/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.manager.forms;

import com.paterva.maltego.entity.manager.forms.NewDisplayDescriptorControl;
import com.paterva.maltego.typing.TypeNameValidator;
import com.paterva.maltego.typing.TypeRegistry;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.dialog.ValidatingController;
import org.openide.WizardDescriptor;

public class NewDisplayDescriptorController
extends ValidatingController<NewDisplayDescriptorControl> {
    public static final String PROP_NAME = "name";
    public static final String PROP_DISPLAY_NAME = "displayName";
    public static final String PROP_TYPE = "type";

    protected NewDisplayDescriptorControl createComponent() {
        NewDisplayDescriptorControl c = new NewDisplayDescriptorControl(TypeRegistry.getDefault().getTypes());
        c.addChangeListener(this.changeListener());
        return c;
    }

    protected String getFirstError(NewDisplayDescriptorControl component) {
        String name = component.getPropertyName();
        String displayName = component.getDisplayName();
        Object type = component.getType();
        if (StringUtilities.isNullOrEmpty((String)name)) {
            return "Name is required";
        }
        String error = TypeNameValidator.checkName((String)name);
        if (error != null) {
            return error;
        }
        if (StringUtilities.isNullOrEmpty((String)displayName)) {
            return "Display name is required";
        }
        if (type == null) {
            return "Type is required";
        }
        return null;
    }

    protected void readSettings(WizardDescriptor settings) {
        ((NewDisplayDescriptorControl)this.component()).setPropertyName((String)settings.getProperty(PROP_NAME));
        ((NewDisplayDescriptorControl)this.component()).setDisplayName((String)settings.getProperty(PROP_DISPLAY_NAME));
    }

    protected void storeSettings(WizardDescriptor settings) {
        settings.putProperty(PROP_TYPE, ((NewDisplayDescriptorControl)this.component()).getType());
        settings.putProperty(PROP_NAME, (Object)((NewDisplayDescriptorControl)this.component()).getPropertyName());
        settings.putProperty(PROP_DISPLAY_NAME, (Object)((NewDisplayDescriptorControl)this.component()).getDisplayName());
    }
}

