/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.java.config.jre.windows;

import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinReg;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.prefs.Preferences;

public class WinRegistry {
    public static final int HKEY_CURRENT_USER = -2147483647;
    public static final int HKEY_LOCAL_MACHINE = -2147483646;
    public static final int REG_SUCCESS = 0;
    public static final int REG_NOTFOUND = 2;
    public static final int REG_ACCESSDENIED = 5;
    public static final int KEY_WOW64_32KEY = 512;
    public static final int KEY_WOW64_64KEY = 256;
    private static final int KEY_READ = 131097;
    private static final Preferences userRoot = Preferences.userRoot();
    private static final Preferences systemRoot = Preferences.systemRoot();
    private static final Class<? extends Preferences> userClass = userRoot.getClass();
    private static Method regOpenKey = null;
    private static Method regCloseKey = null;
    private static Method regQueryValueEx = null;
    private static Method regQueryInfoKey = null;
    private static Method regEnumKeyEx = null;
    private static boolean isBeforeJava11 = true;
    private static boolean useJna = false;

    private WinRegistry() {
    }

    public static String readString(int hkey, String key, String valueName, int wow64) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (useJna) {
            return WinRegistry.readString(hkey, key, valueName);
        }
        if (hkey == -2147483646) {
            return WinRegistry.readString(systemRoot, hkey, key, valueName, wow64);
        }
        if (hkey == -2147483647) {
            return WinRegistry.readString(userRoot, hkey, key, valueName, wow64);
        }
        throw new IllegalArgumentException("hkey=" + hkey);
    }

    private static String readString(int hkey, String key, String valueName) {
        String result = null;
        switch (hkey) {
            case -2147483646: {
                try {
                    result = Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)key, (String)valueName);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return result;
            }
            case -2147483647: {
                try {
                    result = Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)key, (String)valueName);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return result;
            }
        }
        throw new IllegalArgumentException("hkey=" + hkey);
    }

    public static List<String> readStringSubKeys(int hkey, String key, int wow64) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (useJna) {
            return WinRegistry.readStringSubKeys(hkey, key);
        }
        if (hkey == -2147483646) {
            return WinRegistry.readStringSubKeys(systemRoot, hkey, key, wow64);
        }
        if (hkey == -2147483647) {
            return WinRegistry.readStringSubKeys(userRoot, hkey, key, wow64);
        }
        throw new IllegalArgumentException("hkey=" + hkey);
    }

    private static List<String> readStringSubKeys(int hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        ArrayList<String> results = new ArrayList<String>();
        switch (hkey) {
            case -2147483646: {
                try {
                    String[] keys = Advapi32Util.registryGetKeys((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)key);
                    results.addAll(Arrays.asList(keys));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return results;
            }
            case -2147483647: {
                try {
                    String[] keys = Advapi32Util.registryGetKeys((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)key);
                    results.addAll(Arrays.asList(keys));
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        throw new IllegalArgumentException("hkey=" + hkey);
    }

    private static String readString(Preferences root, int hkey, String key, String value, int wow64) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object hkeyValue = WinRegistry.getHKeyValue(hkey);
        long[] handles = WinRegistry.toLongArray(regOpenKey.invoke((Object)root, hkeyValue, WinRegistry.toCstr(key), 0x20019 | wow64));
        if (handles[1] != 0L) {
            return null;
        }
        Object handlesValue1 = WinRegistry.getHandlesValue(handles);
        byte[] valb = (byte[])regQueryValueEx.invoke((Object)root, handlesValue1, WinRegistry.toCstr(value));
        Object handlesValue2 = WinRegistry.getHandlesValue(handles);
        regCloseKey.invoke((Object)root, handlesValue2);
        return valb != null ? new String(valb).trim() : null;
    }

    private static List<String> readStringSubKeys(Preferences root, int hkey, String key, int wow64) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        ArrayList<String> results = new ArrayList<String>();
        Object hkeyValue = WinRegistry.getHKeyValue(hkey);
        long[] handles = WinRegistry.toLongArray(regOpenKey.invoke((Object)root, hkeyValue, WinRegistry.toCstr(key), 0x20019 | wow64));
        if (handles[1] != 0L) {
            return null;
        }
        Object handlesValue1 = WinRegistry.getHandlesValue(handles);
        long[] info = WinRegistry.toLongArray(regQueryInfoKey.invoke((Object)root, handlesValue1));
        int count = (int)info[0];
        int maxlen = (int)info[3];
        for (int index = 0; index < count; ++index) {
            Object handlesValue2 = WinRegistry.getHandlesValue(handles);
            byte[] name = (byte[])regEnumKeyEx.invoke((Object)root, handlesValue2, index, maxlen + 1);
            results.add(new String(name).trim());
        }
        Object handlesValue3 = WinRegistry.getHandlesValue(handles);
        regCloseKey.invoke((Object)root, handlesValue3);
        return results;
    }

    private static Object getHKeyValue(int hkey) {
        Number hkeyValue = null;
        hkeyValue = isBeforeJava11 ? (Number)new Integer(hkey) : (Number)new Long(hkey);
        return hkeyValue;
    }

    private static Object getHandlesValue(long[] handles) {
        Number handlesValue = null;
        handlesValue = isBeforeJava11 ? (Number)new Integer((int)handles[0]) : (Number)new Long(handles[0]);
        return handlesValue;
    }

    private static byte[] toCstr(String str) {
        byte[] result = new byte[str.length() + 1];
        for (int i = 0; i < str.length(); ++i) {
            result[i] = (byte)str.charAt(i);
        }
        result[str.length()] = 0;
        return result;
    }

    private static long[] toLongArray(Object obj) {
        long[] longArr;
        if (Integer.TYPE.equals(obj.getClass().getComponentType())) {
            int[] intArr = (int[])obj;
            longArr = new long[intArr.length];
            for (int i = 0; i < intArr.length; ++i) {
                longArr[i] = intArr[i];
            }
        } else {
            longArr = (long[])obj;
        }
        return longArr;
    }

    public static boolean isDriveHidden(char driveLetter) {
        int noDrivesRegValue = WinRegistry.noDrivesRegValue();
        return WinRegistry.isDriveHidden(driveLetter, noDrivesRegValue);
    }

    public static boolean isDriveHidden(char driveLetter, int noDrivesRegValue) {
        if (noDrivesRegValue > 0) {
            try {
                int driveIndex = Character.toUpperCase(driveLetter) - 65;
                int driveBinValue = 1 << driveIndex;
                return (noDrivesRegValue & driveBinValue) != 0;
            }
            catch (Exception e) {
                System.out.println("Exception when checking drive hidden: drive = " + driveLetter + "; reg value = " + noDrivesRegValue);
                e.printStackTrace();
            }
        }
        return false;
    }

    public static int noDrivesRegValue() {
        try {
            String keyPath = "Software\\Microsoft\\Windows\\CurrentVersion\\Policies\\Explorer";
            String valueName = "NoDrives";
            if (useJna && Advapi32Util.registryValueExists((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)keyPath, (String)valueName)) {
                int noDrivesRegValue = Advapi32Util.registryGetIntValue((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)keyPath, (String)valueName);
                return noDrivesRegValue;
            }
        }
        catch (Exception e) {
            System.out.println("Exception when checking NoDrives reg: use JNA = " + useJna);
            e.printStackTrace();
            return -2;
        }
        System.out.println("Problem when checking NoDrives reg: use JNA = " + useJna);
        return -1;
    }

    static {
        try {
            block8: {
                try {
                    String keyPath = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion";
                    Advapi32Util.registryGetKeys((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)keyPath);
                    String valueName = "ProgramFilesPath";
                    Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)keyPath, (String)valueName);
                }
                catch (Win32Exception exAcceptable) {
                    System.out.println(exAcceptable.getMessage());
                    if (exAcceptable.getMessage().toLowerCase().contains("cannot find")) break block8;
                    throw exAcceptable;
                }
            }
            System.out.println("Using JNA to read the Java registry");
            useJna = true;
        }
        catch (Exception excep) {
            try {
                regOpenKey = userClass.getDeclaredMethod("WindowsRegOpenKey", Integer.TYPE, byte[].class, Integer.TYPE);
                regOpenKey.setAccessible(true);
                regCloseKey = userClass.getDeclaredMethod("WindowsRegCloseKey", Integer.TYPE);
                regCloseKey.setAccessible(true);
                regQueryValueEx = userClass.getDeclaredMethod("WindowsRegQueryValueEx", Integer.TYPE, byte[].class);
                regQueryValueEx.setAccessible(true);
                regQueryInfoKey = userClass.getDeclaredMethod("WindowsRegQueryInfoKey1", Integer.TYPE);
                regQueryInfoKey.setAccessible(true);
                regEnumKeyEx = userClass.getDeclaredMethod("WindowsRegEnumKeyEx", Integer.TYPE, Integer.TYPE, Integer.TYPE);
                regEnumKeyEx.setAccessible(true);
            }
            catch (Exception e) {
                try {
                    regOpenKey = userClass.getDeclaredMethod("WindowsRegOpenKey", Long.TYPE, byte[].class, Integer.TYPE);
                    regOpenKey.setAccessible(true);
                    regCloseKey = userClass.getDeclaredMethod("WindowsRegCloseKey", Long.TYPE);
                    regCloseKey.setAccessible(true);
                    regQueryValueEx = userClass.getDeclaredMethod("WindowsRegQueryValueEx", Long.TYPE, byte[].class);
                    regQueryValueEx.setAccessible(true);
                    regQueryInfoKey = userClass.getDeclaredMethod("WindowsRegQueryInfoKey1", Long.TYPE);
                    regQueryInfoKey.setAccessible(true);
                    regEnumKeyEx = userClass.getDeclaredMethod("WindowsRegEnumKeyEx", Long.TYPE, Integer.TYPE, Integer.TYPE);
                    regEnumKeyEx.setAccessible(true);
                    isBeforeJava11 = false;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

