/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph;

import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.paterva.maltego.ui.graph.GraphView;
import com.paterva.maltego.ui.graph.GraphViewCookie;
import com.paterva.maltego.ui.graph.GraphViewNotificationAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;

public class TopGraphViewRegistry {
    public static final String PROP_TOP_GRAPH_VIEW = "topGraphViewChanged";
    private static TopGraphViewRegistry _default;
    private final PropertyChangeSupport _changeSupport = new PropertyChangeSupport(this);
    private final TopGraphViewListener _listener = new TopGraphViewListener();
    private GraphView _topGraphView;

    public static synchronized TopGraphViewRegistry getDefault() {
        if (_default == null && (_default = (TopGraphViewRegistry)Lookup.getDefault().lookup(TopGraphViewRegistry.class)) == null) {
            _default = new TopGraphViewRegistry();
        }
        return _default;
    }

    protected TopGraphViewRegistry() {
        GraphEditorRegistry.getDefault().addPropertyChangeListener(this._listener);
        GraphViewNotificationAdapter.getDefault().addPropertyChangeListener(this._listener);
    }

    public GraphView getTopGraphView() {
        return this._topGraphView;
    }

    public GraphView getGraphView(TopComponent tc) {
        GraphViewCookie cookie;
        if (tc != null && (cookie = (GraphViewCookie)tc.getLookup().lookup(GraphViewCookie.class)) != null) {
            return cookie.getGraphView();
        }
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.removePropertyChangeListener(listener);
    }

    public void onTopGraphViewChanged(GraphView oldGraphView, GraphView newGraphView) {
        this._topGraphView = newGraphView;
        this._changeSupport.firePropertyChange(PROP_TOP_GRAPH_VIEW, oldGraphView, newGraphView);
    }

    private class TopGraphViewListener
    implements PropertyChangeListener {
        private TopGraphViewListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            switch (evt.getPropertyName()) {
                case "topmost": 
                case "graphLoadingDone": {
                    TopComponent topmost = GraphEditorRegistry.getDefault().getTopmost();
                    GraphView graphView = TopGraphViewRegistry.this.getGraphView(topmost);
                    if (Utilities.compareObjects((Object)TopGraphViewRegistry.this._topGraphView, (Object)graphView)) break;
                    TopGraphViewRegistry.this.onTopGraphViewChanged(TopGraphViewRegistry.this._topGraphView, graphView);
                    break;
                }
            }
        }
    }
}

