/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.actions;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.graph.GraphViewManager;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.imgfactoryapi.GraphIconRegistry;
import com.paterva.maltego.imgfactoryapi.IconRegistry;
import com.paterva.maltego.imgfactoryapi.ImageCache;
import com.paterva.maltego.imgfactoryapi.MemoryIconRegistry;
import com.paterva.maltego.imgfactoryapi.RegistryIcon;
import com.paterva.maltego.ui.graph.actions.Bundle;
import com.paterva.maltego.ui.graph.actions.TopGraphEntitySelectionAction;
import com.paterva.maltego.ui.graph.data.GraphDataUtils;
import com.paterva.maltego.util.FastURL;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.Presenter;
import yguard.A.J.SA;

public class RefreshImagesAction
extends TopGraphEntitySelectionAction
implements Presenter.Menu,
Presenter.Popup {
    public RefreshImagesAction() {
        this.putValue("position", 900);
    }

    @Override
    protected void actionPerformed() {
    }

    public JMenuItem getMenuPresenter() {
        return this.getPopupPresenter();
    }

    public JMenuItem getPopupPresenter() {
        GraphID graphID = this.getTopGraphID();
        JMenu menu = new JMenu(this.getName());
        ClearDownloadedImagesAction downloadedAction = new ClearDownloadedImagesAction(graphID);
        RefreshTypeImagesAction typeAction = new RefreshTypeImagesAction(graphID);
        menu.add(downloadedAction);
        menu.add(typeAction);
        menu.add(new JSeparator());
        menu.add(new AllAction(downloadedAction, typeAction));
        menu.setIcon(new ImageIcon(ImageUtilities.loadImage((String)this.iconResource())));
        return menu;
    }

    public String getName() {
        return Bundle.CTL_RefreshImagesAction();
    }

    @Override
    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected String iconResource() {
        return "com/paterva/maltego/ui/graph/resources/RefreshImages.png";
    }

    private static class AllAction
    extends AbstractAction {
        private final Action[] _actions;

        public AllAction(Action ... actions) {
            super("All");
            this._actions = actions;
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            for (Action action : this._actions) {
                action.actionPerformed(e2);
            }
        }
    }

    private static class RefreshTypeImagesAction
    extends AbstractAction {
        private final GraphID _graphID;

        public RefreshTypeImagesAction(GraphID graphID) {
            super("Type images (whole graph)");
            this._graphID = graphID;
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            new Thread(() -> {
                IconRegistry defaultRegistry = IconRegistry.getDefault();
                IconRegistry graphIconReg = IconRegistry.forGraphID((GraphID)this._graphID);
                if (graphIconReg instanceof GraphIconRegistry) {
                    MemoryIconRegistry memIconReg = ((GraphIconRegistry)graphIconReg).getMemoryIconRegistry();
                    if (memIconReg != null) {
                        for (RegistryIcon icon : memIconReg.getIcons()) {
                            if (!defaultRegistry.contains(icon)) continue;
                            try {
                                Map images = defaultRegistry.loadImages(icon);
                                memIconReg.addFromImages(icon.getCategory(), icon.getName(), images);
                            }
                            catch (IOException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    }
                    ImageCache.getDefault().resetFailedImages();
                }
                SwingUtilities.invokeLater(() -> {
                    SA viewGraph = GraphViewManager.getDefault().getViewGraph(this._graphID);
                    viewGraph.\u0107();
                    GraphDataUtils.getGraphDataObject(this._graphID).setModified(true);
                });
            }, "Refresh Type Images Action").start();
        }
    }

    private class ClearDownloadedImagesAction
    extends AbstractAction {
        private final GraphID _graphID;

        public ClearDownloadedImagesAction(GraphID graphID) {
            super("Downloaded images");
            this._graphID = graphID;
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            ImageCache cache = ImageCache.getDefault();
            Set<FastURL> images = this.getImagesToRefresh(cache);
            for (FastURL image : images) {
                cache.remove((Object)image);
            }
            cache.resetFailedImages();
        }

        private Set<FastURL> getImagesToRefresh(ImageCache cache) {
            HashSet<FastURL> urls = new HashSet<FastURL>();
            EntityRegistry registry = EntityRegistry.forGraphID((GraphID)this._graphID);
            Set<EntityID> entityIDs = RefreshImagesAction.this.getSelectedModelEntities();
            Set entities = GraphStoreHelper.getMaltegoEntities((GraphID)this._graphID, entityIDs);
            for (MaltegoEntity entity : entities) {
                Object image = InheritanceHelper.getImageKey((EntityRegistry)registry, (MaltegoEntity)entity).orElse(null);
                if (!(image instanceof FastURL) || !cache.contains(image)) continue;
                urls.add(image);
            }
            return urls;
        }
    }
}

