/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.impl;

import com.paterva.maltego.graph.PageRankProvider;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.event.ChangeListener;
import org.openide.util.ChangeSupport;
import yguard.A.A.C;
import yguard.A.A.D;
import yguard.A.A.E;
import yguard.A.A.I;
import yguard.A.A.K;
import yguard.A.A.Y;
import yguard.A.A._;

public class DefaultPageRankProvider
extends PageRankProvider {
    private static final String PAGE_RANK_PROVIDER_KEY = "maltego.PageRank";
    private static final double DAMPENING = 0.85;
    private Map<D, ChangeSupport> _changeSupport = new WeakHashMap<D, ChangeSupport>();
    private Set<D> _updatingGraphs = new HashSet<D>();
    private Set<D> _modifiedGraphs = new HashSet<D>();

    public double get(Y node) {
        D graph = node.H();
        I pageRankMap = this.getPageRankMap(graph);
        this.lazyUpdate(graph, pageRankMap);
        return pageRankMap.getDouble((Object)node);
    }

    protected synchronized I getPageRankMap(D graph) {
        I pageRanks = (I)graph.B((Object)PAGE_RANK_PROVIDER_KEY);
        if (pageRanks == null) {
            pageRanks = graph.\u00ba();
            graph.A((Object)PAGE_RANK_PROVIDER_KEY, (K)pageRanks);
            this.initPageRanks(graph, pageRanks);
            this.updatePageRanks(graph, pageRanks);
            graph.A((_)new EdgeGraphListener(graph));
        }
        return pageRanks;
    }

    private void initPageRanks(D graph, I pageRanks) {
        E nodes = graph.\u00a4();
        while (nodes.ok()) {
            Y node = nodes.B();
            pageRanks.setDouble((Object)node, 1.0 / (double)graph.\u00ca());
            nodes.next();
        }
    }

    private void lazyUpdate(D graph, I pageRankMap) {
        if (this._modifiedGraphs.contains(graph)) {
            this.updatePageRanks(graph, pageRankMap);
            this._modifiedGraphs.remove(graph);
        }
    }

    protected void updatePageRanks(D graph) {
        this.updatePageRanks(graph, this.getPageRankMap(graph));
    }

    protected void updatePageRanks(D graph, I pageRanks) {
        this.updatePageRanks(graph, pageRanks, 50);
    }

    protected void updatePageRanks(D graph, I pageRanks, int maxIterations) {
        if (this._updatingGraphs.contains(graph)) {
            return;
        }
        this._updatingGraphs.add(graph);
        double aux = 0.15000000000000002;
        boolean change = true;
        while (maxIterations-- > 0 && change) {
            change = false;
            I tempPageRanks = this.clonePageRanks(graph, pageRanks);
            E nodes = graph.\u00a4();
            while (nodes.ok()) {
                Y node = nodes.B();
                E predecessors = node.F();
                double rank = 0.0;
                while (predecessors.ok()) {
                    Y predecessor = predecessors.B();
                    int numLink = predecessor.C();
                    rank += pageRanks.getDouble((Object)predecessor) / (double)numLink;
                    predecessors.next();
                }
                rank = aux + 0.85 * rank;
                tempPageRanks.setDouble((Object)node, rank);
                if (Math.abs(rank - pageRanks.getDouble((Object)node)) > 0.001) {
                    change = true;
                }
                nodes.next();
            }
            this.copyPageRanks(graph, tempPageRanks, pageRanks);
            graph.A(tempPageRanks);
        }
        this._modifiedGraphs.remove(graph);
        this._updatingGraphs.remove(graph);
    }

    private I clonePageRanks(D graph, I pageRanks) {
        I cloned = graph.\u00ba();
        this.copyPageRanks(graph, pageRanks, cloned);
        return cloned;
    }

    private void copyPageRanks(D graph, I src, I dest) {
        E nodes = graph.\u00a4();
        while (nodes.ok()) {
            Y node = nodes.B();
            dest.setDouble((Object)node, src.getDouble((Object)node));
            nodes.next();
        }
    }

    public void addChangeListener(D graph, ChangeListener listener) {
        this.getChangeSupport(graph).addChangeListener(listener);
    }

    public void removeChangeListener(D graph, ChangeListener listener) {
        this.getChangeSupport(graph).removeChangeListener(listener);
    }

    private synchronized ChangeSupport getChangeSupport(D graph) {
        ChangeSupport support = this._changeSupport.get(graph);
        if (support == null) {
            support = new ChangeSupport((Object)this);
            this._changeSupport.put(graph, support);
        }
        return support;
    }

    private class EdgeGraphListener
    implements _ {
        private D _graph;
        private int _block = 0;
        private boolean _changed = false;

        public EdgeGraphListener(D graph) {
            this._graph = graph;
        }

        public void onGraphEvent(C ge) {
            switch (ge.C()) {
                case 12: {
                    ++this._block;
                    break;
                }
                case 13: {
                    --this._block;
                    this._block = Math.max(this._block, 0);
                    break;
                }
                case 1: 
                case 5: {
                    this._changed = true;
                }
            }
            if (this._block == 0 && this._changed) {
                DefaultPageRankProvider.this._modifiedGraphs.add(this._graph);
                this._changed = false;
                DefaultPageRankProvider.this.getChangeSupport(this._graph).fireChange();
            }
        }
    }
}

