/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.metadata;

import com.paterva.maltego.archive.mtz.Entry;
import com.paterva.maltego.graph.metadata.GraphMetadata;
import com.paterva.maltego.typing.types.DateTime;
import com.paterva.maltego.ui.graph.metadata.GraphMetadataImpl;
import com.paterva.maltego.util.StringUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Properties;

public class GraphMetadataEntry
extends Entry<GraphMetadata> {
    public static final String DefaultFolder = "Graphs";
    public static final String Type = "properties";

    public GraphMetadataEntry(GraphMetadata metadata, String graphName) {
        super((Object)metadata, DefaultFolder, graphName + "." + Type, graphName + " properties");
    }

    public GraphMetadataEntry(String graphName) {
        super("Graphs/" + graphName + "." + Type);
    }

    public GraphMetadata read(InputStream is) throws IOException {
        Properties properties = new Properties();
        properties.load(is);
        GraphMetadataImpl metadata = new GraphMetadataImpl();
        metadata.setAuthor(properties.getProperty("author", ""));
        metadata.setCreated(this.fromString(properties.getProperty("created", null)));
        metadata.setModified(this.fromString(properties.getProperty("modified", null)));
        return metadata;
    }

    public void write(GraphMetadata data, OutputStream os) throws IOException {
        Properties properties = new Properties();
        this.addProperty(properties, "author", data.getAuthor());
        this.addProperty(properties, "created", this.toString(data.getCreated()));
        this.addProperty(properties, "modified", this.toString(data.getModified()));
        properties.store(os, "");
    }

    private String toString(Date date) {
        return date != null ? new DateTime(date).toString() : null;
    }

    private Date fromString(String str) {
        Date date = null;
        if (!StringUtilities.isNullOrEmpty((String)str)) {
            date = DateTime.parse((String)str).getDate();
        }
        return date;
    }

    private void addProperty(Properties properties, String property, String value) {
        if (value != null) {
            properties.setProperty(property, value);
        }
    }
}

