// stun_params.h
//
// this file was autogenerated at 2022-10-20T01:09:04Z
// you should edit the source file(s) instead of this one
//
// source files:
//     stun-parameters-2.csv
//     local-stun-attributes.csv,stun-parameters-4.csv
//     stun-parameters-6.csv
//     stun-security-features.csv
//     stun-password-algorithm.csv
//

#ifndef STUN_PARAMS_H
#define STUN_PARAMS_H

template <typename T>
class method : public encoded<T> {
    static_assert(std::is_unsigned_v<T>, "T must be an unsigned integer");
public:
    void write_json(json_object &o) const {
        const char *name = get_name();
        if (name == nullptr) {
            o.print_key_unknown_code("method", encoded<T>::value());
        } else {
            o.print_key_string("method", name);
        }
    }
    enum code {
        Binding           = 0x001,
        SharedSecret      = 0x002,
        Allocate          = 0x003,
        Refresh           = 0x004,
        Send              = 0x006,
        Data              = 0x007,
        CreatePermission  = 0x008,
        ChannelBind       = 0x009,
        Connect           = 0x00A,
        ConnectionBind    = 0x00B,
        ConnectionAttempt = 0x00C,
        GOOG_PING         = 0x080,
    };
    const char *get_name() const {
        switch(encoded<T>::value()) {
        case Binding:           return "Binding";
        case SharedSecret:      return "SharedSecret";
        case Allocate:          return "Allocate";
        case Refresh:           return "Refresh";
        case Send:              return "Send";
        case Data:              return "Data";
        case CreatePermission:  return "CreatePermission";
        case ChannelBind:       return "ChannelBind";
        case Connect:           return "Connect";
        case ConnectionBind:    return "ConnectionBind";
        case ConnectionAttempt: return "ConnectionAttempt";
        case GOOG_PING:         return "GOOG_PING";
        default:
            ;
        }
        return nullptr;
    }
};

template <typename T>
class attribute_type : public encoded<T> {
    static_assert(std::is_unsigned_v<T>, "T must be an unsigned integer");
public:
    void write_json(json_object &o) const {
        const char *name = get_name();
        if (name == nullptr) {
            o.print_key_unknown_code("type", encoded<T>::value());
        } else {
            o.print_key_string("type", name);
        }
    }
    enum code {
        MAPPED_ADDRESS                         = 0x0001,
        RESPONSE_ADDRESS                       = 0x0002,
        SOURCE_ADDRESS                         = 0x0004,
        CHANGED_ADDRESS                        = 0x0005,
        USERNAME                               = 0x0006,
        MESSAGE_INTEGRITY                      = 0x0008,
        ERROR_CODE                             = 0x0009,
        UNKNOWN_ATTRIBUTES                     = 0x000A,
        REFLECTED_FROM                         = 0x000B,
        CHANNEL_NUMBER                         = 0x000C,
        LIFETIME                               = 0x000D,
        BANDWIDTH                              = 0x0010,
        XOR_PEER_ADDRESS                       = 0x0012,
        DATA                                   = 0x0013,
        REALM                                  = 0x0014,
        NONCE                                  = 0x0015,
        XOR_RELAYED_ADDRESS                    = 0x0016,
        REQUESTED_ADDRESS_FAMILY               = 0x0017,
        EVEN_PORT                              = 0x0018,
        REQUESTED_TRANSPORT                    = 0x0019,
        DONT_FRAGMENT                          = 0x001A,
        ACCESS_TOKEN                           = 0x001B,
        MESSAGE_INTEGRITY_SHA256               = 0x001C,
        PASSWORD_ALGORITHM                     = 0x001D,
        USERHASH                               = 0x001E,
        XOR_MAPPED_ADDRESS                     = 0x0020,
        RESERVATION_TOKEN                      = 0x0022,
        PRIORITY                               = 0x0024,
        USE_CANDIDATE                          = 0x0025,
        PADDING                                = 0x0026,
        RESPONSE_PORT                          = 0x0027,
        CONNECTION_ID                          = 0x002A,
        ADDITIONAL_ADDRESS_FAMILY              = 0x8000,
        ADDRESS_ERROR_CODE                     = 0x8001,
        PASSWORD_ALGORITHMS                    = 0x8002,
        ALTERNATE_DOMAIN                       = 0x8003,
        ICMP                                   = 0x8004,
        MS_VERSION                             = 0x8008,
        MS_XOR_MAPPED_ADDRESS                  = 0x8020,
        SOFTWARE                               = 0x8022,
        ALTERNATE_SERVER                       = 0x8023,
        TRANSACTION_TRANSMIT_COUNTER           = 0x8025,
        CACHE_TIMEOUT                          = 0x8027,
        FINGERPRINT                            = 0x8028,
        ICE_CONTROLLED                         = 0x8029,
        ICE_CONTROLLING                        = 0x802A,
        RESPONSE_ORIGIN                        = 0x802B,
        OTHER_ADDRESS                          = 0x802C,
        ECN_CHECK_STUN                         = 0x802D,
        THIRD_PARTY_AUTHORIZATION              = 0x802E,
        MOBILITY_TICKET                        = 0x8030,
        MS_ALTERNATE_HOST_NAME                 = 0x8032,
        MS_APP_ID                              = 0x8037,
        MS_SECURE_TAG                          = 0x8039,
        MS_SEQUENCE_NUMBER                     = 0x8050,
        MS_SERVICE_QUALITY                     = 0x8055,
        MS_BANDWIDTH_ADMISSION_CONTROL_MESSAGE = 0x8056,
        MS_IMPLEMENTATION_VERSION              = 0x8070,
        MS_ALTERNATE_MAPPED_ADDRESS            = 0x8090,
        MS_MULTIPLEXED_TURN_SESSION_ID         = 0x8095,
        CISCO_STUN_FLOWDATA                    = 0xC000,
        ENF_FLOW_DESCRIPTION                   = 0xC001,
        ENF_NETWORK_STATUS                     = 0xC002,
        GOOG_NETWORK_INFO                      = 0xC057,
        GOOG_LAST_ICE_CHECK_RECEIVED           = 0xC058,
        GOOG_MISC_INFO                         = 0xC059,
        GOOG_OBSOLETE_1                        = 0xC05A,
        GOOG_CONNECTION_ID                     = 0xC05B,
        GOOG_DELTA                             = 0xC05C,
        GOOG_DELTA_ACK                         = 0xC05D,
        GOOG_MESSAGE_INTEGRITY_32              = 0xC060,
    };
    const char *get_name() const {
        switch(encoded<T>::value()) {
        case MAPPED_ADDRESS:                         return "MAPPED_ADDRESS";
        case RESPONSE_ADDRESS:                       return "RESPONSE_ADDRESS";
        case SOURCE_ADDRESS:                         return "SOURCE_ADDRESS";
        case CHANGED_ADDRESS:                        return "CHANGED_ADDRESS";
        case USERNAME:                               return "USERNAME";
        case MESSAGE_INTEGRITY:                      return "MESSAGE_INTEGRITY";
        case ERROR_CODE:                             return "ERROR_CODE";
        case UNKNOWN_ATTRIBUTES:                     return "UNKNOWN_ATTRIBUTES";
        case REFLECTED_FROM:                         return "REFLECTED_FROM";
        case CHANNEL_NUMBER:                         return "CHANNEL_NUMBER";
        case LIFETIME:                               return "LIFETIME";
        case BANDWIDTH:                              return "BANDWIDTH";
        case XOR_PEER_ADDRESS:                       return "XOR_PEER_ADDRESS";
        case DATA:                                   return "DATA";
        case REALM:                                  return "REALM";
        case NONCE:                                  return "NONCE";
        case XOR_RELAYED_ADDRESS:                    return "XOR_RELAYED_ADDRESS";
        case REQUESTED_ADDRESS_FAMILY:               return "REQUESTED_ADDRESS_FAMILY";
        case EVEN_PORT:                              return "EVEN_PORT";
        case REQUESTED_TRANSPORT:                    return "REQUESTED_TRANSPORT";
        case DONT_FRAGMENT:                          return "DONT_FRAGMENT";
        case ACCESS_TOKEN:                           return "ACCESS_TOKEN";
        case MESSAGE_INTEGRITY_SHA256:               return "MESSAGE_INTEGRITY_SHA256";
        case PASSWORD_ALGORITHM:                     return "PASSWORD_ALGORITHM";
        case USERHASH:                               return "USERHASH";
        case XOR_MAPPED_ADDRESS:                     return "XOR_MAPPED_ADDRESS";
        case RESERVATION_TOKEN:                      return "RESERVATION_TOKEN";
        case PRIORITY:                               return "PRIORITY";
        case USE_CANDIDATE:                          return "USE_CANDIDATE";
        case PADDING:                                return "PADDING";
        case RESPONSE_PORT:                          return "RESPONSE_PORT";
        case CONNECTION_ID:                          return "CONNECTION_ID";
        case ADDITIONAL_ADDRESS_FAMILY:              return "ADDITIONAL_ADDRESS_FAMILY";
        case ADDRESS_ERROR_CODE:                     return "ADDRESS_ERROR_CODE";
        case PASSWORD_ALGORITHMS:                    return "PASSWORD_ALGORITHMS";
        case ALTERNATE_DOMAIN:                       return "ALTERNATE_DOMAIN";
        case ICMP:                                   return "ICMP";
        case MS_VERSION:                             return "MS_VERSION";
        case MS_XOR_MAPPED_ADDRESS:                  return "MS_XOR_MAPPED_ADDRESS";
        case SOFTWARE:                               return "SOFTWARE";
        case ALTERNATE_SERVER:                       return "ALTERNATE_SERVER";
        case TRANSACTION_TRANSMIT_COUNTER:           return "TRANSACTION_TRANSMIT_COUNTER";
        case CACHE_TIMEOUT:                          return "CACHE_TIMEOUT";
        case FINGERPRINT:                            return "FINGERPRINT";
        case ICE_CONTROLLED:                         return "ICE_CONTROLLED";
        case ICE_CONTROLLING:                        return "ICE_CONTROLLING";
        case RESPONSE_ORIGIN:                        return "RESPONSE_ORIGIN";
        case OTHER_ADDRESS:                          return "OTHER_ADDRESS";
        case ECN_CHECK_STUN:                         return "ECN_CHECK_STUN";
        case THIRD_PARTY_AUTHORIZATION:              return "THIRD_PARTY_AUTHORIZATION";
        case MOBILITY_TICKET:                        return "MOBILITY_TICKET";
        case MS_ALTERNATE_HOST_NAME:                 return "MS_ALTERNATE_HOST_NAME";
        case MS_APP_ID:                              return "MS_APP_ID";
        case MS_SECURE_TAG:                          return "MS_SECURE_TAG";
        case MS_SEQUENCE_NUMBER:                     return "MS_SEQUENCE_NUMBER";
        case MS_SERVICE_QUALITY:                     return "MS_SERVICE_QUALITY";
        case MS_BANDWIDTH_ADMISSION_CONTROL_MESSAGE: return "MS_BANDWIDTH_ADMISSION_CONTROL_MESSAGE";
        case MS_IMPLEMENTATION_VERSION:              return "MS_IMPLEMENTATION_VERSION";
        case MS_ALTERNATE_MAPPED_ADDRESS:            return "MS_ALTERNATE_MAPPED_ADDRESS";
        case MS_MULTIPLEXED_TURN_SESSION_ID:         return "MS_MULTIPLEXED_TURN_SESSION_ID";
        case CISCO_STUN_FLOWDATA:                    return "CISCO_STUN_FLOWDATA";
        case ENF_FLOW_DESCRIPTION:                   return "ENF_FLOW_DESCRIPTION";
        case ENF_NETWORK_STATUS:                     return "ENF_NETWORK_STATUS";
        case GOOG_NETWORK_INFO:                      return "GOOG_NETWORK_INFO";
        case GOOG_LAST_ICE_CHECK_RECEIVED:           return "GOOG_LAST_ICE_CHECK_RECEIVED";
        case GOOG_MISC_INFO:                         return "GOOG_MISC_INFO";
        case GOOG_OBSOLETE_1:                        return "GOOG_OBSOLETE_1";
        case GOOG_CONNECTION_ID:                     return "GOOG_CONNECTION_ID";
        case GOOG_DELTA:                             return "GOOG_DELTA";
        case GOOG_DELTA_ACK:                         return "GOOG_DELTA_ACK";
        case GOOG_MESSAGE_INTEGRITY_32:              return "GOOG_MESSAGE_INTEGRITY_32";
        default:
            ;
        }
        return nullptr;
    }
};

template <typename T>
class error_codes : public encoded<T> {
    static_assert(std::is_unsigned_v<T>, "T must be an unsigned integer");
public:
    void write_json(json_object &o) const {
        const char *name = get_name();
        if (name == nullptr) {
            o.print_key_unknown_code("error_codes", encoded<T>::value());
        } else {
            o.print_key_string("error_codes", name);
        }
    }
    enum code {
        Try_Alternate                  = 300,
        Bad_Request                    = 400,
        Unauthenticated                = 401,
        Forbidden                      = 403,
        Mobility_Forbidden             = 405,
        Unknown_Attribute              = 420,
        Allocation_Mismatch            = 437,
        Stale_Nonce                    = 438,
        Address_Family_not_Supported   = 440,
        Wrong_Credentials              = 441,
        Unsupported_Transport_Protocol = 442,
        Peer_Address_Family_Mismatch   = 443,
        Connection_Already_Exists      = 446,
        Connection_Timeout_or_Failure  = 447,
        Allocation_Quota_Reached       = 486,
        Role_Conflict                  = 487,
        Server_Error                   = 500,
        Insufficient_Capacity          = 508,
    };
    const char *get_name() const {
        switch(encoded<T>::value()) {
        case Try_Alternate:                  return "Try_Alternate";
        case Bad_Request:                    return "Bad_Request";
        case Unauthenticated:                return "Unauthenticated";
        case Forbidden:                      return "Forbidden";
        case Mobility_Forbidden:             return "Mobility_Forbidden";
        case Unknown_Attribute:              return "Unknown_Attribute";
        case Allocation_Mismatch:            return "Allocation_Mismatch";
        case Stale_Nonce:                    return "Stale_Nonce";
        case Address_Family_not_Supported:   return "Address_Family_not_Supported";
        case Wrong_Credentials:              return "Wrong_Credentials";
        case Unsupported_Transport_Protocol: return "Unsupported_Transport_Protocol";
        case Peer_Address_Family_Mismatch:   return "Peer_Address_Family_Mismatch";
        case Connection_Already_Exists:      return "Connection_Already_Exists";
        case Connection_Timeout_or_Failure:  return "Connection_Timeout_or_Failure";
        case Allocation_Quota_Reached:       return "Allocation_Quota_Reached";
        case Role_Conflict:                  return "Role_Conflict";
        case Server_Error:                   return "Server_Error";
        case Insufficient_Capacity:          return "Insufficient_Capacity";
        default:
            ;
        }
        return nullptr;
    }
};

template <typename T>
class security_features : public encoded<T> {
    static_assert(std::is_unsigned_v<T>, "T must be an unsigned integer");
public:
    void write_json(json_object &o) const {
        const char *name = get_name();
        if (name == nullptr) {
            o.print_key_unknown_code("security_features", encoded<T>::value());
        } else {
            o.print_key_string("security_features", name);
        }
    }
    enum code {
        Password_algorithms = 0,
        Username_anonymity  = 1,
    };
    const char *get_name() const {
        switch(encoded<T>::value()) {
        case Password_algorithms: return "Password_algorithms";
        case Username_anonymity:  return "Username_anonymity";
        default:
            ;
        }
        return nullptr;
    }
};

template <typename T>
class password_algorithms : public encoded<T> {
    static_assert(std::is_unsigned_v<T>, "T must be an unsigned integer");
public:
    void write_json(json_object &o) const {
        const char *name = get_name();
        if (name == nullptr) {
            o.print_key_unknown_code("password_algorithms", encoded<T>::value());
        } else {
            o.print_key_string("password_algorithms", name);
        }
    }
    enum code {
        MD5     = 0x0001,
        SHA_256 = 0x0002,
    };
    const char *get_name() const {
        switch(encoded<T>::value()) {
        case MD5:     return "MD5";
        case SHA_256: return "SHA_256";
        default:
            ;
        }
        return nullptr;
    }
};


#endif // STUN_PARAMS_H

