/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Objects;
import org.apache.commons.io.FileExistsException;
import org.apache.commons.io.file.Counters$AbstractPathCounters;
import org.apache.commons.io.file.Counters$LongCounter;
import org.apache.commons.io.file.Counters$LongPathCounters;
import org.apache.commons.io.file.DeleteOption;
import org.apache.commons.io.file.DeletingPathVisitor;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.file.StandardDeleteOption;
import org.apache.commons.io.function.IOConsumer;
import org.apache.commons.io.function.IOStreams;

public abstract class FileUtils {
    public static void checkFileExists(File file, String string) {
        if (!file.isFile()) {
            if (!file.exists()) {
                if (!Files.isSymbolicLink(file.toPath())) {
                    throw new FileNotFoundException("Source '" + file + "' does not exist");
                }
            } else {
                throw new IllegalArgumentException("Parameter '" + string + "' is not a file: " + file);
            }
        }
    }

    public static void cleanDirectory(File file) {
        IOConsumer iOConsumer = FileUtils::forceDelete;
        if (!file.isDirectory()) {
            if (file.exists()) {
                throw new IllegalArgumentException("Parameter 'directory' is not a directory: '" + file + "'");
            }
            throw new FileNotFoundException("Directory '" + file + "' does not exist.");
        }
        Object[] objectArray = file.listFiles();
        if (objectArray != null) {
            IOStreams.forAll(IOStreams.of(objectArray), iOConsumer);
            return;
        }
        throw new IOException("Unknown I/O error listing contents of directory: " + file);
    }

    public static void copyFile(File copyOptionArray, File file) {
        CopyOption[] copyOptionArray2 = copyOptionArray;
        CopyOption[] copyOptionArray3 = new CopyOption[1];
        copyOptionArray = copyOptionArray3;
        copyOptionArray3[0] = StandardCopyOption.REPLACE_EXISTING;
        FileUtils.copyFile((File)copyOptionArray2, file, true, copyOptionArray);
    }

    public static void copyFile(File file, File file2, boolean bl, CopyOption ... object) {
        File file3 = file;
        FileUtils.checkFileExists(file3, "srcFile");
        Object object2 = file3.getCanonicalPath();
        if (!((String)object2).equals(file2.getCanonicalPath())) {
            object2 = file2.getParentFile();
            if (object2 != null && !((File)object2).mkdirs() && !((File)object2).isDirectory()) {
                throw new IOException("Cannot create directory '" + object2 + "'.");
            }
            if (file2.exists()) {
                FileUtils.checkFileExists(file2, "destFile");
            }
            Object object3 = file.toPath();
            Files.copy((Path)object3, file2.toPath(), object);
            if (bl && !Files.isSymbolicLink((Path)object3)) {
                boolean bl2;
                File file4 = file2;
                object3 = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                BasicFileAttributeView basicFileAttributeView = Files.getFileAttributeView(file4.toPath(), BasicFileAttributeView.class, new LinkOption[0]);
                Object object4 = object3;
                Object object5 = object4;
                Object object6 = object4;
                object3 = object4.lastModifiedTime();
                object = object6.lastAccessTime();
                object2 = object5.creationTime();
                try {
                    basicFileAttributeView.setTimes((FileTime)object3, (FileTime)object, (FileTime)object2);
                    bl2 = true;
                }
                catch (IOException iOException) {
                    bl2 = file2.setLastModified(file.lastModified());
                }
                if (!bl2) {
                    throw new IOException("Cannot set the file time.");
                }
            }
            return;
        }
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray[0] = object2;
        objectArray[1] = file;
        objectArray[2] = file2;
        throw new IllegalArgumentException(String.format("File canonical paths are equal: '%s' (file1='%s', file2='%s')", objectArray2));
    }

    public static void forceDelete(File file) {
        Object object;
        block13: {
            DeleteOption[] deleteOptionArray;
            LinkOption[] linkOptionArray;
            block12: {
                Counters$LongPathCounters counters$LongPathCounters;
                DeletingPathVisitor deletingPathVisitor;
                File file2 = file;
                Objects.requireNonNull(file2, "file");
                try {
                    object = file2.toPath();
                }
                catch (IOException iOException) {
                    throw new IOException("Cannot delete file: " + file, iOException);
                }
                linkOptionArray = PathUtils.EMPTY_LINK_OPTION_ARRAY;
                DeleteOption[] deleteOptionArray2 = new DeleteOption[1];
                deleteOptionArray = deleteOptionArray2;
                deleteOptionArray2[0] = StandardDeleteOption.OVERRIDE_READ_ONLY;
                if (!Files.isDirectory((Path)object, PathUtils.EMPTY_LINK_OPTION_ARRAY)) break block12;
                DeletingPathVisitor deletingPathVisitor2 = deletingPathVisitor;
                Path path = object;
                DeletingPathVisitor deletingPathVisitor3 = deletingPathVisitor2;
                object = counters$LongPathCounters;
                counters$LongPathCounters = new Counters$LongPathCounters();
                String[] stringArray = new String[]{};
                deletingPathVisitor3((Counters$LongPathCounters)object, linkOptionArray, deleteOptionArray, stringArray);
                Files.walkFileTree(path, deletingPathVisitor2);
                object = deletingPathVisitor.pathCounters;
                break block13;
            }
            object = PathUtils.deleteFile((Path)object, linkOptionArray, deleteOptionArray);
        }
        object = (Counters$AbstractPathCounters)object;
        if (((Counters$LongCounter)((Counters$AbstractPathCounters)object).fileCounter).value < 1L && ((Counters$LongCounter)((Counters$AbstractPathCounters)object).directoryCounter).value < 1L) {
            throw new FileNotFoundException("File does not exist: " + file);
        }
    }

    public static void moveFile(File objectArray, File file) {
        block6: {
            block7: {
                block5: {
                    CopyOption[] copyOptionArray = new CopyOption[1];
                    CopyOption[] copyOptionArray2 = copyOptionArray;
                    copyOptionArray[0] = StandardCopyOption.COPY_ATTRIBUTES;
                    FileUtils.checkFileExists((File)objectArray, "srcFile");
                    if (file.exists()) break block6;
                    if (objectArray.renameTo(file)) break block7;
                    FileUtils.copyFile((File)objectArray, file, false, copyOptionArray2);
                    if (objectArray.delete()) break block7;
                    try {
                        if (!file.isDirectory()) break block5;
                    }
                    catch (Exception exception) {}
                    FileUtils.cleanDirectory(file);
                }
                try {
                    file.delete();
                }
                catch (Exception exception) {}
                throw new IOException("Failed to delete original file '" + objectArray + "' after copy to '" + file + "'");
            }
            return;
        }
        Object[] objectArray2 = new Object[2];
        objectArray = objectArray2;
        objectArray2[0] = "destFile";
        objectArray2[1] = file;
        throw new FileExistsException(String.format("File element in parameter '%s' already exists: '%s'", objectArray));
    }

    static {
        BigInteger bigInteger = BigInteger.valueOf(1024L);
        bigInteger.multiply(bigInteger.multiply(bigInteger.multiply(bigInteger.multiply(bigInteger.multiply(bigInteger)))));
        bigInteger.multiply(BigInteger.valueOf(1024L).multiply(BigInteger.valueOf(0x1000000000000000L)));
    }
}

