/*
 * Decompiled with CFR 0.152.
 */
package lt.neworld.vd2svg.processor;

import com.xenomachina.argparser.SystemExitException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.file.PathMatcher;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import lt.neworld.vd2svg.LoggerKt;
import lt.neworld.vd2svg.converter.Converter;
import lt.neworld.vd2svg.processor.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\bH\u0002J\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\u0006\u0010\u0014\u001a\u00020\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Llt/neworld/vd2svg/processor/Processor;", "", "converter", "Llt/neworld/vd2svg/converter/Converter;", "input", "", "Ljava/nio/file/PathMatcher;", "output", "Ljava/io/File;", "(Llt/neworld/vd2svg/converter/Converter;Ljava/util/List;Ljava/io/File;)V", "getConverter", "()Llt/neworld/vd2svg/converter/Converter;", "getInput", "()Ljava/util/List;", "getOutput", "()Ljava/io/File;", "createOutputStream", "Ljava/io/OutputStream;", "prepareOutput", "", "process", "vd2svg"})
public final class Processor {
    @NotNull
    private final Converter converter;
    @NotNull
    private final List<PathMatcher> input;
    @Nullable
    private final File output;

    public final void process() {
        this.prepareOutput(this.output);
        Sequence $receiver$iv = SequencesKt.filter(SequencesKt.filter(FilesKt.walkTopDown(new File(".")), (Function1)new Function1<File, Boolean>(this){
            final /* synthetic */ Processor this$0;

            public final boolean invoke(@NotNull File file) {
                boolean bl;
                block3: {
                    Intrinsics.checkParameterIsNotNull(file, "file");
                    Iterable $receiver$iv = this.this$0.getInput();
                    if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $receiver$iv) {
                            PathMatcher it = (PathMatcher)element$iv;
                            if (!it.matches(FilesKt.relativeTo(file, new File(".")).toPath())) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl;
            }
            {
                this.this$0 = processor;
                super(1);
            }
        }), process.2.INSTANCE);
        Iterator iterator2 = $receiver$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            File file = (File)element$iv;
            LoggerKt.logProgress("Processing: " + file);
            OutputStream outputStream = this.createOutputStream(file);
            File file2 = file;
            Converter converter = this.converter;
            FileInputStream fileInputStream = new FileInputStream(file2);
            converter.convert(fileInputStream, outputStream);
            outputStream.close();
        }
    }

    private final OutputStream createOutputStream(File input2) {
        String filename = FilesKt.getNameWithoutExtension(input2);
        File file = this.output;
        if (file == null) {
            file = input2.getParentFile();
        }
        File outputDir = file;
        File fileOutput = new File(outputDir, filename + ".svg");
        LoggerKt.logProgress("Save to: " + fileOutput);
        return new FileOutputStream(fileOutput);
    }

    private final void prepareOutput(File output2) {
        if (output2 == null) {
            return;
        }
        if (output2.isFile()) {
            throw (Throwable)new SystemExitException("output is not directory", 1);
        }
        if (!output2.exists()) {
            LoggerKt.logProgress("Creating output dir: " + output2.getPath());
            if (!output2.mkdirs()) {
                throw (Throwable)new SystemExitException("Failed create output dir", 1);
            }
        }
    }

    @NotNull
    public final Converter getConverter() {
        return this.converter;
    }

    @NotNull
    public final List<PathMatcher> getInput() {
        return this.input;
    }

    @Nullable
    public final File getOutput() {
        return this.output;
    }

    public Processor(@NotNull Converter converter, @NotNull List<? extends PathMatcher> input2, @Nullable File output2) {
        Intrinsics.checkParameterIsNotNull(converter, "converter");
        Intrinsics.checkParameterIsNotNull(input2, "input");
        this.converter = converter;
        this.input = input2;
        this.output = output2;
    }
}

