/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import com.android.SdkConstants;
import com.android.utils.TokenizedCommandLineKt;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u000b\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0015\n\u0002\u0010 \n\u0002\b\u0006\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002J\u0017\u0010\u0017\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0018\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u0006\u0010\u001c\u001a\u00020\u0007J\b\u0010\u001d\u001a\u00020\u001bH\u0002J\u0010\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J\u0010\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J\u0010\u0010 \u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J\u0010\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0007H\u0007J\u000e\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u0003J\u0006\u0010%\u001a\u00020\u0007J\u0010\u0010&\u001a\u0004\u0018\u00010\u00032\u0006\u0010'\u001a\u00020\u0007J6\u0010(\u001a\u0004\u0018\u00010\u00032\u0006\u0010)\u001a\u00020\u00032\u0006\u0010*\u001a\u00020\u00072\b\b\u0002\u0010+\u001a\u00020\u00052\b\b\u0002\u0010,\u001a\u00020\u00052\b\b\u0002\u0010-\u001a\u00020\u0005J\b\u0010.\u001a\u00020\u0003H\u0016J\u000e\u0010.\u001a\u00020\u00032\u0006\u0010/\u001a\u00020\u0003J\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u000301J*\u00102\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010+\u001a\u00020\u00052\b\b\u0002\u0010-\u001a\u00020\u0005H\u0007J\u0010\u00103\u001a\u00020\u00032\u0006\u00104\u001a\u00020\u0007H\u0002J\u0010\u00105\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u00106\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/android/utils/TokenizedCommandLine;", "", "commandLine", "", "raw", "", "platform", "", "indexes", "", "(Ljava/lang/String;ZI[I)V", "getCommandLine", "()Ljava/lang/String;", "generation", "getPlatform", "()I", "getRaw", "()Z", "toStringValue", "bothSlash", "c1", "", "c2", "charAt", "i", "(I)Ljava/lang/Character;", "checkGeneration", "", "computeNormalizedCommandLineHashCode", "invalidate", "isEndOfCommand", "isEndOfToken", "isStartOfToken", "nextTokenAfter", "offset", "normalizedCommandLineEquals", "other", "normalizedCommandLineLength", "removeNth", "n", "removeTokenGroup", "token", "extra", "matchPrefix", "returnFirstExtra", "filePathSlashAgnostic", "toString", "separator", "toTokenList", "", "tokenMatches", "tokenStartingAt", "start", "zeroAllocTokenizePOSIX", "zeroAllocTokenizeWindows", "common"})
public final class TokenizedCommandLine {
    @NotNull
    private final String commandLine;
    private final boolean raw;
    private final int platform;
    @NotNull
    private int[] indexes;
    private final int generation;
    @Nullable
    private String toStringValue;

    public TokenizedCommandLine(@NotNull String commandLine, boolean raw, int platform, @NotNull int[] indexes) {
        Intrinsics.checkNotNullParameter(commandLine, "commandLine");
        Intrinsics.checkNotNullParameter(indexes, "indexes");
        this.commandLine = commandLine;
        this.raw = raw;
        this.platform = platform;
        int[] nArray = this.indexes = indexes;
        nArray[0] = nArray[0] + 1;
        this.generation = nArray[0];
        this.checkGeneration();
        if (this.platform == 2) {
            this.zeroAllocTokenizeWindows(this.raw);
        } else {
            this.zeroAllocTokenizePOSIX(this.raw);
        }
    }

    public /* synthetic */ TokenizedCommandLine(String string, boolean bl2, int n11, int[] nArray, int n12, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n12 & 4) != 0) {
            n11 = SdkConstants.currentPlatform();
        }
        if ((n12 & 8) != 0) {
            nArray = TokenizedCommandLineKt.allocateTokenizeCommandLineBuffer(string);
        }
        this(string, bl2, n11, nArray);
    }

    @NotNull
    public final String getCommandLine() {
        return this.commandLine;
    }

    public final boolean getRaw() {
        return this.raw;
    }

    public final int getPlatform() {
        return this.platform;
    }

    @Nullable
    public final String removeTokenGroup(@NotNull String token, int extra, boolean matchPrefix, boolean returnFirstExtra, boolean filePathSlashAgnostic) {
        Intrinsics.checkNotNullParameter(token, "token");
        this.checkGeneration();
        this.invalidate();
        int read = 1;
        int write = 1;
        String firstExtra = null;
        do {
            boolean bl2;
            boolean bl3 = bl2 = read >= write;
            if (_Assertions.ENABLED && !bl2) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            bl2 = this.isStartOfToken(read);
            if (_Assertions.ENABLED && !bl2) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            bl2 = this.isStartOfToken(write);
            if (_Assertions.ENABLED && !bl2) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            if (this.tokenMatches(token, read, matchPrefix, filePathSlashAgnostic)) {
                if (returnFirstExtra) {
                    firstExtra = matchPrefix ? this.tokenStartingAt(read + token.length()) : this.tokenStartingAt(this.nextTokenAfter(read));
                }
                for (int count = 0; count != extra + 1 && !this.isEndOfCommand(read); ++count) {
                    read = this.nextTokenAfter(read);
                }
            } else {
                if (this.isEndOfCommand(read) || this.isEndOfCommand(write)) continue;
                do {
                    this.indexes[write++] = this.indexes[read++];
                } while (!this.isEndOfToken(read - 1));
            }
        } while (!this.isEndOfCommand(read));
        this.indexes[write] = Integer.MIN_VALUE;
        return firstExtra;
    }

    public static /* synthetic */ String removeTokenGroup$default(TokenizedCommandLine tokenizedCommandLine, String string, int n11, boolean bl2, boolean bl3, boolean bl4, int n12, Object object) {
        if ((n12 & 4) != 0) {
            bl2 = false;
        }
        if ((n12 & 8) != 0) {
            bl3 = false;
        }
        if ((n12 & 0x10) != 0) {
            bl4 = false;
        }
        return tokenizedCommandLine.removeTokenGroup(string, n11, bl2, bl3, bl4);
    }

    private final String tokenStartingAt(int start) {
        this.checkGeneration();
        StringBuilder token = new StringBuilder();
        int n11 = this.indexes.length;
        block4: for (int read = start; read < n11; ++read) {
            int offset = this.indexes[read];
            switch (offset) {
                case -2147483648: {
                    break block4;
                }
                case 0x7FFFFFFF: {
                    break block4;
                }
                default: {
                    token.append(this.commandLine.charAt(offset));
                    continue block4;
                }
            }
        }
        return ((Object)StringsKt.trim(token)).toString();
    }

    @Nullable
    public final String removeNth(int n11) {
        this.checkGeneration();
        this.invalidate();
        StringBuilder token = new StringBuilder();
        int tokenNumber = 0;
        int write = 1;
        int n12 = this.indexes.length;
        block4: for (int read = 1; read < n12; ++read) {
            if (tokenNumber != n11) {
                this.indexes[write++] = this.indexes[read];
            }
            int offset = this.indexes[read];
            switch (offset) {
                case -2147483648: {
                    if (((CharSequence)token).length() == 0) {
                        return null;
                    }
                    return token.toString();
                }
                case 0x7FFFFFFF: {
                    ++tokenNumber;
                    continue block4;
                }
                default: {
                    if (tokenNumber != n11) continue block4;
                    token.append(this.commandLine.charAt(offset));
                }
            }
        }
        return null;
    }

    @NotNull
    public final List<String> toTokenList() {
        this.checkGeneration();
        List result = new ArrayList();
        StringBuilder token = new StringBuilder();
        int i11 = 1;
        while (!this.isEndOfCommand(i11)) {
            Character c11 = this.charAt(i11);
            if (c11 == null) {
                if (((CharSequence)token).length() > 0) {
                    String string = token.toString();
                    Intrinsics.checkNotNullExpressionValue(string, "token.toString()");
                    result.add(string);
                    token.setLength(0);
                }
            } else {
                token.append(c11.charValue());
            }
            ++i11;
        }
        return result;
    }

    private final TokenizedCommandLine zeroAllocTokenizeWindows(boolean raw) {
        int n11;
        this.checkGeneration();
        this.invalidate();
        boolean quoting = false;
        int i11 = 0;
        int length = this.commandLine.length();
        Character c11 = null;
        int offset = 0;
        offset = 1;
        while (i11 < length && Character.isWhitespace(this.commandLine.charAt(i11))) {
            n11 = i11;
            i11 = n11 + 1;
        }
        block1: while (i11 < length) {
            c11 = Character.valueOf(this.commandLine.charAt(i11));
            n11 = 34;
            if (c11.charValue() == n11) {
                if (raw) {
                    n11 = offset;
                    offset = n11 + 1;
                    this.indexes[n11] = i11;
                }
                quoting = !quoting;
                ++i11;
                continue;
            }
            n11 = 92;
            if (c11.charValue() == n11) {
                boolean quote;
                int forward = i11 + 1;
                int slashCount = 1;
                c11 = StringsKt.getOrNull(this.commandLine, forward);
                while (true) {
                    Character c12 = c11;
                    char c13 = '\\';
                    if (c12 == null || c12.charValue() != c13) break;
                    ++slashCount;
                    c11 = StringsKt.getOrNull(this.commandLine, ++forward);
                }
                boolean odd = slashCount % 2 == 1;
                Character c14 = c11;
                int n12 = 34;
                boolean bl2 = quote = c14 != null && c14.charValue() == n12;
                if (!raw && quote) {
                    slashCount /= 2;
                }
                n12 = 0;
                while (n12 < slashCount) {
                    int j11 = n12++;
                    boolean bl3 = false;
                    int n13 = offset;
                    offset = n13 + 1;
                    this.indexes[n13] = i11 + j11;
                }
                if (odd && quote) {
                    n12 = offset;
                    offset = n12 + 1;
                    this.indexes[n12] = forward++;
                }
                i11 = forward;
                continue;
            }
            if (!quoting) {
                n11 = 94;
                if (c11.charValue() == n11) {
                    c11 = StringsKt.getOrNull(this.commandLine, ++i11);
                    if (raw || c11 == null) {
                        n11 = offset;
                        offset = n11 + 1;
                        this.indexes[n11] = i11 - 1;
                    }
                    Character c15 = c11;
                    n11 = 94;
                    if (c15 != null && c15.charValue() == n11) {
                        n11 = offset;
                        offset = n11 + 1;
                        int n14 = n11;
                        n11 = i11;
                        i11 = n11 + 1;
                        this.indexes[n14] = n11;
                    }
                    while (true) {
                        Character c16 = c11;
                        n11 = 13;
                        if (c16 == null || c16.charValue() != n11) {
                            Character c17 = c11;
                            n11 = 10;
                            if (c17 == null || c17.charValue() != n11) continue block1;
                        }
                        c11 = StringsKt.getOrNull(this.commandLine, ++i11);
                    }
                }
            }
            if (!quoting && Character.isWhitespace(c11.charValue())) {
                n11 = offset;
                offset = n11 + 1;
                this.indexes[n11] = Integer.MAX_VALUE;
                c11 = StringsKt.getOrNull(this.commandLine, ++i11);
                while (c11 != null && Character.isWhitespace(c11.charValue())) {
                    c11 = StringsKt.getOrNull(this.commandLine, ++i11);
                }
                continue;
            }
            n11 = offset;
            offset = n11 + 1;
            int n15 = n11;
            n11 = i11;
            i11 = n11 + 1;
            this.indexes[n15] = n11;
        }
        if (!this.isEndOfToken(offset - 1)) {
            n11 = offset;
            offset = n11 + 1;
            this.indexes[n11] = Integer.MAX_VALUE;
        }
        n11 = offset;
        offset = n11 + 1;
        this.indexes[n11] = Integer.MIN_VALUE;
        return this;
    }

    private final TokenizedCommandLine zeroAllocTokenizePOSIX(boolean raw) {
        this.checkGeneration();
        this.invalidate();
        boolean quoting = false;
        char quote = '\u0000';
        boolean escaping = false;
        boolean skipping = true;
        int i11 = 0;
        char c11 = '\u0000';
        int length = this.commandLine.length();
        int offset = 1;
        while (i11 < length) {
            c11 = this.commandLine.charAt(i11++);
            if (skipping) {
                if (Character.isWhitespace(c11)) continue;
                skipping = false;
            }
            if ((quoting || !Character.isWhitespace(c11)) && raw) {
                this.indexes[offset++] = i11 - 1;
            }
            if (escaping) {
                escaping = false;
                if (c11 == '\n' || raw) continue;
                this.indexes[offset++] = i11 - 1;
                continue;
            }
            if (!(c11 != '\\' || quoting && quote != '\"')) {
                escaping = true;
                continue;
            }
            if (!(quoting || c11 != '\"' && c11 != '\'')) {
                quoting = true;
                quote = c11;
                continue;
            }
            if (quoting && c11 == quote) {
                quoting = false;
                quote = '\u0000';
                continue;
            }
            if (!quoting && Character.isWhitespace(c11)) {
                skipping = true;
                this.indexes[offset++] = Integer.MAX_VALUE;
                continue;
            }
            if (raw) continue;
            this.indexes[offset++] = i11 - 1;
        }
        if (!this.isEndOfToken(offset - 1)) {
            this.indexes[offset++] = Integer.MAX_VALUE;
        }
        this.indexes[offset] = Integer.MIN_VALUE;
        return this;
    }

    @VisibleForTesting
    public final boolean tokenMatches(@NotNull String token, int offset, boolean matchPrefix, boolean filePathSlashAgnostic) {
        Intrinsics.checkNotNullParameter(token, "token");
        this.checkGeneration();
        int i11 = 0;
        int index = this.indexes[offset];
        while (index != Integer.MIN_VALUE) {
            char c22;
            boolean endOfToken;
            boolean bl2 = endOfToken = index == Integer.MAX_VALUE;
            if (i11 == token.length()) {
                return endOfToken || matchPrefix;
            }
            if (endOfToken) {
                return false;
            }
            char c12 = token.charAt(i11);
            if (!(c12 == (c22 = this.commandLine.charAt(index)) || filePathSlashAgnostic && this.bothSlash(c12, c22))) {
                return false;
            }
            index = this.indexes[offset + ++i11];
        }
        return false;
    }

    public static /* synthetic */ boolean tokenMatches$default(TokenizedCommandLine tokenizedCommandLine, String string, int n11, boolean bl2, boolean bl3, int n12, Object object) {
        if ((n12 & 8) != 0) {
            bl3 = false;
        }
        return tokenizedCommandLine.tokenMatches(string, n11, bl2, bl3);
    }

    private final boolean bothSlash(char c12, char c22) {
        if (c12 != '\\' && c12 != '/') {
            return false;
        }
        return c22 == '\\' || c22 == '/';
    }

    @VisibleForTesting
    public final int nextTokenAfter(int offset) {
        this.checkGeneration();
        int result = offset;
        while (!this.isEndOfToken(result) && !this.isEndOfCommand(result)) {
            ++result;
        }
        return result + 1;
    }

    private final boolean isEndOfToken(int i11) {
        return i11 < this.indexes.length && this.indexes[i11] == Integer.MAX_VALUE;
    }

    private final boolean isEndOfCommand(int i11) {
        return i11 >= this.indexes.length || this.indexes[i11] == Integer.MIN_VALUE;
    }

    private final boolean isStartOfToken(int i11) {
        return i11 == 1 || this.isEndOfToken(i11 - 1);
    }

    private final Character charAt(int i11) {
        return this.isEndOfToken(i11) ? null : Character.valueOf(this.commandLine.charAt(this.indexes[i11]));
    }

    public final int normalizedCommandLineLength() {
        int n11;
        if (this.isEndOfCommand(1)) {
            n11 = 0;
        } else {
            int i11 = 1;
            while (!this.isEndOfCommand(i11 + 1)) {
                ++i11;
            }
            n11 = i11 - 1;
        }
        return n11;
    }

    public final int computeNormalizedCommandLineHashCode() {
        this.checkGeneration();
        long hash = 1469598103934665603L;
        int i11 = 1;
        while (!this.isEndOfCommand(i11) && !this.isEndOfCommand(i11 + 1)) {
            Character c11 = this.charAt(i11);
            hash ^= (long)(c11 != null ? c11.charValue() : 32);
            hash *= 1099511628211L;
            ++i11;
        }
        return (int)hash;
    }

    public final boolean normalizedCommandLineEquals(@NotNull String other) {
        Intrinsics.checkNotNullParameter(other, "other");
        int length1 = this.normalizedCommandLineLength();
        int length2 = other.length();
        if (length1 == 0 && length2 == 0) {
            return true;
        }
        if (length1 != length2) {
            return false;
        }
        for (int i11 = 1; i11 < length1; ++i11) {
            Character c11 = this.charAt(i11);
            if ((c11 != null ? c11.charValue() : (char)' ') == other.charAt(i11 - 1)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public final String toString(@NotNull String separator) {
        Intrinsics.checkNotNullParameter(separator, "separator");
        this.checkGeneration();
        int i11 = 1;
        if (this.isEndOfCommand(i11)) {
            return "";
        }
        StringBuilder sb2 = new StringBuilder();
        while (!this.isEndOfCommand(i11 + 1)) {
            Object object = this.charAt(i11);
            if (object == null) {
                object = separator;
            }
            sb2.append(object);
            ++i11;
        }
        String string = sb2.toString();
        Intrinsics.checkNotNullExpressionValue(string, "sb.toString()");
        return string;
    }

    @NotNull
    public String toString() {
        if (this.toStringValue != null) {
            String string = this.toStringValue;
            Intrinsics.checkNotNull(string);
            return string;
        }
        String string = this.toStringValue = this.toString(" ");
        Intrinsics.checkNotNull(string);
        return string;
    }

    private final void invalidate() {
        this.toStringValue = null;
    }

    private final void checkGeneration() {
        if (this.generation != Math.abs(this.indexes[0])) {
            throw new Exception("Buffer indexes was shared with another TokenizedCommandLine after this one");
        }
    }
}

