/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.device;

import com.android.tools.build.bundletool.device.AutoValue_BadgingInfoParser_BadgingInfo;
import com.android.tools.build.bundletool.model.exceptions.AdbOutputParseException;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class BadgingInfoParser {
    private static final Pattern PACKAGE_NAME_PATTERN = Pattern.compile(".*? name='(?<name>.*?)' versionCode='(?<version>\\d+?)' .*");

    private BadgingInfoParser() {
    }

    public static BadgingInfo parse(ImmutableList<String> badgingOutput) {
        String packageLine = badgingOutput.stream().filter(line -> line.trim().startsWith("package:")).findFirst().orElseThrow(() -> AdbOutputParseException.builder().withInternalMessage("'package:' line not found in badging output\n: %s", String.join((CharSequence)"\n", badgingOutput)).build());
        Matcher matcher = PACKAGE_NAME_PATTERN.matcher(packageLine);
        if (!matcher.matches()) {
            throw AdbOutputParseException.builder().withInternalMessage("'name=' and 'versionCode=' not found in package line: %s", packageLine).build();
        }
        return BadgingInfo.create(matcher.group("name"), Long.parseLong(matcher.group("version")));
    }

    @AutoValue
    public static abstract class BadgingInfo {
        static BadgingInfo create(String packageName, long versionCode) {
            return new AutoValue_BadgingInfoParser_BadgingInfo(packageName, versionCode);
        }

        public abstract String getPackageName();

        public abstract long getVersionCode();
    }
}

