/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.sdkmodule;

import com.android.bundle.SdkModulesConfigOuterClass;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleEntriesMutator;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ZipPath;
import com.google.common.collect.ImmutableList;
import java.util.function.Function;
import java.util.function.Predicate;

public class JavaResourceRepackager
extends ModuleEntriesMutator {
    private static final String ASSETS_DIRECTORY = "assets";
    private static final String ASSETS_SUBDIRECTORY_PREFIX = "RuntimeEnabledSdk-";
    private final SdkModulesConfigOuterClass.SdkModulesConfig sdkModulesConfig;

    JavaResourceRepackager(SdkModulesConfigOuterClass.SdkModulesConfig sdkModulesConfig) {
        this.sdkModulesConfig = sdkModulesConfig;
    }

    @Override
    public Predicate<ModuleEntry> getFilter() {
        return entry -> entry.getPath().toString().startsWith("root/");
    }

    @Override
    public Function<ImmutableList<ModuleEntry>, ImmutableList<ModuleEntry>> getMutator() {
        return resourceEntries -> resourceEntries.stream().map(this::updateJavaResourceEntryPath).collect(ImmutableList.toImmutableList());
    }

    @Override
    public boolean shouldApplyMutation(BundleModule module) {
        return true;
    }

    private ModuleEntry updateJavaResourceEntryPath(ModuleEntry javaResourceEntry) {
        ZipPath javaResourceEntryPath = javaResourceEntry.getPath();
        if (javaResourceEntryPath.getNameCount() < 2) {
            throw new IllegalStateException("Unexpected path to a Java resource entry: " + javaResourceEntryPath);
        }
        String javaResourceFilePath = javaResourceEntryPath.subpath(1, javaResourceEntryPath.getNameCount()).toString();
        return javaResourceEntry.toBuilder().setPath(ZipPath.create(this.getNewJavaResourceDirectoryPath() + "/" + javaResourceFilePath)).build();
    }

    String getNewJavaResourceDirectoryPath() {
        return "assets/" + this.getNewJavaResourceDirectoryPathInsideAssets();
    }

    String getNewJavaResourceDirectoryPathInsideAssets() {
        return ASSETS_SUBDIRECTORY_PREFIX + this.sdkModulesConfig.getSdkPackageName() + "/javaresources";
    }
}

