/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.transparency;

import com.android.bundle.CodeTransparencyOuterClass;
import com.android.tools.build.bundletool.archive.ArchivedResourcesHelper;
import com.android.tools.build.bundletool.io.ResourceReader;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.transparency.CodeTransparencyVersion;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteSource;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Comparator;
import java.util.stream.Stream;

public final class CodeTransparencyFactory {
    public static CodeTransparencyOuterClass.CodeTransparency createCodeTransparencyMetadata(AppBundle bundle) {
        ImmutableList codeRelatedFiles = bundle.getFeatureModules().values().stream().flatMap(CodeTransparencyFactory::getCodeRelatedFileEntries).map(CodeTransparencyFactory::createCodeRelatedFile).sorted(Comparator.comparing(CodeTransparencyOuterClass.CodeRelatedFile::getPath)).collect(ImmutableList.toImmutableList());
        CodeTransparencyOuterClass.CodeTransparency.Builder codeTransparencyBuilder = CodeTransparencyOuterClass.CodeTransparency.newBuilder().setVersion(CodeTransparencyVersion.getCurrentVersion()).addAllCodeRelatedFile(codeRelatedFiles);
        if (bundle.getStoreArchive().orElse(true).booleanValue()) {
            codeTransparencyBuilder.addCodeRelatedFile(CodeTransparencyFactory.createArchivedCodeRelatedFile(bundle));
        }
        return codeTransparencyBuilder.build();
    }

    private static CodeTransparencyOuterClass.CodeRelatedFile createArchivedCodeRelatedFile(AppBundle bundle) {
        CodeTransparencyOuterClass.CodeRelatedFile.Builder codeRelatedFile = CodeTransparencyOuterClass.CodeRelatedFile.newBuilder().setType(CodeTransparencyOuterClass.CodeRelatedFile.Type.DEX);
        try {
            ResourceReader resourceReader = new ResourceReader();
            ArchivedResourcesHelper archivedResourcesHelper = new ArchivedResourcesHelper(resourceReader);
            String resourcePath = archivedResourcesHelper.findArchivedClassesDexPath(bundle.getVersion(), true);
            codeRelatedFile.setBundletoolRepoPath(resourcePath);
            ByteSource byteSource = resourceReader.getResourceByteSource(resourcePath);
            codeRelatedFile.setSha256(byteSource.hash(Hashing.sha256()).toString());
        }
        catch (IOException e11) {
            throw InvalidBundleException.builder().withUserMessage("Unable to create an archived code related file.").withCause(e11).build();
        }
        return codeRelatedFile.build();
    }

    public static CodeTransparencyOuterClass.CodeTransparency parseFrom(String codeTransparency) {
        CodeTransparencyOuterClass.CodeTransparency.Builder codeTransparencyProto = CodeTransparencyOuterClass.CodeTransparency.newBuilder();
        try {
            JsonFormat.parser().merge(codeTransparency, (Message.Builder)codeTransparencyProto);
        }
        catch (IOException e11) {
            throw InvalidBundleException.builder().withUserMessage("Unable to parse code transparency file contents.").withCause(e11).build();
        }
        return codeTransparencyProto.build();
    }

    private static Stream<ModuleEntry> getCodeRelatedFileEntries(BundleModule module) {
        return module.getEntries().stream().filter(CodeTransparencyFactory::isCodeRelatedFile);
    }

    private static CodeTransparencyOuterClass.CodeRelatedFile createCodeRelatedFile(ModuleEntry moduleEntry) {
        Preconditions.checkArgument(moduleEntry.getFileLocation().isPresent());
        CodeTransparencyOuterClass.CodeRelatedFile.Builder codeRelatedFile = CodeTransparencyOuterClass.CodeRelatedFile.newBuilder().setPath(moduleEntry.getFileLocation().get().entryPathInFile().toString());
        if (moduleEntry.getPath().startsWith(BundleModule.LIB_DIRECTORY)) {
            codeRelatedFile.setType(CodeTransparencyOuterClass.CodeRelatedFile.Type.NATIVE_LIBRARY);
            codeRelatedFile.setApkPath(moduleEntry.getPath().toString());
        } else {
            codeRelatedFile.setType(CodeTransparencyOuterClass.CodeRelatedFile.Type.DEX);
        }
        try {
            codeRelatedFile.setSha256(moduleEntry.getContent().hash(Hashing.sha256()).toString());
        }
        catch (IOException e11) {
            throw new UncheckedIOException("An error occurred when calculating file hash.", e11);
        }
        return codeRelatedFile.build();
    }

    private static boolean isCodeRelatedFile(ModuleEntry moduleEntry) {
        return moduleEntry.getPath().startsWith(BundleModule.DEX_DIRECTORY) || moduleEntry.getPath().startsWith(BundleModule.LIB_DIRECTORY) && moduleEntry.getPath().toString().endsWith(".so");
    }

    private CodeTransparencyFactory() {
    }
}

