/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32;

import com.sun.jna.LastErrorException;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.W32Errors;
import com.sun.jna.platform.win32.WinNT;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Win32Exception
extends LastErrorException {
    private static final long serialVersionUID = 1L;
    private WinNT.HRESULT _hr;
    private static Method addSuppressedMethod = null;

    public WinNT.HRESULT getHR() {
        return this._hr;
    }

    public Win32Exception(int code) {
        this(code, W32Errors.HRESULT_FROM_WIN32(code));
    }

    public Win32Exception(WinNT.HRESULT hr2) {
        this(W32Errors.HRESULT_CODE(hr2.intValue()), hr2);
    }

    protected Win32Exception(int code, WinNT.HRESULT hr2) {
        this(code, hr2, Kernel32Util.formatMessage(hr2));
    }

    protected Win32Exception(int code, WinNT.HRESULT hr2, String msg) {
        super(code, msg);
        this._hr = hr2;
    }

    void addSuppressedReflected(Throwable exception) {
        if (addSuppressedMethod == null) {
            return;
        }
        try {
            addSuppressedMethod.invoke((Object)this, exception);
        }
        catch (IllegalAccessException ex2) {
            throw new RuntimeException("Failed to call addSuppressedMethod", ex2);
        }
        catch (IllegalArgumentException ex3) {
            throw new RuntimeException("Failed to call addSuppressedMethod", ex3);
        }
        catch (InvocationTargetException ex4) {
            throw new RuntimeException("Failed to call addSuppressedMethod", ex4);
        }
    }

    static {
        try {
            addSuppressedMethod = Throwable.class.getMethod("addSuppressed", Throwable.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException ex2) {
            Logger.getLogger(Win32Exception.class.getName()).log(Level.SEVERE, "Failed to initialize 'addSuppressed' method", ex2);
        }
    }
}

