/*
 * Decompiled with CFR 0.152.
 */
package org.jose4j.keys;

import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.NamedParameterSpec;
import org.jose4j.keys.EdDsaKeyUtil;
import org.jose4j.keys.KeyPairUtil;
import org.jose4j.keys.XDHKeyUtil;
import org.jose4j.lang.ExceptionHelp;
import org.jose4j.lang.JoseException;

public abstract class OctetKeyPairUtil
extends KeyPairUtil {
    public OctetKeyPairUtil(String provider, SecureRandom secureRandom) {
        super(provider, secureRandom);
    }

    public static OctetKeyPairUtil getOctetKeyPairUtil(String subtypeName, String provider, SecureRandom secureRandom) {
        if (subtypeName.equals("Ed25519") || subtypeName.equals("Ed448")) {
            return new EdDsaKeyUtil(provider, secureRandom);
        }
        if (subtypeName.equals("X25519") || subtypeName.equals("X448")) {
            return new XDHKeyUtil(provider, secureRandom);
        }
        return null;
    }

    public abstract PublicKey publicKey(byte[] var1, String var2) throws JoseException;

    public abstract PrivateKey privateKey(byte[] var1, String var2) throws JoseException;

    public abstract byte[] rawPublicKey(Key var1);

    public abstract byte[] rawPrivateKey(PrivateKey var1);

    public KeyPair generateKeyPair(String name) throws JoseException {
        KeyPairGenerator keyGenerator = this.getKeyPairGenerator();
        NamedParameterSpec spec = this.getNamedParameterSpec(name);
        try {
            if (this.secureRandom == null) {
                keyGenerator.initialize(spec);
            } else {
                keyGenerator.initialize(spec, this.secureRandom);
            }
            return keyGenerator.generateKeyPair();
        }
        catch (InvalidAlgorithmParameterException e11) {
            throw new JoseException("Unable to create EdDSA key pair: " + e11, e11);
        }
    }

    NamedParameterSpec getNamedParameterSpec(String name) throws JoseException {
        try {
            return new NamedParameterSpec(name);
        }
        catch (NoClassDefFoundError ncd) {
            throw new JoseException(name + " NamedParameterSpec not available. " + ExceptionHelp.toStringWithCauses(ncd));
        }
    }
}

