/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.writer.builder;

import com.android.tools.smali.dexlib2.base.value.BaseAnnotationEncodedValue;
import com.android.tools.smali.dexlib2.base.value.BaseArrayEncodedValue;
import com.android.tools.smali.dexlib2.base.value.BaseBooleanEncodedValue;
import com.android.tools.smali.dexlib2.base.value.BaseEnumEncodedValue;
import com.android.tools.smali.dexlib2.base.value.BaseFieldEncodedValue;
import com.android.tools.smali.dexlib2.base.value.BaseMethodEncodedValue;
import com.android.tools.smali.dexlib2.base.value.BaseMethodHandleEncodedValue;
import com.android.tools.smali.dexlib2.base.value.BaseMethodTypeEncodedValue;
import com.android.tools.smali.dexlib2.base.value.BaseNullEncodedValue;
import com.android.tools.smali.dexlib2.base.value.BaseStringEncodedValue;
import com.android.tools.smali.dexlib2.base.value.BaseTypeEncodedValue;
import com.android.tools.smali.dexlib2.iface.value.EncodedValue;
import com.android.tools.smali.dexlib2.immutable.value.ImmutableByteEncodedValue;
import com.android.tools.smali.dexlib2.immutable.value.ImmutableCharEncodedValue;
import com.android.tools.smali.dexlib2.immutable.value.ImmutableDoubleEncodedValue;
import com.android.tools.smali.dexlib2.immutable.value.ImmutableFloatEncodedValue;
import com.android.tools.smali.dexlib2.immutable.value.ImmutableIntEncodedValue;
import com.android.tools.smali.dexlib2.immutable.value.ImmutableLongEncodedValue;
import com.android.tools.smali.dexlib2.immutable.value.ImmutableShortEncodedValue;
import com.android.tools.smali.dexlib2.writer.builder.BuilderAnnotationElement;
import com.android.tools.smali.dexlib2.writer.builder.BuilderFieldReference;
import com.android.tools.smali.dexlib2.writer.builder.BuilderMethodHandleReference;
import com.android.tools.smali.dexlib2.writer.builder.BuilderMethodProtoReference;
import com.android.tools.smali.dexlib2.writer.builder.BuilderMethodReference;
import com.android.tools.smali.dexlib2.writer.builder.BuilderStringReference;
import com.android.tools.smali.dexlib2.writer.builder.BuilderTypeReference;
import com.android.tools.smali.util.ExceptionWithContext;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

public abstract class BuilderEncodedValues {
    @Nonnull
    public static BuilderEncodedValue defaultValueForType(String type) {
        switch (type.charAt(0)) {
            case 'Z': {
                return BuilderBooleanEncodedValue.FALSE_VALUE;
            }
            case 'B': {
                return new BuilderByteEncodedValue(0);
            }
            case 'S': {
                return new BuilderShortEncodedValue(0);
            }
            case 'C': {
                return new BuilderCharEncodedValue('\u0000');
            }
            case 'I': {
                return new BuilderIntEncodedValue(0);
            }
            case 'J': {
                return new BuilderLongEncodedValue(0L);
            }
            case 'F': {
                return new BuilderFloatEncodedValue(0.0f);
            }
            case 'D': {
                return new BuilderDoubleEncodedValue(0.0);
            }
            case 'L': 
            case '[': {
                return BuilderNullEncodedValue.INSTANCE;
            }
        }
        throw new ExceptionWithContext("Unrecognized type: %s", type);
    }

    public static class BuilderBooleanEncodedValue
    extends BaseBooleanEncodedValue
    implements BuilderEncodedValue {
        public static final BuilderBooleanEncodedValue TRUE_VALUE = new BuilderBooleanEncodedValue(true);
        public static final BuilderBooleanEncodedValue FALSE_VALUE = new BuilderBooleanEncodedValue(false);
        private final boolean value;

        private BuilderBooleanEncodedValue(boolean value) {
            this.value = value;
        }

        @Override
        public boolean getValue() {
            return this.value;
        }
    }

    public static class BuilderByteEncodedValue
    extends ImmutableByteEncodedValue
    implements BuilderEncodedValue {
        public BuilderByteEncodedValue(byte value) {
            super(value);
        }
    }

    public static class BuilderShortEncodedValue
    extends ImmutableShortEncodedValue
    implements BuilderEncodedValue {
        public BuilderShortEncodedValue(short value) {
            super(value);
        }
    }

    public static class BuilderCharEncodedValue
    extends ImmutableCharEncodedValue
    implements BuilderEncodedValue {
        public BuilderCharEncodedValue(char value) {
            super(value);
        }
    }

    public static class BuilderIntEncodedValue
    extends ImmutableIntEncodedValue
    implements BuilderEncodedValue {
        public BuilderIntEncodedValue(int value) {
            super(value);
        }
    }

    public static class BuilderLongEncodedValue
    extends ImmutableLongEncodedValue
    implements BuilderEncodedValue {
        public BuilderLongEncodedValue(long value) {
            super(value);
        }
    }

    public static class BuilderFloatEncodedValue
    extends ImmutableFloatEncodedValue
    implements BuilderEncodedValue {
        public BuilderFloatEncodedValue(float value) {
            super(value);
        }
    }

    public static class BuilderDoubleEncodedValue
    extends ImmutableDoubleEncodedValue
    implements BuilderEncodedValue {
        public BuilderDoubleEncodedValue(double value) {
            super(value);
        }
    }

    public static class BuilderNullEncodedValue
    extends BaseNullEncodedValue
    implements BuilderEncodedValue {
        public static final BuilderNullEncodedValue INSTANCE = new BuilderNullEncodedValue();

        private BuilderNullEncodedValue() {
        }
    }

    public static class BuilderMethodHandleEncodedValue
    extends BaseMethodHandleEncodedValue
    implements BuilderEncodedValue {
        @Nonnull
        final BuilderMethodHandleReference methodHandleReference;

        public BuilderMethodHandleEncodedValue(@Nonnull BuilderMethodHandleReference methodHandleReference) {
            this.methodHandleReference = methodHandleReference;
        }

        @Override
        @Nonnull
        public BuilderMethodHandleReference getValue() {
            return this.methodHandleReference;
        }
    }

    public static class BuilderMethodTypeEncodedValue
    extends BaseMethodTypeEncodedValue
    implements BuilderEncodedValue {
        @Nonnull
        final BuilderMethodProtoReference methodProtoReference;

        public BuilderMethodTypeEncodedValue(@Nonnull BuilderMethodProtoReference methodProtoReference) {
            this.methodProtoReference = methodProtoReference;
        }

        @Override
        @Nonnull
        public BuilderMethodProtoReference getValue() {
            return this.methodProtoReference;
        }
    }

    public static class BuilderTypeEncodedValue
    extends BaseTypeEncodedValue
    implements BuilderEncodedValue {
        @Nonnull
        final BuilderTypeReference typeReference;

        BuilderTypeEncodedValue(@Nonnull BuilderTypeReference typeReference) {
            this.typeReference = typeReference;
        }

        @Override
        @Nonnull
        public String getValue() {
            return this.typeReference.getType();
        }
    }

    public static class BuilderStringEncodedValue
    extends BaseStringEncodedValue
    implements BuilderEncodedValue {
        @Nonnull
        final BuilderStringReference stringReference;

        BuilderStringEncodedValue(@Nonnull BuilderStringReference stringReference) {
            this.stringReference = stringReference;
        }

        @Override
        @Nonnull
        public String getValue() {
            return this.stringReference.getString();
        }
    }

    public static class BuilderMethodEncodedValue
    extends BaseMethodEncodedValue
    implements BuilderEncodedValue {
        @Nonnull
        final BuilderMethodReference methodReference;

        BuilderMethodEncodedValue(@Nonnull BuilderMethodReference methodReference) {
            this.methodReference = methodReference;
        }

        @Override
        public BuilderMethodReference getValue() {
            return this.methodReference;
        }
    }

    public static class BuilderFieldEncodedValue
    extends BaseFieldEncodedValue
    implements BuilderEncodedValue {
        @Nonnull
        final BuilderFieldReference fieldReference;

        BuilderFieldEncodedValue(@Nonnull BuilderFieldReference fieldReference) {
            this.fieldReference = fieldReference;
        }

        @Override
        @Nonnull
        public BuilderFieldReference getValue() {
            return this.fieldReference;
        }
    }

    public static class BuilderEnumEncodedValue
    extends BaseEnumEncodedValue
    implements BuilderEncodedValue {
        @Nonnull
        final BuilderFieldReference enumReference;

        BuilderEnumEncodedValue(@Nonnull BuilderFieldReference enumReference) {
            this.enumReference = enumReference;
        }

        @Override
        @Nonnull
        public BuilderFieldReference getValue() {
            return this.enumReference;
        }
    }

    public static class BuilderArrayEncodedValue
    extends BaseArrayEncodedValue
    implements BuilderEncodedValue {
        @Nonnull
        final List<? extends BuilderEncodedValue> elements;
        int offset = 0;

        BuilderArrayEncodedValue(@Nonnull List<? extends BuilderEncodedValue> elements) {
            this.elements = elements;
        }

        @Override
        @Nonnull
        public List<? extends EncodedValue> getValue() {
            return this.elements;
        }
    }

    public static class BuilderAnnotationEncodedValue
    extends BaseAnnotationEncodedValue
    implements BuilderEncodedValue {
        @Nonnull
        final BuilderTypeReference typeReference;
        @Nonnull
        final Set<? extends BuilderAnnotationElement> elements;

        BuilderAnnotationEncodedValue(@Nonnull BuilderTypeReference typeReference, @Nonnull Set<? extends BuilderAnnotationElement> elements) {
            this.typeReference = typeReference;
            this.elements = elements;
        }

        @Override
        @Nonnull
        public String getType() {
            return this.typeReference.getType();
        }

        @Nonnull
        public Set<? extends BuilderAnnotationElement> getElements() {
            return this.elements;
        }
    }

    public static interface BuilderEncodedValue
    extends EncodedValue {
    }
}

