/*
© 2020 Amazon Web Services, Inc. or its affiliates. All Rights Reserved.

                                 Apache License
                           Version 2.0, January 2004
                        http://www.apache.org/licenses/

   TERMS AND CONDITIONS FOR USE, REPRODUCTION, AND DISTRIBUTION

   1. Definitions.

      "License" shall mean the terms and conditions for use, reproduction,
      and distribution as defined by Sections 1 through 9 of this document.

      "Licensor" shall mean the copyright owner or entity authorized by
      the copyright owner that is granting the License.

      "Legal Entity" shall mean the union of the acting entity and all
      other entities that control, are controlled by, or are under common
      control with that entity. For the purposes of this definition,
      "control" means (i) the power, direct or indirect, to cause the
      direction or management of such entity, whether by contract or
      otherwise, or (ii) ownership of fifty percent (50%) or more of the
      outstanding shares, or (iii) beneficial ownership of such entity.

      "You" (or "Your") shall mean an individual or Legal Entity
      exercising permissions granted by this License.

      "Source" form shall mean the preferred form for making modifications,
      including but not limited to software source code, documentation
      source, and configuration files.

      "Object" form shall mean any form resulting from mechanical
      transformation or translation of a Source form, including but
      not limited to compiled object code, generated documentation,
      and conversions to other media types.

      "Work" shall mean the work of authorship, whether in Source or
      Object form, made available under the License, as indicated by a
      copyright notice that is included in or attached to the work
      (an example is provided in the Appendix below).

      "Derivative Works" shall mean any work, whether in Source or Object
      form, that is based on (or derived from) the Work and for which the
      editorial revisions, annotations, elaborations, or other modifications
      represent, as a whole, an original work of authorship. For the purposes
      of this License, Derivative Works shall not include works that remain
      separable from, or merely link (or bind by name) to the interfaces of,
      the Work and Derivative Works thereof.

      "Contribution" shall mean any work of authorship, including
      the original version of the Work and any modifications or additions
      to that Work or Derivative Works thereof, that is intentionally
      submitted to Licensor for inclusion in the Work by the copyright owner
      or by an individual or Legal Entity authorized to submit on behalf of
      the copyright owner. For the purposes of this definition, "submitted"
      means any form of electronic, verbal, or written communication sent
      to the Licensor or its representatives, including but not limited to
      communication on electronic mailing lists, source code control systems,
      and issue tracking systems that are managed by, or on behalf of, the
      Licensor for the purpose of discussing and improving the Work, but
      excluding communication that is conspicuously marked or otherwise
      designated in writing by the copyright owner as "Not a Contribution."

      "Contributor" shall mean Licensor and any individual or Legal Entity
      on behalf of whom a Contribution has been received by Licensor and
      subsequently incorporated within the Work.

   2. Grant of Copyright License. Subject to the terms and conditions of
      this License, each Contributor hereby grants to You a perpetual,
      worldwide, non_exclusive, no_charge, royalty_free, irrevocable
      copyright license to reproduce, prepare Derivative Works of,
      publicly display, publicly perform, sublicense, and distribute the
      Work and such Derivative Works in Source or Object form.

   3. Grant of Patent License. Subject to the terms and conditions of
      this License, each Contributor hereby grants to You a perpetual,
      worldwide, non_exclusive, no_charge, royalty_free, irrevocable
      (except as stated in this section) patent license to make, have made,
      use, offer to sell, sell, import, and otherwise transfer the Work,
      where such license applies only to those patent claims licensable
      by such Contributor that are necessarily infringed by their
      Contribution(s) alone or by combination of their Contribution(s)
      with the Work to which such Contribution(s) was submitted. If You
      institute patent litigation against any entity (including a
      cross_claim or counterclaim in a lawsuit) alleging that the Work
      or a Contribution incorporated within the Work constitutes direct
      or contributory patent infringement, then any patent licenses
      granted to You under this License for that Work shall terminate
      as of the date such litigation is filed.

   4. Redistribution. You may reproduce and distribute copies of the
      Work or Derivative Works thereof in any medium, with or without
      modifications, and in Source or Object form, provided that You
      meet the following conditions:

      (a) You must give any other recipients of the Work or
          Derivative Works a copy of this License; and

      (b) You must cause any modified files to carry prominent notices
          stating that You changed the files; and

      (c) You must retain, in the Source form of any Derivative Works
          that You distribute, all copyright, patent, trademark, and
          attribution notices from the Source form of the Work,
          excluding those notices that do not pertain to any part of
          the Derivative Works; and

      (d) If the Work includes a "NOTICE" text file as part of its
          distribution, then any Derivative Works that You distribute must
          include a readable copy of the attribution notices contained
          within such NOTICE file, excluding those notices that do not
          pertain to any part of the Derivative Works, in at least one
          of the following places: within a NOTICE text file distributed
          as part of the Derivative Works; within the Source form or
          documentation, if provided along with the Derivative Works; or,
          within a display generated by the Derivative Works, if and
          wherever such third_party notices normally appear. The contents
          of the NOTICE file are for informational purposes only and
          do not modify the License. You may add Your own attribution
          notices within Derivative Works that You distribute, alongside
          or as an addendum to the NOTICE text from the Work, provided
          that such additional attribution notices cannot be construed
          as modifying the License.

      You may add Your own copyright statement to Your modifications and
      may provide additional or different license terms and conditions
      for use, reproduction, or distribution of Your modifications, or
      for any such Derivative Works as a whole, provided Your use,
      reproduction, and distribution of the Work otherwise complies with
      the conditions stated in this License.

   5. Submission of Contributions. Unless You explicitly state otherwise,
      any Contribution intentionally submitted for inclusion in the Work
      by You to the Licensor shall be under the terms and conditions of
      this License, without any additional terms or conditions.
      Notwithstanding the above, nothing herein shall supersede or modify
      the terms of any separate license agreement you may have executed
      with Licensor regarding such Contributions.

   6. Trademarks. This License does not grant permission to use the trade
      names, trademarks, service marks, or product names of the Licensor,
      except as required for reasonable and customary use in describing the
      origin of the Work and reproducing the content of the NOTICE file.

   7. Disclaimer of Warranty. Unless required by applicable law or
      agreed to in writing, Licensor provides the Work (and each
      Contributor provides its Contributions) on an "AS IS" BASIS,
      WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
      implied, including, without limitation, any warranties or conditions
      of TITLE, NON_INFRINGEMENT, MERCHANTABILITY, or FITNESS FOR A
      PARTICULAR PURPOSE. You are solely responsible for determining the
      appropriateness of using or redistributing the Work and assume any
      risks associated with Your exercise of permissions under this License.

   8. Limitation of Liability. In no event and under no legal theory,
      whether in tort (including negligence), contract, or otherwise,
      unless required by applicable law (such as deliberate and grossly
      negligent acts) or agreed to in writing, shall any Contributor be
      liable to You for damages, including any direct, indirect, special,
      incidental, or consequential damages of any character arising as a
      result of this License or out of the use or inability to use the
      Work (including but not limited to damages for loss of goodwill,
      work stoppage, computer failure or malfunction, or any and all
      other commercial damages or losses), even if such Contributor
      has been advised of the possibility of such damages.

   9. Accepting Warranty or Additional Liability. While redistributing
      the Work or Derivative Works thereof, You may choose to offer,
      and charge a fee for, acceptance of support, warranty, indemnity,
      or other liability obligations and/or rights consistent with this
      License. However, in accepting such obligations, You may act only
      on Your own behalf and on Your sole responsibility, not on behalf
      of any other Contributor, and only if You agree to indemnify,
      defend, and hold each Contributor harmless for any liability
      incurred by, or claims asserted against, such Contributor by reason
      of your accepting any such warranty or additional liability.

   END OF TERMS AND CONDITIONS

   APPENDIX: How to apply the Apache License to your work.

      To apply the Apache License to your work, attach the following
      boilerplate notice, with the fields enclosed by brackets "[]"
      replaced with your own identifying information. (Don't include
      the brackets!)  The text should be enclosed in the appropriate
      comment syntax for the file format. We also recommend that a
      file or class name and description of purpose be included on the
      same "printed page" as the copyright notice for easier
      identification within third_party archives.

   Copyright [2020] [© 2020 Amazon Web Services, Inc. or its affiliates. All Rights Reserved.]

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE_2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/

/*
Security Hub Import Commands

Run this to get state of SecurityHub

terraform import aws_securityhub_account.securityhubresource 123456789012

*/

terraform {
  required_providers {
    aws = {
      source  = "hashicorp/aws"
      version = "~> 3.54"
    }
  }
}
provider "aws" {
  region = var.select_region
}

resource "aws_iam_role" "prowler_kick_start_role" {
  name                = "security_baseline_kickstarter_iam_role"
  managed_policy_arns = ["${data.aws_iam_policy.SecurityAudit.arn}",
                         "arn:aws:iam::aws:policy/job-function/SupportUser",
                         "arn:aws:iam::aws:policy/job-function/ViewOnlyAccess"]
  assume_role_policy = jsonencode({
    Version = "2012-10-17"
    Statement = [
      {
        Action="sts:AssumeRole"
        Effect="Allow"
        Sid = "CodeBuildProwler"
        Principal = {Service="codebuild.amazonaws.com"}
      }
    ]
  })
  force_detach_policies=true
}
resource "aws_iam_role" "prowler_event_trigger_role" {
    name = "security_baseline_kickstarter_event_trigger_iam_role"
    assume_role_policy = jsonencode({
                              Version = "2012-10-17"
                              Statement = [
                                {
                                  Action="sts:AssumeRole"
                                  Effect="Allow"
                                  Sid = "TriggerCodeBuild"
                                  Principal = {Service="events.amazonaws.com"}
                                }
                              ]
                            })

}
resource "aws_iam_policy" "prowler_event_trigger_policy" {
  depends_on        = [aws_codebuild_project.prowler_codebuild]
  name        = "security_baseline_kickstarter_trigger_iam_policy"
  path        = "/"
  description = "IAM Policy used to trigger the Prowler in AWS Codebuild"
  policy = jsonencode({
     Version = "2012-10-17"
    Statement = [
      {
        Action =  ["codebuild:StartBuild"],
        Effect   = "Allow"
        Resource =  aws_codebuild_project.prowler_codebuild.arn
      }]
  })
}
resource "aws_iam_policy_attachment" "prowler_event_trigger_policy_attach" {
  depends_on = [aws_iam_policy.prowler_event_trigger_policy]
  name       = "prowler_event_trigger_policy_attach"
  roles      = toset([aws_iam_role.prowler_event_trigger_role.id])
  policy_arn = aws_iam_policy.prowler_event_trigger_policy.arn
}
resource "aws_iam_policy" "prowler_kickstarter_iam_policy" {
  name        = "security_baseline_kickstarter_iam_policy"
  path        = "/"
  description = "IAM Policy used to run prowler from codebuild"

  # Terraform's "jsonencode" function converts a
  # Terraform expression result to valid JSON syntax.
  policy = jsonencode({
    Version = "2012-10-17"
    Statement = [
      {
        Action =  [
            "logs:PutLogEvents"
            ],
        Effect   = "Allow"
        Resource =  "arn:aws:logs:*:${data.aws_caller_identity.current.account_id}:log-group:*:log-stream:*"
      },
       {
        Action =  [
            "logs:CreateLogStream",
            "logs:CreateLogGroup"
            ],
        Effect   = "Allow"
        Resource =  "arn:aws:logs:*:${data.aws_caller_identity.current.account_id}:log-group:*"
      },
       {
        Action =  ["sts:AssumeRole"],
        Effect   = "Allow"
        Resource =  "arn:aws:iam::${data.aws_caller_identity.current.account_id}:role/${aws_iam_role.prowler_kick_start_role.name}"
      },
      {
        Action =  [
                  "ds:ListAuthorizedApplications",
                  "ec2:GetEbsEncryptionByDefault",
                  "ecr:Describe*",
                  "elasticfilesystem:DescribeBackupPolicy",
                  "glue:GetConnections",
                  "glue:GetSecurityConfiguration",
                  "glue:SearchTables",
                  "lambda:GetFunction",
                  "s3:GetAccountPublicAccessBlock",
                  "shield:DescribeProtection",
                  "shield:GetSubscriptionState",
                  "ssm:GetDocument",
                  "support:Describe*",
                  "tag:GetTagKeys"
                  ]
        Effect   = "Allow"
        Resource = "arn:aws:glue:${data.aws_region.current.name}:${data.aws_caller_identity.current.account_id}:catalog"

      },
      {
        Action =  [
                "codebuild:CreateReportGroup",
                "codebuild:CreateReport",
                "codebuild:UpdateReport",
                "codebuild:BatchPutTestCases",
                "codebuild:BatchPutCodeCoverages"
                                    ]
        Effect   = "Allow"
        Resource = "arn:aws:codebuild:${data.aws_region.current.name}:${data.aws_caller_identity.current.account_id}:report-group/*"

      },
       {
        Action =  [ "securityhub:BatchImportFindings"]
        Effect   = "Allow"
        Resource = "*"
      },
             {
        Action =  [ "securityhub:GetFindings"]
        Effect   = "Allow"
        Resource = "*"
      },
      {
            "Action": "codebuild:StartBuild",
            "Resource": "arn:aws:codebuild:${data.aws_region.current.name}:${data.aws_caller_identity.current.account_id}:project/*",
            "Effect": "Allow"
      },
      {
            "Action": ["s3:PutObject", "s3:GetObject", "s3:GetObjectVersion", "s3:GetBucketAcl", "s3:GetBucketLocation"],
            "Resource": "arn:aws:s3:::prowler-kickstart-${data.aws_region.current.name}-${data.aws_caller_identity.current.account_id}-reports/*",
            "Effect": "Allow"
      },
    ]
  })
}
resource "aws_iam_policy_attachment" "prowler_kickstarter_iam_policy_attach" {
  depends_on = [aws_iam_policy.prowler_kickstarter_iam_policy]
  name       = "security_baseline_kickstarter_policy_attach"
  roles      = toset([aws_iam_role.prowler_kick_start_role.id])
  policy_arn = aws_iam_policy.prowler_kickstarter_iam_policy.arn
}
resource "aws_s3_bucket" "prowler_report_storage_bucket" {
    bucket = "prowler-kickstart-${data.aws_region.current.name}-${data.aws_caller_identity.current.account_id}-reports"
    acl = "log-delivery-write"
    versioning {
        enabled = true
    }
    server_side_encryption_configuration {
        rule {
            apply_server_side_encryption_by_default {
                sse_algorithm     = "AES256"
            }
        }
    }
    }

resource "aws_s3_bucket_policy" "prowler_report_storage_bucket_policy" {
    depends_on = [aws_s3_bucket.prowler_report_storage_bucket]
    bucket = aws_s3_bucket.prowler_report_storage_bucket.id
    policy = jsonencode({Version = "2012-10-17"
                            Id      = "ProwlerBucketReportPolicy"
                            Statement = [
                            {
                                Sid       = "S3ForceSSL"
                                Effect    = "Deny"
                                Principal = "*"
                                Action    = "s3:*"
                                Resource = ["${aws_s3_bucket.prowler_report_storage_bucket.arn}/*"]
                                Condition = {
                                Bool = {
                                    "aws:SecureTransport" = "false"
                                    }
                                }
                            },
                            {
                                Sid       = "DenyUnEncryptedObjectUploads"
                                Effect    = "Deny"
                                Principal = "*"
                                Action    = "s3:*"
                                Resource = ["${aws_s3_bucket.prowler_report_storage_bucket.arn}/*"]
                                Condition = {
                                Null = {
                                    "s3:x-amz-server-side-encryption" = "true"
                                    }
                                }
                            }

                            ]
                        })
                        }



resource "aws_s3_bucket_public_access_block" "prowler_report_storage_bucket_block_public" {
    depends_on = [aws_s3_bucket.prowler_report_storage_bucket, aws_s3_bucket_policy.prowler_report_storage_bucket_policy]
    bucket = aws_s3_bucket.prowler_report_storage_bucket.id
    block_public_acls   = true
    block_public_policy = true
    ignore_public_acls = true
    restrict_public_buckets = true
    }

resource "aws_codebuild_project" "prowler_codebuild" {
  name          = "security_baseline_kickstarter_codebuild"
  description   = "Run a Prowler Assessment with Prowler"
  build_timeout = var.codebuild_timeout
  service_role  = aws_iam_role.prowler_kick_start_role.arn

  artifacts {
    type = "NO_ARTIFACTS"
  }

  environment {
    compute_type                = "BUILD_GENERAL1_SMALL"
    image                       = "aws/codebuild/amazonlinux2-x86_64-standard:3.0"
    type                        = "LINUX_CONTAINER"

    environment_variable {
      name  = "BUCKET_REPORT"
      value = "${aws_s3_bucket.prowler_report_storage_bucket.id}"
    }

    environment_variable {
      name  = "PROWLER_OPTIONS"
      type  = "PLAINTEXT"
      value = var.prowler_cli_options
        }
    }


  source {
    type            = "NO_SOURCE"
    buildspec       =  "${file("prowler_build_spec.yml")}"
    }

  tags = {
    Environment = "Prowler KickStarter"
        }
    }





resource "aws_securityhub_account" "securityhub_resource" {
    }

resource "aws_securityhub_product_subscription" "security_hub_enable_prowler_findings" {
  depends_on  = [aws_securityhub_account.securityhub_resource]
  //arn:aws:securityhub:<REGION>::product/prowler/prowler
  product_arn = "arn:aws:securityhub:${data.aws_region.current.name}::product/prowler/prowler"
    }

resource "aws_cloudwatch_event_rule" "prowler_check_scheduler_event" {

    name = "security_baseline_kickstarter_event_cron"
    description = "Run Prowler every night"
    schedule_expression = var.prowler_schedule
    }

resource "aws_cloudwatch_event_target" "run_prowler_scan" {

  arn       = aws_codebuild_project.prowler_codebuild.arn
  rule      = aws_cloudwatch_event_rule.prowler_check_scheduler_event.name
  role_arn  = aws_iam_role.prowler_event_trigger_role.arn

    }
