# Generated by Django 5.1.13 on 2025-10-30 15:23

import uuid

import django.db.models.deletion
from django.db import migrations, models

import api.rls


class Migration(migrations.Migration):
    dependencies = [
        ("api", "0058_drop_redundant_compliance_requirement_indexes"),
    ]

    operations = [
        migrations.CreateModel(
            name="ComplianceOverviewSummary",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("inserted_at", models.DateTimeField(auto_now_add=True)),
                ("compliance_id", models.TextField()),
                ("requirements_passed", models.IntegerField(default=0)),
                ("requirements_failed", models.IntegerField(default=0)),
                ("requirements_manual", models.IntegerField(default=0)),
                ("total_requirements", models.IntegerField(default=0)),
                (
                    "scan",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="compliance_summaries",
                        related_query_name="compliance_summary",
                        to="api.scan",
                    ),
                ),
                (
                    "tenant",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="api.tenant"
                    ),
                ),
            ],
            options={
                "db_table": "compliance_overview_summaries",
                "abstract": False,
                "indexes": [
                    models.Index(
                        fields=["tenant_id", "scan_id"], name="cos_tenant_scan_idx"
                    )
                ],
                "constraints": [
                    models.UniqueConstraint(
                        fields=("tenant_id", "scan_id", "compliance_id"),
                        name="unique_compliance_summary_per_scan",
                    )
                ],
            },
        ),
        migrations.AddConstraint(
            model_name="complianceoverviewsummary",
            constraint=api.rls.RowLevelSecurityConstraint(
                "tenant_id",
                name="rls_on_complianceoverviewsummary",
                statements=["SELECT", "INSERT", "UPDATE", "DELETE"],
            ),
        ),
    ]
