// components/metrics/public/mojom/single_sample_metrics.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/metrics/public/mojom/single_sample_metrics.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "components/metrics/public/mojom/single_sample_metrics.mojom-params-data.h"
#include "components/metrics/public/mojom/single_sample_metrics.mojom-shared-message-ids.h"

#include "components/metrics/public/mojom/single_sample_metrics.mojom-import-headers.h"


#ifndef COMPONENTS_METRICS_PUBLIC_MOJOM_SINGLE_SAMPLE_METRICS_MOJOM_JUMBO_H_
#define COMPONENTS_METRICS_PUBLIC_MOJOM_SINGLE_SAMPLE_METRICS_MOJOM_JUMBO_H_
#endif
namespace metrics {
namespace mojom {
const char SingleSampleMetricsProvider::Name_[] = "metrics.mojom.SingleSampleMetricsProvider";

SingleSampleMetricsProviderProxy::SingleSampleMetricsProviderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SingleSampleMetricsProviderProxy::AcquireSingleSampleMetric(
    const std::string& in_histogram_name, int32_t in_min, int32_t in_max, uint32_t in_bucket_count, int32_t in_flags, ::mojo::PendingReceiver<SingleSampleMetric> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "metrics::mojom::SingleSampleMetricsProvider::AcquireSingleSampleMetric", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("histogram_name", in_histogram_name);
      raw_value->SetInteger("min", in_min);
      raw_value->SetInteger("max", in_max);
      raw_value->SetString("bucket_count", base::NumberToString(in_bucket_count));
      raw_value->SetInteger("flags", in_flags);
      raw_value->SetBoolean("receiver", in_receiver.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSingleSampleMetricsProvider_AcquireSingleSampleMetric_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::metrics::mojom::internal::SingleSampleMetricsProvider_AcquireSingleSampleMetric_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->histogram_name)::BaseType::BufferWriter
      histogram_name_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_histogram_name, buffer, &histogram_name_writer, &serialization_context);
  params->histogram_name.Set(
      histogram_name_writer.is_null() ? nullptr : histogram_name_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->histogram_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null histogram_name in SingleSampleMetricsProvider.AcquireSingleSampleMetric request");
  params->min = in_min;
  params->max = in_max;
  params->bucket_count = in_bucket_count;
  params->flags = in_flags;
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::metrics::mojom::SingleSampleMetricInterfaceBase>>(
      in_receiver, &params->receiver, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in SingleSampleMetricsProvider.AcquireSingleSampleMetric request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SingleSampleMetricsProvider::Name_);
  message.set_method_name("AcquireSingleSampleMetric");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool SingleSampleMetricsProviderStubDispatch::Accept(
    SingleSampleMetricsProvider* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kSingleSampleMetricsProvider_AcquireSingleSampleMetric_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)metrics::mojom::SingleSampleMetricsProvider::AcquireSingleSampleMetric",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)metrics::mojom::SingleSampleMetricsProvider::AcquireSingleSampleMetric");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SingleSampleMetricsProvider_AcquireSingleSampleMetric_Params_Data* params =
          reinterpret_cast<internal::SingleSampleMetricsProvider_AcquireSingleSampleMetric_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_histogram_name{};
      int32_t p_min{};
      int32_t p_max{};
      uint32_t p_bucket_count{};
      int32_t p_flags{};
      ::mojo::PendingReceiver<SingleSampleMetric> p_receiver{};
      SingleSampleMetricsProvider_AcquireSingleSampleMetric_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadHistogramName(&p_histogram_name))
        success = false;
      if (success)
        p_min = input_data_view.min();
      if (success)
        p_max = input_data_view.max();
      if (success)
        p_bucket_count = input_data_view.bucket_count();
      if (success)
        p_flags = input_data_view.flags();
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SingleSampleMetricsProvider::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AcquireSingleSampleMetric(
std::move(p_histogram_name), 
std::move(p_min), 
std::move(p_max), 
std::move(p_bucket_count), 
std::move(p_flags), 
std::move(p_receiver));
      return true;
    }
  }
  return false;
}

// static
bool SingleSampleMetricsProviderStubDispatch::AcceptWithResponder(
    SingleSampleMetricsProvider* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kSingleSampleMetricsProvider_AcquireSingleSampleMetric_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kSingleSampleMetricsProviderValidationInfo[] = {
    {internal::kSingleSampleMetricsProvider_AcquireSingleSampleMetric_Name,
     {&internal::SingleSampleMetricsProvider_AcquireSingleSampleMetric_Params_Data::Validate,
      nullptr /* no response */}},
};

bool SingleSampleMetricsProviderRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::metrics::mojom::SingleSampleMetricsProvider::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kSingleSampleMetricsProviderValidationInfo);
}

const char SingleSampleMetric::Name_[] = "metrics.mojom.SingleSampleMetric";

SingleSampleMetricProxy::SingleSampleMetricProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SingleSampleMetricProxy::SetSample(
    int32_t in_sample) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "metrics::mojom::SingleSampleMetric::SetSample", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("sample", in_sample);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSingleSampleMetric_SetSample_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::metrics::mojom::internal::SingleSampleMetric_SetSample_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->sample = in_sample;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SingleSampleMetric::Name_);
  message.set_method_name("SetSample");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool SingleSampleMetricStubDispatch::Accept(
    SingleSampleMetric* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kSingleSampleMetric_SetSample_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)metrics::mojom::SingleSampleMetric::SetSample",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)metrics::mojom::SingleSampleMetric::SetSample");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SingleSampleMetric_SetSample_Params_Data* params =
          reinterpret_cast<internal::SingleSampleMetric_SetSample_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_sample{};
      SingleSampleMetric_SetSample_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_sample = input_data_view.sample();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SingleSampleMetric::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetSample(
std::move(p_sample));
      return true;
    }
  }
  return false;
}

// static
bool SingleSampleMetricStubDispatch::AcceptWithResponder(
    SingleSampleMetric* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kSingleSampleMetric_SetSample_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kSingleSampleMetricValidationInfo[] = {
    {internal::kSingleSampleMetric_SetSample_Name,
     {&internal::SingleSampleMetric_SetSample_Params_Data::Validate,
      nullptr /* no response */}},
};

bool SingleSampleMetricRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::metrics::mojom::SingleSampleMetric::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kSingleSampleMetricValidationInfo);
}

}  // namespace mojom
}  // namespace metrics

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif