// components/performance_manager/public/mojom/coordination_unit.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/performance_manager/public/mojom/coordination_unit.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "components/performance_manager/public/mojom/coordination_unit.mojom-params-data.h"
#include "components/performance_manager/public/mojom/coordination_unit.mojom-shared-message-ids.h"

#include "components/performance_manager/public/mojom/coordination_unit.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef COMPONENTS_PERFORMANCE_MANAGER_PUBLIC_MOJOM_COORDINATION_UNIT_MOJOM_BLINK_JUMBO_H_
#define COMPONENTS_PERFORMANCE_MANAGER_PUBLIC_MOJOM_COORDINATION_UNIT_MOJOM_BLINK_JUMBO_H_
#endif
namespace performance_manager {
namespace mojom {
namespace blink {
const char DocumentCoordinationUnit::Name_[] = "performance_manager.mojom.DocumentCoordinationUnit";

DocumentCoordinationUnitProxy::DocumentCoordinationUnitProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DocumentCoordinationUnitProxy::SetNetworkAlmostIdle(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "performance_manager::mojom::DocumentCoordinationUnit::SetNetworkAlmostIdle");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDocumentCoordinationUnit_SetNetworkAlmostIdle_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::performance_manager::mojom::internal::DocumentCoordinationUnit_SetNetworkAlmostIdle_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DocumentCoordinationUnit::Name_);
  message.set_method_name("SetNetworkAlmostIdle");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DocumentCoordinationUnitProxy::SetLifecycleState(
    ::performance_manager::mojom::blink::LifecycleState in_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "performance_manager::mojom::DocumentCoordinationUnit::SetLifecycleState", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("state", base::trace_event::ValueToString(in_state));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDocumentCoordinationUnit_SetLifecycleState_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::performance_manager::mojom::internal::DocumentCoordinationUnit_SetLifecycleState_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::performance_manager::mojom::LifecycleState>(
      in_state, &params->state);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DocumentCoordinationUnit::Name_);
  message.set_method_name("SetLifecycleState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DocumentCoordinationUnitProxy::SetHasNonEmptyBeforeUnload(
    bool in_has_nonempty_beforeunload) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "performance_manager::mojom::DocumentCoordinationUnit::SetHasNonEmptyBeforeUnload", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("has_nonempty_beforeunload", in_has_nonempty_beforeunload);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDocumentCoordinationUnit_SetHasNonEmptyBeforeUnload_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::performance_manager::mojom::internal::DocumentCoordinationUnit_SetHasNonEmptyBeforeUnload_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->has_nonempty_beforeunload = in_has_nonempty_beforeunload;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DocumentCoordinationUnit::Name_);
  message.set_method_name("SetHasNonEmptyBeforeUnload");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DocumentCoordinationUnitProxy::SetHadFormInteraction(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "performance_manager::mojom::DocumentCoordinationUnit::SetHadFormInteraction");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDocumentCoordinationUnit_SetHadFormInteraction_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::performance_manager::mojom::internal::DocumentCoordinationUnit_SetHadFormInteraction_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DocumentCoordinationUnit::Name_);
  message.set_method_name("SetHadFormInteraction");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DocumentCoordinationUnitProxy::SetOriginTrialFreezePolicy(
    InterventionPolicy in_policy) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "performance_manager::mojom::DocumentCoordinationUnit::SetOriginTrialFreezePolicy", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("policy", base::trace_event::ValueToString(in_policy));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDocumentCoordinationUnit_SetOriginTrialFreezePolicy_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::performance_manager::mojom::internal::DocumentCoordinationUnit_SetOriginTrialFreezePolicy_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::performance_manager::mojom::InterventionPolicy>(
      in_policy, &params->policy);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DocumentCoordinationUnit::Name_);
  message.set_method_name("SetOriginTrialFreezePolicy");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DocumentCoordinationUnitProxy::SetIsAdFrame(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "performance_manager::mojom::DocumentCoordinationUnit::SetIsAdFrame");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDocumentCoordinationUnit_SetIsAdFrame_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::performance_manager::mojom::internal::DocumentCoordinationUnit_SetIsAdFrame_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DocumentCoordinationUnit::Name_);
  message.set_method_name("SetIsAdFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DocumentCoordinationUnitProxy::OnNonPersistentNotificationCreated(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "performance_manager::mojom::DocumentCoordinationUnit::OnNonPersistentNotificationCreated");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDocumentCoordinationUnit_OnNonPersistentNotificationCreated_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::performance_manager::mojom::internal::DocumentCoordinationUnit_OnNonPersistentNotificationCreated_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DocumentCoordinationUnit::Name_);
  message.set_method_name("OnNonPersistentNotificationCreated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DocumentCoordinationUnitProxy::OnFirstContentfulPaint(
    ::base::TimeDelta in_time_since_navigation_start) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "performance_manager::mojom::DocumentCoordinationUnit::OnFirstContentfulPaint", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("time_since_navigation_start", base::trace_event::ValueToString(in_time_since_navigation_start, "<value of type ::base::TimeDelta>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDocumentCoordinationUnit_OnFirstContentfulPaint_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::performance_manager::mojom::internal::DocumentCoordinationUnit_OnFirstContentfulPaint_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->time_since_navigation_start)::BaseType::BufferWriter
      time_since_navigation_start_writer;
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_time_since_navigation_start, buffer, &time_since_navigation_start_writer, &serialization_context);
  params->time_since_navigation_start.Set(
      time_since_navigation_start_writer.is_null() ? nullptr : time_since_navigation_start_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->time_since_navigation_start.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null time_since_navigation_start in DocumentCoordinationUnit.OnFirstContentfulPaint request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DocumentCoordinationUnit::Name_);
  message.set_method_name("OnFirstContentfulPaint");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool DocumentCoordinationUnitStubDispatch::Accept(
    DocumentCoordinationUnit* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kDocumentCoordinationUnit_SetNetworkAlmostIdle_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)performance_manager::mojom::DocumentCoordinationUnit::SetNetworkAlmostIdle",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)performance_manager::mojom::DocumentCoordinationUnit::SetNetworkAlmostIdle");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DocumentCoordinationUnit_SetNetworkAlmostIdle_Params_Data* params =
          reinterpret_cast<internal::DocumentCoordinationUnit_SetNetworkAlmostIdle_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      DocumentCoordinationUnit_SetNetworkAlmostIdle_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DocumentCoordinationUnit::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetNetworkAlmostIdle();
      return true;
    }
    case internal::kDocumentCoordinationUnit_SetLifecycleState_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)performance_manager::mojom::DocumentCoordinationUnit::SetLifecycleState",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)performance_manager::mojom::DocumentCoordinationUnit::SetLifecycleState");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DocumentCoordinationUnit_SetLifecycleState_Params_Data* params =
          reinterpret_cast<internal::DocumentCoordinationUnit_SetLifecycleState_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::performance_manager::mojom::blink::LifecycleState p_state{};
      DocumentCoordinationUnit_SetLifecycleState_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadState(&p_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DocumentCoordinationUnit::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetLifecycleState(
std::move(p_state));
      return true;
    }
    case internal::kDocumentCoordinationUnit_SetHasNonEmptyBeforeUnload_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)performance_manager::mojom::DocumentCoordinationUnit::SetHasNonEmptyBeforeUnload",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)performance_manager::mojom::DocumentCoordinationUnit::SetHasNonEmptyBeforeUnload");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DocumentCoordinationUnit_SetHasNonEmptyBeforeUnload_Params_Data* params =
          reinterpret_cast<internal::DocumentCoordinationUnit_SetHasNonEmptyBeforeUnload_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_has_nonempty_beforeunload{};
      DocumentCoordinationUnit_SetHasNonEmptyBeforeUnload_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_has_nonempty_beforeunload = input_data_view.has_nonempty_beforeunload();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DocumentCoordinationUnit::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetHasNonEmptyBeforeUnload(
std::move(p_has_nonempty_beforeunload));
      return true;
    }
    case internal::kDocumentCoordinationUnit_SetHadFormInteraction_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)performance_manager::mojom::DocumentCoordinationUnit::SetHadFormInteraction",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)performance_manager::mojom::DocumentCoordinationUnit::SetHadFormInteraction");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DocumentCoordinationUnit_SetHadFormInteraction_Params_Data* params =
          reinterpret_cast<internal::DocumentCoordinationUnit_SetHadFormInteraction_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      DocumentCoordinationUnit_SetHadFormInteraction_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DocumentCoordinationUnit::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetHadFormInteraction();
      return true;
    }
    case internal::kDocumentCoordinationUnit_SetOriginTrialFreezePolicy_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)performance_manager::mojom::DocumentCoordinationUnit::SetOriginTrialFreezePolicy",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)performance_manager::mojom::DocumentCoordinationUnit::SetOriginTrialFreezePolicy");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DocumentCoordinationUnit_SetOriginTrialFreezePolicy_Params_Data* params =
          reinterpret_cast<internal::DocumentCoordinationUnit_SetOriginTrialFreezePolicy_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      InterventionPolicy p_policy{};
      DocumentCoordinationUnit_SetOriginTrialFreezePolicy_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadPolicy(&p_policy))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DocumentCoordinationUnit::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetOriginTrialFreezePolicy(
std::move(p_policy));
      return true;
    }
    case internal::kDocumentCoordinationUnit_SetIsAdFrame_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)performance_manager::mojom::DocumentCoordinationUnit::SetIsAdFrame",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)performance_manager::mojom::DocumentCoordinationUnit::SetIsAdFrame");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DocumentCoordinationUnit_SetIsAdFrame_Params_Data* params =
          reinterpret_cast<internal::DocumentCoordinationUnit_SetIsAdFrame_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      DocumentCoordinationUnit_SetIsAdFrame_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DocumentCoordinationUnit::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetIsAdFrame();
      return true;
    }
    case internal::kDocumentCoordinationUnit_OnNonPersistentNotificationCreated_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)performance_manager::mojom::DocumentCoordinationUnit::OnNonPersistentNotificationCreated",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)performance_manager::mojom::DocumentCoordinationUnit::OnNonPersistentNotificationCreated");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DocumentCoordinationUnit_OnNonPersistentNotificationCreated_Params_Data* params =
          reinterpret_cast<internal::DocumentCoordinationUnit_OnNonPersistentNotificationCreated_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      DocumentCoordinationUnit_OnNonPersistentNotificationCreated_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DocumentCoordinationUnit::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnNonPersistentNotificationCreated();
      return true;
    }
    case internal::kDocumentCoordinationUnit_OnFirstContentfulPaint_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)performance_manager::mojom::DocumentCoordinationUnit::OnFirstContentfulPaint",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)performance_manager::mojom::DocumentCoordinationUnit::OnFirstContentfulPaint");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DocumentCoordinationUnit_OnFirstContentfulPaint_Params_Data* params =
          reinterpret_cast<internal::DocumentCoordinationUnit_OnFirstContentfulPaint_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::TimeDelta p_time_since_navigation_start{};
      DocumentCoordinationUnit_OnFirstContentfulPaint_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadTimeSinceNavigationStart(&p_time_since_navigation_start))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DocumentCoordinationUnit::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFirstContentfulPaint(
std::move(p_time_since_navigation_start));
      return true;
    }
  }
  return false;
}

// static
bool DocumentCoordinationUnitStubDispatch::AcceptWithResponder(
    DocumentCoordinationUnit* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kDocumentCoordinationUnit_SetNetworkAlmostIdle_Name: {
      break;
    }
    case internal::kDocumentCoordinationUnit_SetLifecycleState_Name: {
      break;
    }
    case internal::kDocumentCoordinationUnit_SetHasNonEmptyBeforeUnload_Name: {
      break;
    }
    case internal::kDocumentCoordinationUnit_SetHadFormInteraction_Name: {
      break;
    }
    case internal::kDocumentCoordinationUnit_SetOriginTrialFreezePolicy_Name: {
      break;
    }
    case internal::kDocumentCoordinationUnit_SetIsAdFrame_Name: {
      break;
    }
    case internal::kDocumentCoordinationUnit_OnNonPersistentNotificationCreated_Name: {
      break;
    }
    case internal::kDocumentCoordinationUnit_OnFirstContentfulPaint_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kDocumentCoordinationUnitValidationInfo[] = {
    {internal::kDocumentCoordinationUnit_SetNetworkAlmostIdle_Name,
     {&internal::DocumentCoordinationUnit_SetNetworkAlmostIdle_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDocumentCoordinationUnit_SetLifecycleState_Name,
     {&internal::DocumentCoordinationUnit_SetLifecycleState_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDocumentCoordinationUnit_SetHasNonEmptyBeforeUnload_Name,
     {&internal::DocumentCoordinationUnit_SetHasNonEmptyBeforeUnload_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDocumentCoordinationUnit_SetHadFormInteraction_Name,
     {&internal::DocumentCoordinationUnit_SetHadFormInteraction_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDocumentCoordinationUnit_SetOriginTrialFreezePolicy_Name,
     {&internal::DocumentCoordinationUnit_SetOriginTrialFreezePolicy_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDocumentCoordinationUnit_SetIsAdFrame_Name,
     {&internal::DocumentCoordinationUnit_SetIsAdFrame_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDocumentCoordinationUnit_OnNonPersistentNotificationCreated_Name,
     {&internal::DocumentCoordinationUnit_OnNonPersistentNotificationCreated_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDocumentCoordinationUnit_OnFirstContentfulPaint_Name,
     {&internal::DocumentCoordinationUnit_OnFirstContentfulPaint_Params_Data::Validate,
      nullptr /* no response */}},
};

bool DocumentCoordinationUnitRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::performance_manager::mojom::blink::DocumentCoordinationUnit::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kDocumentCoordinationUnitValidationInfo);
}

const char ProcessCoordinationUnit::Name_[] = "performance_manager.mojom.ProcessCoordinationUnit";

ProcessCoordinationUnitProxy::ProcessCoordinationUnitProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ProcessCoordinationUnitProxy::SetMainThreadTaskLoadIsLow(
    bool in_main_thread_task_load_is_low) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "performance_manager::mojom::ProcessCoordinationUnit::SetMainThreadTaskLoadIsLow", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("main_thread_task_load_is_low", in_main_thread_task_load_is_low);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kProcessCoordinationUnit_SetMainThreadTaskLoadIsLow_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::performance_manager::mojom::internal::ProcessCoordinationUnit_SetMainThreadTaskLoadIsLow_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->main_thread_task_load_is_low = in_main_thread_task_load_is_low;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProcessCoordinationUnit::Name_);
  message.set_method_name("SetMainThreadTaskLoadIsLow");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool ProcessCoordinationUnitStubDispatch::Accept(
    ProcessCoordinationUnit* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kProcessCoordinationUnit_SetMainThreadTaskLoadIsLow_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)performance_manager::mojom::ProcessCoordinationUnit::SetMainThreadTaskLoadIsLow",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)performance_manager::mojom::ProcessCoordinationUnit::SetMainThreadTaskLoadIsLow");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ProcessCoordinationUnit_SetMainThreadTaskLoadIsLow_Params_Data* params =
          reinterpret_cast<internal::ProcessCoordinationUnit_SetMainThreadTaskLoadIsLow_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_main_thread_task_load_is_low{};
      ProcessCoordinationUnit_SetMainThreadTaskLoadIsLow_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_main_thread_task_load_is_low = input_data_view.main_thread_task_load_is_low();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProcessCoordinationUnit::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetMainThreadTaskLoadIsLow(
std::move(p_main_thread_task_load_is_low));
      return true;
    }
  }
  return false;
}

// static
bool ProcessCoordinationUnitStubDispatch::AcceptWithResponder(
    ProcessCoordinationUnit* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kProcessCoordinationUnit_SetMainThreadTaskLoadIsLow_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kProcessCoordinationUnitValidationInfo[] = {
    {internal::kProcessCoordinationUnit_SetMainThreadTaskLoadIsLow_Name,
     {&internal::ProcessCoordinationUnit_SetMainThreadTaskLoadIsLow_Params_Data::Validate,
      nullptr /* no response */}},
};

bool ProcessCoordinationUnitRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::performance_manager::mojom::blink::ProcessCoordinationUnit::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kProcessCoordinationUnitValidationInfo);
}

}  // namespace blink
}  // namespace mojom
}  // namespace performance_manager

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif