// components/services/app_service/public/mojom/types.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_APP_SERVICE_PUBLIC_MOJOM_TYPES_MOJOM_SHARED_H_
#define COMPONENTS_SERVICES_APP_SERVICE_PUBLIC_MOJOM_TYPES_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "components/services/app_service/public/mojom/types.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "ui/gfx/image/mojom/image.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"






namespace apps {
namespace mojom {
class AppDataView;

class PermissionDataView;

class IconKeyDataView;

class IconValueDataView;

class MenuItemsDataView;

class MenuItemDataView;

class ConditionValueDataView;

class ConditionDataView;

class IntentFilterDataView;

class IntentDataView;

class ReplacedAppPreferencesDataView;

class PreferredAppDataView;

class FilePathsDataView;



}  // namespace mojom
}  // namespace apps

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::apps::mojom::AppDataView> {
  using Data = ::apps::mojom::internal::App_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::apps::mojom::PermissionDataView> {
  using Data = ::apps::mojom::internal::Permission_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::apps::mojom::IconKeyDataView> {
  using Data = ::apps::mojom::internal::IconKey_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::apps::mojom::IconValueDataView> {
  using Data = ::apps::mojom::internal::IconValue_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::apps::mojom::MenuItemsDataView> {
  using Data = ::apps::mojom::internal::MenuItems_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::apps::mojom::MenuItemDataView> {
  using Data = ::apps::mojom::internal::MenuItem_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::apps::mojom::ConditionValueDataView> {
  using Data = ::apps::mojom::internal::ConditionValue_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::apps::mojom::ConditionDataView> {
  using Data = ::apps::mojom::internal::Condition_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::apps::mojom::IntentFilterDataView> {
  using Data = ::apps::mojom::internal::IntentFilter_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::apps::mojom::IntentDataView> {
  using Data = ::apps::mojom::internal::Intent_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::apps::mojom::ReplacedAppPreferencesDataView> {
  using Data = ::apps::mojom::internal::ReplacedAppPreferences_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::apps::mojom::PreferredAppDataView> {
  using Data = ::apps::mojom::internal::PreferredApp_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::apps::mojom::FilePathsDataView> {
  using Data = ::apps::mojom::internal::FilePaths_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace apps {
namespace mojom {


enum class AppType : int32_t {
  
  kUnknown = 0,
  
  kArc = 1,
  
  kBuiltIn = 2,
  
  kCrostini = 3,
  
  kExtension = 4,
  
  kWeb = 5,
  
  kMacNative = 6,
  
  kPluginVm = 7,
  
  kLacros = 8,
  
  kRemote = 9,
  
  kBorealis = 10,
  kMinValue = 0,
  kMaxValue = 10,
};

 std::ostream& operator<<(std::ostream& os, AppType value);
inline bool IsKnownEnumValue(AppType value) {
  return internal::AppType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class Readiness : int32_t {
  
  kUnknown = 0,
  
  kReady = 1,
  
  kDisabledByBlocklist = 2,
  
  kDisabledByPolicy = 3,
  
  kDisabledByUser = 4,
  
  kTerminated = 5,
  
  kUninstalledByUser = 6,
  kMinValue = 0,
  kMaxValue = 6,
};

 std::ostream& operator<<(std::ostream& os, Readiness value);
inline bool IsKnownEnumValue(Readiness value) {
  return internal::Readiness_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class InstallSource : int32_t {
  
  kUnknown = 0,
  
  kSystem = 1,
  
  kPolicy = 2,
  
  kOem = 3,
  
  kDefault = 4,
  
  kSync = 5,
  
  kUser = 6,
  kMinValue = 0,
  kMaxValue = 6,
};

 std::ostream& operator<<(std::ostream& os, InstallSource value);
inline bool IsKnownEnumValue(InstallSource value) {
  return internal::InstallSource_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class UninstallSource : int32_t {
  
  kUnknown = 0,
  
  kUser = 1,
  
  kMigration = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, UninstallSource value);
inline bool IsKnownEnumValue(UninstallSource value) {
  return internal::UninstallSource_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class OptionalBool : int32_t {
  
  kUnknown = 0,
  
  kFalse = 1,
  
  kTrue = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, OptionalBool value);
inline bool IsKnownEnumValue(OptionalBool value) {
  return internal::OptionalBool_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class IconType : int32_t {
  
  kUnknown = 0,
  
  kUncompressed = 1,
  
  kCompressed = 2,
  
  kStandard = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, IconType value);
inline bool IsKnownEnumValue(IconType value) {
  return internal::IconType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class LaunchSource : int32_t {
  
  kUnknown = 0,
  
  kFromAppListGrid = 1,
  
  kFromAppListGridContextMenu = 2,
  
  kFromAppListQuery = 3,
  
  kFromAppListQueryContextMenu = 4,
  
  kFromAppListRecommendation = 5,
  
  kFromParentalControls = 6,
  
  kFromShelf = 7,
  
  kFromFileManager = 8,
  
  kFromLink = 9,
  
  kFromOmnibox = 10,
  
  kFromChromeInternal = 11,
  
  kFromKeyboard = 12,
  
  kFromOtherApp = 13,
  
  kFromMenu = 14,
  
  kFromInstalledNotification = 15,
  
  kFromTest = 16,
  
  kFromArc = 17,
  
  kFromSharesheet = 18,
  
  kFromReleaseNotesNotification = 19,
  kMinValue = 0,
  kMaxValue = 19,
};

 std::ostream& operator<<(std::ostream& os, LaunchSource value);
inline bool IsKnownEnumValue(LaunchSource value) {
  return internal::LaunchSource_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class TriState : int32_t {
  
  kAllow = 0,
  
  kBlock = 1,
  
  kAsk = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, TriState value);
inline bool IsKnownEnumValue(TriState value) {
  return internal::TriState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class PermissionValueType : int32_t {
  
  kBool = 0,
  
  kTriState = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, PermissionValueType value);
inline bool IsKnownEnumValue(PermissionValueType value) {
  return internal::PermissionValueType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class MenuItemType : int32_t {
  
  kCommand = 0,
  
  kRadio = 1,
  
  kSeparator = 2,
  
  kSubmenu = 3,
  
  kArcCommand = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

 std::ostream& operator<<(std::ostream& os, MenuItemType value);
inline bool IsKnownEnumValue(MenuItemType value) {
  return internal::MenuItemType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class MenuType : int32_t {
  
  kAppList = 0,
  
  kShelf = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, MenuType value);
inline bool IsKnownEnumValue(MenuType value) {
  return internal::MenuType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ConditionType : int32_t {
  
  kScheme = 0,
  
  kHost = 1,
  
  kPattern = 2,
  
  kAction = 3,
  
  kMimeType = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

 std::ostream& operator<<(std::ostream& os, ConditionType value);
inline bool IsKnownEnumValue(ConditionType value) {
  return internal::ConditionType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class PatternMatchType : int32_t {
  
  kNone = 0,
  
  kLiteral = 1,
  
  kPrefix = 2,
  
  kGlob = 3,
  
  kMimeType = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

 std::ostream& operator<<(std::ostream& os, PatternMatchType value);
inline bool IsKnownEnumValue(PatternMatchType value) {
  return internal::PatternMatchType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class AppLaunchSource : int32_t {
  
  kSourceNone = 0,
  
  kSourceUntracked = 1,
  
  kSourceAppLauncher = 2,
  
  kSourceNewTabPage = 3,
  
  kSourceReload = 4,
  
  kSourceRestart = 5,
  
  kSourceLoadAndLaunch = 6,
  
  kSourceCommandLine = 7,
  
  kSourceFileHandler = 8,
  
  kSourceUrlHandler = 9,
  
  kSourceSystemTray = 10,
  
  kSourceAboutPage = 11,
  
  kSourceKeyboard = 12,
  
  kSourceExtensionsPage = 13,
  
  kSourceManagementApi = 14,
  
  kSourceEphemeralAppDeprecated = 15,
  
  kSourceBackground = 16,
  
  kSourceKiosk = 17,
  
  kSourceChromeInternal = 18,
  
  kSourceTest = 19,
  
  kSourceInstalledNotification = 20,
  
  kSourceContextMenu = 21,
  
  kSourceArc = 22,
  
  kSourceIntentUrl = 23,
  kMinValue = 0,
  kMaxValue = 23,
};

 std::ostream& operator<<(std::ostream& os, AppLaunchSource value);
inline bool IsKnownEnumValue(AppLaunchSource value) {
  return internal::AppLaunchSource_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class LaunchContainer : int32_t {
  
  kLaunchContainerWindow = 0,
  
  kLaunchContainerPanelDeprecated = 1,
  
  kLaunchContainerTab = 2,
  
  kLaunchContainerNone = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, LaunchContainer value);
inline bool IsKnownEnumValue(LaunchContainer value) {
  return internal::LaunchContainer_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class AppDataView {
 public:
  AppDataView() {}

  AppDataView(
      internal::App_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadAppType(UserType* output) const {
    auto data_value = data_->app_type;
    return mojo::internal::Deserialize<::apps::mojom::AppType>(
        data_value, output);
  }

  AppType app_type() const {
    return static_cast<AppType>(data_->app_type);
  }
  inline void GetAppIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadAppId(UserType* output) {
    
    auto* pointer = data_->app_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadReadiness(UserType* output) const {
    auto data_value = data_->readiness;
    return mojo::internal::Deserialize<::apps::mojom::Readiness>(
        data_value, output);
  }

  Readiness readiness() const {
    return static_cast<Readiness>(data_->readiness);
  }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadName` instead "
    "of `ReadName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetShortNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadShortName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `short_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadShortName` instead "
    "of `ReadShortName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->short_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetPublisherIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPublisherId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `publisher_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPublisherId` instead "
    "of `ReadPublisherId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->publisher_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetDescriptionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDescription(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `description` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDescription` instead "
    "of `ReadDescription if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->description.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetVersionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadVersion(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `version` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadVersion` instead "
    "of `ReadVersion if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->version.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetAdditionalSearchTermsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadAdditionalSearchTerms(UserType* output) {
    
    auto* pointer = data_->additional_search_terms.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, context_);
  }
  inline void GetIconKeyDataView(
      IconKeyDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadIconKey(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::apps::mojom::IconKeyDataView, UserType>(),
    "Attempting to read the optional `icon_key` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadIconKey` instead "
    "of `ReadIconKey if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->icon_key.Get();
    return mojo::internal::Deserialize<::apps::mojom::IconKeyDataView>(
        pointer, output, context_);
  }
  inline void GetLastLaunchTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadLastLaunchTime(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDataView, UserType>(),
    "Attempting to read the optional `last_launch_time` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLastLaunchTime` instead "
    "of `ReadLastLaunchTime if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->last_launch_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, context_);
  }
  inline void GetInstallTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadInstallTime(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDataView, UserType>(),
    "Attempting to read the optional `install_time` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInstallTime` instead "
    "of `ReadInstallTime if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->install_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, context_);
  }
  inline void GetPermissionsDataView(
      mojo::ArrayDataView<PermissionDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPermissions(UserType* output) {
    
    auto* pointer = data_->permissions.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::apps::mojom::PermissionDataView>>(
        pointer, output, context_);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadInstallSource(UserType* output) const {
    auto data_value = data_->install_source;
    return mojo::internal::Deserialize<::apps::mojom::InstallSource>(
        data_value, output);
  }

  InstallSource install_source() const {
    return static_cast<InstallSource>(data_->install_source);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadIsPlatformApp(UserType* output) const {
    auto data_value = data_->is_platform_app;
    return mojo::internal::Deserialize<::apps::mojom::OptionalBool>(
        data_value, output);
  }

  OptionalBool is_platform_app() const {
    return static_cast<OptionalBool>(data_->is_platform_app);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRecommendable(UserType* output) const {
    auto data_value = data_->recommendable;
    return mojo::internal::Deserialize<::apps::mojom::OptionalBool>(
        data_value, output);
  }

  OptionalBool recommendable() const {
    return static_cast<OptionalBool>(data_->recommendable);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSearchable(UserType* output) const {
    auto data_value = data_->searchable;
    return mojo::internal::Deserialize<::apps::mojom::OptionalBool>(
        data_value, output);
  }

  OptionalBool searchable() const {
    return static_cast<OptionalBool>(data_->searchable);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadShowInLauncher(UserType* output) const {
    auto data_value = data_->show_in_launcher;
    return mojo::internal::Deserialize<::apps::mojom::OptionalBool>(
        data_value, output);
  }

  OptionalBool show_in_launcher() const {
    return static_cast<OptionalBool>(data_->show_in_launcher);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadShowInShelf(UserType* output) const {
    auto data_value = data_->show_in_shelf;
    return mojo::internal::Deserialize<::apps::mojom::OptionalBool>(
        data_value, output);
  }

  OptionalBool show_in_shelf() const {
    return static_cast<OptionalBool>(data_->show_in_shelf);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadShowInSearch(UserType* output) const {
    auto data_value = data_->show_in_search;
    return mojo::internal::Deserialize<::apps::mojom::OptionalBool>(
        data_value, output);
  }

  OptionalBool show_in_search() const {
    return static_cast<OptionalBool>(data_->show_in_search);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadShowInManagement(UserType* output) const {
    auto data_value = data_->show_in_management;
    return mojo::internal::Deserialize<::apps::mojom::OptionalBool>(
        data_value, output);
  }

  OptionalBool show_in_management() const {
    return static_cast<OptionalBool>(data_->show_in_management);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadHasBadge(UserType* output) const {
    auto data_value = data_->has_badge;
    return mojo::internal::Deserialize<::apps::mojom::OptionalBool>(
        data_value, output);
  }

  OptionalBool has_badge() const {
    return static_cast<OptionalBool>(data_->has_badge);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPaused(UserType* output) const {
    auto data_value = data_->paused;
    return mojo::internal::Deserialize<::apps::mojom::OptionalBool>(
        data_value, output);
  }

  OptionalBool paused() const {
    return static_cast<OptionalBool>(data_->paused);
  }
  inline void GetIntentFiltersDataView(
      mojo::ArrayDataView<IntentFilterDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadIntentFilters(UserType* output) {
    
    auto* pointer = data_->intent_filters.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::apps::mojom::IntentFilterDataView>>(
        pointer, output, context_);
  }
 private:
  internal::App_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class PermissionDataView {
 public:
  PermissionDataView() {}

  PermissionDataView(
      internal::Permission_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t permission_id() const {
    return data_->permission_id;
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadValueType(UserType* output) const {
    auto data_value = data_->value_type;
    return mojo::internal::Deserialize<::apps::mojom::PermissionValueType>(
        data_value, output);
  }

  PermissionValueType value_type() const {
    return static_cast<PermissionValueType>(data_->value_type);
  }
  uint32_t value() const {
    return data_->value;
  }
  bool is_managed() const {
    return data_->is_managed;
  }
 private:
  internal::Permission_Data* data_ = nullptr;
};



class IconKeyDataView {
 public:
  IconKeyDataView() {}

  IconKeyDataView(
      internal::IconKey_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint64_t timeline() const {
    return data_->timeline;
  }
  int32_t resource_id() const {
    return data_->resource_id;
  }
  uint32_t icon_effects() const {
    return data_->icon_effects;
  }
 private:
  internal::IconKey_Data* data_ = nullptr;
};



class IconValueDataView {
 public:
  IconValueDataView() {}

  IconValueDataView(
      internal::IconValue_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadIconType(UserType* output) const {
    auto data_value = data_->icon_type;
    return mojo::internal::Deserialize<::apps::mojom::IconType>(
        data_value, output);
  }

  IconType icon_type() const {
    return static_cast<IconType>(data_->icon_type);
  }
  inline void GetUncompressedDataView(
      ::gfx::mojom::ImageSkiaDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadUncompressed(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::ImageSkiaDataView, UserType>(),
    "Attempting to read the optional `uncompressed` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUncompressed` instead "
    "of `ReadUncompressed if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->uncompressed.Get();
    return mojo::internal::Deserialize<::gfx::mojom::ImageSkiaDataView>(
        pointer, output, context_);
  }
  inline void GetCompressedDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadCompressed(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<uint8_t>, UserType>(),
    "Attempting to read the optional `compressed` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCompressed` instead "
    "of `ReadCompressed if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->compressed.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, context_);
  }
  bool is_placeholder_icon() const {
    return data_->is_placeholder_icon;
  }
 private:
  internal::IconValue_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class MenuItemsDataView {
 public:
  MenuItemsDataView() {}

  MenuItemsDataView(
      internal::MenuItems_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetItemsDataView(
      mojo::ArrayDataView<MenuItemDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadItems(UserType* output) {
    
    auto* pointer = data_->items.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::apps::mojom::MenuItemDataView>>(
        pointer, output, context_);
  }
 private:
  internal::MenuItems_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class MenuItemDataView {
 public:
  MenuItemDataView() {}

  MenuItemDataView(
      internal::MenuItem_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::apps::mojom::MenuItemType>(
        data_value, output);
  }

  MenuItemType type() const {
    return static_cast<MenuItemType>(data_->type);
  }
  int32_t command_id() const {
    return data_->command_id;
  }
  int32_t string_id() const {
    return data_->string_id;
  }
  inline void GetSubmenuDataView(
      mojo::ArrayDataView<MenuItemDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSubmenu(UserType* output) {
    
    auto* pointer = data_->submenu.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::apps::mojom::MenuItemDataView>>(
        pointer, output, context_);
  }
  int32_t radio_group_id() const {
    return data_->radio_group_id;
  }
  inline void GetShortcutIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadShortcutId(UserType* output) {
    
    auto* pointer = data_->shortcut_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetImageDataView(
      ::gfx::mojom::ImageSkiaDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadImage(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::ImageSkiaDataView, UserType>(),
    "Attempting to read the optional `image` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadImage` instead "
    "of `ReadImage if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->image.Get();
    return mojo::internal::Deserialize<::gfx::mojom::ImageSkiaDataView>(
        pointer, output, context_);
  }
 private:
  internal::MenuItem_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class ConditionValueDataView {
 public:
  ConditionValueDataView() {}

  ConditionValueDataView(
      internal::ConditionValue_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetValueDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadValue(UserType* output) {
    
    auto* pointer = data_->value.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadMatchType(UserType* output) const {
    auto data_value = data_->match_type;
    return mojo::internal::Deserialize<::apps::mojom::PatternMatchType>(
        data_value, output);
  }

  PatternMatchType match_type() const {
    return static_cast<PatternMatchType>(data_->match_type);
  }
 private:
  internal::ConditionValue_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class ConditionDataView {
 public:
  ConditionDataView() {}

  ConditionDataView(
      internal::Condition_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadConditionType(UserType* output) const {
    auto data_value = data_->condition_type;
    return mojo::internal::Deserialize<::apps::mojom::ConditionType>(
        data_value, output);
  }

  ConditionType condition_type() const {
    return static_cast<ConditionType>(data_->condition_type);
  }
  inline void GetConditionValuesDataView(
      mojo::ArrayDataView<ConditionValueDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadConditionValues(UserType* output) {
    
    auto* pointer = data_->condition_values.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::apps::mojom::ConditionValueDataView>>(
        pointer, output, context_);
  }
 private:
  internal::Condition_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class IntentFilterDataView {
 public:
  IntentFilterDataView() {}

  IntentFilterDataView(
      internal::IntentFilter_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetConditionsDataView(
      mojo::ArrayDataView<ConditionDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadConditions(UserType* output) {
    
    auto* pointer = data_->conditions.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::apps::mojom::ConditionDataView>>(
        pointer, output, context_);
  }
  inline void GetActivityNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadActivityName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `activity_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadActivityName` instead "
    "of `ReadActivityName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->activity_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetActivityLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadActivityLabel(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `activity_label` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadActivityLabel` instead "
    "of `ReadActivityLabel if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->activity_label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
 private:
  internal::IntentFilter_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class IntentDataView {
 public:
  IntentDataView() {}

  IntentDataView(
      internal::Intent_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetActionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadAction(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `action` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAction` instead "
    "of `ReadAction if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->action.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUrl` instead "
    "of `ReadUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
  inline void GetMimeTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadMimeType(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `mime_type` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMimeType` instead "
    "of `ReadMimeType if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->mime_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetFileUrlsDataView(
      mojo::ArrayDataView<::url::mojom::UrlDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadFileUrls(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::url::mojom::UrlDataView>, UserType>(),
    "Attempting to read the optional `file_urls` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFileUrls` instead "
    "of `ReadFileUrls if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->file_urls.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
        pointer, output, context_);
  }
  inline void GetActivityNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadActivityName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `activity_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadActivityName` instead "
    "of `ReadActivityName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->activity_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetDriveShareUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDriveShareUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `drive_share_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDriveShareUrl` instead "
    "of `ReadDriveShareUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->drive_share_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
  inline void GetShareTextDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadShareText(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `share_text` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadShareText` instead "
    "of `ReadShareText if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->share_text.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
 private:
  internal::Intent_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class ReplacedAppPreferencesDataView {
 public:
  ReplacedAppPreferencesDataView() {}

  ReplacedAppPreferencesDataView(
      internal::ReplacedAppPreferences_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetReplacedPreferenceDataView(
      mojo::MapDataView<mojo::StringDataView, mojo::ArrayDataView<IntentFilterDataView>>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadReplacedPreference(UserType* output) {
    
    auto* pointer = data_->replaced_preference.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, mojo::ArrayDataView<::apps::mojom::IntentFilterDataView>>>(
        pointer, output, context_);
  }
 private:
  internal::ReplacedAppPreferences_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class PreferredAppDataView {
 public:
  PreferredAppDataView() {}

  PreferredAppDataView(
      internal::PreferredApp_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetIntentFilterDataView(
      IntentFilterDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadIntentFilter(UserType* output) {
    
    auto* pointer = data_->intent_filter.Get();
    return mojo::internal::Deserialize<::apps::mojom::IntentFilterDataView>(
        pointer, output, context_);
  }
  inline void GetAppIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadAppId(UserType* output) {
    
    auto* pointer = data_->app_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
 private:
  internal::PreferredApp_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class FilePathsDataView {
 public:
  FilePathsDataView() {}

  FilePathsDataView(
      internal::FilePaths_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetFilePathsDataView(
      mojo::ArrayDataView<::mojo_base::mojom::FilePathDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadFilePaths(UserType* output) {
    
    auto* pointer = data_->file_paths.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojo_base::mojom::FilePathDataView>>(
        pointer, output, context_);
  }
 private:
  internal::FilePaths_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace apps

namespace std {

template <>
struct hash<::apps::mojom::AppType>
    : public mojo::internal::EnumHashImpl<::apps::mojom::AppType> {};

template <>
struct hash<::apps::mojom::Readiness>
    : public mojo::internal::EnumHashImpl<::apps::mojom::Readiness> {};

template <>
struct hash<::apps::mojom::InstallSource>
    : public mojo::internal::EnumHashImpl<::apps::mojom::InstallSource> {};

template <>
struct hash<::apps::mojom::UninstallSource>
    : public mojo::internal::EnumHashImpl<::apps::mojom::UninstallSource> {};

template <>
struct hash<::apps::mojom::OptionalBool>
    : public mojo::internal::EnumHashImpl<::apps::mojom::OptionalBool> {};

template <>
struct hash<::apps::mojom::IconType>
    : public mojo::internal::EnumHashImpl<::apps::mojom::IconType> {};

template <>
struct hash<::apps::mojom::LaunchSource>
    : public mojo::internal::EnumHashImpl<::apps::mojom::LaunchSource> {};

template <>
struct hash<::apps::mojom::TriState>
    : public mojo::internal::EnumHashImpl<::apps::mojom::TriState> {};

template <>
struct hash<::apps::mojom::PermissionValueType>
    : public mojo::internal::EnumHashImpl<::apps::mojom::PermissionValueType> {};

template <>
struct hash<::apps::mojom::MenuItemType>
    : public mojo::internal::EnumHashImpl<::apps::mojom::MenuItemType> {};

template <>
struct hash<::apps::mojom::MenuType>
    : public mojo::internal::EnumHashImpl<::apps::mojom::MenuType> {};

template <>
struct hash<::apps::mojom::ConditionType>
    : public mojo::internal::EnumHashImpl<::apps::mojom::ConditionType> {};

template <>
struct hash<::apps::mojom::PatternMatchType>
    : public mojo::internal::EnumHashImpl<::apps::mojom::PatternMatchType> {};

template <>
struct hash<::apps::mojom::AppLaunchSource>
    : public mojo::internal::EnumHashImpl<::apps::mojom::AppLaunchSource> {};

template <>
struct hash<::apps::mojom::LaunchContainer>
    : public mojo::internal::EnumHashImpl<::apps::mojom::LaunchContainer> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::apps::mojom::AppType, ::apps::mojom::AppType> {
  static ::apps::mojom::AppType ToMojom(::apps::mojom::AppType input) { return input; }
  static bool FromMojom(::apps::mojom::AppType input, ::apps::mojom::AppType* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::apps::mojom::AppType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::apps::mojom::AppType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::apps::mojom::AppType>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::apps::mojom::Readiness, ::apps::mojom::Readiness> {
  static ::apps::mojom::Readiness ToMojom(::apps::mojom::Readiness input) { return input; }
  static bool FromMojom(::apps::mojom::Readiness input, ::apps::mojom::Readiness* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::apps::mojom::Readiness, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::apps::mojom::Readiness, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::apps::mojom::Readiness>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::apps::mojom::InstallSource, ::apps::mojom::InstallSource> {
  static ::apps::mojom::InstallSource ToMojom(::apps::mojom::InstallSource input) { return input; }
  static bool FromMojom(::apps::mojom::InstallSource input, ::apps::mojom::InstallSource* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::apps::mojom::InstallSource, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::apps::mojom::InstallSource, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::apps::mojom::InstallSource>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::apps::mojom::UninstallSource, ::apps::mojom::UninstallSource> {
  static ::apps::mojom::UninstallSource ToMojom(::apps::mojom::UninstallSource input) { return input; }
  static bool FromMojom(::apps::mojom::UninstallSource input, ::apps::mojom::UninstallSource* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::apps::mojom::UninstallSource, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::apps::mojom::UninstallSource, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::apps::mojom::UninstallSource>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::apps::mojom::OptionalBool, ::apps::mojom::OptionalBool> {
  static ::apps::mojom::OptionalBool ToMojom(::apps::mojom::OptionalBool input) { return input; }
  static bool FromMojom(::apps::mojom::OptionalBool input, ::apps::mojom::OptionalBool* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::apps::mojom::OptionalBool, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::apps::mojom::OptionalBool, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::apps::mojom::OptionalBool>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::apps::mojom::IconType, ::apps::mojom::IconType> {
  static ::apps::mojom::IconType ToMojom(::apps::mojom::IconType input) { return input; }
  static bool FromMojom(::apps::mojom::IconType input, ::apps::mojom::IconType* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::apps::mojom::IconType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::apps::mojom::IconType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::apps::mojom::IconType>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::apps::mojom::LaunchSource, ::apps::mojom::LaunchSource> {
  static ::apps::mojom::LaunchSource ToMojom(::apps::mojom::LaunchSource input) { return input; }
  static bool FromMojom(::apps::mojom::LaunchSource input, ::apps::mojom::LaunchSource* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::apps::mojom::LaunchSource, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::apps::mojom::LaunchSource, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::apps::mojom::LaunchSource>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::apps::mojom::TriState, ::apps::mojom::TriState> {
  static ::apps::mojom::TriState ToMojom(::apps::mojom::TriState input) { return input; }
  static bool FromMojom(::apps::mojom::TriState input, ::apps::mojom::TriState* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::apps::mojom::TriState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::apps::mojom::TriState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::apps::mojom::TriState>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::apps::mojom::PermissionValueType, ::apps::mojom::PermissionValueType> {
  static ::apps::mojom::PermissionValueType ToMojom(::apps::mojom::PermissionValueType input) { return input; }
  static bool FromMojom(::apps::mojom::PermissionValueType input, ::apps::mojom::PermissionValueType* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::apps::mojom::PermissionValueType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::apps::mojom::PermissionValueType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::apps::mojom::PermissionValueType>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::apps::mojom::MenuItemType, ::apps::mojom::MenuItemType> {
  static ::apps::mojom::MenuItemType ToMojom(::apps::mojom::MenuItemType input) { return input; }
  static bool FromMojom(::apps::mojom::MenuItemType input, ::apps::mojom::MenuItemType* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::apps::mojom::MenuItemType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::apps::mojom::MenuItemType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::apps::mojom::MenuItemType>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::apps::mojom::MenuType, ::apps::mojom::MenuType> {
  static ::apps::mojom::MenuType ToMojom(::apps::mojom::MenuType input) { return input; }
  static bool FromMojom(::apps::mojom::MenuType input, ::apps::mojom::MenuType* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::apps::mojom::MenuType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::apps::mojom::MenuType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::apps::mojom::MenuType>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::apps::mojom::ConditionType, ::apps::mojom::ConditionType> {
  static ::apps::mojom::ConditionType ToMojom(::apps::mojom::ConditionType input) { return input; }
  static bool FromMojom(::apps::mojom::ConditionType input, ::apps::mojom::ConditionType* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::apps::mojom::ConditionType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::apps::mojom::ConditionType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::apps::mojom::ConditionType>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::apps::mojom::PatternMatchType, ::apps::mojom::PatternMatchType> {
  static ::apps::mojom::PatternMatchType ToMojom(::apps::mojom::PatternMatchType input) { return input; }
  static bool FromMojom(::apps::mojom::PatternMatchType input, ::apps::mojom::PatternMatchType* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::apps::mojom::PatternMatchType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::apps::mojom::PatternMatchType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::apps::mojom::PatternMatchType>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::apps::mojom::AppLaunchSource, ::apps::mojom::AppLaunchSource> {
  static ::apps::mojom::AppLaunchSource ToMojom(::apps::mojom::AppLaunchSource input) { return input; }
  static bool FromMojom(::apps::mojom::AppLaunchSource input, ::apps::mojom::AppLaunchSource* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::apps::mojom::AppLaunchSource, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::apps::mojom::AppLaunchSource, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::apps::mojom::AppLaunchSource>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::apps::mojom::LaunchContainer, ::apps::mojom::LaunchContainer> {
  static ::apps::mojom::LaunchContainer ToMojom(::apps::mojom::LaunchContainer input) { return input; }
  static bool FromMojom(::apps::mojom::LaunchContainer input, ::apps::mojom::LaunchContainer* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::apps::mojom::LaunchContainer, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::apps::mojom::LaunchContainer, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::apps::mojom::LaunchContainer>(input), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::apps::mojom::AppDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::apps::mojom::AppDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::apps::mojom::internal::App_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    mojo::internal::Serialize<::apps::mojom::AppType>(
        Traits::app_type(input), &(*output)->app_type);
    decltype(Traits::app_id(input)) in_app_id = Traits::app_id(input);
    typename decltype((*output)->app_id)::BaseType::BufferWriter
        app_id_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_app_id, buffer, &app_id_writer, context);
    (*output)->app_id.Set(
        app_id_writer.is_null() ? nullptr : app_id_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->app_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null app_id in App struct");
    mojo::internal::Serialize<::apps::mojom::Readiness>(
        Traits::readiness(input), &(*output)->readiness);
    decltype(Traits::name(input)) in_name = Traits::name(input);
    typename decltype((*output)->name)::BaseType::BufferWriter
        name_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_name, buffer, &name_writer, context);
    (*output)->name.Set(
        name_writer.is_null() ? nullptr : name_writer.data());
    decltype(Traits::short_name(input)) in_short_name = Traits::short_name(input);
    typename decltype((*output)->short_name)::BaseType::BufferWriter
        short_name_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_short_name, buffer, &short_name_writer, context);
    (*output)->short_name.Set(
        short_name_writer.is_null() ? nullptr : short_name_writer.data());
    decltype(Traits::publisher_id(input)) in_publisher_id = Traits::publisher_id(input);
    typename decltype((*output)->publisher_id)::BaseType::BufferWriter
        publisher_id_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_publisher_id, buffer, &publisher_id_writer, context);
    (*output)->publisher_id.Set(
        publisher_id_writer.is_null() ? nullptr : publisher_id_writer.data());
    decltype(Traits::description(input)) in_description = Traits::description(input);
    typename decltype((*output)->description)::BaseType::BufferWriter
        description_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_description, buffer, &description_writer, context);
    (*output)->description.Set(
        description_writer.is_null() ? nullptr : description_writer.data());
    decltype(Traits::version(input)) in_version = Traits::version(input);
    typename decltype((*output)->version)::BaseType::BufferWriter
        version_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_version, buffer, &version_writer, context);
    (*output)->version.Set(
        version_writer.is_null() ? nullptr : version_writer.data());
    decltype(Traits::additional_search_terms(input)) in_additional_search_terms = Traits::additional_search_terms(input);
    typename decltype((*output)->additional_search_terms)::BaseType::BufferWriter
        additional_search_terms_writer;
    const mojo::internal::ContainerValidateParams additional_search_terms_validate_params(
        0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
        in_additional_search_terms, buffer, &additional_search_terms_writer, &additional_search_terms_validate_params,
        context);
    (*output)->additional_search_terms.Set(
        additional_search_terms_writer.is_null() ? nullptr : additional_search_terms_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->additional_search_terms.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null additional_search_terms in App struct");
    decltype(Traits::icon_key(input)) in_icon_key = Traits::icon_key(input);
    typename decltype((*output)->icon_key)::BaseType::BufferWriter
        icon_key_writer;
    mojo::internal::Serialize<::apps::mojom::IconKeyDataView>(
        in_icon_key, buffer, &icon_key_writer, context);
    (*output)->icon_key.Set(
        icon_key_writer.is_null() ? nullptr : icon_key_writer.data());
    decltype(Traits::last_launch_time(input)) in_last_launch_time = Traits::last_launch_time(input);
    typename decltype((*output)->last_launch_time)::BaseType::BufferWriter
        last_launch_time_writer;
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
        in_last_launch_time, buffer, &last_launch_time_writer, context);
    (*output)->last_launch_time.Set(
        last_launch_time_writer.is_null() ? nullptr : last_launch_time_writer.data());
    decltype(Traits::install_time(input)) in_install_time = Traits::install_time(input);
    typename decltype((*output)->install_time)::BaseType::BufferWriter
        install_time_writer;
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
        in_install_time, buffer, &install_time_writer, context);
    (*output)->install_time.Set(
        install_time_writer.is_null() ? nullptr : install_time_writer.data());
    decltype(Traits::permissions(input)) in_permissions = Traits::permissions(input);
    typename decltype((*output)->permissions)::BaseType::BufferWriter
        permissions_writer;
    const mojo::internal::ContainerValidateParams permissions_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::apps::mojom::PermissionDataView>>(
        in_permissions, buffer, &permissions_writer, &permissions_validate_params,
        context);
    (*output)->permissions.Set(
        permissions_writer.is_null() ? nullptr : permissions_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->permissions.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null permissions in App struct");
    mojo::internal::Serialize<::apps::mojom::InstallSource>(
        Traits::install_source(input), &(*output)->install_source);
    mojo::internal::Serialize<::apps::mojom::OptionalBool>(
        Traits::is_platform_app(input), &(*output)->is_platform_app);
    mojo::internal::Serialize<::apps::mojom::OptionalBool>(
        Traits::recommendable(input), &(*output)->recommendable);
    mojo::internal::Serialize<::apps::mojom::OptionalBool>(
        Traits::searchable(input), &(*output)->searchable);
    mojo::internal::Serialize<::apps::mojom::OptionalBool>(
        Traits::show_in_launcher(input), &(*output)->show_in_launcher);
    mojo::internal::Serialize<::apps::mojom::OptionalBool>(
        Traits::show_in_shelf(input), &(*output)->show_in_shelf);
    mojo::internal::Serialize<::apps::mojom::OptionalBool>(
        Traits::show_in_search(input), &(*output)->show_in_search);
    mojo::internal::Serialize<::apps::mojom::OptionalBool>(
        Traits::show_in_management(input), &(*output)->show_in_management);
    mojo::internal::Serialize<::apps::mojom::OptionalBool>(
        Traits::has_badge(input), &(*output)->has_badge);
    mojo::internal::Serialize<::apps::mojom::OptionalBool>(
        Traits::paused(input), &(*output)->paused);
    decltype(Traits::intent_filters(input)) in_intent_filters = Traits::intent_filters(input);
    typename decltype((*output)->intent_filters)::BaseType::BufferWriter
        intent_filters_writer;
    const mojo::internal::ContainerValidateParams intent_filters_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::apps::mojom::IntentFilterDataView>>(
        in_intent_filters, buffer, &intent_filters_writer, &intent_filters_validate_params,
        context);
    (*output)->intent_filters.Set(
        intent_filters_writer.is_null() ? nullptr : intent_filters_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->intent_filters.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null intent_filters in App struct");
  }

  static bool Deserialize(::apps::mojom::internal::App_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::apps::mojom::AppDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::apps::mojom::PermissionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::apps::mojom::PermissionDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::apps::mojom::internal::Permission_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->permission_id = Traits::permission_id(input);
    mojo::internal::Serialize<::apps::mojom::PermissionValueType>(
        Traits::value_type(input), &(*output)->value_type);
    (*output)->value = Traits::value(input);
    (*output)->is_managed = Traits::is_managed(input);
  }

  static bool Deserialize(::apps::mojom::internal::Permission_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::apps::mojom::PermissionDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::apps::mojom::IconKeyDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::apps::mojom::IconKeyDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::apps::mojom::internal::IconKey_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->timeline = Traits::timeline(input);
    (*output)->resource_id = Traits::resource_id(input);
    (*output)->icon_effects = Traits::icon_effects(input);
  }

  static bool Deserialize(::apps::mojom::internal::IconKey_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::apps::mojom::IconKeyDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::apps::mojom::IconValueDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::apps::mojom::IconValueDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::apps::mojom::internal::IconValue_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    mojo::internal::Serialize<::apps::mojom::IconType>(
        Traits::icon_type(input), &(*output)->icon_type);
    decltype(Traits::uncompressed(input)) in_uncompressed = Traits::uncompressed(input);
    typename decltype((*output)->uncompressed)::BaseType::BufferWriter
        uncompressed_writer;
    mojo::internal::Serialize<::gfx::mojom::ImageSkiaDataView>(
        in_uncompressed, buffer, &uncompressed_writer, context);
    (*output)->uncompressed.Set(
        uncompressed_writer.is_null() ? nullptr : uncompressed_writer.data());
    decltype(Traits::compressed(input)) in_compressed = Traits::compressed(input);
    typename decltype((*output)->compressed)::BaseType::BufferWriter
        compressed_writer;
    const mojo::internal::ContainerValidateParams compressed_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
        in_compressed, buffer, &compressed_writer, &compressed_validate_params,
        context);
    (*output)->compressed.Set(
        compressed_writer.is_null() ? nullptr : compressed_writer.data());
    (*output)->is_placeholder_icon = Traits::is_placeholder_icon(input);
  }

  static bool Deserialize(::apps::mojom::internal::IconValue_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::apps::mojom::IconValueDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::apps::mojom::MenuItemsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::apps::mojom::MenuItemsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::apps::mojom::internal::MenuItems_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::items(input)) in_items = Traits::items(input);
    typename decltype((*output)->items)::BaseType::BufferWriter
        items_writer;
    const mojo::internal::ContainerValidateParams items_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::apps::mojom::MenuItemDataView>>(
        in_items, buffer, &items_writer, &items_validate_params,
        context);
    (*output)->items.Set(
        items_writer.is_null() ? nullptr : items_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->items.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null items in MenuItems struct");
  }

  static bool Deserialize(::apps::mojom::internal::MenuItems_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::apps::mojom::MenuItemsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::apps::mojom::MenuItemDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::apps::mojom::MenuItemDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::apps::mojom::internal::MenuItem_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    mojo::internal::Serialize<::apps::mojom::MenuItemType>(
        Traits::type(input), &(*output)->type);
    (*output)->command_id = Traits::command_id(input);
    (*output)->string_id = Traits::string_id(input);
    decltype(Traits::submenu(input)) in_submenu = Traits::submenu(input);
    typename decltype((*output)->submenu)::BaseType::BufferWriter
        submenu_writer;
    const mojo::internal::ContainerValidateParams submenu_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::apps::mojom::MenuItemDataView>>(
        in_submenu, buffer, &submenu_writer, &submenu_validate_params,
        context);
    (*output)->submenu.Set(
        submenu_writer.is_null() ? nullptr : submenu_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->submenu.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null submenu in MenuItem struct");
    (*output)->radio_group_id = Traits::radio_group_id(input);
    decltype(Traits::shortcut_id(input)) in_shortcut_id = Traits::shortcut_id(input);
    typename decltype((*output)->shortcut_id)::BaseType::BufferWriter
        shortcut_id_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_shortcut_id, buffer, &shortcut_id_writer, context);
    (*output)->shortcut_id.Set(
        shortcut_id_writer.is_null() ? nullptr : shortcut_id_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->shortcut_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null shortcut_id in MenuItem struct");
    decltype(Traits::label(input)) in_label = Traits::label(input);
    typename decltype((*output)->label)::BaseType::BufferWriter
        label_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_label, buffer, &label_writer, context);
    (*output)->label.Set(
        label_writer.is_null() ? nullptr : label_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->label.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null label in MenuItem struct");
    decltype(Traits::image(input)) in_image = Traits::image(input);
    typename decltype((*output)->image)::BaseType::BufferWriter
        image_writer;
    mojo::internal::Serialize<::gfx::mojom::ImageSkiaDataView>(
        in_image, buffer, &image_writer, context);
    (*output)->image.Set(
        image_writer.is_null() ? nullptr : image_writer.data());
  }

  static bool Deserialize(::apps::mojom::internal::MenuItem_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::apps::mojom::MenuItemDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::apps::mojom::ConditionValueDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::apps::mojom::ConditionValueDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::apps::mojom::internal::ConditionValue_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::value(input)) in_value = Traits::value(input);
    typename decltype((*output)->value)::BaseType::BufferWriter
        value_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_value, buffer, &value_writer, context);
    (*output)->value.Set(
        value_writer.is_null() ? nullptr : value_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->value.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null value in ConditionValue struct");
    mojo::internal::Serialize<::apps::mojom::PatternMatchType>(
        Traits::match_type(input), &(*output)->match_type);
  }

  static bool Deserialize(::apps::mojom::internal::ConditionValue_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::apps::mojom::ConditionValueDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::apps::mojom::ConditionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::apps::mojom::ConditionDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::apps::mojom::internal::Condition_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    mojo::internal::Serialize<::apps::mojom::ConditionType>(
        Traits::condition_type(input), &(*output)->condition_type);
    decltype(Traits::condition_values(input)) in_condition_values = Traits::condition_values(input);
    typename decltype((*output)->condition_values)::BaseType::BufferWriter
        condition_values_writer;
    const mojo::internal::ContainerValidateParams condition_values_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::apps::mojom::ConditionValueDataView>>(
        in_condition_values, buffer, &condition_values_writer, &condition_values_validate_params,
        context);
    (*output)->condition_values.Set(
        condition_values_writer.is_null() ? nullptr : condition_values_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->condition_values.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null condition_values in Condition struct");
  }

  static bool Deserialize(::apps::mojom::internal::Condition_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::apps::mojom::ConditionDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::apps::mojom::IntentFilterDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::apps::mojom::IntentFilterDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::apps::mojom::internal::IntentFilter_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::conditions(input)) in_conditions = Traits::conditions(input);
    typename decltype((*output)->conditions)::BaseType::BufferWriter
        conditions_writer;
    const mojo::internal::ContainerValidateParams conditions_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::apps::mojom::ConditionDataView>>(
        in_conditions, buffer, &conditions_writer, &conditions_validate_params,
        context);
    (*output)->conditions.Set(
        conditions_writer.is_null() ? nullptr : conditions_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->conditions.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null conditions in IntentFilter struct");
    decltype(Traits::activity_name(input)) in_activity_name = Traits::activity_name(input);
    typename decltype((*output)->activity_name)::BaseType::BufferWriter
        activity_name_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_activity_name, buffer, &activity_name_writer, context);
    (*output)->activity_name.Set(
        activity_name_writer.is_null() ? nullptr : activity_name_writer.data());
    decltype(Traits::activity_label(input)) in_activity_label = Traits::activity_label(input);
    typename decltype((*output)->activity_label)::BaseType::BufferWriter
        activity_label_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_activity_label, buffer, &activity_label_writer, context);
    (*output)->activity_label.Set(
        activity_label_writer.is_null() ? nullptr : activity_label_writer.data());
  }

  static bool Deserialize(::apps::mojom::internal::IntentFilter_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::apps::mojom::IntentFilterDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::apps::mojom::IntentDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::apps::mojom::IntentDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::apps::mojom::internal::Intent_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::action(input)) in_action = Traits::action(input);
    typename decltype((*output)->action)::BaseType::BufferWriter
        action_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_action, buffer, &action_writer, context);
    (*output)->action.Set(
        action_writer.is_null() ? nullptr : action_writer.data());
    decltype(Traits::url(input)) in_url = Traits::url(input);
    typename decltype((*output)->url)::BaseType::BufferWriter
        url_writer;
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_url, buffer, &url_writer, context);
    (*output)->url.Set(
        url_writer.is_null() ? nullptr : url_writer.data());
    decltype(Traits::mime_type(input)) in_mime_type = Traits::mime_type(input);
    typename decltype((*output)->mime_type)::BaseType::BufferWriter
        mime_type_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_mime_type, buffer, &mime_type_writer, context);
    (*output)->mime_type.Set(
        mime_type_writer.is_null() ? nullptr : mime_type_writer.data());
    decltype(Traits::file_urls(input)) in_file_urls = Traits::file_urls(input);
    typename decltype((*output)->file_urls)::BaseType::BufferWriter
        file_urls_writer;
    const mojo::internal::ContainerValidateParams file_urls_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
        in_file_urls, buffer, &file_urls_writer, &file_urls_validate_params,
        context);
    (*output)->file_urls.Set(
        file_urls_writer.is_null() ? nullptr : file_urls_writer.data());
    decltype(Traits::activity_name(input)) in_activity_name = Traits::activity_name(input);
    typename decltype((*output)->activity_name)::BaseType::BufferWriter
        activity_name_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_activity_name, buffer, &activity_name_writer, context);
    (*output)->activity_name.Set(
        activity_name_writer.is_null() ? nullptr : activity_name_writer.data());
    decltype(Traits::drive_share_url(input)) in_drive_share_url = Traits::drive_share_url(input);
    typename decltype((*output)->drive_share_url)::BaseType::BufferWriter
        drive_share_url_writer;
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_drive_share_url, buffer, &drive_share_url_writer, context);
    (*output)->drive_share_url.Set(
        drive_share_url_writer.is_null() ? nullptr : drive_share_url_writer.data());
    decltype(Traits::share_text(input)) in_share_text = Traits::share_text(input);
    typename decltype((*output)->share_text)::BaseType::BufferWriter
        share_text_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_share_text, buffer, &share_text_writer, context);
    (*output)->share_text.Set(
        share_text_writer.is_null() ? nullptr : share_text_writer.data());
  }

  static bool Deserialize(::apps::mojom::internal::Intent_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::apps::mojom::IntentDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::apps::mojom::ReplacedAppPreferencesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::apps::mojom::ReplacedAppPreferencesDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::apps::mojom::internal::ReplacedAppPreferences_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::replaced_preference(input)) in_replaced_preference = Traits::replaced_preference(input);
    typename decltype((*output)->replaced_preference)::BaseType::BufferWriter
        replaced_preference_writer;
    const mojo::internal::ContainerValidateParams replaced_preference_validate_params(
        new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)), new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)));
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, mojo::ArrayDataView<::apps::mojom::IntentFilterDataView>>>(
        in_replaced_preference, buffer, &replaced_preference_writer, &replaced_preference_validate_params,
        context);
    (*output)->replaced_preference.Set(
        replaced_preference_writer.is_null() ? nullptr : replaced_preference_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->replaced_preference.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null replaced_preference in ReplacedAppPreferences struct");
  }

  static bool Deserialize(::apps::mojom::internal::ReplacedAppPreferences_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::apps::mojom::ReplacedAppPreferencesDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::apps::mojom::PreferredAppDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::apps::mojom::PreferredAppDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::apps::mojom::internal::PreferredApp_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::intent_filter(input)) in_intent_filter = Traits::intent_filter(input);
    typename decltype((*output)->intent_filter)::BaseType::BufferWriter
        intent_filter_writer;
    mojo::internal::Serialize<::apps::mojom::IntentFilterDataView>(
        in_intent_filter, buffer, &intent_filter_writer, context);
    (*output)->intent_filter.Set(
        intent_filter_writer.is_null() ? nullptr : intent_filter_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->intent_filter.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null intent_filter in PreferredApp struct");
    decltype(Traits::app_id(input)) in_app_id = Traits::app_id(input);
    typename decltype((*output)->app_id)::BaseType::BufferWriter
        app_id_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_app_id, buffer, &app_id_writer, context);
    (*output)->app_id.Set(
        app_id_writer.is_null() ? nullptr : app_id_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->app_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null app_id in PreferredApp struct");
  }

  static bool Deserialize(::apps::mojom::internal::PreferredApp_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::apps::mojom::PreferredAppDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::apps::mojom::FilePathsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::apps::mojom::FilePathsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::apps::mojom::internal::FilePaths_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::file_paths(input)) in_file_paths = Traits::file_paths(input);
    typename decltype((*output)->file_paths)::BaseType::BufferWriter
        file_paths_writer;
    const mojo::internal::ContainerValidateParams file_paths_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::FilePathDataView>>(
        in_file_paths, buffer, &file_paths_writer, &file_paths_validate_params,
        context);
    (*output)->file_paths.Set(
        file_paths_writer.is_null() ? nullptr : file_paths_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->file_paths.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null file_paths in FilePaths struct");
  }

  static bool Deserialize(::apps::mojom::internal::FilePaths_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::apps::mojom::FilePathsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace apps {
namespace mojom {

inline void AppDataView::GetAppIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->app_id.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void AppDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void AppDataView::GetShortNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->short_name.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void AppDataView::GetPublisherIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->publisher_id.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void AppDataView::GetDescriptionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->description.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void AppDataView::GetVersionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->version.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void AppDataView::GetAdditionalSearchTermsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->additional_search_terms.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, context_);
}
inline void AppDataView::GetIconKeyDataView(
    IconKeyDataView* output) {
  auto pointer = data_->icon_key.Get();
  *output = IconKeyDataView(pointer, context_);
}
inline void AppDataView::GetLastLaunchTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->last_launch_time.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, context_);
}
inline void AppDataView::GetInstallTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->install_time.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, context_);
}
inline void AppDataView::GetPermissionsDataView(
    mojo::ArrayDataView<PermissionDataView>* output) {
  auto pointer = data_->permissions.Get();
  *output = mojo::ArrayDataView<PermissionDataView>(pointer, context_);
}
inline void AppDataView::GetIntentFiltersDataView(
    mojo::ArrayDataView<IntentFilterDataView>* output) {
  auto pointer = data_->intent_filters.Get();
  *output = mojo::ArrayDataView<IntentFilterDataView>(pointer, context_);
}






inline void IconValueDataView::GetUncompressedDataView(
    ::gfx::mojom::ImageSkiaDataView* output) {
  auto pointer = data_->uncompressed.Get();
  *output = ::gfx::mojom::ImageSkiaDataView(pointer, context_);
}
inline void IconValueDataView::GetCompressedDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->compressed.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, context_);
}


inline void MenuItemsDataView::GetItemsDataView(
    mojo::ArrayDataView<MenuItemDataView>* output) {
  auto pointer = data_->items.Get();
  *output = mojo::ArrayDataView<MenuItemDataView>(pointer, context_);
}


inline void MenuItemDataView::GetSubmenuDataView(
    mojo::ArrayDataView<MenuItemDataView>* output) {
  auto pointer = data_->submenu.Get();
  *output = mojo::ArrayDataView<MenuItemDataView>(pointer, context_);
}
inline void MenuItemDataView::GetShortcutIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->shortcut_id.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void MenuItemDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void MenuItemDataView::GetImageDataView(
    ::gfx::mojom::ImageSkiaDataView* output) {
  auto pointer = data_->image.Get();
  *output = ::gfx::mojom::ImageSkiaDataView(pointer, context_);
}


inline void ConditionValueDataView::GetValueDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->value.Get();
  *output = mojo::StringDataView(pointer, context_);
}


inline void ConditionDataView::GetConditionValuesDataView(
    mojo::ArrayDataView<ConditionValueDataView>* output) {
  auto pointer = data_->condition_values.Get();
  *output = mojo::ArrayDataView<ConditionValueDataView>(pointer, context_);
}


inline void IntentFilterDataView::GetConditionsDataView(
    mojo::ArrayDataView<ConditionDataView>* output) {
  auto pointer = data_->conditions.Get();
  *output = mojo::ArrayDataView<ConditionDataView>(pointer, context_);
}
inline void IntentFilterDataView::GetActivityNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->activity_name.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void IntentFilterDataView::GetActivityLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->activity_label.Get();
  *output = mojo::StringDataView(pointer, context_);
}


inline void IntentDataView::GetActionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->action.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void IntentDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}
inline void IntentDataView::GetMimeTypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->mime_type.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void IntentDataView::GetFileUrlsDataView(
    mojo::ArrayDataView<::url::mojom::UrlDataView>* output) {
  auto pointer = data_->file_urls.Get();
  *output = mojo::ArrayDataView<::url::mojom::UrlDataView>(pointer, context_);
}
inline void IntentDataView::GetActivityNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->activity_name.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void IntentDataView::GetDriveShareUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->drive_share_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}
inline void IntentDataView::GetShareTextDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->share_text.Get();
  *output = mojo::StringDataView(pointer, context_);
}


inline void ReplacedAppPreferencesDataView::GetReplacedPreferenceDataView(
    mojo::MapDataView<mojo::StringDataView, mojo::ArrayDataView<IntentFilterDataView>>* output) {
  auto pointer = data_->replaced_preference.Get();
  *output = mojo::MapDataView<mojo::StringDataView, mojo::ArrayDataView<IntentFilterDataView>>(pointer, context_);
}


inline void PreferredAppDataView::GetIntentFilterDataView(
    IntentFilterDataView* output) {
  auto pointer = data_->intent_filter.Get();
  *output = IntentFilterDataView(pointer, context_);
}
inline void PreferredAppDataView::GetAppIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->app_id.Get();
  *output = mojo::StringDataView(pointer, context_);
}


inline void FilePathsDataView::GetFilePathsDataView(
    mojo::ArrayDataView<::mojo_base::mojom::FilePathDataView>* output) {
  auto pointer = data_->file_paths.Get();
  *output = mojo::ArrayDataView<::mojo_base::mojom::FilePathDataView>(pointer, context_);
}



}  // namespace mojom
}  // namespace apps

#endif  // COMPONENTS_SERVICES_APP_SERVICE_PUBLIC_MOJOM_TYPES_MOJOM_SHARED_H_