// components/services/storage/public/mojom/indexed_db_control.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/services/storage/public/mojom/indexed_db_control.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "components/services/storage/public/mojom/indexed_db_control.mojom-params-data.h"
#include "components/services/storage/public/mojom/indexed_db_control.mojom-shared-message-ids.h"

#include "components/services/storage/public/mojom/indexed_db_control.mojom-import-headers.h"


#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_INDEXED_DB_CONTROL_MOJOM_JUMBO_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_INDEXED_DB_CONTROL_MOJOM_JUMBO_H_
#endif
namespace storage {
namespace mojom {
IndexedDBStorageUsageInfo::IndexedDBStorageUsageInfo()
    : origin(),
      size_in_bytes(),
      last_modified_time() {}

IndexedDBStorageUsageInfo::IndexedDBStorageUsageInfo(
    const ::url::Origin& origin_in,
    uint64_t size_in_bytes_in,
    ::base::Time last_modified_time_in)
    : origin(std::move(origin_in)),
      size_in_bytes(std::move(size_in_bytes_in)),
      last_modified_time(std::move(last_modified_time_in)) {}

IndexedDBStorageUsageInfo::~IndexedDBStorageUsageInfo() = default;

void IndexedDBStorageUsageInfo::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("origin", base::trace_event::ValueToString(this->origin, "<value of type const ::url::Origin&>"));
  value->SetString("size_in_bytes", base::NumberToString(this->size_in_bytes));
  value->SetString("last_modified_time", base::trace_event::ValueToString(this->last_modified_time, "<value of type ::base::Time>"));
}

bool IndexedDBStorageUsageInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
IndexedDBStoragePolicyUpdate::IndexedDBStoragePolicyUpdate()
    : origin(),
      purge_on_shutdown() {}

IndexedDBStoragePolicyUpdate::IndexedDBStoragePolicyUpdate(
    const ::url::Origin& origin_in,
    bool purge_on_shutdown_in)
    : origin(std::move(origin_in)),
      purge_on_shutdown(std::move(purge_on_shutdown_in)) {}

IndexedDBStoragePolicyUpdate::~IndexedDBStoragePolicyUpdate() = default;

void IndexedDBStoragePolicyUpdate::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("origin", base::trace_event::ValueToString(this->origin, "<value of type const ::url::Origin&>"));
  value->SetBoolean("purge_on_shutdown", this->purge_on_shutdown);
}

bool IndexedDBStoragePolicyUpdate::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char IndexedDBObserver::Name_[] = "storage.mojom.IndexedDBObserver";

IndexedDBObserverProxy::IndexedDBObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void IndexedDBObserverProxy::OnIndexedDBListChanged(
    const ::url::Origin& in_origin) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::IndexedDBObserver::OnIndexedDBListChanged", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("origin", base::trace_event::ValueToString(in_origin, "<value of type const ::url::Origin&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIndexedDBObserver_OnIndexedDBListChanged_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::storage::mojom::internal::IndexedDBObserver_OnIndexedDBListChanged_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->origin)::BaseType::BufferWriter
      origin_writer;
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_origin, buffer, &origin_writer, &serialization_context);
  params->origin.Set(
      origin_writer.is_null() ? nullptr : origin_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in IndexedDBObserver.OnIndexedDBListChanged request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBObserver::Name_);
  message.set_method_name("OnIndexedDBListChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void IndexedDBObserverProxy::OnIndexedDBContentChanged(
    const ::url::Origin& in_origin, const ::base::string16& in_database_name, const ::base::string16& in_object_store_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::IndexedDBObserver::OnIndexedDBContentChanged", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("origin", base::trace_event::ValueToString(in_origin, "<value of type const ::url::Origin&>"));
      raw_value->SetString("database_name", base::trace_event::ValueToString(in_database_name, "<value of type const ::base::string16&>"));
      raw_value->SetString("object_store_name", base::trace_event::ValueToString(in_object_store_name, "<value of type const ::base::string16&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIndexedDBObserver_OnIndexedDBContentChanged_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::storage::mojom::internal::IndexedDBObserver_OnIndexedDBContentChanged_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->origin)::BaseType::BufferWriter
      origin_writer;
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_origin, buffer, &origin_writer, &serialization_context);
  params->origin.Set(
      origin_writer.is_null() ? nullptr : origin_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in IndexedDBObserver.OnIndexedDBContentChanged request");
  typename decltype(params->database_name)::BaseType::BufferWriter
      database_name_writer;
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_database_name, buffer, &database_name_writer, &serialization_context);
  params->database_name.Set(
      database_name_writer.is_null() ? nullptr : database_name_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->database_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null database_name in IndexedDBObserver.OnIndexedDBContentChanged request");
  typename decltype(params->object_store_name)::BaseType::BufferWriter
      object_store_name_writer;
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_object_store_name, buffer, &object_store_name_writer, &serialization_context);
  params->object_store_name.Set(
      object_store_name_writer.is_null() ? nullptr : object_store_name_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->object_store_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null object_store_name in IndexedDBObserver.OnIndexedDBContentChanged request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBObserver::Name_);
  message.set_method_name("OnIndexedDBContentChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool IndexedDBObserverStubDispatch::Accept(
    IndexedDBObserver* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kIndexedDBObserver_OnIndexedDBListChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::IndexedDBObserver::OnIndexedDBListChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::IndexedDBObserver::OnIndexedDBListChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::IndexedDBObserver_OnIndexedDBListChanged_Params_Data* params =
          reinterpret_cast<internal::IndexedDBObserver_OnIndexedDBListChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::url::Origin p_origin{};
      IndexedDBObserver_OnIndexedDBListChanged_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnIndexedDBListChanged(
std::move(p_origin));
      return true;
    }
    case internal::kIndexedDBObserver_OnIndexedDBContentChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::IndexedDBObserver::OnIndexedDBContentChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::IndexedDBObserver::OnIndexedDBContentChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::IndexedDBObserver_OnIndexedDBContentChanged_Params_Data* params =
          reinterpret_cast<internal::IndexedDBObserver_OnIndexedDBContentChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::url::Origin p_origin{};
      ::base::string16 p_database_name{};
      ::base::string16 p_object_store_name{};
      IndexedDBObserver_OnIndexedDBContentChanged_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (success && !input_data_view.ReadDatabaseName(&p_database_name))
        success = false;
      if (success && !input_data_view.ReadObjectStoreName(&p_object_store_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBObserver::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnIndexedDBContentChanged(
std::move(p_origin), 
std::move(p_database_name), 
std::move(p_object_store_name));
      return true;
    }
  }
  return false;
}

// static
bool IndexedDBObserverStubDispatch::AcceptWithResponder(
    IndexedDBObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kIndexedDBObserver_OnIndexedDBListChanged_Name: {
      break;
    }
    case internal::kIndexedDBObserver_OnIndexedDBContentChanged_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kIndexedDBObserverValidationInfo[] = {
    {internal::kIndexedDBObserver_OnIndexedDBListChanged_Name,
     {&internal::IndexedDBObserver_OnIndexedDBListChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kIndexedDBObserver_OnIndexedDBContentChanged_Name,
     {&internal::IndexedDBObserver_OnIndexedDBContentChanged_Params_Data::Validate,
      nullptr /* no response */}},
};

bool IndexedDBObserverRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::storage::mojom::IndexedDBObserver::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kIndexedDBObserverValidationInfo);
}

const char IndexedDBControl::Name_[] = "storage.mojom.IndexedDBControl";

class IndexedDBControl_GetUsage_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IndexedDBControl_GetUsage_ForwardToCallback(
      IndexedDBControl::GetUsageCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  IndexedDBControl::GetUsageCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(IndexedDBControl_GetUsage_ForwardToCallback);
};

class IndexedDBControl_DeleteForOrigin_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IndexedDBControl_DeleteForOrigin_ForwardToCallback(
      IndexedDBControl::DeleteForOriginCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  IndexedDBControl::DeleteForOriginCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(IndexedDBControl_DeleteForOrigin_ForwardToCallback);
};

class IndexedDBControl_ForceClose_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IndexedDBControl_ForceClose_ForwardToCallback(
      IndexedDBControl::ForceCloseCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  IndexedDBControl::ForceCloseCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(IndexedDBControl_ForceClose_ForwardToCallback);
};

class IndexedDBControl_GetConnectionCount_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IndexedDBControl_GetConnectionCount_ForwardToCallback(
      IndexedDBControl::GetConnectionCountCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  IndexedDBControl::GetConnectionCountCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(IndexedDBControl_GetConnectionCount_ForwardToCallback);
};

class IndexedDBControl_DownloadOriginData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IndexedDBControl_DownloadOriginData_ForwardToCallback(
      IndexedDBControl::DownloadOriginDataCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  IndexedDBControl::DownloadOriginDataCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(IndexedDBControl_DownloadOriginData_ForwardToCallback);
};

class IndexedDBControl_GetAllOriginsDetails_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IndexedDBControl_GetAllOriginsDetails_ForwardToCallback(
      IndexedDBControl::GetAllOriginsDetailsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  IndexedDBControl::GetAllOriginsDetailsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(IndexedDBControl_GetAllOriginsDetails_ForwardToCallback);
};

IndexedDBControlProxy::IndexedDBControlProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void IndexedDBControlProxy::BindIndexedDB(
    const ::url::Origin& in_origin, ::mojo::PendingReceiver<::blink::mojom::IDBFactory> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::IndexedDBControl::BindIndexedDB", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("origin", base::trace_event::ValueToString(in_origin, "<value of type const ::url::Origin&>"));
      raw_value->SetBoolean("receiver", in_receiver.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIndexedDBControl_BindIndexedDB_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::storage::mojom::internal::IndexedDBControl_BindIndexedDB_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->origin)::BaseType::BufferWriter
      origin_writer;
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_origin, buffer, &origin_writer, &serialization_context);
  params->origin.Set(
      origin_writer.is_null() ? nullptr : origin_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in IndexedDBControl.BindIndexedDB request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::IDBFactoryInterfaceBase>>(
      in_receiver, &params->receiver, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in IndexedDBControl.BindIndexedDB request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControl::Name_);
  message.set_method_name("BindIndexedDB");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void IndexedDBControlProxy::GetUsage(
    GetUsageCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "storage::mojom::IndexedDBControl::GetUsage");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIndexedDBControl_GetUsage_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::storage::mojom::internal::IndexedDBControl_GetUsage_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControl::Name_);
  message.set_method_name("GetUsage");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IndexedDBControl_GetUsage_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void IndexedDBControlProxy::DeleteForOrigin(
    const ::url::Origin& in_origin, DeleteForOriginCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::IndexedDBControl::DeleteForOrigin", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("origin", base::trace_event::ValueToString(in_origin, "<value of type const ::url::Origin&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIndexedDBControl_DeleteForOrigin_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::storage::mojom::internal::IndexedDBControl_DeleteForOrigin_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->origin)::BaseType::BufferWriter
      origin_writer;
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_origin, buffer, &origin_writer, &serialization_context);
  params->origin.Set(
      origin_writer.is_null() ? nullptr : origin_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in IndexedDBControl.DeleteForOrigin request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControl::Name_);
  message.set_method_name("DeleteForOrigin");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IndexedDBControl_DeleteForOrigin_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void IndexedDBControlProxy::ForceClose(
    const ::url::Origin& in_origin, ForceCloseReason in_reason, ForceCloseCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::IndexedDBControl::ForceClose", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("origin", base::trace_event::ValueToString(in_origin, "<value of type const ::url::Origin&>"));
      raw_value->SetString("reason", base::trace_event::ValueToString(in_reason));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIndexedDBControl_ForceClose_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::storage::mojom::internal::IndexedDBControl_ForceClose_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->origin)::BaseType::BufferWriter
      origin_writer;
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_origin, buffer, &origin_writer, &serialization_context);
  params->origin.Set(
      origin_writer.is_null() ? nullptr : origin_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in IndexedDBControl.ForceClose request");
  mojo::internal::Serialize<::storage::mojom::ForceCloseReason>(
      in_reason, &params->reason);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControl::Name_);
  message.set_method_name("ForceClose");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IndexedDBControl_ForceClose_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void IndexedDBControlProxy::GetConnectionCount(
    const ::url::Origin& in_origin, GetConnectionCountCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::IndexedDBControl::GetConnectionCount", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("origin", base::trace_event::ValueToString(in_origin, "<value of type const ::url::Origin&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIndexedDBControl_GetConnectionCount_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::storage::mojom::internal::IndexedDBControl_GetConnectionCount_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->origin)::BaseType::BufferWriter
      origin_writer;
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_origin, buffer, &origin_writer, &serialization_context);
  params->origin.Set(
      origin_writer.is_null() ? nullptr : origin_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in IndexedDBControl.GetConnectionCount request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControl::Name_);
  message.set_method_name("GetConnectionCount");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IndexedDBControl_GetConnectionCount_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void IndexedDBControlProxy::DownloadOriginData(
    const ::url::Origin& in_origin, DownloadOriginDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::IndexedDBControl::DownloadOriginData", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("origin", base::trace_event::ValueToString(in_origin, "<value of type const ::url::Origin&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIndexedDBControl_DownloadOriginData_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::storage::mojom::internal::IndexedDBControl_DownloadOriginData_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->origin)::BaseType::BufferWriter
      origin_writer;
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_origin, buffer, &origin_writer, &serialization_context);
  params->origin.Set(
      origin_writer.is_null() ? nullptr : origin_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in IndexedDBControl.DownloadOriginData request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControl::Name_);
  message.set_method_name("DownloadOriginData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IndexedDBControl_DownloadOriginData_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void IndexedDBControlProxy::GetAllOriginsDetails(
    GetAllOriginsDetailsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "storage::mojom::IndexedDBControl::GetAllOriginsDetails");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIndexedDBControl_GetAllOriginsDetails_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::storage::mojom::internal::IndexedDBControl_GetAllOriginsDetails_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControl::Name_);
  message.set_method_name("GetAllOriginsDetails");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IndexedDBControl_GetAllOriginsDetails_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void IndexedDBControlProxy::SetForceKeepSessionState(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "storage::mojom::IndexedDBControl::SetForceKeepSessionState");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIndexedDBControl_SetForceKeepSessionState_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::storage::mojom::internal::IndexedDBControl_SetForceKeepSessionState_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControl::Name_);
  message.set_method_name("SetForceKeepSessionState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void IndexedDBControlProxy::AddObserver(
    ::mojo::PendingRemote<IndexedDBObserver> in_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::IndexedDBControl::AddObserver", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("observer", in_observer.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIndexedDBControl_AddObserver_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::storage::mojom::internal::IndexedDBControl_AddObserver_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::storage::mojom::IndexedDBObserverInterfaceBase>>(
      in_observer, &params->observer, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->observer),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid observer in IndexedDBControl.AddObserver request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControl::Name_);
  message.set_method_name("AddObserver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void IndexedDBControlProxy::ApplyPolicyUpdates(
    std::vector<IndexedDBStoragePolicyUpdatePtr> in_policy_updates) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::IndexedDBControl::ApplyPolicyUpdates", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->BeginArray("policy_updates");
      for (const auto& item0 : in_policy_updates) {
        if (item0.is_null()) {
          raw_value->AppendString("nullptr");
        } else {
          raw_value->BeginDictionary();
          item0->AsValueInto(raw_value);
          raw_value->EndDictionary();
        }
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIndexedDBControl_ApplyPolicyUpdates_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::storage::mojom::internal::IndexedDBControl_ApplyPolicyUpdates_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->policy_updates)::BaseType::BufferWriter
      policy_updates_writer;
  const mojo::internal::ContainerValidateParams policy_updates_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::storage::mojom::IndexedDBStoragePolicyUpdateDataView>>(
      in_policy_updates, buffer, &policy_updates_writer, &policy_updates_validate_params,
      &serialization_context);
  params->policy_updates.Set(
      policy_updates_writer.is_null() ? nullptr : policy_updates_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->policy_updates.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null policy_updates in IndexedDBControl.ApplyPolicyUpdates request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControl::Name_);
  message.set_method_name("ApplyPolicyUpdates");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void IndexedDBControlProxy::BindTestInterface(
    ::mojo::PendingReceiver<::storage::mojom::IndexedDBControlTest> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::IndexedDBControl::BindTestInterface", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("receiver", in_receiver.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIndexedDBControl_BindTestInterface_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::storage::mojom::internal::IndexedDBControl_BindTestInterface_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::storage::mojom::IndexedDBControlTestInterfaceBase>>(
      in_receiver, &params->receiver, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in IndexedDBControl.BindTestInterface request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControl::Name_);
  message.set_method_name("BindTestInterface");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class IndexedDBControl_GetUsage_ProxyToResponder {
 public:
  static IndexedDBControl::GetUsageCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<IndexedDBControl_GetUsage_ProxyToResponder> proxy(
        new IndexedDBControl_GetUsage_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&IndexedDBControl_GetUsage_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IndexedDBControl_GetUsage_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  IndexedDBControl_GetUsage_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "IndexedDBControl::GetUsageCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<IndexedDBStorageUsageInfoPtr> in_info);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(IndexedDBControl_GetUsage_ProxyToResponder);
};

bool IndexedDBControl_GetUsage_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::IndexedDBControl::GetUsageCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::IndexedDBControl_GetUsage_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IndexedDBControl_GetUsage_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  std::vector<IndexedDBStorageUsageInfoPtr> p_info{};
  IndexedDBControl_GetUsage_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadInfo(&p_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IndexedDBControl::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_info));
  return true;
}

void IndexedDBControl_GetUsage_ProxyToResponder::Run(
    std::vector<IndexedDBStorageUsageInfoPtr> in_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::IndexedDBControl::GetUsageCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->BeginArray("info");
      for (const auto& item0 : in_info) {
        if (item0.is_null()) {
          raw_value->AppendString("nullptr");
        } else {
          raw_value->BeginDictionary();
          item0->AsValueInto(raw_value);
          raw_value->EndDictionary();
        }
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIndexedDBControl_GetUsage_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::storage::mojom::internal::IndexedDBControl_GetUsage_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->info)::BaseType::BufferWriter
      info_writer;
  const mojo::internal::ContainerValidateParams info_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::storage::mojom::IndexedDBStorageUsageInfoDataView>>(
      in_info, buffer, &info_writer, &info_validate_params,
      &serialization_context);
  params->info.Set(
      info_writer.is_null() ? nullptr : info_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null info in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::IndexedDBControl::GetUsageCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControl::Name_);
  message.set_method_name("GetUsage");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class IndexedDBControl_DeleteForOrigin_ProxyToResponder {
 public:
  static IndexedDBControl::DeleteForOriginCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<IndexedDBControl_DeleteForOrigin_ProxyToResponder> proxy(
        new IndexedDBControl_DeleteForOrigin_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&IndexedDBControl_DeleteForOrigin_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IndexedDBControl_DeleteForOrigin_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  IndexedDBControl_DeleteForOrigin_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "IndexedDBControl::DeleteForOriginCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(IndexedDBControl_DeleteForOrigin_ProxyToResponder);
};

bool IndexedDBControl_DeleteForOrigin_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::IndexedDBControl::DeleteForOriginCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::IndexedDBControl_DeleteForOrigin_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IndexedDBControl_DeleteForOrigin_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  bool p_success{};
  IndexedDBControl_DeleteForOrigin_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IndexedDBControl::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void IndexedDBControl_DeleteForOrigin_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::IndexedDBControl::DeleteForOriginCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("success", in_success);
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIndexedDBControl_DeleteForOrigin_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::storage::mojom::internal::IndexedDBControl_DeleteForOrigin_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->success = in_success;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::IndexedDBControl::DeleteForOriginCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControl::Name_);
  message.set_method_name("DeleteForOrigin");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class IndexedDBControl_ForceClose_ProxyToResponder {
 public:
  static IndexedDBControl::ForceCloseCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<IndexedDBControl_ForceClose_ProxyToResponder> proxy(
        new IndexedDBControl_ForceClose_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&IndexedDBControl_ForceClose_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IndexedDBControl_ForceClose_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  IndexedDBControl_ForceClose_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "IndexedDBControl::ForceCloseCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(IndexedDBControl_ForceClose_ProxyToResponder);
};

bool IndexedDBControl_ForceClose_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::IndexedDBControl::ForceCloseCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::IndexedDBControl_ForceClose_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IndexedDBControl_ForceClose_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  IndexedDBControl_ForceClose_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IndexedDBControl::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void IndexedDBControl_ForceClose_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)storage::mojom::IndexedDBControl::ForceCloseCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIndexedDBControl_ForceClose_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::storage::mojom::internal::IndexedDBControl_ForceClose_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::IndexedDBControl::ForceCloseCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControl::Name_);
  message.set_method_name("ForceClose");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class IndexedDBControl_GetConnectionCount_ProxyToResponder {
 public:
  static IndexedDBControl::GetConnectionCountCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<IndexedDBControl_GetConnectionCount_ProxyToResponder> proxy(
        new IndexedDBControl_GetConnectionCount_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&IndexedDBControl_GetConnectionCount_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IndexedDBControl_GetConnectionCount_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  IndexedDBControl_GetConnectionCount_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "IndexedDBControl::GetConnectionCountCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      uint64_t in_connection_count);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(IndexedDBControl_GetConnectionCount_ProxyToResponder);
};

bool IndexedDBControl_GetConnectionCount_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::IndexedDBControl::GetConnectionCountCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::IndexedDBControl_GetConnectionCount_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IndexedDBControl_GetConnectionCount_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  uint64_t p_connection_count{};
  IndexedDBControl_GetConnectionCount_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_connection_count = input_data_view.connection_count();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IndexedDBControl::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_connection_count));
  return true;
}

void IndexedDBControl_GetConnectionCount_ProxyToResponder::Run(
    uint64_t in_connection_count) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::IndexedDBControl::GetConnectionCountCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("connection_count", base::NumberToString(in_connection_count));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIndexedDBControl_GetConnectionCount_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::storage::mojom::internal::IndexedDBControl_GetConnectionCount_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->connection_count = in_connection_count;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::IndexedDBControl::GetConnectionCountCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControl::Name_);
  message.set_method_name("GetConnectionCount");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class IndexedDBControl_DownloadOriginData_ProxyToResponder {
 public:
  static IndexedDBControl::DownloadOriginDataCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<IndexedDBControl_DownloadOriginData_ProxyToResponder> proxy(
        new IndexedDBControl_DownloadOriginData_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&IndexedDBControl_DownloadOriginData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IndexedDBControl_DownloadOriginData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  IndexedDBControl_DownloadOriginData_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "IndexedDBControl::DownloadOriginDataCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, const ::base::FilePath& in_temp_path, const ::base::FilePath& in_zip_path);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(IndexedDBControl_DownloadOriginData_ProxyToResponder);
};

bool IndexedDBControl_DownloadOriginData_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::IndexedDBControl::DownloadOriginDataCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::IndexedDBControl_DownloadOriginData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IndexedDBControl_DownloadOriginData_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  bool p_success{};
  ::base::FilePath p_temp_path{};
  ::base::FilePath p_zip_path{};
  IndexedDBControl_DownloadOriginData_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadTempPath(&p_temp_path))
    success = false;
  if (success && !input_data_view.ReadZipPath(&p_zip_path))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IndexedDBControl::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_temp_path), 
std::move(p_zip_path));
  return true;
}

void IndexedDBControl_DownloadOriginData_ProxyToResponder::Run(
    bool in_success, const ::base::FilePath& in_temp_path, const ::base::FilePath& in_zip_path) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::IndexedDBControl::DownloadOriginDataCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("success", in_success);
      raw_value->SetString("temp_path", base::trace_event::ValueToString(in_temp_path, "<value of type const ::base::FilePath&>"));
      raw_value->SetString("zip_path", base::trace_event::ValueToString(in_zip_path, "<value of type const ::base::FilePath&>"));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIndexedDBControl_DownloadOriginData_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::storage::mojom::internal::IndexedDBControl_DownloadOriginData_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->success = in_success;
  typename decltype(params->temp_path)::BaseType::BufferWriter
      temp_path_writer;
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
      in_temp_path, buffer, &temp_path_writer, &serialization_context);
  params->temp_path.Set(
      temp_path_writer.is_null() ? nullptr : temp_path_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->temp_path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null temp_path in ");
  typename decltype(params->zip_path)::BaseType::BufferWriter
      zip_path_writer;
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
      in_zip_path, buffer, &zip_path_writer, &serialization_context);
  params->zip_path.Set(
      zip_path_writer.is_null() ? nullptr : zip_path_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->zip_path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null zip_path in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::IndexedDBControl::DownloadOriginDataCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControl::Name_);
  message.set_method_name("DownloadOriginData");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class IndexedDBControl_GetAllOriginsDetails_ProxyToResponder {
 public:
  static IndexedDBControl::GetAllOriginsDetailsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<IndexedDBControl_GetAllOriginsDetails_ProxyToResponder> proxy(
        new IndexedDBControl_GetAllOriginsDetails_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&IndexedDBControl_GetAllOriginsDetails_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IndexedDBControl_GetAllOriginsDetails_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  IndexedDBControl_GetAllOriginsDetails_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "IndexedDBControl::GetAllOriginsDetailsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_incognito, ::base::Value in_details);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(IndexedDBControl_GetAllOriginsDetails_ProxyToResponder);
};

bool IndexedDBControl_GetAllOriginsDetails_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "storage::mojom::IndexedDBControl::GetAllOriginsDetailsCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::IndexedDBControl_GetAllOriginsDetails_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IndexedDBControl_GetAllOriginsDetails_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  bool p_incognito{};
  ::base::Value p_details{};
  IndexedDBControl_GetAllOriginsDetails_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_incognito = input_data_view.incognito();
  if (success && !input_data_view.ReadDetails(&p_details))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IndexedDBControl::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_incognito), 
std::move(p_details));
  return true;
}

void IndexedDBControl_GetAllOriginsDetails_ProxyToResponder::Run(
    bool in_incognito, ::base::Value in_details) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)storage::mojom::IndexedDBControl::GetAllOriginsDetailsCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("incognito", in_incognito);
      raw_value->SetString("details", base::trace_event::ValueToString(in_details, "<value of type ::base::Value>"));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kIndexedDBControl_GetAllOriginsDetails_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::storage::mojom::internal::IndexedDBControl_GetAllOriginsDetails_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->incognito = in_incognito;
  typename decltype(params->details)::BaseType::BufferWriter
      details_writer;
  mojo::internal::Serialize<::mojo_base::mojom::ListValueDataView>(
      in_details, buffer, &details_writer, &serialization_context);
  params->details.Set(
      details_writer.is_null() ? nullptr : details_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->details.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null details in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)storage::mojom::IndexedDBControl::GetAllOriginsDetailsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBControl::Name_);
  message.set_method_name("GetAllOriginsDetails");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool IndexedDBControlStubDispatch::Accept(
    IndexedDBControl* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kIndexedDBControl_BindIndexedDB_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::IndexedDBControl::BindIndexedDB",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::IndexedDBControl::BindIndexedDB");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::IndexedDBControl_BindIndexedDB_Params_Data* params =
          reinterpret_cast<internal::IndexedDBControl_BindIndexedDB_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::url::Origin p_origin{};
      ::mojo::PendingReceiver<::blink::mojom::IDBFactory> p_receiver{};
      IndexedDBControl_BindIndexedDB_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBControl::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindIndexedDB(
std::move(p_origin), 
std::move(p_receiver));
      return true;
    }
    case internal::kIndexedDBControl_GetUsage_Name: {
      break;
    }
    case internal::kIndexedDBControl_DeleteForOrigin_Name: {
      break;
    }
    case internal::kIndexedDBControl_ForceClose_Name: {
      break;
    }
    case internal::kIndexedDBControl_GetConnectionCount_Name: {
      break;
    }
    case internal::kIndexedDBControl_DownloadOriginData_Name: {
      break;
    }
    case internal::kIndexedDBControl_GetAllOriginsDetails_Name: {
      break;
    }
    case internal::kIndexedDBControl_SetForceKeepSessionState_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::IndexedDBControl::SetForceKeepSessionState",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::IndexedDBControl::SetForceKeepSessionState");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::IndexedDBControl_SetForceKeepSessionState_Params_Data* params =
          reinterpret_cast<internal::IndexedDBControl_SetForceKeepSessionState_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      IndexedDBControl_SetForceKeepSessionState_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBControl::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetForceKeepSessionState();
      return true;
    }
    case internal::kIndexedDBControl_AddObserver_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::IndexedDBControl::AddObserver",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::IndexedDBControl::AddObserver");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::IndexedDBControl_AddObserver_Params_Data* params =
          reinterpret_cast<internal::IndexedDBControl_AddObserver_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<IndexedDBObserver> p_observer{};
      IndexedDBControl_AddObserver_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBControl::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddObserver(
std::move(p_observer));
      return true;
    }
    case internal::kIndexedDBControl_ApplyPolicyUpdates_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::IndexedDBControl::ApplyPolicyUpdates",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::IndexedDBControl::ApplyPolicyUpdates");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::IndexedDBControl_ApplyPolicyUpdates_Params_Data* params =
          reinterpret_cast<internal::IndexedDBControl_ApplyPolicyUpdates_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::vector<IndexedDBStoragePolicyUpdatePtr> p_policy_updates{};
      IndexedDBControl_ApplyPolicyUpdates_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadPolicyUpdates(&p_policy_updates))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBControl::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ApplyPolicyUpdates(
std::move(p_policy_updates));
      return true;
    }
    case internal::kIndexedDBControl_BindTestInterface_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::IndexedDBControl::BindTestInterface",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::IndexedDBControl::BindTestInterface");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::IndexedDBControl_BindTestInterface_Params_Data* params =
          reinterpret_cast<internal::IndexedDBControl_BindTestInterface_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::storage::mojom::IndexedDBControlTest> p_receiver{};
      IndexedDBControl_BindTestInterface_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBControl::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindTestInterface(
std::move(p_receiver));
      return true;
    }
  }
  return false;
}

// static
bool IndexedDBControlStubDispatch::AcceptWithResponder(
    IndexedDBControl* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kIndexedDBControl_BindIndexedDB_Name: {
      break;
    }
    case internal::kIndexedDBControl_GetUsage_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::IndexedDBControl::GetUsage",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::IndexedDBControl::GetUsage");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::IndexedDBControl_GetUsage_Params_Data* params =
          reinterpret_cast<
              internal::IndexedDBControl_GetUsage_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      IndexedDBControl_GetUsage_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBControl::Name_, 1, false);
        return false;
      }
      IndexedDBControl::GetUsageCallback callback =
          IndexedDBControl_GetUsage_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetUsage(std::move(callback));
      return true;
    }
    case internal::kIndexedDBControl_DeleteForOrigin_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::IndexedDBControl::DeleteForOrigin",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::IndexedDBControl::DeleteForOrigin");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::IndexedDBControl_DeleteForOrigin_Params_Data* params =
          reinterpret_cast<
              internal::IndexedDBControl_DeleteForOrigin_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::url::Origin p_origin{};
      IndexedDBControl_DeleteForOrigin_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBControl::Name_, 2, false);
        return false;
      }
      IndexedDBControl::DeleteForOriginCallback callback =
          IndexedDBControl_DeleteForOrigin_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteForOrigin(
std::move(p_origin), std::move(callback));
      return true;
    }
    case internal::kIndexedDBControl_ForceClose_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::IndexedDBControl::ForceClose",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::IndexedDBControl::ForceClose");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::IndexedDBControl_ForceClose_Params_Data* params =
          reinterpret_cast<
              internal::IndexedDBControl_ForceClose_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::url::Origin p_origin{};
      ForceCloseReason p_reason{};
      IndexedDBControl_ForceClose_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (success && !input_data_view.ReadReason(&p_reason))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBControl::Name_, 3, false);
        return false;
      }
      IndexedDBControl::ForceCloseCallback callback =
          IndexedDBControl_ForceClose_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ForceClose(
std::move(p_origin), 
std::move(p_reason), std::move(callback));
      return true;
    }
    case internal::kIndexedDBControl_GetConnectionCount_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::IndexedDBControl::GetConnectionCount",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::IndexedDBControl::GetConnectionCount");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::IndexedDBControl_GetConnectionCount_Params_Data* params =
          reinterpret_cast<
              internal::IndexedDBControl_GetConnectionCount_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::url::Origin p_origin{};
      IndexedDBControl_GetConnectionCount_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBControl::Name_, 4, false);
        return false;
      }
      IndexedDBControl::GetConnectionCountCallback callback =
          IndexedDBControl_GetConnectionCount_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetConnectionCount(
std::move(p_origin), std::move(callback));
      return true;
    }
    case internal::kIndexedDBControl_DownloadOriginData_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::IndexedDBControl::DownloadOriginData",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::IndexedDBControl::DownloadOriginData");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::IndexedDBControl_DownloadOriginData_Params_Data* params =
          reinterpret_cast<
              internal::IndexedDBControl_DownloadOriginData_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::url::Origin p_origin{};
      IndexedDBControl_DownloadOriginData_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBControl::Name_, 5, false);
        return false;
      }
      IndexedDBControl::DownloadOriginDataCallback callback =
          IndexedDBControl_DownloadOriginData_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DownloadOriginData(
std::move(p_origin), std::move(callback));
      return true;
    }
    case internal::kIndexedDBControl_GetAllOriginsDetails_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::IndexedDBControl::GetAllOriginsDetails",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::IndexedDBControl::GetAllOriginsDetails");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::IndexedDBControl_GetAllOriginsDetails_Params_Data* params =
          reinterpret_cast<
              internal::IndexedDBControl_GetAllOriginsDetails_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      IndexedDBControl_GetAllOriginsDetails_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBControl::Name_, 6, false);
        return false;
      }
      IndexedDBControl::GetAllOriginsDetailsCallback callback =
          IndexedDBControl_GetAllOriginsDetails_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAllOriginsDetails(std::move(callback));
      return true;
    }
    case internal::kIndexedDBControl_SetForceKeepSessionState_Name: {
      break;
    }
    case internal::kIndexedDBControl_AddObserver_Name: {
      break;
    }
    case internal::kIndexedDBControl_ApplyPolicyUpdates_Name: {
      break;
    }
    case internal::kIndexedDBControl_BindTestInterface_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kIndexedDBControlValidationInfo[] = {
    {internal::kIndexedDBControl_BindIndexedDB_Name,
     {&internal::IndexedDBControl_BindIndexedDB_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kIndexedDBControl_GetUsage_Name,
     {&internal::IndexedDBControl_GetUsage_Params_Data::Validate,
      &internal::IndexedDBControl_GetUsage_ResponseParams_Data::Validate}},
    {internal::kIndexedDBControl_DeleteForOrigin_Name,
     {&internal::IndexedDBControl_DeleteForOrigin_Params_Data::Validate,
      &internal::IndexedDBControl_DeleteForOrigin_ResponseParams_Data::Validate}},
    {internal::kIndexedDBControl_ForceClose_Name,
     {&internal::IndexedDBControl_ForceClose_Params_Data::Validate,
      &internal::IndexedDBControl_ForceClose_ResponseParams_Data::Validate}},
    {internal::kIndexedDBControl_GetConnectionCount_Name,
     {&internal::IndexedDBControl_GetConnectionCount_Params_Data::Validate,
      &internal::IndexedDBControl_GetConnectionCount_ResponseParams_Data::Validate}},
    {internal::kIndexedDBControl_DownloadOriginData_Name,
     {&internal::IndexedDBControl_DownloadOriginData_Params_Data::Validate,
      &internal::IndexedDBControl_DownloadOriginData_ResponseParams_Data::Validate}},
    {internal::kIndexedDBControl_GetAllOriginsDetails_Name,
     {&internal::IndexedDBControl_GetAllOriginsDetails_Params_Data::Validate,
      &internal::IndexedDBControl_GetAllOriginsDetails_ResponseParams_Data::Validate}},
    {internal::kIndexedDBControl_SetForceKeepSessionState_Name,
     {&internal::IndexedDBControl_SetForceKeepSessionState_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kIndexedDBControl_AddObserver_Name,
     {&internal::IndexedDBControl_AddObserver_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kIndexedDBControl_ApplyPolicyUpdates_Name,
     {&internal::IndexedDBControl_ApplyPolicyUpdates_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kIndexedDBControl_BindTestInterface_Name,
     {&internal::IndexedDBControl_BindTestInterface_Params_Data::Validate,
      nullptr /* no response */}},
};

bool IndexedDBControlRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::storage::mojom::IndexedDBControl::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kIndexedDBControlValidationInfo);
}

bool IndexedDBControlResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::storage::mojom::IndexedDBControl::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kIndexedDBControlValidationInfo);

}
}  // namespace mojom
}  // namespace storage

namespace mojo {


// static
bool StructTraits<::storage::mojom::IndexedDBStorageUsageInfo::DataView, ::storage::mojom::IndexedDBStorageUsageInfoPtr>::Read(
    ::storage::mojom::IndexedDBStorageUsageInfo::DataView input,
    ::storage::mojom::IndexedDBStorageUsageInfoPtr* output) {
  bool success = true;
  ::storage::mojom::IndexedDBStorageUsageInfoPtr result(::storage::mojom::IndexedDBStorageUsageInfo::New());
  
      if (success && !input.ReadOrigin(&result->origin))
        success = false;
      if (success)
        result->size_in_bytes = input.size_in_bytes();
      if (success && !input.ReadLastModifiedTime(&result->last_modified_time))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::storage::mojom::IndexedDBStoragePolicyUpdate::DataView, ::storage::mojom::IndexedDBStoragePolicyUpdatePtr>::Read(
    ::storage::mojom::IndexedDBStoragePolicyUpdate::DataView input,
    ::storage::mojom::IndexedDBStoragePolicyUpdatePtr* output) {
  bool success = true;
  ::storage::mojom::IndexedDBStoragePolicyUpdatePtr result(::storage::mojom::IndexedDBStoragePolicyUpdate::New());
  
      if (success && !input.ReadOrigin(&result->origin))
        success = false;
      if (success)
        result->purge_on_shutdown = input.purge_on_shutdown();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif