// components/services/storage/public/mojom/session_storage_control.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SESSION_STORAGE_CONTROL_MOJOM_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SESSION_STORAGE_CONTROL_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "components/services/storage/public/mojom/session_storage_control.mojom-shared.h"
#include "components/services/storage/public/mojom/session_storage_control.mojom-forward.h"
#include "third_party/blink/public/mojom/dom_storage/storage_area.mojom.h"
#include "third_party/blink/public/mojom/dom_storage/session_storage_namespace.mojom.h"
#include "url/mojom/origin.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"





// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace storage {
namespace mojom {

class SessionStorageControlProxy;

template <typename ImplRefTraits>
class SessionStorageControlStub;

class SessionStorageControlRequestValidator;
class SessionStorageControlResponseValidator;


class  SessionStorageControl
    : public SessionStorageControlInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = SessionStorageControlInterfaceBase;
  using Proxy_ = SessionStorageControlProxy;

  template <typename ImplRefTraits>
  using Stub_ = SessionStorageControlStub<ImplRefTraits>;

  using RequestValidator_ = SessionStorageControlRequestValidator;
  using ResponseValidator_ = SessionStorageControlResponseValidator;
  enum MethodMinVersions : uint32_t {
    kBindNamespaceMinVersion = 0,
    kBindStorageAreaMinVersion = 0,
    kGetUsageMinVersion = 0,
    kDeleteStorageMinVersion = 0,
    kCleanUpStorageMinVersion = 0,
    kScavengeUnusedNamespacesMinVersion = 0,
    kFlushMinVersion = 0,
    kPurgeMemoryMinVersion = 0,
    kCreateNamespaceMinVersion = 0,
    kCloneNamespaceMinVersion = 0,
    kDeleteNamespaceMinVersion = 0,
  };
  virtual ~SessionStorageControl() {}


  using BindNamespaceCallback = base::OnceCallback<void(bool)>;
  
  virtual void BindNamespace(const std::string& namespace_id, ::mojo::PendingReceiver<::blink::mojom::SessionStorageNamespace> receiver, BindNamespaceCallback callback) = 0;


  using BindStorageAreaCallback = base::OnceCallback<void(bool)>;
  
  virtual void BindStorageArea(const ::url::Origin& origin, const std::string& namespace_id, ::mojo::PendingReceiver<::blink::mojom::StorageArea> receiver, BindStorageAreaCallback callback) = 0;


  using GetUsageCallback = base::OnceCallback<void(std::vector<SessionStorageUsageInfoPtr>)>;
  
  virtual void GetUsage(GetUsageCallback callback) = 0;


  using DeleteStorageCallback = base::OnceCallback<void()>;
  
  virtual void DeleteStorage(const ::url::Origin& origin, const std::string& namespace_id, DeleteStorageCallback callback) = 0;


  using CleanUpStorageCallback = base::OnceCallback<void()>;
  
  virtual void CleanUpStorage(CleanUpStorageCallback callback) = 0;


  using ScavengeUnusedNamespacesCallback = base::OnceCallback<void()>;
  
  virtual void ScavengeUnusedNamespaces(ScavengeUnusedNamespacesCallback callback) = 0;


  using FlushCallback = base::OnceCallback<void()>;
  
  virtual void Flush(FlushCallback callback) = 0;

  
  virtual void PurgeMemory() = 0;

  
  virtual void CreateNamespace(const std::string& namespace_id) = 0;

  
  virtual void CloneNamespace(const std::string& namespace_id_to_clone, const std::string& clone_namespace_id, SessionStorageCloneType clone_type) = 0;

  
  virtual void DeleteNamespace(const std::string& namespace_id, bool should_persist) = 0;
};



class  SessionStorageControlProxy
    : public SessionStorageControl {
 public:
  using InterfaceType = SessionStorageControl;

  explicit SessionStorageControlProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void BindNamespace(const std::string& namespace_id, ::mojo::PendingReceiver<::blink::mojom::SessionStorageNamespace> receiver, BindNamespaceCallback callback) final;
  
  void BindStorageArea(const ::url::Origin& origin, const std::string& namespace_id, ::mojo::PendingReceiver<::blink::mojom::StorageArea> receiver, BindStorageAreaCallback callback) final;
  
  void GetUsage(GetUsageCallback callback) final;
  
  void DeleteStorage(const ::url::Origin& origin, const std::string& namespace_id, DeleteStorageCallback callback) final;
  
  void CleanUpStorage(CleanUpStorageCallback callback) final;
  
  void ScavengeUnusedNamespaces(ScavengeUnusedNamespacesCallback callback) final;
  
  void Flush(FlushCallback callback) final;
  
  void PurgeMemory() final;
  
  void CreateNamespace(const std::string& namespace_id) final;
  
  void CloneNamespace(const std::string& namespace_id_to_clone, const std::string& clone_namespace_id, SessionStorageCloneType clone_type) final;
  
  void DeleteNamespace(const std::string& namespace_id, bool should_persist) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  SessionStorageControlStubDispatch {
 public:
  static bool Accept(SessionStorageControl* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SessionStorageControl* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SessionStorageControl>>
class SessionStorageControlStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SessionStorageControlStub() {}
  ~SessionStorageControlStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SessionStorageControlStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SessionStorageControlStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SessionStorageControlRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SessionStorageControlResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  SessionStorageUsageInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SessionStorageUsageInfo, T>::value>;
  using DataView = SessionStorageUsageInfoDataView;
  using Data_ = internal::SessionStorageUsageInfo_Data;

  template <typename... Args>
  static SessionStorageUsageInfoPtr New(Args&&... args) {
    return SessionStorageUsageInfoPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SessionStorageUsageInfoPtr From(const U& u) {
    return mojo::TypeConverter<SessionStorageUsageInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SessionStorageUsageInfo>::Convert(*this);
  }


  SessionStorageUsageInfo();

  SessionStorageUsageInfo(
      const ::url::Origin& origin,
      const std::string& namespace_id);

  ~SessionStorageUsageInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SessionStorageUsageInfoPtr>
  SessionStorageUsageInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SessionStorageUsageInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SessionStorageUsageInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SessionStorageUsageInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SessionStorageUsageInfo_UnserializedMessageContext<
            UserType, SessionStorageUsageInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<SessionStorageUsageInfo::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return SessionStorageUsageInfo::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SessionStorageUsageInfo_UnserializedMessageContext<
            UserType, SessionStorageUsageInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SessionStorageUsageInfo::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::url::Origin origin;
  
  std::string namespace_id;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SessionStorageUsageInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SessionStorageUsageInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SessionStorageUsageInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SessionStorageUsageInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
SessionStorageUsageInfoPtr SessionStorageUsageInfo::Clone() const {
  return New(
      mojo::Clone(origin),
      mojo::Clone(namespace_id)
  );
}

template <typename T, SessionStorageUsageInfo::EnableIfSame<T>*>
bool SessionStorageUsageInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->origin, other_struct.origin))
    return false;
  if (!mojo::Equals(this->namespace_id, other_struct.namespace_id))
    return false;
  return true;
}

template <typename T, SessionStorageUsageInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.origin, rhs.origin))
    return true;
  if (std::less<>{}(rhs.origin, lhs.origin))
    return false;
  if (std::less<>{}(lhs.namespace_id, rhs.namespace_id))
    return true;
  if (std::less<>{}(rhs.namespace_id, lhs.namespace_id))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace storage

namespace mojo {


template <>
struct  StructTraits<::storage::mojom::SessionStorageUsageInfo::DataView,
                                         ::storage::mojom::SessionStorageUsageInfoPtr> {
  static bool IsNull(const ::storage::mojom::SessionStorageUsageInfoPtr& input) { return !input; }
  static void SetToNull(::storage::mojom::SessionStorageUsageInfoPtr* output) { output->reset(); }

  static const decltype(::storage::mojom::SessionStorageUsageInfo::origin)& origin(
      const ::storage::mojom::SessionStorageUsageInfoPtr& input) {
    return input->origin;
  }

  static const decltype(::storage::mojom::SessionStorageUsageInfo::namespace_id)& namespace_id(
      const ::storage::mojom::SessionStorageUsageInfoPtr& input) {
    return input->namespace_id;
  }

  static bool Read(::storage::mojom::SessionStorageUsageInfo::DataView input, ::storage::mojom::SessionStorageUsageInfoPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SESSION_STORAGE_CONTROL_MOJOM_H_