// This file is generated by TypeBuilder_h.template.

// Copyright (c) 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef content_protocol_Tracing_h
#define content_protocol_Tracing_h

#include "content/common/content_export.h"
#include "content/browser/devtools/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.
#include "content/browser/devtools/protocol/io.h"

namespace content {
namespace protocol {
namespace Tracing {
using MemoryDumpConfig = Object;
class TraceConfig;
using StreamFormat = String;
using StreamCompression = String;

// ------------- Forward and enum declarations.

namespace StreamFormatEnum {
CONTENT_EXPORT extern const char Json[];
CONTENT_EXPORT extern const char Proto[];
} // namespace StreamFormatEnum

namespace StreamCompressionEnum {
CONTENT_EXPORT extern const char None[];
CONTENT_EXPORT extern const char Gzip[];
} // namespace StreamCompressionEnum

namespace Start {
namespace TransferModeEnum {
CONTENT_EXPORT extern const char* ReportEvents;
CONTENT_EXPORT extern const char* ReturnAsStream;
} // TransferModeEnum
} // Start

// ------------- Type and builder declarations.

class CONTENT_EXPORT TraceConfig : public ::crdtp::ProtocolObject<TraceConfig> {
public:
    ~TraceConfig() override { }

    struct CONTENT_EXPORT RecordModeEnum {
        static const char* RecordUntilFull;
        static const char* RecordContinuously;
        static const char* RecordAsMuchAsPossible;
        static const char* EchoToConsole;
    }; // RecordModeEnum

    bool HasRecordMode() { return m_recordMode.isJust(); }
    String GetRecordMode(const String& defaultValue) { return m_recordMode.isJust() ? m_recordMode.fromJust() : defaultValue; }
    void SetRecordMode(const String& value) { m_recordMode = value; }

    bool HasEnableSampling() { return m_enableSampling.isJust(); }
    bool GetEnableSampling(bool defaultValue) { return m_enableSampling.isJust() ? m_enableSampling.fromJust() : defaultValue; }
    void SetEnableSampling(bool value) { m_enableSampling = value; }

    bool HasEnableSystrace() { return m_enableSystrace.isJust(); }
    bool GetEnableSystrace(bool defaultValue) { return m_enableSystrace.isJust() ? m_enableSystrace.fromJust() : defaultValue; }
    void SetEnableSystrace(bool value) { m_enableSystrace = value; }

    bool HasEnableArgumentFilter() { return m_enableArgumentFilter.isJust(); }
    bool GetEnableArgumentFilter(bool defaultValue) { return m_enableArgumentFilter.isJust() ? m_enableArgumentFilter.fromJust() : defaultValue; }
    void SetEnableArgumentFilter(bool value) { m_enableArgumentFilter = value; }

    bool HasIncludedCategories() { return m_includedCategories.isJust(); }
    protocol::Array<String>* GetIncludedCategories(protocol::Array<String>* defaultValue) { return m_includedCategories.isJust() ? m_includedCategories.fromJust() : defaultValue; }
    void SetIncludedCategories(std::unique_ptr<protocol::Array<String>> value) { m_includedCategories = std::move(value); }

    bool HasExcludedCategories() { return m_excludedCategories.isJust(); }
    protocol::Array<String>* GetExcludedCategories(protocol::Array<String>* defaultValue) { return m_excludedCategories.isJust() ? m_excludedCategories.fromJust() : defaultValue; }
    void SetExcludedCategories(std::unique_ptr<protocol::Array<String>> value) { m_excludedCategories = std::move(value); }

    bool HasSyntheticDelays() { return m_syntheticDelays.isJust(); }
    protocol::Array<String>* GetSyntheticDelays(protocol::Array<String>* defaultValue) { return m_syntheticDelays.isJust() ? m_syntheticDelays.fromJust() : defaultValue; }
    void SetSyntheticDelays(std::unique_ptr<protocol::Array<String>> value) { m_syntheticDelays = std::move(value); }

    bool HasMemoryDumpConfig() { return m_memoryDumpConfig.isJust(); }
    protocol::Tracing::MemoryDumpConfig* GetMemoryDumpConfig(protocol::Tracing::MemoryDumpConfig* defaultValue) { return m_memoryDumpConfig.isJust() ? m_memoryDumpConfig.fromJust() : defaultValue; }
    void SetMemoryDumpConfig(std::unique_ptr<protocol::Tracing::MemoryDumpConfig> value) { m_memoryDumpConfig = std::move(value); }

    template<int STATE>
    class TraceConfigBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AllFieldsSet = (0)};


        TraceConfigBuilder<STATE>& SetRecordMode(const String& value)
        {
            m_result->SetRecordMode(value);
            return *this;
        }

        TraceConfigBuilder<STATE>& SetEnableSampling(bool value)
        {
            m_result->SetEnableSampling(value);
            return *this;
        }

        TraceConfigBuilder<STATE>& SetEnableSystrace(bool value)
        {
            m_result->SetEnableSystrace(value);
            return *this;
        }

        TraceConfigBuilder<STATE>& SetEnableArgumentFilter(bool value)
        {
            m_result->SetEnableArgumentFilter(value);
            return *this;
        }

        TraceConfigBuilder<STATE>& SetIncludedCategories(std::unique_ptr<protocol::Array<String>> value)
        {
            m_result->SetIncludedCategories(std::move(value));
            return *this;
        }

        TraceConfigBuilder<STATE>& SetExcludedCategories(std::unique_ptr<protocol::Array<String>> value)
        {
            m_result->SetExcludedCategories(std::move(value));
            return *this;
        }

        TraceConfigBuilder<STATE>& SetSyntheticDelays(std::unique_ptr<protocol::Array<String>> value)
        {
            m_result->SetSyntheticDelays(std::move(value));
            return *this;
        }

        TraceConfigBuilder<STATE>& SetMemoryDumpConfig(std::unique_ptr<protocol::Tracing::MemoryDumpConfig> value)
        {
            m_result->SetMemoryDumpConfig(std::move(value));
            return *this;
        }

        std::unique_ptr<TraceConfig> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class TraceConfig;
        TraceConfigBuilder() : m_result(new TraceConfig()) { }

        template<int STEP> TraceConfigBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<TraceConfigBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Tracing::TraceConfig> m_result;
    };

    static TraceConfigBuilder<0> Create()
    {
        return TraceConfigBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    TraceConfig()
    {
    }

    Maybe<String> m_recordMode;
    Maybe<bool> m_enableSampling;
    Maybe<bool> m_enableSystrace;
    Maybe<bool> m_enableArgumentFilter;
    Maybe<protocol::Array<String>> m_includedCategories;
    Maybe<protocol::Array<String>> m_excludedCategories;
    Maybe<protocol::Array<String>> m_syntheticDelays;
    Maybe<protocol::Tracing::MemoryDumpConfig> m_memoryDumpConfig;
};


// ------------- Backend interface.

class CONTENT_EXPORT Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse End() = 0;
    class CONTENT_EXPORT GetCategoriesCallback {
    public:
        virtual void sendSuccess(std::unique_ptr<protocol::Array<String>> categories) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~GetCategoriesCallback() { }
    };
    virtual void GetCategories(std::unique_ptr<GetCategoriesCallback> callback) = 0;
    virtual DispatchResponse RecordClockSyncMarker(const String& in_syncId) = 0;
    class CONTENT_EXPORT RequestMemoryDumpCallback {
    public:
        virtual void sendSuccess(const String& dumpGuid, bool success) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~RequestMemoryDumpCallback() { }
    };
    virtual void RequestMemoryDump(Maybe<bool> in_deterministic, std::unique_ptr<RequestMemoryDumpCallback> callback) = 0;
    class CONTENT_EXPORT StartCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~StartCallback() { }
    };
    virtual void Start(Maybe<String> in_categories, Maybe<String> in_options, Maybe<double> in_bufferUsageReportingInterval, Maybe<String> in_transferMode, Maybe<String> in_streamFormat, Maybe<String> in_streamCompression, Maybe<protocol::Tracing::TraceConfig> in_traceConfig, std::unique_ptr<StartCallback> callback) = 0;

    virtual DispatchResponse Disable()
    {
        return DispatchResponse::Success();
    }
};

// ------------- Frontend interface.

class CONTENT_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void BufferUsage(Maybe<double> percentFull = Maybe<double>(), Maybe<double> eventCount = Maybe<double>(), Maybe<double> value = Maybe<double>());
    void DataCollected(std::unique_ptr<protocol::Array<protocol::DictionaryValue>> value);
    void TracingComplete(bool dataLossOccurred, Maybe<String> stream = Maybe<String>(), Maybe<String> traceFormat = Maybe<String>(), Maybe<String> streamCompression = Maybe<String>());

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class CONTENT_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class CONTENT_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Tracing
} // namespace content
} // namespace protocol

#endif // !defined(content_protocol_Tracing_h)
