// This file is generated by TypeBuilder_h.template.

// Copyright (c) 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef content_protocol_WebAuthn_h
#define content_protocol_WebAuthn_h

#include "content/common/content_export.h"
#include "content/browser/devtools/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.

namespace content {
namespace protocol {
namespace WebAuthn {
using AuthenticatorId = String;
using AuthenticatorProtocol = String;
using AuthenticatorTransport = String;
class VirtualAuthenticatorOptions;
class Credential;

// ------------- Forward and enum declarations.

namespace AuthenticatorProtocolEnum {
CONTENT_EXPORT extern const char U2f[];
CONTENT_EXPORT extern const char Ctap2[];
} // namespace AuthenticatorProtocolEnum

namespace AuthenticatorTransportEnum {
CONTENT_EXPORT extern const char Usb[];
CONTENT_EXPORT extern const char Nfc[];
CONTENT_EXPORT extern const char Ble[];
CONTENT_EXPORT extern const char Cable[];
CONTENT_EXPORT extern const char Internal[];
} // namespace AuthenticatorTransportEnum

// ------------- Type and builder declarations.

class CONTENT_EXPORT VirtualAuthenticatorOptions : public ::crdtp::ProtocolObject<VirtualAuthenticatorOptions> {
public:
    ~VirtualAuthenticatorOptions() override { }

    String GetProtocol() { return m_protocol; }
    void SetProtocol(const String& value) { m_protocol = value; }

    String GetTransport() { return m_transport; }
    void SetTransport(const String& value) { m_transport = value; }

    bool HasHasResidentKey() { return m_hasResidentKey.isJust(); }
    bool GetHasResidentKey(bool defaultValue) { return m_hasResidentKey.isJust() ? m_hasResidentKey.fromJust() : defaultValue; }
    void SetHasResidentKey(bool value) { m_hasResidentKey = value; }

    bool HasHasUserVerification() { return m_hasUserVerification.isJust(); }
    bool GetHasUserVerification(bool defaultValue) { return m_hasUserVerification.isJust() ? m_hasUserVerification.fromJust() : defaultValue; }
    void SetHasUserVerification(bool value) { m_hasUserVerification = value; }

    bool HasAutomaticPresenceSimulation() { return m_automaticPresenceSimulation.isJust(); }
    bool GetAutomaticPresenceSimulation(bool defaultValue) { return m_automaticPresenceSimulation.isJust() ? m_automaticPresenceSimulation.fromJust() : defaultValue; }
    void SetAutomaticPresenceSimulation(bool value) { m_automaticPresenceSimulation = value; }

    bool HasIsUserVerified() { return m_isUserVerified.isJust(); }
    bool GetIsUserVerified(bool defaultValue) { return m_isUserVerified.isJust() ? m_isUserVerified.fromJust() : defaultValue; }
    void SetIsUserVerified(bool value) { m_isUserVerified = value; }

    template<int STATE>
    class VirtualAuthenticatorOptionsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ProtocolSet = 1 << 1,
            TransportSet = 1 << 2,
            AllFieldsSet = (ProtocolSet | TransportSet | 0)};


        VirtualAuthenticatorOptionsBuilder<STATE | ProtocolSet>& SetProtocol(const String& value)
        {
            static_assert(!(STATE & ProtocolSet), "property protocol should not be set yet");
            m_result->SetProtocol(value);
            return castState<ProtocolSet>();
        }

        VirtualAuthenticatorOptionsBuilder<STATE | TransportSet>& SetTransport(const String& value)
        {
            static_assert(!(STATE & TransportSet), "property transport should not be set yet");
            m_result->SetTransport(value);
            return castState<TransportSet>();
        }

        VirtualAuthenticatorOptionsBuilder<STATE>& SetHasResidentKey(bool value)
        {
            m_result->SetHasResidentKey(value);
            return *this;
        }

        VirtualAuthenticatorOptionsBuilder<STATE>& SetHasUserVerification(bool value)
        {
            m_result->SetHasUserVerification(value);
            return *this;
        }

        VirtualAuthenticatorOptionsBuilder<STATE>& SetAutomaticPresenceSimulation(bool value)
        {
            m_result->SetAutomaticPresenceSimulation(value);
            return *this;
        }

        VirtualAuthenticatorOptionsBuilder<STATE>& SetIsUserVerified(bool value)
        {
            m_result->SetIsUserVerified(value);
            return *this;
        }

        std::unique_ptr<VirtualAuthenticatorOptions> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class VirtualAuthenticatorOptions;
        VirtualAuthenticatorOptionsBuilder() : m_result(new VirtualAuthenticatorOptions()) { }

        template<int STEP> VirtualAuthenticatorOptionsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<VirtualAuthenticatorOptionsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::WebAuthn::VirtualAuthenticatorOptions> m_result;
    };

    static VirtualAuthenticatorOptionsBuilder<0> Create()
    {
        return VirtualAuthenticatorOptionsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    VirtualAuthenticatorOptions()
    {
    }

    String m_protocol;
    String m_transport;
    Maybe<bool> m_hasResidentKey;
    Maybe<bool> m_hasUserVerification;
    Maybe<bool> m_automaticPresenceSimulation;
    Maybe<bool> m_isUserVerified;
};


class CONTENT_EXPORT Credential : public ::crdtp::ProtocolObject<Credential> {
public:
    ~Credential() override { }

    Binary GetCredentialId() { return m_credentialId; }
    void SetCredentialId(const Binary& value) { m_credentialId = value; }

    bool GetIsResidentCredential() { return m_isResidentCredential; }
    void SetIsResidentCredential(bool value) { m_isResidentCredential = value; }

    bool HasRpId() { return m_rpId.isJust(); }
    String GetRpId(const String& defaultValue) { return m_rpId.isJust() ? m_rpId.fromJust() : defaultValue; }
    void SetRpId(const String& value) { m_rpId = value; }

    Binary GetPrivateKey() { return m_privateKey; }
    void SetPrivateKey(const Binary& value) { m_privateKey = value; }

    bool HasUserHandle() { return m_userHandle.isJust(); }
    Binary GetUserHandle(const Binary& defaultValue) { return m_userHandle.isJust() ? m_userHandle.fromJust() : defaultValue; }
    void SetUserHandle(const Binary& value) { m_userHandle = value; }

    int GetSignCount() { return m_signCount; }
    void SetSignCount(int value) { m_signCount = value; }

    template<int STATE>
    class CredentialBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            CredentialIdSet = 1 << 1,
            IsResidentCredentialSet = 1 << 2,
            PrivateKeySet = 1 << 3,
            SignCountSet = 1 << 4,
            AllFieldsSet = (CredentialIdSet | IsResidentCredentialSet | PrivateKeySet | SignCountSet | 0)};


        CredentialBuilder<STATE | CredentialIdSet>& SetCredentialId(const Binary& value)
        {
            static_assert(!(STATE & CredentialIdSet), "property credentialId should not be set yet");
            m_result->SetCredentialId(value);
            return castState<CredentialIdSet>();
        }

        CredentialBuilder<STATE | IsResidentCredentialSet>& SetIsResidentCredential(bool value)
        {
            static_assert(!(STATE & IsResidentCredentialSet), "property isResidentCredential should not be set yet");
            m_result->SetIsResidentCredential(value);
            return castState<IsResidentCredentialSet>();
        }

        CredentialBuilder<STATE>& SetRpId(const String& value)
        {
            m_result->SetRpId(value);
            return *this;
        }

        CredentialBuilder<STATE | PrivateKeySet>& SetPrivateKey(const Binary& value)
        {
            static_assert(!(STATE & PrivateKeySet), "property privateKey should not be set yet");
            m_result->SetPrivateKey(value);
            return castState<PrivateKeySet>();
        }

        CredentialBuilder<STATE>& SetUserHandle(const Binary& value)
        {
            m_result->SetUserHandle(value);
            return *this;
        }

        CredentialBuilder<STATE | SignCountSet>& SetSignCount(int value)
        {
            static_assert(!(STATE & SignCountSet), "property signCount should not be set yet");
            m_result->SetSignCount(value);
            return castState<SignCountSet>();
        }

        std::unique_ptr<Credential> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class Credential;
        CredentialBuilder() : m_result(new Credential()) { }

        template<int STEP> CredentialBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CredentialBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::WebAuthn::Credential> m_result;
    };

    static CredentialBuilder<0> Create()
    {
        return CredentialBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    Credential()
    {
          m_isResidentCredential = false;
          m_signCount = 0;
    }

    Binary m_credentialId;
    bool m_isResidentCredential;
    Maybe<String> m_rpId;
    Binary m_privateKey;
    Maybe<Binary> m_userHandle;
    int m_signCount;
};


// ------------- Backend interface.

class CONTENT_EXPORT Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse Enable() = 0;
    virtual DispatchResponse Disable() = 0;
    virtual DispatchResponse AddVirtualAuthenticator(std::unique_ptr<protocol::WebAuthn::VirtualAuthenticatorOptions> in_options, String* out_authenticatorId) = 0;
    virtual DispatchResponse RemoveVirtualAuthenticator(const String& in_authenticatorId) = 0;
    virtual DispatchResponse AddCredential(const String& in_authenticatorId, std::unique_ptr<protocol::WebAuthn::Credential> in_credential) = 0;
    virtual DispatchResponse GetCredential(const String& in_authenticatorId, const Binary& in_credentialId, std::unique_ptr<protocol::WebAuthn::Credential>* out_credential) = 0;
    virtual DispatchResponse GetCredentials(const String& in_authenticatorId, std::unique_ptr<protocol::Array<protocol::WebAuthn::Credential>>* out_credentials) = 0;
    virtual DispatchResponse RemoveCredential(const String& in_authenticatorId, const Binary& in_credentialId) = 0;
    virtual DispatchResponse ClearCredentials(const String& in_authenticatorId) = 0;
    virtual DispatchResponse SetUserVerified(const String& in_authenticatorId, bool in_isUserVerified) = 0;
    virtual DispatchResponse SetAutomaticPresenceSimulation(const String& in_authenticatorId, bool in_enabled) = 0;

};

// ------------- Frontend interface.

class CONTENT_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class CONTENT_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class CONTENT_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace WebAuthn
} // namespace content
} // namespace protocol

#endif // !defined(content_protocol_WebAuthn_h)
