// content/common/agent_scheduling_group.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/common/agent_scheduling_group.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "content/common/agent_scheduling_group.mojom-params-data.h"
#include "content/common/agent_scheduling_group.mojom-shared-message-ids.h"

#include "content/common/agent_scheduling_group.mojom-import-headers.h"


#ifndef CONTENT_COMMON_AGENT_SCHEDULING_GROUP_MOJOM_JUMBO_H_
#define CONTENT_COMMON_AGENT_SCHEDULING_GROUP_MOJOM_JUMBO_H_
#include "content/common/frame_messages.h"
#include "content/common/input_messages.h"
#include "content/common/view_messages.h"
#include "content/common/widget_messages.h"
#include "content/public/common/common_param_traits.h"
#include "services/network/public/cpp/p2p_param_traits.h"
#endif
namespace content {
namespace mojom {
CreateViewParams::CreateViewParams()
    : renderer_preferences(),
      web_preferences(),
      view_id(::IPC::mojom::kRoutingIdNone),
      main_frame_routing_id(::IPC::mojom::kRoutingIdNone),
      main_frame_widget_routing_id(::IPC::mojom::kRoutingIdNone),
      main_frame_interface_bundle(),
      frame_widget_host(),
      frame_widget(),
      widget_host(),
      widget(),
      session_storage_namespace_id(),
      opener_frame_token(),
      replicated_frame_state(),
      main_frame_frame_token(),
      devtools_main_frame_token(),
      proxy_routing_id(::IPC::mojom::kRoutingIdNone),
      hidden(),
      never_composited(),
      window_was_created_with_opener(),
      has_committed_real_load(),
      visual_properties(),
      renderer_wide_named_frame_lookup(),
      type(),
      blink_page_broadcast() {}

CreateViewParams::CreateViewParams(
    ::blink::mojom::RendererPreferencesPtr renderer_preferences_in,
    const ::blink::web_pref::WebPreferences& web_preferences_in,
    int32_t view_id_in,
    int32_t main_frame_routing_id_in,
    int32_t main_frame_widget_routing_id_in,
    ::content::mojom::DocumentScopedInterfaceBundlePtr main_frame_interface_bundle_in,
    ::mojo::PendingAssociatedRemote<::blink::mojom::FrameWidgetHost> frame_widget_host_in,
    ::mojo::PendingAssociatedReceiver<::blink::mojom::FrameWidget> frame_widget_in,
    ::mojo::PendingAssociatedRemote<::blink::mojom::WidgetHost> widget_host_in,
    ::mojo::PendingAssociatedReceiver<::blink::mojom::Widget> widget_in,
    const std::string& session_storage_namespace_id_in,
    const base::Optional<::base::UnguessableToken>& opener_frame_token_in,
    const ::content::FrameReplicationState& replicated_frame_state_in,
    const ::base::UnguessableToken& main_frame_frame_token_in,
    const ::base::UnguessableToken& devtools_main_frame_token_in,
    int32_t proxy_routing_id_in,
    bool hidden_in,
    bool never_composited_in,
    bool window_was_created_with_opener_in,
    bool has_committed_real_load_in,
    const ::blink::VisualProperties& visual_properties_in,
    bool renderer_wide_named_frame_lookup_in,
    ViewWidgetType type_in,
    ::mojo::PendingAssociatedReceiver<::blink::mojom::PageBroadcast> blink_page_broadcast_in)
    : renderer_preferences(std::move(renderer_preferences_in)),
      web_preferences(std::move(web_preferences_in)),
      view_id(std::move(view_id_in)),
      main_frame_routing_id(std::move(main_frame_routing_id_in)),
      main_frame_widget_routing_id(std::move(main_frame_widget_routing_id_in)),
      main_frame_interface_bundle(std::move(main_frame_interface_bundle_in)),
      frame_widget_host(std::move(frame_widget_host_in)),
      frame_widget(std::move(frame_widget_in)),
      widget_host(std::move(widget_host_in)),
      widget(std::move(widget_in)),
      session_storage_namespace_id(std::move(session_storage_namespace_id_in)),
      opener_frame_token(std::move(opener_frame_token_in)),
      replicated_frame_state(std::move(replicated_frame_state_in)),
      main_frame_frame_token(std::move(main_frame_frame_token_in)),
      devtools_main_frame_token(std::move(devtools_main_frame_token_in)),
      proxy_routing_id(std::move(proxy_routing_id_in)),
      hidden(std::move(hidden_in)),
      never_composited(std::move(never_composited_in)),
      window_was_created_with_opener(std::move(window_was_created_with_opener_in)),
      has_committed_real_load(std::move(has_committed_real_load_in)),
      visual_properties(std::move(visual_properties_in)),
      renderer_wide_named_frame_lookup(std::move(renderer_wide_named_frame_lookup_in)),
      type(std::move(type_in)),
      blink_page_broadcast(std::move(blink_page_broadcast_in)) {}

CreateViewParams::~CreateViewParams() = default;

void CreateViewParams::AsValueInto(base::trace_event::TracedValue* value) const {
  if (this->renderer_preferences.is_null()) {
    value->SetString("renderer_preferences", "nullptr");
  } else {
    value->BeginDictionary("renderer_preferences");
    this->renderer_preferences->AsValueInto(value);
    value->EndDictionary();
  }
  value->SetString("web_preferences", base::trace_event::ValueToString(this->web_preferences, "<value of type const ::blink::web_pref::WebPreferences&>"));
  value->SetInteger("view_id", this->view_id);
  value->SetInteger("main_frame_routing_id", this->main_frame_routing_id);
  value->SetInteger("main_frame_widget_routing_id", this->main_frame_widget_routing_id);
  if (this->main_frame_interface_bundle.is_null()) {
    value->SetString("main_frame_interface_bundle", "nullptr");
  } else {
    value->BeginDictionary("main_frame_interface_bundle");
    this->main_frame_interface_bundle->AsValueInto(value);
    value->EndDictionary();
  }
  value->SetBoolean("frame_widget_host", this->frame_widget_host.is_valid());
  value->SetBoolean("frame_widget", this->frame_widget.is_valid());
  value->SetBoolean("widget_host", this->widget_host.is_valid());
  value->SetBoolean("widget", this->widget.is_valid());
  value->SetString("session_storage_namespace_id", this->session_storage_namespace_id);
  value->SetString("opener_frame_token", base::trace_event::ValueToString(this->opener_frame_token, "<value of type const base::Optional<::base::UnguessableToken>&>"));
  value->SetString("replicated_frame_state", base::trace_event::ValueToString(this->replicated_frame_state, "<value of type const ::content::FrameReplicationState&>"));
  value->SetString("main_frame_frame_token", base::trace_event::ValueToString(this->main_frame_frame_token, "<value of type const ::base::UnguessableToken&>"));
  value->SetString("devtools_main_frame_token", base::trace_event::ValueToString(this->devtools_main_frame_token, "<value of type const ::base::UnguessableToken&>"));
  value->SetInteger("proxy_routing_id", this->proxy_routing_id);
  value->SetBoolean("hidden", this->hidden);
  value->SetBoolean("never_composited", this->never_composited);
  value->SetBoolean("window_was_created_with_opener", this->window_was_created_with_opener);
  value->SetBoolean("has_committed_real_load", this->has_committed_real_load);
  value->SetString("visual_properties", base::trace_event::ValueToString(this->visual_properties, "<value of type const ::blink::VisualProperties&>"));
  value->SetBoolean("renderer_wide_named_frame_lookup", this->renderer_wide_named_frame_lookup);
  value->SetString("type", base::trace_event::ValueToString(this->type));
  value->SetBoolean("blink_page_broadcast", this->blink_page_broadcast.is_valid());
}

bool CreateViewParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CreateFrameWidgetParams::CreateFrameWidgetParams()
    : routing_id(),
      frame_widget_host(),
      frame_widget(),
      widget_host(),
      widget(),
      visual_properties() {}

CreateFrameWidgetParams::CreateFrameWidgetParams(
    int32_t routing_id_in,
    ::mojo::PendingAssociatedRemote<::blink::mojom::FrameWidgetHost> frame_widget_host_in,
    ::mojo::PendingAssociatedReceiver<::blink::mojom::FrameWidget> frame_widget_in,
    ::mojo::PendingAssociatedRemote<::blink::mojom::WidgetHost> widget_host_in,
    ::mojo::PendingAssociatedReceiver<::blink::mojom::Widget> widget_in,
    const ::blink::VisualProperties& visual_properties_in)
    : routing_id(std::move(routing_id_in)),
      frame_widget_host(std::move(frame_widget_host_in)),
      frame_widget(std::move(frame_widget_in)),
      widget_host(std::move(widget_host_in)),
      widget(std::move(widget_in)),
      visual_properties(std::move(visual_properties_in)) {}

CreateFrameWidgetParams::~CreateFrameWidgetParams() = default;

void CreateFrameWidgetParams::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetInteger("routing_id", this->routing_id);
  value->SetBoolean("frame_widget_host", this->frame_widget_host.is_valid());
  value->SetBoolean("frame_widget", this->frame_widget.is_valid());
  value->SetBoolean("widget_host", this->widget_host.is_valid());
  value->SetBoolean("widget", this->widget.is_valid());
  value->SetString("visual_properties", base::trace_event::ValueToString(this->visual_properties, "<value of type const ::blink::VisualProperties&>"));
}

bool CreateFrameWidgetParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CreateFrameParams::CreateFrameParams()
    : routing_id(),
      previous_routing_id(),
      frame_token(),
      opener_frame_token(),
      parent_routing_id(),
      previous_sibling_routing_id(),
      interface_bundle(),
      replication_state(),
      devtools_frame_token(),
      frame_owner_properties(),
      widget_params(),
      has_committed_real_load() {}

CreateFrameParams::CreateFrameParams(
    int32_t routing_id_in,
    int32_t previous_routing_id_in,
    const ::base::UnguessableToken& frame_token_in,
    const base::Optional<::base::UnguessableToken>& opener_frame_token_in,
    int32_t parent_routing_id_in,
    int32_t previous_sibling_routing_id_in,
    ::content::mojom::DocumentScopedInterfaceBundlePtr interface_bundle_in,
    const ::content::FrameReplicationState& replication_state_in,
    const ::base::UnguessableToken& devtools_frame_token_in,
    ::blink::mojom::FrameOwnerPropertiesPtr frame_owner_properties_in,
    CreateFrameWidgetParamsPtr widget_params_in,
    bool has_committed_real_load_in)
    : routing_id(std::move(routing_id_in)),
      previous_routing_id(std::move(previous_routing_id_in)),
      frame_token(std::move(frame_token_in)),
      opener_frame_token(std::move(opener_frame_token_in)),
      parent_routing_id(std::move(parent_routing_id_in)),
      previous_sibling_routing_id(std::move(previous_sibling_routing_id_in)),
      interface_bundle(std::move(interface_bundle_in)),
      replication_state(std::move(replication_state_in)),
      devtools_frame_token(std::move(devtools_frame_token_in)),
      frame_owner_properties(std::move(frame_owner_properties_in)),
      widget_params(std::move(widget_params_in)),
      has_committed_real_load(std::move(has_committed_real_load_in)) {}

CreateFrameParams::~CreateFrameParams() = default;

void CreateFrameParams::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetInteger("routing_id", this->routing_id);
  value->SetInteger("previous_routing_id", this->previous_routing_id);
  value->SetString("frame_token", base::trace_event::ValueToString(this->frame_token, "<value of type const ::base::UnguessableToken&>"));
  value->SetString("opener_frame_token", base::trace_event::ValueToString(this->opener_frame_token, "<value of type const base::Optional<::base::UnguessableToken>&>"));
  value->SetInteger("parent_routing_id", this->parent_routing_id);
  value->SetInteger("previous_sibling_routing_id", this->previous_sibling_routing_id);
  if (this->interface_bundle.is_null()) {
    value->SetString("interface_bundle", "nullptr");
  } else {
    value->BeginDictionary("interface_bundle");
    this->interface_bundle->AsValueInto(value);
    value->EndDictionary();
  }
  value->SetString("replication_state", base::trace_event::ValueToString(this->replication_state, "<value of type const ::content::FrameReplicationState&>"));
  value->SetString("devtools_frame_token", base::trace_event::ValueToString(this->devtools_frame_token, "<value of type const ::base::UnguessableToken&>"));
  if (this->frame_owner_properties.is_null()) {
    value->SetString("frame_owner_properties", "nullptr");
  } else {
    value->BeginDictionary("frame_owner_properties");
    this->frame_owner_properties->AsValueInto(value);
    value->EndDictionary();
  }
  if (this->widget_params.is_null()) {
    value->SetString("widget_params", "nullptr");
  } else {
    value->BeginDictionary("widget_params");
    this->widget_params->AsValueInto(value);
    value->EndDictionary();
  }
  value->SetBoolean("has_committed_real_load", this->has_committed_real_load);
}

bool CreateFrameParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char AgentSchedulingGroupHost::Name_[] = "content.mojom.AgentSchedulingGroupHost";

AgentSchedulingGroupHostProxy::AgentSchedulingGroupHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

// static
bool AgentSchedulingGroupHostStubDispatch::Accept(
    AgentSchedulingGroupHost* impl,
    mojo::Message* message) {
  return false;
}

// static
bool AgentSchedulingGroupHostStubDispatch::AcceptWithResponder(
    AgentSchedulingGroupHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  return false;
}



bool AgentSchedulingGroupHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::AgentSchedulingGroupHost::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, {});
}

const char AgentSchedulingGroup::Name_[] = "content.mojom.AgentSchedulingGroup";

AgentSchedulingGroupProxy::AgentSchedulingGroupProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AgentSchedulingGroupProxy::CreateView(
    CreateViewParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::AgentSchedulingGroup::CreateView", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_params.is_null()) {
        raw_value->SetString("params", "nullptr");
      } else {
        raw_value->BeginDictionary("params");
        in_params->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kAgentSchedulingGroup_CreateView_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::AgentSchedulingGroup_CreateView_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->params)::BaseType::BufferWriter
      params_writer;
  mojo::internal::Serialize<::content::mojom::CreateViewParamsDataView>(
      in_params, buffer, &params_writer, &serialization_context);
  params->params.Set(
      params_writer.is_null() ? nullptr : params_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in AgentSchedulingGroup.CreateView request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AgentSchedulingGroup::Name_);
  message.set_method_name("CreateView");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void AgentSchedulingGroupProxy::DestroyView(
    int32_t in_view_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::AgentSchedulingGroup::DestroyView", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("view_id", in_view_id);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kAgentSchedulingGroup_DestroyView_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::AgentSchedulingGroup_DestroyView_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->view_id = in_view_id;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AgentSchedulingGroup::Name_);
  message.set_method_name("DestroyView");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void AgentSchedulingGroupProxy::CreateFrame(
    CreateFrameParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::AgentSchedulingGroup::CreateFrame", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_params.is_null()) {
        raw_value->SetString("params", "nullptr");
      } else {
        raw_value->BeginDictionary("params");
        in_params->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kAgentSchedulingGroup_CreateFrame_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::AgentSchedulingGroup_CreateFrame_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->params)::BaseType::BufferWriter
      params_writer;
  mojo::internal::Serialize<::content::mojom::CreateFrameParamsDataView>(
      in_params, buffer, &params_writer, &serialization_context);
  params->params.Set(
      params_writer.is_null() ? nullptr : params_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in AgentSchedulingGroup.CreateFrame request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AgentSchedulingGroup::Name_);
  message.set_method_name("CreateFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void AgentSchedulingGroupProxy::CreateFrameProxy(
    int32_t in_routing_id, int32_t in_render_view_routing_id, const base::Optional<::base::UnguessableToken>& in_opener_frame_token, int32_t in_parent_routing_id, const ::content::FrameReplicationState& in_replication_state, const ::base::UnguessableToken& in_proxy_frame_token, const ::base::UnguessableToken& in_devtools_frame_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::AgentSchedulingGroup::CreateFrameProxy", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("routing_id", in_routing_id);
      raw_value->SetInteger("render_view_routing_id", in_render_view_routing_id);
      raw_value->SetString("opener_frame_token", base::trace_event::ValueToString(in_opener_frame_token, "<value of type const base::Optional<::base::UnguessableToken>&>"));
      raw_value->SetInteger("parent_routing_id", in_parent_routing_id);
      raw_value->SetString("replication_state", base::trace_event::ValueToString(in_replication_state, "<value of type const ::content::FrameReplicationState&>"));
      raw_value->SetString("proxy_frame_token", base::trace_event::ValueToString(in_proxy_frame_token, "<value of type const ::base::UnguessableToken&>"));
      raw_value->SetString("devtools_frame_token", base::trace_event::ValueToString(in_devtools_frame_token, "<value of type const ::base::UnguessableToken&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kAgentSchedulingGroup_CreateFrameProxy_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::AgentSchedulingGroup_CreateFrameProxy_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->routing_id = in_routing_id;
  params->render_view_routing_id = in_render_view_routing_id;
  typename decltype(params->opener_frame_token)::BaseType::BufferWriter
      opener_frame_token_writer;
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_opener_frame_token, buffer, &opener_frame_token_writer, &serialization_context);
  params->opener_frame_token.Set(
      opener_frame_token_writer.is_null() ? nullptr : opener_frame_token_writer.data());
  params->parent_routing_id = in_parent_routing_id;
  typename decltype(params->replication_state)::BaseType::BufferWriter
      replication_state_writer;
  mojo::internal::Serialize<::content::mojom::FrameReplicationStateDataView>(
      in_replication_state, buffer, &replication_state_writer, &serialization_context);
  params->replication_state.Set(
      replication_state_writer.is_null() ? nullptr : replication_state_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->replication_state.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null replication_state in AgentSchedulingGroup.CreateFrameProxy request");
  typename decltype(params->proxy_frame_token)::BaseType::BufferWriter
      proxy_frame_token_writer;
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_proxy_frame_token, buffer, &proxy_frame_token_writer, &serialization_context);
  params->proxy_frame_token.Set(
      proxy_frame_token_writer.is_null() ? nullptr : proxy_frame_token_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->proxy_frame_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null proxy_frame_token in AgentSchedulingGroup.CreateFrameProxy request");
  typename decltype(params->devtools_frame_token)::BaseType::BufferWriter
      devtools_frame_token_writer;
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_devtools_frame_token, buffer, &devtools_frame_token_writer, &serialization_context);
  params->devtools_frame_token.Set(
      devtools_frame_token_writer.is_null() ? nullptr : devtools_frame_token_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->devtools_frame_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null devtools_frame_token in AgentSchedulingGroup.CreateFrameProxy request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AgentSchedulingGroup::Name_);
  message.set_method_name("CreateFrameProxy");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool AgentSchedulingGroupStubDispatch::Accept(
    AgentSchedulingGroup* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kAgentSchedulingGroup_CreateView_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::AgentSchedulingGroup::CreateView",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::AgentSchedulingGroup::CreateView");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AgentSchedulingGroup_CreateView_Params_Data* params =
          reinterpret_cast<internal::AgentSchedulingGroup_CreateView_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      CreateViewParamsPtr p_params{};
      AgentSchedulingGroup_CreateView_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AgentSchedulingGroup::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateView(
std::move(p_params));
      return true;
    }
    case internal::kAgentSchedulingGroup_DestroyView_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::AgentSchedulingGroup::DestroyView",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::AgentSchedulingGroup::DestroyView");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AgentSchedulingGroup_DestroyView_Params_Data* params =
          reinterpret_cast<internal::AgentSchedulingGroup_DestroyView_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_view_id{};
      AgentSchedulingGroup_DestroyView_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_view_id = input_data_view.view_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AgentSchedulingGroup::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DestroyView(
std::move(p_view_id));
      return true;
    }
    case internal::kAgentSchedulingGroup_CreateFrame_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::AgentSchedulingGroup::CreateFrame",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::AgentSchedulingGroup::CreateFrame");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AgentSchedulingGroup_CreateFrame_Params_Data* params =
          reinterpret_cast<internal::AgentSchedulingGroup_CreateFrame_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      CreateFrameParamsPtr p_params{};
      AgentSchedulingGroup_CreateFrame_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AgentSchedulingGroup::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateFrame(
std::move(p_params));
      return true;
    }
    case internal::kAgentSchedulingGroup_CreateFrameProxy_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::AgentSchedulingGroup::CreateFrameProxy",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::AgentSchedulingGroup::CreateFrameProxy");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AgentSchedulingGroup_CreateFrameProxy_Params_Data* params =
          reinterpret_cast<internal::AgentSchedulingGroup_CreateFrameProxy_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_routing_id{};
      int32_t p_render_view_routing_id{};
      base::Optional<::base::UnguessableToken> p_opener_frame_token{};
      int32_t p_parent_routing_id{};
      ::content::FrameReplicationState p_replication_state{};
      ::base::UnguessableToken p_proxy_frame_token{};
      ::base::UnguessableToken p_devtools_frame_token{};
      AgentSchedulingGroup_CreateFrameProxy_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_routing_id = input_data_view.routing_id();
      if (success)
        p_render_view_routing_id = input_data_view.render_view_routing_id();
      if (success && !input_data_view.ReadOpenerFrameToken(&p_opener_frame_token))
        success = false;
      if (success)
        p_parent_routing_id = input_data_view.parent_routing_id();
      if (success && !input_data_view.ReadReplicationState(&p_replication_state))
        success = false;
      if (success && !input_data_view.ReadProxyFrameToken(&p_proxy_frame_token))
        success = false;
      if (success && !input_data_view.ReadDevtoolsFrameToken(&p_devtools_frame_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AgentSchedulingGroup::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateFrameProxy(
std::move(p_routing_id), 
std::move(p_render_view_routing_id), 
std::move(p_opener_frame_token), 
std::move(p_parent_routing_id), 
std::move(p_replication_state), 
std::move(p_proxy_frame_token), 
std::move(p_devtools_frame_token));
      return true;
    }
  }
  return false;
}

// static
bool AgentSchedulingGroupStubDispatch::AcceptWithResponder(
    AgentSchedulingGroup* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kAgentSchedulingGroup_CreateView_Name: {
      break;
    }
    case internal::kAgentSchedulingGroup_DestroyView_Name: {
      break;
    }
    case internal::kAgentSchedulingGroup_CreateFrame_Name: {
      break;
    }
    case internal::kAgentSchedulingGroup_CreateFrameProxy_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kAgentSchedulingGroupValidationInfo[] = {
    {internal::kAgentSchedulingGroup_CreateView_Name,
     {&internal::AgentSchedulingGroup_CreateView_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kAgentSchedulingGroup_DestroyView_Name,
     {&internal::AgentSchedulingGroup_DestroyView_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kAgentSchedulingGroup_CreateFrame_Name,
     {&internal::AgentSchedulingGroup_CreateFrame_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kAgentSchedulingGroup_CreateFrameProxy_Name,
     {&internal::AgentSchedulingGroup_CreateFrameProxy_Params_Data::Validate,
      nullptr /* no response */}},
};

bool AgentSchedulingGroupRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::AgentSchedulingGroup::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kAgentSchedulingGroupValidationInfo);
}

}  // namespace mojom
}  // namespace content

namespace mojo {


// static
bool StructTraits<::content::mojom::CreateViewParams::DataView, ::content::mojom::CreateViewParamsPtr>::Read(
    ::content::mojom::CreateViewParams::DataView input,
    ::content::mojom::CreateViewParamsPtr* output) {
  bool success = true;
  ::content::mojom::CreateViewParamsPtr result(::content::mojom::CreateViewParams::New());
  
      if (success && !input.ReadRendererPreferences(&result->renderer_preferences))
        success = false;
      if (success && !input.ReadWebPreferences(&result->web_preferences))
        success = false;
      if (success)
        result->view_id = input.view_id();
      if (success)
        result->main_frame_routing_id = input.main_frame_routing_id();
      if (success)
        result->main_frame_widget_routing_id = input.main_frame_widget_routing_id();
      if (success && !input.ReadMainFrameInterfaceBundle(&result->main_frame_interface_bundle))
        success = false;
      if (success) {
        result->frame_widget_host =
            input.TakeFrameWidgetHost<decltype(result->frame_widget_host)>();
      }
      if (success) {
        result->frame_widget =
            input.TakeFrameWidget<decltype(result->frame_widget)>();
      }
      if (success) {
        result->widget_host =
            input.TakeWidgetHost<decltype(result->widget_host)>();
      }
      if (success) {
        result->widget =
            input.TakeWidget<decltype(result->widget)>();
      }
      if (success && !input.ReadSessionStorageNamespaceId(&result->session_storage_namespace_id))
        success = false;
      if (success && !input.ReadOpenerFrameToken(&result->opener_frame_token))
        success = false;
      if (success && !input.ReadReplicatedFrameState(&result->replicated_frame_state))
        success = false;
      if (success && !input.ReadMainFrameFrameToken(&result->main_frame_frame_token))
        success = false;
      if (success && !input.ReadDevtoolsMainFrameToken(&result->devtools_main_frame_token))
        success = false;
      if (success)
        result->proxy_routing_id = input.proxy_routing_id();
      if (success)
        result->hidden = input.hidden();
      if (success)
        result->never_composited = input.never_composited();
      if (success)
        result->window_was_created_with_opener = input.window_was_created_with_opener();
      if (success)
        result->has_committed_real_load = input.has_committed_real_load();
      if (success && !input.ReadVisualProperties(&result->visual_properties))
        success = false;
      if (success)
        result->renderer_wide_named_frame_lookup = input.renderer_wide_named_frame_lookup();
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success) {
        result->blink_page_broadcast =
            input.TakeBlinkPageBroadcast<decltype(result->blink_page_broadcast)>();
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::content::mojom::CreateFrameWidgetParams::DataView, ::content::mojom::CreateFrameWidgetParamsPtr>::Read(
    ::content::mojom::CreateFrameWidgetParams::DataView input,
    ::content::mojom::CreateFrameWidgetParamsPtr* output) {
  bool success = true;
  ::content::mojom::CreateFrameWidgetParamsPtr result(::content::mojom::CreateFrameWidgetParams::New());
  
      if (success)
        result->routing_id = input.routing_id();
      if (success) {
        result->frame_widget_host =
            input.TakeFrameWidgetHost<decltype(result->frame_widget_host)>();
      }
      if (success) {
        result->frame_widget =
            input.TakeFrameWidget<decltype(result->frame_widget)>();
      }
      if (success) {
        result->widget_host =
            input.TakeWidgetHost<decltype(result->widget_host)>();
      }
      if (success) {
        result->widget =
            input.TakeWidget<decltype(result->widget)>();
      }
      if (success && !input.ReadVisualProperties(&result->visual_properties))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::content::mojom::CreateFrameParams::DataView, ::content::mojom::CreateFrameParamsPtr>::Read(
    ::content::mojom::CreateFrameParams::DataView input,
    ::content::mojom::CreateFrameParamsPtr* output) {
  bool success = true;
  ::content::mojom::CreateFrameParamsPtr result(::content::mojom::CreateFrameParams::New());
  
      if (success)
        result->routing_id = input.routing_id();
      if (success)
        result->previous_routing_id = input.previous_routing_id();
      if (success && !input.ReadFrameToken(&result->frame_token))
        success = false;
      if (success && !input.ReadOpenerFrameToken(&result->opener_frame_token))
        success = false;
      if (success)
        result->parent_routing_id = input.parent_routing_id();
      if (success)
        result->previous_sibling_routing_id = input.previous_sibling_routing_id();
      if (success && !input.ReadInterfaceBundle(&result->interface_bundle))
        success = false;
      if (success && !input.ReadReplicationState(&result->replication_state))
        success = false;
      if (success && !input.ReadDevtoolsFrameToken(&result->devtools_frame_token))
        success = false;
      if (success && !input.ReadFrameOwnerProperties(&result->frame_owner_properties))
        success = false;
      if (success && !input.ReadWidgetParams(&result->widget_params))
        success = false;
      if (success)
        result->has_committed_real_load = input.has_committed_real_load();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif