// content/common/media/media_log_records.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_MEDIA_MEDIA_LOG_RECORDS_MOJOM_H_
#define CONTENT_COMMON_MEDIA_MEDIA_LOG_RECORDS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "content/common/media/media_log_records.mojom-shared.h"
#include "content/common/media/media_log_records.mojom-forward.h"
#include "media/mojo/mojom/media_types.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "content/common/content_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace content {
namespace mojom {

class MediaInternalLogRecordsProxy;

template <typename ImplRefTraits>
class MediaInternalLogRecordsStub;

class MediaInternalLogRecordsRequestValidator;


class CONTENT_EXPORT MediaInternalLogRecords
    : public MediaInternalLogRecordsInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = MediaInternalLogRecordsInterfaceBase;
  using Proxy_ = MediaInternalLogRecordsProxy;

  template <typename ImplRefTraits>
  using Stub_ = MediaInternalLogRecordsStub<ImplRefTraits>;

  using RequestValidator_ = MediaInternalLogRecordsRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kLogMinVersion = 0,
  };
  virtual ~MediaInternalLogRecords() {}

  
  virtual void Log(const std::vector<::media::MediaLogRecord>& events) = 0;
};



class CONTENT_EXPORT MediaInternalLogRecordsProxy
    : public MediaInternalLogRecords {
 public:
  using InterfaceType = MediaInternalLogRecords;

  explicit MediaInternalLogRecordsProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Log(const std::vector<::media::MediaLogRecord>& events) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class CONTENT_EXPORT MediaInternalLogRecordsStubDispatch {
 public:
  static bool Accept(MediaInternalLogRecords* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MediaInternalLogRecords* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MediaInternalLogRecords>>
class MediaInternalLogRecordsStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MediaInternalLogRecordsStub() {}
  ~MediaInternalLogRecordsStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaInternalLogRecordsStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaInternalLogRecordsStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT MediaInternalLogRecordsRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // namespace mojom
}  // namespace content

namespace mojo {

}  // namespace mojo

#endif  // CONTENT_COMMON_MEDIA_MEDIA_LOG_RECORDS_MOJOM_H_