// device/vr/public/mojom/vr_service.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef DEVICE_VR_PUBLIC_MOJOM_VR_SERVICE_MOJOM_BLINK_H_
#define DEVICE_VR_PUBLIC_MOJOM_VR_SERVICE_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "device/vr/public/mojom/vr_service.mojom-shared.h"
#include "device/vr/public/mojom/vr_service.mojom-blink-forward.h"
#include "device/gamepad/public/mojom/gamepad.mojom-blink.h"
#include "mojo/public/mojom/base/big_buffer.mojom-blink.h"
#include "mojo/public/mojom/base/time.mojom-blink.h"
#include "gpu/ipc/common/mailbox_holder.mojom-blink.h"
#include "gpu/ipc/common/sync_token.mojom-blink.h"
#include "ui/display/mojom/display.mojom-blink.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"
#include "ui/gfx/mojom/gpu_fence_handle.mojom-blink.h"
#include "ui/gfx/mojom/transform.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "device/vr/public/mojom/vr_service_mojom_traits.h"
#include "base/component_export.h"




namespace WTF {
struct device_mojom_internal_XRDeviceId_DataHashFn {
  static unsigned GetHash(const ::device::mojom::XRDeviceId& value) {
    using utype = std::underlying_type<::device::mojom::XRDeviceId>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::device::mojom::XRDeviceId& left, const ::device::mojom::XRDeviceId& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::device::mojom::XRDeviceId>
    : public GenericHashTraits<::device::mojom::XRDeviceId> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::device::mojom::XRDeviceId& value) {
    return value == static_cast<::device::mojom::XRDeviceId>(-1000000);
  }
  static void ConstructDeletedValue(::device::mojom::XRDeviceId& slot, bool) {
    slot = static_cast<::device::mojom::XRDeviceId>(-1000001);
  }
  static bool IsDeletedValue(const ::device::mojom::XRDeviceId& value) {
    return value == static_cast<::device::mojom::XRDeviceId>(-1000001);
  }
};
}  // namespace WTF


namespace WTF {
struct device_mojom_internal_XRHandedness_DataHashFn {
  static unsigned GetHash(const ::device::mojom::XRHandedness& value) {
    using utype = std::underlying_type<::device::mojom::XRHandedness>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::device::mojom::XRHandedness& left, const ::device::mojom::XRHandedness& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::device::mojom::XRHandedness>
    : public GenericHashTraits<::device::mojom::XRHandedness> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::device::mojom::XRHandedness& value) {
    return value == static_cast<::device::mojom::XRHandedness>(-1000000);
  }
  static void ConstructDeletedValue(::device::mojom::XRHandedness& slot, bool) {
    slot = static_cast<::device::mojom::XRHandedness>(-1000001);
  }
  static bool IsDeletedValue(const ::device::mojom::XRHandedness& value) {
    return value == static_cast<::device::mojom::XRHandedness>(-1000001);
  }
};
}  // namespace WTF


namespace WTF {
struct device_mojom_internal_XRTargetRayMode_DataHashFn {
  static unsigned GetHash(const ::device::mojom::XRTargetRayMode& value) {
    using utype = std::underlying_type<::device::mojom::XRTargetRayMode>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::device::mojom::XRTargetRayMode& left, const ::device::mojom::XRTargetRayMode& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::device::mojom::XRTargetRayMode>
    : public GenericHashTraits<::device::mojom::XRTargetRayMode> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::device::mojom::XRTargetRayMode& value) {
    return value == static_cast<::device::mojom::XRTargetRayMode>(-1000000);
  }
  static void ConstructDeletedValue(::device::mojom::XRTargetRayMode& slot, bool) {
    slot = static_cast<::device::mojom::XRTargetRayMode>(-1000001);
  }
  static bool IsDeletedValue(const ::device::mojom::XRTargetRayMode& value) {
    return value == static_cast<::device::mojom::XRTargetRayMode>(-1000001);
  }
};
}  // namespace WTF


namespace WTF {
struct device_mojom_internal_XRSessionFeature_DataHashFn {
  static unsigned GetHash(const ::device::mojom::XRSessionFeature& value) {
    using utype = std::underlying_type<::device::mojom::XRSessionFeature>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::device::mojom::XRSessionFeature& left, const ::device::mojom::XRSessionFeature& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::device::mojom::XRSessionFeature>
    : public GenericHashTraits<::device::mojom::XRSessionFeature> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::device::mojom::XRSessionFeature& value) {
    return value == static_cast<::device::mojom::XRSessionFeature>(-1000000);
  }
  static void ConstructDeletedValue(::device::mojom::XRSessionFeature& slot, bool) {
    slot = static_cast<::device::mojom::XRSessionFeature>(-1000001);
  }
  static bool IsDeletedValue(const ::device::mojom::XRSessionFeature& value) {
    return value == static_cast<::device::mojom::XRSessionFeature>(-1000001);
  }
};
}  // namespace WTF


namespace WTF {
struct device_mojom_internal_XRSessionFeatureRequestStatus_DataHashFn {
  static unsigned GetHash(const ::device::mojom::XRSessionFeatureRequestStatus& value) {
    using utype = std::underlying_type<::device::mojom::XRSessionFeatureRequestStatus>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::device::mojom::XRSessionFeatureRequestStatus& left, const ::device::mojom::XRSessionFeatureRequestStatus& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::device::mojom::XRSessionFeatureRequestStatus>
    : public GenericHashTraits<::device::mojom::XRSessionFeatureRequestStatus> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::device::mojom::XRSessionFeatureRequestStatus& value) {
    return value == static_cast<::device::mojom::XRSessionFeatureRequestStatus>(-1000000);
  }
  static void ConstructDeletedValue(::device::mojom::XRSessionFeatureRequestStatus& slot, bool) {
    slot = static_cast<::device::mojom::XRSessionFeatureRequestStatus>(-1000001);
  }
  static bool IsDeletedValue(const ::device::mojom::XRSessionFeatureRequestStatus& value) {
    return value == static_cast<::device::mojom::XRSessionFeatureRequestStatus>(-1000001);
  }
};
}  // namespace WTF


namespace WTF {
struct device_mojom_internal_XRSessionMode_DataHashFn {
  static unsigned GetHash(const ::device::mojom::XRSessionMode& value) {
    using utype = std::underlying_type<::device::mojom::XRSessionMode>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::device::mojom::XRSessionMode& left, const ::device::mojom::XRSessionMode& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::device::mojom::XRSessionMode>
    : public GenericHashTraits<::device::mojom::XRSessionMode> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::device::mojom::XRSessionMode& value) {
    return value == static_cast<::device::mojom::XRSessionMode>(-1000000);
  }
  static void ConstructDeletedValue(::device::mojom::XRSessionMode& slot, bool) {
    slot = static_cast<::device::mojom::XRSessionMode>(-1000001);
  }
  static bool IsDeletedValue(const ::device::mojom::XRSessionMode& value) {
    return value == static_cast<::device::mojom::XRSessionMode>(-1000001);
  }
};
}  // namespace WTF


namespace WTF {
struct device_mojom_internal_XRPresentationTransportMethod_DataHashFn {
  static unsigned GetHash(const ::device::mojom::XRPresentationTransportMethod& value) {
    using utype = std::underlying_type<::device::mojom::XRPresentationTransportMethod>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::device::mojom::XRPresentationTransportMethod& left, const ::device::mojom::XRPresentationTransportMethod& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::device::mojom::XRPresentationTransportMethod>
    : public GenericHashTraits<::device::mojom::XRPresentationTransportMethod> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::device::mojom::XRPresentationTransportMethod& value) {
    return value == static_cast<::device::mojom::XRPresentationTransportMethod>(-1000000);
  }
  static void ConstructDeletedValue(::device::mojom::XRPresentationTransportMethod& slot, bool) {
    slot = static_cast<::device::mojom::XRPresentationTransportMethod>(-1000001);
  }
  static bool IsDeletedValue(const ::device::mojom::XRPresentationTransportMethod& value) {
    return value == static_cast<::device::mojom::XRPresentationTransportMethod>(-1000001);
  }
};
}  // namespace WTF


namespace WTF {
struct device_mojom_internal_XRReferenceSpaceType_DataHashFn {
  static unsigned GetHash(const ::device::mojom::XRReferenceSpaceType& value) {
    using utype = std::underlying_type<::device::mojom::XRReferenceSpaceType>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::device::mojom::XRReferenceSpaceType& left, const ::device::mojom::XRReferenceSpaceType& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::device::mojom::XRReferenceSpaceType>
    : public GenericHashTraits<::device::mojom::XRReferenceSpaceType> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::device::mojom::XRReferenceSpaceType& value) {
    return value == static_cast<::device::mojom::XRReferenceSpaceType>(-1000000);
  }
  static void ConstructDeletedValue(::device::mojom::XRReferenceSpaceType& slot, bool) {
    slot = static_cast<::device::mojom::XRReferenceSpaceType>(-1000001);
  }
  static bool IsDeletedValue(const ::device::mojom::XRReferenceSpaceType& value) {
    return value == static_cast<::device::mojom::XRReferenceSpaceType>(-1000001);
  }
};
}  // namespace WTF


namespace WTF {
struct device_mojom_internal_XRPlaneOrientation_DataHashFn {
  static unsigned GetHash(const ::device::mojom::XRPlaneOrientation& value) {
    using utype = std::underlying_type<::device::mojom::XRPlaneOrientation>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::device::mojom::XRPlaneOrientation& left, const ::device::mojom::XRPlaneOrientation& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::device::mojom::XRPlaneOrientation>
    : public GenericHashTraits<::device::mojom::XRPlaneOrientation> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::device::mojom::XRPlaneOrientation& value) {
    return value == static_cast<::device::mojom::XRPlaneOrientation>(-1000000);
  }
  static void ConstructDeletedValue(::device::mojom::XRPlaneOrientation& slot, bool) {
    slot = static_cast<::device::mojom::XRPlaneOrientation>(-1000001);
  }
  static bool IsDeletedValue(const ::device::mojom::XRPlaneOrientation& value) {
    return value == static_cast<::device::mojom::XRPlaneOrientation>(-1000001);
  }
};
}  // namespace WTF


namespace WTF {
struct device_mojom_internal_RequestSessionError_DataHashFn {
  static unsigned GetHash(const ::device::mojom::RequestSessionError& value) {
    using utype = std::underlying_type<::device::mojom::RequestSessionError>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::device::mojom::RequestSessionError& left, const ::device::mojom::RequestSessionError& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::device::mojom::RequestSessionError>
    : public GenericHashTraits<::device::mojom::RequestSessionError> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::device::mojom::RequestSessionError& value) {
    return value == static_cast<::device::mojom::RequestSessionError>(-1000000);
  }
  static void ConstructDeletedValue(::device::mojom::RequestSessionError& slot, bool) {
    slot = static_cast<::device::mojom::RequestSessionError>(-1000001);
  }
  static bool IsDeletedValue(const ::device::mojom::RequestSessionError& value) {
    return value == static_cast<::device::mojom::RequestSessionError>(-1000001);
  }
};
}  // namespace WTF


namespace WTF {
struct device_mojom_internal_XrCompatibleResult_DataHashFn {
  static unsigned GetHash(const ::device::mojom::XrCompatibleResult& value) {
    using utype = std::underlying_type<::device::mojom::XrCompatibleResult>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::device::mojom::XrCompatibleResult& left, const ::device::mojom::XrCompatibleResult& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::device::mojom::XrCompatibleResult>
    : public GenericHashTraits<::device::mojom::XrCompatibleResult> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::device::mojom::XrCompatibleResult& value) {
    return value == static_cast<::device::mojom::XrCompatibleResult>(-1000000);
  }
  static void ConstructDeletedValue(::device::mojom::XrCompatibleResult& slot, bool) {
    slot = static_cast<::device::mojom::XrCompatibleResult>(-1000001);
  }
  static bool IsDeletedValue(const ::device::mojom::XrCompatibleResult& value) {
    return value == static_cast<::device::mojom::XrCompatibleResult>(-1000001);
  }
};
}  // namespace WTF


namespace WTF {
struct device_mojom_internal_CreateAnchorResult_DataHashFn {
  static unsigned GetHash(const ::device::mojom::CreateAnchorResult& value) {
    using utype = std::underlying_type<::device::mojom::CreateAnchorResult>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::device::mojom::CreateAnchorResult& left, const ::device::mojom::CreateAnchorResult& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::device::mojom::CreateAnchorResult>
    : public GenericHashTraits<::device::mojom::CreateAnchorResult> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::device::mojom::CreateAnchorResult& value) {
    return value == static_cast<::device::mojom::CreateAnchorResult>(-1000000);
  }
  static void ConstructDeletedValue(::device::mojom::CreateAnchorResult& slot, bool) {
    slot = static_cast<::device::mojom::CreateAnchorResult>(-1000001);
  }
  static bool IsDeletedValue(const ::device::mojom::CreateAnchorResult& value) {
    return value == static_cast<::device::mojom::CreateAnchorResult>(-1000001);
  }
};
}  // namespace WTF


namespace WTF {
struct device_mojom_internal_SubscribeToHitTestResult_DataHashFn {
  static unsigned GetHash(const ::device::mojom::SubscribeToHitTestResult& value) {
    using utype = std::underlying_type<::device::mojom::SubscribeToHitTestResult>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::device::mojom::SubscribeToHitTestResult& left, const ::device::mojom::SubscribeToHitTestResult& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::device::mojom::SubscribeToHitTestResult>
    : public GenericHashTraits<::device::mojom::SubscribeToHitTestResult> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::device::mojom::SubscribeToHitTestResult& value) {
    return value == static_cast<::device::mojom::SubscribeToHitTestResult>(-1000000);
  }
  static void ConstructDeletedValue(::device::mojom::SubscribeToHitTestResult& slot, bool) {
    slot = static_cast<::device::mojom::SubscribeToHitTestResult>(-1000001);
  }
  static bool IsDeletedValue(const ::device::mojom::SubscribeToHitTestResult& value) {
    return value == static_cast<::device::mojom::SubscribeToHitTestResult>(-1000001);
  }
};
}  // namespace WTF


namespace WTF {
struct device_mojom_internal_EntityTypeForHitTest_DataHashFn {
  static unsigned GetHash(const ::device::mojom::EntityTypeForHitTest& value) {
    using utype = std::underlying_type<::device::mojom::EntityTypeForHitTest>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::device::mojom::EntityTypeForHitTest& left, const ::device::mojom::EntityTypeForHitTest& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::device::mojom::EntityTypeForHitTest>
    : public GenericHashTraits<::device::mojom::EntityTypeForHitTest> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::device::mojom::EntityTypeForHitTest& value) {
    return value == static_cast<::device::mojom::EntityTypeForHitTest>(-1000000);
  }
  static void ConstructDeletedValue(::device::mojom::EntityTypeForHitTest& slot, bool) {
    slot = static_cast<::device::mojom::EntityTypeForHitTest>(-1000001);
  }
  static bool IsDeletedValue(const ::device::mojom::EntityTypeForHitTest& value) {
    return value == static_cast<::device::mojom::EntityTypeForHitTest>(-1000001);
  }
};
}  // namespace WTF


namespace WTF {
struct device_mojom_internal_XRVisibilityState_DataHashFn {
  static unsigned GetHash(const ::device::mojom::XRVisibilityState& value) {
    using utype = std::underlying_type<::device::mojom::XRVisibilityState>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::device::mojom::XRVisibilityState& left, const ::device::mojom::XRVisibilityState& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::device::mojom::XRVisibilityState>
    : public GenericHashTraits<::device::mojom::XRVisibilityState> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::device::mojom::XRVisibilityState& value) {
    return value == static_cast<::device::mojom::XRVisibilityState>(-1000000);
  }
  static void ConstructDeletedValue(::device::mojom::XRVisibilityState& slot, bool) {
    slot = static_cast<::device::mojom::XRVisibilityState>(-1000001);
  }
  static bool IsDeletedValue(const ::device::mojom::XRVisibilityState& value) {
    return value == static_cast<::device::mojom::XRVisibilityState>(-1000001);
  }
};
}  // namespace WTF

// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace device {
namespace mojom {
namespace blink {

class VRServiceProxy;

template <typename ImplRefTraits>
class VRServiceStub;

class VRServiceRequestValidator;
class VRServiceResponseValidator;


class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) VRService
    : public VRServiceInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = true;

  using Base_ = VRServiceInterfaceBase;
  using Proxy_ = VRServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = VRServiceStub<ImplRefTraits>;

  using RequestValidator_ = VRServiceRequestValidator;
  using ResponseValidator_ = VRServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSetClientMinVersion = 0,
    kRequestSessionMinVersion = 0,
    kSupportsSessionMinVersion = 0,
    kExitPresentMinVersion = 0,
    kSetFramesThrottledMinVersion = 0,
    kMakeXrCompatibleMinVersion = 0,
  };
  virtual ~VRService() {}

  
  virtual void SetClient(::mojo::PendingRemote<VRServiceClient> client) = 0;


  using RequestSessionCallback = base::OnceCallback<void(RequestSessionResultPtr)>;
  
  virtual void RequestSession(XRSessionOptionsPtr options, RequestSessionCallback callback) = 0;


  using SupportsSessionCallback = base::OnceCallback<void(bool)>;
  
  virtual void SupportsSession(XRSessionOptionsPtr options, SupportsSessionCallback callback) = 0;


  using ExitPresentCallback = base::OnceCallback<void()>;
  
  virtual void ExitPresent(ExitPresentCallback callback) = 0;

  
  virtual void SetFramesThrottled(bool throttled) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool MakeXrCompatible(XrCompatibleResult* out_xr_compatible_result);

  using MakeXrCompatibleCallback = base::OnceCallback<void(XrCompatibleResult)>;
  
  virtual void MakeXrCompatible(MakeXrCompatibleCallback callback) = 0;
};

class XRSessionMetricsRecorderProxy;

template <typename ImplRefTraits>
class XRSessionMetricsRecorderStub;

class XRSessionMetricsRecorderRequestValidator;


class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) XRSessionMetricsRecorder
    : public XRSessionMetricsRecorderInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = XRSessionMetricsRecorderInterfaceBase;
  using Proxy_ = XRSessionMetricsRecorderProxy;

  template <typename ImplRefTraits>
  using Stub_ = XRSessionMetricsRecorderStub<ImplRefTraits>;

  using RequestValidator_ = XRSessionMetricsRecorderRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kReportFeatureUsedMinVersion = 0,
  };
  virtual ~XRSessionMetricsRecorder() {}

  
  virtual void ReportFeatureUsed(XRSessionFeature feature) = 0;
};

class VRServiceClientProxy;

template <typename ImplRefTraits>
class VRServiceClientStub;

class VRServiceClientRequestValidator;


class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) VRServiceClient
    : public VRServiceClientInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = VRServiceClientInterfaceBase;
  using Proxy_ = VRServiceClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = VRServiceClientStub<ImplRefTraits>;

  using RequestValidator_ = VRServiceClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnDeviceChangedMinVersion = 0,
  };
  virtual ~VRServiceClient() {}

  
  virtual void OnDeviceChanged() = 0;
};

class XREnvironmentIntegrationProviderProxy;

template <typename ImplRefTraits>
class XREnvironmentIntegrationProviderStub;

class XREnvironmentIntegrationProviderRequestValidator;
class XREnvironmentIntegrationProviderResponseValidator;


class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) XREnvironmentIntegrationProvider
    : public XREnvironmentIntegrationProviderInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = XREnvironmentIntegrationProviderInterfaceBase;
  using Proxy_ = XREnvironmentIntegrationProviderProxy;

  template <typename ImplRefTraits>
  using Stub_ = XREnvironmentIntegrationProviderStub<ImplRefTraits>;

  using RequestValidator_ = XREnvironmentIntegrationProviderRequestValidator;
  using ResponseValidator_ = XREnvironmentIntegrationProviderResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSubscribeToHitTestMinVersion = 0,
    kSubscribeToHitTestForTransientInputMinVersion = 0,
    kUnsubscribeFromHitTestMinVersion = 0,
    kCreateAnchorMinVersion = 0,
    kCreatePlaneAnchorMinVersion = 0,
    kDetachAnchorMinVersion = 0,
  };
  virtual ~XREnvironmentIntegrationProvider() {}


  using SubscribeToHitTestCallback = base::OnceCallback<void(SubscribeToHitTestResult, uint64_t)>;
  
  virtual void SubscribeToHitTest(XRNativeOriginInformationPtr native_origin_information, const WTF::Vector<EntityTypeForHitTest>& entity_types, XRRayPtr ray, SubscribeToHitTestCallback callback) = 0;


  using SubscribeToHitTestForTransientInputCallback = base::OnceCallback<void(SubscribeToHitTestResult, uint64_t)>;
  
  virtual void SubscribeToHitTestForTransientInput(const WTF::String& profile_name, const WTF::Vector<EntityTypeForHitTest>& entity_types, XRRayPtr ray, SubscribeToHitTestForTransientInputCallback callback) = 0;

  
  virtual void UnsubscribeFromHitTest(uint64_t subscription_id) = 0;


  using CreateAnchorCallback = base::OnceCallback<void(CreateAnchorResult, uint64_t)>;
  
  virtual void CreateAnchor(XRNativeOriginInformationPtr native_origin_information, const ::device::Pose& native_origin_from_anchor, CreateAnchorCallback callback) = 0;


  using CreatePlaneAnchorCallback = base::OnceCallback<void(CreateAnchorResult, uint64_t)>;
  
  virtual void CreatePlaneAnchor(XRNativeOriginInformationPtr native_origin_information, const ::device::Pose& native_origin_from_anchor, uint64_t plane_id, CreatePlaneAnchorCallback callback) = 0;

  
  virtual void DetachAnchor(uint64_t anchor_id) = 0;
};

class XRInputSourceButtonListenerProxy;

template <typename ImplRefTraits>
class XRInputSourceButtonListenerStub;

class XRInputSourceButtonListenerRequestValidator;


class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) XRInputSourceButtonListener
    : public XRInputSourceButtonListenerInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = XRInputSourceButtonListenerInterfaceBase;
  using Proxy_ = XRInputSourceButtonListenerProxy;

  template <typename ImplRefTraits>
  using Stub_ = XRInputSourceButtonListenerStub<ImplRefTraits>;

  using RequestValidator_ = XRInputSourceButtonListenerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnButtonEventMinVersion = 0,
  };
  virtual ~XRInputSourceButtonListener() {}

  
  virtual void OnButtonEvent(XRInputSourceStatePtr input_source) = 0;
};

class XRFrameDataProviderProxy;

template <typename ImplRefTraits>
class XRFrameDataProviderStub;

class XRFrameDataProviderRequestValidator;
class XRFrameDataProviderResponseValidator;


class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) XRFrameDataProvider
    : public XRFrameDataProviderInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = XRFrameDataProviderInterfaceBase;
  using Proxy_ = XRFrameDataProviderProxy;

  template <typename ImplRefTraits>
  using Stub_ = XRFrameDataProviderStub<ImplRefTraits>;

  using RequestValidator_ = XRFrameDataProviderRequestValidator;
  using ResponseValidator_ = XRFrameDataProviderResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetFrameDataMinVersion = 0,
    kGetEnvironmentIntegrationProviderMinVersion = 0,
    kSetInputSourceButtonListenerMinVersion = 0,
  };
  virtual ~XRFrameDataProvider() {}


  using GetFrameDataCallback = base::OnceCallback<void(XRFrameDataPtr)>;
  
  virtual void GetFrameData(XRFrameDataRequestOptionsPtr options, GetFrameDataCallback callback) = 0;

  
  virtual void GetEnvironmentIntegrationProvider(::mojo::PendingAssociatedReceiver<XREnvironmentIntegrationProvider> environment_provider) = 0;

  
  virtual void SetInputSourceButtonListener(::mojo::PendingAssociatedRemote<XRInputSourceButtonListener> event_listener) = 0;
};

class XRPresentationProviderProxy;

template <typename ImplRefTraits>
class XRPresentationProviderStub;

class XRPresentationProviderRequestValidator;


class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) XRPresentationProvider
    : public XRPresentationProviderInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = XRPresentationProviderInterfaceBase;
  using Proxy_ = XRPresentationProviderProxy;

  template <typename ImplRefTraits>
  using Stub_ = XRPresentationProviderStub<ImplRefTraits>;

  using RequestValidator_ = XRPresentationProviderRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kUpdateLayerBoundsMinVersion = 0,
    kSubmitFrameMissingMinVersion = 0,
    kSubmitFrameMinVersion = 0,
    kSubmitFrameWithTextureHandleMinVersion = 0,
    kSubmitFrameDrawnIntoTextureMinVersion = 0,
  };
  virtual ~XRPresentationProvider() {}

  
  virtual void UpdateLayerBounds(int16_t frame_id, const ::gfx::RectF& left_bounds, const ::gfx::RectF& right_bounds, const ::gfx::Size& source_size) = 0;

  
  virtual void SubmitFrameMissing(int16_t frame_id, const ::gpu::SyncToken& sync_token) = 0;

  
  virtual void SubmitFrame(int16_t frame_id, const ::gpu::MailboxHolder& mailbox_holder, ::base::TimeDelta time_waited) = 0;

  
  virtual void SubmitFrameWithTextureHandle(int16_t frameId, ::mojo::PlatformHandle texture) = 0;

  
  virtual void SubmitFrameDrawnIntoTexture(int16_t frameId, const ::gpu::SyncToken& sync_token, ::base::TimeDelta time_waited) = 0;
};

class XRPresentationClientProxy;

template <typename ImplRefTraits>
class XRPresentationClientStub;

class XRPresentationClientRequestValidator;


class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) XRPresentationClient
    : public XRPresentationClientInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = XRPresentationClientInterfaceBase;
  using Proxy_ = XRPresentationClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = XRPresentationClientStub<ImplRefTraits>;

  using RequestValidator_ = XRPresentationClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnSubmitFrameTransferredMinVersion = 0,
    kOnSubmitFrameRenderedMinVersion = 0,
    kOnSubmitFrameGpuFenceMinVersion = 0,
  };
  virtual ~XRPresentationClient() {}

  
  virtual void OnSubmitFrameTransferred(bool success) = 0;

  
  virtual void OnSubmitFrameRendered() = 0;

  
  virtual void OnSubmitFrameGpuFence(::gfx::GpuFenceHandle gpu_fence_handle) = 0;
};

class XRSessionClientProxy;

template <typename ImplRefTraits>
class XRSessionClientStub;

class XRSessionClientRequestValidator;


class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) XRSessionClient
    : public XRSessionClientInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = XRSessionClientInterfaceBase;
  using Proxy_ = XRSessionClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = XRSessionClientStub<ImplRefTraits>;

  using RequestValidator_ = XRSessionClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnChangedMinVersion = 0,
    kOnExitPresentMinVersion = 0,
    kOnVisibilityStateChangedMinVersion = 0,
  };
  virtual ~XRSessionClient() {}

  
  virtual void OnChanged(VRDisplayInfoPtr display) = 0;

  
  virtual void OnExitPresent() = 0;

  
  virtual void OnVisibilityStateChanged(XRVisibilityState visibility_state) = 0;
};



class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) VRServiceProxy
    : public VRService {
 public:
  using InterfaceType = VRService;

  explicit VRServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetClient(::mojo::PendingRemote<VRServiceClient> client) final;
  
  void RequestSession(XRSessionOptionsPtr options, RequestSessionCallback callback) final;
  
  void SupportsSession(XRSessionOptionsPtr options, SupportsSessionCallback callback) final;
  
  void ExitPresent(ExitPresentCallback callback) final;
  
  void SetFramesThrottled(bool throttled) final;
  
  bool MakeXrCompatible(XrCompatibleResult* out_xr_compatible_result) final;
  
  void MakeXrCompatible(MakeXrCompatibleCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) XRSessionMetricsRecorderProxy
    : public XRSessionMetricsRecorder {
 public:
  using InterfaceType = XRSessionMetricsRecorder;

  explicit XRSessionMetricsRecorderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ReportFeatureUsed(XRSessionFeature feature) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) VRServiceClientProxy
    : public VRServiceClient {
 public:
  using InterfaceType = VRServiceClient;

  explicit VRServiceClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnDeviceChanged() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) XREnvironmentIntegrationProviderProxy
    : public XREnvironmentIntegrationProvider {
 public:
  using InterfaceType = XREnvironmentIntegrationProvider;

  explicit XREnvironmentIntegrationProviderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SubscribeToHitTest(XRNativeOriginInformationPtr native_origin_information, const WTF::Vector<EntityTypeForHitTest>& entity_types, XRRayPtr ray, SubscribeToHitTestCallback callback) final;
  
  void SubscribeToHitTestForTransientInput(const WTF::String& profile_name, const WTF::Vector<EntityTypeForHitTest>& entity_types, XRRayPtr ray, SubscribeToHitTestForTransientInputCallback callback) final;
  
  void UnsubscribeFromHitTest(uint64_t subscription_id) final;
  
  void CreateAnchor(XRNativeOriginInformationPtr native_origin_information, const ::device::Pose& native_origin_from_anchor, CreateAnchorCallback callback) final;
  
  void CreatePlaneAnchor(XRNativeOriginInformationPtr native_origin_information, const ::device::Pose& native_origin_from_anchor, uint64_t plane_id, CreatePlaneAnchorCallback callback) final;
  
  void DetachAnchor(uint64_t anchor_id) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) XRInputSourceButtonListenerProxy
    : public XRInputSourceButtonListener {
 public:
  using InterfaceType = XRInputSourceButtonListener;

  explicit XRInputSourceButtonListenerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnButtonEvent(XRInputSourceStatePtr input_source) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) XRFrameDataProviderProxy
    : public XRFrameDataProvider {
 public:
  using InterfaceType = XRFrameDataProvider;

  explicit XRFrameDataProviderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetFrameData(XRFrameDataRequestOptionsPtr options, GetFrameDataCallback callback) final;
  
  void GetEnvironmentIntegrationProvider(::mojo::PendingAssociatedReceiver<XREnvironmentIntegrationProvider> environment_provider) final;
  
  void SetInputSourceButtonListener(::mojo::PendingAssociatedRemote<XRInputSourceButtonListener> event_listener) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) XRPresentationProviderProxy
    : public XRPresentationProvider {
 public:
  using InterfaceType = XRPresentationProvider;

  explicit XRPresentationProviderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void UpdateLayerBounds(int16_t frame_id, const ::gfx::RectF& left_bounds, const ::gfx::RectF& right_bounds, const ::gfx::Size& source_size) final;
  
  void SubmitFrameMissing(int16_t frame_id, const ::gpu::SyncToken& sync_token) final;
  
  void SubmitFrame(int16_t frame_id, const ::gpu::MailboxHolder& mailbox_holder, ::base::TimeDelta time_waited) final;
  
  void SubmitFrameWithTextureHandle(int16_t frameId, ::mojo::PlatformHandle texture) final;
  
  void SubmitFrameDrawnIntoTexture(int16_t frameId, const ::gpu::SyncToken& sync_token, ::base::TimeDelta time_waited) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) XRPresentationClientProxy
    : public XRPresentationClient {
 public:
  using InterfaceType = XRPresentationClient;

  explicit XRPresentationClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnSubmitFrameTransferred(bool success) final;
  
  void OnSubmitFrameRendered() final;
  
  void OnSubmitFrameGpuFence(::gfx::GpuFenceHandle gpu_fence_handle) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) XRSessionClientProxy
    : public XRSessionClient {
 public:
  using InterfaceType = XRSessionClient;

  explicit XRSessionClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnChanged(VRDisplayInfoPtr display) final;
  
  void OnExitPresent() final;
  
  void OnVisibilityStateChanged(XRVisibilityState visibility_state) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) VRServiceStubDispatch {
 public:
  static bool Accept(VRService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      VRService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<VRService>>
class VRServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  VRServiceStub() {}
  ~VRServiceStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VRServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VRServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) XRSessionMetricsRecorderStubDispatch {
 public:
  static bool Accept(XRSessionMetricsRecorder* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      XRSessionMetricsRecorder* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<XRSessionMetricsRecorder>>
class XRSessionMetricsRecorderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  XRSessionMetricsRecorderStub() {}
  ~XRSessionMetricsRecorderStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XRSessionMetricsRecorderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XRSessionMetricsRecorderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) VRServiceClientStubDispatch {
 public:
  static bool Accept(VRServiceClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      VRServiceClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<VRServiceClient>>
class VRServiceClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  VRServiceClientStub() {}
  ~VRServiceClientStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VRServiceClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VRServiceClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) XREnvironmentIntegrationProviderStubDispatch {
 public:
  static bool Accept(XREnvironmentIntegrationProvider* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      XREnvironmentIntegrationProvider* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<XREnvironmentIntegrationProvider>>
class XREnvironmentIntegrationProviderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  XREnvironmentIntegrationProviderStub() {}
  ~XREnvironmentIntegrationProviderStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XREnvironmentIntegrationProviderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XREnvironmentIntegrationProviderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) XRInputSourceButtonListenerStubDispatch {
 public:
  static bool Accept(XRInputSourceButtonListener* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      XRInputSourceButtonListener* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<XRInputSourceButtonListener>>
class XRInputSourceButtonListenerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  XRInputSourceButtonListenerStub() {}
  ~XRInputSourceButtonListenerStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XRInputSourceButtonListenerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XRInputSourceButtonListenerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) XRFrameDataProviderStubDispatch {
 public:
  static bool Accept(XRFrameDataProvider* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      XRFrameDataProvider* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<XRFrameDataProvider>>
class XRFrameDataProviderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  XRFrameDataProviderStub() {}
  ~XRFrameDataProviderStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XRFrameDataProviderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XRFrameDataProviderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) XRPresentationProviderStubDispatch {
 public:
  static bool Accept(XRPresentationProvider* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      XRPresentationProvider* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<XRPresentationProvider>>
class XRPresentationProviderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  XRPresentationProviderStub() {}
  ~XRPresentationProviderStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XRPresentationProviderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XRPresentationProviderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) XRPresentationClientStubDispatch {
 public:
  static bool Accept(XRPresentationClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      XRPresentationClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<XRPresentationClient>>
class XRPresentationClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  XRPresentationClientStub() {}
  ~XRPresentationClientStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XRPresentationClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XRPresentationClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) XRSessionClientStubDispatch {
 public:
  static bool Accept(XRSessionClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      XRSessionClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<XRSessionClient>>
class XRSessionClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  XRSessionClientStub() {}
  ~XRSessionClientStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XRSessionClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XRSessionClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) VRServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) XRSessionMetricsRecorderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) VRServiceClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) XREnvironmentIntegrationProviderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) XRInputSourceButtonListenerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) XRFrameDataProviderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) XRPresentationProviderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) XRPresentationClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) XRSessionClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) VRServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) XREnvironmentIntegrationProviderResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) XRFrameDataProviderResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};










class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) VRFieldOfView {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VRFieldOfView, T>::value>;
  using DataView = VRFieldOfViewDataView;
  using Data_ = internal::VRFieldOfView_Data;

  template <typename... Args>
  static VRFieldOfViewPtr New(Args&&... args) {
    return VRFieldOfViewPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VRFieldOfViewPtr From(const U& u) {
    return mojo::TypeConverter<VRFieldOfViewPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VRFieldOfView>::Convert(*this);
  }


  VRFieldOfView();

  VRFieldOfView(
      float up_degrees,
      float down_degrees,
      float left_degrees,
      float right_degrees);

  ~VRFieldOfView();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VRFieldOfViewPtr>
  VRFieldOfViewPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VRFieldOfView::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VRFieldOfView::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VRFieldOfView::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VRFieldOfView_UnserializedMessageContext<
            UserType, VRFieldOfView::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<VRFieldOfView::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return VRFieldOfView::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VRFieldOfView_UnserializedMessageContext<
            UserType, VRFieldOfView::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VRFieldOfView::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  float up_degrees;
  
  float down_degrees;
  
  float left_degrees;
  
  float right_degrees;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VRFieldOfView::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VRFieldOfView::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VRFieldOfView::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VRFieldOfView::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}












class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) XRPresentationTransportOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRPresentationTransportOptions, T>::value>;
  using DataView = XRPresentationTransportOptionsDataView;
  using Data_ = internal::XRPresentationTransportOptions_Data;

  template <typename... Args>
  static XRPresentationTransportOptionsPtr New(Args&&... args) {
    return XRPresentationTransportOptionsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRPresentationTransportOptionsPtr From(const U& u) {
    return mojo::TypeConverter<XRPresentationTransportOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRPresentationTransportOptions>::Convert(*this);
  }


  XRPresentationTransportOptions();

  XRPresentationTransportOptions(
      XRPresentationTransportMethod transport_method,
      bool wait_for_transfer_notification,
      bool wait_for_render_notification,
      bool wait_for_gpu_fence);

  ~XRPresentationTransportOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRPresentationTransportOptionsPtr>
  XRPresentationTransportOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRPresentationTransportOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRPresentationTransportOptions::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRPresentationTransportOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRPresentationTransportOptions_UnserializedMessageContext<
            UserType, XRPresentationTransportOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<XRPresentationTransportOptions::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return XRPresentationTransportOptions::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRPresentationTransportOptions_UnserializedMessageContext<
            UserType, XRPresentationTransportOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRPresentationTransportOptions::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  XRPresentationTransportMethod transport_method;
  
  bool wait_for_transfer_notification;
  
  bool wait_for_render_notification;
  
  bool wait_for_gpu_fence;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRPresentationTransportOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRPresentationTransportOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRPresentationTransportOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRPresentationTransportOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) XRPlanePointData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRPlanePointData, T>::value>;
  using DataView = XRPlanePointDataDataView;
  using Data_ = internal::XRPlanePointData_Data;

  template <typename... Args>
  static XRPlanePointDataPtr New(Args&&... args) {
    return XRPlanePointDataPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRPlanePointDataPtr From(const U& u) {
    return mojo::TypeConverter<XRPlanePointDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRPlanePointData>::Convert(*this);
  }


  XRPlanePointData();

  XRPlanePointData(
      float x,
      float z);

  ~XRPlanePointData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRPlanePointDataPtr>
  XRPlanePointDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRPlanePointData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRPlanePointData::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRPlanePointData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRPlanePointData_UnserializedMessageContext<
            UserType, XRPlanePointData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<XRPlanePointData::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return XRPlanePointData::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRPlanePointData_UnserializedMessageContext<
            UserType, XRPlanePointData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRPlanePointData::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  float x;
  
  float z;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRPlanePointData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRPlanePointData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRPlanePointData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRPlanePointData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}












class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) RgbTupleF32 {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RgbTupleF32, T>::value>;
  using DataView = RgbTupleF32DataView;
  using Data_ = internal::RgbTupleF32_Data;

  template <typename... Args>
  static RgbTupleF32Ptr New(Args&&... args) {
    return RgbTupleF32Ptr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RgbTupleF32Ptr From(const U& u) {
    return mojo::TypeConverter<RgbTupleF32Ptr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RgbTupleF32>::Convert(*this);
  }


  RgbTupleF32();

  RgbTupleF32(
      float red,
      float green,
      float blue);

  ~RgbTupleF32();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RgbTupleF32Ptr>
  RgbTupleF32Ptr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RgbTupleF32::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RgbTupleF32::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RgbTupleF32::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RgbTupleF32_UnserializedMessageContext<
            UserType, RgbTupleF32::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<RgbTupleF32::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return RgbTupleF32::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RgbTupleF32_UnserializedMessageContext<
            UserType, RgbTupleF32::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RgbTupleF32::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  float red;
  
  float green;
  
  float blue;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RgbTupleF32::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RgbTupleF32::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RgbTupleF32::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RgbTupleF32::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) RgbaTupleF16 {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RgbaTupleF16, T>::value>;
  using DataView = RgbaTupleF16DataView;
  using Data_ = internal::RgbaTupleF16_Data;

  template <typename... Args>
  static RgbaTupleF16Ptr New(Args&&... args) {
    return RgbaTupleF16Ptr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RgbaTupleF16Ptr From(const U& u) {
    return mojo::TypeConverter<RgbaTupleF16Ptr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RgbaTupleF16>::Convert(*this);
  }


  RgbaTupleF16();

  RgbaTupleF16(
      uint16_t red,
      uint16_t green,
      uint16_t blue,
      uint16_t alpha);

  ~RgbaTupleF16();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RgbaTupleF16Ptr>
  RgbaTupleF16Ptr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RgbaTupleF16::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RgbaTupleF16::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RgbaTupleF16::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RgbaTupleF16_UnserializedMessageContext<
            UserType, RgbaTupleF16::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<RgbaTupleF16::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return RgbaTupleF16::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RgbaTupleF16_UnserializedMessageContext<
            UserType, RgbaTupleF16::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RgbaTupleF16::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  uint16_t red;
  
  uint16_t green;
  
  uint16_t blue;
  
  uint16_t alpha;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RgbaTupleF16::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RgbaTupleF16::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RgbaTupleF16::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RgbaTupleF16::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}









class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) XRDepthDataStillValid {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRDepthDataStillValid, T>::value>;
  using DataView = XRDepthDataStillValidDataView;
  using Data_ = internal::XRDepthDataStillValid_Data;

  template <typename... Args>
  static XRDepthDataStillValidPtr New(Args&&... args) {
    return XRDepthDataStillValidPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRDepthDataStillValidPtr From(const U& u) {
    return mojo::TypeConverter<XRDepthDataStillValidPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRDepthDataStillValid>::Convert(*this);
  }


  XRDepthDataStillValid();

  ~XRDepthDataStillValid();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRDepthDataStillValidPtr>
  XRDepthDataStillValidPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRDepthDataStillValid::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRDepthDataStillValid::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRDepthDataStillValid::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRDepthDataStillValid_UnserializedMessageContext<
            UserType, XRDepthDataStillValid::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<XRDepthDataStillValid::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return XRDepthDataStillValid::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRDepthDataStillValid_UnserializedMessageContext<
            UserType, XRDepthDataStillValid::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRDepthDataStillValid::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }


  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRDepthDataStillValid::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRDepthDataStillValid::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRDepthDataStillValid::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRDepthDataStillValid::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}








class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) XRFrameDataRequestOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRFrameDataRequestOptions, T>::value>;
  using DataView = XRFrameDataRequestOptionsDataView;
  using Data_ = internal::XRFrameDataRequestOptions_Data;

  template <typename... Args>
  static XRFrameDataRequestOptionsPtr New(Args&&... args) {
    return XRFrameDataRequestOptionsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRFrameDataRequestOptionsPtr From(const U& u) {
    return mojo::TypeConverter<XRFrameDataRequestOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRFrameDataRequestOptions>::Convert(*this);
  }


  XRFrameDataRequestOptions();

  explicit XRFrameDataRequestOptions(
      bool include_lighting_estimation_data);

  ~XRFrameDataRequestOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRFrameDataRequestOptionsPtr>
  XRFrameDataRequestOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRFrameDataRequestOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRFrameDataRequestOptions::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRFrameDataRequestOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRFrameDataRequestOptions_UnserializedMessageContext<
            UserType, XRFrameDataRequestOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<XRFrameDataRequestOptions::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return XRFrameDataRequestOptions::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRFrameDataRequestOptions_UnserializedMessageContext<
            UserType, XRFrameDataRequestOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRFrameDataRequestOptions::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  bool include_lighting_estimation_data;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRFrameDataRequestOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRFrameDataRequestOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRFrameDataRequestOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRFrameDataRequestOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) XRNativeOriginInformation {
 public:
  using DataView = XRNativeOriginInformationDataView;
  using Data_ = internal::XRNativeOriginInformation_Data;
  using Tag = Data_::XRNativeOriginInformation_Tag;

  static XRNativeOriginInformationPtr New() {
    return XRNativeOriginInformationPtr(base::in_place);
  }
  // Construct an instance holding |input_source_id|.
  static XRNativeOriginInformationPtr
  NewInputSourceId(
      uint32_t input_source_id) {
    auto result = XRNativeOriginInformationPtr(base::in_place);
    result->set_input_source_id(std::move(input_source_id));
    return result;
  }
  // Construct an instance holding |plane_id|.
  static XRNativeOriginInformationPtr
  NewPlaneId(
      uint64_t plane_id) {
    auto result = XRNativeOriginInformationPtr(base::in_place);
    result->set_plane_id(std::move(plane_id));
    return result;
  }
  // Construct an instance holding |anchor_id|.
  static XRNativeOriginInformationPtr
  NewAnchorId(
      uint64_t anchor_id) {
    auto result = XRNativeOriginInformationPtr(base::in_place);
    result->set_anchor_id(std::move(anchor_id));
    return result;
  }
  // Construct an instance holding |reference_space_type|.
  static XRNativeOriginInformationPtr
  NewReferenceSpaceType(
      XRReferenceSpaceType reference_space_type) {
    auto result = XRNativeOriginInformationPtr(base::in_place);
    result->set_reference_space_type(std::move(reference_space_type));
    return result;
  }

  template <typename U>
  static XRNativeOriginInformationPtr From(const U& u) {
    return mojo::TypeConverter<XRNativeOriginInformationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRNativeOriginInformation>::Convert(*this);
  }

  XRNativeOriginInformation();
  ~XRNativeOriginInformation();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = XRNativeOriginInformationPtr>
  XRNativeOriginInformationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, XRNativeOriginInformation>::value>::type* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  Tag which() const {
    return tag_;
  }


  
  bool is_input_source_id() const { return tag_ == Tag::INPUT_SOURCE_ID; }

  
  uint32_t get_input_source_id() const {
    DCHECK(tag_ == Tag::INPUT_SOURCE_ID);
    return data_.input_source_id;
  }

  
  void set_input_source_id(
      uint32_t input_source_id);
  
  bool is_plane_id() const { return tag_ == Tag::PLANE_ID; }

  
  uint64_t get_plane_id() const {
    DCHECK(tag_ == Tag::PLANE_ID);
    return data_.plane_id;
  }

  
  void set_plane_id(
      uint64_t plane_id);
  
  bool is_anchor_id() const { return tag_ == Tag::ANCHOR_ID; }

  
  uint64_t get_anchor_id() const {
    DCHECK(tag_ == Tag::ANCHOR_ID);
    return data_.anchor_id;
  }

  
  void set_anchor_id(
      uint64_t anchor_id);
  
  bool is_reference_space_type() const { return tag_ == Tag::REFERENCE_SPACE_TYPE; }

  
  XRReferenceSpaceType get_reference_space_type() const {
    DCHECK(tag_ == Tag::REFERENCE_SPACE_TYPE);
    return data_.reference_space_type;
  }

  
  void set_reference_space_type(
      XRReferenceSpaceType reference_space_type);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRNativeOriginInformation::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<XRNativeOriginInformation::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

 private:
  union Union_ {
    Union_() {}
    ~Union_() {}
    uint32_t input_source_id;
    uint64_t plane_id;
    uint64_t anchor_id;
    XRReferenceSpaceType reference_space_type;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) XRDepthData {
 public:
  using DataView = XRDepthDataDataView;
  using Data_ = internal::XRDepthData_Data;
  using Tag = Data_::XRDepthData_Tag;

  static XRDepthDataPtr New() {
    return XRDepthDataPtr(base::in_place);
  }
  // Construct an instance holding |data_still_valid|.
  static XRDepthDataPtr
  NewDataStillValid(
      XRDepthDataStillValidPtr data_still_valid) {
    auto result = XRDepthDataPtr(base::in_place);
    result->set_data_still_valid(std::move(data_still_valid));
    return result;
  }
  // Construct an instance holding |updated_depth_data|.
  static XRDepthDataPtr
  NewUpdatedDepthData(
      XRDepthDataUpdatedPtr updated_depth_data) {
    auto result = XRDepthDataPtr(base::in_place);
    result->set_updated_depth_data(std::move(updated_depth_data));
    return result;
  }

  template <typename U>
  static XRDepthDataPtr From(const U& u) {
    return mojo::TypeConverter<XRDepthDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRDepthData>::Convert(*this);
  }

  XRDepthData();
  ~XRDepthData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = XRDepthDataPtr>
  XRDepthDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, XRDepthData>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  Tag which() const {
    return tag_;
  }


  
  bool is_data_still_valid() const { return tag_ == Tag::DATA_STILL_VALID; }

  
  XRDepthDataStillValidPtr& get_data_still_valid() const {
    DCHECK(tag_ == Tag::DATA_STILL_VALID);
    return *(data_.data_still_valid);
  }

  
  void set_data_still_valid(
      XRDepthDataStillValidPtr data_still_valid);
  
  bool is_updated_depth_data() const { return tag_ == Tag::UPDATED_DEPTH_DATA; }

  
  XRDepthDataUpdatedPtr& get_updated_depth_data() const {
    DCHECK(tag_ == Tag::UPDATED_DEPTH_DATA);
    return *(data_.updated_depth_data);
  }

  
  void set_updated_depth_data(
      XRDepthDataUpdatedPtr updated_depth_data);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRDepthData::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<XRDepthData::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

 private:
  union Union_ {
    Union_() {}
    ~Union_() {}
    XRDepthDataStillValidPtr* data_still_valid;
    XRDepthDataUpdatedPtr* updated_depth_data;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) RequestSessionResult {
 public:
  using DataView = RequestSessionResultDataView;
  using Data_ = internal::RequestSessionResult_Data;
  using Tag = Data_::RequestSessionResult_Tag;

  static RequestSessionResultPtr New() {
    return RequestSessionResultPtr(base::in_place);
  }
  // Construct an instance holding |success|.
  static RequestSessionResultPtr
  NewSuccess(
      RequestSessionSuccessPtr success) {
    auto result = RequestSessionResultPtr(base::in_place);
    result->set_success(std::move(success));
    return result;
  }
  // Construct an instance holding |failure_reason|.
  static RequestSessionResultPtr
  NewFailureReason(
      RequestSessionError failure_reason) {
    auto result = RequestSessionResultPtr(base::in_place);
    result->set_failure_reason(std::move(failure_reason));
    return result;
  }

  template <typename U>
  static RequestSessionResultPtr From(const U& u) {
    return mojo::TypeConverter<RequestSessionResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RequestSessionResult>::Convert(*this);
  }

  RequestSessionResult();
  ~RequestSessionResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = RequestSessionResultPtr>
  RequestSessionResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, RequestSessionResult>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  Tag which() const {
    return tag_;
  }


  
  bool is_success() const { return tag_ == Tag::SUCCESS; }

  
  RequestSessionSuccessPtr& get_success() const {
    DCHECK(tag_ == Tag::SUCCESS);
    return *(data_.success);
  }

  
  void set_success(
      RequestSessionSuccessPtr success);
  
  bool is_failure_reason() const { return tag_ == Tag::FAILURE_REASON; }

  
  RequestSessionError get_failure_reason() const {
    DCHECK(tag_ == Tag::FAILURE_REASON);
    return data_.failure_reason;
  }

  
  void set_failure_reason(
      RequestSessionError failure_reason);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RequestSessionResult::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<RequestSessionResult::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

 private:
  union Union_ {
    Union_() {}
    ~Union_() {}
    RequestSessionSuccessPtr* success;
    RequestSessionError failure_reason;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) XRSessionOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRSessionOptions, T>::value>;
  using DataView = XRSessionOptionsDataView;
  using Data_ = internal::XRSessionOptions_Data;

  template <typename... Args>
  static XRSessionOptionsPtr New(Args&&... args) {
    return XRSessionOptionsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRSessionOptionsPtr From(const U& u) {
    return mojo::TypeConverter<XRSessionOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRSessionOptions>::Convert(*this);
  }


  XRSessionOptions();

  XRSessionOptions(
      XRSessionMode mode,
      WTF::Vector<XRSessionFeature> required_features,
      WTF::Vector<XRSessionFeature> optional_features);

  ~XRSessionOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRSessionOptionsPtr>
  XRSessionOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRSessionOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRSessionOptions::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRSessionOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRSessionOptions_UnserializedMessageContext<
            UserType, XRSessionOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<XRSessionOptions::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return XRSessionOptions::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRSessionOptions_UnserializedMessageContext<
            UserType, XRSessionOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRSessionOptions::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  XRSessionMode mode;
  
  WTF::Vector<XRSessionFeature> required_features;
  
  WTF::Vector<XRSessionFeature> optional_features;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRSessionOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRSessionOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRSessionOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRSessionOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) XRSession {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRSession, T>::value>;
  using DataView = XRSessionDataView;
  using Data_ = internal::XRSession_Data;

  template <typename... Args>
  static XRSessionPtr New(Args&&... args) {
    return XRSessionPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRSessionPtr From(const U& u) {
    return mojo::TypeConverter<XRSessionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRSession>::Convert(*this);
  }


  XRSession();

  XRSession(
      ::mojo::PendingRemote<XRFrameDataProvider> data_provider,
      ::mojo::PendingReceiver<XRSessionClient> client_receiver,
      VRDisplayInfoPtr display_info,
      XRPresentationConnectionPtr submit_frame_sink,
      WTF::Vector<XRSessionFeature> enabled_features,
      bool uses_input_eventing,
      float default_framebuffer_scale);

  ~XRSession();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRSessionPtr>
  XRSessionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRSession::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRSession::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRSession::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRSession_UnserializedMessageContext<
            UserType, XRSession::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<XRSession::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return XRSession::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRSession_UnserializedMessageContext<
            UserType, XRSession::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRSession::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::mojo::PendingRemote<XRFrameDataProvider> data_provider;
  
  ::mojo::PendingReceiver<XRSessionClient> client_receiver;
  
  VRDisplayInfoPtr display_info;
  
  XRPresentationConnectionPtr submit_frame_sink;
  
  WTF::Vector<XRSessionFeature> enabled_features;
  
  bool uses_input_eventing;
  
  float default_framebuffer_scale;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(XRSession);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRSession::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRSession::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRSession::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRSession::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) XRPresentationConnection {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRPresentationConnection, T>::value>;
  using DataView = XRPresentationConnectionDataView;
  using Data_ = internal::XRPresentationConnection_Data;

  template <typename... Args>
  static XRPresentationConnectionPtr New(Args&&... args) {
    return XRPresentationConnectionPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRPresentationConnectionPtr From(const U& u) {
    return mojo::TypeConverter<XRPresentationConnectionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRPresentationConnection>::Convert(*this);
  }


  XRPresentationConnection();

  XRPresentationConnection(
      ::mojo::PendingRemote<XRPresentationProvider> provider,
      ::mojo::PendingReceiver<XRPresentationClient> client_receiver,
      XRPresentationTransportOptionsPtr transport_options);

  ~XRPresentationConnection();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRPresentationConnectionPtr>
  XRPresentationConnectionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRPresentationConnection::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRPresentationConnection::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRPresentationConnection::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRPresentationConnection_UnserializedMessageContext<
            UserType, XRPresentationConnection::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<XRPresentationConnection::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return XRPresentationConnection::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRPresentationConnection_UnserializedMessageContext<
            UserType, XRPresentationConnection::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRPresentationConnection::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::mojo::PendingRemote<XRPresentationProvider> provider;
  
  ::mojo::PendingReceiver<XRPresentationClient> client_receiver;
  
  XRPresentationTransportOptionsPtr transport_options;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(XRPresentationConnection);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRPresentationConnection::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRPresentationConnection::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRPresentationConnection::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRPresentationConnection::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) XRInputSourceDescription {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRInputSourceDescription, T>::value>;
  using DataView = XRInputSourceDescriptionDataView;
  using Data_ = internal::XRInputSourceDescription_Data;

  template <typename... Args>
  static XRInputSourceDescriptionPtr New(Args&&... args) {
    return XRInputSourceDescriptionPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRInputSourceDescriptionPtr From(const U& u) {
    return mojo::TypeConverter<XRInputSourceDescriptionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRInputSourceDescription>::Convert(*this);
  }


  XRInputSourceDescription();

  XRInputSourceDescription(
      XRTargetRayMode target_ray_mode,
      XRHandedness handedness,
      const base::Optional<::gfx::Transform>& input_from_pointer,
      WTF::Vector<WTF::String> profiles);

  ~XRInputSourceDescription();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRInputSourceDescriptionPtr>
  XRInputSourceDescriptionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRInputSourceDescription::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRInputSourceDescription::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRInputSourceDescription::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRInputSourceDescription_UnserializedMessageContext<
            UserType, XRInputSourceDescription::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<XRInputSourceDescription::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return XRInputSourceDescription::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRInputSourceDescription_UnserializedMessageContext<
            UserType, XRInputSourceDescription::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRInputSourceDescription::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  XRTargetRayMode target_ray_mode;
  
  XRHandedness handedness;
  
  base::Optional<::gfx::Transform> input_from_pointer;
  
  WTF::Vector<WTF::String> profiles;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRInputSourceDescription::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRInputSourceDescription::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRInputSourceDescription::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRInputSourceDescription::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) XRInputSourceState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRInputSourceState, T>::value>;
  using DataView = XRInputSourceStateDataView;
  using Data_ = internal::XRInputSourceState_Data;

  template <typename... Args>
  static XRInputSourceStatePtr New(Args&&... args) {
    return XRInputSourceStatePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRInputSourceStatePtr From(const U& u) {
    return mojo::TypeConverter<XRInputSourceStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRInputSourceState>::Convert(*this);
  }


  XRInputSourceState();

  XRInputSourceState(
      uint32_t source_id,
      XRInputSourceDescriptionPtr description,
      const base::Optional<::gfx::Transform>& mojo_from_input,
      bool emulated_position,
      bool is_auxiliary,
      bool primary_input_pressed,
      bool primary_input_clicked,
      bool primary_squeeze_pressed,
      bool primary_squeeze_clicked,
      const base::Optional<::device::Gamepad>& gamepad,
      const base::Optional<::gfx::PointF>& overlay_pointer_position);

  ~XRInputSourceState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRInputSourceStatePtr>
  XRInputSourceStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRInputSourceState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRInputSourceState::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRInputSourceState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRInputSourceState_UnserializedMessageContext<
            UserType, XRInputSourceState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<XRInputSourceState::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return XRInputSourceState::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRInputSourceState_UnserializedMessageContext<
            UserType, XRInputSourceState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRInputSourceState::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  uint32_t source_id;
  
  XRInputSourceDescriptionPtr description;
  
  base::Optional<::gfx::Transform> mojo_from_input;
  
  bool emulated_position;
  
  bool is_auxiliary;
  
  bool primary_input_pressed;
  
  bool primary_input_clicked;
  
  bool primary_squeeze_pressed;
  
  bool primary_squeeze_clicked;
  
  base::Optional<::device::Gamepad> gamepad;
  
  base::Optional<::gfx::PointF> overlay_pointer_position;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(XRInputSourceState);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRInputSourceState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRInputSourceState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRInputSourceState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRInputSourceState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) VRPose {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VRPose, T>::value>;
  using DataView = VRPoseDataView;
  using Data_ = internal::VRPose_Data;

  template <typename... Args>
  static VRPosePtr New(Args&&... args) {
    return VRPosePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VRPosePtr From(const U& u) {
    return mojo::TypeConverter<VRPosePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VRPose>::Convert(*this);
  }


  VRPose();

  VRPose(
      const base::Optional<::gfx::Quaternion>& orientation,
      const base::Optional<::gfx::Point3F>& position,
      bool emulated_position);

  ~VRPose();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VRPosePtr>
  VRPosePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VRPose::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VRPose::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VRPose::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VRPose_UnserializedMessageContext<
            UserType, VRPose::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<VRPose::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return VRPose::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VRPose_UnserializedMessageContext<
            UserType, VRPose::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VRPose::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  base::Optional<::gfx::Quaternion> orientation;
  
  base::Optional<::gfx::Point3F> position;
  
  bool emulated_position;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VRPose::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VRPose::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VRPose::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VRPose::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) Pose {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Pose, T>::value>;
  using DataView = PoseDataView;
  using Data_ = internal::Pose_Data;

  template <typename... Args>
  static PosePtr New(Args&&... args) {
    return PosePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PosePtr From(const U& u) {
    return mojo::TypeConverter<PosePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Pose>::Convert(*this);
  }


  Pose();

  Pose(
      const ::gfx::Quaternion& orientation,
      const ::gfx::Point3F& position);

  ~Pose();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PosePtr>
  PosePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Pose::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Pose::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Pose::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Pose_UnserializedMessageContext<
            UserType, Pose::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<Pose::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return Pose::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Pose_UnserializedMessageContext<
            UserType, Pose::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Pose::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::gfx::Quaternion orientation;
  
  ::gfx::Point3F position;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Pose::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Pose::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Pose::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Pose::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) XRRay {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRRay, T>::value>;
  using DataView = XRRayDataView;
  using Data_ = internal::XRRay_Data;

  template <typename... Args>
  static XRRayPtr New(Args&&... args) {
    return XRRayPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRRayPtr From(const U& u) {
    return mojo::TypeConverter<XRRayPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRRay>::Convert(*this);
  }


  XRRay();

  XRRay(
      const ::gfx::Point3F& origin,
      const ::gfx::Vector3dF& direction);

  ~XRRay();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRRayPtr>
  XRRayPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRRay::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRRay::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRRay::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRRay_UnserializedMessageContext<
            UserType, XRRay::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<XRRay::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return XRRay::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRRay_UnserializedMessageContext<
            UserType, XRRay::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRRay::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::gfx::Point3F origin;
  
  ::gfx::Vector3dF direction;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRRay::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRRay::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRRay::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRRay::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) XRHitResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRHitResult, T>::value>;
  using DataView = XRHitResultDataView;
  using Data_ = internal::XRHitResult_Data;

  template <typename... Args>
  static XRHitResultPtr New(Args&&... args) {
    return XRHitResultPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRHitResultPtr From(const U& u) {
    return mojo::TypeConverter<XRHitResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRHitResult>::Convert(*this);
  }


  XRHitResult();

  XRHitResult(
      const ::device::Pose& mojo_from_result,
      uint64_t plane_id);

  ~XRHitResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRHitResultPtr>
  XRHitResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRHitResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRHitResult::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRHitResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRHitResult_UnserializedMessageContext<
            UserType, XRHitResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<XRHitResult::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return XRHitResult::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRHitResult_UnserializedMessageContext<
            UserType, XRHitResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRHitResult::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::device::Pose mojo_from_result;
  
  uint64_t plane_id;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRHitResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRHitResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRHitResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRHitResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) VREyeParameters {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VREyeParameters, T>::value>;
  using DataView = VREyeParametersDataView;
  using Data_ = internal::VREyeParameters_Data;

  template <typename... Args>
  static VREyeParametersPtr New(Args&&... args) {
    return VREyeParametersPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VREyeParametersPtr From(const U& u) {
    return mojo::TypeConverter<VREyeParametersPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VREyeParameters>::Convert(*this);
  }


  VREyeParameters();

  VREyeParameters(
      VRFieldOfViewPtr field_of_view,
      const ::gfx::Transform& head_from_eye,
      uint32_t render_width,
      uint32_t render_height);

  ~VREyeParameters();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VREyeParametersPtr>
  VREyeParametersPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VREyeParameters::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VREyeParameters::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VREyeParameters::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VREyeParameters_UnserializedMessageContext<
            UserType, VREyeParameters::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<VREyeParameters::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return VREyeParameters::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VREyeParameters_UnserializedMessageContext<
            UserType, VREyeParameters::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VREyeParameters::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  VRFieldOfViewPtr field_of_view;
  
  ::gfx::Transform head_from_eye;
  
  uint32_t render_width;
  
  uint32_t render_height;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(VREyeParameters);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VREyeParameters::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VREyeParameters::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VREyeParameters::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VREyeParameters::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) VRStageParameters {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VRStageParameters, T>::value>;
  using DataView = VRStageParametersDataView;
  using Data_ = internal::VRStageParameters_Data;

  template <typename... Args>
  static VRStageParametersPtr New(Args&&... args) {
    return VRStageParametersPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VRStageParametersPtr From(const U& u) {
    return mojo::TypeConverter<VRStageParametersPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VRStageParameters>::Convert(*this);
  }


  VRStageParameters();

  VRStageParameters(
      const ::gfx::Transform& mojo_from_floor,
      base::Optional<WTF::Vector<::gfx::Point3F>> bounds);

  ~VRStageParameters();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VRStageParametersPtr>
  VRStageParametersPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VRStageParameters::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VRStageParameters::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VRStageParameters::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VRStageParameters_UnserializedMessageContext<
            UserType, VRStageParameters::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<VRStageParameters::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return VRStageParameters::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VRStageParameters_UnserializedMessageContext<
            UserType, VRStageParameters::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VRStageParameters::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::gfx::Transform mojo_from_floor;
  
  base::Optional<WTF::Vector<::gfx::Point3F>> bounds;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VRStageParameters::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VRStageParameters::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VRStageParameters::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VRStageParameters::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) VRDisplayInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VRDisplayInfo, T>::value>;
  using DataView = VRDisplayInfoDataView;
  using Data_ = internal::VRDisplayInfo_Data;

  template <typename... Args>
  static VRDisplayInfoPtr New(Args&&... args) {
    return VRDisplayInfoPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VRDisplayInfoPtr From(const U& u) {
    return mojo::TypeConverter<VRDisplayInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VRDisplayInfo>::Convert(*this);
  }


  VRDisplayInfo();

  VRDisplayInfo(
      VRStageParametersPtr stage_parameters,
      VREyeParametersPtr left_eye,
      VREyeParametersPtr right_eye);

  ~VRDisplayInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VRDisplayInfoPtr>
  VRDisplayInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VRDisplayInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VRDisplayInfo::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VRDisplayInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VRDisplayInfo_UnserializedMessageContext<
            UserType, VRDisplayInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<VRDisplayInfo::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return VRDisplayInfo::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VRDisplayInfo_UnserializedMessageContext<
            UserType, VRDisplayInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VRDisplayInfo::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  VRStageParametersPtr stage_parameters;
  
  VREyeParametersPtr left_eye;
  
  VREyeParametersPtr right_eye;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(VRDisplayInfo);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VRDisplayInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VRDisplayInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VRDisplayInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VRDisplayInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) XRPlaneData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRPlaneData, T>::value>;
  using DataView = XRPlaneDataDataView;
  using Data_ = internal::XRPlaneData_Data;

  template <typename... Args>
  static XRPlaneDataPtr New(Args&&... args) {
    return XRPlaneDataPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRPlaneDataPtr From(const U& u) {
    return mojo::TypeConverter<XRPlaneDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRPlaneData>::Convert(*this);
  }


  XRPlaneData();

  XRPlaneData(
      uint64_t id,
      XRPlaneOrientation orientation,
      const base::Optional<::device::Pose>& mojo_from_plane,
      WTF::Vector<XRPlanePointDataPtr> polygon);

  ~XRPlaneData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRPlaneDataPtr>
  XRPlaneDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRPlaneData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRPlaneData::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRPlaneData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRPlaneData_UnserializedMessageContext<
            UserType, XRPlaneData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<XRPlaneData::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return XRPlaneData::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRPlaneData_UnserializedMessageContext<
            UserType, XRPlaneData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRPlaneData::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  uint64_t id;
  
  XRPlaneOrientation orientation;
  
  base::Optional<::device::Pose> mojo_from_plane;
  
  WTF::Vector<XRPlanePointDataPtr> polygon;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(XRPlaneData);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRPlaneData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRPlaneData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRPlaneData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRPlaneData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) XRPlaneDetectionData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRPlaneDetectionData, T>::value>;
  using DataView = XRPlaneDetectionDataDataView;
  using Data_ = internal::XRPlaneDetectionData_Data;

  template <typename... Args>
  static XRPlaneDetectionDataPtr New(Args&&... args) {
    return XRPlaneDetectionDataPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRPlaneDetectionDataPtr From(const U& u) {
    return mojo::TypeConverter<XRPlaneDetectionDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRPlaneDetectionData>::Convert(*this);
  }


  XRPlaneDetectionData();

  XRPlaneDetectionData(
      WTF::Vector<uint64_t> all_planes_ids,
      WTF::Vector<XRPlaneDataPtr> updated_planes_data);

  ~XRPlaneDetectionData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRPlaneDetectionDataPtr>
  XRPlaneDetectionDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRPlaneDetectionData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRPlaneDetectionData::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRPlaneDetectionData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRPlaneDetectionData_UnserializedMessageContext<
            UserType, XRPlaneDetectionData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<XRPlaneDetectionData::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return XRPlaneDetectionData::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRPlaneDetectionData_UnserializedMessageContext<
            UserType, XRPlaneDetectionData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRPlaneDetectionData::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  WTF::Vector<uint64_t> all_planes_ids;
  
  WTF::Vector<XRPlaneDataPtr> updated_planes_data;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(XRPlaneDetectionData);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRPlaneDetectionData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRPlaneDetectionData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRPlaneDetectionData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRPlaneDetectionData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) XRAnchorData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRAnchorData, T>::value>;
  using DataView = XRAnchorDataDataView;
  using Data_ = internal::XRAnchorData_Data;

  template <typename... Args>
  static XRAnchorDataPtr New(Args&&... args) {
    return XRAnchorDataPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRAnchorDataPtr From(const U& u) {
    return mojo::TypeConverter<XRAnchorDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRAnchorData>::Convert(*this);
  }


  XRAnchorData();

  XRAnchorData(
      uint64_t id,
      const base::Optional<::device::Pose>& mojo_from_anchor);

  ~XRAnchorData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRAnchorDataPtr>
  XRAnchorDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRAnchorData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRAnchorData::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRAnchorData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRAnchorData_UnserializedMessageContext<
            UserType, XRAnchorData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<XRAnchorData::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return XRAnchorData::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRAnchorData_UnserializedMessageContext<
            UserType, XRAnchorData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRAnchorData::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  uint64_t id;
  
  base::Optional<::device::Pose> mojo_from_anchor;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRAnchorData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRAnchorData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRAnchorData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRAnchorData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) XRAnchorsData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRAnchorsData, T>::value>;
  using DataView = XRAnchorsDataDataView;
  using Data_ = internal::XRAnchorsData_Data;

  template <typename... Args>
  static XRAnchorsDataPtr New(Args&&... args) {
    return XRAnchorsDataPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRAnchorsDataPtr From(const U& u) {
    return mojo::TypeConverter<XRAnchorsDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRAnchorsData>::Convert(*this);
  }


  XRAnchorsData();

  XRAnchorsData(
      WTF::Vector<uint64_t> all_anchors_ids,
      WTF::Vector<XRAnchorDataPtr> updated_anchors_data);

  ~XRAnchorsData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRAnchorsDataPtr>
  XRAnchorsDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRAnchorsData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRAnchorsData::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRAnchorsData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRAnchorsData_UnserializedMessageContext<
            UserType, XRAnchorsData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<XRAnchorsData::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return XRAnchorsData::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRAnchorsData_UnserializedMessageContext<
            UserType, XRAnchorsData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRAnchorsData::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  WTF::Vector<uint64_t> all_anchors_ids;
  
  WTF::Vector<XRAnchorDataPtr> updated_anchors_data;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(XRAnchorsData);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRAnchorsData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRAnchorsData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRAnchorsData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRAnchorsData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) XRHitTestSubscriptionResultData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRHitTestSubscriptionResultData, T>::value>;
  using DataView = XRHitTestSubscriptionResultDataDataView;
  using Data_ = internal::XRHitTestSubscriptionResultData_Data;

  template <typename... Args>
  static XRHitTestSubscriptionResultDataPtr New(Args&&... args) {
    return XRHitTestSubscriptionResultDataPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRHitTestSubscriptionResultDataPtr From(const U& u) {
    return mojo::TypeConverter<XRHitTestSubscriptionResultDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRHitTestSubscriptionResultData>::Convert(*this);
  }


  XRHitTestSubscriptionResultData();

  XRHitTestSubscriptionResultData(
      uint64_t subscription_id,
      WTF::Vector<XRHitResultPtr> hit_test_results);

  ~XRHitTestSubscriptionResultData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRHitTestSubscriptionResultDataPtr>
  XRHitTestSubscriptionResultDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRHitTestSubscriptionResultData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRHitTestSubscriptionResultData::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRHitTestSubscriptionResultData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRHitTestSubscriptionResultData_UnserializedMessageContext<
            UserType, XRHitTestSubscriptionResultData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<XRHitTestSubscriptionResultData::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return XRHitTestSubscriptionResultData::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRHitTestSubscriptionResultData_UnserializedMessageContext<
            UserType, XRHitTestSubscriptionResultData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRHitTestSubscriptionResultData::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  uint64_t subscription_id;
  
  WTF::Vector<XRHitResultPtr> hit_test_results;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(XRHitTestSubscriptionResultData);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRHitTestSubscriptionResultData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRHitTestSubscriptionResultData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRHitTestSubscriptionResultData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRHitTestSubscriptionResultData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) XRHitTestTransientInputSubscriptionResultData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRHitTestTransientInputSubscriptionResultData, T>::value>;
  using DataView = XRHitTestTransientInputSubscriptionResultDataDataView;
  using Data_ = internal::XRHitTestTransientInputSubscriptionResultData_Data;

  template <typename... Args>
  static XRHitTestTransientInputSubscriptionResultDataPtr New(Args&&... args) {
    return XRHitTestTransientInputSubscriptionResultDataPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRHitTestTransientInputSubscriptionResultDataPtr From(const U& u) {
    return mojo::TypeConverter<XRHitTestTransientInputSubscriptionResultDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRHitTestTransientInputSubscriptionResultData>::Convert(*this);
  }


  XRHitTestTransientInputSubscriptionResultData();

  XRHitTestTransientInputSubscriptionResultData(
      uint64_t subscription_id,
      WTF::HashMap<uint32_t, WTF::Vector<XRHitResultPtr>> input_source_id_to_hit_test_results);

  ~XRHitTestTransientInputSubscriptionResultData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRHitTestTransientInputSubscriptionResultDataPtr>
  XRHitTestTransientInputSubscriptionResultDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRHitTestTransientInputSubscriptionResultData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRHitTestTransientInputSubscriptionResultData::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRHitTestTransientInputSubscriptionResultData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRHitTestTransientInputSubscriptionResultData_UnserializedMessageContext<
            UserType, XRHitTestTransientInputSubscriptionResultData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<XRHitTestTransientInputSubscriptionResultData::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return XRHitTestTransientInputSubscriptionResultData::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRHitTestTransientInputSubscriptionResultData_UnserializedMessageContext<
            UserType, XRHitTestTransientInputSubscriptionResultData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRHitTestTransientInputSubscriptionResultData::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  uint64_t subscription_id;
  
  WTF::HashMap<uint32_t, WTF::Vector<XRHitResultPtr>> input_source_id_to_hit_test_results;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(XRHitTestTransientInputSubscriptionResultData);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRHitTestTransientInputSubscriptionResultData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRHitTestTransientInputSubscriptionResultData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRHitTestTransientInputSubscriptionResultData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRHitTestTransientInputSubscriptionResultData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) XRHitTestSubscriptionResultsData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRHitTestSubscriptionResultsData, T>::value>;
  using DataView = XRHitTestSubscriptionResultsDataDataView;
  using Data_ = internal::XRHitTestSubscriptionResultsData_Data;

  template <typename... Args>
  static XRHitTestSubscriptionResultsDataPtr New(Args&&... args) {
    return XRHitTestSubscriptionResultsDataPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRHitTestSubscriptionResultsDataPtr From(const U& u) {
    return mojo::TypeConverter<XRHitTestSubscriptionResultsDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRHitTestSubscriptionResultsData>::Convert(*this);
  }


  XRHitTestSubscriptionResultsData();

  XRHitTestSubscriptionResultsData(
      WTF::Vector<XRHitTestSubscriptionResultDataPtr> results,
      WTF::Vector<XRHitTestTransientInputSubscriptionResultDataPtr> transient_input_results);

  ~XRHitTestSubscriptionResultsData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRHitTestSubscriptionResultsDataPtr>
  XRHitTestSubscriptionResultsDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRHitTestSubscriptionResultsData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRHitTestSubscriptionResultsData::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRHitTestSubscriptionResultsData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRHitTestSubscriptionResultsData_UnserializedMessageContext<
            UserType, XRHitTestSubscriptionResultsData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<XRHitTestSubscriptionResultsData::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return XRHitTestSubscriptionResultsData::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRHitTestSubscriptionResultsData_UnserializedMessageContext<
            UserType, XRHitTestSubscriptionResultsData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRHitTestSubscriptionResultsData::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  WTF::Vector<XRHitTestSubscriptionResultDataPtr> results;
  
  WTF::Vector<XRHitTestTransientInputSubscriptionResultDataPtr> transient_input_results;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(XRHitTestSubscriptionResultsData);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRHitTestSubscriptionResultsData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRHitTestSubscriptionResultsData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRHitTestSubscriptionResultsData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRHitTestSubscriptionResultsData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) XRSphericalHarmonics {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRSphericalHarmonics, T>::value>;
  using DataView = XRSphericalHarmonicsDataView;
  using Data_ = internal::XRSphericalHarmonics_Data;

  template <typename... Args>
  static XRSphericalHarmonicsPtr New(Args&&... args) {
    return XRSphericalHarmonicsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRSphericalHarmonicsPtr From(const U& u) {
    return mojo::TypeConverter<XRSphericalHarmonicsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRSphericalHarmonics>::Convert(*this);
  }


  XRSphericalHarmonics();

  explicit XRSphericalHarmonics(
      WTF::Vector<::device::RgbTupleF32> coefficients);

  ~XRSphericalHarmonics();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRSphericalHarmonicsPtr>
  XRSphericalHarmonicsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRSphericalHarmonics::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRSphericalHarmonics::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRSphericalHarmonics::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRSphericalHarmonics_UnserializedMessageContext<
            UserType, XRSphericalHarmonics::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<XRSphericalHarmonics::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return XRSphericalHarmonics::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRSphericalHarmonics_UnserializedMessageContext<
            UserType, XRSphericalHarmonics::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRSphericalHarmonics::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  WTF::Vector<::device::RgbTupleF32> coefficients;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRSphericalHarmonics::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRSphericalHarmonics::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRSphericalHarmonics::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRSphericalHarmonics::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) XRCubeMap {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRCubeMap, T>::value>;
  using DataView = XRCubeMapDataView;
  using Data_ = internal::XRCubeMap_Data;
  
  static constexpr uint64_t kNumComponentsPerPixel = 4ULL;

  template <typename... Args>
  static XRCubeMapPtr New(Args&&... args) {
    return XRCubeMapPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRCubeMapPtr From(const U& u) {
    return mojo::TypeConverter<XRCubeMapPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRCubeMap>::Convert(*this);
  }


  XRCubeMap();

  XRCubeMap(
      uint32_t width_and_height,
      WTF::Vector<::device::RgbaTupleF16> positive_x,
      WTF::Vector<::device::RgbaTupleF16> negative_x,
      WTF::Vector<::device::RgbaTupleF16> positive_y,
      WTF::Vector<::device::RgbaTupleF16> negative_y,
      WTF::Vector<::device::RgbaTupleF16> positive_z,
      WTF::Vector<::device::RgbaTupleF16> negative_z);

  ~XRCubeMap();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRCubeMapPtr>
  XRCubeMapPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRCubeMap::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRCubeMap::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRCubeMap::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRCubeMap_UnserializedMessageContext<
            UserType, XRCubeMap::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<XRCubeMap::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return XRCubeMap::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRCubeMap_UnserializedMessageContext<
            UserType, XRCubeMap::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRCubeMap::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  uint32_t width_and_height;
  
  WTF::Vector<::device::RgbaTupleF16> positive_x;
  
  WTF::Vector<::device::RgbaTupleF16> negative_x;
  
  WTF::Vector<::device::RgbaTupleF16> positive_y;
  
  WTF::Vector<::device::RgbaTupleF16> negative_y;
  
  WTF::Vector<::device::RgbaTupleF16> positive_z;
  
  WTF::Vector<::device::RgbaTupleF16> negative_z;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRCubeMap::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRCubeMap::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRCubeMap::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRCubeMap::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) XRLightProbe {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRLightProbe, T>::value>;
  using DataView = XRLightProbeDataView;
  using Data_ = internal::XRLightProbe_Data;

  template <typename... Args>
  static XRLightProbePtr New(Args&&... args) {
    return XRLightProbePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRLightProbePtr From(const U& u) {
    return mojo::TypeConverter<XRLightProbePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRLightProbe>::Convert(*this);
  }


  XRLightProbe();

  XRLightProbe(
      XRSphericalHarmonicsPtr spherical_harmonics,
      const ::gfx::Vector3dF& main_light_direction,
      const ::device::RgbTupleF32& main_light_intensity);

  ~XRLightProbe();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRLightProbePtr>
  XRLightProbePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRLightProbe::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRLightProbe::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRLightProbe::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRLightProbe_UnserializedMessageContext<
            UserType, XRLightProbe::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<XRLightProbe::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return XRLightProbe::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRLightProbe_UnserializedMessageContext<
            UserType, XRLightProbe::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRLightProbe::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  XRSphericalHarmonicsPtr spherical_harmonics;
  
  ::gfx::Vector3dF main_light_direction;
  
  ::device::RgbTupleF32 main_light_intensity;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(XRLightProbe);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRLightProbe::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRLightProbe::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRLightProbe::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRLightProbe::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) XRReflectionProbe {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRReflectionProbe, T>::value>;
  using DataView = XRReflectionProbeDataView;
  using Data_ = internal::XRReflectionProbe_Data;

  template <typename... Args>
  static XRReflectionProbePtr New(Args&&... args) {
    return XRReflectionProbePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRReflectionProbePtr From(const U& u) {
    return mojo::TypeConverter<XRReflectionProbePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRReflectionProbe>::Convert(*this);
  }


  XRReflectionProbe();

  explicit XRReflectionProbe(
      XRCubeMapPtr cube_map);

  ~XRReflectionProbe();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRReflectionProbePtr>
  XRReflectionProbePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRReflectionProbe::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRReflectionProbe::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRReflectionProbe::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRReflectionProbe_UnserializedMessageContext<
            UserType, XRReflectionProbe::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<XRReflectionProbe::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return XRReflectionProbe::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRReflectionProbe_UnserializedMessageContext<
            UserType, XRReflectionProbe::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRReflectionProbe::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  XRCubeMapPtr cube_map;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(XRReflectionProbe);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRReflectionProbe::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRReflectionProbe::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRReflectionProbe::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRReflectionProbe::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) XRLightEstimationData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRLightEstimationData, T>::value>;
  using DataView = XRLightEstimationDataDataView;
  using Data_ = internal::XRLightEstimationData_Data;

  template <typename... Args>
  static XRLightEstimationDataPtr New(Args&&... args) {
    return XRLightEstimationDataPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRLightEstimationDataPtr From(const U& u) {
    return mojo::TypeConverter<XRLightEstimationDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRLightEstimationData>::Convert(*this);
  }


  XRLightEstimationData();

  XRLightEstimationData(
      XRLightProbePtr light_probe,
      XRReflectionProbePtr reflection_probe);

  ~XRLightEstimationData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRLightEstimationDataPtr>
  XRLightEstimationDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRLightEstimationData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRLightEstimationData::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRLightEstimationData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRLightEstimationData_UnserializedMessageContext<
            UserType, XRLightEstimationData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<XRLightEstimationData::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return XRLightEstimationData::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRLightEstimationData_UnserializedMessageContext<
            UserType, XRLightEstimationData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRLightEstimationData::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  XRLightProbePtr light_probe;
  
  XRReflectionProbePtr reflection_probe;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(XRLightEstimationData);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRLightEstimationData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRLightEstimationData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRLightEstimationData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRLightEstimationData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) XRDepthDataUpdated {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRDepthDataUpdated, T>::value>;
  using DataView = XRDepthDataUpdatedDataView;
  using Data_ = internal::XRDepthDataUpdated_Data;

  template <typename... Args>
  static XRDepthDataUpdatedPtr New(Args&&... args) {
    return XRDepthDataUpdatedPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRDepthDataUpdatedPtr From(const U& u) {
    return mojo::TypeConverter<XRDepthDataUpdatedPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRDepthDataUpdated>::Convert(*this);
  }


  XRDepthDataUpdated();

  XRDepthDataUpdated(
      ::base::TimeDelta time_delta,
      ::mojo_base::BigBuffer pixel_data,
      const ::gfx::Transform& norm_texture_from_norm_view,
      const ::gfx::Size& size);

  ~XRDepthDataUpdated();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRDepthDataUpdatedPtr>
  XRDepthDataUpdatedPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRDepthDataUpdated::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRDepthDataUpdated::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRDepthDataUpdated::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRDepthDataUpdated_UnserializedMessageContext<
            UserType, XRDepthDataUpdated::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<XRDepthDataUpdated::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return XRDepthDataUpdated::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRDepthDataUpdated_UnserializedMessageContext<
            UserType, XRDepthDataUpdated::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRDepthDataUpdated::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::base::TimeDelta time_delta;
  
  ::mojo_base::BigBuffer pixel_data;
  
  ::gfx::Transform norm_texture_from_norm_view;
  
  ::gfx::Size size;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(XRDepthDataUpdated);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRDepthDataUpdated::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRDepthDataUpdated::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRDepthDataUpdated::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRDepthDataUpdated::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) XRFrameData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRFrameData, T>::value>;
  using DataView = XRFrameDataDataView;
  using Data_ = internal::XRFrameData_Data;

  template <typename... Args>
  static XRFrameDataPtr New(Args&&... args) {
    return XRFrameDataPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRFrameDataPtr From(const U& u) {
    return mojo::TypeConverter<XRFrameDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRFrameData>::Convert(*this);
  }


  XRFrameData();

  XRFrameData(
      VRPosePtr pose,
      ::base::TimeDelta time_delta,
      const base::Optional<::gpu::MailboxHolder>& buffer_holder,
      const base::Optional<::gpu::MailboxHolder>& camera_image_buffer_holder,
      XRDepthDataPtr depth_data,
      bool mojo_space_reset,
      int16_t frame_id,
      VREyeParametersPtr left_eye,
      VREyeParametersPtr right_eye,
      base::Optional<WTF::Vector<XRInputSourceStatePtr>> input_state,
      bool stage_parameters_updated,
      VRStageParametersPtr stage_parameters,
      XRPlaneDetectionDataPtr detected_planes_data,
      XRAnchorsDataPtr anchors_data,
      XRLightEstimationDataPtr light_estimation_data,
      XRHitTestSubscriptionResultsDataPtr hit_test_subscription_results);

  ~XRFrameData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRFrameDataPtr>
  XRFrameDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRFrameData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRFrameData::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRFrameData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRFrameData_UnserializedMessageContext<
            UserType, XRFrameData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<XRFrameData::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return XRFrameData::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRFrameData_UnserializedMessageContext<
            UserType, XRFrameData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRFrameData::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  VRPosePtr pose;
  
  ::base::TimeDelta time_delta;
  
  base::Optional<::gpu::MailboxHolder> buffer_holder;
  
  base::Optional<::gpu::MailboxHolder> camera_image_buffer_holder;
  
  XRDepthDataPtr depth_data;
  
  bool mojo_space_reset;
  
  int16_t frame_id;
  
  VREyeParametersPtr left_eye;
  
  VREyeParametersPtr right_eye;
  
  base::Optional<WTF::Vector<XRInputSourceStatePtr>> input_state;
  
  bool stage_parameters_updated;
  
  VRStageParametersPtr stage_parameters;
  
  XRPlaneDetectionDataPtr detected_planes_data;
  
  XRAnchorsDataPtr anchors_data;
  
  XRLightEstimationDataPtr light_estimation_data;
  
  XRHitTestSubscriptionResultsDataPtr hit_test_subscription_results;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(XRFrameData);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRFrameData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRFrameData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRFrameData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRFrameData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) RequestSessionSuccess {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RequestSessionSuccess, T>::value>;
  using DataView = RequestSessionSuccessDataView;
  using Data_ = internal::RequestSessionSuccess_Data;

  template <typename... Args>
  static RequestSessionSuccessPtr New(Args&&... args) {
    return RequestSessionSuccessPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RequestSessionSuccessPtr From(const U& u) {
    return mojo::TypeConverter<RequestSessionSuccessPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RequestSessionSuccess>::Convert(*this);
  }


  RequestSessionSuccess();

  RequestSessionSuccess(
      XRSessionPtr session,
      ::mojo::PendingRemote<XRSessionMetricsRecorder> metrics_recorder);

  ~RequestSessionSuccess();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RequestSessionSuccessPtr>
  RequestSessionSuccessPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RequestSessionSuccess::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RequestSessionSuccess::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RequestSessionSuccess::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RequestSessionSuccess_UnserializedMessageContext<
            UserType, RequestSessionSuccess::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<RequestSessionSuccess::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return RequestSessionSuccess::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RequestSessionSuccess_UnserializedMessageContext<
            UserType, RequestSessionSuccess::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RequestSessionSuccess::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  XRSessionPtr session;
  
  ::mojo::PendingRemote<XRSessionMetricsRecorder> metrics_recorder;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(RequestSessionSuccess);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RequestSessionSuccess::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RequestSessionSuccess::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RequestSessionSuccess::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RequestSessionSuccess::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename UnionPtrType>
XRNativeOriginInformationPtr XRNativeOriginInformation::Clone() const {
  // Use UnionPtrType to prevent the compiler from trying to compile this
  // without being asked.
  UnionPtrType rv(New());
  switch (tag_) {
    case Tag::INPUT_SOURCE_ID:
      rv->set_input_source_id(mojo::Clone(data_.input_source_id));
      break;
    case Tag::PLANE_ID:
      rv->set_plane_id(mojo::Clone(data_.plane_id));
      break;
    case Tag::ANCHOR_ID:
      rv->set_anchor_id(mojo::Clone(data_.anchor_id));
      break;
    case Tag::REFERENCE_SPACE_TYPE:
      rv->set_reference_space_type(mojo::Clone(data_.reference_space_type));
      break;
  }
  return rv;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, XRNativeOriginInformation>::value>::type*>
bool XRNativeOriginInformation::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::INPUT_SOURCE_ID:
      return mojo::Equals(data_.input_source_id, other.data_.input_source_id);
    case Tag::PLANE_ID:
      return mojo::Equals(data_.plane_id, other.data_.plane_id);
    case Tag::ANCHOR_ID:
      return mojo::Equals(data_.anchor_id, other.data_.anchor_id);
    case Tag::REFERENCE_SPACE_TYPE:
      return mojo::Equals(data_.reference_space_type, other.data_.reference_space_type);
  }

  return false;
}
template <typename UnionPtrType>
XRDepthDataPtr XRDepthData::Clone() const {
  // Use UnionPtrType to prevent the compiler from trying to compile this
  // without being asked.
  UnionPtrType rv(New());
  switch (tag_) {
    case Tag::DATA_STILL_VALID:
      rv->set_data_still_valid(mojo::Clone(*data_.data_still_valid));
      break;
    case Tag::UPDATED_DEPTH_DATA:
      rv->set_updated_depth_data(mojo::Clone(*data_.updated_depth_data));
      break;
  }
  return rv;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, XRDepthData>::value>::type*>
bool XRDepthData::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::DATA_STILL_VALID:
      return mojo::Equals(*(data_.data_still_valid), *(other.data_.data_still_valid));
    case Tag::UPDATED_DEPTH_DATA:
      return mojo::Equals(*(data_.updated_depth_data), *(other.data_.updated_depth_data));
  }

  return false;
}
template <typename UnionPtrType>
RequestSessionResultPtr RequestSessionResult::Clone() const {
  // Use UnionPtrType to prevent the compiler from trying to compile this
  // without being asked.
  UnionPtrType rv(New());
  switch (tag_) {
    case Tag::SUCCESS:
      rv->set_success(mojo::Clone(*data_.success));
      break;
    case Tag::FAILURE_REASON:
      rv->set_failure_reason(mojo::Clone(data_.failure_reason));
      break;
  }
  return rv;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, RequestSessionResult>::value>::type*>
bool RequestSessionResult::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::SUCCESS:
      return mojo::Equals(*(data_.success), *(other.data_.success));
    case Tag::FAILURE_REASON:
      return mojo::Equals(data_.failure_reason, other.data_.failure_reason);
  }

  return false;
}
template <typename StructPtrType>
XRSessionOptionsPtr XRSessionOptions::Clone() const {
  return New(
      mojo::Clone(mode),
      mojo::Clone(required_features),
      mojo::Clone(optional_features)
  );
}

template <typename T, XRSessionOptions::EnableIfSame<T>*>
bool XRSessionOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->mode, other_struct.mode))
    return false;
  if (!mojo::Equals(this->required_features, other_struct.required_features))
    return false;
  if (!mojo::Equals(this->optional_features, other_struct.optional_features))
    return false;
  return true;
}

template <typename T, XRSessionOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.mode, rhs.mode))
    return true;
  if (std::less<>{}(rhs.mode, lhs.mode))
    return false;
  if (std::less<>{}(lhs.required_features, rhs.required_features))
    return true;
  if (std::less<>{}(rhs.required_features, lhs.required_features))
    return false;
  if (std::less<>{}(lhs.optional_features, rhs.optional_features))
    return true;
  if (std::less<>{}(rhs.optional_features, lhs.optional_features))
    return false;
  return false;
}
template <typename StructPtrType>
XRSessionPtr XRSession::Clone() const {
  return New(
      mojo::Clone(data_provider),
      mojo::Clone(client_receiver),
      mojo::Clone(display_info),
      mojo::Clone(submit_frame_sink),
      mojo::Clone(enabled_features),
      mojo::Clone(uses_input_eventing),
      mojo::Clone(default_framebuffer_scale)
  );
}

template <typename T, XRSession::EnableIfSame<T>*>
bool XRSession::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->data_provider, other_struct.data_provider))
    return false;
  if (!mojo::Equals(this->client_receiver, other_struct.client_receiver))
    return false;
  if (!mojo::Equals(this->display_info, other_struct.display_info))
    return false;
  if (!mojo::Equals(this->submit_frame_sink, other_struct.submit_frame_sink))
    return false;
  if (!mojo::Equals(this->enabled_features, other_struct.enabled_features))
    return false;
  if (!mojo::Equals(this->uses_input_eventing, other_struct.uses_input_eventing))
    return false;
  if (!mojo::Equals(this->default_framebuffer_scale, other_struct.default_framebuffer_scale))
    return false;
  return true;
}

template <typename T, XRSession::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.data_provider, rhs.data_provider))
    return true;
  if (std::less<>{}(rhs.data_provider, lhs.data_provider))
    return false;
  if (std::less<>{}(lhs.client_receiver, rhs.client_receiver))
    return true;
  if (std::less<>{}(rhs.client_receiver, lhs.client_receiver))
    return false;
  if (std::less<>{}(lhs.display_info, rhs.display_info))
    return true;
  if (std::less<>{}(rhs.display_info, lhs.display_info))
    return false;
  if (std::less<>{}(lhs.submit_frame_sink, rhs.submit_frame_sink))
    return true;
  if (std::less<>{}(rhs.submit_frame_sink, lhs.submit_frame_sink))
    return false;
  if (std::less<>{}(lhs.enabled_features, rhs.enabled_features))
    return true;
  if (std::less<>{}(rhs.enabled_features, lhs.enabled_features))
    return false;
  if (std::less<>{}(lhs.uses_input_eventing, rhs.uses_input_eventing))
    return true;
  if (std::less<>{}(rhs.uses_input_eventing, lhs.uses_input_eventing))
    return false;
  if (std::less<>{}(lhs.default_framebuffer_scale, rhs.default_framebuffer_scale))
    return true;
  if (std::less<>{}(rhs.default_framebuffer_scale, lhs.default_framebuffer_scale))
    return false;
  return false;
}
template <typename StructPtrType>
XRPresentationConnectionPtr XRPresentationConnection::Clone() const {
  return New(
      mojo::Clone(provider),
      mojo::Clone(client_receiver),
      mojo::Clone(transport_options)
  );
}

template <typename T, XRPresentationConnection::EnableIfSame<T>*>
bool XRPresentationConnection::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->provider, other_struct.provider))
    return false;
  if (!mojo::Equals(this->client_receiver, other_struct.client_receiver))
    return false;
  if (!mojo::Equals(this->transport_options, other_struct.transport_options))
    return false;
  return true;
}

template <typename T, XRPresentationConnection::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.provider, rhs.provider))
    return true;
  if (std::less<>{}(rhs.provider, lhs.provider))
    return false;
  if (std::less<>{}(lhs.client_receiver, rhs.client_receiver))
    return true;
  if (std::less<>{}(rhs.client_receiver, lhs.client_receiver))
    return false;
  if (std::less<>{}(lhs.transport_options, rhs.transport_options))
    return true;
  if (std::less<>{}(rhs.transport_options, lhs.transport_options))
    return false;
  return false;
}
template <typename StructPtrType>
XRInputSourceDescriptionPtr XRInputSourceDescription::Clone() const {
  return New(
      mojo::Clone(target_ray_mode),
      mojo::Clone(handedness),
      mojo::Clone(input_from_pointer),
      mojo::Clone(profiles)
  );
}

template <typename T, XRInputSourceDescription::EnableIfSame<T>*>
bool XRInputSourceDescription::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->target_ray_mode, other_struct.target_ray_mode))
    return false;
  if (!mojo::Equals(this->handedness, other_struct.handedness))
    return false;
  if (!mojo::Equals(this->input_from_pointer, other_struct.input_from_pointer))
    return false;
  if (!mojo::Equals(this->profiles, other_struct.profiles))
    return false;
  return true;
}

template <typename T, XRInputSourceDescription::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.target_ray_mode, rhs.target_ray_mode))
    return true;
  if (std::less<>{}(rhs.target_ray_mode, lhs.target_ray_mode))
    return false;
  if (std::less<>{}(lhs.handedness, rhs.handedness))
    return true;
  if (std::less<>{}(rhs.handedness, lhs.handedness))
    return false;
  if (std::less<>{}(lhs.input_from_pointer, rhs.input_from_pointer))
    return true;
  if (std::less<>{}(rhs.input_from_pointer, lhs.input_from_pointer))
    return false;
  if (std::less<>{}(lhs.profiles, rhs.profiles))
    return true;
  if (std::less<>{}(rhs.profiles, lhs.profiles))
    return false;
  return false;
}
template <typename StructPtrType>
XRInputSourceStatePtr XRInputSourceState::Clone() const {
  return New(
      mojo::Clone(source_id),
      mojo::Clone(description),
      mojo::Clone(mojo_from_input),
      mojo::Clone(emulated_position),
      mojo::Clone(is_auxiliary),
      mojo::Clone(primary_input_pressed),
      mojo::Clone(primary_input_clicked),
      mojo::Clone(primary_squeeze_pressed),
      mojo::Clone(primary_squeeze_clicked),
      mojo::Clone(gamepad),
      mojo::Clone(overlay_pointer_position)
  );
}

template <typename T, XRInputSourceState::EnableIfSame<T>*>
bool XRInputSourceState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->source_id, other_struct.source_id))
    return false;
  if (!mojo::Equals(this->description, other_struct.description))
    return false;
  if (!mojo::Equals(this->mojo_from_input, other_struct.mojo_from_input))
    return false;
  if (!mojo::Equals(this->emulated_position, other_struct.emulated_position))
    return false;
  if (!mojo::Equals(this->is_auxiliary, other_struct.is_auxiliary))
    return false;
  if (!mojo::Equals(this->primary_input_pressed, other_struct.primary_input_pressed))
    return false;
  if (!mojo::Equals(this->primary_input_clicked, other_struct.primary_input_clicked))
    return false;
  if (!mojo::Equals(this->primary_squeeze_pressed, other_struct.primary_squeeze_pressed))
    return false;
  if (!mojo::Equals(this->primary_squeeze_clicked, other_struct.primary_squeeze_clicked))
    return false;
  if (!mojo::Equals(this->gamepad, other_struct.gamepad))
    return false;
  if (!mojo::Equals(this->overlay_pointer_position, other_struct.overlay_pointer_position))
    return false;
  return true;
}

template <typename T, XRInputSourceState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.source_id, rhs.source_id))
    return true;
  if (std::less<>{}(rhs.source_id, lhs.source_id))
    return false;
  if (std::less<>{}(lhs.description, rhs.description))
    return true;
  if (std::less<>{}(rhs.description, lhs.description))
    return false;
  if (std::less<>{}(lhs.mojo_from_input, rhs.mojo_from_input))
    return true;
  if (std::less<>{}(rhs.mojo_from_input, lhs.mojo_from_input))
    return false;
  if (std::less<>{}(lhs.emulated_position, rhs.emulated_position))
    return true;
  if (std::less<>{}(rhs.emulated_position, lhs.emulated_position))
    return false;
  if (std::less<>{}(lhs.is_auxiliary, rhs.is_auxiliary))
    return true;
  if (std::less<>{}(rhs.is_auxiliary, lhs.is_auxiliary))
    return false;
  if (std::less<>{}(lhs.primary_input_pressed, rhs.primary_input_pressed))
    return true;
  if (std::less<>{}(rhs.primary_input_pressed, lhs.primary_input_pressed))
    return false;
  if (std::less<>{}(lhs.primary_input_clicked, rhs.primary_input_clicked))
    return true;
  if (std::less<>{}(rhs.primary_input_clicked, lhs.primary_input_clicked))
    return false;
  if (std::less<>{}(lhs.primary_squeeze_pressed, rhs.primary_squeeze_pressed))
    return true;
  if (std::less<>{}(rhs.primary_squeeze_pressed, lhs.primary_squeeze_pressed))
    return false;
  if (std::less<>{}(lhs.primary_squeeze_clicked, rhs.primary_squeeze_clicked))
    return true;
  if (std::less<>{}(rhs.primary_squeeze_clicked, lhs.primary_squeeze_clicked))
    return false;
  if (std::less<>{}(lhs.gamepad, rhs.gamepad))
    return true;
  if (std::less<>{}(rhs.gamepad, lhs.gamepad))
    return false;
  if (std::less<>{}(lhs.overlay_pointer_position, rhs.overlay_pointer_position))
    return true;
  if (std::less<>{}(rhs.overlay_pointer_position, lhs.overlay_pointer_position))
    return false;
  return false;
}
template <typename StructPtrType>
VRFieldOfViewPtr VRFieldOfView::Clone() const {
  return New(
      mojo::Clone(up_degrees),
      mojo::Clone(down_degrees),
      mojo::Clone(left_degrees),
      mojo::Clone(right_degrees)
  );
}

template <typename T, VRFieldOfView::EnableIfSame<T>*>
bool VRFieldOfView::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->up_degrees, other_struct.up_degrees))
    return false;
  if (!mojo::Equals(this->down_degrees, other_struct.down_degrees))
    return false;
  if (!mojo::Equals(this->left_degrees, other_struct.left_degrees))
    return false;
  if (!mojo::Equals(this->right_degrees, other_struct.right_degrees))
    return false;
  return true;
}

template <typename T, VRFieldOfView::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.up_degrees, rhs.up_degrees))
    return true;
  if (std::less<>{}(rhs.up_degrees, lhs.up_degrees))
    return false;
  if (std::less<>{}(lhs.down_degrees, rhs.down_degrees))
    return true;
  if (std::less<>{}(rhs.down_degrees, lhs.down_degrees))
    return false;
  if (std::less<>{}(lhs.left_degrees, rhs.left_degrees))
    return true;
  if (std::less<>{}(rhs.left_degrees, lhs.left_degrees))
    return false;
  if (std::less<>{}(lhs.right_degrees, rhs.right_degrees))
    return true;
  if (std::less<>{}(rhs.right_degrees, lhs.right_degrees))
    return false;
  return false;
}
template <typename StructPtrType>
VRPosePtr VRPose::Clone() const {
  return New(
      mojo::Clone(orientation),
      mojo::Clone(position),
      mojo::Clone(emulated_position)
  );
}

template <typename T, VRPose::EnableIfSame<T>*>
bool VRPose::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->orientation, other_struct.orientation))
    return false;
  if (!mojo::Equals(this->position, other_struct.position))
    return false;
  if (!mojo::Equals(this->emulated_position, other_struct.emulated_position))
    return false;
  return true;
}

template <typename T, VRPose::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.orientation, rhs.orientation))
    return true;
  if (std::less<>{}(rhs.orientation, lhs.orientation))
    return false;
  if (std::less<>{}(lhs.position, rhs.position))
    return true;
  if (std::less<>{}(rhs.position, lhs.position))
    return false;
  if (std::less<>{}(lhs.emulated_position, rhs.emulated_position))
    return true;
  if (std::less<>{}(rhs.emulated_position, lhs.emulated_position))
    return false;
  return false;
}
template <typename StructPtrType>
PosePtr Pose::Clone() const {
  return New(
      mojo::Clone(orientation),
      mojo::Clone(position)
  );
}

template <typename T, Pose::EnableIfSame<T>*>
bool Pose::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->orientation, other_struct.orientation))
    return false;
  if (!mojo::Equals(this->position, other_struct.position))
    return false;
  return true;
}

template <typename T, Pose::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.orientation, rhs.orientation))
    return true;
  if (std::less<>{}(rhs.orientation, lhs.orientation))
    return false;
  if (std::less<>{}(lhs.position, rhs.position))
    return true;
  if (std::less<>{}(rhs.position, lhs.position))
    return false;
  return false;
}
template <typename StructPtrType>
XRRayPtr XRRay::Clone() const {
  return New(
      mojo::Clone(origin),
      mojo::Clone(direction)
  );
}

template <typename T, XRRay::EnableIfSame<T>*>
bool XRRay::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->origin, other_struct.origin))
    return false;
  if (!mojo::Equals(this->direction, other_struct.direction))
    return false;
  return true;
}

template <typename T, XRRay::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.origin, rhs.origin))
    return true;
  if (std::less<>{}(rhs.origin, lhs.origin))
    return false;
  if (std::less<>{}(lhs.direction, rhs.direction))
    return true;
  if (std::less<>{}(rhs.direction, lhs.direction))
    return false;
  return false;
}
template <typename StructPtrType>
XRHitResultPtr XRHitResult::Clone() const {
  return New(
      mojo::Clone(mojo_from_result),
      mojo::Clone(plane_id)
  );
}

template <typename T, XRHitResult::EnableIfSame<T>*>
bool XRHitResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->mojo_from_result, other_struct.mojo_from_result))
    return false;
  if (!mojo::Equals(this->plane_id, other_struct.plane_id))
    return false;
  return true;
}

template <typename T, XRHitResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.mojo_from_result, rhs.mojo_from_result))
    return true;
  if (std::less<>{}(rhs.mojo_from_result, lhs.mojo_from_result))
    return false;
  if (std::less<>{}(lhs.plane_id, rhs.plane_id))
    return true;
  if (std::less<>{}(rhs.plane_id, lhs.plane_id))
    return false;
  return false;
}
template <typename StructPtrType>
VREyeParametersPtr VREyeParameters::Clone() const {
  return New(
      mojo::Clone(field_of_view),
      mojo::Clone(head_from_eye),
      mojo::Clone(render_width),
      mojo::Clone(render_height)
  );
}

template <typename T, VREyeParameters::EnableIfSame<T>*>
bool VREyeParameters::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->field_of_view, other_struct.field_of_view))
    return false;
  if (!mojo::Equals(this->head_from_eye, other_struct.head_from_eye))
    return false;
  if (!mojo::Equals(this->render_width, other_struct.render_width))
    return false;
  if (!mojo::Equals(this->render_height, other_struct.render_height))
    return false;
  return true;
}

template <typename T, VREyeParameters::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.field_of_view, rhs.field_of_view))
    return true;
  if (std::less<>{}(rhs.field_of_view, lhs.field_of_view))
    return false;
  if (std::less<>{}(lhs.head_from_eye, rhs.head_from_eye))
    return true;
  if (std::less<>{}(rhs.head_from_eye, lhs.head_from_eye))
    return false;
  if (std::less<>{}(lhs.render_width, rhs.render_width))
    return true;
  if (std::less<>{}(rhs.render_width, lhs.render_width))
    return false;
  if (std::less<>{}(lhs.render_height, rhs.render_height))
    return true;
  if (std::less<>{}(rhs.render_height, lhs.render_height))
    return false;
  return false;
}
template <typename StructPtrType>
VRStageParametersPtr VRStageParameters::Clone() const {
  return New(
      mojo::Clone(mojo_from_floor),
      mojo::Clone(bounds)
  );
}

template <typename T, VRStageParameters::EnableIfSame<T>*>
bool VRStageParameters::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->mojo_from_floor, other_struct.mojo_from_floor))
    return false;
  if (!mojo::Equals(this->bounds, other_struct.bounds))
    return false;
  return true;
}

template <typename T, VRStageParameters::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.mojo_from_floor, rhs.mojo_from_floor))
    return true;
  if (std::less<>{}(rhs.mojo_from_floor, lhs.mojo_from_floor))
    return false;
  if (std::less<>{}(lhs.bounds, rhs.bounds))
    return true;
  if (std::less<>{}(rhs.bounds, lhs.bounds))
    return false;
  return false;
}
template <typename StructPtrType>
VRDisplayInfoPtr VRDisplayInfo::Clone() const {
  return New(
      mojo::Clone(stage_parameters),
      mojo::Clone(left_eye),
      mojo::Clone(right_eye)
  );
}

template <typename T, VRDisplayInfo::EnableIfSame<T>*>
bool VRDisplayInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->stage_parameters, other_struct.stage_parameters))
    return false;
  if (!mojo::Equals(this->left_eye, other_struct.left_eye))
    return false;
  if (!mojo::Equals(this->right_eye, other_struct.right_eye))
    return false;
  return true;
}

template <typename T, VRDisplayInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.stage_parameters, rhs.stage_parameters))
    return true;
  if (std::less<>{}(rhs.stage_parameters, lhs.stage_parameters))
    return false;
  if (std::less<>{}(lhs.left_eye, rhs.left_eye))
    return true;
  if (std::less<>{}(rhs.left_eye, lhs.left_eye))
    return false;
  if (std::less<>{}(lhs.right_eye, rhs.right_eye))
    return true;
  if (std::less<>{}(rhs.right_eye, lhs.right_eye))
    return false;
  return false;
}
template <typename StructPtrType>
XRPresentationTransportOptionsPtr XRPresentationTransportOptions::Clone() const {
  return New(
      mojo::Clone(transport_method),
      mojo::Clone(wait_for_transfer_notification),
      mojo::Clone(wait_for_render_notification),
      mojo::Clone(wait_for_gpu_fence)
  );
}

template <typename T, XRPresentationTransportOptions::EnableIfSame<T>*>
bool XRPresentationTransportOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->transport_method, other_struct.transport_method))
    return false;
  if (!mojo::Equals(this->wait_for_transfer_notification, other_struct.wait_for_transfer_notification))
    return false;
  if (!mojo::Equals(this->wait_for_render_notification, other_struct.wait_for_render_notification))
    return false;
  if (!mojo::Equals(this->wait_for_gpu_fence, other_struct.wait_for_gpu_fence))
    return false;
  return true;
}

template <typename T, XRPresentationTransportOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.transport_method, rhs.transport_method))
    return true;
  if (std::less<>{}(rhs.transport_method, lhs.transport_method))
    return false;
  if (std::less<>{}(lhs.wait_for_transfer_notification, rhs.wait_for_transfer_notification))
    return true;
  if (std::less<>{}(rhs.wait_for_transfer_notification, lhs.wait_for_transfer_notification))
    return false;
  if (std::less<>{}(lhs.wait_for_render_notification, rhs.wait_for_render_notification))
    return true;
  if (std::less<>{}(rhs.wait_for_render_notification, lhs.wait_for_render_notification))
    return false;
  if (std::less<>{}(lhs.wait_for_gpu_fence, rhs.wait_for_gpu_fence))
    return true;
  if (std::less<>{}(rhs.wait_for_gpu_fence, lhs.wait_for_gpu_fence))
    return false;
  return false;
}
template <typename StructPtrType>
XRPlanePointDataPtr XRPlanePointData::Clone() const {
  return New(
      mojo::Clone(x),
      mojo::Clone(z)
  );
}

template <typename T, XRPlanePointData::EnableIfSame<T>*>
bool XRPlanePointData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->x, other_struct.x))
    return false;
  if (!mojo::Equals(this->z, other_struct.z))
    return false;
  return true;
}

template <typename T, XRPlanePointData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.x, rhs.x))
    return true;
  if (std::less<>{}(rhs.x, lhs.x))
    return false;
  if (std::less<>{}(lhs.z, rhs.z))
    return true;
  if (std::less<>{}(rhs.z, lhs.z))
    return false;
  return false;
}
template <typename StructPtrType>
XRPlaneDataPtr XRPlaneData::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(orientation),
      mojo::Clone(mojo_from_plane),
      mojo::Clone(polygon)
  );
}

template <typename T, XRPlaneData::EnableIfSame<T>*>
bool XRPlaneData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->orientation, other_struct.orientation))
    return false;
  if (!mojo::Equals(this->mojo_from_plane, other_struct.mojo_from_plane))
    return false;
  if (!mojo::Equals(this->polygon, other_struct.polygon))
    return false;
  return true;
}

template <typename T, XRPlaneData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.id, rhs.id))
    return true;
  if (std::less<>{}(rhs.id, lhs.id))
    return false;
  if (std::less<>{}(lhs.orientation, rhs.orientation))
    return true;
  if (std::less<>{}(rhs.orientation, lhs.orientation))
    return false;
  if (std::less<>{}(lhs.mojo_from_plane, rhs.mojo_from_plane))
    return true;
  if (std::less<>{}(rhs.mojo_from_plane, lhs.mojo_from_plane))
    return false;
  if (std::less<>{}(lhs.polygon, rhs.polygon))
    return true;
  if (std::less<>{}(rhs.polygon, lhs.polygon))
    return false;
  return false;
}
template <typename StructPtrType>
XRPlaneDetectionDataPtr XRPlaneDetectionData::Clone() const {
  return New(
      mojo::Clone(all_planes_ids),
      mojo::Clone(updated_planes_data)
  );
}

template <typename T, XRPlaneDetectionData::EnableIfSame<T>*>
bool XRPlaneDetectionData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->all_planes_ids, other_struct.all_planes_ids))
    return false;
  if (!mojo::Equals(this->updated_planes_data, other_struct.updated_planes_data))
    return false;
  return true;
}

template <typename T, XRPlaneDetectionData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.all_planes_ids, rhs.all_planes_ids))
    return true;
  if (std::less<>{}(rhs.all_planes_ids, lhs.all_planes_ids))
    return false;
  if (std::less<>{}(lhs.updated_planes_data, rhs.updated_planes_data))
    return true;
  if (std::less<>{}(rhs.updated_planes_data, lhs.updated_planes_data))
    return false;
  return false;
}
template <typename StructPtrType>
XRAnchorDataPtr XRAnchorData::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(mojo_from_anchor)
  );
}

template <typename T, XRAnchorData::EnableIfSame<T>*>
bool XRAnchorData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->mojo_from_anchor, other_struct.mojo_from_anchor))
    return false;
  return true;
}

template <typename T, XRAnchorData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.id, rhs.id))
    return true;
  if (std::less<>{}(rhs.id, lhs.id))
    return false;
  if (std::less<>{}(lhs.mojo_from_anchor, rhs.mojo_from_anchor))
    return true;
  if (std::less<>{}(rhs.mojo_from_anchor, lhs.mojo_from_anchor))
    return false;
  return false;
}
template <typename StructPtrType>
XRAnchorsDataPtr XRAnchorsData::Clone() const {
  return New(
      mojo::Clone(all_anchors_ids),
      mojo::Clone(updated_anchors_data)
  );
}

template <typename T, XRAnchorsData::EnableIfSame<T>*>
bool XRAnchorsData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->all_anchors_ids, other_struct.all_anchors_ids))
    return false;
  if (!mojo::Equals(this->updated_anchors_data, other_struct.updated_anchors_data))
    return false;
  return true;
}

template <typename T, XRAnchorsData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.all_anchors_ids, rhs.all_anchors_ids))
    return true;
  if (std::less<>{}(rhs.all_anchors_ids, lhs.all_anchors_ids))
    return false;
  if (std::less<>{}(lhs.updated_anchors_data, rhs.updated_anchors_data))
    return true;
  if (std::less<>{}(rhs.updated_anchors_data, lhs.updated_anchors_data))
    return false;
  return false;
}
template <typename StructPtrType>
XRHitTestSubscriptionResultDataPtr XRHitTestSubscriptionResultData::Clone() const {
  return New(
      mojo::Clone(subscription_id),
      mojo::Clone(hit_test_results)
  );
}

template <typename T, XRHitTestSubscriptionResultData::EnableIfSame<T>*>
bool XRHitTestSubscriptionResultData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->subscription_id, other_struct.subscription_id))
    return false;
  if (!mojo::Equals(this->hit_test_results, other_struct.hit_test_results))
    return false;
  return true;
}

template <typename T, XRHitTestSubscriptionResultData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.subscription_id, rhs.subscription_id))
    return true;
  if (std::less<>{}(rhs.subscription_id, lhs.subscription_id))
    return false;
  if (std::less<>{}(lhs.hit_test_results, rhs.hit_test_results))
    return true;
  if (std::less<>{}(rhs.hit_test_results, lhs.hit_test_results))
    return false;
  return false;
}
template <typename StructPtrType>
XRHitTestTransientInputSubscriptionResultDataPtr XRHitTestTransientInputSubscriptionResultData::Clone() const {
  return New(
      mojo::Clone(subscription_id),
      mojo::Clone(input_source_id_to_hit_test_results)
  );
}

template <typename T, XRHitTestTransientInputSubscriptionResultData::EnableIfSame<T>*>
bool XRHitTestTransientInputSubscriptionResultData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->subscription_id, other_struct.subscription_id))
    return false;
  if (!mojo::Equals(this->input_source_id_to_hit_test_results, other_struct.input_source_id_to_hit_test_results))
    return false;
  return true;
}

template <typename T, XRHitTestTransientInputSubscriptionResultData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.subscription_id, rhs.subscription_id))
    return true;
  if (std::less<>{}(rhs.subscription_id, lhs.subscription_id))
    return false;
  if (std::less<>{}(lhs.input_source_id_to_hit_test_results, rhs.input_source_id_to_hit_test_results))
    return true;
  if (std::less<>{}(rhs.input_source_id_to_hit_test_results, lhs.input_source_id_to_hit_test_results))
    return false;
  return false;
}
template <typename StructPtrType>
XRHitTestSubscriptionResultsDataPtr XRHitTestSubscriptionResultsData::Clone() const {
  return New(
      mojo::Clone(results),
      mojo::Clone(transient_input_results)
  );
}

template <typename T, XRHitTestSubscriptionResultsData::EnableIfSame<T>*>
bool XRHitTestSubscriptionResultsData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->results, other_struct.results))
    return false;
  if (!mojo::Equals(this->transient_input_results, other_struct.transient_input_results))
    return false;
  return true;
}

template <typename T, XRHitTestSubscriptionResultsData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.results, rhs.results))
    return true;
  if (std::less<>{}(rhs.results, lhs.results))
    return false;
  if (std::less<>{}(lhs.transient_input_results, rhs.transient_input_results))
    return true;
  if (std::less<>{}(rhs.transient_input_results, lhs.transient_input_results))
    return false;
  return false;
}
template <typename StructPtrType>
RgbTupleF32Ptr RgbTupleF32::Clone() const {
  return New(
      mojo::Clone(red),
      mojo::Clone(green),
      mojo::Clone(blue)
  );
}

template <typename T, RgbTupleF32::EnableIfSame<T>*>
bool RgbTupleF32::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->red, other_struct.red))
    return false;
  if (!mojo::Equals(this->green, other_struct.green))
    return false;
  if (!mojo::Equals(this->blue, other_struct.blue))
    return false;
  return true;
}

template <typename T, RgbTupleF32::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.red, rhs.red))
    return true;
  if (std::less<>{}(rhs.red, lhs.red))
    return false;
  if (std::less<>{}(lhs.green, rhs.green))
    return true;
  if (std::less<>{}(rhs.green, lhs.green))
    return false;
  if (std::less<>{}(lhs.blue, rhs.blue))
    return true;
  if (std::less<>{}(rhs.blue, lhs.blue))
    return false;
  return false;
}
template <typename StructPtrType>
XRSphericalHarmonicsPtr XRSphericalHarmonics::Clone() const {
  return New(
      mojo::Clone(coefficients)
  );
}

template <typename T, XRSphericalHarmonics::EnableIfSame<T>*>
bool XRSphericalHarmonics::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->coefficients, other_struct.coefficients))
    return false;
  return true;
}

template <typename T, XRSphericalHarmonics::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.coefficients, rhs.coefficients))
    return true;
  if (std::less<>{}(rhs.coefficients, lhs.coefficients))
    return false;
  return false;
}
template <typename StructPtrType>
RgbaTupleF16Ptr RgbaTupleF16::Clone() const {
  return New(
      mojo::Clone(red),
      mojo::Clone(green),
      mojo::Clone(blue),
      mojo::Clone(alpha)
  );
}

template <typename T, RgbaTupleF16::EnableIfSame<T>*>
bool RgbaTupleF16::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->red, other_struct.red))
    return false;
  if (!mojo::Equals(this->green, other_struct.green))
    return false;
  if (!mojo::Equals(this->blue, other_struct.blue))
    return false;
  if (!mojo::Equals(this->alpha, other_struct.alpha))
    return false;
  return true;
}

template <typename T, RgbaTupleF16::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.red, rhs.red))
    return true;
  if (std::less<>{}(rhs.red, lhs.red))
    return false;
  if (std::less<>{}(lhs.green, rhs.green))
    return true;
  if (std::less<>{}(rhs.green, lhs.green))
    return false;
  if (std::less<>{}(lhs.blue, rhs.blue))
    return true;
  if (std::less<>{}(rhs.blue, lhs.blue))
    return false;
  if (std::less<>{}(lhs.alpha, rhs.alpha))
    return true;
  if (std::less<>{}(rhs.alpha, lhs.alpha))
    return false;
  return false;
}
template <typename StructPtrType>
XRCubeMapPtr XRCubeMap::Clone() const {
  return New(
      mojo::Clone(width_and_height),
      mojo::Clone(positive_x),
      mojo::Clone(negative_x),
      mojo::Clone(positive_y),
      mojo::Clone(negative_y),
      mojo::Clone(positive_z),
      mojo::Clone(negative_z)
  );
}

template <typename T, XRCubeMap::EnableIfSame<T>*>
bool XRCubeMap::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->width_and_height, other_struct.width_and_height))
    return false;
  if (!mojo::Equals(this->positive_x, other_struct.positive_x))
    return false;
  if (!mojo::Equals(this->negative_x, other_struct.negative_x))
    return false;
  if (!mojo::Equals(this->positive_y, other_struct.positive_y))
    return false;
  if (!mojo::Equals(this->negative_y, other_struct.negative_y))
    return false;
  if (!mojo::Equals(this->positive_z, other_struct.positive_z))
    return false;
  if (!mojo::Equals(this->negative_z, other_struct.negative_z))
    return false;
  return true;
}

template <typename T, XRCubeMap::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.width_and_height, rhs.width_and_height))
    return true;
  if (std::less<>{}(rhs.width_and_height, lhs.width_and_height))
    return false;
  if (std::less<>{}(lhs.positive_x, rhs.positive_x))
    return true;
  if (std::less<>{}(rhs.positive_x, lhs.positive_x))
    return false;
  if (std::less<>{}(lhs.negative_x, rhs.negative_x))
    return true;
  if (std::less<>{}(rhs.negative_x, lhs.negative_x))
    return false;
  if (std::less<>{}(lhs.positive_y, rhs.positive_y))
    return true;
  if (std::less<>{}(rhs.positive_y, lhs.positive_y))
    return false;
  if (std::less<>{}(lhs.negative_y, rhs.negative_y))
    return true;
  if (std::less<>{}(rhs.negative_y, lhs.negative_y))
    return false;
  if (std::less<>{}(lhs.positive_z, rhs.positive_z))
    return true;
  if (std::less<>{}(rhs.positive_z, lhs.positive_z))
    return false;
  if (std::less<>{}(lhs.negative_z, rhs.negative_z))
    return true;
  if (std::less<>{}(rhs.negative_z, lhs.negative_z))
    return false;
  return false;
}
template <typename StructPtrType>
XRLightProbePtr XRLightProbe::Clone() const {
  return New(
      mojo::Clone(spherical_harmonics),
      mojo::Clone(main_light_direction),
      mojo::Clone(main_light_intensity)
  );
}

template <typename T, XRLightProbe::EnableIfSame<T>*>
bool XRLightProbe::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->spherical_harmonics, other_struct.spherical_harmonics))
    return false;
  if (!mojo::Equals(this->main_light_direction, other_struct.main_light_direction))
    return false;
  if (!mojo::Equals(this->main_light_intensity, other_struct.main_light_intensity))
    return false;
  return true;
}

template <typename T, XRLightProbe::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.spherical_harmonics, rhs.spherical_harmonics))
    return true;
  if (std::less<>{}(rhs.spherical_harmonics, lhs.spherical_harmonics))
    return false;
  if (std::less<>{}(lhs.main_light_direction, rhs.main_light_direction))
    return true;
  if (std::less<>{}(rhs.main_light_direction, lhs.main_light_direction))
    return false;
  if (std::less<>{}(lhs.main_light_intensity, rhs.main_light_intensity))
    return true;
  if (std::less<>{}(rhs.main_light_intensity, lhs.main_light_intensity))
    return false;
  return false;
}
template <typename StructPtrType>
XRReflectionProbePtr XRReflectionProbe::Clone() const {
  return New(
      mojo::Clone(cube_map)
  );
}

template <typename T, XRReflectionProbe::EnableIfSame<T>*>
bool XRReflectionProbe::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->cube_map, other_struct.cube_map))
    return false;
  return true;
}

template <typename T, XRReflectionProbe::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.cube_map, rhs.cube_map))
    return true;
  if (std::less<>{}(rhs.cube_map, lhs.cube_map))
    return false;
  return false;
}
template <typename StructPtrType>
XRLightEstimationDataPtr XRLightEstimationData::Clone() const {
  return New(
      mojo::Clone(light_probe),
      mojo::Clone(reflection_probe)
  );
}

template <typename T, XRLightEstimationData::EnableIfSame<T>*>
bool XRLightEstimationData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->light_probe, other_struct.light_probe))
    return false;
  if (!mojo::Equals(this->reflection_probe, other_struct.reflection_probe))
    return false;
  return true;
}

template <typename T, XRLightEstimationData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.light_probe, rhs.light_probe))
    return true;
  if (std::less<>{}(rhs.light_probe, lhs.light_probe))
    return false;
  if (std::less<>{}(lhs.reflection_probe, rhs.reflection_probe))
    return true;
  if (std::less<>{}(rhs.reflection_probe, lhs.reflection_probe))
    return false;
  return false;
}
template <typename StructPtrType>
XRDepthDataStillValidPtr XRDepthDataStillValid::Clone() const {
  return New(
  );
}

template <typename T, XRDepthDataStillValid::EnableIfSame<T>*>
bool XRDepthDataStillValid::Equals(const T& other_struct) const {
  return true;
}

template <typename T, XRDepthDataStillValid::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  return false;
}
template <typename StructPtrType>
XRDepthDataUpdatedPtr XRDepthDataUpdated::Clone() const {
  return New(
      mojo::Clone(time_delta),
      mojo::Clone(pixel_data),
      mojo::Clone(norm_texture_from_norm_view),
      mojo::Clone(size)
  );
}

template <typename T, XRDepthDataUpdated::EnableIfSame<T>*>
bool XRDepthDataUpdated::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->time_delta, other_struct.time_delta))
    return false;
  if (!mojo::Equals(this->pixel_data, other_struct.pixel_data))
    return false;
  if (!mojo::Equals(this->norm_texture_from_norm_view, other_struct.norm_texture_from_norm_view))
    return false;
  if (!mojo::Equals(this->size, other_struct.size))
    return false;
  return true;
}

template <typename T, XRDepthDataUpdated::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.time_delta, rhs.time_delta))
    return true;
  if (std::less<>{}(rhs.time_delta, lhs.time_delta))
    return false;
  if (std::less<>{}(lhs.pixel_data, rhs.pixel_data))
    return true;
  if (std::less<>{}(rhs.pixel_data, lhs.pixel_data))
    return false;
  if (std::less<>{}(lhs.norm_texture_from_norm_view, rhs.norm_texture_from_norm_view))
    return true;
  if (std::less<>{}(rhs.norm_texture_from_norm_view, lhs.norm_texture_from_norm_view))
    return false;
  if (std::less<>{}(lhs.size, rhs.size))
    return true;
  if (std::less<>{}(rhs.size, lhs.size))
    return false;
  return false;
}
template <typename StructPtrType>
XRFrameDataPtr XRFrameData::Clone() const {
  return New(
      mojo::Clone(pose),
      mojo::Clone(time_delta),
      mojo::Clone(buffer_holder),
      mojo::Clone(camera_image_buffer_holder),
      mojo::Clone(depth_data),
      mojo::Clone(mojo_space_reset),
      mojo::Clone(frame_id),
      mojo::Clone(left_eye),
      mojo::Clone(right_eye),
      mojo::Clone(input_state),
      mojo::Clone(stage_parameters_updated),
      mojo::Clone(stage_parameters),
      mojo::Clone(detected_planes_data),
      mojo::Clone(anchors_data),
      mojo::Clone(light_estimation_data),
      mojo::Clone(hit_test_subscription_results)
  );
}

template <typename T, XRFrameData::EnableIfSame<T>*>
bool XRFrameData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->pose, other_struct.pose))
    return false;
  if (!mojo::Equals(this->time_delta, other_struct.time_delta))
    return false;
  if (!mojo::Equals(this->buffer_holder, other_struct.buffer_holder))
    return false;
  if (!mojo::Equals(this->camera_image_buffer_holder, other_struct.camera_image_buffer_holder))
    return false;
  if (!mojo::Equals(this->depth_data, other_struct.depth_data))
    return false;
  if (!mojo::Equals(this->mojo_space_reset, other_struct.mojo_space_reset))
    return false;
  if (!mojo::Equals(this->frame_id, other_struct.frame_id))
    return false;
  if (!mojo::Equals(this->left_eye, other_struct.left_eye))
    return false;
  if (!mojo::Equals(this->right_eye, other_struct.right_eye))
    return false;
  if (!mojo::Equals(this->input_state, other_struct.input_state))
    return false;
  if (!mojo::Equals(this->stage_parameters_updated, other_struct.stage_parameters_updated))
    return false;
  if (!mojo::Equals(this->stage_parameters, other_struct.stage_parameters))
    return false;
  if (!mojo::Equals(this->detected_planes_data, other_struct.detected_planes_data))
    return false;
  if (!mojo::Equals(this->anchors_data, other_struct.anchors_data))
    return false;
  if (!mojo::Equals(this->light_estimation_data, other_struct.light_estimation_data))
    return false;
  if (!mojo::Equals(this->hit_test_subscription_results, other_struct.hit_test_subscription_results))
    return false;
  return true;
}

template <typename T, XRFrameData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.pose, rhs.pose))
    return true;
  if (std::less<>{}(rhs.pose, lhs.pose))
    return false;
  if (std::less<>{}(lhs.time_delta, rhs.time_delta))
    return true;
  if (std::less<>{}(rhs.time_delta, lhs.time_delta))
    return false;
  if (std::less<>{}(lhs.buffer_holder, rhs.buffer_holder))
    return true;
  if (std::less<>{}(rhs.buffer_holder, lhs.buffer_holder))
    return false;
  if (std::less<>{}(lhs.camera_image_buffer_holder, rhs.camera_image_buffer_holder))
    return true;
  if (std::less<>{}(rhs.camera_image_buffer_holder, lhs.camera_image_buffer_holder))
    return false;
  if (std::less<>{}(lhs.depth_data, rhs.depth_data))
    return true;
  if (std::less<>{}(rhs.depth_data, lhs.depth_data))
    return false;
  if (std::less<>{}(lhs.mojo_space_reset, rhs.mojo_space_reset))
    return true;
  if (std::less<>{}(rhs.mojo_space_reset, lhs.mojo_space_reset))
    return false;
  if (std::less<>{}(lhs.frame_id, rhs.frame_id))
    return true;
  if (std::less<>{}(rhs.frame_id, lhs.frame_id))
    return false;
  if (std::less<>{}(lhs.left_eye, rhs.left_eye))
    return true;
  if (std::less<>{}(rhs.left_eye, lhs.left_eye))
    return false;
  if (std::less<>{}(lhs.right_eye, rhs.right_eye))
    return true;
  if (std::less<>{}(rhs.right_eye, lhs.right_eye))
    return false;
  if (std::less<>{}(lhs.input_state, rhs.input_state))
    return true;
  if (std::less<>{}(rhs.input_state, lhs.input_state))
    return false;
  if (std::less<>{}(lhs.stage_parameters_updated, rhs.stage_parameters_updated))
    return true;
  if (std::less<>{}(rhs.stage_parameters_updated, lhs.stage_parameters_updated))
    return false;
  if (std::less<>{}(lhs.stage_parameters, rhs.stage_parameters))
    return true;
  if (std::less<>{}(rhs.stage_parameters, lhs.stage_parameters))
    return false;
  if (std::less<>{}(lhs.detected_planes_data, rhs.detected_planes_data))
    return true;
  if (std::less<>{}(rhs.detected_planes_data, lhs.detected_planes_data))
    return false;
  if (std::less<>{}(lhs.anchors_data, rhs.anchors_data))
    return true;
  if (std::less<>{}(rhs.anchors_data, lhs.anchors_data))
    return false;
  if (std::less<>{}(lhs.light_estimation_data, rhs.light_estimation_data))
    return true;
  if (std::less<>{}(rhs.light_estimation_data, lhs.light_estimation_data))
    return false;
  if (std::less<>{}(lhs.hit_test_subscription_results, rhs.hit_test_subscription_results))
    return true;
  if (std::less<>{}(rhs.hit_test_subscription_results, lhs.hit_test_subscription_results))
    return false;
  return false;
}
template <typename StructPtrType>
RequestSessionSuccessPtr RequestSessionSuccess::Clone() const {
  return New(
      mojo::Clone(session),
      mojo::Clone(metrics_recorder)
  );
}

template <typename T, RequestSessionSuccess::EnableIfSame<T>*>
bool RequestSessionSuccess::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->session, other_struct.session))
    return false;
  if (!mojo::Equals(this->metrics_recorder, other_struct.metrics_recorder))
    return false;
  return true;
}

template <typename T, RequestSessionSuccess::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.session, rhs.session))
    return true;
  if (std::less<>{}(rhs.session, lhs.session))
    return false;
  if (std::less<>{}(lhs.metrics_recorder, rhs.metrics_recorder))
    return true;
  if (std::less<>{}(rhs.metrics_recorder, lhs.metrics_recorder))
    return false;
  return false;
}
template <typename StructPtrType>
XRFrameDataRequestOptionsPtr XRFrameDataRequestOptions::Clone() const {
  return New(
      mojo::Clone(include_lighting_estimation_data)
  );
}

template <typename T, XRFrameDataRequestOptions::EnableIfSame<T>*>
bool XRFrameDataRequestOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->include_lighting_estimation_data, other_struct.include_lighting_estimation_data))
    return false;
  return true;
}

template <typename T, XRFrameDataRequestOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.include_lighting_estimation_data, rhs.include_lighting_estimation_data))
    return true;
  if (std::less<>{}(rhs.include_lighting_estimation_data, lhs.include_lighting_estimation_data))
    return false;
  return false;
}


}  // namespace blink
}  // namespace mojom
}  // namespace device

namespace mojo {


template <>
struct COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRSessionOptions::DataView,
                                         ::device::mojom::blink::XRSessionOptionsPtr> {
  static bool IsNull(const ::device::mojom::blink::XRSessionOptionsPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRSessionOptionsPtr* output) { output->reset(); }

  static decltype(::device::mojom::blink::XRSessionOptions::mode) mode(
      const ::device::mojom::blink::XRSessionOptionsPtr& input) {
    return input->mode;
  }

  static const decltype(::device::mojom::blink::XRSessionOptions::required_features)& required_features(
      const ::device::mojom::blink::XRSessionOptionsPtr& input) {
    return input->required_features;
  }

  static const decltype(::device::mojom::blink::XRSessionOptions::optional_features)& optional_features(
      const ::device::mojom::blink::XRSessionOptionsPtr& input) {
    return input->optional_features;
  }

  static bool Read(::device::mojom::blink::XRSessionOptions::DataView input, ::device::mojom::blink::XRSessionOptionsPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRSession::DataView,
                                         ::device::mojom::blink::XRSessionPtr> {
  static bool IsNull(const ::device::mojom::blink::XRSessionPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRSessionPtr* output) { output->reset(); }

  static  decltype(::device::mojom::blink::XRSession::data_provider)& data_provider(
       ::device::mojom::blink::XRSessionPtr& input) {
    return input->data_provider;
  }

  static  decltype(::device::mojom::blink::XRSession::client_receiver)& client_receiver(
       ::device::mojom::blink::XRSessionPtr& input) {
    return input->client_receiver;
  }

  static const decltype(::device::mojom::blink::XRSession::display_info)& display_info(
      const ::device::mojom::blink::XRSessionPtr& input) {
    return input->display_info;
  }

  static  decltype(::device::mojom::blink::XRSession::submit_frame_sink)& submit_frame_sink(
       ::device::mojom::blink::XRSessionPtr& input) {
    return input->submit_frame_sink;
  }

  static const decltype(::device::mojom::blink::XRSession::enabled_features)& enabled_features(
      const ::device::mojom::blink::XRSessionPtr& input) {
    return input->enabled_features;
  }

  static decltype(::device::mojom::blink::XRSession::uses_input_eventing) uses_input_eventing(
      const ::device::mojom::blink::XRSessionPtr& input) {
    return input->uses_input_eventing;
  }

  static decltype(::device::mojom::blink::XRSession::default_framebuffer_scale) default_framebuffer_scale(
      const ::device::mojom::blink::XRSessionPtr& input) {
    return input->default_framebuffer_scale;
  }

  static bool Read(::device::mojom::blink::XRSession::DataView input, ::device::mojom::blink::XRSessionPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRPresentationConnection::DataView,
                                         ::device::mojom::blink::XRPresentationConnectionPtr> {
  static bool IsNull(const ::device::mojom::blink::XRPresentationConnectionPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRPresentationConnectionPtr* output) { output->reset(); }

  static  decltype(::device::mojom::blink::XRPresentationConnection::provider)& provider(
       ::device::mojom::blink::XRPresentationConnectionPtr& input) {
    return input->provider;
  }

  static  decltype(::device::mojom::blink::XRPresentationConnection::client_receiver)& client_receiver(
       ::device::mojom::blink::XRPresentationConnectionPtr& input) {
    return input->client_receiver;
  }

  static const decltype(::device::mojom::blink::XRPresentationConnection::transport_options)& transport_options(
      const ::device::mojom::blink::XRPresentationConnectionPtr& input) {
    return input->transport_options;
  }

  static bool Read(::device::mojom::blink::XRPresentationConnection::DataView input, ::device::mojom::blink::XRPresentationConnectionPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRInputSourceDescription::DataView,
                                         ::device::mojom::blink::XRInputSourceDescriptionPtr> {
  static bool IsNull(const ::device::mojom::blink::XRInputSourceDescriptionPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRInputSourceDescriptionPtr* output) { output->reset(); }

  static decltype(::device::mojom::blink::XRInputSourceDescription::target_ray_mode) target_ray_mode(
      const ::device::mojom::blink::XRInputSourceDescriptionPtr& input) {
    return input->target_ray_mode;
  }

  static decltype(::device::mojom::blink::XRInputSourceDescription::handedness) handedness(
      const ::device::mojom::blink::XRInputSourceDescriptionPtr& input) {
    return input->handedness;
  }

  static const decltype(::device::mojom::blink::XRInputSourceDescription::input_from_pointer)& input_from_pointer(
      const ::device::mojom::blink::XRInputSourceDescriptionPtr& input) {
    return input->input_from_pointer;
  }

  static const decltype(::device::mojom::blink::XRInputSourceDescription::profiles)& profiles(
      const ::device::mojom::blink::XRInputSourceDescriptionPtr& input) {
    return input->profiles;
  }

  static bool Read(::device::mojom::blink::XRInputSourceDescription::DataView input, ::device::mojom::blink::XRInputSourceDescriptionPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRInputSourceState::DataView,
                                         ::device::mojom::blink::XRInputSourceStatePtr> {
  static bool IsNull(const ::device::mojom::blink::XRInputSourceStatePtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRInputSourceStatePtr* output) { output->reset(); }

  static decltype(::device::mojom::blink::XRInputSourceState::source_id) source_id(
      const ::device::mojom::blink::XRInputSourceStatePtr& input) {
    return input->source_id;
  }

  static const decltype(::device::mojom::blink::XRInputSourceState::description)& description(
      const ::device::mojom::blink::XRInputSourceStatePtr& input) {
    return input->description;
  }

  static const decltype(::device::mojom::blink::XRInputSourceState::mojo_from_input)& mojo_from_input(
      const ::device::mojom::blink::XRInputSourceStatePtr& input) {
    return input->mojo_from_input;
  }

  static decltype(::device::mojom::blink::XRInputSourceState::emulated_position) emulated_position(
      const ::device::mojom::blink::XRInputSourceStatePtr& input) {
    return input->emulated_position;
  }

  static decltype(::device::mojom::blink::XRInputSourceState::is_auxiliary) is_auxiliary(
      const ::device::mojom::blink::XRInputSourceStatePtr& input) {
    return input->is_auxiliary;
  }

  static decltype(::device::mojom::blink::XRInputSourceState::primary_input_pressed) primary_input_pressed(
      const ::device::mojom::blink::XRInputSourceStatePtr& input) {
    return input->primary_input_pressed;
  }

  static decltype(::device::mojom::blink::XRInputSourceState::primary_input_clicked) primary_input_clicked(
      const ::device::mojom::blink::XRInputSourceStatePtr& input) {
    return input->primary_input_clicked;
  }

  static decltype(::device::mojom::blink::XRInputSourceState::primary_squeeze_pressed) primary_squeeze_pressed(
      const ::device::mojom::blink::XRInputSourceStatePtr& input) {
    return input->primary_squeeze_pressed;
  }

  static decltype(::device::mojom::blink::XRInputSourceState::primary_squeeze_clicked) primary_squeeze_clicked(
      const ::device::mojom::blink::XRInputSourceStatePtr& input) {
    return input->primary_squeeze_clicked;
  }

  static const decltype(::device::mojom::blink::XRInputSourceState::gamepad)& gamepad(
      const ::device::mojom::blink::XRInputSourceStatePtr& input) {
    return input->gamepad;
  }

  static const decltype(::device::mojom::blink::XRInputSourceState::overlay_pointer_position)& overlay_pointer_position(
      const ::device::mojom::blink::XRInputSourceStatePtr& input) {
    return input->overlay_pointer_position;
  }

  static bool Read(::device::mojom::blink::XRInputSourceState::DataView input, ::device::mojom::blink::XRInputSourceStatePtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::VRFieldOfView::DataView,
                                         ::device::mojom::blink::VRFieldOfViewPtr> {
  static bool IsNull(const ::device::mojom::blink::VRFieldOfViewPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::VRFieldOfViewPtr* output) { output->reset(); }

  static decltype(::device::mojom::blink::VRFieldOfView::up_degrees) up_degrees(
      const ::device::mojom::blink::VRFieldOfViewPtr& input) {
    return input->up_degrees;
  }

  static decltype(::device::mojom::blink::VRFieldOfView::down_degrees) down_degrees(
      const ::device::mojom::blink::VRFieldOfViewPtr& input) {
    return input->down_degrees;
  }

  static decltype(::device::mojom::blink::VRFieldOfView::left_degrees) left_degrees(
      const ::device::mojom::blink::VRFieldOfViewPtr& input) {
    return input->left_degrees;
  }

  static decltype(::device::mojom::blink::VRFieldOfView::right_degrees) right_degrees(
      const ::device::mojom::blink::VRFieldOfViewPtr& input) {
    return input->right_degrees;
  }

  static bool Read(::device::mojom::blink::VRFieldOfView::DataView input, ::device::mojom::blink::VRFieldOfViewPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::VRPose::DataView,
                                         ::device::mojom::blink::VRPosePtr> {
  static bool IsNull(const ::device::mojom::blink::VRPosePtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::VRPosePtr* output) { output->reset(); }

  static const decltype(::device::mojom::blink::VRPose::orientation)& orientation(
      const ::device::mojom::blink::VRPosePtr& input) {
    return input->orientation;
  }

  static const decltype(::device::mojom::blink::VRPose::position)& position(
      const ::device::mojom::blink::VRPosePtr& input) {
    return input->position;
  }

  static decltype(::device::mojom::blink::VRPose::emulated_position) emulated_position(
      const ::device::mojom::blink::VRPosePtr& input) {
    return input->emulated_position;
  }

  static bool Read(::device::mojom::blink::VRPose::DataView input, ::device::mojom::blink::VRPosePtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::Pose::DataView,
                                         ::device::mojom::blink::PosePtr> {
  static bool IsNull(const ::device::mojom::blink::PosePtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::PosePtr* output) { output->reset(); }

  static const decltype(::device::mojom::blink::Pose::orientation)& orientation(
      const ::device::mojom::blink::PosePtr& input) {
    return input->orientation;
  }

  static const decltype(::device::mojom::blink::Pose::position)& position(
      const ::device::mojom::blink::PosePtr& input) {
    return input->position;
  }

  static bool Read(::device::mojom::blink::Pose::DataView input, ::device::mojom::blink::PosePtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRRay::DataView,
                                         ::device::mojom::blink::XRRayPtr> {
  static bool IsNull(const ::device::mojom::blink::XRRayPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRRayPtr* output) { output->reset(); }

  static const decltype(::device::mojom::blink::XRRay::origin)& origin(
      const ::device::mojom::blink::XRRayPtr& input) {
    return input->origin;
  }

  static const decltype(::device::mojom::blink::XRRay::direction)& direction(
      const ::device::mojom::blink::XRRayPtr& input) {
    return input->direction;
  }

  static bool Read(::device::mojom::blink::XRRay::DataView input, ::device::mojom::blink::XRRayPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRHitResult::DataView,
                                         ::device::mojom::blink::XRHitResultPtr> {
  static bool IsNull(const ::device::mojom::blink::XRHitResultPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRHitResultPtr* output) { output->reset(); }

  static const decltype(::device::mojom::blink::XRHitResult::mojo_from_result)& mojo_from_result(
      const ::device::mojom::blink::XRHitResultPtr& input) {
    return input->mojo_from_result;
  }

  static decltype(::device::mojom::blink::XRHitResult::plane_id) plane_id(
      const ::device::mojom::blink::XRHitResultPtr& input) {
    return input->plane_id;
  }

  static bool Read(::device::mojom::blink::XRHitResult::DataView input, ::device::mojom::blink::XRHitResultPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::VREyeParameters::DataView,
                                         ::device::mojom::blink::VREyeParametersPtr> {
  static bool IsNull(const ::device::mojom::blink::VREyeParametersPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::VREyeParametersPtr* output) { output->reset(); }

  static const decltype(::device::mojom::blink::VREyeParameters::field_of_view)& field_of_view(
      const ::device::mojom::blink::VREyeParametersPtr& input) {
    return input->field_of_view;
  }

  static const decltype(::device::mojom::blink::VREyeParameters::head_from_eye)& head_from_eye(
      const ::device::mojom::blink::VREyeParametersPtr& input) {
    return input->head_from_eye;
  }

  static decltype(::device::mojom::blink::VREyeParameters::render_width) render_width(
      const ::device::mojom::blink::VREyeParametersPtr& input) {
    return input->render_width;
  }

  static decltype(::device::mojom::blink::VREyeParameters::render_height) render_height(
      const ::device::mojom::blink::VREyeParametersPtr& input) {
    return input->render_height;
  }

  static bool Read(::device::mojom::blink::VREyeParameters::DataView input, ::device::mojom::blink::VREyeParametersPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::VRStageParameters::DataView,
                                         ::device::mojom::blink::VRStageParametersPtr> {
  static bool IsNull(const ::device::mojom::blink::VRStageParametersPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::VRStageParametersPtr* output) { output->reset(); }

  static const decltype(::device::mojom::blink::VRStageParameters::mojo_from_floor)& mojo_from_floor(
      const ::device::mojom::blink::VRStageParametersPtr& input) {
    return input->mojo_from_floor;
  }

  static const decltype(::device::mojom::blink::VRStageParameters::bounds)& bounds(
      const ::device::mojom::blink::VRStageParametersPtr& input) {
    return input->bounds;
  }

  static bool Read(::device::mojom::blink::VRStageParameters::DataView input, ::device::mojom::blink::VRStageParametersPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::VRDisplayInfo::DataView,
                                         ::device::mojom::blink::VRDisplayInfoPtr> {
  static bool IsNull(const ::device::mojom::blink::VRDisplayInfoPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::VRDisplayInfoPtr* output) { output->reset(); }

  static const decltype(::device::mojom::blink::VRDisplayInfo::stage_parameters)& stage_parameters(
      const ::device::mojom::blink::VRDisplayInfoPtr& input) {
    return input->stage_parameters;
  }

  static const decltype(::device::mojom::blink::VRDisplayInfo::left_eye)& left_eye(
      const ::device::mojom::blink::VRDisplayInfoPtr& input) {
    return input->left_eye;
  }

  static const decltype(::device::mojom::blink::VRDisplayInfo::right_eye)& right_eye(
      const ::device::mojom::blink::VRDisplayInfoPtr& input) {
    return input->right_eye;
  }

  static bool Read(::device::mojom::blink::VRDisplayInfo::DataView input, ::device::mojom::blink::VRDisplayInfoPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRPresentationTransportOptions::DataView,
                                         ::device::mojom::blink::XRPresentationTransportOptionsPtr> {
  static bool IsNull(const ::device::mojom::blink::XRPresentationTransportOptionsPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRPresentationTransportOptionsPtr* output) { output->reset(); }

  static decltype(::device::mojom::blink::XRPresentationTransportOptions::transport_method) transport_method(
      const ::device::mojom::blink::XRPresentationTransportOptionsPtr& input) {
    return input->transport_method;
  }

  static decltype(::device::mojom::blink::XRPresentationTransportOptions::wait_for_transfer_notification) wait_for_transfer_notification(
      const ::device::mojom::blink::XRPresentationTransportOptionsPtr& input) {
    return input->wait_for_transfer_notification;
  }

  static decltype(::device::mojom::blink::XRPresentationTransportOptions::wait_for_render_notification) wait_for_render_notification(
      const ::device::mojom::blink::XRPresentationTransportOptionsPtr& input) {
    return input->wait_for_render_notification;
  }

  static decltype(::device::mojom::blink::XRPresentationTransportOptions::wait_for_gpu_fence) wait_for_gpu_fence(
      const ::device::mojom::blink::XRPresentationTransportOptionsPtr& input) {
    return input->wait_for_gpu_fence;
  }

  static bool Read(::device::mojom::blink::XRPresentationTransportOptions::DataView input, ::device::mojom::blink::XRPresentationTransportOptionsPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRPlanePointData::DataView,
                                         ::device::mojom::blink::XRPlanePointDataPtr> {
  static bool IsNull(const ::device::mojom::blink::XRPlanePointDataPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRPlanePointDataPtr* output) { output->reset(); }

  static decltype(::device::mojom::blink::XRPlanePointData::x) x(
      const ::device::mojom::blink::XRPlanePointDataPtr& input) {
    return input->x;
  }

  static decltype(::device::mojom::blink::XRPlanePointData::z) z(
      const ::device::mojom::blink::XRPlanePointDataPtr& input) {
    return input->z;
  }

  static bool Read(::device::mojom::blink::XRPlanePointData::DataView input, ::device::mojom::blink::XRPlanePointDataPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRPlaneData::DataView,
                                         ::device::mojom::blink::XRPlaneDataPtr> {
  static bool IsNull(const ::device::mojom::blink::XRPlaneDataPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRPlaneDataPtr* output) { output->reset(); }

  static decltype(::device::mojom::blink::XRPlaneData::id) id(
      const ::device::mojom::blink::XRPlaneDataPtr& input) {
    return input->id;
  }

  static decltype(::device::mojom::blink::XRPlaneData::orientation) orientation(
      const ::device::mojom::blink::XRPlaneDataPtr& input) {
    return input->orientation;
  }

  static const decltype(::device::mojom::blink::XRPlaneData::mojo_from_plane)& mojo_from_plane(
      const ::device::mojom::blink::XRPlaneDataPtr& input) {
    return input->mojo_from_plane;
  }

  static const decltype(::device::mojom::blink::XRPlaneData::polygon)& polygon(
      const ::device::mojom::blink::XRPlaneDataPtr& input) {
    return input->polygon;
  }

  static bool Read(::device::mojom::blink::XRPlaneData::DataView input, ::device::mojom::blink::XRPlaneDataPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRPlaneDetectionData::DataView,
                                         ::device::mojom::blink::XRPlaneDetectionDataPtr> {
  static bool IsNull(const ::device::mojom::blink::XRPlaneDetectionDataPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRPlaneDetectionDataPtr* output) { output->reset(); }

  static const decltype(::device::mojom::blink::XRPlaneDetectionData::all_planes_ids)& all_planes_ids(
      const ::device::mojom::blink::XRPlaneDetectionDataPtr& input) {
    return input->all_planes_ids;
  }

  static const decltype(::device::mojom::blink::XRPlaneDetectionData::updated_planes_data)& updated_planes_data(
      const ::device::mojom::blink::XRPlaneDetectionDataPtr& input) {
    return input->updated_planes_data;
  }

  static bool Read(::device::mojom::blink::XRPlaneDetectionData::DataView input, ::device::mojom::blink::XRPlaneDetectionDataPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRAnchorData::DataView,
                                         ::device::mojom::blink::XRAnchorDataPtr> {
  static bool IsNull(const ::device::mojom::blink::XRAnchorDataPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRAnchorDataPtr* output) { output->reset(); }

  static decltype(::device::mojom::blink::XRAnchorData::id) id(
      const ::device::mojom::blink::XRAnchorDataPtr& input) {
    return input->id;
  }

  static const decltype(::device::mojom::blink::XRAnchorData::mojo_from_anchor)& mojo_from_anchor(
      const ::device::mojom::blink::XRAnchorDataPtr& input) {
    return input->mojo_from_anchor;
  }

  static bool Read(::device::mojom::blink::XRAnchorData::DataView input, ::device::mojom::blink::XRAnchorDataPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRAnchorsData::DataView,
                                         ::device::mojom::blink::XRAnchorsDataPtr> {
  static bool IsNull(const ::device::mojom::blink::XRAnchorsDataPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRAnchorsDataPtr* output) { output->reset(); }

  static const decltype(::device::mojom::blink::XRAnchorsData::all_anchors_ids)& all_anchors_ids(
      const ::device::mojom::blink::XRAnchorsDataPtr& input) {
    return input->all_anchors_ids;
  }

  static const decltype(::device::mojom::blink::XRAnchorsData::updated_anchors_data)& updated_anchors_data(
      const ::device::mojom::blink::XRAnchorsDataPtr& input) {
    return input->updated_anchors_data;
  }

  static bool Read(::device::mojom::blink::XRAnchorsData::DataView input, ::device::mojom::blink::XRAnchorsDataPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRHitTestSubscriptionResultData::DataView,
                                         ::device::mojom::blink::XRHitTestSubscriptionResultDataPtr> {
  static bool IsNull(const ::device::mojom::blink::XRHitTestSubscriptionResultDataPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRHitTestSubscriptionResultDataPtr* output) { output->reset(); }

  static decltype(::device::mojom::blink::XRHitTestSubscriptionResultData::subscription_id) subscription_id(
      const ::device::mojom::blink::XRHitTestSubscriptionResultDataPtr& input) {
    return input->subscription_id;
  }

  static const decltype(::device::mojom::blink::XRHitTestSubscriptionResultData::hit_test_results)& hit_test_results(
      const ::device::mojom::blink::XRHitTestSubscriptionResultDataPtr& input) {
    return input->hit_test_results;
  }

  static bool Read(::device::mojom::blink::XRHitTestSubscriptionResultData::DataView input, ::device::mojom::blink::XRHitTestSubscriptionResultDataPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRHitTestTransientInputSubscriptionResultData::DataView,
                                         ::device::mojom::blink::XRHitTestTransientInputSubscriptionResultDataPtr> {
  static bool IsNull(const ::device::mojom::blink::XRHitTestTransientInputSubscriptionResultDataPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRHitTestTransientInputSubscriptionResultDataPtr* output) { output->reset(); }

  static decltype(::device::mojom::blink::XRHitTestTransientInputSubscriptionResultData::subscription_id) subscription_id(
      const ::device::mojom::blink::XRHitTestTransientInputSubscriptionResultDataPtr& input) {
    return input->subscription_id;
  }

  static const decltype(::device::mojom::blink::XRHitTestTransientInputSubscriptionResultData::input_source_id_to_hit_test_results)& input_source_id_to_hit_test_results(
      const ::device::mojom::blink::XRHitTestTransientInputSubscriptionResultDataPtr& input) {
    return input->input_source_id_to_hit_test_results;
  }

  static bool Read(::device::mojom::blink::XRHitTestTransientInputSubscriptionResultData::DataView input, ::device::mojom::blink::XRHitTestTransientInputSubscriptionResultDataPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRHitTestSubscriptionResultsData::DataView,
                                         ::device::mojom::blink::XRHitTestSubscriptionResultsDataPtr> {
  static bool IsNull(const ::device::mojom::blink::XRHitTestSubscriptionResultsDataPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRHitTestSubscriptionResultsDataPtr* output) { output->reset(); }

  static const decltype(::device::mojom::blink::XRHitTestSubscriptionResultsData::results)& results(
      const ::device::mojom::blink::XRHitTestSubscriptionResultsDataPtr& input) {
    return input->results;
  }

  static const decltype(::device::mojom::blink::XRHitTestSubscriptionResultsData::transient_input_results)& transient_input_results(
      const ::device::mojom::blink::XRHitTestSubscriptionResultsDataPtr& input) {
    return input->transient_input_results;
  }

  static bool Read(::device::mojom::blink::XRHitTestSubscriptionResultsData::DataView input, ::device::mojom::blink::XRHitTestSubscriptionResultsDataPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::RgbTupleF32::DataView,
                                         ::device::mojom::blink::RgbTupleF32Ptr> {
  static bool IsNull(const ::device::mojom::blink::RgbTupleF32Ptr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::RgbTupleF32Ptr* output) { output->reset(); }

  static decltype(::device::mojom::blink::RgbTupleF32::red) red(
      const ::device::mojom::blink::RgbTupleF32Ptr& input) {
    return input->red;
  }

  static decltype(::device::mojom::blink::RgbTupleF32::green) green(
      const ::device::mojom::blink::RgbTupleF32Ptr& input) {
    return input->green;
  }

  static decltype(::device::mojom::blink::RgbTupleF32::blue) blue(
      const ::device::mojom::blink::RgbTupleF32Ptr& input) {
    return input->blue;
  }

  static bool Read(::device::mojom::blink::RgbTupleF32::DataView input, ::device::mojom::blink::RgbTupleF32Ptr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRSphericalHarmonics::DataView,
                                         ::device::mojom::blink::XRSphericalHarmonicsPtr> {
  static bool IsNull(const ::device::mojom::blink::XRSphericalHarmonicsPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRSphericalHarmonicsPtr* output) { output->reset(); }

  static const decltype(::device::mojom::blink::XRSphericalHarmonics::coefficients)& coefficients(
      const ::device::mojom::blink::XRSphericalHarmonicsPtr& input) {
    return input->coefficients;
  }

  static bool Read(::device::mojom::blink::XRSphericalHarmonics::DataView input, ::device::mojom::blink::XRSphericalHarmonicsPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::RgbaTupleF16::DataView,
                                         ::device::mojom::blink::RgbaTupleF16Ptr> {
  static bool IsNull(const ::device::mojom::blink::RgbaTupleF16Ptr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::RgbaTupleF16Ptr* output) { output->reset(); }

  static decltype(::device::mojom::blink::RgbaTupleF16::red) red(
      const ::device::mojom::blink::RgbaTupleF16Ptr& input) {
    return input->red;
  }

  static decltype(::device::mojom::blink::RgbaTupleF16::green) green(
      const ::device::mojom::blink::RgbaTupleF16Ptr& input) {
    return input->green;
  }

  static decltype(::device::mojom::blink::RgbaTupleF16::blue) blue(
      const ::device::mojom::blink::RgbaTupleF16Ptr& input) {
    return input->blue;
  }

  static decltype(::device::mojom::blink::RgbaTupleF16::alpha) alpha(
      const ::device::mojom::blink::RgbaTupleF16Ptr& input) {
    return input->alpha;
  }

  static bool Read(::device::mojom::blink::RgbaTupleF16::DataView input, ::device::mojom::blink::RgbaTupleF16Ptr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRCubeMap::DataView,
                                         ::device::mojom::blink::XRCubeMapPtr> {
  static bool IsNull(const ::device::mojom::blink::XRCubeMapPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRCubeMapPtr* output) { output->reset(); }

  static decltype(::device::mojom::blink::XRCubeMap::width_and_height) width_and_height(
      const ::device::mojom::blink::XRCubeMapPtr& input) {
    return input->width_and_height;
  }

  static const decltype(::device::mojom::blink::XRCubeMap::positive_x)& positive_x(
      const ::device::mojom::blink::XRCubeMapPtr& input) {
    return input->positive_x;
  }

  static const decltype(::device::mojom::blink::XRCubeMap::negative_x)& negative_x(
      const ::device::mojom::blink::XRCubeMapPtr& input) {
    return input->negative_x;
  }

  static const decltype(::device::mojom::blink::XRCubeMap::positive_y)& positive_y(
      const ::device::mojom::blink::XRCubeMapPtr& input) {
    return input->positive_y;
  }

  static const decltype(::device::mojom::blink::XRCubeMap::negative_y)& negative_y(
      const ::device::mojom::blink::XRCubeMapPtr& input) {
    return input->negative_y;
  }

  static const decltype(::device::mojom::blink::XRCubeMap::positive_z)& positive_z(
      const ::device::mojom::blink::XRCubeMapPtr& input) {
    return input->positive_z;
  }

  static const decltype(::device::mojom::blink::XRCubeMap::negative_z)& negative_z(
      const ::device::mojom::blink::XRCubeMapPtr& input) {
    return input->negative_z;
  }

  static bool Read(::device::mojom::blink::XRCubeMap::DataView input, ::device::mojom::blink::XRCubeMapPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRLightProbe::DataView,
                                         ::device::mojom::blink::XRLightProbePtr> {
  static bool IsNull(const ::device::mojom::blink::XRLightProbePtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRLightProbePtr* output) { output->reset(); }

  static const decltype(::device::mojom::blink::XRLightProbe::spherical_harmonics)& spherical_harmonics(
      const ::device::mojom::blink::XRLightProbePtr& input) {
    return input->spherical_harmonics;
  }

  static const decltype(::device::mojom::blink::XRLightProbe::main_light_direction)& main_light_direction(
      const ::device::mojom::blink::XRLightProbePtr& input) {
    return input->main_light_direction;
  }

  static const decltype(::device::mojom::blink::XRLightProbe::main_light_intensity)& main_light_intensity(
      const ::device::mojom::blink::XRLightProbePtr& input) {
    return input->main_light_intensity;
  }

  static bool Read(::device::mojom::blink::XRLightProbe::DataView input, ::device::mojom::blink::XRLightProbePtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRReflectionProbe::DataView,
                                         ::device::mojom::blink::XRReflectionProbePtr> {
  static bool IsNull(const ::device::mojom::blink::XRReflectionProbePtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRReflectionProbePtr* output) { output->reset(); }

  static const decltype(::device::mojom::blink::XRReflectionProbe::cube_map)& cube_map(
      const ::device::mojom::blink::XRReflectionProbePtr& input) {
    return input->cube_map;
  }

  static bool Read(::device::mojom::blink::XRReflectionProbe::DataView input, ::device::mojom::blink::XRReflectionProbePtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRLightEstimationData::DataView,
                                         ::device::mojom::blink::XRLightEstimationDataPtr> {
  static bool IsNull(const ::device::mojom::blink::XRLightEstimationDataPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRLightEstimationDataPtr* output) { output->reset(); }

  static const decltype(::device::mojom::blink::XRLightEstimationData::light_probe)& light_probe(
      const ::device::mojom::blink::XRLightEstimationDataPtr& input) {
    return input->light_probe;
  }

  static const decltype(::device::mojom::blink::XRLightEstimationData::reflection_probe)& reflection_probe(
      const ::device::mojom::blink::XRLightEstimationDataPtr& input) {
    return input->reflection_probe;
  }

  static bool Read(::device::mojom::blink::XRLightEstimationData::DataView input, ::device::mojom::blink::XRLightEstimationDataPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRDepthDataStillValid::DataView,
                                         ::device::mojom::blink::XRDepthDataStillValidPtr> {
  static bool IsNull(const ::device::mojom::blink::XRDepthDataStillValidPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRDepthDataStillValidPtr* output) { output->reset(); }

  static bool Read(::device::mojom::blink::XRDepthDataStillValid::DataView input, ::device::mojom::blink::XRDepthDataStillValidPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRDepthDataUpdated::DataView,
                                         ::device::mojom::blink::XRDepthDataUpdatedPtr> {
  static bool IsNull(const ::device::mojom::blink::XRDepthDataUpdatedPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRDepthDataUpdatedPtr* output) { output->reset(); }

  static const decltype(::device::mojom::blink::XRDepthDataUpdated::time_delta)& time_delta(
      const ::device::mojom::blink::XRDepthDataUpdatedPtr& input) {
    return input->time_delta;
  }

  static  decltype(::device::mojom::blink::XRDepthDataUpdated::pixel_data)& pixel_data(
       ::device::mojom::blink::XRDepthDataUpdatedPtr& input) {
    return input->pixel_data;
  }

  static const decltype(::device::mojom::blink::XRDepthDataUpdated::norm_texture_from_norm_view)& norm_texture_from_norm_view(
      const ::device::mojom::blink::XRDepthDataUpdatedPtr& input) {
    return input->norm_texture_from_norm_view;
  }

  static const decltype(::device::mojom::blink::XRDepthDataUpdated::size)& size(
      const ::device::mojom::blink::XRDepthDataUpdatedPtr& input) {
    return input->size;
  }

  static bool Read(::device::mojom::blink::XRDepthDataUpdated::DataView input, ::device::mojom::blink::XRDepthDataUpdatedPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRFrameData::DataView,
                                         ::device::mojom::blink::XRFrameDataPtr> {
  static bool IsNull(const ::device::mojom::blink::XRFrameDataPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRFrameDataPtr* output) { output->reset(); }

  static const decltype(::device::mojom::blink::XRFrameData::pose)& pose(
      const ::device::mojom::blink::XRFrameDataPtr& input) {
    return input->pose;
  }

  static const decltype(::device::mojom::blink::XRFrameData::time_delta)& time_delta(
      const ::device::mojom::blink::XRFrameDataPtr& input) {
    return input->time_delta;
  }

  static const decltype(::device::mojom::blink::XRFrameData::buffer_holder)& buffer_holder(
      const ::device::mojom::blink::XRFrameDataPtr& input) {
    return input->buffer_holder;
  }

  static const decltype(::device::mojom::blink::XRFrameData::camera_image_buffer_holder)& camera_image_buffer_holder(
      const ::device::mojom::blink::XRFrameDataPtr& input) {
    return input->camera_image_buffer_holder;
  }

  static  decltype(::device::mojom::blink::XRFrameData::depth_data)& depth_data(
       ::device::mojom::blink::XRFrameDataPtr& input) {
    return input->depth_data;
  }

  static decltype(::device::mojom::blink::XRFrameData::mojo_space_reset) mojo_space_reset(
      const ::device::mojom::blink::XRFrameDataPtr& input) {
    return input->mojo_space_reset;
  }

  static decltype(::device::mojom::blink::XRFrameData::frame_id) frame_id(
      const ::device::mojom::blink::XRFrameDataPtr& input) {
    return input->frame_id;
  }

  static const decltype(::device::mojom::blink::XRFrameData::left_eye)& left_eye(
      const ::device::mojom::blink::XRFrameDataPtr& input) {
    return input->left_eye;
  }

  static const decltype(::device::mojom::blink::XRFrameData::right_eye)& right_eye(
      const ::device::mojom::blink::XRFrameDataPtr& input) {
    return input->right_eye;
  }

  static const decltype(::device::mojom::blink::XRFrameData::input_state)& input_state(
      const ::device::mojom::blink::XRFrameDataPtr& input) {
    return input->input_state;
  }

  static decltype(::device::mojom::blink::XRFrameData::stage_parameters_updated) stage_parameters_updated(
      const ::device::mojom::blink::XRFrameDataPtr& input) {
    return input->stage_parameters_updated;
  }

  static const decltype(::device::mojom::blink::XRFrameData::stage_parameters)& stage_parameters(
      const ::device::mojom::blink::XRFrameDataPtr& input) {
    return input->stage_parameters;
  }

  static const decltype(::device::mojom::blink::XRFrameData::detected_planes_data)& detected_planes_data(
      const ::device::mojom::blink::XRFrameDataPtr& input) {
    return input->detected_planes_data;
  }

  static const decltype(::device::mojom::blink::XRFrameData::anchors_data)& anchors_data(
      const ::device::mojom::blink::XRFrameDataPtr& input) {
    return input->anchors_data;
  }

  static const decltype(::device::mojom::blink::XRFrameData::light_estimation_data)& light_estimation_data(
      const ::device::mojom::blink::XRFrameDataPtr& input) {
    return input->light_estimation_data;
  }

  static const decltype(::device::mojom::blink::XRFrameData::hit_test_subscription_results)& hit_test_subscription_results(
      const ::device::mojom::blink::XRFrameDataPtr& input) {
    return input->hit_test_subscription_results;
  }

  static bool Read(::device::mojom::blink::XRFrameData::DataView input, ::device::mojom::blink::XRFrameDataPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::RequestSessionSuccess::DataView,
                                         ::device::mojom::blink::RequestSessionSuccessPtr> {
  static bool IsNull(const ::device::mojom::blink::RequestSessionSuccessPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::RequestSessionSuccessPtr* output) { output->reset(); }

  static  decltype(::device::mojom::blink::RequestSessionSuccess::session)& session(
       ::device::mojom::blink::RequestSessionSuccessPtr& input) {
    return input->session;
  }

  static  decltype(::device::mojom::blink::RequestSessionSuccess::metrics_recorder)& metrics_recorder(
       ::device::mojom::blink::RequestSessionSuccessPtr& input) {
    return input->metrics_recorder;
  }

  static bool Read(::device::mojom::blink::RequestSessionSuccess::DataView input, ::device::mojom::blink::RequestSessionSuccessPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRFrameDataRequestOptions::DataView,
                                         ::device::mojom::blink::XRFrameDataRequestOptionsPtr> {
  static bool IsNull(const ::device::mojom::blink::XRFrameDataRequestOptionsPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRFrameDataRequestOptionsPtr* output) { output->reset(); }

  static decltype(::device::mojom::blink::XRFrameDataRequestOptions::include_lighting_estimation_data) include_lighting_estimation_data(
      const ::device::mojom::blink::XRFrameDataRequestOptionsPtr& input) {
    return input->include_lighting_estimation_data;
  }

  static bool Read(::device::mojom::blink::XRFrameDataRequestOptions::DataView input, ::device::mojom::blink::XRFrameDataRequestOptionsPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) UnionTraits<::device::mojom::blink::XRNativeOriginInformation::DataView,
                                        ::device::mojom::blink::XRNativeOriginInformationPtr> {
  static bool IsNull(const ::device::mojom::blink::XRNativeOriginInformationPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRNativeOriginInformationPtr* output) { output->reset(); }

  static ::device::mojom::blink::XRNativeOriginInformation::Tag GetTag(const ::device::mojom::blink::XRNativeOriginInformationPtr& input) {
    return input->which();
  }

  static  uint32_t input_source_id(const ::device::mojom::blink::XRNativeOriginInformationPtr& input) {
    return input->get_input_source_id();
  }

  static  uint64_t plane_id(const ::device::mojom::blink::XRNativeOriginInformationPtr& input) {
    return input->get_plane_id();
  }

  static  uint64_t anchor_id(const ::device::mojom::blink::XRNativeOriginInformationPtr& input) {
    return input->get_anchor_id();
  }

  static  ::device::mojom::blink::XRReferenceSpaceType reference_space_type(const ::device::mojom::blink::XRNativeOriginInformationPtr& input) {
    return input->get_reference_space_type();
  }

  static bool Read(::device::mojom::blink::XRNativeOriginInformation::DataView input, ::device::mojom::blink::XRNativeOriginInformationPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) UnionTraits<::device::mojom::blink::XRDepthData::DataView,
                                        ::device::mojom::blink::XRDepthDataPtr> {
  static bool IsNull(const ::device::mojom::blink::XRDepthDataPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRDepthDataPtr* output) { output->reset(); }

  static ::device::mojom::blink::XRDepthData::Tag GetTag(const ::device::mojom::blink::XRDepthDataPtr& input) {
    return input->which();
  }

  static const ::device::mojom::blink::XRDepthDataStillValidPtr& data_still_valid(const ::device::mojom::blink::XRDepthDataPtr& input) {
    return input->get_data_still_valid();
  }

  static  ::device::mojom::blink::XRDepthDataUpdatedPtr& updated_depth_data( ::device::mojom::blink::XRDepthDataPtr& input) {
    return input->get_updated_depth_data();
  }

  static bool Read(::device::mojom::blink::XRDepthData::DataView input, ::device::mojom::blink::XRDepthDataPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_BLINK) UnionTraits<::device::mojom::blink::RequestSessionResult::DataView,
                                        ::device::mojom::blink::RequestSessionResultPtr> {
  static bool IsNull(const ::device::mojom::blink::RequestSessionResultPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::RequestSessionResultPtr* output) { output->reset(); }

  static ::device::mojom::blink::RequestSessionResult::Tag GetTag(const ::device::mojom::blink::RequestSessionResultPtr& input) {
    return input->which();
  }

  static  ::device::mojom::blink::RequestSessionSuccessPtr& success( ::device::mojom::blink::RequestSessionResultPtr& input) {
    return input->get_success();
  }

  static  ::device::mojom::blink::RequestSessionError failure_reason(const ::device::mojom::blink::RequestSessionResultPtr& input) {
    return input->get_failure_reason();
  }

  static bool Read(::device::mojom::blink::RequestSessionResult::DataView input, ::device::mojom::blink::RequestSessionResultPtr* output);
};

}  // namespace mojo

#endif  // DEVICE_VR_PUBLIC_MOJOM_VR_SERVICE_MOJOM_BLINK_H_