// device/vr/public/mojom/vr_service.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef DEVICE_VR_PUBLIC_MOJOM_VR_SERVICE_MOJOM_SHARED_H_
#define DEVICE_VR_PUBLIC_MOJOM_VR_SERVICE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "device/vr/public/mojom/vr_service.mojom-shared-internal.h"
#include "device/gamepad/public/mojom/gamepad.mojom-shared.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "gpu/ipc/common/mailbox_holder.mojom-shared.h"
#include "gpu/ipc/common/sync_token.mojom-shared.h"
#include "ui/display/mojom/display.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/gpu_fence_handle.mojom-shared.h"
#include "ui/gfx/mojom/transform.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"


#include "base/component_export.h"




namespace device {
namespace mojom {
class XRSessionOptionsDataView;

class XRSessionDataView;

class XRPresentationConnectionDataView;

class XRInputSourceDescriptionDataView;

class XRInputSourceStateDataView;

class VRFieldOfViewDataView;

class VRPoseDataView;

class PoseDataView;

class XRRayDataView;

class XRHitResultDataView;

class VREyeParametersDataView;

class VRStageParametersDataView;

class VRDisplayInfoDataView;

class XRPresentationTransportOptionsDataView;

class XRPlanePointDataDataView;

class XRPlaneDataDataView;

class XRPlaneDetectionDataDataView;

class XRAnchorDataDataView;

class XRAnchorsDataDataView;

class XRHitTestSubscriptionResultDataDataView;

class XRHitTestTransientInputSubscriptionResultDataDataView;

class XRHitTestSubscriptionResultsDataDataView;

class RgbTupleF32DataView;

class XRSphericalHarmonicsDataView;

class RgbaTupleF16DataView;

class XRCubeMapDataView;

class XRLightProbeDataView;

class XRReflectionProbeDataView;

class XRLightEstimationDataDataView;

class XRDepthDataStillValidDataView;

class XRDepthDataUpdatedDataView;

class XRFrameDataDataView;

class RequestSessionSuccessDataView;

class XRFrameDataRequestOptionsDataView;

class XRNativeOriginInformationDataView;
class XRDepthDataDataView;
class RequestSessionResultDataView;


}  // namespace mojom
}  // namespace device

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::device::mojom::XRSessionOptionsDataView> {
  using Data = ::device::mojom::internal::XRSessionOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRSessionDataView> {
  using Data = ::device::mojom::internal::XRSession_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRPresentationConnectionDataView> {
  using Data = ::device::mojom::internal::XRPresentationConnection_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRInputSourceDescriptionDataView> {
  using Data = ::device::mojom::internal::XRInputSourceDescription_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRInputSourceStateDataView> {
  using Data = ::device::mojom::internal::XRInputSourceState_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::VRFieldOfViewDataView> {
  using Data = ::device::mojom::internal::VRFieldOfView_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::VRPoseDataView> {
  using Data = ::device::mojom::internal::VRPose_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::PoseDataView> {
  using Data = ::device::mojom::internal::Pose_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRRayDataView> {
  using Data = ::device::mojom::internal::XRRay_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRHitResultDataView> {
  using Data = ::device::mojom::internal::XRHitResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::VREyeParametersDataView> {
  using Data = ::device::mojom::internal::VREyeParameters_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::VRStageParametersDataView> {
  using Data = ::device::mojom::internal::VRStageParameters_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::VRDisplayInfoDataView> {
  using Data = ::device::mojom::internal::VRDisplayInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRPresentationTransportOptionsDataView> {
  using Data = ::device::mojom::internal::XRPresentationTransportOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRPlanePointDataDataView> {
  using Data = ::device::mojom::internal::XRPlanePointData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRPlaneDataDataView> {
  using Data = ::device::mojom::internal::XRPlaneData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRPlaneDetectionDataDataView> {
  using Data = ::device::mojom::internal::XRPlaneDetectionData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRAnchorDataDataView> {
  using Data = ::device::mojom::internal::XRAnchorData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRAnchorsDataDataView> {
  using Data = ::device::mojom::internal::XRAnchorsData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRHitTestSubscriptionResultDataDataView> {
  using Data = ::device::mojom::internal::XRHitTestSubscriptionResultData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRHitTestTransientInputSubscriptionResultDataDataView> {
  using Data = ::device::mojom::internal::XRHitTestTransientInputSubscriptionResultData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRHitTestSubscriptionResultsDataDataView> {
  using Data = ::device::mojom::internal::XRHitTestSubscriptionResultsData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::RgbTupleF32DataView> {
  using Data = ::device::mojom::internal::RgbTupleF32_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRSphericalHarmonicsDataView> {
  using Data = ::device::mojom::internal::XRSphericalHarmonics_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::RgbaTupleF16DataView> {
  using Data = ::device::mojom::internal::RgbaTupleF16_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRCubeMapDataView> {
  using Data = ::device::mojom::internal::XRCubeMap_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRLightProbeDataView> {
  using Data = ::device::mojom::internal::XRLightProbe_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRReflectionProbeDataView> {
  using Data = ::device::mojom::internal::XRReflectionProbe_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRLightEstimationDataDataView> {
  using Data = ::device::mojom::internal::XRLightEstimationData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRDepthDataStillValidDataView> {
  using Data = ::device::mojom::internal::XRDepthDataStillValid_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRDepthDataUpdatedDataView> {
  using Data = ::device::mojom::internal::XRDepthDataUpdated_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRFrameDataDataView> {
  using Data = ::device::mojom::internal::XRFrameData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::RequestSessionSuccessDataView> {
  using Data = ::device::mojom::internal::RequestSessionSuccess_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRFrameDataRequestOptionsDataView> {
  using Data = ::device::mojom::internal::XRFrameDataRequestOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRNativeOriginInformationDataView> {
  using Data = ::device::mojom::internal::XRNativeOriginInformation_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::device::mojom::XRDepthDataDataView> {
  using Data = ::device::mojom::internal::XRDepthData_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::device::mojom::RequestSessionResultDataView> {
  using Data = ::device::mojom::internal::RequestSessionResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace device {
namespace mojom {


enum class XRDeviceId : int32_t {
  
  WEB_TEST_DEVICE_ID = 0,
  
  FAKE_DEVICE_ID = 1,
  
  ORIENTATION_DEVICE_ID = 2,
  
  GVR_DEVICE_ID = 3,
  
  ARCORE_DEVICE_ID = 7,
  kMinValue = 0,
  kMaxValue = 7,
};

COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, XRDeviceId value);
inline bool IsKnownEnumValue(XRDeviceId value) {
  return internal::XRDeviceId_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class XRHandedness : int32_t {
  
  NONE = 0,
  
  LEFT = 1,
  
  RIGHT = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, XRHandedness value);
inline bool IsKnownEnumValue(XRHandedness value) {
  return internal::XRHandedness_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class XRTargetRayMode : int32_t {
  
  GAZING = 1,
  
  POINTING = 2,
  
  TAPPING = 3,
  kMinValue = 1,
  kMaxValue = 3,
};

COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, XRTargetRayMode value);
inline bool IsKnownEnumValue(XRTargetRayMode value) {
  return internal::XRTargetRayMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class XRSessionFeature : int32_t {
  
  REF_SPACE_VIEWER = 1,
  
  REF_SPACE_LOCAL = 2,
  
  REF_SPACE_LOCAL_FLOOR = 3,
  
  REF_SPACE_BOUNDED_FLOOR = 4,
  
  REF_SPACE_UNBOUNDED = 5,
  
  DOM_OVERLAY = 6,
  
  HIT_TEST = 7,
  
  LIGHT_ESTIMATION = 8,
  
  ANCHORS = 9,
  
  CAMERA_ACCESS = 10,
  
  PLANE_DETECTION = 11,
  
  DEPTH = 12,
  kMinValue = 1,
  kMaxValue = 12,
};

COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, XRSessionFeature value);
inline bool IsKnownEnumValue(XRSessionFeature value) {
  return internal::XRSessionFeature_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class XRSessionFeatureRequestStatus : int32_t {
  
  kNotRequested = 0,
  
  kRequired = 1,
  
  kOptionalAccepted = 2,
  
  kOptionalRejected = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, XRSessionFeatureRequestStatus value);
inline bool IsKnownEnumValue(XRSessionFeatureRequestStatus value) {
  return internal::XRSessionFeatureRequestStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class XRSessionMode : int32_t {
  
  kInline = 1,
  
  kImmersiveVr = 2,
  
  kImmersiveAr = 3,
  kMinValue = 1,
  kMaxValue = 3,
};

COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, XRSessionMode value);
inline bool IsKnownEnumValue(XRSessionMode value) {
  return internal::XRSessionMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class XRPresentationTransportMethod : int32_t {
  
  NONE = 0,
  
  SUBMIT_AS_TEXTURE_HANDLE = 1,
  
  SUBMIT_AS_MAILBOX_HOLDER = 2,
  
  DRAW_INTO_TEXTURE_MAILBOX = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, XRPresentationTransportMethod value);
inline bool IsKnownEnumValue(XRPresentationTransportMethod value) {
  return internal::XRPresentationTransportMethod_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class XRReferenceSpaceType : int32_t {
  
  kViewer = 0,
  
  kLocal = 1,
  
  kLocalFloor = 2,
  
  kBoundedFloor = 3,
  
  kUnbounded = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, XRReferenceSpaceType value);
inline bool IsKnownEnumValue(XRReferenceSpaceType value) {
  return internal::XRReferenceSpaceType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class XRPlaneOrientation : int32_t {
  
  UNKNOWN = 0,
  
  HORIZONTAL = 1,
  
  VERTICAL = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, XRPlaneOrientation value);
inline bool IsKnownEnumValue(XRPlaneOrientation value) {
  return internal::XRPlaneOrientation_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class RequestSessionError : int32_t {
  
  EXISTING_IMMERSIVE_SESSION = 1,
  
  INVALID_CLIENT = 2,
  
  USER_DENIED_CONSENT = 3,
  
  NO_RUNTIME_FOUND = 4,
  
  UNKNOWN_RUNTIME_ERROR = 5,
  
  RUNTIME_INSTALL_FAILURE = 6,
  
  RUNTIMES_CHANGED = 7,
  
  FULLSCREEN_ERROR = 8,
  
  UNKNOWN_FAILURE = 9,
  kMinValue = 1,
  kMaxValue = 9,
};

COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, RequestSessionError value);
inline bool IsKnownEnumValue(RequestSessionError value) {
  return internal::RequestSessionError_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class XrCompatibleResult : int32_t {
  
  kAlreadyCompatible = 0,
  
  kNoDeviceAvailable = 1,
  
  kWebXrFeaturePolicyBlocked = 2,
  
  kCompatibleAfterRestart = 3,
  
  kNotCompatibleAfterRestart = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, XrCompatibleResult value);
inline bool IsKnownEnumValue(XrCompatibleResult value) {
  return internal::XrCompatibleResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CreateAnchorResult : int32_t {
  
  SUCCESS = 0,
  
  FAILURE = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, CreateAnchorResult value);
inline bool IsKnownEnumValue(CreateAnchorResult value) {
  return internal::CreateAnchorResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SubscribeToHitTestResult : int32_t {
  
  SUCCESS = 0,
  
  FAILURE_GENERIC = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, SubscribeToHitTestResult value);
inline bool IsKnownEnumValue(SubscribeToHitTestResult value) {
  return internal::SubscribeToHitTestResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class EntityTypeForHitTest : int32_t {
  
  POINT = 1,
  
  PLANE = 2,
  kMinValue = 1,
  kMaxValue = 2,
};

COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, EntityTypeForHitTest value);
inline bool IsKnownEnumValue(EntityTypeForHitTest value) {
  return internal::EntityTypeForHitTest_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class XRVisibilityState : int32_t {
  
  VISIBLE = 1,
  
  VISIBLE_BLURRED = 2,
  
  HIDDEN = 3,
  kMinValue = 1,
  kMaxValue = 3,
};

COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, XRVisibilityState value);
inline bool IsKnownEnumValue(XRVisibilityState value) {
  return internal::XRVisibilityState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class VRServiceInterfaceBase {};

using VRServicePtrDataView =
    mojo::InterfacePtrDataView<VRServiceInterfaceBase>;
using VRServiceRequestDataView =
    mojo::InterfaceRequestDataView<VRServiceInterfaceBase>;
using VRServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<VRServiceInterfaceBase>;
using VRServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<VRServiceInterfaceBase>;
class XRSessionMetricsRecorderInterfaceBase {};

using XRSessionMetricsRecorderPtrDataView =
    mojo::InterfacePtrDataView<XRSessionMetricsRecorderInterfaceBase>;
using XRSessionMetricsRecorderRequestDataView =
    mojo::InterfaceRequestDataView<XRSessionMetricsRecorderInterfaceBase>;
using XRSessionMetricsRecorderAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<XRSessionMetricsRecorderInterfaceBase>;
using XRSessionMetricsRecorderAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<XRSessionMetricsRecorderInterfaceBase>;
class VRServiceClientInterfaceBase {};

using VRServiceClientPtrDataView =
    mojo::InterfacePtrDataView<VRServiceClientInterfaceBase>;
using VRServiceClientRequestDataView =
    mojo::InterfaceRequestDataView<VRServiceClientInterfaceBase>;
using VRServiceClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<VRServiceClientInterfaceBase>;
using VRServiceClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<VRServiceClientInterfaceBase>;
class XREnvironmentIntegrationProviderInterfaceBase {};

using XREnvironmentIntegrationProviderPtrDataView =
    mojo::InterfacePtrDataView<XREnvironmentIntegrationProviderInterfaceBase>;
using XREnvironmentIntegrationProviderRequestDataView =
    mojo::InterfaceRequestDataView<XREnvironmentIntegrationProviderInterfaceBase>;
using XREnvironmentIntegrationProviderAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<XREnvironmentIntegrationProviderInterfaceBase>;
using XREnvironmentIntegrationProviderAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<XREnvironmentIntegrationProviderInterfaceBase>;
class XRInputSourceButtonListenerInterfaceBase {};

using XRInputSourceButtonListenerPtrDataView =
    mojo::InterfacePtrDataView<XRInputSourceButtonListenerInterfaceBase>;
using XRInputSourceButtonListenerRequestDataView =
    mojo::InterfaceRequestDataView<XRInputSourceButtonListenerInterfaceBase>;
using XRInputSourceButtonListenerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<XRInputSourceButtonListenerInterfaceBase>;
using XRInputSourceButtonListenerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<XRInputSourceButtonListenerInterfaceBase>;
class XRFrameDataProviderInterfaceBase {};

using XRFrameDataProviderPtrDataView =
    mojo::InterfacePtrDataView<XRFrameDataProviderInterfaceBase>;
using XRFrameDataProviderRequestDataView =
    mojo::InterfaceRequestDataView<XRFrameDataProviderInterfaceBase>;
using XRFrameDataProviderAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<XRFrameDataProviderInterfaceBase>;
using XRFrameDataProviderAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<XRFrameDataProviderInterfaceBase>;
class XRPresentationProviderInterfaceBase {};

using XRPresentationProviderPtrDataView =
    mojo::InterfacePtrDataView<XRPresentationProviderInterfaceBase>;
using XRPresentationProviderRequestDataView =
    mojo::InterfaceRequestDataView<XRPresentationProviderInterfaceBase>;
using XRPresentationProviderAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<XRPresentationProviderInterfaceBase>;
using XRPresentationProviderAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<XRPresentationProviderInterfaceBase>;
class XRPresentationClientInterfaceBase {};

using XRPresentationClientPtrDataView =
    mojo::InterfacePtrDataView<XRPresentationClientInterfaceBase>;
using XRPresentationClientRequestDataView =
    mojo::InterfaceRequestDataView<XRPresentationClientInterfaceBase>;
using XRPresentationClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<XRPresentationClientInterfaceBase>;
using XRPresentationClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<XRPresentationClientInterfaceBase>;
class XRSessionClientInterfaceBase {};

using XRSessionClientPtrDataView =
    mojo::InterfacePtrDataView<XRSessionClientInterfaceBase>;
using XRSessionClientRequestDataView =
    mojo::InterfaceRequestDataView<XRSessionClientInterfaceBase>;
using XRSessionClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<XRSessionClientInterfaceBase>;
using XRSessionClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<XRSessionClientInterfaceBase>;


class XRSessionOptionsDataView {
 public:
  XRSessionOptionsDataView() {}

  XRSessionOptionsDataView(
      internal::XRSessionOptions_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadMode(UserType* output) const {
    auto data_value = data_->mode;
    return mojo::internal::Deserialize<::device::mojom::XRSessionMode>(
        data_value, output);
  }

  XRSessionMode mode() const {
    return static_cast<XRSessionMode>(data_->mode);
  }
  inline void GetRequiredFeaturesDataView(
      mojo::ArrayDataView<XRSessionFeature>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRequiredFeatures(UserType* output) {
    
    auto* pointer = data_->required_features.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::XRSessionFeature>>(
        pointer, output, context_);
  }
  inline void GetOptionalFeaturesDataView(
      mojo::ArrayDataView<XRSessionFeature>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadOptionalFeatures(UserType* output) {
    
    auto* pointer = data_->optional_features.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::XRSessionFeature>>(
        pointer, output, context_);
  }
 private:
  internal::XRSessionOptions_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class XRSessionDataView {
 public:
  XRSessionDataView() {}

  XRSessionDataView(
      internal::XRSession_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeDataProvider() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::device::mojom::XRFrameDataProviderInterfaceBase>>(
            &data_->data_provider, &result, context_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeClientReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::device::mojom::XRSessionClientInterfaceBase>>(
            &data_->client_receiver, &result, context_);
    DCHECK(ret);
    return result;
  }
  inline void GetDisplayInfoDataView(
      VRDisplayInfoDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDisplayInfo(UserType* output) {
    
    auto* pointer = data_->display_info.Get();
    return mojo::internal::Deserialize<::device::mojom::VRDisplayInfoDataView>(
        pointer, output, context_);
  }
  inline void GetSubmitFrameSinkDataView(
      XRPresentationConnectionDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSubmitFrameSink(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::XRPresentationConnectionDataView, UserType>(),
    "Attempting to read the optional `submit_frame_sink` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSubmitFrameSink` instead "
    "of `ReadSubmitFrameSink if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->submit_frame_sink.Get();
    return mojo::internal::Deserialize<::device::mojom::XRPresentationConnectionDataView>(
        pointer, output, context_);
  }
  inline void GetEnabledFeaturesDataView(
      mojo::ArrayDataView<XRSessionFeature>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadEnabledFeatures(UserType* output) {
    
    auto* pointer = data_->enabled_features.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::XRSessionFeature>>(
        pointer, output, context_);
  }
  bool uses_input_eventing() const {
    return data_->uses_input_eventing;
  }
  float default_framebuffer_scale() const {
    return data_->default_framebuffer_scale;
  }
 private:
  internal::XRSession_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class XRPresentationConnectionDataView {
 public:
  XRPresentationConnectionDataView() {}

  XRPresentationConnectionDataView(
      internal::XRPresentationConnection_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeProvider() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::device::mojom::XRPresentationProviderInterfaceBase>>(
            &data_->provider, &result, context_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeClientReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::device::mojom::XRPresentationClientInterfaceBase>>(
            &data_->client_receiver, &result, context_);
    DCHECK(ret);
    return result;
  }
  inline void GetTransportOptionsDataView(
      XRPresentationTransportOptionsDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadTransportOptions(UserType* output) {
    
    auto* pointer = data_->transport_options.Get();
    return mojo::internal::Deserialize<::device::mojom::XRPresentationTransportOptionsDataView>(
        pointer, output, context_);
  }
 private:
  internal::XRPresentationConnection_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class XRInputSourceDescriptionDataView {
 public:
  XRInputSourceDescriptionDataView() {}

  XRInputSourceDescriptionDataView(
      internal::XRInputSourceDescription_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadTargetRayMode(UserType* output) const {
    auto data_value = data_->target_ray_mode;
    return mojo::internal::Deserialize<::device::mojom::XRTargetRayMode>(
        data_value, output);
  }

  XRTargetRayMode target_ray_mode() const {
    return static_cast<XRTargetRayMode>(data_->target_ray_mode);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadHandedness(UserType* output) const {
    auto data_value = data_->handedness;
    return mojo::internal::Deserialize<::device::mojom::XRHandedness>(
        data_value, output);
  }

  XRHandedness handedness() const {
    return static_cast<XRHandedness>(data_->handedness);
  }
  inline void GetInputFromPointerDataView(
      ::gfx::mojom::TransformDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadInputFromPointer(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::TransformDataView, UserType>(),
    "Attempting to read the optional `input_from_pointer` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInputFromPointer` instead "
    "of `ReadInputFromPointer if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->input_from_pointer.Get();
    return mojo::internal::Deserialize<::gfx::mojom::TransformDataView>(
        pointer, output, context_);
  }
  inline void GetProfilesDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadProfiles(UserType* output) {
    
    auto* pointer = data_->profiles.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, context_);
  }
 private:
  internal::XRInputSourceDescription_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class XRInputSourceStateDataView {
 public:
  XRInputSourceStateDataView() {}

  XRInputSourceStateDataView(
      internal::XRInputSourceState_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  uint32_t source_id() const {
    return data_->source_id;
  }
  inline void GetDescriptionDataView(
      XRInputSourceDescriptionDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDescription(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::XRInputSourceDescriptionDataView, UserType>(),
    "Attempting to read the optional `description` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDescription` instead "
    "of `ReadDescription if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->description.Get();
    return mojo::internal::Deserialize<::device::mojom::XRInputSourceDescriptionDataView>(
        pointer, output, context_);
  }
  inline void GetMojoFromInputDataView(
      ::gfx::mojom::TransformDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadMojoFromInput(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::TransformDataView, UserType>(),
    "Attempting to read the optional `mojo_from_input` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMojoFromInput` instead "
    "of `ReadMojoFromInput if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->mojo_from_input.Get();
    return mojo::internal::Deserialize<::gfx::mojom::TransformDataView>(
        pointer, output, context_);
  }
  bool emulated_position() const {
    return data_->emulated_position;
  }
  bool is_auxiliary() const {
    return data_->is_auxiliary;
  }
  bool primary_input_pressed() const {
    return data_->primary_input_pressed;
  }
  bool primary_input_clicked() const {
    return data_->primary_input_clicked;
  }
  bool primary_squeeze_pressed() const {
    return data_->primary_squeeze_pressed;
  }
  bool primary_squeeze_clicked() const {
    return data_->primary_squeeze_clicked;
  }
  inline void GetGamepadDataView(
      ::device::mojom::GamepadDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadGamepad(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::GamepadDataView, UserType>(),
    "Attempting to read the optional `gamepad` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadGamepad` instead "
    "of `ReadGamepad if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->gamepad.Get();
    return mojo::internal::Deserialize<::device::mojom::GamepadDataView>(
        pointer, output, context_);
  }
  inline void GetOverlayPointerPositionDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadOverlayPointerPosition(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::PointFDataView, UserType>(),
    "Attempting to read the optional `overlay_pointer_position` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadOverlayPointerPosition` instead "
    "of `ReadOverlayPointerPosition if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->overlay_pointer_position.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, context_);
  }
 private:
  internal::XRInputSourceState_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class VRFieldOfViewDataView {
 public:
  VRFieldOfViewDataView() {}

  VRFieldOfViewDataView(
      internal::VRFieldOfView_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  float up_degrees() const {
    return data_->up_degrees;
  }
  float down_degrees() const {
    return data_->down_degrees;
  }
  float left_degrees() const {
    return data_->left_degrees;
  }
  float right_degrees() const {
    return data_->right_degrees;
  }
 private:
  internal::VRFieldOfView_Data* data_ = nullptr;
};



class VRPoseDataView {
 public:
  VRPoseDataView() {}

  VRPoseDataView(
      internal::VRPose_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetOrientationDataView(
      ::gfx::mojom::QuaternionDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadOrientation(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::QuaternionDataView, UserType>(),
    "Attempting to read the optional `orientation` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadOrientation` instead "
    "of `ReadOrientation if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->orientation.Get();
    return mojo::internal::Deserialize<::gfx::mojom::QuaternionDataView>(
        pointer, output, context_);
  }
  inline void GetPositionDataView(
      ::gfx::mojom::Point3FDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPosition(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::Point3FDataView, UserType>(),
    "Attempting to read the optional `position` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPosition` instead "
    "of `ReadPosition if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->position.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Point3FDataView>(
        pointer, output, context_);
  }
  bool emulated_position() const {
    return data_->emulated_position;
  }
 private:
  internal::VRPose_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class PoseDataView {
 public:
  PoseDataView() {}

  PoseDataView(
      internal::Pose_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetOrientationDataView(
      ::gfx::mojom::QuaternionDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadOrientation(UserType* output) {
    
    auto* pointer = data_->orientation.Get();
    return mojo::internal::Deserialize<::gfx::mojom::QuaternionDataView>(
        pointer, output, context_);
  }
  inline void GetPositionDataView(
      ::gfx::mojom::Point3FDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPosition(UserType* output) {
    
    auto* pointer = data_->position.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Point3FDataView>(
        pointer, output, context_);
  }
 private:
  internal::Pose_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class XRRayDataView {
 public:
  XRRayDataView() {}

  XRRayDataView(
      internal::XRRay_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetOriginDataView(
      ::gfx::mojom::Point3FDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadOrigin(UserType* output) {
    
    auto* pointer = data_->origin.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Point3FDataView>(
        pointer, output, context_);
  }
  inline void GetDirectionDataView(
      ::gfx::mojom::Vector3dFDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDirection(UserType* output) {
    
    auto* pointer = data_->direction.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Vector3dFDataView>(
        pointer, output, context_);
  }
 private:
  internal::XRRay_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class XRHitResultDataView {
 public:
  XRHitResultDataView() {}

  XRHitResultDataView(
      internal::XRHitResult_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetMojoFromResultDataView(
      PoseDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadMojoFromResult(UserType* output) {
    
    auto* pointer = data_->mojo_from_result.Get();
    return mojo::internal::Deserialize<::device::mojom::PoseDataView>(
        pointer, output, context_);
  }
  uint64_t plane_id() const {
    return data_->plane_id;
  }
 private:
  internal::XRHitResult_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class VREyeParametersDataView {
 public:
  VREyeParametersDataView() {}

  VREyeParametersDataView(
      internal::VREyeParameters_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetFieldOfViewDataView(
      VRFieldOfViewDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadFieldOfView(UserType* output) {
    
    auto* pointer = data_->field_of_view.Get();
    return mojo::internal::Deserialize<::device::mojom::VRFieldOfViewDataView>(
        pointer, output, context_);
  }
  inline void GetHeadFromEyeDataView(
      ::gfx::mojom::TransformDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadHeadFromEye(UserType* output) {
    
    auto* pointer = data_->head_from_eye.Get();
    return mojo::internal::Deserialize<::gfx::mojom::TransformDataView>(
        pointer, output, context_);
  }
  uint32_t render_width() const {
    return data_->render_width;
  }
  uint32_t render_height() const {
    return data_->render_height;
  }
 private:
  internal::VREyeParameters_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class VRStageParametersDataView {
 public:
  VRStageParametersDataView() {}

  VRStageParametersDataView(
      internal::VRStageParameters_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetMojoFromFloorDataView(
      ::gfx::mojom::TransformDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadMojoFromFloor(UserType* output) {
    
    auto* pointer = data_->mojo_from_floor.Get();
    return mojo::internal::Deserialize<::gfx::mojom::TransformDataView>(
        pointer, output, context_);
  }
  inline void GetBoundsDataView(
      mojo::ArrayDataView<::gfx::mojom::Point3FDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadBounds(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::gfx::mojom::Point3FDataView>, UserType>(),
    "Attempting to read the optional `bounds` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBounds` instead "
    "of `ReadBounds if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->bounds.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gfx::mojom::Point3FDataView>>(
        pointer, output, context_);
  }
 private:
  internal::VRStageParameters_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class VRDisplayInfoDataView {
 public:
  VRDisplayInfoDataView() {}

  VRDisplayInfoDataView(
      internal::VRDisplayInfo_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetStageParametersDataView(
      VRStageParametersDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadStageParameters(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::VRStageParametersDataView, UserType>(),
    "Attempting to read the optional `stage_parameters` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadStageParameters` instead "
    "of `ReadStageParameters if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->stage_parameters.Get();
    return mojo::internal::Deserialize<::device::mojom::VRStageParametersDataView>(
        pointer, output, context_);
  }
  inline void GetLeftEyeDataView(
      VREyeParametersDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadLeftEye(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::VREyeParametersDataView, UserType>(),
    "Attempting to read the optional `left_eye` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLeftEye` instead "
    "of `ReadLeftEye if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->left_eye.Get();
    return mojo::internal::Deserialize<::device::mojom::VREyeParametersDataView>(
        pointer, output, context_);
  }
  inline void GetRightEyeDataView(
      VREyeParametersDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRightEye(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::VREyeParametersDataView, UserType>(),
    "Attempting to read the optional `right_eye` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRightEye` instead "
    "of `ReadRightEye if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->right_eye.Get();
    return mojo::internal::Deserialize<::device::mojom::VREyeParametersDataView>(
        pointer, output, context_);
  }
 private:
  internal::VRDisplayInfo_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class XRPresentationTransportOptionsDataView {
 public:
  XRPresentationTransportOptionsDataView() {}

  XRPresentationTransportOptionsDataView(
      internal::XRPresentationTransportOptions_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadTransportMethod(UserType* output) const {
    auto data_value = data_->transport_method;
    return mojo::internal::Deserialize<::device::mojom::XRPresentationTransportMethod>(
        data_value, output);
  }

  XRPresentationTransportMethod transport_method() const {
    return static_cast<XRPresentationTransportMethod>(data_->transport_method);
  }
  bool wait_for_transfer_notification() const {
    return data_->wait_for_transfer_notification;
  }
  bool wait_for_render_notification() const {
    return data_->wait_for_render_notification;
  }
  bool wait_for_gpu_fence() const {
    return data_->wait_for_gpu_fence;
  }
 private:
  internal::XRPresentationTransportOptions_Data* data_ = nullptr;
};



class XRPlanePointDataDataView {
 public:
  XRPlanePointDataDataView() {}

  XRPlanePointDataDataView(
      internal::XRPlanePointData_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  float x() const {
    return data_->x;
  }
  float z() const {
    return data_->z;
  }
 private:
  internal::XRPlanePointData_Data* data_ = nullptr;
};



class XRPlaneDataDataView {
 public:
  XRPlaneDataDataView() {}

  XRPlaneDataDataView(
      internal::XRPlaneData_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  uint64_t id() const {
    return data_->id;
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadOrientation(UserType* output) const {
    auto data_value = data_->orientation;
    return mojo::internal::Deserialize<::device::mojom::XRPlaneOrientation>(
        data_value, output);
  }

  XRPlaneOrientation orientation() const {
    return static_cast<XRPlaneOrientation>(data_->orientation);
  }
  inline void GetMojoFromPlaneDataView(
      PoseDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadMojoFromPlane(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::PoseDataView, UserType>(),
    "Attempting to read the optional `mojo_from_plane` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMojoFromPlane` instead "
    "of `ReadMojoFromPlane if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->mojo_from_plane.Get();
    return mojo::internal::Deserialize<::device::mojom::PoseDataView>(
        pointer, output, context_);
  }
  inline void GetPolygonDataView(
      mojo::ArrayDataView<XRPlanePointDataDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPolygon(UserType* output) {
    
    auto* pointer = data_->polygon.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::XRPlanePointDataDataView>>(
        pointer, output, context_);
  }
 private:
  internal::XRPlaneData_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class XRPlaneDetectionDataDataView {
 public:
  XRPlaneDetectionDataDataView() {}

  XRPlaneDetectionDataDataView(
      internal::XRPlaneDetectionData_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetAllPlanesIdsDataView(
      mojo::ArrayDataView<uint64_t>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadAllPlanesIds(UserType* output) {
    
    auto* pointer = data_->all_planes_ids.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint64_t>>(
        pointer, output, context_);
  }
  inline void GetUpdatedPlanesDataDataView(
      mojo::ArrayDataView<XRPlaneDataDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadUpdatedPlanesData(UserType* output) {
    
    auto* pointer = data_->updated_planes_data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::XRPlaneDataDataView>>(
        pointer, output, context_);
  }
 private:
  internal::XRPlaneDetectionData_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class XRAnchorDataDataView {
 public:
  XRAnchorDataDataView() {}

  XRAnchorDataDataView(
      internal::XRAnchorData_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  uint64_t id() const {
    return data_->id;
  }
  inline void GetMojoFromAnchorDataView(
      PoseDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadMojoFromAnchor(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::PoseDataView, UserType>(),
    "Attempting to read the optional `mojo_from_anchor` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMojoFromAnchor` instead "
    "of `ReadMojoFromAnchor if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->mojo_from_anchor.Get();
    return mojo::internal::Deserialize<::device::mojom::PoseDataView>(
        pointer, output, context_);
  }
 private:
  internal::XRAnchorData_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class XRAnchorsDataDataView {
 public:
  XRAnchorsDataDataView() {}

  XRAnchorsDataDataView(
      internal::XRAnchorsData_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetAllAnchorsIdsDataView(
      mojo::ArrayDataView<uint64_t>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadAllAnchorsIds(UserType* output) {
    
    auto* pointer = data_->all_anchors_ids.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint64_t>>(
        pointer, output, context_);
  }
  inline void GetUpdatedAnchorsDataDataView(
      mojo::ArrayDataView<XRAnchorDataDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadUpdatedAnchorsData(UserType* output) {
    
    auto* pointer = data_->updated_anchors_data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::XRAnchorDataDataView>>(
        pointer, output, context_);
  }
 private:
  internal::XRAnchorsData_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class XRHitTestSubscriptionResultDataDataView {
 public:
  XRHitTestSubscriptionResultDataDataView() {}

  XRHitTestSubscriptionResultDataDataView(
      internal::XRHitTestSubscriptionResultData_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  uint64_t subscription_id() const {
    return data_->subscription_id;
  }
  inline void GetHitTestResultsDataView(
      mojo::ArrayDataView<XRHitResultDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadHitTestResults(UserType* output) {
    
    auto* pointer = data_->hit_test_results.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::XRHitResultDataView>>(
        pointer, output, context_);
  }
 private:
  internal::XRHitTestSubscriptionResultData_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class XRHitTestTransientInputSubscriptionResultDataDataView {
 public:
  XRHitTestTransientInputSubscriptionResultDataDataView() {}

  XRHitTestTransientInputSubscriptionResultDataDataView(
      internal::XRHitTestTransientInputSubscriptionResultData_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  uint64_t subscription_id() const {
    return data_->subscription_id;
  }
  inline void GetInputSourceIdToHitTestResultsDataView(
      mojo::MapDataView<uint32_t, mojo::ArrayDataView<XRHitResultDataView>>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadInputSourceIdToHitTestResults(UserType* output) {
    
    auto* pointer = data_->input_source_id_to_hit_test_results.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<uint32_t, mojo::ArrayDataView<::device::mojom::XRHitResultDataView>>>(
        pointer, output, context_);
  }
 private:
  internal::XRHitTestTransientInputSubscriptionResultData_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class XRHitTestSubscriptionResultsDataDataView {
 public:
  XRHitTestSubscriptionResultsDataDataView() {}

  XRHitTestSubscriptionResultsDataDataView(
      internal::XRHitTestSubscriptionResultsData_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetResultsDataView(
      mojo::ArrayDataView<XRHitTestSubscriptionResultDataDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadResults(UserType* output) {
    
    auto* pointer = data_->results.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::XRHitTestSubscriptionResultDataDataView>>(
        pointer, output, context_);
  }
  inline void GetTransientInputResultsDataView(
      mojo::ArrayDataView<XRHitTestTransientInputSubscriptionResultDataDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadTransientInputResults(UserType* output) {
    
    auto* pointer = data_->transient_input_results.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::XRHitTestTransientInputSubscriptionResultDataDataView>>(
        pointer, output, context_);
  }
 private:
  internal::XRHitTestSubscriptionResultsData_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class RgbTupleF32DataView {
 public:
  RgbTupleF32DataView() {}

  RgbTupleF32DataView(
      internal::RgbTupleF32_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  float red() const {
    return data_->red;
  }
  float green() const {
    return data_->green;
  }
  float blue() const {
    return data_->blue;
  }
 private:
  internal::RgbTupleF32_Data* data_ = nullptr;
};



class XRSphericalHarmonicsDataView {
 public:
  XRSphericalHarmonicsDataView() {}

  XRSphericalHarmonicsDataView(
      internal::XRSphericalHarmonics_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetCoefficientsDataView(
      mojo::ArrayDataView<RgbTupleF32DataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadCoefficients(UserType* output) {
    
    auto* pointer = data_->coefficients.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::RgbTupleF32DataView>>(
        pointer, output, context_);
  }
 private:
  internal::XRSphericalHarmonics_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class RgbaTupleF16DataView {
 public:
  RgbaTupleF16DataView() {}

  RgbaTupleF16DataView(
      internal::RgbaTupleF16_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint16_t red() const {
    return data_->red;
  }
  uint16_t green() const {
    return data_->green;
  }
  uint16_t blue() const {
    return data_->blue;
  }
  uint16_t alpha() const {
    return data_->alpha;
  }
 private:
  internal::RgbaTupleF16_Data* data_ = nullptr;
};



class XRCubeMapDataView {
 public:
  XRCubeMapDataView() {}

  XRCubeMapDataView(
      internal::XRCubeMap_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  uint32_t width_and_height() const {
    return data_->width_and_height;
  }
  inline void GetPositiveXDataView(
      mojo::ArrayDataView<RgbaTupleF16DataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPositiveX(UserType* output) {
    
    auto* pointer = data_->positive_x.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::RgbaTupleF16DataView>>(
        pointer, output, context_);
  }
  inline void GetNegativeXDataView(
      mojo::ArrayDataView<RgbaTupleF16DataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadNegativeX(UserType* output) {
    
    auto* pointer = data_->negative_x.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::RgbaTupleF16DataView>>(
        pointer, output, context_);
  }
  inline void GetPositiveYDataView(
      mojo::ArrayDataView<RgbaTupleF16DataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPositiveY(UserType* output) {
    
    auto* pointer = data_->positive_y.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::RgbaTupleF16DataView>>(
        pointer, output, context_);
  }
  inline void GetNegativeYDataView(
      mojo::ArrayDataView<RgbaTupleF16DataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadNegativeY(UserType* output) {
    
    auto* pointer = data_->negative_y.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::RgbaTupleF16DataView>>(
        pointer, output, context_);
  }
  inline void GetPositiveZDataView(
      mojo::ArrayDataView<RgbaTupleF16DataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPositiveZ(UserType* output) {
    
    auto* pointer = data_->positive_z.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::RgbaTupleF16DataView>>(
        pointer, output, context_);
  }
  inline void GetNegativeZDataView(
      mojo::ArrayDataView<RgbaTupleF16DataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadNegativeZ(UserType* output) {
    
    auto* pointer = data_->negative_z.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::RgbaTupleF16DataView>>(
        pointer, output, context_);
  }
 private:
  internal::XRCubeMap_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class XRLightProbeDataView {
 public:
  XRLightProbeDataView() {}

  XRLightProbeDataView(
      internal::XRLightProbe_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetSphericalHarmonicsDataView(
      XRSphericalHarmonicsDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSphericalHarmonics(UserType* output) {
    
    auto* pointer = data_->spherical_harmonics.Get();
    return mojo::internal::Deserialize<::device::mojom::XRSphericalHarmonicsDataView>(
        pointer, output, context_);
  }
  inline void GetMainLightDirectionDataView(
      ::gfx::mojom::Vector3dFDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadMainLightDirection(UserType* output) {
    
    auto* pointer = data_->main_light_direction.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Vector3dFDataView>(
        pointer, output, context_);
  }
  inline void GetMainLightIntensityDataView(
      RgbTupleF32DataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadMainLightIntensity(UserType* output) {
    
    auto* pointer = data_->main_light_intensity.Get();
    return mojo::internal::Deserialize<::device::mojom::RgbTupleF32DataView>(
        pointer, output, context_);
  }
 private:
  internal::XRLightProbe_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class XRReflectionProbeDataView {
 public:
  XRReflectionProbeDataView() {}

  XRReflectionProbeDataView(
      internal::XRReflectionProbe_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetCubeMapDataView(
      XRCubeMapDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadCubeMap(UserType* output) {
    
    auto* pointer = data_->cube_map.Get();
    return mojo::internal::Deserialize<::device::mojom::XRCubeMapDataView>(
        pointer, output, context_);
  }
 private:
  internal::XRReflectionProbe_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class XRLightEstimationDataDataView {
 public:
  XRLightEstimationDataDataView() {}

  XRLightEstimationDataDataView(
      internal::XRLightEstimationData_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetLightProbeDataView(
      XRLightProbeDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadLightProbe(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::XRLightProbeDataView, UserType>(),
    "Attempting to read the optional `light_probe` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLightProbe` instead "
    "of `ReadLightProbe if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->light_probe.Get();
    return mojo::internal::Deserialize<::device::mojom::XRLightProbeDataView>(
        pointer, output, context_);
  }
  inline void GetReflectionProbeDataView(
      XRReflectionProbeDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadReflectionProbe(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::XRReflectionProbeDataView, UserType>(),
    "Attempting to read the optional `reflection_probe` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadReflectionProbe` instead "
    "of `ReadReflectionProbe if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->reflection_probe.Get();
    return mojo::internal::Deserialize<::device::mojom::XRReflectionProbeDataView>(
        pointer, output, context_);
  }
 private:
  internal::XRLightEstimationData_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class XRDepthDataStillValidDataView {
 public:
  XRDepthDataStillValidDataView() {}

  XRDepthDataStillValidDataView(
      internal::XRDepthDataStillValid_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::XRDepthDataStillValid_Data* data_ = nullptr;
};



class XRDepthDataUpdatedDataView {
 public:
  XRDepthDataUpdatedDataView() {}

  XRDepthDataUpdatedDataView(
      internal::XRDepthDataUpdated_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetTimeDeltaDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadTimeDelta(UserType* output) {
    
    auto* pointer = data_->time_delta.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, context_);
  }
  inline void GetPixelDataDataView(
      ::mojo_base::mojom::BigBufferDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPixelData(UserType* output) {
    
    auto* pointer = !data_->pixel_data.is_null() ? &data_->pixel_data : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::BigBufferDataView>(
        pointer, output, context_);
  }
  inline void GetNormTextureFromNormViewDataView(
      ::gfx::mojom::TransformDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadNormTextureFromNormView(UserType* output) {
    
    auto* pointer = data_->norm_texture_from_norm_view.Get();
    return mojo::internal::Deserialize<::gfx::mojom::TransformDataView>(
        pointer, output, context_);
  }
  inline void GetSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSize(UserType* output) {
    
    auto* pointer = data_->size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, context_);
  }
 private:
  internal::XRDepthDataUpdated_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class XRFrameDataDataView {
 public:
  XRFrameDataDataView() {}

  XRFrameDataDataView(
      internal::XRFrameData_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetPoseDataView(
      VRPoseDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPose(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::VRPoseDataView, UserType>(),
    "Attempting to read the optional `pose` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPose` instead "
    "of `ReadPose if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->pose.Get();
    return mojo::internal::Deserialize<::device::mojom::VRPoseDataView>(
        pointer, output, context_);
  }
  inline void GetTimeDeltaDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadTimeDelta(UserType* output) {
    
    auto* pointer = data_->time_delta.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, context_);
  }
  inline void GetBufferHolderDataView(
      ::gpu::mojom::MailboxHolderDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadBufferHolder(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gpu::mojom::MailboxHolderDataView, UserType>(),
    "Attempting to read the optional `buffer_holder` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBufferHolder` instead "
    "of `ReadBufferHolder if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->buffer_holder.Get();
    return mojo::internal::Deserialize<::gpu::mojom::MailboxHolderDataView>(
        pointer, output, context_);
  }
  inline void GetCameraImageBufferHolderDataView(
      ::gpu::mojom::MailboxHolderDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadCameraImageBufferHolder(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gpu::mojom::MailboxHolderDataView, UserType>(),
    "Attempting to read the optional `camera_image_buffer_holder` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCameraImageBufferHolder` instead "
    "of `ReadCameraImageBufferHolder if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->camera_image_buffer_holder.Get();
    return mojo::internal::Deserialize<::gpu::mojom::MailboxHolderDataView>(
        pointer, output, context_);
  }
  inline void GetDepthDataDataView(
      XRDepthDataDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDepthData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::XRDepthDataDataView, UserType>(),
    "Attempting to read the optional `depth_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDepthData` instead "
    "of `ReadDepthData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->depth_data.is_null() ? &data_->depth_data : nullptr;
    return mojo::internal::Deserialize<::device::mojom::XRDepthDataDataView>(
        pointer, output, context_);
  }
  bool mojo_space_reset() const {
    return data_->mojo_space_reset;
  }
  int16_t frame_id() const {
    return data_->frame_id;
  }
  inline void GetLeftEyeDataView(
      VREyeParametersDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadLeftEye(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::VREyeParametersDataView, UserType>(),
    "Attempting to read the optional `left_eye` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLeftEye` instead "
    "of `ReadLeftEye if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->left_eye.Get();
    return mojo::internal::Deserialize<::device::mojom::VREyeParametersDataView>(
        pointer, output, context_);
  }
  inline void GetRightEyeDataView(
      VREyeParametersDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRightEye(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::VREyeParametersDataView, UserType>(),
    "Attempting to read the optional `right_eye` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRightEye` instead "
    "of `ReadRightEye if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->right_eye.Get();
    return mojo::internal::Deserialize<::device::mojom::VREyeParametersDataView>(
        pointer, output, context_);
  }
  inline void GetInputStateDataView(
      mojo::ArrayDataView<XRInputSourceStateDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadInputState(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::device::mojom::XRInputSourceStateDataView>, UserType>(),
    "Attempting to read the optional `input_state` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInputState` instead "
    "of `ReadInputState if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->input_state.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::XRInputSourceStateDataView>>(
        pointer, output, context_);
  }
  bool stage_parameters_updated() const {
    return data_->stage_parameters_updated;
  }
  inline void GetStageParametersDataView(
      VRStageParametersDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadStageParameters(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::VRStageParametersDataView, UserType>(),
    "Attempting to read the optional `stage_parameters` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadStageParameters` instead "
    "of `ReadStageParameters if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->stage_parameters.Get();
    return mojo::internal::Deserialize<::device::mojom::VRStageParametersDataView>(
        pointer, output, context_);
  }
  inline void GetDetectedPlanesDataDataView(
      XRPlaneDetectionDataDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDetectedPlanesData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::XRPlaneDetectionDataDataView, UserType>(),
    "Attempting to read the optional `detected_planes_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDetectedPlanesData` instead "
    "of `ReadDetectedPlanesData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->detected_planes_data.Get();
    return mojo::internal::Deserialize<::device::mojom::XRPlaneDetectionDataDataView>(
        pointer, output, context_);
  }
  inline void GetAnchorsDataDataView(
      XRAnchorsDataDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadAnchorsData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::XRAnchorsDataDataView, UserType>(),
    "Attempting to read the optional `anchors_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAnchorsData` instead "
    "of `ReadAnchorsData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->anchors_data.Get();
    return mojo::internal::Deserialize<::device::mojom::XRAnchorsDataDataView>(
        pointer, output, context_);
  }
  inline void GetLightEstimationDataDataView(
      XRLightEstimationDataDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadLightEstimationData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::XRLightEstimationDataDataView, UserType>(),
    "Attempting to read the optional `light_estimation_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLightEstimationData` instead "
    "of `ReadLightEstimationData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->light_estimation_data.Get();
    return mojo::internal::Deserialize<::device::mojom::XRLightEstimationDataDataView>(
        pointer, output, context_);
  }
  inline void GetHitTestSubscriptionResultsDataView(
      XRHitTestSubscriptionResultsDataDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadHitTestSubscriptionResults(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::XRHitTestSubscriptionResultsDataDataView, UserType>(),
    "Attempting to read the optional `hit_test_subscription_results` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadHitTestSubscriptionResults` instead "
    "of `ReadHitTestSubscriptionResults if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->hit_test_subscription_results.Get();
    return mojo::internal::Deserialize<::device::mojom::XRHitTestSubscriptionResultsDataDataView>(
        pointer, output, context_);
  }
 private:
  internal::XRFrameData_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class RequestSessionSuccessDataView {
 public:
  RequestSessionSuccessDataView() {}

  RequestSessionSuccessDataView(
      internal::RequestSessionSuccess_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetSessionDataView(
      XRSessionDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSession(UserType* output) {
    
    auto* pointer = data_->session.Get();
    return mojo::internal::Deserialize<::device::mojom::XRSessionDataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  UserType TakeMetricsRecorder() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::device::mojom::XRSessionMetricsRecorderInterfaceBase>>(
            &data_->metrics_recorder, &result, context_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::RequestSessionSuccess_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class XRFrameDataRequestOptionsDataView {
 public:
  XRFrameDataRequestOptionsDataView() {}

  XRFrameDataRequestOptionsDataView(
      internal::XRFrameDataRequestOptions_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool include_lighting_estimation_data() const {
    return data_->include_lighting_estimation_data;
  }
 private:
  internal::XRFrameDataRequestOptions_Data* data_ = nullptr;
};



class XRNativeOriginInformationDataView {
 public:
  using Tag = internal::XRNativeOriginInformation_Data::XRNativeOriginInformation_Tag;

  XRNativeOriginInformationDataView() {}

  XRNativeOriginInformationDataView(
      internal::XRNativeOriginInformation_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_input_source_id() const { return data_->tag == Tag::INPUT_SOURCE_ID; }
  uint32_t input_source_id() const {
    DCHECK(is_input_source_id());
    return data_->data.f_input_source_id;
  }
  bool is_plane_id() const { return data_->tag == Tag::PLANE_ID; }
  uint64_t plane_id() const {
    DCHECK(is_plane_id());
    return data_->data.f_plane_id;
  }
  bool is_anchor_id() const { return data_->tag == Tag::ANCHOR_ID; }
  uint64_t anchor_id() const {
    DCHECK(is_anchor_id());
    return data_->data.f_anchor_id;
  }
  bool is_reference_space_type() const { return data_->tag == Tag::REFERENCE_SPACE_TYPE; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadReferenceSpaceType(UserType* output) const {
    DCHECK(is_reference_space_type());
    return mojo::internal::Deserialize<::device::mojom::XRReferenceSpaceType>(
        data_->data.f_reference_space_type, output);
  }

  XRReferenceSpaceType reference_space_type() const {
    DCHECK(is_reference_space_type());
    return static_cast<XRReferenceSpaceType>(
        data_->data.f_reference_space_type);
  }

 private:
  internal::XRNativeOriginInformation_Data* data_ = nullptr;
};



class XRDepthDataDataView {
 public:
  using Tag = internal::XRDepthData_Data::XRDepthData_Tag;

  XRDepthDataDataView() {}

  XRDepthDataDataView(
      internal::XRDepthData_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_data_still_valid() const { return data_->tag == Tag::DATA_STILL_VALID; }
  inline void GetDataStillValidDataView(
      XRDepthDataStillValidDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDataStillValid(UserType* output) {
    
    DCHECK(is_data_still_valid());
    return mojo::internal::Deserialize<::device::mojom::XRDepthDataStillValidDataView>(
        data_->data.f_data_still_valid.Get(), output, context_);
  }
  bool is_updated_depth_data() const { return data_->tag == Tag::UPDATED_DEPTH_DATA; }
  inline void GetUpdatedDepthDataDataView(
      XRDepthDataUpdatedDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadUpdatedDepthData(UserType* output) {
    
    DCHECK(is_updated_depth_data());
    return mojo::internal::Deserialize<::device::mojom::XRDepthDataUpdatedDataView>(
        data_->data.f_updated_depth_data.Get(), output, context_);
  }

 private:
  internal::XRDepthData_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class RequestSessionResultDataView {
 public:
  using Tag = internal::RequestSessionResult_Data::RequestSessionResult_Tag;

  RequestSessionResultDataView() {}

  RequestSessionResultDataView(
      internal::RequestSessionResult_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_success() const { return data_->tag == Tag::SUCCESS; }
  inline void GetSuccessDataView(
      RequestSessionSuccessDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSuccess(UserType* output) {
    
    DCHECK(is_success());
    return mojo::internal::Deserialize<::device::mojom::RequestSessionSuccessDataView>(
        data_->data.f_success.Get(), output, context_);
  }
  bool is_failure_reason() const { return data_->tag == Tag::FAILURE_REASON; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadFailureReason(UserType* output) const {
    DCHECK(is_failure_reason());
    return mojo::internal::Deserialize<::device::mojom::RequestSessionError>(
        data_->data.f_failure_reason, output);
  }

  RequestSessionError failure_reason() const {
    DCHECK(is_failure_reason());
    return static_cast<RequestSessionError>(
        data_->data.f_failure_reason);
  }

 private:
  internal::RequestSessionResult_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace device

namespace std {

template <>
struct hash<::device::mojom::XRDeviceId>
    : public mojo::internal::EnumHashImpl<::device::mojom::XRDeviceId> {};

template <>
struct hash<::device::mojom::XRHandedness>
    : public mojo::internal::EnumHashImpl<::device::mojom::XRHandedness> {};

template <>
struct hash<::device::mojom::XRTargetRayMode>
    : public mojo::internal::EnumHashImpl<::device::mojom::XRTargetRayMode> {};

template <>
struct hash<::device::mojom::XRSessionFeature>
    : public mojo::internal::EnumHashImpl<::device::mojom::XRSessionFeature> {};

template <>
struct hash<::device::mojom::XRSessionFeatureRequestStatus>
    : public mojo::internal::EnumHashImpl<::device::mojom::XRSessionFeatureRequestStatus> {};

template <>
struct hash<::device::mojom::XRSessionMode>
    : public mojo::internal::EnumHashImpl<::device::mojom::XRSessionMode> {};

template <>
struct hash<::device::mojom::XRPresentationTransportMethod>
    : public mojo::internal::EnumHashImpl<::device::mojom::XRPresentationTransportMethod> {};

template <>
struct hash<::device::mojom::XRReferenceSpaceType>
    : public mojo::internal::EnumHashImpl<::device::mojom::XRReferenceSpaceType> {};

template <>
struct hash<::device::mojom::XRPlaneOrientation>
    : public mojo::internal::EnumHashImpl<::device::mojom::XRPlaneOrientation> {};

template <>
struct hash<::device::mojom::RequestSessionError>
    : public mojo::internal::EnumHashImpl<::device::mojom::RequestSessionError> {};

template <>
struct hash<::device::mojom::XrCompatibleResult>
    : public mojo::internal::EnumHashImpl<::device::mojom::XrCompatibleResult> {};

template <>
struct hash<::device::mojom::CreateAnchorResult>
    : public mojo::internal::EnumHashImpl<::device::mojom::CreateAnchorResult> {};

template <>
struct hash<::device::mojom::SubscribeToHitTestResult>
    : public mojo::internal::EnumHashImpl<::device::mojom::SubscribeToHitTestResult> {};

template <>
struct hash<::device::mojom::EntityTypeForHitTest>
    : public mojo::internal::EnumHashImpl<::device::mojom::EntityTypeForHitTest> {};

template <>
struct hash<::device::mojom::XRVisibilityState>
    : public mojo::internal::EnumHashImpl<::device::mojom::XRVisibilityState> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::device::mojom::XRDeviceId, ::device::mojom::XRDeviceId> {
  static ::device::mojom::XRDeviceId ToMojom(::device::mojom::XRDeviceId input) { return input; }
  static bool FromMojom(::device::mojom::XRDeviceId input, ::device::mojom::XRDeviceId* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRDeviceId, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::XRDeviceId, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::device::mojom::XRDeviceId>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::device::mojom::XRHandedness, ::device::mojom::XRHandedness> {
  static ::device::mojom::XRHandedness ToMojom(::device::mojom::XRHandedness input) { return input; }
  static bool FromMojom(::device::mojom::XRHandedness input, ::device::mojom::XRHandedness* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRHandedness, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::XRHandedness, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::device::mojom::XRHandedness>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::device::mojom::XRTargetRayMode, ::device::mojom::XRTargetRayMode> {
  static ::device::mojom::XRTargetRayMode ToMojom(::device::mojom::XRTargetRayMode input) { return input; }
  static bool FromMojom(::device::mojom::XRTargetRayMode input, ::device::mojom::XRTargetRayMode* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRTargetRayMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::XRTargetRayMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::device::mojom::XRTargetRayMode>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::device::mojom::XRSessionFeature, ::device::mojom::XRSessionFeature> {
  static ::device::mojom::XRSessionFeature ToMojom(::device::mojom::XRSessionFeature input) { return input; }
  static bool FromMojom(::device::mojom::XRSessionFeature input, ::device::mojom::XRSessionFeature* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRSessionFeature, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::XRSessionFeature, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::device::mojom::XRSessionFeature>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::device::mojom::XRSessionFeatureRequestStatus, ::device::mojom::XRSessionFeatureRequestStatus> {
  static ::device::mojom::XRSessionFeatureRequestStatus ToMojom(::device::mojom::XRSessionFeatureRequestStatus input) { return input; }
  static bool FromMojom(::device::mojom::XRSessionFeatureRequestStatus input, ::device::mojom::XRSessionFeatureRequestStatus* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRSessionFeatureRequestStatus, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::XRSessionFeatureRequestStatus, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::device::mojom::XRSessionFeatureRequestStatus>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::device::mojom::XRSessionMode, ::device::mojom::XRSessionMode> {
  static ::device::mojom::XRSessionMode ToMojom(::device::mojom::XRSessionMode input) { return input; }
  static bool FromMojom(::device::mojom::XRSessionMode input, ::device::mojom::XRSessionMode* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRSessionMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::XRSessionMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::device::mojom::XRSessionMode>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::device::mojom::XRPresentationTransportMethod, ::device::mojom::XRPresentationTransportMethod> {
  static ::device::mojom::XRPresentationTransportMethod ToMojom(::device::mojom::XRPresentationTransportMethod input) { return input; }
  static bool FromMojom(::device::mojom::XRPresentationTransportMethod input, ::device::mojom::XRPresentationTransportMethod* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRPresentationTransportMethod, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::XRPresentationTransportMethod, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::device::mojom::XRPresentationTransportMethod>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::device::mojom::XRReferenceSpaceType, ::device::mojom::XRReferenceSpaceType> {
  static ::device::mojom::XRReferenceSpaceType ToMojom(::device::mojom::XRReferenceSpaceType input) { return input; }
  static bool FromMojom(::device::mojom::XRReferenceSpaceType input, ::device::mojom::XRReferenceSpaceType* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRReferenceSpaceType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::XRReferenceSpaceType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::device::mojom::XRReferenceSpaceType>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::device::mojom::XRPlaneOrientation, ::device::mojom::XRPlaneOrientation> {
  static ::device::mojom::XRPlaneOrientation ToMojom(::device::mojom::XRPlaneOrientation input) { return input; }
  static bool FromMojom(::device::mojom::XRPlaneOrientation input, ::device::mojom::XRPlaneOrientation* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRPlaneOrientation, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::XRPlaneOrientation, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::device::mojom::XRPlaneOrientation>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::device::mojom::RequestSessionError, ::device::mojom::RequestSessionError> {
  static ::device::mojom::RequestSessionError ToMojom(::device::mojom::RequestSessionError input) { return input; }
  static bool FromMojom(::device::mojom::RequestSessionError input, ::device::mojom::RequestSessionError* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::RequestSessionError, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::RequestSessionError, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::device::mojom::RequestSessionError>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::device::mojom::XrCompatibleResult, ::device::mojom::XrCompatibleResult> {
  static ::device::mojom::XrCompatibleResult ToMojom(::device::mojom::XrCompatibleResult input) { return input; }
  static bool FromMojom(::device::mojom::XrCompatibleResult input, ::device::mojom::XrCompatibleResult* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XrCompatibleResult, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::XrCompatibleResult, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::device::mojom::XrCompatibleResult>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::device::mojom::CreateAnchorResult, ::device::mojom::CreateAnchorResult> {
  static ::device::mojom::CreateAnchorResult ToMojom(::device::mojom::CreateAnchorResult input) { return input; }
  static bool FromMojom(::device::mojom::CreateAnchorResult input, ::device::mojom::CreateAnchorResult* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::CreateAnchorResult, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::CreateAnchorResult, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::device::mojom::CreateAnchorResult>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::device::mojom::SubscribeToHitTestResult, ::device::mojom::SubscribeToHitTestResult> {
  static ::device::mojom::SubscribeToHitTestResult ToMojom(::device::mojom::SubscribeToHitTestResult input) { return input; }
  static bool FromMojom(::device::mojom::SubscribeToHitTestResult input, ::device::mojom::SubscribeToHitTestResult* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::SubscribeToHitTestResult, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::SubscribeToHitTestResult, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::device::mojom::SubscribeToHitTestResult>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::device::mojom::EntityTypeForHitTest, ::device::mojom::EntityTypeForHitTest> {
  static ::device::mojom::EntityTypeForHitTest ToMojom(::device::mojom::EntityTypeForHitTest input) { return input; }
  static bool FromMojom(::device::mojom::EntityTypeForHitTest input, ::device::mojom::EntityTypeForHitTest* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::EntityTypeForHitTest, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::EntityTypeForHitTest, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::device::mojom::EntityTypeForHitTest>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::device::mojom::XRVisibilityState, ::device::mojom::XRVisibilityState> {
  static ::device::mojom::XRVisibilityState ToMojom(::device::mojom::XRVisibilityState input) { return input; }
  static bool FromMojom(::device::mojom::XRVisibilityState input, ::device::mojom::XRVisibilityState* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRVisibilityState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::XRVisibilityState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::device::mojom::XRVisibilityState>(input), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRSessionOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRSessionOptionsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::device::mojom::internal::XRSessionOptions_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    mojo::internal::Serialize<::device::mojom::XRSessionMode>(
        Traits::mode(input), &(*output)->mode);
    decltype(Traits::required_features(input)) in_required_features = Traits::required_features(input);
    typename decltype((*output)->required_features)::BaseType::BufferWriter
        required_features_writer;
    const mojo::internal::ContainerValidateParams required_features_validate_params(
        0, ::device::mojom::internal::XRSessionFeature_Data::Validate);
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::XRSessionFeature>>(
        in_required_features, buffer, &required_features_writer, &required_features_validate_params,
        context);
    (*output)->required_features.Set(
        required_features_writer.is_null() ? nullptr : required_features_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->required_features.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null required_features in XRSessionOptions struct");
    decltype(Traits::optional_features(input)) in_optional_features = Traits::optional_features(input);
    typename decltype((*output)->optional_features)::BaseType::BufferWriter
        optional_features_writer;
    const mojo::internal::ContainerValidateParams optional_features_validate_params(
        0, ::device::mojom::internal::XRSessionFeature_Data::Validate);
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::XRSessionFeature>>(
        in_optional_features, buffer, &optional_features_writer, &optional_features_validate_params,
        context);
    (*output)->optional_features.Set(
        optional_features_writer.is_null() ? nullptr : optional_features_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->optional_features.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null optional_features in XRSessionOptions struct");
  }

  static bool Deserialize(::device::mojom::internal::XRSessionOptions_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRSessionOptionsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRSessionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRSessionDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::device::mojom::internal::XRSession_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::data_provider(input)) in_data_provider = Traits::data_provider(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::XRFrameDataProviderInterfaceBase>>(
        in_data_provider, &(*output)->data_provider, context);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid((*output)->data_provider),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid data_provider in XRSession struct");
    decltype(Traits::client_receiver(input)) in_client_receiver = Traits::client_receiver(input);
    mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::XRSessionClientInterfaceBase>>(
        in_client_receiver, &(*output)->client_receiver, context);
    decltype(Traits::display_info(input)) in_display_info = Traits::display_info(input);
    typename decltype((*output)->display_info)::BaseType::BufferWriter
        display_info_writer;
    mojo::internal::Serialize<::device::mojom::VRDisplayInfoDataView>(
        in_display_info, buffer, &display_info_writer, context);
    (*output)->display_info.Set(
        display_info_writer.is_null() ? nullptr : display_info_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->display_info.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null display_info in XRSession struct");
    decltype(Traits::submit_frame_sink(input)) in_submit_frame_sink = Traits::submit_frame_sink(input);
    typename decltype((*output)->submit_frame_sink)::BaseType::BufferWriter
        submit_frame_sink_writer;
    mojo::internal::Serialize<::device::mojom::XRPresentationConnectionDataView>(
        in_submit_frame_sink, buffer, &submit_frame_sink_writer, context);
    (*output)->submit_frame_sink.Set(
        submit_frame_sink_writer.is_null() ? nullptr : submit_frame_sink_writer.data());
    decltype(Traits::enabled_features(input)) in_enabled_features = Traits::enabled_features(input);
    typename decltype((*output)->enabled_features)::BaseType::BufferWriter
        enabled_features_writer;
    const mojo::internal::ContainerValidateParams enabled_features_validate_params(
        0, ::device::mojom::internal::XRSessionFeature_Data::Validate);
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::XRSessionFeature>>(
        in_enabled_features, buffer, &enabled_features_writer, &enabled_features_validate_params,
        context);
    (*output)->enabled_features.Set(
        enabled_features_writer.is_null() ? nullptr : enabled_features_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->enabled_features.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null enabled_features in XRSession struct");
    (*output)->uses_input_eventing = Traits::uses_input_eventing(input);
    (*output)->default_framebuffer_scale = Traits::default_framebuffer_scale(input);
  }

  static bool Deserialize(::device::mojom::internal::XRSession_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRSessionDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRPresentationConnectionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRPresentationConnectionDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::device::mojom::internal::XRPresentationConnection_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::provider(input)) in_provider = Traits::provider(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::XRPresentationProviderInterfaceBase>>(
        in_provider, &(*output)->provider, context);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid((*output)->provider),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid provider in XRPresentationConnection struct");
    decltype(Traits::client_receiver(input)) in_client_receiver = Traits::client_receiver(input);
    mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::XRPresentationClientInterfaceBase>>(
        in_client_receiver, &(*output)->client_receiver, context);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid((*output)->client_receiver),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid client_receiver in XRPresentationConnection struct");
    decltype(Traits::transport_options(input)) in_transport_options = Traits::transport_options(input);
    typename decltype((*output)->transport_options)::BaseType::BufferWriter
        transport_options_writer;
    mojo::internal::Serialize<::device::mojom::XRPresentationTransportOptionsDataView>(
        in_transport_options, buffer, &transport_options_writer, context);
    (*output)->transport_options.Set(
        transport_options_writer.is_null() ? nullptr : transport_options_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->transport_options.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null transport_options in XRPresentationConnection struct");
  }

  static bool Deserialize(::device::mojom::internal::XRPresentationConnection_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRPresentationConnectionDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRInputSourceDescriptionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRInputSourceDescriptionDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::device::mojom::internal::XRInputSourceDescription_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    mojo::internal::Serialize<::device::mojom::XRTargetRayMode>(
        Traits::target_ray_mode(input), &(*output)->target_ray_mode);
    mojo::internal::Serialize<::device::mojom::XRHandedness>(
        Traits::handedness(input), &(*output)->handedness);
    decltype(Traits::input_from_pointer(input)) in_input_from_pointer = Traits::input_from_pointer(input);
    typename decltype((*output)->input_from_pointer)::BaseType::BufferWriter
        input_from_pointer_writer;
    mojo::internal::Serialize<::gfx::mojom::TransformDataView>(
        in_input_from_pointer, buffer, &input_from_pointer_writer, context);
    (*output)->input_from_pointer.Set(
        input_from_pointer_writer.is_null() ? nullptr : input_from_pointer_writer.data());
    decltype(Traits::profiles(input)) in_profiles = Traits::profiles(input);
    typename decltype((*output)->profiles)::BaseType::BufferWriter
        profiles_writer;
    const mojo::internal::ContainerValidateParams profiles_validate_params(
        0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
        in_profiles, buffer, &profiles_writer, &profiles_validate_params,
        context);
    (*output)->profiles.Set(
        profiles_writer.is_null() ? nullptr : profiles_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->profiles.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null profiles in XRInputSourceDescription struct");
  }

  static bool Deserialize(::device::mojom::internal::XRInputSourceDescription_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRInputSourceDescriptionDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRInputSourceStateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRInputSourceStateDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::device::mojom::internal::XRInputSourceState_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->source_id = Traits::source_id(input);
    decltype(Traits::description(input)) in_description = Traits::description(input);
    typename decltype((*output)->description)::BaseType::BufferWriter
        description_writer;
    mojo::internal::Serialize<::device::mojom::XRInputSourceDescriptionDataView>(
        in_description, buffer, &description_writer, context);
    (*output)->description.Set(
        description_writer.is_null() ? nullptr : description_writer.data());
    decltype(Traits::mojo_from_input(input)) in_mojo_from_input = Traits::mojo_from_input(input);
    typename decltype((*output)->mojo_from_input)::BaseType::BufferWriter
        mojo_from_input_writer;
    mojo::internal::Serialize<::gfx::mojom::TransformDataView>(
        in_mojo_from_input, buffer, &mojo_from_input_writer, context);
    (*output)->mojo_from_input.Set(
        mojo_from_input_writer.is_null() ? nullptr : mojo_from_input_writer.data());
    (*output)->emulated_position = Traits::emulated_position(input);
    (*output)->is_auxiliary = Traits::is_auxiliary(input);
    (*output)->primary_input_pressed = Traits::primary_input_pressed(input);
    (*output)->primary_input_clicked = Traits::primary_input_clicked(input);
    (*output)->primary_squeeze_pressed = Traits::primary_squeeze_pressed(input);
    (*output)->primary_squeeze_clicked = Traits::primary_squeeze_clicked(input);
    decltype(Traits::gamepad(input)) in_gamepad = Traits::gamepad(input);
    typename decltype((*output)->gamepad)::BaseType::BufferWriter
        gamepad_writer;
    mojo::internal::Serialize<::device::mojom::GamepadDataView>(
        in_gamepad, buffer, &gamepad_writer, context);
    (*output)->gamepad.Set(
        gamepad_writer.is_null() ? nullptr : gamepad_writer.data());
    decltype(Traits::overlay_pointer_position(input)) in_overlay_pointer_position = Traits::overlay_pointer_position(input);
    typename decltype((*output)->overlay_pointer_position)::BaseType::BufferWriter
        overlay_pointer_position_writer;
    mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
        in_overlay_pointer_position, buffer, &overlay_pointer_position_writer, context);
    (*output)->overlay_pointer_position.Set(
        overlay_pointer_position_writer.is_null() ? nullptr : overlay_pointer_position_writer.data());
  }

  static bool Deserialize(::device::mojom::internal::XRInputSourceState_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRInputSourceStateDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::VRFieldOfViewDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::VRFieldOfViewDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::device::mojom::internal::VRFieldOfView_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->up_degrees = Traits::up_degrees(input);
    (*output)->down_degrees = Traits::down_degrees(input);
    (*output)->left_degrees = Traits::left_degrees(input);
    (*output)->right_degrees = Traits::right_degrees(input);
  }

  static bool Deserialize(::device::mojom::internal::VRFieldOfView_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::VRFieldOfViewDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::VRPoseDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::VRPoseDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::device::mojom::internal::VRPose_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::orientation(input)) in_orientation = Traits::orientation(input);
    typename decltype((*output)->orientation)::BaseType::BufferWriter
        orientation_writer;
    mojo::internal::Serialize<::gfx::mojom::QuaternionDataView>(
        in_orientation, buffer, &orientation_writer, context);
    (*output)->orientation.Set(
        orientation_writer.is_null() ? nullptr : orientation_writer.data());
    decltype(Traits::position(input)) in_position = Traits::position(input);
    typename decltype((*output)->position)::BaseType::BufferWriter
        position_writer;
    mojo::internal::Serialize<::gfx::mojom::Point3FDataView>(
        in_position, buffer, &position_writer, context);
    (*output)->position.Set(
        position_writer.is_null() ? nullptr : position_writer.data());
    (*output)->emulated_position = Traits::emulated_position(input);
  }

  static bool Deserialize(::device::mojom::internal::VRPose_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::VRPoseDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::PoseDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::PoseDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::device::mojom::internal::Pose_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::orientation(input)) in_orientation = Traits::orientation(input);
    typename decltype((*output)->orientation)::BaseType::BufferWriter
        orientation_writer;
    mojo::internal::Serialize<::gfx::mojom::QuaternionDataView>(
        in_orientation, buffer, &orientation_writer, context);
    (*output)->orientation.Set(
        orientation_writer.is_null() ? nullptr : orientation_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->orientation.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null orientation in Pose struct");
    decltype(Traits::position(input)) in_position = Traits::position(input);
    typename decltype((*output)->position)::BaseType::BufferWriter
        position_writer;
    mojo::internal::Serialize<::gfx::mojom::Point3FDataView>(
        in_position, buffer, &position_writer, context);
    (*output)->position.Set(
        position_writer.is_null() ? nullptr : position_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->position.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null position in Pose struct");
  }

  static bool Deserialize(::device::mojom::internal::Pose_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::PoseDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRRayDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRRayDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::device::mojom::internal::XRRay_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::origin(input)) in_origin = Traits::origin(input);
    typename decltype((*output)->origin)::BaseType::BufferWriter
        origin_writer;
    mojo::internal::Serialize<::gfx::mojom::Point3FDataView>(
        in_origin, buffer, &origin_writer, context);
    (*output)->origin.Set(
        origin_writer.is_null() ? nullptr : origin_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->origin.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null origin in XRRay struct");
    decltype(Traits::direction(input)) in_direction = Traits::direction(input);
    typename decltype((*output)->direction)::BaseType::BufferWriter
        direction_writer;
    mojo::internal::Serialize<::gfx::mojom::Vector3dFDataView>(
        in_direction, buffer, &direction_writer, context);
    (*output)->direction.Set(
        direction_writer.is_null() ? nullptr : direction_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->direction.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null direction in XRRay struct");
  }

  static bool Deserialize(::device::mojom::internal::XRRay_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRRayDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRHitResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRHitResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::device::mojom::internal::XRHitResult_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::mojo_from_result(input)) in_mojo_from_result = Traits::mojo_from_result(input);
    typename decltype((*output)->mojo_from_result)::BaseType::BufferWriter
        mojo_from_result_writer;
    mojo::internal::Serialize<::device::mojom::PoseDataView>(
        in_mojo_from_result, buffer, &mojo_from_result_writer, context);
    (*output)->mojo_from_result.Set(
        mojo_from_result_writer.is_null() ? nullptr : mojo_from_result_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->mojo_from_result.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null mojo_from_result in XRHitResult struct");
    (*output)->plane_id = Traits::plane_id(input);
  }

  static bool Deserialize(::device::mojom::internal::XRHitResult_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRHitResultDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::VREyeParametersDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::VREyeParametersDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::device::mojom::internal::VREyeParameters_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::field_of_view(input)) in_field_of_view = Traits::field_of_view(input);
    typename decltype((*output)->field_of_view)::BaseType::BufferWriter
        field_of_view_writer;
    mojo::internal::Serialize<::device::mojom::VRFieldOfViewDataView>(
        in_field_of_view, buffer, &field_of_view_writer, context);
    (*output)->field_of_view.Set(
        field_of_view_writer.is_null() ? nullptr : field_of_view_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->field_of_view.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null field_of_view in VREyeParameters struct");
    decltype(Traits::head_from_eye(input)) in_head_from_eye = Traits::head_from_eye(input);
    typename decltype((*output)->head_from_eye)::BaseType::BufferWriter
        head_from_eye_writer;
    mojo::internal::Serialize<::gfx::mojom::TransformDataView>(
        in_head_from_eye, buffer, &head_from_eye_writer, context);
    (*output)->head_from_eye.Set(
        head_from_eye_writer.is_null() ? nullptr : head_from_eye_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->head_from_eye.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null head_from_eye in VREyeParameters struct");
    (*output)->render_width = Traits::render_width(input);
    (*output)->render_height = Traits::render_height(input);
  }

  static bool Deserialize(::device::mojom::internal::VREyeParameters_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::VREyeParametersDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::VRStageParametersDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::VRStageParametersDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::device::mojom::internal::VRStageParameters_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::mojo_from_floor(input)) in_mojo_from_floor = Traits::mojo_from_floor(input);
    typename decltype((*output)->mojo_from_floor)::BaseType::BufferWriter
        mojo_from_floor_writer;
    mojo::internal::Serialize<::gfx::mojom::TransformDataView>(
        in_mojo_from_floor, buffer, &mojo_from_floor_writer, context);
    (*output)->mojo_from_floor.Set(
        mojo_from_floor_writer.is_null() ? nullptr : mojo_from_floor_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->mojo_from_floor.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null mojo_from_floor in VRStageParameters struct");
    decltype(Traits::bounds(input)) in_bounds = Traits::bounds(input);
    typename decltype((*output)->bounds)::BaseType::BufferWriter
        bounds_writer;
    const mojo::internal::ContainerValidateParams bounds_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::Point3FDataView>>(
        in_bounds, buffer, &bounds_writer, &bounds_validate_params,
        context);
    (*output)->bounds.Set(
        bounds_writer.is_null() ? nullptr : bounds_writer.data());
  }

  static bool Deserialize(::device::mojom::internal::VRStageParameters_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::VRStageParametersDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::VRDisplayInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::VRDisplayInfoDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::device::mojom::internal::VRDisplayInfo_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::stage_parameters(input)) in_stage_parameters = Traits::stage_parameters(input);
    typename decltype((*output)->stage_parameters)::BaseType::BufferWriter
        stage_parameters_writer;
    mojo::internal::Serialize<::device::mojom::VRStageParametersDataView>(
        in_stage_parameters, buffer, &stage_parameters_writer, context);
    (*output)->stage_parameters.Set(
        stage_parameters_writer.is_null() ? nullptr : stage_parameters_writer.data());
    decltype(Traits::left_eye(input)) in_left_eye = Traits::left_eye(input);
    typename decltype((*output)->left_eye)::BaseType::BufferWriter
        left_eye_writer;
    mojo::internal::Serialize<::device::mojom::VREyeParametersDataView>(
        in_left_eye, buffer, &left_eye_writer, context);
    (*output)->left_eye.Set(
        left_eye_writer.is_null() ? nullptr : left_eye_writer.data());
    decltype(Traits::right_eye(input)) in_right_eye = Traits::right_eye(input);
    typename decltype((*output)->right_eye)::BaseType::BufferWriter
        right_eye_writer;
    mojo::internal::Serialize<::device::mojom::VREyeParametersDataView>(
        in_right_eye, buffer, &right_eye_writer, context);
    (*output)->right_eye.Set(
        right_eye_writer.is_null() ? nullptr : right_eye_writer.data());
  }

  static bool Deserialize(::device::mojom::internal::VRDisplayInfo_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::VRDisplayInfoDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRPresentationTransportOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRPresentationTransportOptionsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::device::mojom::internal::XRPresentationTransportOptions_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    mojo::internal::Serialize<::device::mojom::XRPresentationTransportMethod>(
        Traits::transport_method(input), &(*output)->transport_method);
    (*output)->wait_for_transfer_notification = Traits::wait_for_transfer_notification(input);
    (*output)->wait_for_render_notification = Traits::wait_for_render_notification(input);
    (*output)->wait_for_gpu_fence = Traits::wait_for_gpu_fence(input);
  }

  static bool Deserialize(::device::mojom::internal::XRPresentationTransportOptions_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRPresentationTransportOptionsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRPlanePointDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRPlanePointDataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::device::mojom::internal::XRPlanePointData_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->x = Traits::x(input);
    (*output)->z = Traits::z(input);
  }

  static bool Deserialize(::device::mojom::internal::XRPlanePointData_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRPlanePointDataDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRPlaneDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRPlaneDataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::device::mojom::internal::XRPlaneData_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->id = Traits::id(input);
    mojo::internal::Serialize<::device::mojom::XRPlaneOrientation>(
        Traits::orientation(input), &(*output)->orientation);
    decltype(Traits::mojo_from_plane(input)) in_mojo_from_plane = Traits::mojo_from_plane(input);
    typename decltype((*output)->mojo_from_plane)::BaseType::BufferWriter
        mojo_from_plane_writer;
    mojo::internal::Serialize<::device::mojom::PoseDataView>(
        in_mojo_from_plane, buffer, &mojo_from_plane_writer, context);
    (*output)->mojo_from_plane.Set(
        mojo_from_plane_writer.is_null() ? nullptr : mojo_from_plane_writer.data());
    decltype(Traits::polygon(input)) in_polygon = Traits::polygon(input);
    typename decltype((*output)->polygon)::BaseType::BufferWriter
        polygon_writer;
    const mojo::internal::ContainerValidateParams polygon_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::XRPlanePointDataDataView>>(
        in_polygon, buffer, &polygon_writer, &polygon_validate_params,
        context);
    (*output)->polygon.Set(
        polygon_writer.is_null() ? nullptr : polygon_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->polygon.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null polygon in XRPlaneData struct");
  }

  static bool Deserialize(::device::mojom::internal::XRPlaneData_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRPlaneDataDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRPlaneDetectionDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRPlaneDetectionDataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::device::mojom::internal::XRPlaneDetectionData_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::all_planes_ids(input)) in_all_planes_ids = Traits::all_planes_ids(input);
    typename decltype((*output)->all_planes_ids)::BaseType::BufferWriter
        all_planes_ids_writer;
    const mojo::internal::ContainerValidateParams all_planes_ids_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<uint64_t>>(
        in_all_planes_ids, buffer, &all_planes_ids_writer, &all_planes_ids_validate_params,
        context);
    (*output)->all_planes_ids.Set(
        all_planes_ids_writer.is_null() ? nullptr : all_planes_ids_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->all_planes_ids.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null all_planes_ids in XRPlaneDetectionData struct");
    decltype(Traits::updated_planes_data(input)) in_updated_planes_data = Traits::updated_planes_data(input);
    typename decltype((*output)->updated_planes_data)::BaseType::BufferWriter
        updated_planes_data_writer;
    const mojo::internal::ContainerValidateParams updated_planes_data_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::XRPlaneDataDataView>>(
        in_updated_planes_data, buffer, &updated_planes_data_writer, &updated_planes_data_validate_params,
        context);
    (*output)->updated_planes_data.Set(
        updated_planes_data_writer.is_null() ? nullptr : updated_planes_data_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->updated_planes_data.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null updated_planes_data in XRPlaneDetectionData struct");
  }

  static bool Deserialize(::device::mojom::internal::XRPlaneDetectionData_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRPlaneDetectionDataDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRAnchorDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRAnchorDataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::device::mojom::internal::XRAnchorData_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->id = Traits::id(input);
    decltype(Traits::mojo_from_anchor(input)) in_mojo_from_anchor = Traits::mojo_from_anchor(input);
    typename decltype((*output)->mojo_from_anchor)::BaseType::BufferWriter
        mojo_from_anchor_writer;
    mojo::internal::Serialize<::device::mojom::PoseDataView>(
        in_mojo_from_anchor, buffer, &mojo_from_anchor_writer, context);
    (*output)->mojo_from_anchor.Set(
        mojo_from_anchor_writer.is_null() ? nullptr : mojo_from_anchor_writer.data());
  }

  static bool Deserialize(::device::mojom::internal::XRAnchorData_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRAnchorDataDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRAnchorsDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRAnchorsDataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::device::mojom::internal::XRAnchorsData_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::all_anchors_ids(input)) in_all_anchors_ids = Traits::all_anchors_ids(input);
    typename decltype((*output)->all_anchors_ids)::BaseType::BufferWriter
        all_anchors_ids_writer;
    const mojo::internal::ContainerValidateParams all_anchors_ids_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<uint64_t>>(
        in_all_anchors_ids, buffer, &all_anchors_ids_writer, &all_anchors_ids_validate_params,
        context);
    (*output)->all_anchors_ids.Set(
        all_anchors_ids_writer.is_null() ? nullptr : all_anchors_ids_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->all_anchors_ids.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null all_anchors_ids in XRAnchorsData struct");
    decltype(Traits::updated_anchors_data(input)) in_updated_anchors_data = Traits::updated_anchors_data(input);
    typename decltype((*output)->updated_anchors_data)::BaseType::BufferWriter
        updated_anchors_data_writer;
    const mojo::internal::ContainerValidateParams updated_anchors_data_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::XRAnchorDataDataView>>(
        in_updated_anchors_data, buffer, &updated_anchors_data_writer, &updated_anchors_data_validate_params,
        context);
    (*output)->updated_anchors_data.Set(
        updated_anchors_data_writer.is_null() ? nullptr : updated_anchors_data_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->updated_anchors_data.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null updated_anchors_data in XRAnchorsData struct");
  }

  static bool Deserialize(::device::mojom::internal::XRAnchorsData_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRAnchorsDataDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRHitTestSubscriptionResultDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRHitTestSubscriptionResultDataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::device::mojom::internal::XRHitTestSubscriptionResultData_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->subscription_id = Traits::subscription_id(input);
    decltype(Traits::hit_test_results(input)) in_hit_test_results = Traits::hit_test_results(input);
    typename decltype((*output)->hit_test_results)::BaseType::BufferWriter
        hit_test_results_writer;
    const mojo::internal::ContainerValidateParams hit_test_results_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::XRHitResultDataView>>(
        in_hit_test_results, buffer, &hit_test_results_writer, &hit_test_results_validate_params,
        context);
    (*output)->hit_test_results.Set(
        hit_test_results_writer.is_null() ? nullptr : hit_test_results_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->hit_test_results.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null hit_test_results in XRHitTestSubscriptionResultData struct");
  }

  static bool Deserialize(::device::mojom::internal::XRHitTestSubscriptionResultData_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRHitTestSubscriptionResultDataDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRHitTestTransientInputSubscriptionResultDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRHitTestTransientInputSubscriptionResultDataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::device::mojom::internal::XRHitTestTransientInputSubscriptionResultData_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->subscription_id = Traits::subscription_id(input);
    decltype(Traits::input_source_id_to_hit_test_results(input)) in_input_source_id_to_hit_test_results = Traits::input_source_id_to_hit_test_results(input);
    typename decltype((*output)->input_source_id_to_hit_test_results)::BaseType::BufferWriter
        input_source_id_to_hit_test_results_writer;
    const mojo::internal::ContainerValidateParams input_source_id_to_hit_test_results_validate_params(
        new mojo::internal::ContainerValidateParams(0, false, nullptr), new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)));
    mojo::internal::Serialize<mojo::MapDataView<uint32_t, mojo::ArrayDataView<::device::mojom::XRHitResultDataView>>>(
        in_input_source_id_to_hit_test_results, buffer, &input_source_id_to_hit_test_results_writer, &input_source_id_to_hit_test_results_validate_params,
        context);
    (*output)->input_source_id_to_hit_test_results.Set(
        input_source_id_to_hit_test_results_writer.is_null() ? nullptr : input_source_id_to_hit_test_results_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->input_source_id_to_hit_test_results.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null input_source_id_to_hit_test_results in XRHitTestTransientInputSubscriptionResultData struct");
  }

  static bool Deserialize(::device::mojom::internal::XRHitTestTransientInputSubscriptionResultData_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRHitTestTransientInputSubscriptionResultDataDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRHitTestSubscriptionResultsDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRHitTestSubscriptionResultsDataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::device::mojom::internal::XRHitTestSubscriptionResultsData_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::results(input)) in_results = Traits::results(input);
    typename decltype((*output)->results)::BaseType::BufferWriter
        results_writer;
    const mojo::internal::ContainerValidateParams results_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::XRHitTestSubscriptionResultDataDataView>>(
        in_results, buffer, &results_writer, &results_validate_params,
        context);
    (*output)->results.Set(
        results_writer.is_null() ? nullptr : results_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->results.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null results in XRHitTestSubscriptionResultsData struct");
    decltype(Traits::transient_input_results(input)) in_transient_input_results = Traits::transient_input_results(input);
    typename decltype((*output)->transient_input_results)::BaseType::BufferWriter
        transient_input_results_writer;
    const mojo::internal::ContainerValidateParams transient_input_results_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::XRHitTestTransientInputSubscriptionResultDataDataView>>(
        in_transient_input_results, buffer, &transient_input_results_writer, &transient_input_results_validate_params,
        context);
    (*output)->transient_input_results.Set(
        transient_input_results_writer.is_null() ? nullptr : transient_input_results_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->transient_input_results.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null transient_input_results in XRHitTestSubscriptionResultsData struct");
  }

  static bool Deserialize(::device::mojom::internal::XRHitTestSubscriptionResultsData_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRHitTestSubscriptionResultsDataDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::RgbTupleF32DataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::RgbTupleF32DataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::device::mojom::internal::RgbTupleF32_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->red = Traits::red(input);
    (*output)->green = Traits::green(input);
    (*output)->blue = Traits::blue(input);
  }

  static bool Deserialize(::device::mojom::internal::RgbTupleF32_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::RgbTupleF32DataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRSphericalHarmonicsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRSphericalHarmonicsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::device::mojom::internal::XRSphericalHarmonics_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::coefficients(input)) in_coefficients = Traits::coefficients(input);
    typename decltype((*output)->coefficients)::BaseType::BufferWriter
        coefficients_writer;
    const mojo::internal::ContainerValidateParams coefficients_validate_params(
        9, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::RgbTupleF32DataView>>(
        in_coefficients, buffer, &coefficients_writer, &coefficients_validate_params,
        context);
    (*output)->coefficients.Set(
        coefficients_writer.is_null() ? nullptr : coefficients_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->coefficients.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null coefficients in XRSphericalHarmonics struct");
  }

  static bool Deserialize(::device::mojom::internal::XRSphericalHarmonics_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRSphericalHarmonicsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::RgbaTupleF16DataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::RgbaTupleF16DataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::device::mojom::internal::RgbaTupleF16_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->red = Traits::red(input);
    (*output)->green = Traits::green(input);
    (*output)->blue = Traits::blue(input);
    (*output)->alpha = Traits::alpha(input);
  }

  static bool Deserialize(::device::mojom::internal::RgbaTupleF16_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::RgbaTupleF16DataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRCubeMapDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRCubeMapDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::device::mojom::internal::XRCubeMap_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->width_and_height = Traits::width_and_height(input);
    decltype(Traits::positive_x(input)) in_positive_x = Traits::positive_x(input);
    typename decltype((*output)->positive_x)::BaseType::BufferWriter
        positive_x_writer;
    const mojo::internal::ContainerValidateParams positive_x_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::RgbaTupleF16DataView>>(
        in_positive_x, buffer, &positive_x_writer, &positive_x_validate_params,
        context);
    (*output)->positive_x.Set(
        positive_x_writer.is_null() ? nullptr : positive_x_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->positive_x.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null positive_x in XRCubeMap struct");
    decltype(Traits::negative_x(input)) in_negative_x = Traits::negative_x(input);
    typename decltype((*output)->negative_x)::BaseType::BufferWriter
        negative_x_writer;
    const mojo::internal::ContainerValidateParams negative_x_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::RgbaTupleF16DataView>>(
        in_negative_x, buffer, &negative_x_writer, &negative_x_validate_params,
        context);
    (*output)->negative_x.Set(
        negative_x_writer.is_null() ? nullptr : negative_x_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->negative_x.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null negative_x in XRCubeMap struct");
    decltype(Traits::positive_y(input)) in_positive_y = Traits::positive_y(input);
    typename decltype((*output)->positive_y)::BaseType::BufferWriter
        positive_y_writer;
    const mojo::internal::ContainerValidateParams positive_y_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::RgbaTupleF16DataView>>(
        in_positive_y, buffer, &positive_y_writer, &positive_y_validate_params,
        context);
    (*output)->positive_y.Set(
        positive_y_writer.is_null() ? nullptr : positive_y_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->positive_y.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null positive_y in XRCubeMap struct");
    decltype(Traits::negative_y(input)) in_negative_y = Traits::negative_y(input);
    typename decltype((*output)->negative_y)::BaseType::BufferWriter
        negative_y_writer;
    const mojo::internal::ContainerValidateParams negative_y_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::RgbaTupleF16DataView>>(
        in_negative_y, buffer, &negative_y_writer, &negative_y_validate_params,
        context);
    (*output)->negative_y.Set(
        negative_y_writer.is_null() ? nullptr : negative_y_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->negative_y.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null negative_y in XRCubeMap struct");
    decltype(Traits::positive_z(input)) in_positive_z = Traits::positive_z(input);
    typename decltype((*output)->positive_z)::BaseType::BufferWriter
        positive_z_writer;
    const mojo::internal::ContainerValidateParams positive_z_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::RgbaTupleF16DataView>>(
        in_positive_z, buffer, &positive_z_writer, &positive_z_validate_params,
        context);
    (*output)->positive_z.Set(
        positive_z_writer.is_null() ? nullptr : positive_z_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->positive_z.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null positive_z in XRCubeMap struct");
    decltype(Traits::negative_z(input)) in_negative_z = Traits::negative_z(input);
    typename decltype((*output)->negative_z)::BaseType::BufferWriter
        negative_z_writer;
    const mojo::internal::ContainerValidateParams negative_z_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::RgbaTupleF16DataView>>(
        in_negative_z, buffer, &negative_z_writer, &negative_z_validate_params,
        context);
    (*output)->negative_z.Set(
        negative_z_writer.is_null() ? nullptr : negative_z_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->negative_z.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null negative_z in XRCubeMap struct");
  }

  static bool Deserialize(::device::mojom::internal::XRCubeMap_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRCubeMapDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRLightProbeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRLightProbeDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::device::mojom::internal::XRLightProbe_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::spherical_harmonics(input)) in_spherical_harmonics = Traits::spherical_harmonics(input);
    typename decltype((*output)->spherical_harmonics)::BaseType::BufferWriter
        spherical_harmonics_writer;
    mojo::internal::Serialize<::device::mojom::XRSphericalHarmonicsDataView>(
        in_spherical_harmonics, buffer, &spherical_harmonics_writer, context);
    (*output)->spherical_harmonics.Set(
        spherical_harmonics_writer.is_null() ? nullptr : spherical_harmonics_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->spherical_harmonics.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null spherical_harmonics in XRLightProbe struct");
    decltype(Traits::main_light_direction(input)) in_main_light_direction = Traits::main_light_direction(input);
    typename decltype((*output)->main_light_direction)::BaseType::BufferWriter
        main_light_direction_writer;
    mojo::internal::Serialize<::gfx::mojom::Vector3dFDataView>(
        in_main_light_direction, buffer, &main_light_direction_writer, context);
    (*output)->main_light_direction.Set(
        main_light_direction_writer.is_null() ? nullptr : main_light_direction_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->main_light_direction.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null main_light_direction in XRLightProbe struct");
    decltype(Traits::main_light_intensity(input)) in_main_light_intensity = Traits::main_light_intensity(input);
    typename decltype((*output)->main_light_intensity)::BaseType::BufferWriter
        main_light_intensity_writer;
    mojo::internal::Serialize<::device::mojom::RgbTupleF32DataView>(
        in_main_light_intensity, buffer, &main_light_intensity_writer, context);
    (*output)->main_light_intensity.Set(
        main_light_intensity_writer.is_null() ? nullptr : main_light_intensity_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->main_light_intensity.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null main_light_intensity in XRLightProbe struct");
  }

  static bool Deserialize(::device::mojom::internal::XRLightProbe_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRLightProbeDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRReflectionProbeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRReflectionProbeDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::device::mojom::internal::XRReflectionProbe_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::cube_map(input)) in_cube_map = Traits::cube_map(input);
    typename decltype((*output)->cube_map)::BaseType::BufferWriter
        cube_map_writer;
    mojo::internal::Serialize<::device::mojom::XRCubeMapDataView>(
        in_cube_map, buffer, &cube_map_writer, context);
    (*output)->cube_map.Set(
        cube_map_writer.is_null() ? nullptr : cube_map_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->cube_map.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null cube_map in XRReflectionProbe struct");
  }

  static bool Deserialize(::device::mojom::internal::XRReflectionProbe_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRReflectionProbeDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRLightEstimationDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRLightEstimationDataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::device::mojom::internal::XRLightEstimationData_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::light_probe(input)) in_light_probe = Traits::light_probe(input);
    typename decltype((*output)->light_probe)::BaseType::BufferWriter
        light_probe_writer;
    mojo::internal::Serialize<::device::mojom::XRLightProbeDataView>(
        in_light_probe, buffer, &light_probe_writer, context);
    (*output)->light_probe.Set(
        light_probe_writer.is_null() ? nullptr : light_probe_writer.data());
    decltype(Traits::reflection_probe(input)) in_reflection_probe = Traits::reflection_probe(input);
    typename decltype((*output)->reflection_probe)::BaseType::BufferWriter
        reflection_probe_writer;
    mojo::internal::Serialize<::device::mojom::XRReflectionProbeDataView>(
        in_reflection_probe, buffer, &reflection_probe_writer, context);
    (*output)->reflection_probe.Set(
        reflection_probe_writer.is_null() ? nullptr : reflection_probe_writer.data());
  }

  static bool Deserialize(::device::mojom::internal::XRLightEstimationData_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRLightEstimationDataDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRDepthDataStillValidDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRDepthDataStillValidDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::device::mojom::internal::XRDepthDataStillValid_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
  }

  static bool Deserialize(::device::mojom::internal::XRDepthDataStillValid_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRDepthDataStillValidDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRDepthDataUpdatedDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRDepthDataUpdatedDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::device::mojom::internal::XRDepthDataUpdated_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::time_delta(input)) in_time_delta = Traits::time_delta(input);
    typename decltype((*output)->time_delta)::BaseType::BufferWriter
        time_delta_writer;
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
        in_time_delta, buffer, &time_delta_writer, context);
    (*output)->time_delta.Set(
        time_delta_writer.is_null() ? nullptr : time_delta_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->time_delta.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null time_delta in XRDepthDataUpdated struct");
    decltype(Traits::pixel_data(input)) in_pixel_data = Traits::pixel_data(input);
    typename decltype((*output)->pixel_data)::BufferWriter pixel_data_writer;
    pixel_data_writer.AllocateInline(buffer, &(*output)->pixel_data);
    mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
        in_pixel_data, buffer, &pixel_data_writer, true, context);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->pixel_data.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null pixel_data in XRDepthDataUpdated struct");
    decltype(Traits::norm_texture_from_norm_view(input)) in_norm_texture_from_norm_view = Traits::norm_texture_from_norm_view(input);
    typename decltype((*output)->norm_texture_from_norm_view)::BaseType::BufferWriter
        norm_texture_from_norm_view_writer;
    mojo::internal::Serialize<::gfx::mojom::TransformDataView>(
        in_norm_texture_from_norm_view, buffer, &norm_texture_from_norm_view_writer, context);
    (*output)->norm_texture_from_norm_view.Set(
        norm_texture_from_norm_view_writer.is_null() ? nullptr : norm_texture_from_norm_view_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->norm_texture_from_norm_view.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null norm_texture_from_norm_view in XRDepthDataUpdated struct");
    decltype(Traits::size(input)) in_size = Traits::size(input);
    typename decltype((*output)->size)::BaseType::BufferWriter
        size_writer;
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
        in_size, buffer, &size_writer, context);
    (*output)->size.Set(
        size_writer.is_null() ? nullptr : size_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->size.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null size in XRDepthDataUpdated struct");
  }

  static bool Deserialize(::device::mojom::internal::XRDepthDataUpdated_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRDepthDataUpdatedDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRFrameDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRFrameDataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::device::mojom::internal::XRFrameData_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::pose(input)) in_pose = Traits::pose(input);
    typename decltype((*output)->pose)::BaseType::BufferWriter
        pose_writer;
    mojo::internal::Serialize<::device::mojom::VRPoseDataView>(
        in_pose, buffer, &pose_writer, context);
    (*output)->pose.Set(
        pose_writer.is_null() ? nullptr : pose_writer.data());
    decltype(Traits::time_delta(input)) in_time_delta = Traits::time_delta(input);
    typename decltype((*output)->time_delta)::BaseType::BufferWriter
        time_delta_writer;
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
        in_time_delta, buffer, &time_delta_writer, context);
    (*output)->time_delta.Set(
        time_delta_writer.is_null() ? nullptr : time_delta_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->time_delta.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null time_delta in XRFrameData struct");
    decltype(Traits::buffer_holder(input)) in_buffer_holder = Traits::buffer_holder(input);
    typename decltype((*output)->buffer_holder)::BaseType::BufferWriter
        buffer_holder_writer;
    mojo::internal::Serialize<::gpu::mojom::MailboxHolderDataView>(
        in_buffer_holder, buffer, &buffer_holder_writer, context);
    (*output)->buffer_holder.Set(
        buffer_holder_writer.is_null() ? nullptr : buffer_holder_writer.data());
    decltype(Traits::camera_image_buffer_holder(input)) in_camera_image_buffer_holder = Traits::camera_image_buffer_holder(input);
    typename decltype((*output)->camera_image_buffer_holder)::BaseType::BufferWriter
        camera_image_buffer_holder_writer;
    mojo::internal::Serialize<::gpu::mojom::MailboxHolderDataView>(
        in_camera_image_buffer_holder, buffer, &camera_image_buffer_holder_writer, context);
    (*output)->camera_image_buffer_holder.Set(
        camera_image_buffer_holder_writer.is_null() ? nullptr : camera_image_buffer_holder_writer.data());
    decltype(Traits::depth_data(input)) in_depth_data = Traits::depth_data(input);
    typename decltype((*output)->depth_data)::BufferWriter depth_data_writer;
    depth_data_writer.AllocateInline(buffer, &(*output)->depth_data);
    mojo::internal::Serialize<::device::mojom::XRDepthDataDataView>(
        in_depth_data, buffer, &depth_data_writer, true, context);
    (*output)->mojo_space_reset = Traits::mojo_space_reset(input);
    (*output)->frame_id = Traits::frame_id(input);
    decltype(Traits::left_eye(input)) in_left_eye = Traits::left_eye(input);
    typename decltype((*output)->left_eye)::BaseType::BufferWriter
        left_eye_writer;
    mojo::internal::Serialize<::device::mojom::VREyeParametersDataView>(
        in_left_eye, buffer, &left_eye_writer, context);
    (*output)->left_eye.Set(
        left_eye_writer.is_null() ? nullptr : left_eye_writer.data());
    decltype(Traits::right_eye(input)) in_right_eye = Traits::right_eye(input);
    typename decltype((*output)->right_eye)::BaseType::BufferWriter
        right_eye_writer;
    mojo::internal::Serialize<::device::mojom::VREyeParametersDataView>(
        in_right_eye, buffer, &right_eye_writer, context);
    (*output)->right_eye.Set(
        right_eye_writer.is_null() ? nullptr : right_eye_writer.data());
    decltype(Traits::input_state(input)) in_input_state = Traits::input_state(input);
    typename decltype((*output)->input_state)::BaseType::BufferWriter
        input_state_writer;
    const mojo::internal::ContainerValidateParams input_state_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::XRInputSourceStateDataView>>(
        in_input_state, buffer, &input_state_writer, &input_state_validate_params,
        context);
    (*output)->input_state.Set(
        input_state_writer.is_null() ? nullptr : input_state_writer.data());
    (*output)->stage_parameters_updated = Traits::stage_parameters_updated(input);
    decltype(Traits::stage_parameters(input)) in_stage_parameters = Traits::stage_parameters(input);
    typename decltype((*output)->stage_parameters)::BaseType::BufferWriter
        stage_parameters_writer;
    mojo::internal::Serialize<::device::mojom::VRStageParametersDataView>(
        in_stage_parameters, buffer, &stage_parameters_writer, context);
    (*output)->stage_parameters.Set(
        stage_parameters_writer.is_null() ? nullptr : stage_parameters_writer.data());
    decltype(Traits::detected_planes_data(input)) in_detected_planes_data = Traits::detected_planes_data(input);
    typename decltype((*output)->detected_planes_data)::BaseType::BufferWriter
        detected_planes_data_writer;
    mojo::internal::Serialize<::device::mojom::XRPlaneDetectionDataDataView>(
        in_detected_planes_data, buffer, &detected_planes_data_writer, context);
    (*output)->detected_planes_data.Set(
        detected_planes_data_writer.is_null() ? nullptr : detected_planes_data_writer.data());
    decltype(Traits::anchors_data(input)) in_anchors_data = Traits::anchors_data(input);
    typename decltype((*output)->anchors_data)::BaseType::BufferWriter
        anchors_data_writer;
    mojo::internal::Serialize<::device::mojom::XRAnchorsDataDataView>(
        in_anchors_data, buffer, &anchors_data_writer, context);
    (*output)->anchors_data.Set(
        anchors_data_writer.is_null() ? nullptr : anchors_data_writer.data());
    decltype(Traits::light_estimation_data(input)) in_light_estimation_data = Traits::light_estimation_data(input);
    typename decltype((*output)->light_estimation_data)::BaseType::BufferWriter
        light_estimation_data_writer;
    mojo::internal::Serialize<::device::mojom::XRLightEstimationDataDataView>(
        in_light_estimation_data, buffer, &light_estimation_data_writer, context);
    (*output)->light_estimation_data.Set(
        light_estimation_data_writer.is_null() ? nullptr : light_estimation_data_writer.data());
    decltype(Traits::hit_test_subscription_results(input)) in_hit_test_subscription_results = Traits::hit_test_subscription_results(input);
    typename decltype((*output)->hit_test_subscription_results)::BaseType::BufferWriter
        hit_test_subscription_results_writer;
    mojo::internal::Serialize<::device::mojom::XRHitTestSubscriptionResultsDataDataView>(
        in_hit_test_subscription_results, buffer, &hit_test_subscription_results_writer, context);
    (*output)->hit_test_subscription_results.Set(
        hit_test_subscription_results_writer.is_null() ? nullptr : hit_test_subscription_results_writer.data());
  }

  static bool Deserialize(::device::mojom::internal::XRFrameData_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRFrameDataDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::RequestSessionSuccessDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::RequestSessionSuccessDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::device::mojom::internal::RequestSessionSuccess_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::session(input)) in_session = Traits::session(input);
    typename decltype((*output)->session)::BaseType::BufferWriter
        session_writer;
    mojo::internal::Serialize<::device::mojom::XRSessionDataView>(
        in_session, buffer, &session_writer, context);
    (*output)->session.Set(
        session_writer.is_null() ? nullptr : session_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->session.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null session in RequestSessionSuccess struct");
    decltype(Traits::metrics_recorder(input)) in_metrics_recorder = Traits::metrics_recorder(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::XRSessionMetricsRecorderInterfaceBase>>(
        in_metrics_recorder, &(*output)->metrics_recorder, context);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid((*output)->metrics_recorder),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid metrics_recorder in RequestSessionSuccess struct");
  }

  static bool Deserialize(::device::mojom::internal::RequestSessionSuccess_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::RequestSessionSuccessDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRFrameDataRequestOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRFrameDataRequestOptionsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::device::mojom::internal::XRFrameDataRequestOptions_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->include_lighting_estimation_data = Traits::include_lighting_estimation_data(input);
  }

  static bool Deserialize(::device::mojom::internal::XRFrameDataRequestOptions_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRFrameDataRequestOptionsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRNativeOriginInformationDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::device::mojom::XRNativeOriginInformationDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::device::mojom::internal::XRNativeOriginInformation_Data::BufferWriter* writer,
                        bool inlined,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
         writer->data()->set_null();
      return;
    }
    if (!inlined)
      writer->Allocate(buffer);

    ::device::mojom::internal::XRNativeOriginInformation_Data::BufferWriter& result = *writer;
    ALLOW_UNUSED_LOCAL(result);
    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    result->size = kUnionDataSize;
    result->tag = Traits::GetTag(input);
    switch (result->tag) {
      case ::device::mojom::XRNativeOriginInformationDataView::Tag::INPUT_SOURCE_ID: {
        decltype(Traits::input_source_id(input))
            in_input_source_id = Traits::input_source_id(input);
        result->data.f_input_source_id = in_input_source_id;
        break;
      }
      case ::device::mojom::XRNativeOriginInformationDataView::Tag::PLANE_ID: {
        decltype(Traits::plane_id(input))
            in_plane_id = Traits::plane_id(input);
        result->data.f_plane_id = in_plane_id;
        break;
      }
      case ::device::mojom::XRNativeOriginInformationDataView::Tag::ANCHOR_ID: {
        decltype(Traits::anchor_id(input))
            in_anchor_id = Traits::anchor_id(input);
        result->data.f_anchor_id = in_anchor_id;
        break;
      }
      case ::device::mojom::XRNativeOriginInformationDataView::Tag::REFERENCE_SPACE_TYPE: {
        decltype(Traits::reference_space_type(input))
            in_reference_space_type = Traits::reference_space_type(input);
        mojo::internal::Serialize<::device::mojom::XRReferenceSpaceType>(
            in_reference_space_type, &result->data.f_reference_space_type);
        break;
      }
    }
  }

  static bool Deserialize(::device::mojom::internal::XRNativeOriginInformation_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRNativeOriginInformationDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRDepthDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::device::mojom::XRDepthDataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::device::mojom::internal::XRDepthData_Data::BufferWriter* writer,
                        bool inlined,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
         writer->data()->set_null();
      return;
    }
    if (!inlined)
      writer->Allocate(buffer);

    ::device::mojom::internal::XRDepthData_Data::BufferWriter& result = *writer;
    ALLOW_UNUSED_LOCAL(result);
    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    result->size = kUnionDataSize;
    result->tag = Traits::GetTag(input);
    switch (result->tag) {
      case ::device::mojom::XRDepthDataDataView::Tag::DATA_STILL_VALID: {
        decltype(Traits::data_still_valid(input))
            in_data_still_valid = Traits::data_still_valid(input);
        typename decltype(result->data.f_data_still_valid)::BaseType::BufferWriter
            value_writer;
        mojo::internal::Serialize<::device::mojom::XRDepthDataStillValidDataView>(
            in_data_still_valid, buffer, &value_writer, context);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_writer.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null data_still_valid in XRDepthData union");
        result->data.f_data_still_valid.Set(
            value_writer.is_null() ? nullptr : value_writer.data());
        break;
      }
      case ::device::mojom::XRDepthDataDataView::Tag::UPDATED_DEPTH_DATA: {
        decltype(Traits::updated_depth_data(input))
            in_updated_depth_data = Traits::updated_depth_data(input);
        typename decltype(result->data.f_updated_depth_data)::BaseType::BufferWriter
            value_writer;
        mojo::internal::Serialize<::device::mojom::XRDepthDataUpdatedDataView>(
            in_updated_depth_data, buffer, &value_writer, context);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_writer.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null updated_depth_data in XRDepthData union");
        result->data.f_updated_depth_data.Set(
            value_writer.is_null() ? nullptr : value_writer.data());
        break;
      }
    }
  }

  static bool Deserialize(::device::mojom::internal::XRDepthData_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRDepthDataDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::RequestSessionResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::device::mojom::RequestSessionResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::device::mojom::internal::RequestSessionResult_Data::BufferWriter* writer,
                        bool inlined,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
         writer->data()->set_null();
      return;
    }
    if (!inlined)
      writer->Allocate(buffer);

    ::device::mojom::internal::RequestSessionResult_Data::BufferWriter& result = *writer;
    ALLOW_UNUSED_LOCAL(result);
    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    result->size = kUnionDataSize;
    result->tag = Traits::GetTag(input);
    switch (result->tag) {
      case ::device::mojom::RequestSessionResultDataView::Tag::SUCCESS: {
        decltype(Traits::success(input))
            in_success = Traits::success(input);
        typename decltype(result->data.f_success)::BaseType::BufferWriter
            value_writer;
        mojo::internal::Serialize<::device::mojom::RequestSessionSuccessDataView>(
            in_success, buffer, &value_writer, context);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_writer.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null success in RequestSessionResult union");
        result->data.f_success.Set(
            value_writer.is_null() ? nullptr : value_writer.data());
        break;
      }
      case ::device::mojom::RequestSessionResultDataView::Tag::FAILURE_REASON: {
        decltype(Traits::failure_reason(input))
            in_failure_reason = Traits::failure_reason(input);
        mojo::internal::Serialize<::device::mojom::RequestSessionError>(
            in_failure_reason, &result->data.f_failure_reason);
        break;
      }
    }
  }

  static bool Deserialize(::device::mojom::internal::RequestSessionResult_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::RequestSessionResultDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace device {
namespace mojom {

inline void XRSessionOptionsDataView::GetRequiredFeaturesDataView(
    mojo::ArrayDataView<XRSessionFeature>* output) {
  auto pointer = data_->required_features.Get();
  *output = mojo::ArrayDataView<XRSessionFeature>(pointer, context_);
}
inline void XRSessionOptionsDataView::GetOptionalFeaturesDataView(
    mojo::ArrayDataView<XRSessionFeature>* output) {
  auto pointer = data_->optional_features.Get();
  *output = mojo::ArrayDataView<XRSessionFeature>(pointer, context_);
}


inline void XRSessionDataView::GetDisplayInfoDataView(
    VRDisplayInfoDataView* output) {
  auto pointer = data_->display_info.Get();
  *output = VRDisplayInfoDataView(pointer, context_);
}
inline void XRSessionDataView::GetSubmitFrameSinkDataView(
    XRPresentationConnectionDataView* output) {
  auto pointer = data_->submit_frame_sink.Get();
  *output = XRPresentationConnectionDataView(pointer, context_);
}
inline void XRSessionDataView::GetEnabledFeaturesDataView(
    mojo::ArrayDataView<XRSessionFeature>* output) {
  auto pointer = data_->enabled_features.Get();
  *output = mojo::ArrayDataView<XRSessionFeature>(pointer, context_);
}


inline void XRPresentationConnectionDataView::GetTransportOptionsDataView(
    XRPresentationTransportOptionsDataView* output) {
  auto pointer = data_->transport_options.Get();
  *output = XRPresentationTransportOptionsDataView(pointer, context_);
}


inline void XRInputSourceDescriptionDataView::GetInputFromPointerDataView(
    ::gfx::mojom::TransformDataView* output) {
  auto pointer = data_->input_from_pointer.Get();
  *output = ::gfx::mojom::TransformDataView(pointer, context_);
}
inline void XRInputSourceDescriptionDataView::GetProfilesDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->profiles.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, context_);
}


inline void XRInputSourceStateDataView::GetDescriptionDataView(
    XRInputSourceDescriptionDataView* output) {
  auto pointer = data_->description.Get();
  *output = XRInputSourceDescriptionDataView(pointer, context_);
}
inline void XRInputSourceStateDataView::GetMojoFromInputDataView(
    ::gfx::mojom::TransformDataView* output) {
  auto pointer = data_->mojo_from_input.Get();
  *output = ::gfx::mojom::TransformDataView(pointer, context_);
}
inline void XRInputSourceStateDataView::GetGamepadDataView(
    ::device::mojom::GamepadDataView* output) {
  auto pointer = data_->gamepad.Get();
  *output = ::device::mojom::GamepadDataView(pointer, context_);
}
inline void XRInputSourceStateDataView::GetOverlayPointerPositionDataView(
    ::gfx::mojom::PointFDataView* output) {
  auto pointer = data_->overlay_pointer_position.Get();
  *output = ::gfx::mojom::PointFDataView(pointer, context_);
}




inline void VRPoseDataView::GetOrientationDataView(
    ::gfx::mojom::QuaternionDataView* output) {
  auto pointer = data_->orientation.Get();
  *output = ::gfx::mojom::QuaternionDataView(pointer, context_);
}
inline void VRPoseDataView::GetPositionDataView(
    ::gfx::mojom::Point3FDataView* output) {
  auto pointer = data_->position.Get();
  *output = ::gfx::mojom::Point3FDataView(pointer, context_);
}


inline void PoseDataView::GetOrientationDataView(
    ::gfx::mojom::QuaternionDataView* output) {
  auto pointer = data_->orientation.Get();
  *output = ::gfx::mojom::QuaternionDataView(pointer, context_);
}
inline void PoseDataView::GetPositionDataView(
    ::gfx::mojom::Point3FDataView* output) {
  auto pointer = data_->position.Get();
  *output = ::gfx::mojom::Point3FDataView(pointer, context_);
}


inline void XRRayDataView::GetOriginDataView(
    ::gfx::mojom::Point3FDataView* output) {
  auto pointer = data_->origin.Get();
  *output = ::gfx::mojom::Point3FDataView(pointer, context_);
}
inline void XRRayDataView::GetDirectionDataView(
    ::gfx::mojom::Vector3dFDataView* output) {
  auto pointer = data_->direction.Get();
  *output = ::gfx::mojom::Vector3dFDataView(pointer, context_);
}


inline void XRHitResultDataView::GetMojoFromResultDataView(
    PoseDataView* output) {
  auto pointer = data_->mojo_from_result.Get();
  *output = PoseDataView(pointer, context_);
}


inline void VREyeParametersDataView::GetFieldOfViewDataView(
    VRFieldOfViewDataView* output) {
  auto pointer = data_->field_of_view.Get();
  *output = VRFieldOfViewDataView(pointer, context_);
}
inline void VREyeParametersDataView::GetHeadFromEyeDataView(
    ::gfx::mojom::TransformDataView* output) {
  auto pointer = data_->head_from_eye.Get();
  *output = ::gfx::mojom::TransformDataView(pointer, context_);
}


inline void VRStageParametersDataView::GetMojoFromFloorDataView(
    ::gfx::mojom::TransformDataView* output) {
  auto pointer = data_->mojo_from_floor.Get();
  *output = ::gfx::mojom::TransformDataView(pointer, context_);
}
inline void VRStageParametersDataView::GetBoundsDataView(
    mojo::ArrayDataView<::gfx::mojom::Point3FDataView>* output) {
  auto pointer = data_->bounds.Get();
  *output = mojo::ArrayDataView<::gfx::mojom::Point3FDataView>(pointer, context_);
}


inline void VRDisplayInfoDataView::GetStageParametersDataView(
    VRStageParametersDataView* output) {
  auto pointer = data_->stage_parameters.Get();
  *output = VRStageParametersDataView(pointer, context_);
}
inline void VRDisplayInfoDataView::GetLeftEyeDataView(
    VREyeParametersDataView* output) {
  auto pointer = data_->left_eye.Get();
  *output = VREyeParametersDataView(pointer, context_);
}
inline void VRDisplayInfoDataView::GetRightEyeDataView(
    VREyeParametersDataView* output) {
  auto pointer = data_->right_eye.Get();
  *output = VREyeParametersDataView(pointer, context_);
}






inline void XRPlaneDataDataView::GetMojoFromPlaneDataView(
    PoseDataView* output) {
  auto pointer = data_->mojo_from_plane.Get();
  *output = PoseDataView(pointer, context_);
}
inline void XRPlaneDataDataView::GetPolygonDataView(
    mojo::ArrayDataView<XRPlanePointDataDataView>* output) {
  auto pointer = data_->polygon.Get();
  *output = mojo::ArrayDataView<XRPlanePointDataDataView>(pointer, context_);
}


inline void XRPlaneDetectionDataDataView::GetAllPlanesIdsDataView(
    mojo::ArrayDataView<uint64_t>* output) {
  auto pointer = data_->all_planes_ids.Get();
  *output = mojo::ArrayDataView<uint64_t>(pointer, context_);
}
inline void XRPlaneDetectionDataDataView::GetUpdatedPlanesDataDataView(
    mojo::ArrayDataView<XRPlaneDataDataView>* output) {
  auto pointer = data_->updated_planes_data.Get();
  *output = mojo::ArrayDataView<XRPlaneDataDataView>(pointer, context_);
}


inline void XRAnchorDataDataView::GetMojoFromAnchorDataView(
    PoseDataView* output) {
  auto pointer = data_->mojo_from_anchor.Get();
  *output = PoseDataView(pointer, context_);
}


inline void XRAnchorsDataDataView::GetAllAnchorsIdsDataView(
    mojo::ArrayDataView<uint64_t>* output) {
  auto pointer = data_->all_anchors_ids.Get();
  *output = mojo::ArrayDataView<uint64_t>(pointer, context_);
}
inline void XRAnchorsDataDataView::GetUpdatedAnchorsDataDataView(
    mojo::ArrayDataView<XRAnchorDataDataView>* output) {
  auto pointer = data_->updated_anchors_data.Get();
  *output = mojo::ArrayDataView<XRAnchorDataDataView>(pointer, context_);
}


inline void XRHitTestSubscriptionResultDataDataView::GetHitTestResultsDataView(
    mojo::ArrayDataView<XRHitResultDataView>* output) {
  auto pointer = data_->hit_test_results.Get();
  *output = mojo::ArrayDataView<XRHitResultDataView>(pointer, context_);
}


inline void XRHitTestTransientInputSubscriptionResultDataDataView::GetInputSourceIdToHitTestResultsDataView(
    mojo::MapDataView<uint32_t, mojo::ArrayDataView<XRHitResultDataView>>* output) {
  auto pointer = data_->input_source_id_to_hit_test_results.Get();
  *output = mojo::MapDataView<uint32_t, mojo::ArrayDataView<XRHitResultDataView>>(pointer, context_);
}


inline void XRHitTestSubscriptionResultsDataDataView::GetResultsDataView(
    mojo::ArrayDataView<XRHitTestSubscriptionResultDataDataView>* output) {
  auto pointer = data_->results.Get();
  *output = mojo::ArrayDataView<XRHitTestSubscriptionResultDataDataView>(pointer, context_);
}
inline void XRHitTestSubscriptionResultsDataDataView::GetTransientInputResultsDataView(
    mojo::ArrayDataView<XRHitTestTransientInputSubscriptionResultDataDataView>* output) {
  auto pointer = data_->transient_input_results.Get();
  *output = mojo::ArrayDataView<XRHitTestTransientInputSubscriptionResultDataDataView>(pointer, context_);
}




inline void XRSphericalHarmonicsDataView::GetCoefficientsDataView(
    mojo::ArrayDataView<RgbTupleF32DataView>* output) {
  auto pointer = data_->coefficients.Get();
  *output = mojo::ArrayDataView<RgbTupleF32DataView>(pointer, context_);
}




inline void XRCubeMapDataView::GetPositiveXDataView(
    mojo::ArrayDataView<RgbaTupleF16DataView>* output) {
  auto pointer = data_->positive_x.Get();
  *output = mojo::ArrayDataView<RgbaTupleF16DataView>(pointer, context_);
}
inline void XRCubeMapDataView::GetNegativeXDataView(
    mojo::ArrayDataView<RgbaTupleF16DataView>* output) {
  auto pointer = data_->negative_x.Get();
  *output = mojo::ArrayDataView<RgbaTupleF16DataView>(pointer, context_);
}
inline void XRCubeMapDataView::GetPositiveYDataView(
    mojo::ArrayDataView<RgbaTupleF16DataView>* output) {
  auto pointer = data_->positive_y.Get();
  *output = mojo::ArrayDataView<RgbaTupleF16DataView>(pointer, context_);
}
inline void XRCubeMapDataView::GetNegativeYDataView(
    mojo::ArrayDataView<RgbaTupleF16DataView>* output) {
  auto pointer = data_->negative_y.Get();
  *output = mojo::ArrayDataView<RgbaTupleF16DataView>(pointer, context_);
}
inline void XRCubeMapDataView::GetPositiveZDataView(
    mojo::ArrayDataView<RgbaTupleF16DataView>* output) {
  auto pointer = data_->positive_z.Get();
  *output = mojo::ArrayDataView<RgbaTupleF16DataView>(pointer, context_);
}
inline void XRCubeMapDataView::GetNegativeZDataView(
    mojo::ArrayDataView<RgbaTupleF16DataView>* output) {
  auto pointer = data_->negative_z.Get();
  *output = mojo::ArrayDataView<RgbaTupleF16DataView>(pointer, context_);
}


inline void XRLightProbeDataView::GetSphericalHarmonicsDataView(
    XRSphericalHarmonicsDataView* output) {
  auto pointer = data_->spherical_harmonics.Get();
  *output = XRSphericalHarmonicsDataView(pointer, context_);
}
inline void XRLightProbeDataView::GetMainLightDirectionDataView(
    ::gfx::mojom::Vector3dFDataView* output) {
  auto pointer = data_->main_light_direction.Get();
  *output = ::gfx::mojom::Vector3dFDataView(pointer, context_);
}
inline void XRLightProbeDataView::GetMainLightIntensityDataView(
    RgbTupleF32DataView* output) {
  auto pointer = data_->main_light_intensity.Get();
  *output = RgbTupleF32DataView(pointer, context_);
}


inline void XRReflectionProbeDataView::GetCubeMapDataView(
    XRCubeMapDataView* output) {
  auto pointer = data_->cube_map.Get();
  *output = XRCubeMapDataView(pointer, context_);
}


inline void XRLightEstimationDataDataView::GetLightProbeDataView(
    XRLightProbeDataView* output) {
  auto pointer = data_->light_probe.Get();
  *output = XRLightProbeDataView(pointer, context_);
}
inline void XRLightEstimationDataDataView::GetReflectionProbeDataView(
    XRReflectionProbeDataView* output) {
  auto pointer = data_->reflection_probe.Get();
  *output = XRReflectionProbeDataView(pointer, context_);
}




inline void XRDepthDataUpdatedDataView::GetTimeDeltaDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->time_delta.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, context_);
}
inline void XRDepthDataUpdatedDataView::GetPixelDataDataView(
    ::mojo_base::mojom::BigBufferDataView* output) {
  auto pointer = &data_->pixel_data;
  *output = ::mojo_base::mojom::BigBufferDataView(pointer, context_);
}
inline void XRDepthDataUpdatedDataView::GetNormTextureFromNormViewDataView(
    ::gfx::mojom::TransformDataView* output) {
  auto pointer = data_->norm_texture_from_norm_view.Get();
  *output = ::gfx::mojom::TransformDataView(pointer, context_);
}
inline void XRDepthDataUpdatedDataView::GetSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, context_);
}


inline void XRFrameDataDataView::GetPoseDataView(
    VRPoseDataView* output) {
  auto pointer = data_->pose.Get();
  *output = VRPoseDataView(pointer, context_);
}
inline void XRFrameDataDataView::GetTimeDeltaDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->time_delta.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, context_);
}
inline void XRFrameDataDataView::GetBufferHolderDataView(
    ::gpu::mojom::MailboxHolderDataView* output) {
  auto pointer = data_->buffer_holder.Get();
  *output = ::gpu::mojom::MailboxHolderDataView(pointer, context_);
}
inline void XRFrameDataDataView::GetCameraImageBufferHolderDataView(
    ::gpu::mojom::MailboxHolderDataView* output) {
  auto pointer = data_->camera_image_buffer_holder.Get();
  *output = ::gpu::mojom::MailboxHolderDataView(pointer, context_);
}
inline void XRFrameDataDataView::GetDepthDataDataView(
    XRDepthDataDataView* output) {
  auto pointer = &data_->depth_data;
  *output = XRDepthDataDataView(pointer, context_);
}
inline void XRFrameDataDataView::GetLeftEyeDataView(
    VREyeParametersDataView* output) {
  auto pointer = data_->left_eye.Get();
  *output = VREyeParametersDataView(pointer, context_);
}
inline void XRFrameDataDataView::GetRightEyeDataView(
    VREyeParametersDataView* output) {
  auto pointer = data_->right_eye.Get();
  *output = VREyeParametersDataView(pointer, context_);
}
inline void XRFrameDataDataView::GetInputStateDataView(
    mojo::ArrayDataView<XRInputSourceStateDataView>* output) {
  auto pointer = data_->input_state.Get();
  *output = mojo::ArrayDataView<XRInputSourceStateDataView>(pointer, context_);
}
inline void XRFrameDataDataView::GetStageParametersDataView(
    VRStageParametersDataView* output) {
  auto pointer = data_->stage_parameters.Get();
  *output = VRStageParametersDataView(pointer, context_);
}
inline void XRFrameDataDataView::GetDetectedPlanesDataDataView(
    XRPlaneDetectionDataDataView* output) {
  auto pointer = data_->detected_planes_data.Get();
  *output = XRPlaneDetectionDataDataView(pointer, context_);
}
inline void XRFrameDataDataView::GetAnchorsDataDataView(
    XRAnchorsDataDataView* output) {
  auto pointer = data_->anchors_data.Get();
  *output = XRAnchorsDataDataView(pointer, context_);
}
inline void XRFrameDataDataView::GetLightEstimationDataDataView(
    XRLightEstimationDataDataView* output) {
  auto pointer = data_->light_estimation_data.Get();
  *output = XRLightEstimationDataDataView(pointer, context_);
}
inline void XRFrameDataDataView::GetHitTestSubscriptionResultsDataView(
    XRHitTestSubscriptionResultsDataDataView* output) {
  auto pointer = data_->hit_test_subscription_results.Get();
  *output = XRHitTestSubscriptionResultsDataDataView(pointer, context_);
}


inline void RequestSessionSuccessDataView::GetSessionDataView(
    XRSessionDataView* output) {
  auto pointer = data_->session.Get();
  *output = XRSessionDataView(pointer, context_);
}





inline void XRDepthDataDataView::GetDataStillValidDataView(
    XRDepthDataStillValidDataView* output) {
  DCHECK(is_data_still_valid());
  *output = XRDepthDataStillValidDataView(data_->data.f_data_still_valid.Get(), context_);
}
inline void XRDepthDataDataView::GetUpdatedDepthDataDataView(
    XRDepthDataUpdatedDataView* output) {
  DCHECK(is_updated_depth_data());
  *output = XRDepthDataUpdatedDataView(data_->data.f_updated_depth_data.Get(), context_);
}

inline void RequestSessionResultDataView::GetSuccessDataView(
    RequestSessionSuccessDataView* output) {
  DCHECK(is_success());
  *output = RequestSessionSuccessDataView(data_->data.f_success.Get(), context_);
}


}  // namespace mojom
}  // namespace device

#endif  // DEVICE_VR_PUBLIC_MOJOM_VR_SERVICE_MOJOM_SHARED_H_