// media/learning/mojo/public/mojom/learning_types.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_LEARNING_MOJO_PUBLIC_MOJOM_LEARNING_TYPES_MOJOM_SHARED_H_
#define MEDIA_LEARNING_MOJO_PUBLIC_MOJOM_LEARNING_TYPES_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "media/learning/mojo/public/mojom/learning_types.mojom-shared-internal.h"







namespace media {
namespace learning {
namespace mojom {
class FeatureValueDataView;

class TargetValueDataView;

class LabelledExampleDataView;

class ObservationCompletionDataView;

class TargetHistogramPairDataView;

class TargetHistogramDataView;



}  // namespace mojom
}  // namespace learning
}  // namespace media

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::media::learning::mojom::FeatureValueDataView> {
  using Data = ::media::learning::mojom::internal::FeatureValue_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::learning::mojom::TargetValueDataView> {
  using Data = ::media::learning::mojom::internal::TargetValue_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::learning::mojom::LabelledExampleDataView> {
  using Data = ::media::learning::mojom::internal::LabelledExample_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::learning::mojom::ObservationCompletionDataView> {
  using Data = ::media::learning::mojom::internal::ObservationCompletion_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::learning::mojom::TargetHistogramPairDataView> {
  using Data = ::media::learning::mojom::internal::TargetHistogramPair_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::learning::mojom::TargetHistogramDataView> {
  using Data = ::media::learning::mojom::internal::TargetHistogram_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace media {
namespace learning {
namespace mojom {


class FeatureValueDataView {
 public:
  FeatureValueDataView() {}

  FeatureValueDataView(
      internal::FeatureValue_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  double value() const {
    return data_->value;
  }
 private:
  internal::FeatureValue_Data* data_ = nullptr;
};



class TargetValueDataView {
 public:
  TargetValueDataView() {}

  TargetValueDataView(
      internal::TargetValue_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  double value() const {
    return data_->value;
  }
 private:
  internal::TargetValue_Data* data_ = nullptr;
};



class LabelledExampleDataView {
 public:
  LabelledExampleDataView() {}

  LabelledExampleDataView(
      internal::LabelledExample_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetFeaturesDataView(
      mojo::ArrayDataView<FeatureValueDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadFeatures(UserType* output) {
    
    auto* pointer = data_->features.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::learning::mojom::FeatureValueDataView>>(
        pointer, output, context_);
  }
  inline void GetTargetValueDataView(
      TargetValueDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadTargetValue(UserType* output) {
    
    auto* pointer = data_->target_value.Get();
    return mojo::internal::Deserialize<::media::learning::mojom::TargetValueDataView>(
        pointer, output, context_);
  }
 private:
  internal::LabelledExample_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class ObservationCompletionDataView {
 public:
  ObservationCompletionDataView() {}

  ObservationCompletionDataView(
      internal::ObservationCompletion_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetTargetValueDataView(
      TargetValueDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadTargetValue(UserType* output) {
    
    auto* pointer = data_->target_value.Get();
    return mojo::internal::Deserialize<::media::learning::mojom::TargetValueDataView>(
        pointer, output, context_);
  }
  uint64_t weight() const {
    return data_->weight;
  }
 private:
  internal::ObservationCompletion_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class TargetHistogramPairDataView {
 public:
  TargetHistogramPairDataView() {}

  TargetHistogramPairDataView(
      internal::TargetHistogramPair_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetTargetValueDataView(
      TargetValueDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadTargetValue(UserType* output) {
    
    auto* pointer = data_->target_value.Get();
    return mojo::internal::Deserialize<::media::learning::mojom::TargetValueDataView>(
        pointer, output, context_);
  }
  double count() const {
    return data_->count;
  }
 private:
  internal::TargetHistogramPair_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class TargetHistogramDataView {
 public:
  TargetHistogramDataView() {}

  TargetHistogramDataView(
      internal::TargetHistogram_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetPairsDataView(
      mojo::ArrayDataView<TargetHistogramPairDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPairs(UserType* output) {
    
    auto* pointer = data_->pairs.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::learning::mojom::TargetHistogramPairDataView>>(
        pointer, output, context_);
  }
 private:
  internal::TargetHistogram_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace learning
}  // namespace media

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::learning::mojom::FeatureValueDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::learning::mojom::FeatureValueDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::media::learning::mojom::internal::FeatureValue_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->value = Traits::value(input);
  }

  static bool Deserialize(::media::learning::mojom::internal::FeatureValue_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::learning::mojom::FeatureValueDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::learning::mojom::TargetValueDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::learning::mojom::TargetValueDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::media::learning::mojom::internal::TargetValue_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->value = Traits::value(input);
  }

  static bool Deserialize(::media::learning::mojom::internal::TargetValue_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::learning::mojom::TargetValueDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::learning::mojom::LabelledExampleDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::learning::mojom::LabelledExampleDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::media::learning::mojom::internal::LabelledExample_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::features(input)) in_features = Traits::features(input);
    typename decltype((*output)->features)::BaseType::BufferWriter
        features_writer;
    const mojo::internal::ContainerValidateParams features_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::media::learning::mojom::FeatureValueDataView>>(
        in_features, buffer, &features_writer, &features_validate_params,
        context);
    (*output)->features.Set(
        features_writer.is_null() ? nullptr : features_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->features.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null features in LabelledExample struct");
    decltype(Traits::target_value(input)) in_target_value = Traits::target_value(input);
    typename decltype((*output)->target_value)::BaseType::BufferWriter
        target_value_writer;
    mojo::internal::Serialize<::media::learning::mojom::TargetValueDataView>(
        in_target_value, buffer, &target_value_writer, context);
    (*output)->target_value.Set(
        target_value_writer.is_null() ? nullptr : target_value_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->target_value.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null target_value in LabelledExample struct");
  }

  static bool Deserialize(::media::learning::mojom::internal::LabelledExample_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::learning::mojom::LabelledExampleDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::learning::mojom::ObservationCompletionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::learning::mojom::ObservationCompletionDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::media::learning::mojom::internal::ObservationCompletion_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::target_value(input)) in_target_value = Traits::target_value(input);
    typename decltype((*output)->target_value)::BaseType::BufferWriter
        target_value_writer;
    mojo::internal::Serialize<::media::learning::mojom::TargetValueDataView>(
        in_target_value, buffer, &target_value_writer, context);
    (*output)->target_value.Set(
        target_value_writer.is_null() ? nullptr : target_value_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->target_value.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null target_value in ObservationCompletion struct");
    (*output)->weight = Traits::weight(input);
  }

  static bool Deserialize(::media::learning::mojom::internal::ObservationCompletion_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::learning::mojom::ObservationCompletionDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::learning::mojom::TargetHistogramPairDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::learning::mojom::TargetHistogramPairDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::media::learning::mojom::internal::TargetHistogramPair_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::target_value(input)) in_target_value = Traits::target_value(input);
    typename decltype((*output)->target_value)::BaseType::BufferWriter
        target_value_writer;
    mojo::internal::Serialize<::media::learning::mojom::TargetValueDataView>(
        in_target_value, buffer, &target_value_writer, context);
    (*output)->target_value.Set(
        target_value_writer.is_null() ? nullptr : target_value_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->target_value.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null target_value in TargetHistogramPair struct");
    (*output)->count = Traits::count(input);
  }

  static bool Deserialize(::media::learning::mojom::internal::TargetHistogramPair_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::learning::mojom::TargetHistogramPairDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::learning::mojom::TargetHistogramDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::learning::mojom::TargetHistogramDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::media::learning::mojom::internal::TargetHistogram_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::pairs(input)) in_pairs = Traits::pairs(input);
    typename decltype((*output)->pairs)::BaseType::BufferWriter
        pairs_writer;
    const mojo::internal::ContainerValidateParams pairs_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::media::learning::mojom::TargetHistogramPairDataView>>(
        in_pairs, buffer, &pairs_writer, &pairs_validate_params,
        context);
    (*output)->pairs.Set(
        pairs_writer.is_null() ? nullptr : pairs_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->pairs.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null pairs in TargetHistogram struct");
  }

  static bool Deserialize(::media::learning::mojom::internal::TargetHistogram_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::learning::mojom::TargetHistogramDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace media {
namespace learning {
namespace mojom {





inline void LabelledExampleDataView::GetFeaturesDataView(
    mojo::ArrayDataView<FeatureValueDataView>* output) {
  auto pointer = data_->features.Get();
  *output = mojo::ArrayDataView<FeatureValueDataView>(pointer, context_);
}
inline void LabelledExampleDataView::GetTargetValueDataView(
    TargetValueDataView* output) {
  auto pointer = data_->target_value.Get();
  *output = TargetValueDataView(pointer, context_);
}


inline void ObservationCompletionDataView::GetTargetValueDataView(
    TargetValueDataView* output) {
  auto pointer = data_->target_value.Get();
  *output = TargetValueDataView(pointer, context_);
}


inline void TargetHistogramPairDataView::GetTargetValueDataView(
    TargetValueDataView* output) {
  auto pointer = data_->target_value.Get();
  *output = TargetValueDataView(pointer, context_);
}


inline void TargetHistogramDataView::GetPairsDataView(
    mojo::ArrayDataView<TargetHistogramPairDataView>* output) {
  auto pointer = data_->pairs.Get();
  *output = mojo::ArrayDataView<TargetHistogramPairDataView>(pointer, context_);
}



}  // namespace mojom
}  // namespace learning
}  // namespace media

#endif  // MEDIA_LEARNING_MOJO_PUBLIC_MOJOM_LEARNING_TYPES_MOJOM_SHARED_H_