// printing/mojom/print.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef PRINTING_MOJOM_PRINT_MOJOM_H_
#define PRINTING_MOJOM_PRINT_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "printing/mojom/print.mojom-shared.h"
#include "printing/mojom/print.mojom-forward.h"
#include <string>
#include <vector>







// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace printing {
namespace mojom {








class  PageSizeMargins {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PageSizeMargins, T>::value>;
  using DataView = PageSizeMarginsDataView;
  using Data_ = internal::PageSizeMargins_Data;

  template <typename... Args>
  static PageSizeMarginsPtr New(Args&&... args) {
    return PageSizeMarginsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PageSizeMarginsPtr From(const U& u) {
    return mojo::TypeConverter<PageSizeMarginsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PageSizeMargins>::Convert(*this);
  }


  PageSizeMargins();

  PageSizeMargins(
      double content_width,
      double content_height,
      double margin_top,
      double margin_right,
      double margin_bottom,
      double margin_left);

  ~PageSizeMargins();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PageSizeMarginsPtr>
  PageSizeMarginsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PageSizeMargins::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PageSizeMargins::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PageSizeMargins::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PageSizeMargins_UnserializedMessageContext<
            UserType, PageSizeMargins::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<PageSizeMargins::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return PageSizeMargins::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PageSizeMargins_UnserializedMessageContext<
            UserType, PageSizeMargins::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PageSizeMargins::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  double content_width;
  
  double content_height;
  
  double margin_top;
  
  double margin_right;
  
  double margin_bottom;
  
  double margin_left;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PageSizeMargins::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PageSizeMargins::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PageSizeMargins::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PageSizeMargins::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
PageSizeMarginsPtr PageSizeMargins::Clone() const {
  return New(
      mojo::Clone(content_width),
      mojo::Clone(content_height),
      mojo::Clone(margin_top),
      mojo::Clone(margin_right),
      mojo::Clone(margin_bottom),
      mojo::Clone(margin_left)
  );
}

template <typename T, PageSizeMargins::EnableIfSame<T>*>
bool PageSizeMargins::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->content_width, other_struct.content_width))
    return false;
  if (!mojo::Equals(this->content_height, other_struct.content_height))
    return false;
  if (!mojo::Equals(this->margin_top, other_struct.margin_top))
    return false;
  if (!mojo::Equals(this->margin_right, other_struct.margin_right))
    return false;
  if (!mojo::Equals(this->margin_bottom, other_struct.margin_bottom))
    return false;
  if (!mojo::Equals(this->margin_left, other_struct.margin_left))
    return false;
  return true;
}

template <typename T, PageSizeMargins::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.content_width, rhs.content_width))
    return true;
  if (std::less<>{}(rhs.content_width, lhs.content_width))
    return false;
  if (std::less<>{}(lhs.content_height, rhs.content_height))
    return true;
  if (std::less<>{}(rhs.content_height, lhs.content_height))
    return false;
  if (std::less<>{}(lhs.margin_top, rhs.margin_top))
    return true;
  if (std::less<>{}(rhs.margin_top, lhs.margin_top))
    return false;
  if (std::less<>{}(lhs.margin_right, rhs.margin_right))
    return true;
  if (std::less<>{}(rhs.margin_right, lhs.margin_right))
    return false;
  if (std::less<>{}(lhs.margin_bottom, rhs.margin_bottom))
    return true;
  if (std::less<>{}(rhs.margin_bottom, lhs.margin_bottom))
    return false;
  if (std::less<>{}(lhs.margin_left, rhs.margin_left))
    return true;
  if (std::less<>{}(rhs.margin_left, lhs.margin_left))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace printing

namespace mojo {


template <>
struct  StructTraits<::printing::mojom::PageSizeMargins::DataView,
                                         ::printing::mojom::PageSizeMarginsPtr> {
  static bool IsNull(const ::printing::mojom::PageSizeMarginsPtr& input) { return !input; }
  static void SetToNull(::printing::mojom::PageSizeMarginsPtr* output) { output->reset(); }

  static decltype(::printing::mojom::PageSizeMargins::content_width) content_width(
      const ::printing::mojom::PageSizeMarginsPtr& input) {
    return input->content_width;
  }

  static decltype(::printing::mojom::PageSizeMargins::content_height) content_height(
      const ::printing::mojom::PageSizeMarginsPtr& input) {
    return input->content_height;
  }

  static decltype(::printing::mojom::PageSizeMargins::margin_top) margin_top(
      const ::printing::mojom::PageSizeMarginsPtr& input) {
    return input->margin_top;
  }

  static decltype(::printing::mojom::PageSizeMargins::margin_right) margin_right(
      const ::printing::mojom::PageSizeMarginsPtr& input) {
    return input->margin_right;
  }

  static decltype(::printing::mojom::PageSizeMargins::margin_bottom) margin_bottom(
      const ::printing::mojom::PageSizeMarginsPtr& input) {
    return input->margin_bottom;
  }

  static decltype(::printing::mojom::PageSizeMargins::margin_left) margin_left(
      const ::printing::mojom::PageSizeMarginsPtr& input) {
    return input->margin_left;
  }

  static bool Read(::printing::mojom::PageSizeMargins::DataView input, ::printing::mojom::PageSizeMarginsPtr* output);
};

}  // namespace mojo

#endif  // PRINTING_MOJOM_PRINT_MOJOM_H_