// qtwebengine/common/renderer_configuration.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "qtwebengine/common/renderer_configuration.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "qtwebengine/common/renderer_configuration.mojom-params-data.h"
#include "qtwebengine/common/renderer_configuration.mojom-shared-message-ids.h"

#include "qtwebengine/common/renderer_configuration.mojom-import-headers.h"


#ifndef QTWEBENGINE_COMMON_RENDERER_CONFIGURATION_MOJOM_JUMBO_H_
#define QTWEBENGINE_COMMON_RENDERER_CONFIGURATION_MOJOM_JUMBO_H_
#endif
namespace qtwebengine {
namespace mojom {
const char RendererConfiguration::Name_[] = "qtwebengine.mojom.RendererConfiguration";

RendererConfigurationProxy::RendererConfigurationProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RendererConfigurationProxy::SetInitialConfiguration(
    bool in_is_incognito_process) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "qtwebengine::mojom::RendererConfiguration::SetInitialConfiguration", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("is_incognito_process", in_is_incognito_process);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRendererConfiguration_SetInitialConfiguration_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::qtwebengine::mojom::internal::RendererConfiguration_SetInitialConfiguration_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->is_incognito_process = in_is_incognito_process;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RendererConfiguration::Name_);
  message.set_method_name("SetInitialConfiguration");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool RendererConfigurationStubDispatch::Accept(
    RendererConfiguration* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kRendererConfiguration_SetInitialConfiguration_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)qtwebengine::mojom::RendererConfiguration::SetInitialConfiguration",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)qtwebengine::mojom::RendererConfiguration::SetInitialConfiguration");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RendererConfiguration_SetInitialConfiguration_Params_Data* params =
          reinterpret_cast<internal::RendererConfiguration_SetInitialConfiguration_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_is_incognito_process{};
      RendererConfiguration_SetInitialConfiguration_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_is_incognito_process = input_data_view.is_incognito_process();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RendererConfiguration::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetInitialConfiguration(
std::move(p_is_incognito_process));
      return true;
    }
  }
  return false;
}

// static
bool RendererConfigurationStubDispatch::AcceptWithResponder(
    RendererConfiguration* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kRendererConfiguration_SetInitialConfiguration_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kRendererConfigurationValidationInfo[] = {
    {internal::kRendererConfiguration_SetInitialConfiguration_Name,
     {&internal::RendererConfiguration_SetInitialConfiguration_Params_Data::Validate,
      nullptr /* no response */}},
};

bool RendererConfigurationRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::qtwebengine::mojom::RendererConfiguration::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kRendererConfigurationValidationInfo);
}

}  // namespace mojom
}  // namespace qtwebengine

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif