// services/content/public/mojom/navigable_contents.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_CONTENT_PUBLIC_MOJOM_NAVIGABLE_CONTENTS_MOJOM_PARAMS_DATA_H_
#define SERVICES_CONTENT_PUBLIC_MOJOM_NAVIGABLE_CONTENTS_MOJOM_PARAMS_DATA_H_

#include "base/macros.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif
namespace content {
namespace mojom {
namespace internal {
class COMPONENT_EXPORT(CONTENT_SERVICE_MOJOM_SHARED) NavigableContents_Navigate_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(NavigableContents_Navigate_Params_Data));
      new (data()) NavigableContents_Navigate_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    NavigableContents_Navigate_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<NavigableContents_Navigate_Params_Data>(index_);
    }
    NavigableContents_Navigate_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> url;
  mojo::internal::Pointer<internal::NavigateParams_Data> params;

 private:
  NavigableContents_Navigate_Params_Data();
  ~NavigableContents_Navigate_Params_Data() = delete;
};
static_assert(sizeof(NavigableContents_Navigate_Params_Data) == 24,
              "Bad sizeof(NavigableContents_Navigate_Params_Data)");
class COMPONENT_EXPORT(CONTENT_SERVICE_MOJOM_SHARED) NavigableContents_GoBack_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(NavigableContents_GoBack_Params_Data));
      new (data()) NavigableContents_GoBack_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    NavigableContents_GoBack_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<NavigableContents_GoBack_Params_Data>(index_);
    }
    NavigableContents_GoBack_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  NavigableContents_GoBack_Params_Data();
  ~NavigableContents_GoBack_Params_Data() = delete;
};
static_assert(sizeof(NavigableContents_GoBack_Params_Data) == 8,
              "Bad sizeof(NavigableContents_GoBack_Params_Data)");
class COMPONENT_EXPORT(CONTENT_SERVICE_MOJOM_SHARED) NavigableContents_GoBack_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(NavigableContents_GoBack_ResponseParams_Data));
      new (data()) NavigableContents_GoBack_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    NavigableContents_GoBack_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<NavigableContents_GoBack_ResponseParams_Data>(index_);
    }
    NavigableContents_GoBack_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t success : 1;
  uint8_t padfinal_[7];

 private:
  NavigableContents_GoBack_ResponseParams_Data();
  ~NavigableContents_GoBack_ResponseParams_Data() = delete;
};
static_assert(sizeof(NavigableContents_GoBack_ResponseParams_Data) == 16,
              "Bad sizeof(NavigableContents_GoBack_ResponseParams_Data)");
class COMPONENT_EXPORT(CONTENT_SERVICE_MOJOM_SHARED) NavigableContents_CreateView_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(NavigableContents_CreateView_Params_Data));
      new (data()) NavigableContents_CreateView_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    NavigableContents_CreateView_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<NavigableContents_CreateView_Params_Data>(index_);
    }
    NavigableContents_CreateView_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  NavigableContents_CreateView_Params_Data();
  ~NavigableContents_CreateView_Params_Data() = delete;
};
static_assert(sizeof(NavigableContents_CreateView_Params_Data) == 8,
              "Bad sizeof(NavigableContents_CreateView_Params_Data)");
class COMPONENT_EXPORT(CONTENT_SERVICE_MOJOM_SHARED) NavigableContents_CreateView_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(NavigableContents_CreateView_ResponseParams_Data));
      new (data()) NavigableContents_CreateView_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    NavigableContents_CreateView_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<NavigableContents_CreateView_ResponseParams_Data>(index_);
    }
    NavigableContents_CreateView_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> embed_token;

 private:
  NavigableContents_CreateView_ResponseParams_Data();
  ~NavigableContents_CreateView_ResponseParams_Data() = delete;
};
static_assert(sizeof(NavigableContents_CreateView_ResponseParams_Data) == 16,
              "Bad sizeof(NavigableContents_CreateView_ResponseParams_Data)");
class COMPONENT_EXPORT(CONTENT_SERVICE_MOJOM_SHARED) NavigableContents_Focus_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(NavigableContents_Focus_Params_Data));
      new (data()) NavigableContents_Focus_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    NavigableContents_Focus_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<NavigableContents_Focus_Params_Data>(index_);
    }
    NavigableContents_Focus_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  NavigableContents_Focus_Params_Data();
  ~NavigableContents_Focus_Params_Data() = delete;
};
static_assert(sizeof(NavigableContents_Focus_Params_Data) == 8,
              "Bad sizeof(NavigableContents_Focus_Params_Data)");
class COMPONENT_EXPORT(CONTENT_SERVICE_MOJOM_SHARED) NavigableContents_FocusThroughTabTraversal_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(NavigableContents_FocusThroughTabTraversal_Params_Data));
      new (data()) NavigableContents_FocusThroughTabTraversal_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    NavigableContents_FocusThroughTabTraversal_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<NavigableContents_FocusThroughTabTraversal_Params_Data>(index_);
    }
    NavigableContents_FocusThroughTabTraversal_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t reverse : 1;
  uint8_t padfinal_[7];

 private:
  NavigableContents_FocusThroughTabTraversal_Params_Data();
  ~NavigableContents_FocusThroughTabTraversal_Params_Data() = delete;
};
static_assert(sizeof(NavigableContents_FocusThroughTabTraversal_Params_Data) == 16,
              "Bad sizeof(NavigableContents_FocusThroughTabTraversal_Params_Data)");
class COMPONENT_EXPORT(CONTENT_SERVICE_MOJOM_SHARED) NavigableContentsClient_ClearViewFocus_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(NavigableContentsClient_ClearViewFocus_Params_Data));
      new (data()) NavigableContentsClient_ClearViewFocus_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    NavigableContentsClient_ClearViewFocus_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<NavigableContentsClient_ClearViewFocus_Params_Data>(index_);
    }
    NavigableContentsClient_ClearViewFocus_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  NavigableContentsClient_ClearViewFocus_Params_Data();
  ~NavigableContentsClient_ClearViewFocus_Params_Data() = delete;
};
static_assert(sizeof(NavigableContentsClient_ClearViewFocus_Params_Data) == 8,
              "Bad sizeof(NavigableContentsClient_ClearViewFocus_Params_Data)");
class COMPONENT_EXPORT(CONTENT_SERVICE_MOJOM_SHARED) NavigableContentsClient_DidFinishNavigation_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(NavigableContentsClient_DidFinishNavigation_Params_Data));
      new (data()) NavigableContentsClient_DidFinishNavigation_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    NavigableContentsClient_DidFinishNavigation_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<NavigableContentsClient_DidFinishNavigation_Params_Data>(index_);
    }
    NavigableContentsClient_DidFinishNavigation_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> url;
  uint8_t is_main_frame : 1;
  uint8_t is_error_page : 1;
  uint8_t pad2_[7];
  mojo::internal::Pointer<::network::mojom::internal::HttpResponseHeaders_Data> response_headers;

 private:
  NavigableContentsClient_DidFinishNavigation_Params_Data();
  ~NavigableContentsClient_DidFinishNavigation_Params_Data() = delete;
};
static_assert(sizeof(NavigableContentsClient_DidFinishNavigation_Params_Data) == 32,
              "Bad sizeof(NavigableContentsClient_DidFinishNavigation_Params_Data)");
class COMPONENT_EXPORT(CONTENT_SERVICE_MOJOM_SHARED) NavigableContentsClient_DidStopLoading_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(NavigableContentsClient_DidStopLoading_Params_Data));
      new (data()) NavigableContentsClient_DidStopLoading_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    NavigableContentsClient_DidStopLoading_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<NavigableContentsClient_DidStopLoading_Params_Data>(index_);
    }
    NavigableContentsClient_DidStopLoading_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  NavigableContentsClient_DidStopLoading_Params_Data();
  ~NavigableContentsClient_DidStopLoading_Params_Data() = delete;
};
static_assert(sizeof(NavigableContentsClient_DidStopLoading_Params_Data) == 8,
              "Bad sizeof(NavigableContentsClient_DidStopLoading_Params_Data)");
class COMPONENT_EXPORT(CONTENT_SERVICE_MOJOM_SHARED) NavigableContentsClient_DidAutoResizeView_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(NavigableContentsClient_DidAutoResizeView_Params_Data));
      new (data()) NavigableContentsClient_DidAutoResizeView_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    NavigableContentsClient_DidAutoResizeView_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<NavigableContentsClient_DidAutoResizeView_Params_Data>(index_);
    }
    NavigableContentsClient_DidAutoResizeView_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::gfx::mojom::internal::Size_Data> new_size;

 private:
  NavigableContentsClient_DidAutoResizeView_Params_Data();
  ~NavigableContentsClient_DidAutoResizeView_Params_Data() = delete;
};
static_assert(sizeof(NavigableContentsClient_DidAutoResizeView_Params_Data) == 16,
              "Bad sizeof(NavigableContentsClient_DidAutoResizeView_Params_Data)");
class COMPONENT_EXPORT(CONTENT_SERVICE_MOJOM_SHARED) NavigableContentsClient_DidSuppressNavigation_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(NavigableContentsClient_DidSuppressNavigation_Params_Data));
      new (data()) NavigableContentsClient_DidSuppressNavigation_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    NavigableContentsClient_DidSuppressNavigation_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<NavigableContentsClient_DidSuppressNavigation_Params_Data>(index_);
    }
    NavigableContentsClient_DidSuppressNavigation_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> url;
  int32_t disposition;
  uint8_t from_user_gesture : 1;
  uint8_t padfinal_[3];

 private:
  NavigableContentsClient_DidSuppressNavigation_Params_Data();
  ~NavigableContentsClient_DidSuppressNavigation_Params_Data() = delete;
};
static_assert(sizeof(NavigableContentsClient_DidSuppressNavigation_Params_Data) == 24,
              "Bad sizeof(NavigableContentsClient_DidSuppressNavigation_Params_Data)");
class COMPONENT_EXPORT(CONTENT_SERVICE_MOJOM_SHARED) NavigableContentsClient_UpdateCanGoBack_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(NavigableContentsClient_UpdateCanGoBack_Params_Data));
      new (data()) NavigableContentsClient_UpdateCanGoBack_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    NavigableContentsClient_UpdateCanGoBack_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<NavigableContentsClient_UpdateCanGoBack_Params_Data>(index_);
    }
    NavigableContentsClient_UpdateCanGoBack_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t can_go_back : 1;
  uint8_t padfinal_[7];

 private:
  NavigableContentsClient_UpdateCanGoBack_Params_Data();
  ~NavigableContentsClient_UpdateCanGoBack_Params_Data() = delete;
};
static_assert(sizeof(NavigableContentsClient_UpdateCanGoBack_Params_Data) == 16,
              "Bad sizeof(NavigableContentsClient_UpdateCanGoBack_Params_Data)");
class COMPONENT_EXPORT(CONTENT_SERVICE_MOJOM_SHARED) NavigableContentsClient_UpdateContentAXTree_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(NavigableContentsClient_UpdateContentAXTree_Params_Data));
      new (data()) NavigableContentsClient_UpdateContentAXTree_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    NavigableContentsClient_UpdateContentAXTree_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<NavigableContentsClient_UpdateContentAXTree_Params_Data>(index_);
    }
    NavigableContentsClient_UpdateContentAXTree_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  ::ax::mojom::internal::AXTreeID_Data id;

 private:
  NavigableContentsClient_UpdateContentAXTree_Params_Data();
  ~NavigableContentsClient_UpdateContentAXTree_Params_Data() = delete;
};
static_assert(sizeof(NavigableContentsClient_UpdateContentAXTree_Params_Data) == 24,
              "Bad sizeof(NavigableContentsClient_UpdateContentAXTree_Params_Data)");
class COMPONENT_EXPORT(CONTENT_SERVICE_MOJOM_SHARED) NavigableContentsClient_FocusedNodeChanged_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(NavigableContentsClient_FocusedNodeChanged_Params_Data));
      new (data()) NavigableContentsClient_FocusedNodeChanged_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    NavigableContentsClient_FocusedNodeChanged_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<NavigableContentsClient_FocusedNodeChanged_Params_Data>(index_);
    }
    NavigableContentsClient_FocusedNodeChanged_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t is_editable_node : 1;
  uint8_t pad0_[7];
  mojo::internal::Pointer<::gfx::mojom::internal::Rect_Data> node_bounds_in_screen;

 private:
  NavigableContentsClient_FocusedNodeChanged_Params_Data();
  ~NavigableContentsClient_FocusedNodeChanged_Params_Data() = delete;
};
static_assert(sizeof(NavigableContentsClient_FocusedNodeChanged_Params_Data) == 24,
              "Bad sizeof(NavigableContentsClient_FocusedNodeChanged_Params_Data)");

}  // namespace internal


class NavigableContents_Navigate_ParamsDataView {
 public:
  NavigableContents_Navigate_ParamsDataView() {}

  NavigableContents_Navigate_ParamsDataView(
      internal::NavigableContents_Navigate_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
  inline void GetParamsDataView(
      NavigateParamsDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadParams(UserType* output) {
    
    auto* pointer = data_->params.Get();
    return mojo::internal::Deserialize<::content::mojom::NavigateParamsDataView>(
        pointer, output, context_);
  }
 private:
  internal::NavigableContents_Navigate_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class NavigableContents_GoBack_ParamsDataView {
 public:
  NavigableContents_GoBack_ParamsDataView() {}

  NavigableContents_GoBack_ParamsDataView(
      internal::NavigableContents_GoBack_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::NavigableContents_GoBack_Params_Data* data_ = nullptr;
};



class NavigableContents_GoBack_ResponseParamsDataView {
 public:
  NavigableContents_GoBack_ResponseParamsDataView() {}

  NavigableContents_GoBack_ResponseParamsDataView(
      internal::NavigableContents_GoBack_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool success() const {
    return data_->success;
  }
 private:
  internal::NavigableContents_GoBack_ResponseParams_Data* data_ = nullptr;
};



class NavigableContents_CreateView_ParamsDataView {
 public:
  NavigableContents_CreateView_ParamsDataView() {}

  NavigableContents_CreateView_ParamsDataView(
      internal::NavigableContents_CreateView_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::NavigableContents_CreateView_Params_Data* data_ = nullptr;
};



class NavigableContents_CreateView_ResponseParamsDataView {
 public:
  NavigableContents_CreateView_ResponseParamsDataView() {}

  NavigableContents_CreateView_ResponseParamsDataView(
      internal::NavigableContents_CreateView_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetEmbedTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadEmbedToken(UserType* output) {
    
    auto* pointer = data_->embed_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, context_);
  }
 private:
  internal::NavigableContents_CreateView_ResponseParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class NavigableContents_Focus_ParamsDataView {
 public:
  NavigableContents_Focus_ParamsDataView() {}

  NavigableContents_Focus_ParamsDataView(
      internal::NavigableContents_Focus_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::NavigableContents_Focus_Params_Data* data_ = nullptr;
};



class NavigableContents_FocusThroughTabTraversal_ParamsDataView {
 public:
  NavigableContents_FocusThroughTabTraversal_ParamsDataView() {}

  NavigableContents_FocusThroughTabTraversal_ParamsDataView(
      internal::NavigableContents_FocusThroughTabTraversal_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool reverse() const {
    return data_->reverse;
  }
 private:
  internal::NavigableContents_FocusThroughTabTraversal_Params_Data* data_ = nullptr;
};



class NavigableContentsClient_ClearViewFocus_ParamsDataView {
 public:
  NavigableContentsClient_ClearViewFocus_ParamsDataView() {}

  NavigableContentsClient_ClearViewFocus_ParamsDataView(
      internal::NavigableContentsClient_ClearViewFocus_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::NavigableContentsClient_ClearViewFocus_Params_Data* data_ = nullptr;
};



class NavigableContentsClient_DidFinishNavigation_ParamsDataView {
 public:
  NavigableContentsClient_DidFinishNavigation_ParamsDataView() {}

  NavigableContentsClient_DidFinishNavigation_ParamsDataView(
      internal::NavigableContentsClient_DidFinishNavigation_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
  bool is_main_frame() const {
    return data_->is_main_frame;
  }
  bool is_error_page() const {
    return data_->is_error_page;
  }
  inline void GetResponseHeadersDataView(
      ::network::mojom::HttpResponseHeadersDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadResponseHeaders(UserType* output) {
    
    auto* pointer = data_->response_headers.Get();
    return mojo::internal::Deserialize<::network::mojom::HttpResponseHeadersDataView>(
        pointer, output, context_);
  }
 private:
  internal::NavigableContentsClient_DidFinishNavigation_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class NavigableContentsClient_DidStopLoading_ParamsDataView {
 public:
  NavigableContentsClient_DidStopLoading_ParamsDataView() {}

  NavigableContentsClient_DidStopLoading_ParamsDataView(
      internal::NavigableContentsClient_DidStopLoading_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::NavigableContentsClient_DidStopLoading_Params_Data* data_ = nullptr;
};



class NavigableContentsClient_DidAutoResizeView_ParamsDataView {
 public:
  NavigableContentsClient_DidAutoResizeView_ParamsDataView() {}

  NavigableContentsClient_DidAutoResizeView_ParamsDataView(
      internal::NavigableContentsClient_DidAutoResizeView_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetNewSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadNewSize(UserType* output) {
    
    auto* pointer = data_->new_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, context_);
  }
 private:
  internal::NavigableContentsClient_DidAutoResizeView_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class NavigableContentsClient_DidSuppressNavigation_ParamsDataView {
 public:
  NavigableContentsClient_DidSuppressNavigation_ParamsDataView() {}

  NavigableContentsClient_DidSuppressNavigation_ParamsDataView(
      internal::NavigableContentsClient_DidSuppressNavigation_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDisposition(UserType* output) const {
    auto data_value = data_->disposition;
    return mojo::internal::Deserialize<::ui::mojom::WindowOpenDisposition>(
        data_value, output);
  }

  ::ui::mojom::WindowOpenDisposition disposition() const {
    return static_cast<::ui::mojom::WindowOpenDisposition>(data_->disposition);
  }
  bool from_user_gesture() const {
    return data_->from_user_gesture;
  }
 private:
  internal::NavigableContentsClient_DidSuppressNavigation_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class NavigableContentsClient_UpdateCanGoBack_ParamsDataView {
 public:
  NavigableContentsClient_UpdateCanGoBack_ParamsDataView() {}

  NavigableContentsClient_UpdateCanGoBack_ParamsDataView(
      internal::NavigableContentsClient_UpdateCanGoBack_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool can_go_back() const {
    return data_->can_go_back;
  }
 private:
  internal::NavigableContentsClient_UpdateCanGoBack_Params_Data* data_ = nullptr;
};



class NavigableContentsClient_UpdateContentAXTree_ParamsDataView {
 public:
  NavigableContentsClient_UpdateContentAXTree_ParamsDataView() {}

  NavigableContentsClient_UpdateContentAXTree_ParamsDataView(
      internal::NavigableContentsClient_UpdateContentAXTree_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      ::ax::mojom::AXTreeIDDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadId(UserType* output) {
    
    auto* pointer = !data_->id.is_null() ? &data_->id : nullptr;
    return mojo::internal::Deserialize<::ax::mojom::AXTreeIDDataView>(
        pointer, output, context_);
  }
 private:
  internal::NavigableContentsClient_UpdateContentAXTree_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class NavigableContentsClient_FocusedNodeChanged_ParamsDataView {
 public:
  NavigableContentsClient_FocusedNodeChanged_ParamsDataView() {}

  NavigableContentsClient_FocusedNodeChanged_ParamsDataView(
      internal::NavigableContentsClient_FocusedNodeChanged_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  bool is_editable_node() const {
    return data_->is_editable_node;
  }
  inline void GetNodeBoundsInScreenDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadNodeBoundsInScreen(UserType* output) {
    
    auto* pointer = data_->node_bounds_in_screen.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, context_);
  }
 private:
  internal::NavigableContentsClient_FocusedNodeChanged_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};


inline void NavigableContents_Navigate_ParamsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}
inline void NavigableContents_Navigate_ParamsDataView::GetParamsDataView(
    NavigateParamsDataView* output) {
  auto pointer = data_->params.Get();
  *output = NavigateParamsDataView(pointer, context_);
}








inline void NavigableContents_CreateView_ResponseParamsDataView::GetEmbedTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->embed_token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, context_);
}








inline void NavigableContentsClient_DidFinishNavigation_ParamsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}
inline void NavigableContentsClient_DidFinishNavigation_ParamsDataView::GetResponseHeadersDataView(
    ::network::mojom::HttpResponseHeadersDataView* output) {
  auto pointer = data_->response_headers.Get();
  *output = ::network::mojom::HttpResponseHeadersDataView(pointer, context_);
}




inline void NavigableContentsClient_DidAutoResizeView_ParamsDataView::GetNewSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->new_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, context_);
}


inline void NavigableContentsClient_DidSuppressNavigation_ParamsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}




inline void NavigableContentsClient_UpdateContentAXTree_ParamsDataView::GetIdDataView(
    ::ax::mojom::AXTreeIDDataView* output) {
  auto pointer = &data_->id;
  *output = ::ax::mojom::AXTreeIDDataView(pointer, context_);
}


inline void NavigableContentsClient_FocusedNodeChanged_ParamsDataView::GetNodeBoundsInScreenDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->node_bounds_in_screen.Get();
  *output = ::gfx::mojom::RectDataView(pointer, context_);
}

}  // namespace mojom
}  // namespace content

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // SERVICES_CONTENT_PUBLIC_MOJOM_NAVIGABLE_CONTENTS_MOJOM_PARAMS_DATA_H_