// services/device/public/mojom/usb_enumeration_options.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/device/public/mojom/usb_enumeration_options.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/device/public/mojom/usb_enumeration_options.mojom-params-data.h"
#include "services/device/public/mojom/usb_enumeration_options.mojom-shared-message-ids.h"

#include "services/device/public/mojom/usb_enumeration_options.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_USB_ENUMERATION_OPTIONS_MOJOM_BLINK_JUMBO_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_USB_ENUMERATION_OPTIONS_MOJOM_BLINK_JUMBO_H_
#endif
namespace device {
namespace mojom {
namespace blink {
UsbDeviceFilter::UsbDeviceFilter()
    : has_vendor_id(),
      vendor_id(),
      has_product_id(),
      product_id(),
      has_class_code(),
      class_code(),
      has_subclass_code(),
      subclass_code(),
      has_protocol_code(),
      protocol_code(),
      serial_number() {}

UsbDeviceFilter::UsbDeviceFilter(
    bool has_vendor_id_in,
    uint16_t vendor_id_in,
    bool has_product_id_in,
    uint16_t product_id_in,
    bool has_class_code_in,
    uint8_t class_code_in,
    bool has_subclass_code_in,
    uint8_t subclass_code_in,
    bool has_protocol_code_in,
    uint8_t protocol_code_in,
    const ::WTF::String& serial_number_in)
    : has_vendor_id(std::move(has_vendor_id_in)),
      vendor_id(std::move(vendor_id_in)),
      has_product_id(std::move(has_product_id_in)),
      product_id(std::move(product_id_in)),
      has_class_code(std::move(has_class_code_in)),
      class_code(std::move(class_code_in)),
      has_subclass_code(std::move(has_subclass_code_in)),
      subclass_code(std::move(subclass_code_in)),
      has_protocol_code(std::move(has_protocol_code_in)),
      protocol_code(std::move(protocol_code_in)),
      serial_number(std::move(serial_number_in)) {}

UsbDeviceFilter::~UsbDeviceFilter() = default;

void UsbDeviceFilter::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetBoolean("has_vendor_id", this->has_vendor_id);
  value->SetInteger("vendor_id", this->vendor_id);
  value->SetBoolean("has_product_id", this->has_product_id);
  value->SetInteger("product_id", this->product_id);
  value->SetBoolean("has_class_code", this->has_class_code);
  value->SetInteger("class_code", this->class_code);
  value->SetBoolean("has_subclass_code", this->has_subclass_code);
  value->SetInteger("subclass_code", this->subclass_code);
  value->SetBoolean("has_protocol_code", this->has_protocol_code);
  value->SetInteger("protocol_code", this->protocol_code);
  value->SetString("serial_number", base::trace_event::ValueToString(this->serial_number, "<value of type const ::WTF::String&>"));
}

bool UsbDeviceFilter::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
UsbEnumerationOptions::UsbEnumerationOptions()
    : filters() {}

UsbEnumerationOptions::UsbEnumerationOptions(
    WTF::Vector<UsbDeviceFilterPtr> filters_in)
    : filters(std::move(filters_in)) {}

UsbEnumerationOptions::~UsbEnumerationOptions() = default;

void UsbEnumerationOptions::AsValueInto(base::trace_event::TracedValue* value) const {
  value->BeginArray("filters");
  for (const auto& item0 : this->filters) {
    if (item0.is_null()) {
      value->AppendString("nullptr");
    } else {
      value->BeginDictionary();
      item0->AsValueInto(value);
      value->EndDictionary();
    }
  }
  value->EndArray();
}

bool UsbEnumerationOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace blink
}  // namespace mojom
}  // namespace device

namespace mojo {


// static
bool StructTraits<::device::mojom::blink::UsbDeviceFilter::DataView, ::device::mojom::blink::UsbDeviceFilterPtr>::Read(
    ::device::mojom::blink::UsbDeviceFilter::DataView input,
    ::device::mojom::blink::UsbDeviceFilterPtr* output) {
  bool success = true;
  ::device::mojom::blink::UsbDeviceFilterPtr result(::device::mojom::blink::UsbDeviceFilter::New());
  
      if (success)
        result->has_vendor_id = input.has_vendor_id();
      if (success)
        result->vendor_id = input.vendor_id();
      if (success)
        result->has_product_id = input.has_product_id();
      if (success)
        result->product_id = input.product_id();
      if (success)
        result->has_class_code = input.has_class_code();
      if (success)
        result->class_code = input.class_code();
      if (success)
        result->has_subclass_code = input.has_subclass_code();
      if (success)
        result->subclass_code = input.subclass_code();
      if (success)
        result->has_protocol_code = input.has_protocol_code();
      if (success)
        result->protocol_code = input.protocol_code();
      if (success && !input.ReadSerialNumber(&result->serial_number))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::UsbEnumerationOptions::DataView, ::device::mojom::blink::UsbEnumerationOptionsPtr>::Read(
    ::device::mojom::blink::UsbEnumerationOptions::DataView input,
    ::device::mojom::blink::UsbEnumerationOptionsPtr* output) {
  bool success = true;
  ::device::mojom::blink::UsbEnumerationOptionsPtr result(::device::mojom::blink::UsbEnumerationOptions::New());
  
      if (success && !input.ReadFilters(&result->filters))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif