// services/network/public/mojom/cookie_access_observer.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_ACCESS_OBSERVER_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_ACCESS_OBSERVER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "services/network/public/mojom/cookie_access_observer.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"
#include "services/network/public/mojom/site_for_cookies.mojom-shared.h"
#include "services/network/public/mojom/cookie_manager.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"






namespace network {
namespace mojom {
class CookieAccessDetailsDataView;



}  // namespace mojom
}  // namespace network

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::CookieAccessDetailsDataView> {
  using Data = ::network::mojom::internal::CookieAccessDetails_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network {
namespace mojom {


enum class CookieAccessDetails_Type : int32_t {
  
  kRead = 0,
  
  kChange = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, CookieAccessDetails_Type value);
inline bool IsKnownEnumValue(CookieAccessDetails_Type value) {
  return internal::CookieAccessDetails_Type_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class CookieAccessObserverInterfaceBase {};

using CookieAccessObserverPtrDataView =
    mojo::InterfacePtrDataView<CookieAccessObserverInterfaceBase>;
using CookieAccessObserverRequestDataView =
    mojo::InterfaceRequestDataView<CookieAccessObserverInterfaceBase>;
using CookieAccessObserverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<CookieAccessObserverInterfaceBase>;
using CookieAccessObserverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<CookieAccessObserverInterfaceBase>;


class CookieAccessDetailsDataView {
 public:
  CookieAccessDetailsDataView() {}

  CookieAccessDetailsDataView(
      internal::CookieAccessDetails_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::network::mojom::CookieAccessDetails_Type>(
        data_value, output);
  }

  CookieAccessDetails_Type type() const {
    return static_cast<CookieAccessDetails_Type>(data_->type);
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
  inline void GetSiteForCookiesDataView(
      ::network::mojom::SiteForCookiesDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSiteForCookies(UserType* output) {
    
    auto* pointer = data_->site_for_cookies.Get();
    return mojo::internal::Deserialize<::network::mojom::SiteForCookiesDataView>(
        pointer, output, context_);
  }
  inline void GetCookieListDataView(
      mojo::ArrayDataView<::network::mojom::CookieWithAccessResultDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadCookieList(UserType* output) {
    
    auto* pointer = data_->cookie_list.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::CookieWithAccessResultDataView>>(
        pointer, output, context_);
  }
  inline void GetDevtoolsRequestIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDevtoolsRequestId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `devtools_request_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDevtoolsRequestId` instead "
    "of `ReadDevtoolsRequestId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->devtools_request_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
 private:
  internal::CookieAccessDetails_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace network

namespace std {

template <>
struct hash<::network::mojom::CookieAccessDetails_Type>
    : public mojo::internal::EnumHashImpl<::network::mojom::CookieAccessDetails_Type> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::network::mojom::CookieAccessDetails_Type, ::network::mojom::CookieAccessDetails_Type> {
  static ::network::mojom::CookieAccessDetails_Type ToMojom(::network::mojom::CookieAccessDetails_Type input) { return input; }
  static bool FromMojom(::network::mojom::CookieAccessDetails_Type input, ::network::mojom::CookieAccessDetails_Type* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CookieAccessDetails_Type, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::CookieAccessDetails_Type, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::network::mojom::CookieAccessDetails_Type>(input), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CookieAccessDetailsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CookieAccessDetailsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::network::mojom::internal::CookieAccessDetails_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    mojo::internal::Serialize<::network::mojom::CookieAccessDetails_Type>(
        Traits::type(input), &(*output)->type);
    decltype(Traits::url(input)) in_url = Traits::url(input);
    typename decltype((*output)->url)::BaseType::BufferWriter
        url_writer;
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_url, buffer, &url_writer, context);
    (*output)->url.Set(
        url_writer.is_null() ? nullptr : url_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in CookieAccessDetails struct");
    decltype(Traits::site_for_cookies(input)) in_site_for_cookies = Traits::site_for_cookies(input);
    typename decltype((*output)->site_for_cookies)::BaseType::BufferWriter
        site_for_cookies_writer;
    mojo::internal::Serialize<::network::mojom::SiteForCookiesDataView>(
        in_site_for_cookies, buffer, &site_for_cookies_writer, context);
    (*output)->site_for_cookies.Set(
        site_for_cookies_writer.is_null() ? nullptr : site_for_cookies_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->site_for_cookies.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null site_for_cookies in CookieAccessDetails struct");
    decltype(Traits::cookie_list(input)) in_cookie_list = Traits::cookie_list(input);
    typename decltype((*output)->cookie_list)::BaseType::BufferWriter
        cookie_list_writer;
    const mojo::internal::ContainerValidateParams cookie_list_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::CookieWithAccessResultDataView>>(
        in_cookie_list, buffer, &cookie_list_writer, &cookie_list_validate_params,
        context);
    (*output)->cookie_list.Set(
        cookie_list_writer.is_null() ? nullptr : cookie_list_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->cookie_list.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null cookie_list in CookieAccessDetails struct");
    decltype(Traits::devtools_request_id(input)) in_devtools_request_id = Traits::devtools_request_id(input);
    typename decltype((*output)->devtools_request_id)::BaseType::BufferWriter
        devtools_request_id_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_devtools_request_id, buffer, &devtools_request_id_writer, context);
    (*output)->devtools_request_id.Set(
        devtools_request_id_writer.is_null() ? nullptr : devtools_request_id_writer.data());
  }

  static bool Deserialize(::network::mojom::internal::CookieAccessDetails_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::CookieAccessDetailsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network {
namespace mojom {

inline void CookieAccessDetailsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}
inline void CookieAccessDetailsDataView::GetSiteForCookiesDataView(
    ::network::mojom::SiteForCookiesDataView* output) {
  auto pointer = data_->site_for_cookies.Get();
  *output = ::network::mojom::SiteForCookiesDataView(pointer, context_);
}
inline void CookieAccessDetailsDataView::GetCookieListDataView(
    mojo::ArrayDataView<::network::mojom::CookieWithAccessResultDataView>* output) {
  auto pointer = data_->cookie_list.Get();
  *output = mojo::ArrayDataView<::network::mojom::CookieWithAccessResultDataView>(pointer, context_);
}
inline void CookieAccessDetailsDataView::GetDevtoolsRequestIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->devtools_request_id.Get();
  *output = mojo::StringDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace network

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_ACCESS_OBSERVER_MOJOM_SHARED_H_