// services/network/public/mojom/cross_origin_opener_policy.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CROSS_ORIGIN_OPENER_POLICY_MOJOM_PARAMS_DATA_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CROSS_ORIGIN_OPENER_POLICY_MOJOM_PARAMS_DATA_H_

#include "base/macros.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif
namespace network {
namespace mojom {
namespace internal {
class  CrossOriginOpenerPolicyReporter_QueueAccessReport_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(CrossOriginOpenerPolicyReporter_QueueAccessReport_Params_Data));
      new (data()) CrossOriginOpenerPolicyReporter_QueueAccessReport_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    CrossOriginOpenerPolicyReporter_QueueAccessReport_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<CrossOriginOpenerPolicyReporter_QueueAccessReport_Params_Data>(index_);
    }
    CrossOriginOpenerPolicyReporter_QueueAccessReport_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t report_type;
  uint8_t pad0_[4];
  mojo::internal::Pointer<mojo::internal::String_Data> property;
  mojo::internal::Pointer<::network::mojom::internal::SourceLocation_Data> source_location;
  mojo::internal::Pointer<mojo::internal::String_Data> reported_window_url;

 private:
  CrossOriginOpenerPolicyReporter_QueueAccessReport_Params_Data();
  ~CrossOriginOpenerPolicyReporter_QueueAccessReport_Params_Data() = delete;
};
static_assert(sizeof(CrossOriginOpenerPolicyReporter_QueueAccessReport_Params_Data) == 40,
              "Bad sizeof(CrossOriginOpenerPolicyReporter_QueueAccessReport_Params_Data)");

}  // namespace internal


class CrossOriginOpenerPolicyReporter_QueueAccessReport_ParamsDataView {
 public:
  CrossOriginOpenerPolicyReporter_QueueAccessReport_ParamsDataView() {}

  CrossOriginOpenerPolicyReporter_QueueAccessReport_ParamsDataView(
      internal::CrossOriginOpenerPolicyReporter_QueueAccessReport_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadReportType(UserType* output) const {
    auto data_value = data_->report_type;
    return mojo::internal::Deserialize<::network::mojom::CoopAccessReportType>(
        data_value, output);
  }

  CoopAccessReportType report_type() const {
    return static_cast<CoopAccessReportType>(data_->report_type);
  }
  inline void GetPropertyDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadProperty(UserType* output) {
    
    auto* pointer = data_->property.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetSourceLocationDataView(
      ::network::mojom::SourceLocationDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSourceLocation(UserType* output) {
    
    auto* pointer = data_->source_location.Get();
    return mojo::internal::Deserialize<::network::mojom::SourceLocationDataView>(
        pointer, output, context_);
  }
  inline void GetReportedWindowUrlDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadReportedWindowUrl(UserType* output) {
    
    auto* pointer = data_->reported_window_url.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
 private:
  internal::CrossOriginOpenerPolicyReporter_QueueAccessReport_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};


inline void CrossOriginOpenerPolicyReporter_QueueAccessReport_ParamsDataView::GetPropertyDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->property.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void CrossOriginOpenerPolicyReporter_QueueAccessReport_ParamsDataView::GetSourceLocationDataView(
    ::network::mojom::SourceLocationDataView* output) {
  auto pointer = data_->source_location.Get();
  *output = ::network::mojom::SourceLocationDataView(pointer, context_);
}
inline void CrossOriginOpenerPolicyReporter_QueueAccessReport_ParamsDataView::GetReportedWindowUrlDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->reported_window_url.Get();
  *output = mojo::StringDataView(pointer, context_);
}

}  // namespace mojom
}  // namespace network

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_CROSS_ORIGIN_OPENER_POLICY_MOJOM_PARAMS_DATA_H_