// services/network/public/mojom/http_raw_request_response_info.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_HTTP_RAW_REQUEST_RESPONSE_INFO_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_HTTP_RAW_REQUEST_RESPONSE_INFO_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "services/network/public/mojom/http_raw_request_response_info.mojom-shared-internal.h"
#include "services/network/public/mojom/http_raw_headers.mojom-shared.h"







namespace network {
namespace mojom {
class HttpRawRequestResponseInfoDataView;



}  // namespace mojom
}  // namespace network

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::HttpRawRequestResponseInfoDataView> {
  using Data = ::network::mojom::internal::HttpRawRequestResponseInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network {
namespace mojom {


class HttpRawRequestResponseInfoDataView {
 public:
  HttpRawRequestResponseInfoDataView() {}

  HttpRawRequestResponseInfoDataView(
      internal::HttpRawRequestResponseInfo_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  int32_t http_status_code() const {
    return data_->http_status_code;
  }
  inline void GetHttpStatusTextDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadHttpStatusText(UserType* output) {
    
    auto* pointer = data_->http_status_text.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetRequestHeadersDataView(
      mojo::ArrayDataView<::network::mojom::HttpRawHeaderPairDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRequestHeaders(UserType* output) {
    
    auto* pointer = data_->request_headers.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::HttpRawHeaderPairDataView>>(
        pointer, output, context_);
  }
  inline void GetResponseHeadersDataView(
      mojo::ArrayDataView<::network::mojom::HttpRawHeaderPairDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadResponseHeaders(UserType* output) {
    
    auto* pointer = data_->response_headers.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::HttpRawHeaderPairDataView>>(
        pointer, output, context_);
  }
  inline void GetRequestHeadersTextDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRequestHeadersText(UserType* output) {
    
    auto* pointer = data_->request_headers_text.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetResponseHeadersTextDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadResponseHeadersText(UserType* output) {
    
    auto* pointer = data_->response_headers_text.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
 private:
  internal::HttpRawRequestResponseInfo_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace network

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::HttpRawRequestResponseInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::HttpRawRequestResponseInfoDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::network::mojom::internal::HttpRawRequestResponseInfo_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->http_status_code = Traits::http_status_code(input);
    decltype(Traits::http_status_text(input)) in_http_status_text = Traits::http_status_text(input);
    typename decltype((*output)->http_status_text)::BaseType::BufferWriter
        http_status_text_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_http_status_text, buffer, &http_status_text_writer, context);
    (*output)->http_status_text.Set(
        http_status_text_writer.is_null() ? nullptr : http_status_text_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->http_status_text.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null http_status_text in HttpRawRequestResponseInfo struct");
    decltype(Traits::request_headers(input)) in_request_headers = Traits::request_headers(input);
    typename decltype((*output)->request_headers)::BaseType::BufferWriter
        request_headers_writer;
    const mojo::internal::ContainerValidateParams request_headers_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::HttpRawHeaderPairDataView>>(
        in_request_headers, buffer, &request_headers_writer, &request_headers_validate_params,
        context);
    (*output)->request_headers.Set(
        request_headers_writer.is_null() ? nullptr : request_headers_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->request_headers.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null request_headers in HttpRawRequestResponseInfo struct");
    decltype(Traits::response_headers(input)) in_response_headers = Traits::response_headers(input);
    typename decltype((*output)->response_headers)::BaseType::BufferWriter
        response_headers_writer;
    const mojo::internal::ContainerValidateParams response_headers_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::HttpRawHeaderPairDataView>>(
        in_response_headers, buffer, &response_headers_writer, &response_headers_validate_params,
        context);
    (*output)->response_headers.Set(
        response_headers_writer.is_null() ? nullptr : response_headers_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->response_headers.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null response_headers in HttpRawRequestResponseInfo struct");
    decltype(Traits::request_headers_text(input)) in_request_headers_text = Traits::request_headers_text(input);
    typename decltype((*output)->request_headers_text)::BaseType::BufferWriter
        request_headers_text_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_request_headers_text, buffer, &request_headers_text_writer, context);
    (*output)->request_headers_text.Set(
        request_headers_text_writer.is_null() ? nullptr : request_headers_text_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->request_headers_text.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null request_headers_text in HttpRawRequestResponseInfo struct");
    decltype(Traits::response_headers_text(input)) in_response_headers_text = Traits::response_headers_text(input);
    typename decltype((*output)->response_headers_text)::BaseType::BufferWriter
        response_headers_text_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_response_headers_text, buffer, &response_headers_text_writer, context);
    (*output)->response_headers_text.Set(
        response_headers_text_writer.is_null() ? nullptr : response_headers_text_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->response_headers_text.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null response_headers_text in HttpRawRequestResponseInfo struct");
  }

  static bool Deserialize(::network::mojom::internal::HttpRawRequestResponseInfo_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::HttpRawRequestResponseInfoDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network {
namespace mojom {

inline void HttpRawRequestResponseInfoDataView::GetHttpStatusTextDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->http_status_text.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void HttpRawRequestResponseInfoDataView::GetRequestHeadersDataView(
    mojo::ArrayDataView<::network::mojom::HttpRawHeaderPairDataView>* output) {
  auto pointer = data_->request_headers.Get();
  *output = mojo::ArrayDataView<::network::mojom::HttpRawHeaderPairDataView>(pointer, context_);
}
inline void HttpRawRequestResponseInfoDataView::GetResponseHeadersDataView(
    mojo::ArrayDataView<::network::mojom::HttpRawHeaderPairDataView>* output) {
  auto pointer = data_->response_headers.Get();
  *output = mojo::ArrayDataView<::network::mojom::HttpRawHeaderPairDataView>(pointer, context_);
}
inline void HttpRawRequestResponseInfoDataView::GetRequestHeadersTextDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->request_headers_text.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void HttpRawRequestResponseInfoDataView::GetResponseHeadersTextDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->response_headers_text.Get();
  *output = mojo::StringDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace network

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_HTTP_RAW_REQUEST_RESPONSE_INFO_MOJOM_SHARED_H_