// services/network/public/mojom/load_timing_info.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_LOAD_TIMING_INFO_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_LOAD_TIMING_INFO_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/network/public/mojom/load_timing_info.mojom-shared.h"
#include "services/network/public/mojom/load_timing_info.mojom-forward.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include <string>
#include <vector>




#include "services/network/public/cpp/load_timing_info_mojom_traits.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace network {
namespace mojom {









class  LoadTimingInfoConnectTiming {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<LoadTimingInfoConnectTiming, T>::value>;
  using DataView = LoadTimingInfoConnectTimingDataView;
  using Data_ = internal::LoadTimingInfoConnectTiming_Data;

  template <typename... Args>
  static LoadTimingInfoConnectTimingPtr New(Args&&... args) {
    return LoadTimingInfoConnectTimingPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LoadTimingInfoConnectTimingPtr From(const U& u) {
    return mojo::TypeConverter<LoadTimingInfoConnectTimingPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, LoadTimingInfoConnectTiming>::Convert(*this);
  }


  LoadTimingInfoConnectTiming();

  LoadTimingInfoConnectTiming(
      ::base::TimeTicks dns_start,
      ::base::TimeTicks dns_end,
      ::base::TimeTicks connect_start,
      ::base::TimeTicks connect_end,
      ::base::TimeTicks ssl_start,
      ::base::TimeTicks ssl_end);

  ~LoadTimingInfoConnectTiming();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LoadTimingInfoConnectTimingPtr>
  LoadTimingInfoConnectTimingPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, LoadTimingInfoConnectTiming::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LoadTimingInfoConnectTiming::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        LoadTimingInfoConnectTiming::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::LoadTimingInfoConnectTiming_UnserializedMessageContext<
            UserType, LoadTimingInfoConnectTiming::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<LoadTimingInfoConnectTiming::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return LoadTimingInfoConnectTiming::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::LoadTimingInfoConnectTiming_UnserializedMessageContext<
            UserType, LoadTimingInfoConnectTiming::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<LoadTimingInfoConnectTiming::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::base::TimeTicks dns_start;
  
  ::base::TimeTicks dns_end;
  
  ::base::TimeTicks connect_start;
  
  ::base::TimeTicks connect_end;
  
  ::base::TimeTicks ssl_start;
  
  ::base::TimeTicks ssl_end;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, LoadTimingInfoConnectTiming::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, LoadTimingInfoConnectTiming::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, LoadTimingInfoConnectTiming::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, LoadTimingInfoConnectTiming::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  LoadTimingInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<LoadTimingInfo, T>::value>;
  using DataView = LoadTimingInfoDataView;
  using Data_ = internal::LoadTimingInfo_Data;

  template <typename... Args>
  static LoadTimingInfoPtr New(Args&&... args) {
    return LoadTimingInfoPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LoadTimingInfoPtr From(const U& u) {
    return mojo::TypeConverter<LoadTimingInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, LoadTimingInfo>::Convert(*this);
  }


  LoadTimingInfo();

  LoadTimingInfo(
      bool socket_reused,
      uint32_t socket_log_id,
      ::base::Time request_start_time,
      ::base::TimeTicks request_start,
      ::base::TimeTicks proxy_resolve_start,
      ::base::TimeTicks proxy_resolve_end,
      const ::net::LoadTimingInfo::ConnectTiming& connect_timing,
      ::base::TimeTicks send_start,
      ::base::TimeTicks send_end,
      ::base::TimeTicks receive_headers_start,
      ::base::TimeTicks receive_headers_end,
      ::base::TimeTicks first_early_hints_time,
      ::base::TimeTicks push_start,
      ::base::TimeTicks push_end,
      ::base::TimeTicks service_worker_start_time,
      ::base::TimeTicks service_worker_ready_time,
      ::base::TimeTicks service_worker_fetch_start,
      ::base::TimeTicks service_worker_respond_with_settled);

  ~LoadTimingInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LoadTimingInfoPtr>
  LoadTimingInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, LoadTimingInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LoadTimingInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        LoadTimingInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::LoadTimingInfo_UnserializedMessageContext<
            UserType, LoadTimingInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<LoadTimingInfo::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return LoadTimingInfo::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::LoadTimingInfo_UnserializedMessageContext<
            UserType, LoadTimingInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<LoadTimingInfo::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  bool socket_reused;
  
  uint32_t socket_log_id;
  
  ::base::Time request_start_time;
  
  ::base::TimeTicks request_start;
  
  ::base::TimeTicks proxy_resolve_start;
  
  ::base::TimeTicks proxy_resolve_end;
  
  ::net::LoadTimingInfo::ConnectTiming connect_timing;
  
  ::base::TimeTicks send_start;
  
  ::base::TimeTicks send_end;
  
  ::base::TimeTicks receive_headers_start;
  
  ::base::TimeTicks receive_headers_end;
  
  ::base::TimeTicks first_early_hints_time;
  
  ::base::TimeTicks push_start;
  
  ::base::TimeTicks push_end;
  
  ::base::TimeTicks service_worker_start_time;
  
  ::base::TimeTicks service_worker_ready_time;
  
  ::base::TimeTicks service_worker_fetch_start;
  
  ::base::TimeTicks service_worker_respond_with_settled;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, LoadTimingInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, LoadTimingInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, LoadTimingInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, LoadTimingInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
LoadTimingInfoConnectTimingPtr LoadTimingInfoConnectTiming::Clone() const {
  return New(
      mojo::Clone(dns_start),
      mojo::Clone(dns_end),
      mojo::Clone(connect_start),
      mojo::Clone(connect_end),
      mojo::Clone(ssl_start),
      mojo::Clone(ssl_end)
  );
}

template <typename T, LoadTimingInfoConnectTiming::EnableIfSame<T>*>
bool LoadTimingInfoConnectTiming::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->dns_start, other_struct.dns_start))
    return false;
  if (!mojo::Equals(this->dns_end, other_struct.dns_end))
    return false;
  if (!mojo::Equals(this->connect_start, other_struct.connect_start))
    return false;
  if (!mojo::Equals(this->connect_end, other_struct.connect_end))
    return false;
  if (!mojo::Equals(this->ssl_start, other_struct.ssl_start))
    return false;
  if (!mojo::Equals(this->ssl_end, other_struct.ssl_end))
    return false;
  return true;
}

template <typename T, LoadTimingInfoConnectTiming::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.dns_start, rhs.dns_start))
    return true;
  if (std::less<>{}(rhs.dns_start, lhs.dns_start))
    return false;
  if (std::less<>{}(lhs.dns_end, rhs.dns_end))
    return true;
  if (std::less<>{}(rhs.dns_end, lhs.dns_end))
    return false;
  if (std::less<>{}(lhs.connect_start, rhs.connect_start))
    return true;
  if (std::less<>{}(rhs.connect_start, lhs.connect_start))
    return false;
  if (std::less<>{}(lhs.connect_end, rhs.connect_end))
    return true;
  if (std::less<>{}(rhs.connect_end, lhs.connect_end))
    return false;
  if (std::less<>{}(lhs.ssl_start, rhs.ssl_start))
    return true;
  if (std::less<>{}(rhs.ssl_start, lhs.ssl_start))
    return false;
  if (std::less<>{}(lhs.ssl_end, rhs.ssl_end))
    return true;
  if (std::less<>{}(rhs.ssl_end, lhs.ssl_end))
    return false;
  return false;
}
template <typename StructPtrType>
LoadTimingInfoPtr LoadTimingInfo::Clone() const {
  return New(
      mojo::Clone(socket_reused),
      mojo::Clone(socket_log_id),
      mojo::Clone(request_start_time),
      mojo::Clone(request_start),
      mojo::Clone(proxy_resolve_start),
      mojo::Clone(proxy_resolve_end),
      mojo::Clone(connect_timing),
      mojo::Clone(send_start),
      mojo::Clone(send_end),
      mojo::Clone(receive_headers_start),
      mojo::Clone(receive_headers_end),
      mojo::Clone(first_early_hints_time),
      mojo::Clone(push_start),
      mojo::Clone(push_end),
      mojo::Clone(service_worker_start_time),
      mojo::Clone(service_worker_ready_time),
      mojo::Clone(service_worker_fetch_start),
      mojo::Clone(service_worker_respond_with_settled)
  );
}

template <typename T, LoadTimingInfo::EnableIfSame<T>*>
bool LoadTimingInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->socket_reused, other_struct.socket_reused))
    return false;
  if (!mojo::Equals(this->socket_log_id, other_struct.socket_log_id))
    return false;
  if (!mojo::Equals(this->request_start_time, other_struct.request_start_time))
    return false;
  if (!mojo::Equals(this->request_start, other_struct.request_start))
    return false;
  if (!mojo::Equals(this->proxy_resolve_start, other_struct.proxy_resolve_start))
    return false;
  if (!mojo::Equals(this->proxy_resolve_end, other_struct.proxy_resolve_end))
    return false;
  if (!mojo::Equals(this->connect_timing, other_struct.connect_timing))
    return false;
  if (!mojo::Equals(this->send_start, other_struct.send_start))
    return false;
  if (!mojo::Equals(this->send_end, other_struct.send_end))
    return false;
  if (!mojo::Equals(this->receive_headers_start, other_struct.receive_headers_start))
    return false;
  if (!mojo::Equals(this->receive_headers_end, other_struct.receive_headers_end))
    return false;
  if (!mojo::Equals(this->first_early_hints_time, other_struct.first_early_hints_time))
    return false;
  if (!mojo::Equals(this->push_start, other_struct.push_start))
    return false;
  if (!mojo::Equals(this->push_end, other_struct.push_end))
    return false;
  if (!mojo::Equals(this->service_worker_start_time, other_struct.service_worker_start_time))
    return false;
  if (!mojo::Equals(this->service_worker_ready_time, other_struct.service_worker_ready_time))
    return false;
  if (!mojo::Equals(this->service_worker_fetch_start, other_struct.service_worker_fetch_start))
    return false;
  if (!mojo::Equals(this->service_worker_respond_with_settled, other_struct.service_worker_respond_with_settled))
    return false;
  return true;
}

template <typename T, LoadTimingInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.socket_reused, rhs.socket_reused))
    return true;
  if (std::less<>{}(rhs.socket_reused, lhs.socket_reused))
    return false;
  if (std::less<>{}(lhs.socket_log_id, rhs.socket_log_id))
    return true;
  if (std::less<>{}(rhs.socket_log_id, lhs.socket_log_id))
    return false;
  if (std::less<>{}(lhs.request_start_time, rhs.request_start_time))
    return true;
  if (std::less<>{}(rhs.request_start_time, lhs.request_start_time))
    return false;
  if (std::less<>{}(lhs.request_start, rhs.request_start))
    return true;
  if (std::less<>{}(rhs.request_start, lhs.request_start))
    return false;
  if (std::less<>{}(lhs.proxy_resolve_start, rhs.proxy_resolve_start))
    return true;
  if (std::less<>{}(rhs.proxy_resolve_start, lhs.proxy_resolve_start))
    return false;
  if (std::less<>{}(lhs.proxy_resolve_end, rhs.proxy_resolve_end))
    return true;
  if (std::less<>{}(rhs.proxy_resolve_end, lhs.proxy_resolve_end))
    return false;
  if (std::less<>{}(lhs.connect_timing, rhs.connect_timing))
    return true;
  if (std::less<>{}(rhs.connect_timing, lhs.connect_timing))
    return false;
  if (std::less<>{}(lhs.send_start, rhs.send_start))
    return true;
  if (std::less<>{}(rhs.send_start, lhs.send_start))
    return false;
  if (std::less<>{}(lhs.send_end, rhs.send_end))
    return true;
  if (std::less<>{}(rhs.send_end, lhs.send_end))
    return false;
  if (std::less<>{}(lhs.receive_headers_start, rhs.receive_headers_start))
    return true;
  if (std::less<>{}(rhs.receive_headers_start, lhs.receive_headers_start))
    return false;
  if (std::less<>{}(lhs.receive_headers_end, rhs.receive_headers_end))
    return true;
  if (std::less<>{}(rhs.receive_headers_end, lhs.receive_headers_end))
    return false;
  if (std::less<>{}(lhs.first_early_hints_time, rhs.first_early_hints_time))
    return true;
  if (std::less<>{}(rhs.first_early_hints_time, lhs.first_early_hints_time))
    return false;
  if (std::less<>{}(lhs.push_start, rhs.push_start))
    return true;
  if (std::less<>{}(rhs.push_start, lhs.push_start))
    return false;
  if (std::less<>{}(lhs.push_end, rhs.push_end))
    return true;
  if (std::less<>{}(rhs.push_end, lhs.push_end))
    return false;
  if (std::less<>{}(lhs.service_worker_start_time, rhs.service_worker_start_time))
    return true;
  if (std::less<>{}(rhs.service_worker_start_time, lhs.service_worker_start_time))
    return false;
  if (std::less<>{}(lhs.service_worker_ready_time, rhs.service_worker_ready_time))
    return true;
  if (std::less<>{}(rhs.service_worker_ready_time, lhs.service_worker_ready_time))
    return false;
  if (std::less<>{}(lhs.service_worker_fetch_start, rhs.service_worker_fetch_start))
    return true;
  if (std::less<>{}(rhs.service_worker_fetch_start, lhs.service_worker_fetch_start))
    return false;
  if (std::less<>{}(lhs.service_worker_respond_with_settled, rhs.service_worker_respond_with_settled))
    return true;
  if (std::less<>{}(rhs.service_worker_respond_with_settled, lhs.service_worker_respond_with_settled))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace network

namespace mojo {


template <>
struct  StructTraits<::network::mojom::LoadTimingInfoConnectTiming::DataView,
                                         ::network::mojom::LoadTimingInfoConnectTimingPtr> {
  static bool IsNull(const ::network::mojom::LoadTimingInfoConnectTimingPtr& input) { return !input; }
  static void SetToNull(::network::mojom::LoadTimingInfoConnectTimingPtr* output) { output->reset(); }

  static const decltype(::network::mojom::LoadTimingInfoConnectTiming::dns_start)& dns_start(
      const ::network::mojom::LoadTimingInfoConnectTimingPtr& input) {
    return input->dns_start;
  }

  static const decltype(::network::mojom::LoadTimingInfoConnectTiming::dns_end)& dns_end(
      const ::network::mojom::LoadTimingInfoConnectTimingPtr& input) {
    return input->dns_end;
  }

  static const decltype(::network::mojom::LoadTimingInfoConnectTiming::connect_start)& connect_start(
      const ::network::mojom::LoadTimingInfoConnectTimingPtr& input) {
    return input->connect_start;
  }

  static const decltype(::network::mojom::LoadTimingInfoConnectTiming::connect_end)& connect_end(
      const ::network::mojom::LoadTimingInfoConnectTimingPtr& input) {
    return input->connect_end;
  }

  static const decltype(::network::mojom::LoadTimingInfoConnectTiming::ssl_start)& ssl_start(
      const ::network::mojom::LoadTimingInfoConnectTimingPtr& input) {
    return input->ssl_start;
  }

  static const decltype(::network::mojom::LoadTimingInfoConnectTiming::ssl_end)& ssl_end(
      const ::network::mojom::LoadTimingInfoConnectTimingPtr& input) {
    return input->ssl_end;
  }

  static bool Read(::network::mojom::LoadTimingInfoConnectTiming::DataView input, ::network::mojom::LoadTimingInfoConnectTimingPtr* output);
};


template <>
struct  StructTraits<::network::mojom::LoadTimingInfo::DataView,
                                         ::network::mojom::LoadTimingInfoPtr> {
  static bool IsNull(const ::network::mojom::LoadTimingInfoPtr& input) { return !input; }
  static void SetToNull(::network::mojom::LoadTimingInfoPtr* output) { output->reset(); }

  static decltype(::network::mojom::LoadTimingInfo::socket_reused) socket_reused(
      const ::network::mojom::LoadTimingInfoPtr& input) {
    return input->socket_reused;
  }

  static decltype(::network::mojom::LoadTimingInfo::socket_log_id) socket_log_id(
      const ::network::mojom::LoadTimingInfoPtr& input) {
    return input->socket_log_id;
  }

  static const decltype(::network::mojom::LoadTimingInfo::request_start_time)& request_start_time(
      const ::network::mojom::LoadTimingInfoPtr& input) {
    return input->request_start_time;
  }

  static const decltype(::network::mojom::LoadTimingInfo::request_start)& request_start(
      const ::network::mojom::LoadTimingInfoPtr& input) {
    return input->request_start;
  }

  static const decltype(::network::mojom::LoadTimingInfo::proxy_resolve_start)& proxy_resolve_start(
      const ::network::mojom::LoadTimingInfoPtr& input) {
    return input->proxy_resolve_start;
  }

  static const decltype(::network::mojom::LoadTimingInfo::proxy_resolve_end)& proxy_resolve_end(
      const ::network::mojom::LoadTimingInfoPtr& input) {
    return input->proxy_resolve_end;
  }

  static const decltype(::network::mojom::LoadTimingInfo::connect_timing)& connect_timing(
      const ::network::mojom::LoadTimingInfoPtr& input) {
    return input->connect_timing;
  }

  static const decltype(::network::mojom::LoadTimingInfo::send_start)& send_start(
      const ::network::mojom::LoadTimingInfoPtr& input) {
    return input->send_start;
  }

  static const decltype(::network::mojom::LoadTimingInfo::send_end)& send_end(
      const ::network::mojom::LoadTimingInfoPtr& input) {
    return input->send_end;
  }

  static const decltype(::network::mojom::LoadTimingInfo::receive_headers_start)& receive_headers_start(
      const ::network::mojom::LoadTimingInfoPtr& input) {
    return input->receive_headers_start;
  }

  static const decltype(::network::mojom::LoadTimingInfo::receive_headers_end)& receive_headers_end(
      const ::network::mojom::LoadTimingInfoPtr& input) {
    return input->receive_headers_end;
  }

  static const decltype(::network::mojom::LoadTimingInfo::first_early_hints_time)& first_early_hints_time(
      const ::network::mojom::LoadTimingInfoPtr& input) {
    return input->first_early_hints_time;
  }

  static const decltype(::network::mojom::LoadTimingInfo::push_start)& push_start(
      const ::network::mojom::LoadTimingInfoPtr& input) {
    return input->push_start;
  }

  static const decltype(::network::mojom::LoadTimingInfo::push_end)& push_end(
      const ::network::mojom::LoadTimingInfoPtr& input) {
    return input->push_end;
  }

  static const decltype(::network::mojom::LoadTimingInfo::service_worker_start_time)& service_worker_start_time(
      const ::network::mojom::LoadTimingInfoPtr& input) {
    return input->service_worker_start_time;
  }

  static const decltype(::network::mojom::LoadTimingInfo::service_worker_ready_time)& service_worker_ready_time(
      const ::network::mojom::LoadTimingInfoPtr& input) {
    return input->service_worker_ready_time;
  }

  static const decltype(::network::mojom::LoadTimingInfo::service_worker_fetch_start)& service_worker_fetch_start(
      const ::network::mojom::LoadTimingInfoPtr& input) {
    return input->service_worker_fetch_start;
  }

  static const decltype(::network::mojom::LoadTimingInfo::service_worker_respond_with_settled)& service_worker_respond_with_settled(
      const ::network::mojom::LoadTimingInfoPtr& input) {
    return input->service_worker_respond_with_settled;
  }

  static bool Read(::network::mojom::LoadTimingInfo::DataView input, ::network::mojom::LoadTimingInfoPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_LOAD_TIMING_INFO_MOJOM_H_