// services/network/public/mojom/parsed_headers.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_PARSED_HEADERS_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_PARSED_HEADERS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "services/network/public/mojom/parsed_headers.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/content_security_policy.mojom-shared.h"
#include "services/network/public/mojom/cross_origin_embedder_policy.mojom-shared.h"
#include "services/network/public/mojom/cross_origin_opener_policy.mojom-shared.h"
#include "services/network/public/mojom/web_client_hints_types.mojom-shared.h"







namespace network {
namespace mojom {
class ParsedHeadersDataView;



}  // namespace mojom
}  // namespace network

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::ParsedHeadersDataView> {
  using Data = ::network::mojom::internal::ParsedHeaders_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network {
namespace mojom {


class ParsedHeadersDataView {
 public:
  ParsedHeadersDataView() {}

  ParsedHeadersDataView(
      internal::ParsedHeaders_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetContentSecurityPolicyDataView(
      mojo::ArrayDataView<::network::mojom::ContentSecurityPolicyDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadContentSecurityPolicy(UserType* output) {
    
    auto* pointer = data_->content_security_policy.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::ContentSecurityPolicyDataView>>(
        pointer, output, context_);
  }
  inline void GetAllowCspFromDataView(
      ::network::mojom::AllowCSPFromHeaderValueDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadAllowCspFrom(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::AllowCSPFromHeaderValueDataView, UserType>(),
    "Attempting to read the optional `allow_csp_from` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAllowCspFrom` instead "
    "of `ReadAllowCspFrom if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->allow_csp_from.is_null() ? &data_->allow_csp_from : nullptr;
    return mojo::internal::Deserialize<::network::mojom::AllowCSPFromHeaderValueDataView>(
        pointer, output, context_);
  }
  inline void GetCrossOriginEmbedderPolicyDataView(
      ::network::mojom::CrossOriginEmbedderPolicyDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadCrossOriginEmbedderPolicy(UserType* output) {
    
    auto* pointer = data_->cross_origin_embedder_policy.Get();
    return mojo::internal::Deserialize<::network::mojom::CrossOriginEmbedderPolicyDataView>(
        pointer, output, context_);
  }
  inline void GetCrossOriginOpenerPolicyDataView(
      ::network::mojom::CrossOriginOpenerPolicyDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadCrossOriginOpenerPolicy(UserType* output) {
    
    auto* pointer = data_->cross_origin_opener_policy.Get();
    return mojo::internal::Deserialize<::network::mojom::CrossOriginOpenerPolicyDataView>(
        pointer, output, context_);
  }
  bool origin_isolation() const {
    return data_->origin_isolation;
  }
  inline void GetAcceptChDataView(
      mojo::ArrayDataView<::network::mojom::WebClientHintsType>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadAcceptCh(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::network::mojom::WebClientHintsType>, UserType>(),
    "Attempting to read the optional `accept_ch` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAcceptCh` instead "
    "of `ReadAcceptCh if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->accept_ch.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::WebClientHintsType>>(
        pointer, output, context_);
  }
  inline void GetAcceptChLifetimeDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadAcceptChLifetime(UserType* output) {
    
    auto* pointer = data_->accept_ch_lifetime.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, context_);
  }
 private:
  internal::ParsedHeaders_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace network

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ParsedHeadersDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::ParsedHeadersDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::network::mojom::internal::ParsedHeaders_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::content_security_policy(input)) in_content_security_policy = Traits::content_security_policy(input);
    typename decltype((*output)->content_security_policy)::BaseType::BufferWriter
        content_security_policy_writer;
    const mojo::internal::ContainerValidateParams content_security_policy_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::ContentSecurityPolicyDataView>>(
        in_content_security_policy, buffer, &content_security_policy_writer, &content_security_policy_validate_params,
        context);
    (*output)->content_security_policy.Set(
        content_security_policy_writer.is_null() ? nullptr : content_security_policy_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->content_security_policy.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null content_security_policy in ParsedHeaders struct");
    decltype(Traits::allow_csp_from(input)) in_allow_csp_from = Traits::allow_csp_from(input);
    typename decltype((*output)->allow_csp_from)::BufferWriter allow_csp_from_writer;
    allow_csp_from_writer.AllocateInline(buffer, &(*output)->allow_csp_from);
    mojo::internal::Serialize<::network::mojom::AllowCSPFromHeaderValueDataView>(
        in_allow_csp_from, buffer, &allow_csp_from_writer, true, context);
    decltype(Traits::cross_origin_embedder_policy(input)) in_cross_origin_embedder_policy = Traits::cross_origin_embedder_policy(input);
    typename decltype((*output)->cross_origin_embedder_policy)::BaseType::BufferWriter
        cross_origin_embedder_policy_writer;
    mojo::internal::Serialize<::network::mojom::CrossOriginEmbedderPolicyDataView>(
        in_cross_origin_embedder_policy, buffer, &cross_origin_embedder_policy_writer, context);
    (*output)->cross_origin_embedder_policy.Set(
        cross_origin_embedder_policy_writer.is_null() ? nullptr : cross_origin_embedder_policy_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->cross_origin_embedder_policy.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null cross_origin_embedder_policy in ParsedHeaders struct");
    decltype(Traits::cross_origin_opener_policy(input)) in_cross_origin_opener_policy = Traits::cross_origin_opener_policy(input);
    typename decltype((*output)->cross_origin_opener_policy)::BaseType::BufferWriter
        cross_origin_opener_policy_writer;
    mojo::internal::Serialize<::network::mojom::CrossOriginOpenerPolicyDataView>(
        in_cross_origin_opener_policy, buffer, &cross_origin_opener_policy_writer, context);
    (*output)->cross_origin_opener_policy.Set(
        cross_origin_opener_policy_writer.is_null() ? nullptr : cross_origin_opener_policy_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->cross_origin_opener_policy.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null cross_origin_opener_policy in ParsedHeaders struct");
    (*output)->origin_isolation = Traits::origin_isolation(input);
    decltype(Traits::accept_ch(input)) in_accept_ch = Traits::accept_ch(input);
    typename decltype((*output)->accept_ch)::BaseType::BufferWriter
        accept_ch_writer;
    const mojo::internal::ContainerValidateParams accept_ch_validate_params(
        0, ::network::mojom::internal::WebClientHintsType_Data::Validate);
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::WebClientHintsType>>(
        in_accept_ch, buffer, &accept_ch_writer, &accept_ch_validate_params,
        context);
    (*output)->accept_ch.Set(
        accept_ch_writer.is_null() ? nullptr : accept_ch_writer.data());
    decltype(Traits::accept_ch_lifetime(input)) in_accept_ch_lifetime = Traits::accept_ch_lifetime(input);
    typename decltype((*output)->accept_ch_lifetime)::BaseType::BufferWriter
        accept_ch_lifetime_writer;
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
        in_accept_ch_lifetime, buffer, &accept_ch_lifetime_writer, context);
    (*output)->accept_ch_lifetime.Set(
        accept_ch_lifetime_writer.is_null() ? nullptr : accept_ch_lifetime_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->accept_ch_lifetime.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null accept_ch_lifetime in ParsedHeaders struct");
  }

  static bool Deserialize(::network::mojom::internal::ParsedHeaders_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::ParsedHeadersDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network {
namespace mojom {

inline void ParsedHeadersDataView::GetContentSecurityPolicyDataView(
    mojo::ArrayDataView<::network::mojom::ContentSecurityPolicyDataView>* output) {
  auto pointer = data_->content_security_policy.Get();
  *output = mojo::ArrayDataView<::network::mojom::ContentSecurityPolicyDataView>(pointer, context_);
}
inline void ParsedHeadersDataView::GetAllowCspFromDataView(
    ::network::mojom::AllowCSPFromHeaderValueDataView* output) {
  auto pointer = &data_->allow_csp_from;
  *output = ::network::mojom::AllowCSPFromHeaderValueDataView(pointer, context_);
}
inline void ParsedHeadersDataView::GetCrossOriginEmbedderPolicyDataView(
    ::network::mojom::CrossOriginEmbedderPolicyDataView* output) {
  auto pointer = data_->cross_origin_embedder_policy.Get();
  *output = ::network::mojom::CrossOriginEmbedderPolicyDataView(pointer, context_);
}
inline void ParsedHeadersDataView::GetCrossOriginOpenerPolicyDataView(
    ::network::mojom::CrossOriginOpenerPolicyDataView* output) {
  auto pointer = data_->cross_origin_opener_policy.Get();
  *output = ::network::mojom::CrossOriginOpenerPolicyDataView(pointer, context_);
}
inline void ParsedHeadersDataView::GetAcceptChDataView(
    mojo::ArrayDataView<::network::mojom::WebClientHintsType>* output) {
  auto pointer = data_->accept_ch.Get();
  *output = mojo::ArrayDataView<::network::mojom::WebClientHintsType>(pointer, context_);
}
inline void ParsedHeadersDataView::GetAcceptChLifetimeDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->accept_ch_lifetime.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace network

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_PARSED_HEADERS_MOJOM_SHARED_H_