// services/network/public/mojom/ssl_config.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/ssl_config.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/network/public/mojom/ssl_config.mojom-params-data.h"
#include "services/network/public/mojom/ssl_config.mojom-shared-message-ids.h"

#include "services/network/public/mojom/ssl_config.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_SSL_CONFIG_MOJOM_BLINK_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_SSL_CONFIG_MOJOM_BLINK_JUMBO_H_
#endif
namespace network {
namespace mojom {
namespace blink {
SSLConfig::SSLConfig()
    : rev_checking_enabled(false),
      rev_checking_required_local_anchors(false),
      sha1_local_anchors_enabled(false),
      symantec_enforcement_disabled(false),
      version_min(SSLVersion::kTLS1),
      version_min_warn(SSLVersion::kTLS12),
      version_max(SSLVersion::kTLS13),
      disabled_cipher_suites(),
      client_cert_pooling_policy() {}

SSLConfig::SSLConfig(
    bool rev_checking_enabled_in,
    bool rev_checking_required_local_anchors_in,
    bool sha1_local_anchors_enabled_in,
    bool symantec_enforcement_disabled_in,
    SSLVersion version_min_in,
    SSLVersion version_min_warn_in,
    SSLVersion version_max_in,
    WTF::Vector<uint16_t> disabled_cipher_suites_in,
    WTF::Vector<WTF::String> client_cert_pooling_policy_in)
    : rev_checking_enabled(std::move(rev_checking_enabled_in)),
      rev_checking_required_local_anchors(std::move(rev_checking_required_local_anchors_in)),
      sha1_local_anchors_enabled(std::move(sha1_local_anchors_enabled_in)),
      symantec_enforcement_disabled(std::move(symantec_enforcement_disabled_in)),
      version_min(std::move(version_min_in)),
      version_min_warn(std::move(version_min_warn_in)),
      version_max(std::move(version_max_in)),
      disabled_cipher_suites(std::move(disabled_cipher_suites_in)),
      client_cert_pooling_policy(std::move(client_cert_pooling_policy_in)) {}

SSLConfig::~SSLConfig() = default;

void SSLConfig::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetBoolean("rev_checking_enabled", this->rev_checking_enabled);
  value->SetBoolean("rev_checking_required_local_anchors", this->rev_checking_required_local_anchors);
  value->SetBoolean("sha1_local_anchors_enabled", this->sha1_local_anchors_enabled);
  value->SetBoolean("symantec_enforcement_disabled", this->symantec_enforcement_disabled);
  value->SetString("version_min", base::trace_event::ValueToString(this->version_min));
  value->SetString("version_min_warn", base::trace_event::ValueToString(this->version_min_warn));
  value->SetString("version_max", base::trace_event::ValueToString(this->version_max));
  value->BeginArray("disabled_cipher_suites");
  for (const auto& item0 : this->disabled_cipher_suites) {
    value->AppendInteger(item0);
  }
  value->EndArray();
  value->BeginArray("client_cert_pooling_policy");
  for (const auto& item0 : this->client_cert_pooling_policy) {
    value->AppendString(item0.Utf8());
  }
  value->EndArray();
}

bool SSLConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char SSLConfigClient::Name_[] = "network.mojom.SSLConfigClient";

SSLConfigClientProxy::SSLConfigClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SSLConfigClientProxy::OnSSLConfigUpdated(
    SSLConfigPtr in_ssl_config) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::SSLConfigClient::OnSSLConfigUpdated", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_ssl_config.is_null()) {
        raw_value->SetString("ssl_config", "nullptr");
      } else {
        raw_value->BeginDictionary("ssl_config");
        in_ssl_config->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSSLConfigClient_OnSSLConfigUpdated_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::SSLConfigClient_OnSSLConfigUpdated_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->ssl_config)::BaseType::BufferWriter
      ssl_config_writer;
  mojo::internal::Serialize<::network::mojom::SSLConfigDataView>(
      in_ssl_config, buffer, &ssl_config_writer, &serialization_context);
  params->ssl_config.Set(
      ssl_config_writer.is_null() ? nullptr : ssl_config_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->ssl_config.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null ssl_config in SSLConfigClient.OnSSLConfigUpdated request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SSLConfigClient::Name_);
  message.set_method_name("OnSSLConfigUpdated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool SSLConfigClientStubDispatch::Accept(
    SSLConfigClient* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kSSLConfigClient_OnSSLConfigUpdated_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::SSLConfigClient::OnSSLConfigUpdated",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::SSLConfigClient::OnSSLConfigUpdated");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SSLConfigClient_OnSSLConfigUpdated_Params_Data* params =
          reinterpret_cast<internal::SSLConfigClient_OnSSLConfigUpdated_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      SSLConfigPtr p_ssl_config{};
      SSLConfigClient_OnSSLConfigUpdated_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadSslConfig(&p_ssl_config))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SSLConfigClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSSLConfigUpdated(
std::move(p_ssl_config));
      return true;
    }
  }
  return false;
}

// static
bool SSLConfigClientStubDispatch::AcceptWithResponder(
    SSLConfigClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kSSLConfigClient_OnSSLConfigUpdated_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kSSLConfigClientValidationInfo[] = {
    {internal::kSSLConfigClient_OnSSLConfigUpdated_Name,
     {&internal::SSLConfigClient_OnSSLConfigUpdated_Params_Data::Validate,
      nullptr /* no response */}},
};

bool SSLConfigClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::SSLConfigClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kSSLConfigClientValidationInfo);
}

}  // namespace blink
}  // namespace mojom
}  // namespace network

namespace mojo {


// static
bool StructTraits<::network::mojom::blink::SSLConfig::DataView, ::network::mojom::blink::SSLConfigPtr>::Read(
    ::network::mojom::blink::SSLConfig::DataView input,
    ::network::mojom::blink::SSLConfigPtr* output) {
  bool success = true;
  ::network::mojom::blink::SSLConfigPtr result(::network::mojom::blink::SSLConfig::New());
  
      if (success)
        result->rev_checking_enabled = input.rev_checking_enabled();
      if (success)
        result->rev_checking_required_local_anchors = input.rev_checking_required_local_anchors();
      if (success)
        result->sha1_local_anchors_enabled = input.sha1_local_anchors_enabled();
      if (success)
        result->symantec_enforcement_disabled = input.symantec_enforcement_disabled();
      if (success && !input.ReadVersionMin(&result->version_min))
        success = false;
      if (success && !input.ReadVersionMinWarn(&result->version_min_warn))
        success = false;
      if (success && !input.ReadVersionMax(&result->version_max))
        success = false;
      if (success && !input.ReadDisabledCipherSuites(&result->disabled_cipher_suites))
        success = false;
      if (success && !input.ReadClientCertPoolingPolicy(&result->client_cert_pooling_policy))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif