// services/video_capture/public/mojom/device_factory.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/video_capture/public/mojom/device_factory.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/video_capture/public/mojom/device_factory.mojom-params-data.h"
#include "services/video_capture/public/mojom/device_factory.mojom-shared-message-ids.h"

#include "services/video_capture/public/mojom/device_factory.mojom-import-headers.h"


#ifndef SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_DEVICE_FACTORY_MOJOM_JUMBO_H_
#define SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_DEVICE_FACTORY_MOJOM_JUMBO_H_
#endif
namespace video_capture {
namespace mojom {
const char DeviceFactory::Name_[] = "video_capture.mojom.DeviceFactory";

class DeviceFactory_GetDeviceInfos_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DeviceFactory_GetDeviceInfos_ForwardToCallback(
      DeviceFactory::GetDeviceInfosCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  DeviceFactory::GetDeviceInfosCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(DeviceFactory_GetDeviceInfos_ForwardToCallback);
};

class DeviceFactory_CreateDevice_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DeviceFactory_CreateDevice_ForwardToCallback(
      DeviceFactory::CreateDeviceCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  DeviceFactory::CreateDeviceCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(DeviceFactory_CreateDevice_ForwardToCallback);
};

DeviceFactoryProxy::DeviceFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DeviceFactoryProxy::GetDeviceInfos(
    GetDeviceInfosCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "video_capture::mojom::DeviceFactory::GetDeviceInfos");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDeviceFactory_GetDeviceInfos_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::video_capture::mojom::internal::DeviceFactory_GetDeviceInfos_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceFactory::Name_);
  message.set_method_name("GetDeviceInfos");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DeviceFactory_GetDeviceInfos_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void DeviceFactoryProxy::CreateDevice(
    const std::string& in_device_id, ::mojo::PendingReceiver<::video_capture::mojom::Device> in_device_receiver, CreateDeviceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "video_capture::mojom::DeviceFactory::CreateDevice", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("device_id", in_device_id);
      raw_value->SetBoolean("device_receiver", in_device_receiver.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDeviceFactory_CreateDevice_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::video_capture::mojom::internal::DeviceFactory_CreateDevice_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->device_id)::BaseType::BufferWriter
      device_id_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_device_id, buffer, &device_id_writer, &serialization_context);
  params->device_id.Set(
      device_id_writer.is_null() ? nullptr : device_id_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->device_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null device_id in DeviceFactory.CreateDevice request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::video_capture::mojom::DeviceInterfaceBase>>(
      in_device_receiver, &params->device_receiver, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->device_receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid device_receiver in DeviceFactory.CreateDevice request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceFactory::Name_);
  message.set_method_name("CreateDevice");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DeviceFactory_CreateDevice_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void DeviceFactoryProxy::AddSharedMemoryVirtualDevice(
    const ::media::VideoCaptureDeviceInfo& in_device_info, ::mojo::PendingRemote<::video_capture::mojom::Producer> in_producer, bool in_send_buffer_handles_to_producer_as_raw_file_descriptors, ::mojo::PendingReceiver<::video_capture::mojom::SharedMemoryVirtualDevice> in_virtual_device_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "video_capture::mojom::DeviceFactory::AddSharedMemoryVirtualDevice", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("device_info", base::trace_event::ValueToString(in_device_info, "<value of type const ::media::VideoCaptureDeviceInfo&>"));
      raw_value->SetBoolean("producer", in_producer.is_valid());
      raw_value->SetBoolean("send_buffer_handles_to_producer_as_raw_file_descriptors", in_send_buffer_handles_to_producer_as_raw_file_descriptors);
      raw_value->SetBoolean("virtual_device_receiver", in_virtual_device_receiver.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDeviceFactory_AddSharedMemoryVirtualDevice_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::video_capture::mojom::internal::DeviceFactory_AddSharedMemoryVirtualDevice_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->device_info)::BaseType::BufferWriter
      device_info_writer;
  mojo::internal::Serialize<::media::mojom::VideoCaptureDeviceInfoDataView>(
      in_device_info, buffer, &device_info_writer, &serialization_context);
  params->device_info.Set(
      device_info_writer.is_null() ? nullptr : device_info_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->device_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null device_info in DeviceFactory.AddSharedMemoryVirtualDevice request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::video_capture::mojom::ProducerInterfaceBase>>(
      in_producer, &params->producer, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->producer),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid producer in DeviceFactory.AddSharedMemoryVirtualDevice request");
  params->send_buffer_handles_to_producer_as_raw_file_descriptors = in_send_buffer_handles_to_producer_as_raw_file_descriptors;
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::video_capture::mojom::SharedMemoryVirtualDeviceInterfaceBase>>(
      in_virtual_device_receiver, &params->virtual_device_receiver, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->virtual_device_receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid virtual_device_receiver in DeviceFactory.AddSharedMemoryVirtualDevice request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceFactory::Name_);
  message.set_method_name("AddSharedMemoryVirtualDevice");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DeviceFactoryProxy::AddTextureVirtualDevice(
    const ::media::VideoCaptureDeviceInfo& in_device_info, ::mojo::PendingReceiver<::video_capture::mojom::TextureVirtualDevice> in_virtual_device_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "video_capture::mojom::DeviceFactory::AddTextureVirtualDevice", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("device_info", base::trace_event::ValueToString(in_device_info, "<value of type const ::media::VideoCaptureDeviceInfo&>"));
      raw_value->SetBoolean("virtual_device_receiver", in_virtual_device_receiver.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDeviceFactory_AddTextureVirtualDevice_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::video_capture::mojom::internal::DeviceFactory_AddTextureVirtualDevice_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->device_info)::BaseType::BufferWriter
      device_info_writer;
  mojo::internal::Serialize<::media::mojom::VideoCaptureDeviceInfoDataView>(
      in_device_info, buffer, &device_info_writer, &serialization_context);
  params->device_info.Set(
      device_info_writer.is_null() ? nullptr : device_info_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->device_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null device_info in DeviceFactory.AddTextureVirtualDevice request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::video_capture::mojom::TextureVirtualDeviceInterfaceBase>>(
      in_virtual_device_receiver, &params->virtual_device_receiver, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->virtual_device_receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid virtual_device_receiver in DeviceFactory.AddTextureVirtualDevice request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceFactory::Name_);
  message.set_method_name("AddTextureVirtualDevice");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DeviceFactoryProxy::AddGpuMemoryBufferVirtualDevice(
    const ::media::VideoCaptureDeviceInfo& in_device_info, ::mojo::PendingReceiver<::video_capture::mojom::GpuMemoryBufferVirtualDevice> in_virtual_device_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "video_capture::mojom::DeviceFactory::AddGpuMemoryBufferVirtualDevice", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("device_info", base::trace_event::ValueToString(in_device_info, "<value of type const ::media::VideoCaptureDeviceInfo&>"));
      raw_value->SetBoolean("virtual_device_receiver", in_virtual_device_receiver.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDeviceFactory_AddGpuMemoryBufferVirtualDevice_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::video_capture::mojom::internal::DeviceFactory_AddGpuMemoryBufferVirtualDevice_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->device_info)::BaseType::BufferWriter
      device_info_writer;
  mojo::internal::Serialize<::media::mojom::VideoCaptureDeviceInfoDataView>(
      in_device_info, buffer, &device_info_writer, &serialization_context);
  params->device_info.Set(
      device_info_writer.is_null() ? nullptr : device_info_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->device_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null device_info in DeviceFactory.AddGpuMemoryBufferVirtualDevice request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::video_capture::mojom::GpuMemoryBufferVirtualDeviceInterfaceBase>>(
      in_virtual_device_receiver, &params->virtual_device_receiver, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->virtual_device_receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid virtual_device_receiver in DeviceFactory.AddGpuMemoryBufferVirtualDevice request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceFactory::Name_);
  message.set_method_name("AddGpuMemoryBufferVirtualDevice");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DeviceFactoryProxy::RegisterVirtualDevicesChangedObserver(
    ::mojo::PendingRemote<::video_capture::mojom::DevicesChangedObserver> in_observer, bool in_raise_event_if_virtual_devices_already_present) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "video_capture::mojom::DeviceFactory::RegisterVirtualDevicesChangedObserver", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("observer", in_observer.is_valid());
      raw_value->SetBoolean("raise_event_if_virtual_devices_already_present", in_raise_event_if_virtual_devices_already_present);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDeviceFactory_RegisterVirtualDevicesChangedObserver_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::video_capture::mojom::internal::DeviceFactory_RegisterVirtualDevicesChangedObserver_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::video_capture::mojom::DevicesChangedObserverInterfaceBase>>(
      in_observer, &params->observer, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->observer),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid observer in DeviceFactory.RegisterVirtualDevicesChangedObserver request");
  params->raise_event_if_virtual_devices_already_present = in_raise_event_if_virtual_devices_already_present;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceFactory::Name_);
  message.set_method_name("RegisterVirtualDevicesChangedObserver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class DeviceFactory_GetDeviceInfos_ProxyToResponder {
 public:
  static DeviceFactory::GetDeviceInfosCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<DeviceFactory_GetDeviceInfos_ProxyToResponder> proxy(
        new DeviceFactory_GetDeviceInfos_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&DeviceFactory_GetDeviceInfos_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DeviceFactory_GetDeviceInfos_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  DeviceFactory_GetDeviceInfos_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "DeviceFactory::GetDeviceInfosCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<::media::VideoCaptureDeviceInfo>& in_device_infos);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(DeviceFactory_GetDeviceInfos_ProxyToResponder);
};

bool DeviceFactory_GetDeviceInfos_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "video_capture::mojom::DeviceFactory::GetDeviceInfosCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::DeviceFactory_GetDeviceInfos_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DeviceFactory_GetDeviceInfos_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  std::vector<::media::VideoCaptureDeviceInfo> p_device_infos{};
  DeviceFactory_GetDeviceInfos_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadDeviceInfos(&p_device_infos))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DeviceFactory::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_device_infos));
  return true;
}

void DeviceFactory_GetDeviceInfos_ProxyToResponder::Run(
    const std::vector<::media::VideoCaptureDeviceInfo>& in_device_infos) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)video_capture::mojom::DeviceFactory::GetDeviceInfosCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->BeginArray("device_infos");
      for (const auto& item0 : in_device_infos) {
        raw_value->AppendString(base::trace_event::ValueToString(item0, "<value of type const ::media::VideoCaptureDeviceInfo&>"));
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDeviceFactory_GetDeviceInfos_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::video_capture::mojom::internal::DeviceFactory_GetDeviceInfos_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->device_infos)::BaseType::BufferWriter
      device_infos_writer;
  const mojo::internal::ContainerValidateParams device_infos_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::VideoCaptureDeviceInfoDataView>>(
      in_device_infos, buffer, &device_infos_writer, &device_infos_validate_params,
      &serialization_context);
  params->device_infos.Set(
      device_infos_writer.is_null() ? nullptr : device_infos_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->device_infos.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null device_infos in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)video_capture::mojom::DeviceFactory::GetDeviceInfosCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceFactory::Name_);
  message.set_method_name("GetDeviceInfos");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class DeviceFactory_CreateDevice_ProxyToResponder {
 public:
  static DeviceFactory::CreateDeviceCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<DeviceFactory_CreateDevice_ProxyToResponder> proxy(
        new DeviceFactory_CreateDevice_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&DeviceFactory_CreateDevice_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DeviceFactory_CreateDevice_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  DeviceFactory_CreateDevice_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "DeviceFactory::CreateDeviceCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      DeviceAccessResultCode in_result_code);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(DeviceFactory_CreateDevice_ProxyToResponder);
};

bool DeviceFactory_CreateDevice_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "video_capture::mojom::DeviceFactory::CreateDeviceCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::DeviceFactory_CreateDevice_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DeviceFactory_CreateDevice_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  DeviceAccessResultCode p_result_code{};
  DeviceFactory_CreateDevice_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResultCode(&p_result_code))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DeviceFactory::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result_code));
  return true;
}

void DeviceFactory_CreateDevice_ProxyToResponder::Run(
    DeviceAccessResultCode in_result_code) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)video_capture::mojom::DeviceFactory::CreateDeviceCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("result_code", base::trace_event::ValueToString(in_result_code));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDeviceFactory_CreateDevice_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::video_capture::mojom::internal::DeviceFactory_CreateDevice_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::video_capture::mojom::DeviceAccessResultCode>(
      in_result_code, &params->result_code);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)video_capture::mojom::DeviceFactory::CreateDeviceCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceFactory::Name_);
  message.set_method_name("CreateDevice");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool DeviceFactoryStubDispatch::Accept(
    DeviceFactory* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kDeviceFactory_GetDeviceInfos_Name: {
      break;
    }
    case internal::kDeviceFactory_CreateDevice_Name: {
      break;
    }
    case internal::kDeviceFactory_AddSharedMemoryVirtualDevice_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)video_capture::mojom::DeviceFactory::AddSharedMemoryVirtualDevice",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)video_capture::mojom::DeviceFactory::AddSharedMemoryVirtualDevice");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DeviceFactory_AddSharedMemoryVirtualDevice_Params_Data* params =
          reinterpret_cast<internal::DeviceFactory_AddSharedMemoryVirtualDevice_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media::VideoCaptureDeviceInfo p_device_info{};
      ::mojo::PendingRemote<::video_capture::mojom::Producer> p_producer{};
      bool p_send_buffer_handles_to_producer_as_raw_file_descriptors{};
      ::mojo::PendingReceiver<::video_capture::mojom::SharedMemoryVirtualDevice> p_virtual_device_receiver{};
      DeviceFactory_AddSharedMemoryVirtualDevice_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadDeviceInfo(&p_device_info))
        success = false;
      if (success) {
        p_producer =
            input_data_view.TakeProducer<decltype(p_producer)>();
      }
      if (success)
        p_send_buffer_handles_to_producer_as_raw_file_descriptors = input_data_view.send_buffer_handles_to_producer_as_raw_file_descriptors();
      if (success) {
        p_virtual_device_receiver =
            input_data_view.TakeVirtualDeviceReceiver<decltype(p_virtual_device_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceFactory::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddSharedMemoryVirtualDevice(
std::move(p_device_info), 
std::move(p_producer), 
std::move(p_send_buffer_handles_to_producer_as_raw_file_descriptors), 
std::move(p_virtual_device_receiver));
      return true;
    }
    case internal::kDeviceFactory_AddTextureVirtualDevice_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)video_capture::mojom::DeviceFactory::AddTextureVirtualDevice",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)video_capture::mojom::DeviceFactory::AddTextureVirtualDevice");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DeviceFactory_AddTextureVirtualDevice_Params_Data* params =
          reinterpret_cast<internal::DeviceFactory_AddTextureVirtualDevice_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media::VideoCaptureDeviceInfo p_device_info{};
      ::mojo::PendingReceiver<::video_capture::mojom::TextureVirtualDevice> p_virtual_device_receiver{};
      DeviceFactory_AddTextureVirtualDevice_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadDeviceInfo(&p_device_info))
        success = false;
      if (success) {
        p_virtual_device_receiver =
            input_data_view.TakeVirtualDeviceReceiver<decltype(p_virtual_device_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceFactory::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddTextureVirtualDevice(
std::move(p_device_info), 
std::move(p_virtual_device_receiver));
      return true;
    }
    case internal::kDeviceFactory_AddGpuMemoryBufferVirtualDevice_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)video_capture::mojom::DeviceFactory::AddGpuMemoryBufferVirtualDevice",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)video_capture::mojom::DeviceFactory::AddGpuMemoryBufferVirtualDevice");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DeviceFactory_AddGpuMemoryBufferVirtualDevice_Params_Data* params =
          reinterpret_cast<internal::DeviceFactory_AddGpuMemoryBufferVirtualDevice_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media::VideoCaptureDeviceInfo p_device_info{};
      ::mojo::PendingReceiver<::video_capture::mojom::GpuMemoryBufferVirtualDevice> p_virtual_device_receiver{};
      DeviceFactory_AddGpuMemoryBufferVirtualDevice_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadDeviceInfo(&p_device_info))
        success = false;
      if (success) {
        p_virtual_device_receiver =
            input_data_view.TakeVirtualDeviceReceiver<decltype(p_virtual_device_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceFactory::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddGpuMemoryBufferVirtualDevice(
std::move(p_device_info), 
std::move(p_virtual_device_receiver));
      return true;
    }
    case internal::kDeviceFactory_RegisterVirtualDevicesChangedObserver_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)video_capture::mojom::DeviceFactory::RegisterVirtualDevicesChangedObserver",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)video_capture::mojom::DeviceFactory::RegisterVirtualDevicesChangedObserver");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DeviceFactory_RegisterVirtualDevicesChangedObserver_Params_Data* params =
          reinterpret_cast<internal::DeviceFactory_RegisterVirtualDevicesChangedObserver_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<::video_capture::mojom::DevicesChangedObserver> p_observer{};
      bool p_raise_event_if_virtual_devices_already_present{};
      DeviceFactory_RegisterVirtualDevicesChangedObserver_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (success)
        p_raise_event_if_virtual_devices_already_present = input_data_view.raise_event_if_virtual_devices_already_present();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceFactory::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RegisterVirtualDevicesChangedObserver(
std::move(p_observer), 
std::move(p_raise_event_if_virtual_devices_already_present));
      return true;
    }
  }
  return false;
}

// static
bool DeviceFactoryStubDispatch::AcceptWithResponder(
    DeviceFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kDeviceFactory_GetDeviceInfos_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)video_capture::mojom::DeviceFactory::GetDeviceInfos",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)video_capture::mojom::DeviceFactory::GetDeviceInfos");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::DeviceFactory_GetDeviceInfos_Params_Data* params =
          reinterpret_cast<
              internal::DeviceFactory_GetDeviceInfos_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      DeviceFactory_GetDeviceInfos_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceFactory::Name_, 0, false);
        return false;
      }
      DeviceFactory::GetDeviceInfosCallback callback =
          DeviceFactory_GetDeviceInfos_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDeviceInfos(std::move(callback));
      return true;
    }
    case internal::kDeviceFactory_CreateDevice_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)video_capture::mojom::DeviceFactory::CreateDevice",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)video_capture::mojom::DeviceFactory::CreateDevice");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::DeviceFactory_CreateDevice_Params_Data* params =
          reinterpret_cast<
              internal::DeviceFactory_CreateDevice_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_device_id{};
      ::mojo::PendingReceiver<::video_capture::mojom::Device> p_device_receiver{};
      DeviceFactory_CreateDevice_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadDeviceId(&p_device_id))
        success = false;
      if (success) {
        p_device_receiver =
            input_data_view.TakeDeviceReceiver<decltype(p_device_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceFactory::Name_, 1, false);
        return false;
      }
      DeviceFactory::CreateDeviceCallback callback =
          DeviceFactory_CreateDevice_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateDevice(
std::move(p_device_id), 
std::move(p_device_receiver), std::move(callback));
      return true;
    }
    case internal::kDeviceFactory_AddSharedMemoryVirtualDevice_Name: {
      break;
    }
    case internal::kDeviceFactory_AddTextureVirtualDevice_Name: {
      break;
    }
    case internal::kDeviceFactory_AddGpuMemoryBufferVirtualDevice_Name: {
      break;
    }
    case internal::kDeviceFactory_RegisterVirtualDevicesChangedObserver_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kDeviceFactoryValidationInfo[] = {
    {internal::kDeviceFactory_GetDeviceInfos_Name,
     {&internal::DeviceFactory_GetDeviceInfos_Params_Data::Validate,
      &internal::DeviceFactory_GetDeviceInfos_ResponseParams_Data::Validate}},
    {internal::kDeviceFactory_CreateDevice_Name,
     {&internal::DeviceFactory_CreateDevice_Params_Data::Validate,
      &internal::DeviceFactory_CreateDevice_ResponseParams_Data::Validate}},
    {internal::kDeviceFactory_AddSharedMemoryVirtualDevice_Name,
     {&internal::DeviceFactory_AddSharedMemoryVirtualDevice_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDeviceFactory_AddTextureVirtualDevice_Name,
     {&internal::DeviceFactory_AddTextureVirtualDevice_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDeviceFactory_AddGpuMemoryBufferVirtualDevice_Name,
     {&internal::DeviceFactory_AddGpuMemoryBufferVirtualDevice_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDeviceFactory_RegisterVirtualDevicesChangedObserver_Name,
     {&internal::DeviceFactory_RegisterVirtualDevicesChangedObserver_Params_Data::Validate,
      nullptr /* no response */}},
};

bool DeviceFactoryRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::video_capture::mojom::DeviceFactory::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kDeviceFactoryValidationInfo);
}

bool DeviceFactoryResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::video_capture::mojom::DeviceFactory::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kDeviceFactoryValidationInfo);

}
}  // namespace mojom
}  // namespace video_capture

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif