// services/video_capture/public/mojom/video_source.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_VIDEO_SOURCE_MOJOM_PARAMS_DATA_H_
#define SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_VIDEO_SOURCE_MOJOM_PARAMS_DATA_H_

#include "base/macros.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif
namespace video_capture {
namespace mojom {
namespace internal {
class  PushVideoStreamSubscription_Activate_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(PushVideoStreamSubscription_Activate_Params_Data));
      new (data()) PushVideoStreamSubscription_Activate_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    PushVideoStreamSubscription_Activate_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<PushVideoStreamSubscription_Activate_Params_Data>(index_);
    }
    PushVideoStreamSubscription_Activate_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  PushVideoStreamSubscription_Activate_Params_Data();
  ~PushVideoStreamSubscription_Activate_Params_Data() = delete;
};
static_assert(sizeof(PushVideoStreamSubscription_Activate_Params_Data) == 8,
              "Bad sizeof(PushVideoStreamSubscription_Activate_Params_Data)");
class  PushVideoStreamSubscription_Suspend_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(PushVideoStreamSubscription_Suspend_Params_Data));
      new (data()) PushVideoStreamSubscription_Suspend_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    PushVideoStreamSubscription_Suspend_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<PushVideoStreamSubscription_Suspend_Params_Data>(index_);
    }
    PushVideoStreamSubscription_Suspend_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  PushVideoStreamSubscription_Suspend_Params_Data();
  ~PushVideoStreamSubscription_Suspend_Params_Data() = delete;
};
static_assert(sizeof(PushVideoStreamSubscription_Suspend_Params_Data) == 8,
              "Bad sizeof(PushVideoStreamSubscription_Suspend_Params_Data)");
class  PushVideoStreamSubscription_Suspend_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(PushVideoStreamSubscription_Suspend_ResponseParams_Data));
      new (data()) PushVideoStreamSubscription_Suspend_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    PushVideoStreamSubscription_Suspend_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<PushVideoStreamSubscription_Suspend_ResponseParams_Data>(index_);
    }
    PushVideoStreamSubscription_Suspend_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  PushVideoStreamSubscription_Suspend_ResponseParams_Data();
  ~PushVideoStreamSubscription_Suspend_ResponseParams_Data() = delete;
};
static_assert(sizeof(PushVideoStreamSubscription_Suspend_ResponseParams_Data) == 8,
              "Bad sizeof(PushVideoStreamSubscription_Suspend_ResponseParams_Data)");
class  PushVideoStreamSubscription_Resume_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(PushVideoStreamSubscription_Resume_Params_Data));
      new (data()) PushVideoStreamSubscription_Resume_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    PushVideoStreamSubscription_Resume_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<PushVideoStreamSubscription_Resume_Params_Data>(index_);
    }
    PushVideoStreamSubscription_Resume_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  PushVideoStreamSubscription_Resume_Params_Data();
  ~PushVideoStreamSubscription_Resume_Params_Data() = delete;
};
static_assert(sizeof(PushVideoStreamSubscription_Resume_Params_Data) == 8,
              "Bad sizeof(PushVideoStreamSubscription_Resume_Params_Data)");
class  PushVideoStreamSubscription_GetPhotoState_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(PushVideoStreamSubscription_GetPhotoState_Params_Data));
      new (data()) PushVideoStreamSubscription_GetPhotoState_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    PushVideoStreamSubscription_GetPhotoState_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<PushVideoStreamSubscription_GetPhotoState_Params_Data>(index_);
    }
    PushVideoStreamSubscription_GetPhotoState_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  PushVideoStreamSubscription_GetPhotoState_Params_Data();
  ~PushVideoStreamSubscription_GetPhotoState_Params_Data() = delete;
};
static_assert(sizeof(PushVideoStreamSubscription_GetPhotoState_Params_Data) == 8,
              "Bad sizeof(PushVideoStreamSubscription_GetPhotoState_Params_Data)");
class  PushVideoStreamSubscription_GetPhotoState_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(PushVideoStreamSubscription_GetPhotoState_ResponseParams_Data));
      new (data()) PushVideoStreamSubscription_GetPhotoState_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    PushVideoStreamSubscription_GetPhotoState_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<PushVideoStreamSubscription_GetPhotoState_ResponseParams_Data>(index_);
    }
    PushVideoStreamSubscription_GetPhotoState_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::media::mojom::internal::PhotoState_Data> capabilities;

 private:
  PushVideoStreamSubscription_GetPhotoState_ResponseParams_Data();
  ~PushVideoStreamSubscription_GetPhotoState_ResponseParams_Data() = delete;
};
static_assert(sizeof(PushVideoStreamSubscription_GetPhotoState_ResponseParams_Data) == 16,
              "Bad sizeof(PushVideoStreamSubscription_GetPhotoState_ResponseParams_Data)");
class  PushVideoStreamSubscription_SetPhotoOptions_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(PushVideoStreamSubscription_SetPhotoOptions_Params_Data));
      new (data()) PushVideoStreamSubscription_SetPhotoOptions_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    PushVideoStreamSubscription_SetPhotoOptions_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<PushVideoStreamSubscription_SetPhotoOptions_Params_Data>(index_);
    }
    PushVideoStreamSubscription_SetPhotoOptions_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::media::mojom::internal::PhotoSettings_Data> settings;

 private:
  PushVideoStreamSubscription_SetPhotoOptions_Params_Data();
  ~PushVideoStreamSubscription_SetPhotoOptions_Params_Data() = delete;
};
static_assert(sizeof(PushVideoStreamSubscription_SetPhotoOptions_Params_Data) == 16,
              "Bad sizeof(PushVideoStreamSubscription_SetPhotoOptions_Params_Data)");
class  PushVideoStreamSubscription_SetPhotoOptions_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(PushVideoStreamSubscription_SetPhotoOptions_ResponseParams_Data));
      new (data()) PushVideoStreamSubscription_SetPhotoOptions_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    PushVideoStreamSubscription_SetPhotoOptions_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<PushVideoStreamSubscription_SetPhotoOptions_ResponseParams_Data>(index_);
    }
    PushVideoStreamSubscription_SetPhotoOptions_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t success : 1;
  uint8_t padfinal_[7];

 private:
  PushVideoStreamSubscription_SetPhotoOptions_ResponseParams_Data();
  ~PushVideoStreamSubscription_SetPhotoOptions_ResponseParams_Data() = delete;
};
static_assert(sizeof(PushVideoStreamSubscription_SetPhotoOptions_ResponseParams_Data) == 16,
              "Bad sizeof(PushVideoStreamSubscription_SetPhotoOptions_ResponseParams_Data)");
class  PushVideoStreamSubscription_TakePhoto_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(PushVideoStreamSubscription_TakePhoto_Params_Data));
      new (data()) PushVideoStreamSubscription_TakePhoto_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    PushVideoStreamSubscription_TakePhoto_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<PushVideoStreamSubscription_TakePhoto_Params_Data>(index_);
    }
    PushVideoStreamSubscription_TakePhoto_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  PushVideoStreamSubscription_TakePhoto_Params_Data();
  ~PushVideoStreamSubscription_TakePhoto_Params_Data() = delete;
};
static_assert(sizeof(PushVideoStreamSubscription_TakePhoto_Params_Data) == 8,
              "Bad sizeof(PushVideoStreamSubscription_TakePhoto_Params_Data)");
class  PushVideoStreamSubscription_TakePhoto_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(PushVideoStreamSubscription_TakePhoto_ResponseParams_Data));
      new (data()) PushVideoStreamSubscription_TakePhoto_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    PushVideoStreamSubscription_TakePhoto_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<PushVideoStreamSubscription_TakePhoto_ResponseParams_Data>(index_);
    }
    PushVideoStreamSubscription_TakePhoto_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::media::mojom::internal::Blob_Data> blob;

 private:
  PushVideoStreamSubscription_TakePhoto_ResponseParams_Data();
  ~PushVideoStreamSubscription_TakePhoto_ResponseParams_Data() = delete;
};
static_assert(sizeof(PushVideoStreamSubscription_TakePhoto_ResponseParams_Data) == 16,
              "Bad sizeof(PushVideoStreamSubscription_TakePhoto_ResponseParams_Data)");
class  PushVideoStreamSubscription_Close_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(PushVideoStreamSubscription_Close_Params_Data));
      new (data()) PushVideoStreamSubscription_Close_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    PushVideoStreamSubscription_Close_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<PushVideoStreamSubscription_Close_Params_Data>(index_);
    }
    PushVideoStreamSubscription_Close_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  PushVideoStreamSubscription_Close_Params_Data();
  ~PushVideoStreamSubscription_Close_Params_Data() = delete;
};
static_assert(sizeof(PushVideoStreamSubscription_Close_Params_Data) == 8,
              "Bad sizeof(PushVideoStreamSubscription_Close_Params_Data)");
class  PushVideoStreamSubscription_Close_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(PushVideoStreamSubscription_Close_ResponseParams_Data));
      new (data()) PushVideoStreamSubscription_Close_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    PushVideoStreamSubscription_Close_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<PushVideoStreamSubscription_Close_ResponseParams_Data>(index_);
    }
    PushVideoStreamSubscription_Close_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  PushVideoStreamSubscription_Close_ResponseParams_Data();
  ~PushVideoStreamSubscription_Close_ResponseParams_Data() = delete;
};
static_assert(sizeof(PushVideoStreamSubscription_Close_ResponseParams_Data) == 8,
              "Bad sizeof(PushVideoStreamSubscription_Close_ResponseParams_Data)");
class  VideoSource_CreatePushSubscription_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(VideoSource_CreatePushSubscription_Params_Data));
      new (data()) VideoSource_CreatePushSubscription_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    VideoSource_CreatePushSubscription_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<VideoSource_CreatePushSubscription_Params_Data>(index_);
    }
    VideoSource_CreatePushSubscription_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Interface_Data subscriber;
  mojo::internal::Pointer<::media::mojom::internal::VideoCaptureParams_Data> requested_settings;
  uint8_t force_reopen_with_new_settings : 1;
  uint8_t pad2_[3];
  mojo::internal::Handle_Data subscription;

 private:
  VideoSource_CreatePushSubscription_Params_Data();
  ~VideoSource_CreatePushSubscription_Params_Data() = delete;
};
static_assert(sizeof(VideoSource_CreatePushSubscription_Params_Data) == 32,
              "Bad sizeof(VideoSource_CreatePushSubscription_Params_Data)");
class  VideoSource_CreatePushSubscription_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(VideoSource_CreatePushSubscription_ResponseParams_Data));
      new (data()) VideoSource_CreatePushSubscription_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    VideoSource_CreatePushSubscription_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<VideoSource_CreatePushSubscription_ResponseParams_Data>(index_);
    }
    VideoSource_CreatePushSubscription_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t result_code;
  uint8_t pad0_[4];
  mojo::internal::Pointer<::media::mojom::internal::VideoCaptureParams_Data> settings_source_was_opened_with;

 private:
  VideoSource_CreatePushSubscription_ResponseParams_Data();
  ~VideoSource_CreatePushSubscription_ResponseParams_Data() = delete;
};
static_assert(sizeof(VideoSource_CreatePushSubscription_ResponseParams_Data) == 24,
              "Bad sizeof(VideoSource_CreatePushSubscription_ResponseParams_Data)");

}  // namespace internal


class PushVideoStreamSubscription_Activate_ParamsDataView {
 public:
  PushVideoStreamSubscription_Activate_ParamsDataView() {}

  PushVideoStreamSubscription_Activate_ParamsDataView(
      internal::PushVideoStreamSubscription_Activate_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::PushVideoStreamSubscription_Activate_Params_Data* data_ = nullptr;
};



class PushVideoStreamSubscription_Suspend_ParamsDataView {
 public:
  PushVideoStreamSubscription_Suspend_ParamsDataView() {}

  PushVideoStreamSubscription_Suspend_ParamsDataView(
      internal::PushVideoStreamSubscription_Suspend_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::PushVideoStreamSubscription_Suspend_Params_Data* data_ = nullptr;
};



class PushVideoStreamSubscription_Suspend_ResponseParamsDataView {
 public:
  PushVideoStreamSubscription_Suspend_ResponseParamsDataView() {}

  PushVideoStreamSubscription_Suspend_ResponseParamsDataView(
      internal::PushVideoStreamSubscription_Suspend_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::PushVideoStreamSubscription_Suspend_ResponseParams_Data* data_ = nullptr;
};



class PushVideoStreamSubscription_Resume_ParamsDataView {
 public:
  PushVideoStreamSubscription_Resume_ParamsDataView() {}

  PushVideoStreamSubscription_Resume_ParamsDataView(
      internal::PushVideoStreamSubscription_Resume_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::PushVideoStreamSubscription_Resume_Params_Data* data_ = nullptr;
};



class PushVideoStreamSubscription_GetPhotoState_ParamsDataView {
 public:
  PushVideoStreamSubscription_GetPhotoState_ParamsDataView() {}

  PushVideoStreamSubscription_GetPhotoState_ParamsDataView(
      internal::PushVideoStreamSubscription_GetPhotoState_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::PushVideoStreamSubscription_GetPhotoState_Params_Data* data_ = nullptr;
};



class PushVideoStreamSubscription_GetPhotoState_ResponseParamsDataView {
 public:
  PushVideoStreamSubscription_GetPhotoState_ResponseParamsDataView() {}

  PushVideoStreamSubscription_GetPhotoState_ResponseParamsDataView(
      internal::PushVideoStreamSubscription_GetPhotoState_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetCapabilitiesDataView(
      ::media::mojom::PhotoStateDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadCapabilities(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::PhotoStateDataView, UserType>(),
    "Attempting to read the optional `capabilities` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCapabilities` instead "
    "of `ReadCapabilities if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->capabilities.Get();
    return mojo::internal::Deserialize<::media::mojom::PhotoStateDataView>(
        pointer, output, context_);
  }
 private:
  internal::PushVideoStreamSubscription_GetPhotoState_ResponseParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class PushVideoStreamSubscription_SetPhotoOptions_ParamsDataView {
 public:
  PushVideoStreamSubscription_SetPhotoOptions_ParamsDataView() {}

  PushVideoStreamSubscription_SetPhotoOptions_ParamsDataView(
      internal::PushVideoStreamSubscription_SetPhotoOptions_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetSettingsDataView(
      ::media::mojom::PhotoSettingsDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSettings(UserType* output) {
    
    auto* pointer = data_->settings.Get();
    return mojo::internal::Deserialize<::media::mojom::PhotoSettingsDataView>(
        pointer, output, context_);
  }
 private:
  internal::PushVideoStreamSubscription_SetPhotoOptions_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class PushVideoStreamSubscription_SetPhotoOptions_ResponseParamsDataView {
 public:
  PushVideoStreamSubscription_SetPhotoOptions_ResponseParamsDataView() {}

  PushVideoStreamSubscription_SetPhotoOptions_ResponseParamsDataView(
      internal::PushVideoStreamSubscription_SetPhotoOptions_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool success() const {
    return data_->success;
  }
 private:
  internal::PushVideoStreamSubscription_SetPhotoOptions_ResponseParams_Data* data_ = nullptr;
};



class PushVideoStreamSubscription_TakePhoto_ParamsDataView {
 public:
  PushVideoStreamSubscription_TakePhoto_ParamsDataView() {}

  PushVideoStreamSubscription_TakePhoto_ParamsDataView(
      internal::PushVideoStreamSubscription_TakePhoto_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::PushVideoStreamSubscription_TakePhoto_Params_Data* data_ = nullptr;
};



class PushVideoStreamSubscription_TakePhoto_ResponseParamsDataView {
 public:
  PushVideoStreamSubscription_TakePhoto_ResponseParamsDataView() {}

  PushVideoStreamSubscription_TakePhoto_ResponseParamsDataView(
      internal::PushVideoStreamSubscription_TakePhoto_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetBlobDataView(
      ::media::mojom::BlobDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadBlob(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::BlobDataView, UserType>(),
    "Attempting to read the optional `blob` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBlob` instead "
    "of `ReadBlob if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->blob.Get();
    return mojo::internal::Deserialize<::media::mojom::BlobDataView>(
        pointer, output, context_);
  }
 private:
  internal::PushVideoStreamSubscription_TakePhoto_ResponseParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class PushVideoStreamSubscription_Close_ParamsDataView {
 public:
  PushVideoStreamSubscription_Close_ParamsDataView() {}

  PushVideoStreamSubscription_Close_ParamsDataView(
      internal::PushVideoStreamSubscription_Close_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::PushVideoStreamSubscription_Close_Params_Data* data_ = nullptr;
};



class PushVideoStreamSubscription_Close_ResponseParamsDataView {
 public:
  PushVideoStreamSubscription_Close_ResponseParamsDataView() {}

  PushVideoStreamSubscription_Close_ResponseParamsDataView(
      internal::PushVideoStreamSubscription_Close_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::PushVideoStreamSubscription_Close_ResponseParams_Data* data_ = nullptr;
};



class VideoSource_CreatePushSubscription_ParamsDataView {
 public:
  VideoSource_CreatePushSubscription_ParamsDataView() {}

  VideoSource_CreatePushSubscription_ParamsDataView(
      internal::VideoSource_CreatePushSubscription_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeSubscriber() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::video_capture::mojom::VideoFrameHandlerInterfaceBase>>(
            &data_->subscriber, &result, context_);
    DCHECK(ret);
    return result;
  }
  inline void GetRequestedSettingsDataView(
      ::media::mojom::VideoCaptureParamsDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRequestedSettings(UserType* output) {
    
    auto* pointer = data_->requested_settings.Get();
    return mojo::internal::Deserialize<::media::mojom::VideoCaptureParamsDataView>(
        pointer, output, context_);
  }
  bool force_reopen_with_new_settings() const {
    return data_->force_reopen_with_new_settings;
  }
  template <typename UserType>
  UserType TakeSubscription() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::video_capture::mojom::PushVideoStreamSubscriptionInterfaceBase>>(
            &data_->subscription, &result, context_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::VideoSource_CreatePushSubscription_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class VideoSource_CreatePushSubscription_ResponseParamsDataView {
 public:
  VideoSource_CreatePushSubscription_ResponseParamsDataView() {}

  VideoSource_CreatePushSubscription_ResponseParamsDataView(
      internal::VideoSource_CreatePushSubscription_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadResultCode(UserType* output) const {
    auto data_value = data_->result_code;
    return mojo::internal::Deserialize<::video_capture::mojom::CreatePushSubscriptionResultCode>(
        data_value, output);
  }

  CreatePushSubscriptionResultCode result_code() const {
    return static_cast<CreatePushSubscriptionResultCode>(data_->result_code);
  }
  inline void GetSettingsSourceWasOpenedWithDataView(
      ::media::mojom::VideoCaptureParamsDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSettingsSourceWasOpenedWith(UserType* output) {
    
    auto* pointer = data_->settings_source_was_opened_with.Get();
    return mojo::internal::Deserialize<::media::mojom::VideoCaptureParamsDataView>(
        pointer, output, context_);
  }
 private:
  internal::VideoSource_CreatePushSubscription_ResponseParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};












inline void PushVideoStreamSubscription_GetPhotoState_ResponseParamsDataView::GetCapabilitiesDataView(
    ::media::mojom::PhotoStateDataView* output) {
  auto pointer = data_->capabilities.Get();
  *output = ::media::mojom::PhotoStateDataView(pointer, context_);
}


inline void PushVideoStreamSubscription_SetPhotoOptions_ParamsDataView::GetSettingsDataView(
    ::media::mojom::PhotoSettingsDataView* output) {
  auto pointer = data_->settings.Get();
  *output = ::media::mojom::PhotoSettingsDataView(pointer, context_);
}






inline void PushVideoStreamSubscription_TakePhoto_ResponseParamsDataView::GetBlobDataView(
    ::media::mojom::BlobDataView* output) {
  auto pointer = data_->blob.Get();
  *output = ::media::mojom::BlobDataView(pointer, context_);
}






inline void VideoSource_CreatePushSubscription_ParamsDataView::GetRequestedSettingsDataView(
    ::media::mojom::VideoCaptureParamsDataView* output) {
  auto pointer = data_->requested_settings.Get();
  *output = ::media::mojom::VideoCaptureParamsDataView(pointer, context_);
}


inline void VideoSource_CreatePushSubscription_ResponseParamsDataView::GetSettingsSourceWasOpenedWithDataView(
    ::media::mojom::VideoCaptureParamsDataView* output) {
  auto pointer = data_->settings_source_was_opened_with.Get();
  *output = ::media::mojom::VideoCaptureParamsDataView(pointer, context_);
}

}  // namespace mojom
}  // namespace video_capture

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_VIDEO_SOURCE_MOJOM_PARAMS_DATA_H_