// services/video_capture/public/mojom/virtual_device.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/video_capture/public/mojom/virtual_device.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/video_capture/public/mojom/virtual_device.mojom-params-data.h"
#include "services/video_capture/public/mojom/virtual_device.mojom-shared-message-ids.h"

#include "services/video_capture/public/mojom/virtual_device.mojom-import-headers.h"


#ifndef SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_VIRTUAL_DEVICE_MOJOM_JUMBO_H_
#define SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_VIRTUAL_DEVICE_MOJOM_JUMBO_H_
#endif
namespace video_capture {
namespace mojom {
const char SharedMemoryVirtualDevice::Name_[] = "video_capture.mojom.SharedMemoryVirtualDevice";

class SharedMemoryVirtualDevice_RequestFrameBuffer_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SharedMemoryVirtualDevice_RequestFrameBuffer_ForwardToCallback(
      SharedMemoryVirtualDevice::RequestFrameBufferCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  SharedMemoryVirtualDevice::RequestFrameBufferCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(SharedMemoryVirtualDevice_RequestFrameBuffer_ForwardToCallback);
};

SharedMemoryVirtualDeviceProxy::SharedMemoryVirtualDeviceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SharedMemoryVirtualDeviceProxy::RequestFrameBuffer(
    const ::gfx::Size& in_dimension, ::media::VideoPixelFormat in_pixel_format, ::media::mojom::PlaneStridesPtr in_strides, RequestFrameBufferCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "video_capture::mojom::SharedMemoryVirtualDevice::RequestFrameBuffer", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("dimension", base::trace_event::ValueToString(in_dimension, "<value of type const ::gfx::Size&>"));
      raw_value->SetInteger("pixel_format", static_cast<int>(in_pixel_format));
      if (in_strides.is_null()) {
        raw_value->SetString("strides", "nullptr");
      } else {
        raw_value->BeginDictionary("strides");
        in_strides->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSharedMemoryVirtualDevice_RequestFrameBuffer_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::video_capture::mojom::internal::SharedMemoryVirtualDevice_RequestFrameBuffer_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->dimension)::BaseType::BufferWriter
      dimension_writer;
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_dimension, buffer, &dimension_writer, &serialization_context);
  params->dimension.Set(
      dimension_writer.is_null() ? nullptr : dimension_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->dimension.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null dimension in SharedMemoryVirtualDevice.RequestFrameBuffer request");
  mojo::internal::Serialize<::media::mojom::VideoCapturePixelFormat>(
      in_pixel_format, &params->pixel_format);
  typename decltype(params->strides)::BaseType::BufferWriter
      strides_writer;
  mojo::internal::Serialize<::media::mojom::PlaneStridesDataView>(
      in_strides, buffer, &strides_writer, &serialization_context);
  params->strides.Set(
      strides_writer.is_null() ? nullptr : strides_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedMemoryVirtualDevice::Name_);
  message.set_method_name("RequestFrameBuffer");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SharedMemoryVirtualDevice_RequestFrameBuffer_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void SharedMemoryVirtualDeviceProxy::OnFrameReadyInBuffer(
    int32_t in_buffer_id, ::media::mojom::VideoFrameInfoPtr in_frame_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "video_capture::mojom::SharedMemoryVirtualDevice::OnFrameReadyInBuffer", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("buffer_id", in_buffer_id);
      if (in_frame_info.is_null()) {
        raw_value->SetString("frame_info", "nullptr");
      } else {
        raw_value->BeginDictionary("frame_info");
        in_frame_info->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSharedMemoryVirtualDevice_OnFrameReadyInBuffer_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::video_capture::mojom::internal::SharedMemoryVirtualDevice_OnFrameReadyInBuffer_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->buffer_id = in_buffer_id;
  typename decltype(params->frame_info)::BaseType::BufferWriter
      frame_info_writer;
  mojo::internal::Serialize<::media::mojom::VideoFrameInfoDataView>(
      in_frame_info, buffer, &frame_info_writer, &serialization_context);
  params->frame_info.Set(
      frame_info_writer.is_null() ? nullptr : frame_info_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_info in SharedMemoryVirtualDevice.OnFrameReadyInBuffer request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedMemoryVirtualDevice::Name_);
  message.set_method_name("OnFrameReadyInBuffer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class SharedMemoryVirtualDevice_RequestFrameBuffer_ProxyToResponder {
 public:
  static SharedMemoryVirtualDevice::RequestFrameBufferCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<SharedMemoryVirtualDevice_RequestFrameBuffer_ProxyToResponder> proxy(
        new SharedMemoryVirtualDevice_RequestFrameBuffer_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&SharedMemoryVirtualDevice_RequestFrameBuffer_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SharedMemoryVirtualDevice_RequestFrameBuffer_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  SharedMemoryVirtualDevice_RequestFrameBuffer_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SharedMemoryVirtualDevice::RequestFrameBufferCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_buffer_id);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(SharedMemoryVirtualDevice_RequestFrameBuffer_ProxyToResponder);
};

bool SharedMemoryVirtualDevice_RequestFrameBuffer_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "video_capture::mojom::SharedMemoryVirtualDevice::RequestFrameBufferCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::SharedMemoryVirtualDevice_RequestFrameBuffer_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SharedMemoryVirtualDevice_RequestFrameBuffer_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  int32_t p_buffer_id{};
  SharedMemoryVirtualDevice_RequestFrameBuffer_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_buffer_id = input_data_view.buffer_id();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SharedMemoryVirtualDevice::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_buffer_id));
  return true;
}

void SharedMemoryVirtualDevice_RequestFrameBuffer_ProxyToResponder::Run(
    int32_t in_buffer_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)video_capture::mojom::SharedMemoryVirtualDevice::RequestFrameBufferCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("buffer_id", in_buffer_id);
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSharedMemoryVirtualDevice_RequestFrameBuffer_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::video_capture::mojom::internal::SharedMemoryVirtualDevice_RequestFrameBuffer_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->buffer_id = in_buffer_id;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)video_capture::mojom::SharedMemoryVirtualDevice::RequestFrameBufferCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedMemoryVirtualDevice::Name_);
  message.set_method_name("RequestFrameBuffer");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool SharedMemoryVirtualDeviceStubDispatch::Accept(
    SharedMemoryVirtualDevice* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kSharedMemoryVirtualDevice_RequestFrameBuffer_Name: {
      break;
    }
    case internal::kSharedMemoryVirtualDevice_OnFrameReadyInBuffer_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)video_capture::mojom::SharedMemoryVirtualDevice::OnFrameReadyInBuffer",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)video_capture::mojom::SharedMemoryVirtualDevice::OnFrameReadyInBuffer");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SharedMemoryVirtualDevice_OnFrameReadyInBuffer_Params_Data* params =
          reinterpret_cast<internal::SharedMemoryVirtualDevice_OnFrameReadyInBuffer_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_buffer_id{};
      ::media::mojom::VideoFrameInfoPtr p_frame_info{};
      SharedMemoryVirtualDevice_OnFrameReadyInBuffer_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_buffer_id = input_data_view.buffer_id();
      if (success && !input_data_view.ReadFrameInfo(&p_frame_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SharedMemoryVirtualDevice::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFrameReadyInBuffer(
std::move(p_buffer_id), 
std::move(p_frame_info));
      return true;
    }
  }
  return false;
}

// static
bool SharedMemoryVirtualDeviceStubDispatch::AcceptWithResponder(
    SharedMemoryVirtualDevice* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kSharedMemoryVirtualDevice_RequestFrameBuffer_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)video_capture::mojom::SharedMemoryVirtualDevice::RequestFrameBuffer",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)video_capture::mojom::SharedMemoryVirtualDevice::RequestFrameBuffer");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::SharedMemoryVirtualDevice_RequestFrameBuffer_Params_Data* params =
          reinterpret_cast<
              internal::SharedMemoryVirtualDevice_RequestFrameBuffer_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::gfx::Size p_dimension{};
      ::media::VideoPixelFormat p_pixel_format{};
      ::media::mojom::PlaneStridesPtr p_strides{};
      SharedMemoryVirtualDevice_RequestFrameBuffer_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadDimension(&p_dimension))
        success = false;
      if (success && !input_data_view.ReadPixelFormat(&p_pixel_format))
        success = false;
      if (success && !input_data_view.ReadStrides(&p_strides))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SharedMemoryVirtualDevice::Name_, 0, false);
        return false;
      }
      SharedMemoryVirtualDevice::RequestFrameBufferCallback callback =
          SharedMemoryVirtualDevice_RequestFrameBuffer_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestFrameBuffer(
std::move(p_dimension), 
std::move(p_pixel_format), 
std::move(p_strides), std::move(callback));
      return true;
    }
    case internal::kSharedMemoryVirtualDevice_OnFrameReadyInBuffer_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kSharedMemoryVirtualDeviceValidationInfo[] = {
    {internal::kSharedMemoryVirtualDevice_RequestFrameBuffer_Name,
     {&internal::SharedMemoryVirtualDevice_RequestFrameBuffer_Params_Data::Validate,
      &internal::SharedMemoryVirtualDevice_RequestFrameBuffer_ResponseParams_Data::Validate}},
    {internal::kSharedMemoryVirtualDevice_OnFrameReadyInBuffer_Name,
     {&internal::SharedMemoryVirtualDevice_OnFrameReadyInBuffer_Params_Data::Validate,
      nullptr /* no response */}},
};

bool SharedMemoryVirtualDeviceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::video_capture::mojom::SharedMemoryVirtualDevice::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kSharedMemoryVirtualDeviceValidationInfo);
}

bool SharedMemoryVirtualDeviceResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::video_capture::mojom::SharedMemoryVirtualDevice::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kSharedMemoryVirtualDeviceValidationInfo);

}
const char TextureVirtualDevice::Name_[] = "video_capture.mojom.TextureVirtualDevice";

TextureVirtualDeviceProxy::TextureVirtualDeviceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void TextureVirtualDeviceProxy::OnNewMailboxHolderBufferHandle(
    int32_t in_buffer_id, ::media::mojom::MailboxBufferHandleSetPtr in_mailbox_handles) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "video_capture::mojom::TextureVirtualDevice::OnNewMailboxHolderBufferHandle", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("buffer_id", in_buffer_id);
      if (in_mailbox_handles.is_null()) {
        raw_value->SetString("mailbox_handles", "nullptr");
      } else {
        raw_value->BeginDictionary("mailbox_handles");
        in_mailbox_handles->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kTextureVirtualDevice_OnNewMailboxHolderBufferHandle_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::video_capture::mojom::internal::TextureVirtualDevice_OnNewMailboxHolderBufferHandle_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->buffer_id = in_buffer_id;
  typename decltype(params->mailbox_handles)::BaseType::BufferWriter
      mailbox_handles_writer;
  mojo::internal::Serialize<::media::mojom::MailboxBufferHandleSetDataView>(
      in_mailbox_handles, buffer, &mailbox_handles_writer, &serialization_context);
  params->mailbox_handles.Set(
      mailbox_handles_writer.is_null() ? nullptr : mailbox_handles_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->mailbox_handles.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null mailbox_handles in TextureVirtualDevice.OnNewMailboxHolderBufferHandle request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextureVirtualDevice::Name_);
  message.set_method_name("OnNewMailboxHolderBufferHandle");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void TextureVirtualDeviceProxy::OnFrameReadyInBuffer(
    int32_t in_buffer_id, ::mojo::PendingRemote<::video_capture::mojom::ScopedAccessPermission> in_access_permission, ::media::mojom::VideoFrameInfoPtr in_frame_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "video_capture::mojom::TextureVirtualDevice::OnFrameReadyInBuffer", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("buffer_id", in_buffer_id);
      raw_value->SetBoolean("access_permission", in_access_permission.is_valid());
      if (in_frame_info.is_null()) {
        raw_value->SetString("frame_info", "nullptr");
      } else {
        raw_value->BeginDictionary("frame_info");
        in_frame_info->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kTextureVirtualDevice_OnFrameReadyInBuffer_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::video_capture::mojom::internal::TextureVirtualDevice_OnFrameReadyInBuffer_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->buffer_id = in_buffer_id;
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::video_capture::mojom::ScopedAccessPermissionInterfaceBase>>(
      in_access_permission, &params->access_permission, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->access_permission),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid access_permission in TextureVirtualDevice.OnFrameReadyInBuffer request");
  typename decltype(params->frame_info)::BaseType::BufferWriter
      frame_info_writer;
  mojo::internal::Serialize<::media::mojom::VideoFrameInfoDataView>(
      in_frame_info, buffer, &frame_info_writer, &serialization_context);
  params->frame_info.Set(
      frame_info_writer.is_null() ? nullptr : frame_info_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_info in TextureVirtualDevice.OnFrameReadyInBuffer request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextureVirtualDevice::Name_);
  message.set_method_name("OnFrameReadyInBuffer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void TextureVirtualDeviceProxy::OnBufferRetired(
    int32_t in_buffer_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "video_capture::mojom::TextureVirtualDevice::OnBufferRetired", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("buffer_id", in_buffer_id);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kTextureVirtualDevice_OnBufferRetired_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::video_capture::mojom::internal::TextureVirtualDevice_OnBufferRetired_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->buffer_id = in_buffer_id;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextureVirtualDevice::Name_);
  message.set_method_name("OnBufferRetired");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool TextureVirtualDeviceStubDispatch::Accept(
    TextureVirtualDevice* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kTextureVirtualDevice_OnNewMailboxHolderBufferHandle_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)video_capture::mojom::TextureVirtualDevice::OnNewMailboxHolderBufferHandle",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)video_capture::mojom::TextureVirtualDevice::OnNewMailboxHolderBufferHandle");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::TextureVirtualDevice_OnNewMailboxHolderBufferHandle_Params_Data* params =
          reinterpret_cast<internal::TextureVirtualDevice_OnNewMailboxHolderBufferHandle_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_buffer_id{};
      ::media::mojom::MailboxBufferHandleSetPtr p_mailbox_handles{};
      TextureVirtualDevice_OnNewMailboxHolderBufferHandle_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_buffer_id = input_data_view.buffer_id();
      if (success && !input_data_view.ReadMailboxHandles(&p_mailbox_handles))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TextureVirtualDevice::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnNewMailboxHolderBufferHandle(
std::move(p_buffer_id), 
std::move(p_mailbox_handles));
      return true;
    }
    case internal::kTextureVirtualDevice_OnFrameReadyInBuffer_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)video_capture::mojom::TextureVirtualDevice::OnFrameReadyInBuffer",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)video_capture::mojom::TextureVirtualDevice::OnFrameReadyInBuffer");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::TextureVirtualDevice_OnFrameReadyInBuffer_Params_Data* params =
          reinterpret_cast<internal::TextureVirtualDevice_OnFrameReadyInBuffer_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_buffer_id{};
      ::mojo::PendingRemote<::video_capture::mojom::ScopedAccessPermission> p_access_permission{};
      ::media::mojom::VideoFrameInfoPtr p_frame_info{};
      TextureVirtualDevice_OnFrameReadyInBuffer_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_buffer_id = input_data_view.buffer_id();
      if (success) {
        p_access_permission =
            input_data_view.TakeAccessPermission<decltype(p_access_permission)>();
      }
      if (success && !input_data_view.ReadFrameInfo(&p_frame_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TextureVirtualDevice::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFrameReadyInBuffer(
std::move(p_buffer_id), 
std::move(p_access_permission), 
std::move(p_frame_info));
      return true;
    }
    case internal::kTextureVirtualDevice_OnBufferRetired_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)video_capture::mojom::TextureVirtualDevice::OnBufferRetired",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)video_capture::mojom::TextureVirtualDevice::OnBufferRetired");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::TextureVirtualDevice_OnBufferRetired_Params_Data* params =
          reinterpret_cast<internal::TextureVirtualDevice_OnBufferRetired_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_buffer_id{};
      TextureVirtualDevice_OnBufferRetired_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_buffer_id = input_data_view.buffer_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TextureVirtualDevice::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnBufferRetired(
std::move(p_buffer_id));
      return true;
    }
  }
  return false;
}

// static
bool TextureVirtualDeviceStubDispatch::AcceptWithResponder(
    TextureVirtualDevice* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kTextureVirtualDevice_OnNewMailboxHolderBufferHandle_Name: {
      break;
    }
    case internal::kTextureVirtualDevice_OnFrameReadyInBuffer_Name: {
      break;
    }
    case internal::kTextureVirtualDevice_OnBufferRetired_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kTextureVirtualDeviceValidationInfo[] = {
    {internal::kTextureVirtualDevice_OnNewMailboxHolderBufferHandle_Name,
     {&internal::TextureVirtualDevice_OnNewMailboxHolderBufferHandle_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kTextureVirtualDevice_OnFrameReadyInBuffer_Name,
     {&internal::TextureVirtualDevice_OnFrameReadyInBuffer_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kTextureVirtualDevice_OnBufferRetired_Name,
     {&internal::TextureVirtualDevice_OnBufferRetired_Params_Data::Validate,
      nullptr /* no response */}},
};

bool TextureVirtualDeviceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::video_capture::mojom::TextureVirtualDevice::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kTextureVirtualDeviceValidationInfo);
}

const char GpuMemoryBufferVirtualDevice::Name_[] = "video_capture.mojom.GpuMemoryBufferVirtualDevice";

GpuMemoryBufferVirtualDeviceProxy::GpuMemoryBufferVirtualDeviceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void GpuMemoryBufferVirtualDeviceProxy::OnNewGpuMemoryBufferHandle(
    int32_t in_buffer_id, ::gfx::GpuMemoryBufferHandle in_gmb_handle) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "video_capture::mojom::GpuMemoryBufferVirtualDevice::OnNewGpuMemoryBufferHandle", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("buffer_id", in_buffer_id);
      raw_value->SetString("gmb_handle", base::trace_event::ValueToString(in_gmb_handle, "<value of type ::gfx::GpuMemoryBufferHandle>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGpuMemoryBufferVirtualDevice_OnNewGpuMemoryBufferHandle_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::video_capture::mojom::internal::GpuMemoryBufferVirtualDevice_OnNewGpuMemoryBufferHandle_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->buffer_id = in_buffer_id;
  typename decltype(params->gmb_handle)::BaseType::BufferWriter
      gmb_handle_writer;
  mojo::internal::Serialize<::gfx::mojom::GpuMemoryBufferHandleDataView>(
      in_gmb_handle, buffer, &gmb_handle_writer, &serialization_context);
  params->gmb_handle.Set(
      gmb_handle_writer.is_null() ? nullptr : gmb_handle_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->gmb_handle.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null gmb_handle in GpuMemoryBufferVirtualDevice.OnNewGpuMemoryBufferHandle request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuMemoryBufferVirtualDevice::Name_);
  message.set_method_name("OnNewGpuMemoryBufferHandle");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuMemoryBufferVirtualDeviceProxy::OnFrameReadyInBuffer(
    int32_t in_buffer_id, ::mojo::PendingRemote<::video_capture::mojom::ScopedAccessPermission> in_access_permission, ::media::mojom::VideoFrameInfoPtr in_frame_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "video_capture::mojom::GpuMemoryBufferVirtualDevice::OnFrameReadyInBuffer", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("buffer_id", in_buffer_id);
      raw_value->SetBoolean("access_permission", in_access_permission.is_valid());
      if (in_frame_info.is_null()) {
        raw_value->SetString("frame_info", "nullptr");
      } else {
        raw_value->BeginDictionary("frame_info");
        in_frame_info->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGpuMemoryBufferVirtualDevice_OnFrameReadyInBuffer_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::video_capture::mojom::internal::GpuMemoryBufferVirtualDevice_OnFrameReadyInBuffer_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->buffer_id = in_buffer_id;
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::video_capture::mojom::ScopedAccessPermissionInterfaceBase>>(
      in_access_permission, &params->access_permission, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->access_permission),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid access_permission in GpuMemoryBufferVirtualDevice.OnFrameReadyInBuffer request");
  typename decltype(params->frame_info)::BaseType::BufferWriter
      frame_info_writer;
  mojo::internal::Serialize<::media::mojom::VideoFrameInfoDataView>(
      in_frame_info, buffer, &frame_info_writer, &serialization_context);
  params->frame_info.Set(
      frame_info_writer.is_null() ? nullptr : frame_info_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_info in GpuMemoryBufferVirtualDevice.OnFrameReadyInBuffer request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuMemoryBufferVirtualDevice::Name_);
  message.set_method_name("OnFrameReadyInBuffer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuMemoryBufferVirtualDeviceProxy::OnBufferRetired(
    int32_t in_buffer_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "video_capture::mojom::GpuMemoryBufferVirtualDevice::OnBufferRetired", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("buffer_id", in_buffer_id);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGpuMemoryBufferVirtualDevice_OnBufferRetired_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::video_capture::mojom::internal::GpuMemoryBufferVirtualDevice_OnBufferRetired_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->buffer_id = in_buffer_id;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuMemoryBufferVirtualDevice::Name_);
  message.set_method_name("OnBufferRetired");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool GpuMemoryBufferVirtualDeviceStubDispatch::Accept(
    GpuMemoryBufferVirtualDevice* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kGpuMemoryBufferVirtualDevice_OnNewGpuMemoryBufferHandle_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)video_capture::mojom::GpuMemoryBufferVirtualDevice::OnNewGpuMemoryBufferHandle",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)video_capture::mojom::GpuMemoryBufferVirtualDevice::OnNewGpuMemoryBufferHandle");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuMemoryBufferVirtualDevice_OnNewGpuMemoryBufferHandle_Params_Data* params =
          reinterpret_cast<internal::GpuMemoryBufferVirtualDevice_OnNewGpuMemoryBufferHandle_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_buffer_id{};
      ::gfx::GpuMemoryBufferHandle p_gmb_handle{};
      GpuMemoryBufferVirtualDevice_OnNewGpuMemoryBufferHandle_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_buffer_id = input_data_view.buffer_id();
      if (success && !input_data_view.ReadGmbHandle(&p_gmb_handle))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuMemoryBufferVirtualDevice::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnNewGpuMemoryBufferHandle(
std::move(p_buffer_id), 
std::move(p_gmb_handle));
      return true;
    }
    case internal::kGpuMemoryBufferVirtualDevice_OnFrameReadyInBuffer_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)video_capture::mojom::GpuMemoryBufferVirtualDevice::OnFrameReadyInBuffer",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)video_capture::mojom::GpuMemoryBufferVirtualDevice::OnFrameReadyInBuffer");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuMemoryBufferVirtualDevice_OnFrameReadyInBuffer_Params_Data* params =
          reinterpret_cast<internal::GpuMemoryBufferVirtualDevice_OnFrameReadyInBuffer_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_buffer_id{};
      ::mojo::PendingRemote<::video_capture::mojom::ScopedAccessPermission> p_access_permission{};
      ::media::mojom::VideoFrameInfoPtr p_frame_info{};
      GpuMemoryBufferVirtualDevice_OnFrameReadyInBuffer_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_buffer_id = input_data_view.buffer_id();
      if (success) {
        p_access_permission =
            input_data_view.TakeAccessPermission<decltype(p_access_permission)>();
      }
      if (success && !input_data_view.ReadFrameInfo(&p_frame_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuMemoryBufferVirtualDevice::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFrameReadyInBuffer(
std::move(p_buffer_id), 
std::move(p_access_permission), 
std::move(p_frame_info));
      return true;
    }
    case internal::kGpuMemoryBufferVirtualDevice_OnBufferRetired_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)video_capture::mojom::GpuMemoryBufferVirtualDevice::OnBufferRetired",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)video_capture::mojom::GpuMemoryBufferVirtualDevice::OnBufferRetired");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuMemoryBufferVirtualDevice_OnBufferRetired_Params_Data* params =
          reinterpret_cast<internal::GpuMemoryBufferVirtualDevice_OnBufferRetired_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_buffer_id{};
      GpuMemoryBufferVirtualDevice_OnBufferRetired_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_buffer_id = input_data_view.buffer_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuMemoryBufferVirtualDevice::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnBufferRetired(
std::move(p_buffer_id));
      return true;
    }
  }
  return false;
}

// static
bool GpuMemoryBufferVirtualDeviceStubDispatch::AcceptWithResponder(
    GpuMemoryBufferVirtualDevice* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kGpuMemoryBufferVirtualDevice_OnNewGpuMemoryBufferHandle_Name: {
      break;
    }
    case internal::kGpuMemoryBufferVirtualDevice_OnFrameReadyInBuffer_Name: {
      break;
    }
    case internal::kGpuMemoryBufferVirtualDevice_OnBufferRetired_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kGpuMemoryBufferVirtualDeviceValidationInfo[] = {
    {internal::kGpuMemoryBufferVirtualDevice_OnNewGpuMemoryBufferHandle_Name,
     {&internal::GpuMemoryBufferVirtualDevice_OnNewGpuMemoryBufferHandle_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuMemoryBufferVirtualDevice_OnFrameReadyInBuffer_Name,
     {&internal::GpuMemoryBufferVirtualDevice_OnFrameReadyInBuffer_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuMemoryBufferVirtualDevice_OnBufferRetired_Name,
     {&internal::GpuMemoryBufferVirtualDevice_OnBufferRetired_Params_Data::Validate,
      nullptr /* no response */}},
};

bool GpuMemoryBufferVirtualDeviceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::video_capture::mojom::GpuMemoryBufferVirtualDevice::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kGpuMemoryBufferVirtualDeviceValidationInfo);
}

}  // namespace mojom
}  // namespace video_capture

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif