// services/viz/privileged/mojom/viz_main.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PRIVILEGED_MOJOM_VIZ_MAIN_MOJOM_H_
#define SERVICES_VIZ_PRIVILEGED_MOJOM_VIZ_MAIN_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/viz/privileged/mojom/viz_main.mojom-shared.h"
#include "services/viz/privileged/mojom/viz_main.mojom-forward.h"
#include "components/discardable_memory/public/mojom/discardable_shared_memory_manager.mojom.h"
#include "services/network/public/mojom/tcp_socket.mojom.h"
#include "services/viz/public/mojom/compositing/compositing_mode_watcher.mojom-forward.h"
#include "services/viz/privileged/mojom/compositing/frame_sink_manager.mojom.h"
#include "services/viz/privileged/mojom/compositing/renderer_settings.mojom.h"
#include "services/viz/privileged/mojom/gl/gpu_host.mojom.h"
#include "services/viz/privileged/mojom/gl/gpu_service.mojom.h"
#include "ui/gfx/mojom/font_render_params.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"





// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace viz {
namespace mojom {

class VizMainProxy;

template <typename ImplRefTraits>
class VizMainStub;

class VizMainRequestValidator;


class  VizMain
    : public VizMainInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = VizMainInterfaceBase;
  using Proxy_ = VizMainProxy;

  template <typename ImplRefTraits>
  using Stub_ = VizMainStub<ImplRefTraits>;

  using RequestValidator_ = VizMainRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreateFrameSinkManagerMinVersion = 0,
    kCreateGpuServiceMinVersion = 0,
    kCreateVizDevToolsMinVersion = 0,
  };
  virtual ~VizMain() {}

  
  virtual void CreateFrameSinkManager(FrameSinkManagerParamsPtr params) = 0;

  
  virtual void CreateGpuService(::mojo::PendingReceiver<::viz::mojom::GpuService> gpu_service, ::mojo::PendingRemote<::viz::mojom::GpuHost> gpu_host, ::mojo::PendingRemote<::discardable_memory::mojom::DiscardableSharedMemoryManager> discardable_memory_manager, ::mojo::ScopedSharedBufferHandle activity_flags, ::gfx::FontRenderParams::SubpixelRendering subpixel_rendering) = 0;

  
  virtual void CreateVizDevTools(VizDevToolsParamsPtr params) = 0;
};



class  VizMainProxy
    : public VizMain {
 public:
  using InterfaceType = VizMain;

  explicit VizMainProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateFrameSinkManager(FrameSinkManagerParamsPtr params) final;
  
  void CreateGpuService(::mojo::PendingReceiver<::viz::mojom::GpuService> gpu_service, ::mojo::PendingRemote<::viz::mojom::GpuHost> gpu_host, ::mojo::PendingRemote<::discardable_memory::mojom::DiscardableSharedMemoryManager> discardable_memory_manager, ::mojo::ScopedSharedBufferHandle activity_flags, ::gfx::FontRenderParams::SubpixelRendering subpixel_rendering) final;
  
  void CreateVizDevTools(VizDevToolsParamsPtr params) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  VizMainStubDispatch {
 public:
  static bool Accept(VizMain* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      VizMain* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<VizMain>>
class VizMainStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  VizMainStub() {}
  ~VizMainStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VizMainStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VizMainStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  VizMainRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class  FrameSinkManagerParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FrameSinkManagerParams, T>::value>;
  using DataView = FrameSinkManagerParamsDataView;
  using Data_ = internal::FrameSinkManagerParams_Data;

  template <typename... Args>
  static FrameSinkManagerParamsPtr New(Args&&... args) {
    return FrameSinkManagerParamsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FrameSinkManagerParamsPtr From(const U& u) {
    return mojo::TypeConverter<FrameSinkManagerParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FrameSinkManagerParams>::Convert(*this);
  }


  FrameSinkManagerParams();

  FrameSinkManagerParams(
      uint32_t restart_id,
      bool use_activation_deadline,
      uint32_t activation_deadline_in_frames,
      ::mojo::PendingReceiver<::viz::mojom::FrameSinkManager> frame_sink_manager,
      ::mojo::PendingRemote<::viz::mojom::FrameSinkManagerClient> frame_sink_manager_client,
      const ::viz::DebugRendererSettings& debug_renderer_settings);

  ~FrameSinkManagerParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FrameSinkManagerParamsPtr>
  FrameSinkManagerParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FrameSinkManagerParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FrameSinkManagerParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FrameSinkManagerParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FrameSinkManagerParams_UnserializedMessageContext<
            UserType, FrameSinkManagerParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<FrameSinkManagerParams::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return FrameSinkManagerParams::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FrameSinkManagerParams_UnserializedMessageContext<
            UserType, FrameSinkManagerParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FrameSinkManagerParams::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  uint32_t restart_id;
  
  bool use_activation_deadline;
  
  uint32_t activation_deadline_in_frames;
  
  ::mojo::PendingReceiver<::viz::mojom::FrameSinkManager> frame_sink_manager;
  
  ::mojo::PendingRemote<::viz::mojom::FrameSinkManagerClient> frame_sink_manager_client;
  
  ::viz::DebugRendererSettings debug_renderer_settings;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(FrameSinkManagerParams);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FrameSinkManagerParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FrameSinkManagerParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FrameSinkManagerParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FrameSinkManagerParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  VizDevToolsParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VizDevToolsParams, T>::value>;
  using DataView = VizDevToolsParamsDataView;
  using Data_ = internal::VizDevToolsParams_Data;

  template <typename... Args>
  static VizDevToolsParamsPtr New(Args&&... args) {
    return VizDevToolsParamsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VizDevToolsParamsPtr From(const U& u) {
    return mojo::TypeConverter<VizDevToolsParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VizDevToolsParams>::Convert(*this);
  }


  VizDevToolsParams();

  VizDevToolsParams(
      ::mojo::PendingRemote<::network::mojom::TCPServerSocket> server_socket,
      uint16_t server_port);

  ~VizDevToolsParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VizDevToolsParamsPtr>
  VizDevToolsParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VizDevToolsParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VizDevToolsParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VizDevToolsParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VizDevToolsParams_UnserializedMessageContext<
            UserType, VizDevToolsParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<VizDevToolsParams::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return VizDevToolsParams::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VizDevToolsParams_UnserializedMessageContext<
            UserType, VizDevToolsParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VizDevToolsParams::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::mojo::PendingRemote<::network::mojom::TCPServerSocket> server_socket;
  
  uint16_t server_port;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(VizDevToolsParams);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VizDevToolsParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VizDevToolsParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VizDevToolsParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VizDevToolsParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
FrameSinkManagerParamsPtr FrameSinkManagerParams::Clone() const {
  return New(
      mojo::Clone(restart_id),
      mojo::Clone(use_activation_deadline),
      mojo::Clone(activation_deadline_in_frames),
      mojo::Clone(frame_sink_manager),
      mojo::Clone(frame_sink_manager_client),
      mojo::Clone(debug_renderer_settings)
  );
}

template <typename T, FrameSinkManagerParams::EnableIfSame<T>*>
bool FrameSinkManagerParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->restart_id, other_struct.restart_id))
    return false;
  if (!mojo::Equals(this->use_activation_deadline, other_struct.use_activation_deadline))
    return false;
  if (!mojo::Equals(this->activation_deadline_in_frames, other_struct.activation_deadline_in_frames))
    return false;
  if (!mojo::Equals(this->frame_sink_manager, other_struct.frame_sink_manager))
    return false;
  if (!mojo::Equals(this->frame_sink_manager_client, other_struct.frame_sink_manager_client))
    return false;
  if (!mojo::Equals(this->debug_renderer_settings, other_struct.debug_renderer_settings))
    return false;
  return true;
}

template <typename T, FrameSinkManagerParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.restart_id, rhs.restart_id))
    return true;
  if (std::less<>{}(rhs.restart_id, lhs.restart_id))
    return false;
  if (std::less<>{}(lhs.use_activation_deadline, rhs.use_activation_deadline))
    return true;
  if (std::less<>{}(rhs.use_activation_deadline, lhs.use_activation_deadline))
    return false;
  if (std::less<>{}(lhs.activation_deadline_in_frames, rhs.activation_deadline_in_frames))
    return true;
  if (std::less<>{}(rhs.activation_deadline_in_frames, lhs.activation_deadline_in_frames))
    return false;
  if (std::less<>{}(lhs.frame_sink_manager, rhs.frame_sink_manager))
    return true;
  if (std::less<>{}(rhs.frame_sink_manager, lhs.frame_sink_manager))
    return false;
  if (std::less<>{}(lhs.frame_sink_manager_client, rhs.frame_sink_manager_client))
    return true;
  if (std::less<>{}(rhs.frame_sink_manager_client, lhs.frame_sink_manager_client))
    return false;
  if (std::less<>{}(lhs.debug_renderer_settings, rhs.debug_renderer_settings))
    return true;
  if (std::less<>{}(rhs.debug_renderer_settings, lhs.debug_renderer_settings))
    return false;
  return false;
}
template <typename StructPtrType>
VizDevToolsParamsPtr VizDevToolsParams::Clone() const {
  return New(
      mojo::Clone(server_socket),
      mojo::Clone(server_port)
  );
}

template <typename T, VizDevToolsParams::EnableIfSame<T>*>
bool VizDevToolsParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->server_socket, other_struct.server_socket))
    return false;
  if (!mojo::Equals(this->server_port, other_struct.server_port))
    return false;
  return true;
}

template <typename T, VizDevToolsParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.server_socket, rhs.server_socket))
    return true;
  if (std::less<>{}(rhs.server_socket, lhs.server_socket))
    return false;
  if (std::less<>{}(lhs.server_port, rhs.server_port))
    return true;
  if (std::less<>{}(rhs.server_port, lhs.server_port))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace viz

namespace mojo {


template <>
struct  StructTraits<::viz::mojom::FrameSinkManagerParams::DataView,
                                         ::viz::mojom::FrameSinkManagerParamsPtr> {
  static bool IsNull(const ::viz::mojom::FrameSinkManagerParamsPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::FrameSinkManagerParamsPtr* output) { output->reset(); }

  static decltype(::viz::mojom::FrameSinkManagerParams::restart_id) restart_id(
      const ::viz::mojom::FrameSinkManagerParamsPtr& input) {
    return input->restart_id;
  }

  static decltype(::viz::mojom::FrameSinkManagerParams::use_activation_deadline) use_activation_deadline(
      const ::viz::mojom::FrameSinkManagerParamsPtr& input) {
    return input->use_activation_deadline;
  }

  static decltype(::viz::mojom::FrameSinkManagerParams::activation_deadline_in_frames) activation_deadline_in_frames(
      const ::viz::mojom::FrameSinkManagerParamsPtr& input) {
    return input->activation_deadline_in_frames;
  }

  static  decltype(::viz::mojom::FrameSinkManagerParams::frame_sink_manager)& frame_sink_manager(
       ::viz::mojom::FrameSinkManagerParamsPtr& input) {
    return input->frame_sink_manager;
  }

  static  decltype(::viz::mojom::FrameSinkManagerParams::frame_sink_manager_client)& frame_sink_manager_client(
       ::viz::mojom::FrameSinkManagerParamsPtr& input) {
    return input->frame_sink_manager_client;
  }

  static const decltype(::viz::mojom::FrameSinkManagerParams::debug_renderer_settings)& debug_renderer_settings(
      const ::viz::mojom::FrameSinkManagerParamsPtr& input) {
    return input->debug_renderer_settings;
  }

  static bool Read(::viz::mojom::FrameSinkManagerParams::DataView input, ::viz::mojom::FrameSinkManagerParamsPtr* output);
};


template <>
struct  StructTraits<::viz::mojom::VizDevToolsParams::DataView,
                                         ::viz::mojom::VizDevToolsParamsPtr> {
  static bool IsNull(const ::viz::mojom::VizDevToolsParamsPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::VizDevToolsParamsPtr* output) { output->reset(); }

  static  decltype(::viz::mojom::VizDevToolsParams::server_socket)& server_socket(
       ::viz::mojom::VizDevToolsParamsPtr& input) {
    return input->server_socket;
  }

  static decltype(::viz::mojom::VizDevToolsParams::server_port) server_port(
      const ::viz::mojom::VizDevToolsParamsPtr& input) {
    return input->server_port;
  }

  static bool Read(::viz::mojom::VizDevToolsParams::DataView input, ::viz::mojom::VizDevToolsParamsPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_VIZ_PRIVILEGED_MOJOM_VIZ_MAIN_MOJOM_H_