// services/viz/public/mojom/hit_test/input_target_client.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_HIT_TEST_INPUT_TARGET_CLIENT_MOJOM_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_HIT_TEST_INPUT_TARGET_CLIENT_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/viz/public/mojom/hit_test/input_target_client.mojom-shared.h"
#include "services/viz/public/mojom/hit_test/input_target_client.mojom-forward.h"
#include "services/viz/public/mojom/compositing/frame_sink_id.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"





// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace viz {
namespace mojom {

class InputTargetClientProxy;

template <typename ImplRefTraits>
class InputTargetClientStub;

class InputTargetClientRequestValidator;
class InputTargetClientResponseValidator;


class  InputTargetClient
    : public InputTargetClientInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = InputTargetClientInterfaceBase;
  using Proxy_ = InputTargetClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = InputTargetClientStub<ImplRefTraits>;

  using RequestValidator_ = InputTargetClientRequestValidator;
  using ResponseValidator_ = InputTargetClientResponseValidator;
  enum MethodMinVersions : uint32_t {
    kFrameSinkIdAtMinVersion = 0,
  };
  virtual ~InputTargetClient() {}


  using FrameSinkIdAtCallback = base::OnceCallback<void(const ::viz::FrameSinkId&, const ::gfx::PointF&)>;
  
  virtual void FrameSinkIdAt(const ::gfx::PointF& point, uint64_t trace_id, FrameSinkIdAtCallback callback) = 0;
};



class  InputTargetClientProxy
    : public InputTargetClient {
 public:
  using InterfaceType = InputTargetClient;

  explicit InputTargetClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void FrameSinkIdAt(const ::gfx::PointF& point, uint64_t trace_id, FrameSinkIdAtCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  InputTargetClientStubDispatch {
 public:
  static bool Accept(InputTargetClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      InputTargetClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<InputTargetClient>>
class InputTargetClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  InputTargetClientStub() {}
  ~InputTargetClientStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return InputTargetClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return InputTargetClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  InputTargetClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  InputTargetClientResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // namespace mojom
}  // namespace viz

namespace mojo {

}  // namespace mojo

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_HIT_TEST_INPUT_TARGET_CLIENT_MOJOM_H_