// third_party/blink/public/mojom/choosers/date_time_chooser.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_CHOOSERS_DATE_TIME_CHOOSER_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_CHOOSERS_DATE_TIME_CHOOSER_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "third_party/blink/public/mojom/choosers/date_time_chooser.mojom-shared.h"
#include "third_party/blink/public/mojom/choosers/date_time_chooser.mojom-blink-forward.h"
#include "mojo/public/mojom/base/string16.mojom-blink.h"
#include "ui/base/ime/mojom/ime_types.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "third_party/blink/renderer/platform/platform_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace blink {
namespace mojom {
namespace blink {

class DateTimeChooserProxy;

template <typename ImplRefTraits>
class DateTimeChooserStub;

class DateTimeChooserRequestValidator;
class DateTimeChooserResponseValidator;


class PLATFORM_EXPORT DateTimeChooser
    : public DateTimeChooserInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = DateTimeChooserInterfaceBase;
  using Proxy_ = DateTimeChooserProxy;

  template <typename ImplRefTraits>
  using Stub_ = DateTimeChooserStub<ImplRefTraits>;

  using RequestValidator_ = DateTimeChooserRequestValidator;
  using ResponseValidator_ = DateTimeChooserResponseValidator;
  enum MethodMinVersions : uint32_t {
    kOpenDateTimeDialogMinVersion = 0,
  };
  virtual ~DateTimeChooser() {}


  using OpenDateTimeDialogCallback = base::OnceCallback<void(bool, double)>;
  
  virtual void OpenDateTimeDialog(DateTimeDialogValuePtr value, OpenDateTimeDialogCallback callback) = 0;
};



class PLATFORM_EXPORT DateTimeChooserProxy
    : public DateTimeChooser {
 public:
  using InterfaceType = DateTimeChooser;

  explicit DateTimeChooserProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OpenDateTimeDialog(DateTimeDialogValuePtr value, OpenDateTimeDialogCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT DateTimeChooserStubDispatch {
 public:
  static bool Accept(DateTimeChooser* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DateTimeChooser* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DateTimeChooser>>
class DateTimeChooserStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DateTimeChooserStub() {}
  ~DateTimeChooserStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DateTimeChooserStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DateTimeChooserStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT DateTimeChooserRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT DateTimeChooserResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class PLATFORM_EXPORT DateTimeSuggestion {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DateTimeSuggestion, T>::value>;
  using DataView = DateTimeSuggestionDataView;
  using Data_ = internal::DateTimeSuggestion_Data;

  template <typename... Args>
  static DateTimeSuggestionPtr New(Args&&... args) {
    return DateTimeSuggestionPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DateTimeSuggestionPtr From(const U& u) {
    return mojo::TypeConverter<DateTimeSuggestionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DateTimeSuggestion>::Convert(*this);
  }


  DateTimeSuggestion();

  DateTimeSuggestion(
      double value,
      const ::WTF::String& localized_value,
      const ::WTF::String& label);

  ~DateTimeSuggestion();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DateTimeSuggestionPtr>
  DateTimeSuggestionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DateTimeSuggestion::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DateTimeSuggestion::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DateTimeSuggestion::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DateTimeSuggestion_UnserializedMessageContext<
            UserType, DateTimeSuggestion::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<DateTimeSuggestion::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return DateTimeSuggestion::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DateTimeSuggestion_UnserializedMessageContext<
            UserType, DateTimeSuggestion::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DateTimeSuggestion::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  double value;
  
  ::WTF::String localized_value;
  
  ::WTF::String label;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DateTimeSuggestion::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DateTimeSuggestion::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DateTimeSuggestion::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DateTimeSuggestion::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT DateTimeDialogValue {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DateTimeDialogValue, T>::value>;
  using DataView = DateTimeDialogValueDataView;
  using Data_ = internal::DateTimeDialogValue_Data;

  template <typename... Args>
  static DateTimeDialogValuePtr New(Args&&... args) {
    return DateTimeDialogValuePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DateTimeDialogValuePtr From(const U& u) {
    return mojo::TypeConverter<DateTimeDialogValuePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DateTimeDialogValue>::Convert(*this);
  }


  DateTimeDialogValue();

  DateTimeDialogValue(
      ::ui::TextInputType dialog_type,
      double dialog_value,
      double minimum,
      double maximum,
      double step,
      WTF::Vector<DateTimeSuggestionPtr> suggestions);

  ~DateTimeDialogValue();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DateTimeDialogValuePtr>
  DateTimeDialogValuePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DateTimeDialogValue::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DateTimeDialogValue::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DateTimeDialogValue::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DateTimeDialogValue_UnserializedMessageContext<
            UserType, DateTimeDialogValue::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<DateTimeDialogValue::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return DateTimeDialogValue::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DateTimeDialogValue_UnserializedMessageContext<
            UserType, DateTimeDialogValue::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DateTimeDialogValue::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::ui::TextInputType dialog_type;
  
  double dialog_value;
  
  double minimum;
  
  double maximum;
  
  double step;
  
  WTF::Vector<DateTimeSuggestionPtr> suggestions;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(DateTimeDialogValue);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DateTimeDialogValue::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DateTimeDialogValue::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DateTimeDialogValue::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DateTimeDialogValue::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
DateTimeSuggestionPtr DateTimeSuggestion::Clone() const {
  return New(
      mojo::Clone(value),
      mojo::Clone(localized_value),
      mojo::Clone(label)
  );
}

template <typename T, DateTimeSuggestion::EnableIfSame<T>*>
bool DateTimeSuggestion::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  if (!mojo::Equals(this->localized_value, other_struct.localized_value))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  return true;
}

template <typename T, DateTimeSuggestion::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.value, rhs.value))
    return true;
  if (std::less<>{}(rhs.value, lhs.value))
    return false;
  if (std::less<>{}(lhs.localized_value, rhs.localized_value))
    return true;
  if (std::less<>{}(rhs.localized_value, lhs.localized_value))
    return false;
  if (std::less<>{}(lhs.label, rhs.label))
    return true;
  if (std::less<>{}(rhs.label, lhs.label))
    return false;
  return false;
}
template <typename StructPtrType>
DateTimeDialogValuePtr DateTimeDialogValue::Clone() const {
  return New(
      mojo::Clone(dialog_type),
      mojo::Clone(dialog_value),
      mojo::Clone(minimum),
      mojo::Clone(maximum),
      mojo::Clone(step),
      mojo::Clone(suggestions)
  );
}

template <typename T, DateTimeDialogValue::EnableIfSame<T>*>
bool DateTimeDialogValue::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->dialog_type, other_struct.dialog_type))
    return false;
  if (!mojo::Equals(this->dialog_value, other_struct.dialog_value))
    return false;
  if (!mojo::Equals(this->minimum, other_struct.minimum))
    return false;
  if (!mojo::Equals(this->maximum, other_struct.maximum))
    return false;
  if (!mojo::Equals(this->step, other_struct.step))
    return false;
  if (!mojo::Equals(this->suggestions, other_struct.suggestions))
    return false;
  return true;
}

template <typename T, DateTimeDialogValue::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.dialog_type, rhs.dialog_type))
    return true;
  if (std::less<>{}(rhs.dialog_type, lhs.dialog_type))
    return false;
  if (std::less<>{}(lhs.dialog_value, rhs.dialog_value))
    return true;
  if (std::less<>{}(rhs.dialog_value, lhs.dialog_value))
    return false;
  if (std::less<>{}(lhs.minimum, rhs.minimum))
    return true;
  if (std::less<>{}(rhs.minimum, lhs.minimum))
    return false;
  if (std::less<>{}(lhs.maximum, rhs.maximum))
    return true;
  if (std::less<>{}(rhs.maximum, lhs.maximum))
    return false;
  if (std::less<>{}(lhs.step, rhs.step))
    return true;
  if (std::less<>{}(rhs.step, lhs.step))
    return false;
  if (std::less<>{}(lhs.suggestions, rhs.suggestions))
    return true;
  if (std::less<>{}(rhs.suggestions, lhs.suggestions))
    return false;
  return false;
}


}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::DateTimeSuggestion::DataView,
                                         ::blink::mojom::blink::DateTimeSuggestionPtr> {
  static bool IsNull(const ::blink::mojom::blink::DateTimeSuggestionPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::DateTimeSuggestionPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::DateTimeSuggestion::value) value(
      const ::blink::mojom::blink::DateTimeSuggestionPtr& input) {
    return input->value;
  }

  static const decltype(::blink::mojom::blink::DateTimeSuggestion::localized_value)& localized_value(
      const ::blink::mojom::blink::DateTimeSuggestionPtr& input) {
    return input->localized_value;
  }

  static const decltype(::blink::mojom::blink::DateTimeSuggestion::label)& label(
      const ::blink::mojom::blink::DateTimeSuggestionPtr& input) {
    return input->label;
  }

  static bool Read(::blink::mojom::blink::DateTimeSuggestion::DataView input, ::blink::mojom::blink::DateTimeSuggestionPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::DateTimeDialogValue::DataView,
                                         ::blink::mojom::blink::DateTimeDialogValuePtr> {
  static bool IsNull(const ::blink::mojom::blink::DateTimeDialogValuePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::DateTimeDialogValuePtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::DateTimeDialogValue::dialog_type) dialog_type(
      const ::blink::mojom::blink::DateTimeDialogValuePtr& input) {
    return input->dialog_type;
  }

  static decltype(::blink::mojom::blink::DateTimeDialogValue::dialog_value) dialog_value(
      const ::blink::mojom::blink::DateTimeDialogValuePtr& input) {
    return input->dialog_value;
  }

  static decltype(::blink::mojom::blink::DateTimeDialogValue::minimum) minimum(
      const ::blink::mojom::blink::DateTimeDialogValuePtr& input) {
    return input->minimum;
  }

  static decltype(::blink::mojom::blink::DateTimeDialogValue::maximum) maximum(
      const ::blink::mojom::blink::DateTimeDialogValuePtr& input) {
    return input->maximum;
  }

  static decltype(::blink::mojom::blink::DateTimeDialogValue::step) step(
      const ::blink::mojom::blink::DateTimeDialogValuePtr& input) {
    return input->step;
  }

  static const decltype(::blink::mojom::blink::DateTimeDialogValue::suggestions)& suggestions(
      const ::blink::mojom::blink::DateTimeDialogValuePtr& input) {
    return input->suggestions;
  }

  static bool Read(::blink::mojom::blink::DateTimeDialogValue::DataView input, ::blink::mojom::blink::DateTimeDialogValuePtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_CHOOSERS_DATE_TIME_CHOOSER_MOJOM_BLINK_H_