// third_party/blink/public/mojom/content_index/content_index.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/content_index/content_index.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/content_index/content_index.mojom-params-data.h"
#include "third_party/blink/public/mojom/content_index/content_index.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/content_index/content_index.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONTENT_INDEX_CONTENT_INDEX_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONTENT_INDEX_CONTENT_INDEX_MOJOM_BLINK_JUMBO_H_
#endif
namespace blink {
namespace mojom {
namespace blink {
ContentIconDefinition::ContentIconDefinition()
    : src(),
      sizes(),
      type() {}

ContentIconDefinition::ContentIconDefinition(
    const WTF::String& src_in,
    const WTF::String& sizes_in,
    const WTF::String& type_in)
    : src(std::move(src_in)),
      sizes(std::move(sizes_in)),
      type(std::move(type_in)) {}

ContentIconDefinition::~ContentIconDefinition() = default;

void ContentIconDefinition::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("src", this->src.Utf8());
  value->SetString("sizes", this->sizes.Utf8());
  value->SetString("type", this->type.Utf8());
}

bool ContentIconDefinition::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ContentDescription::ContentDescription()
    : id(),
      title(),
      description(),
      category(),
      icons(),
      launch_url() {}

ContentDescription::ContentDescription(
    const WTF::String& id_in,
    const WTF::String& title_in,
    const WTF::String& description_in,
    ContentCategory category_in,
    WTF::Vector<ContentIconDefinitionPtr> icons_in,
    const WTF::String& launch_url_in)
    : id(std::move(id_in)),
      title(std::move(title_in)),
      description(std::move(description_in)),
      category(std::move(category_in)),
      icons(std::move(icons_in)),
      launch_url(std::move(launch_url_in)) {}

ContentDescription::~ContentDescription() = default;

void ContentDescription::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("id", this->id.Utf8());
  value->SetString("title", this->title.Utf8());
  value->SetString("description", this->description.Utf8());
  value->SetString("category", base::trace_event::ValueToString(this->category));
  value->BeginArray("icons");
  for (const auto& item0 : this->icons) {
    if (item0.is_null()) {
      value->AppendString("nullptr");
    } else {
      value->BeginDictionary();
      item0->AsValueInto(value);
      value->EndDictionary();
    }
  }
  value->EndArray();
  value->SetString("launch_url", this->launch_url.Utf8());
}

bool ContentDescription::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char ContentIndexService::Name_[] = "blink.mojom.ContentIndexService";
constexpr int32_t ContentIndexService::kMaxIconResolution;

class ContentIndexService_GetIconSizes_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ContentIndexService_GetIconSizes_ForwardToCallback(
      ContentIndexService::GetIconSizesCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ContentIndexService::GetIconSizesCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ContentIndexService_GetIconSizes_ForwardToCallback);
};

class ContentIndexService_Add_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ContentIndexService_Add_ForwardToCallback(
      ContentIndexService::AddCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ContentIndexService::AddCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ContentIndexService_Add_ForwardToCallback);
};

class ContentIndexService_Delete_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ContentIndexService_Delete_ForwardToCallback(
      ContentIndexService::DeleteCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ContentIndexService::DeleteCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ContentIndexService_Delete_ForwardToCallback);
};

class ContentIndexService_GetDescriptions_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ContentIndexService_GetDescriptions_ForwardToCallback(
      ContentIndexService::GetDescriptionsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ContentIndexService::GetDescriptionsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ContentIndexService_GetDescriptions_ForwardToCallback);
};

ContentIndexServiceProxy::ContentIndexServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ContentIndexServiceProxy::GetIconSizes(
    ContentCategory in_category, GetIconSizesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ContentIndexService::GetIconSizes", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("category", base::trace_event::ValueToString(in_category));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kContentIndexService_GetIconSizes_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::ContentIndexService_GetIconSizes_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::ContentCategory>(
      in_category, &params->category);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentIndexService::Name_);
  message.set_method_name("GetIconSizes");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ContentIndexService_GetIconSizes_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ContentIndexServiceProxy::Add(
    int64_t in_service_worker_registration_id, ContentDescriptionPtr in_description, const WTF::Vector<::SkBitmap>& in_icon, const ::blink::KURL& in_launchUrl, AddCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ContentIndexService::Add", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("service_worker_registration_id", base::NumberToString(in_service_worker_registration_id));
      if (in_description.is_null()) {
        raw_value->SetString("description", "nullptr");
      } else {
        raw_value->BeginDictionary("description");
        in_description->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      raw_value->BeginArray("icon");
      for (const auto& item0 : in_icon) {
        raw_value->AppendString(base::trace_event::ValueToString(item0, "<value of type const ::SkBitmap&>"));
      }
      raw_value->EndArray();
      raw_value->SetString("launchUrl", base::trace_event::ValueToString(in_launchUrl, "<value of type const ::blink::KURL&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kContentIndexService_Add_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::ContentIndexService_Add_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->service_worker_registration_id = in_service_worker_registration_id;
  typename decltype(params->description)::BaseType::BufferWriter
      description_writer;
  mojo::internal::Serialize<::blink::mojom::ContentDescriptionDataView>(
      in_description, buffer, &description_writer, &serialization_context);
  params->description.Set(
      description_writer.is_null() ? nullptr : description_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->description.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null description in ContentIndexService.Add request");
  typename decltype(params->icon)::BaseType::BufferWriter
      icon_writer;
  const mojo::internal::ContainerValidateParams icon_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::skia::mojom::BitmapDataView>>(
      in_icon, buffer, &icon_writer, &icon_validate_params,
      &serialization_context);
  params->icon.Set(
      icon_writer.is_null() ? nullptr : icon_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->icon.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null icon in ContentIndexService.Add request");
  typename decltype(params->launchUrl)::BaseType::BufferWriter
      launchUrl_writer;
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_launchUrl, buffer, &launchUrl_writer, &serialization_context);
  params->launchUrl.Set(
      launchUrl_writer.is_null() ? nullptr : launchUrl_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->launchUrl.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null launchUrl in ContentIndexService.Add request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentIndexService::Name_);
  message.set_method_name("Add");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ContentIndexService_Add_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ContentIndexServiceProxy::Delete(
    int64_t in_service_worker_registration_id, const WTF::String& in_id, DeleteCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ContentIndexService::Delete", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("service_worker_registration_id", base::NumberToString(in_service_worker_registration_id));
      raw_value->SetString("id", in_id.Utf8());
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kContentIndexService_Delete_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::ContentIndexService_Delete_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->service_worker_registration_id = in_service_worker_registration_id;
  typename decltype(params->id)::BaseType::BufferWriter
      id_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_id, buffer, &id_writer, &serialization_context);
  params->id.Set(
      id_writer.is_null() ? nullptr : id_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in ContentIndexService.Delete request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentIndexService::Name_);
  message.set_method_name("Delete");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ContentIndexService_Delete_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ContentIndexServiceProxy::GetDescriptions(
    int64_t in_service_worker_registration_id, GetDescriptionsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ContentIndexService::GetDescriptions", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("service_worker_registration_id", base::NumberToString(in_service_worker_registration_id));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kContentIndexService_GetDescriptions_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::ContentIndexService_GetDescriptions_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->service_worker_registration_id = in_service_worker_registration_id;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentIndexService::Name_);
  message.set_method_name("GetDescriptions");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ContentIndexService_GetDescriptions_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class ContentIndexService_GetIconSizes_ProxyToResponder {
 public:
  static ContentIndexService::GetIconSizesCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ContentIndexService_GetIconSizes_ProxyToResponder> proxy(
        new ContentIndexService_GetIconSizes_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ContentIndexService_GetIconSizes_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ContentIndexService_GetIconSizes_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ContentIndexService_GetIconSizes_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ContentIndexService::GetIconSizesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const WTF::Vector<::gfx::Size>& in_icon_sizes);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ContentIndexService_GetIconSizes_ProxyToResponder);
};

bool ContentIndexService_GetIconSizes_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ContentIndexService::GetIconSizesCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::ContentIndexService_GetIconSizes_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ContentIndexService_GetIconSizes_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  WTF::Vector<::gfx::Size> p_icon_sizes{};
  ContentIndexService_GetIconSizes_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadIconSizes(&p_icon_sizes))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ContentIndexService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_icon_sizes));
  return true;
}

void ContentIndexService_GetIconSizes_ProxyToResponder::Run(
    const WTF::Vector<::gfx::Size>& in_icon_sizes) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::ContentIndexService::GetIconSizesCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->BeginArray("icon_sizes");
      for (const auto& item0 : in_icon_sizes) {
        raw_value->AppendString(base::trace_event::ValueToString(item0, "<value of type const ::gfx::Size&>"));
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kContentIndexService_GetIconSizes_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::ContentIndexService_GetIconSizes_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->icon_sizes)::BaseType::BufferWriter
      icon_sizes_writer;
  const mojo::internal::ContainerValidateParams icon_sizes_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::SizeDataView>>(
      in_icon_sizes, buffer, &icon_sizes_writer, &icon_sizes_validate_params,
      &serialization_context);
  params->icon_sizes.Set(
      icon_sizes_writer.is_null() ? nullptr : icon_sizes_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->icon_sizes.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null icon_sizes in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ContentIndexService::GetIconSizesCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentIndexService::Name_);
  message.set_method_name("GetIconSizes");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ContentIndexService_Add_ProxyToResponder {
 public:
  static ContentIndexService::AddCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ContentIndexService_Add_ProxyToResponder> proxy(
        new ContentIndexService_Add_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ContentIndexService_Add_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ContentIndexService_Add_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ContentIndexService_Add_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ContentIndexService::AddCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ContentIndexError in_error);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ContentIndexService_Add_ProxyToResponder);
};

bool ContentIndexService_Add_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ContentIndexService::AddCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::ContentIndexService_Add_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ContentIndexService_Add_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ContentIndexError p_error{};
  ContentIndexService_Add_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ContentIndexService::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error));
  return true;
}

void ContentIndexService_Add_ProxyToResponder::Run(
    ContentIndexError in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::ContentIndexService::AddCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("error", base::trace_event::ValueToString(in_error));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kContentIndexService_Add_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::ContentIndexService_Add_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::ContentIndexError>(
      in_error, &params->error);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ContentIndexService::AddCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentIndexService::Name_);
  message.set_method_name("Add");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ContentIndexService_Delete_ProxyToResponder {
 public:
  static ContentIndexService::DeleteCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ContentIndexService_Delete_ProxyToResponder> proxy(
        new ContentIndexService_Delete_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ContentIndexService_Delete_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ContentIndexService_Delete_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ContentIndexService_Delete_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ContentIndexService::DeleteCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ContentIndexError in_error);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ContentIndexService_Delete_ProxyToResponder);
};

bool ContentIndexService_Delete_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ContentIndexService::DeleteCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::ContentIndexService_Delete_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ContentIndexService_Delete_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ContentIndexError p_error{};
  ContentIndexService_Delete_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ContentIndexService::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error));
  return true;
}

void ContentIndexService_Delete_ProxyToResponder::Run(
    ContentIndexError in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::ContentIndexService::DeleteCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("error", base::trace_event::ValueToString(in_error));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kContentIndexService_Delete_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::ContentIndexService_Delete_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::ContentIndexError>(
      in_error, &params->error);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ContentIndexService::DeleteCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentIndexService::Name_);
  message.set_method_name("Delete");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ContentIndexService_GetDescriptions_ProxyToResponder {
 public:
  static ContentIndexService::GetDescriptionsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ContentIndexService_GetDescriptions_ProxyToResponder> proxy(
        new ContentIndexService_GetDescriptions_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ContentIndexService_GetDescriptions_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ContentIndexService_GetDescriptions_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ContentIndexService_GetDescriptions_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ContentIndexService::GetDescriptionsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ContentIndexError in_error, WTF::Vector<ContentDescriptionPtr> in_descriptions);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ContentIndexService_GetDescriptions_ProxyToResponder);
};

bool ContentIndexService_GetDescriptions_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ContentIndexService::GetDescriptionsCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::ContentIndexService_GetDescriptions_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ContentIndexService_GetDescriptions_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ContentIndexError p_error{};
  WTF::Vector<ContentDescriptionPtr> p_descriptions{};
  ContentIndexService_GetDescriptions_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success && !input_data_view.ReadDescriptions(&p_descriptions))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ContentIndexService::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error), 
std::move(p_descriptions));
  return true;
}

void ContentIndexService_GetDescriptions_ProxyToResponder::Run(
    ContentIndexError in_error, WTF::Vector<ContentDescriptionPtr> in_descriptions) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::ContentIndexService::GetDescriptionsCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("error", base::trace_event::ValueToString(in_error));
      raw_value->BeginArray("descriptions");
      for (const auto& item0 : in_descriptions) {
        if (item0.is_null()) {
          raw_value->AppendString("nullptr");
        } else {
          raw_value->BeginDictionary();
          item0->AsValueInto(raw_value);
          raw_value->EndDictionary();
        }
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kContentIndexService_GetDescriptions_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::ContentIndexService_GetDescriptions_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::ContentIndexError>(
      in_error, &params->error);
  typename decltype(params->descriptions)::BaseType::BufferWriter
      descriptions_writer;
  const mojo::internal::ContainerValidateParams descriptions_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ContentDescriptionDataView>>(
      in_descriptions, buffer, &descriptions_writer, &descriptions_validate_params,
      &serialization_context);
  params->descriptions.Set(
      descriptions_writer.is_null() ? nullptr : descriptions_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->descriptions.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null descriptions in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ContentIndexService::GetDescriptionsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentIndexService::Name_);
  message.set_method_name("GetDescriptions");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ContentIndexServiceStubDispatch::Accept(
    ContentIndexService* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kContentIndexService_GetIconSizes_Name: {
      break;
    }
    case internal::kContentIndexService_Add_Name: {
      break;
    }
    case internal::kContentIndexService_Delete_Name: {
      break;
    }
    case internal::kContentIndexService_GetDescriptions_Name: {
      break;
    }
  }
  return false;
}

// static
bool ContentIndexServiceStubDispatch::AcceptWithResponder(
    ContentIndexService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kContentIndexService_GetIconSizes_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ContentIndexService::GetIconSizes",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ContentIndexService::GetIconSizes");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ContentIndexService_GetIconSizes_Params_Data* params =
          reinterpret_cast<
              internal::ContentIndexService_GetIconSizes_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ContentCategory p_category{};
      ContentIndexService_GetIconSizes_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadCategory(&p_category))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ContentIndexService::Name_, 0, false);
        return false;
      }
      ContentIndexService::GetIconSizesCallback callback =
          ContentIndexService_GetIconSizes_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetIconSizes(
std::move(p_category), std::move(callback));
      return true;
    }
    case internal::kContentIndexService_Add_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ContentIndexService::Add",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ContentIndexService::Add");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ContentIndexService_Add_Params_Data* params =
          reinterpret_cast<
              internal::ContentIndexService_Add_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int64_t p_service_worker_registration_id{};
      ContentDescriptionPtr p_description{};
      WTF::Vector<::SkBitmap> p_icon{};
      ::blink::KURL p_launchUrl{};
      ContentIndexService_Add_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_service_worker_registration_id = input_data_view.service_worker_registration_id();
      if (success && !input_data_view.ReadDescription(&p_description))
        success = false;
      if (success && !input_data_view.ReadIcon(&p_icon))
        success = false;
      if (success && !input_data_view.ReadLaunchUrl(&p_launchUrl))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ContentIndexService::Name_, 1, false);
        return false;
      }
      ContentIndexService::AddCallback callback =
          ContentIndexService_Add_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Add(
std::move(p_service_worker_registration_id), 
std::move(p_description), 
std::move(p_icon), 
std::move(p_launchUrl), std::move(callback));
      return true;
    }
    case internal::kContentIndexService_Delete_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ContentIndexService::Delete",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ContentIndexService::Delete");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ContentIndexService_Delete_Params_Data* params =
          reinterpret_cast<
              internal::ContentIndexService_Delete_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int64_t p_service_worker_registration_id{};
      WTF::String p_id{};
      ContentIndexService_Delete_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_service_worker_registration_id = input_data_view.service_worker_registration_id();
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ContentIndexService::Name_, 2, false);
        return false;
      }
      ContentIndexService::DeleteCallback callback =
          ContentIndexService_Delete_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Delete(
std::move(p_service_worker_registration_id), 
std::move(p_id), std::move(callback));
      return true;
    }
    case internal::kContentIndexService_GetDescriptions_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ContentIndexService::GetDescriptions",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ContentIndexService::GetDescriptions");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ContentIndexService_GetDescriptions_Params_Data* params =
          reinterpret_cast<
              internal::ContentIndexService_GetDescriptions_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int64_t p_service_worker_registration_id{};
      ContentIndexService_GetDescriptions_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_service_worker_registration_id = input_data_view.service_worker_registration_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ContentIndexService::Name_, 3, false);
        return false;
      }
      ContentIndexService::GetDescriptionsCallback callback =
          ContentIndexService_GetDescriptions_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDescriptions(
std::move(p_service_worker_registration_id), std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kContentIndexServiceValidationInfo[] = {
    {&internal::ContentIndexService_GetIconSizes_Params_Data::Validate,
     &internal::ContentIndexService_GetIconSizes_ResponseParams_Data::Validate},
    {&internal::ContentIndexService_Add_Params_Data::Validate,
     &internal::ContentIndexService_Add_ResponseParams_Data::Validate},
    {&internal::ContentIndexService_Delete_Params_Data::Validate,
     &internal::ContentIndexService_Delete_ResponseParams_Data::Validate},
    {&internal::ContentIndexService_GetDescriptions_Params_Data::Validate,
     &internal::ContentIndexService_GetDescriptions_ResponseParams_Data::Validate},
};

bool ContentIndexServiceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::ContentIndexService::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kContentIndexServiceValidationInfo);
}

bool ContentIndexServiceResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::ContentIndexService::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kContentIndexServiceValidationInfo);
}
}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::ContentIconDefinition::DataView, ::blink::mojom::blink::ContentIconDefinitionPtr>::Read(
    ::blink::mojom::blink::ContentIconDefinition::DataView input,
    ::blink::mojom::blink::ContentIconDefinitionPtr* output) {
  bool success = true;
  ::blink::mojom::blink::ContentIconDefinitionPtr result(::blink::mojom::blink::ContentIconDefinition::New());
  
      if (success && !input.ReadSrc(&result->src))
        success = false;
      if (success && !input.ReadSizes(&result->sizes))
        success = false;
      if (success && !input.ReadType(&result->type))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::ContentDescription::DataView, ::blink::mojom::blink::ContentDescriptionPtr>::Read(
    ::blink::mojom::blink::ContentDescription::DataView input,
    ::blink::mojom::blink::ContentDescriptionPtr* output) {
  bool success = true;
  ::blink::mojom::blink::ContentDescriptionPtr result(::blink::mojom::blink::ContentDescription::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadDescription(&result->description))
        success = false;
      if (success && !input.ReadCategory(&result->category))
        success = false;
      if (success && !input.ReadIcons(&result->icons))
        success = false;
      if (success && !input.ReadLaunchUrl(&result->launch_url))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif