// third_party/blink/public/mojom/dom_storage/dom_storage.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_DOM_STORAGE_DOM_STORAGE_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_DOM_STORAGE_DOM_STORAGE_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "third_party/blink/public/mojom/dom_storage/dom_storage.mojom-shared.h"
#include "third_party/blink/public/mojom/dom_storage/dom_storage.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/dom_storage/session_storage_namespace.mojom-blink.h"
#include "third_party/blink/public/mojom/dom_storage/storage_area.mojom-blink.h"
#include "url/mojom/origin.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "third_party/blink/renderer/platform/platform_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace blink {
namespace mojom {
namespace blink {

class DomStorageProviderProxy;

template <typename ImplRefTraits>
class DomStorageProviderStub;

class DomStorageProviderRequestValidator;


class PLATFORM_EXPORT DomStorageProvider
    : public DomStorageProviderInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = DomStorageProviderInterfaceBase;
  using Proxy_ = DomStorageProviderProxy;

  template <typename ImplRefTraits>
  using Stub_ = DomStorageProviderStub<ImplRefTraits>;

  using RequestValidator_ = DomStorageProviderRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kBindDomStorageMinVersion = 0,
  };
  virtual ~DomStorageProvider() {}

  
  virtual void BindDomStorage(::mojo::PendingReceiver<DomStorage> receiver, ::mojo::PendingRemote<DomStorageClient> client) = 0;
};

class DomStorageProxy;

template <typename ImplRefTraits>
class DomStorageStub;

class DomStorageRequestValidator;


class PLATFORM_EXPORT DomStorage
    : public DomStorageInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = DomStorageInterfaceBase;
  using Proxy_ = DomStorageProxy;

  template <typename ImplRefTraits>
  using Stub_ = DomStorageStub<ImplRefTraits>;

  using RequestValidator_ = DomStorageRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOpenLocalStorageMinVersion = 0,
    kBindSessionStorageNamespaceMinVersion = 0,
    kBindSessionStorageAreaMinVersion = 0,
  };
  virtual ~DomStorage() {}

  
  virtual void OpenLocalStorage(const ::scoped_refptr<const ::blink::SecurityOrigin>& origin, ::mojo::PendingReceiver<::blink::mojom::blink::StorageArea> area) = 0;

  
  virtual void BindSessionStorageNamespace(const WTF::String& namespace_id, ::mojo::PendingReceiver<::blink::mojom::blink::SessionStorageNamespace> receiver) = 0;

  
  virtual void BindSessionStorageArea(const ::scoped_refptr<const ::blink::SecurityOrigin>& origin, const WTF::String& namespace_id, ::mojo::PendingReceiver<::blink::mojom::blink::StorageArea> session_namespace) = 0;
};

class DomStorageClientProxy;

template <typename ImplRefTraits>
class DomStorageClientStub;

class DomStorageClientRequestValidator;


class PLATFORM_EXPORT DomStorageClient
    : public DomStorageClientInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = DomStorageClientInterfaceBase;
  using Proxy_ = DomStorageClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = DomStorageClientStub<ImplRefTraits>;

  using RequestValidator_ = DomStorageClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kResetStorageAreaAndNamespaceConnectionsMinVersion = 0,
  };
  virtual ~DomStorageClient() {}

  
  virtual void ResetStorageAreaAndNamespaceConnections() = 0;
};



class PLATFORM_EXPORT DomStorageProviderProxy
    : public DomStorageProvider {
 public:
  using InterfaceType = DomStorageProvider;

  explicit DomStorageProviderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void BindDomStorage(::mojo::PendingReceiver<DomStorage> receiver, ::mojo::PendingRemote<DomStorageClient> client) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class PLATFORM_EXPORT DomStorageProxy
    : public DomStorage {
 public:
  using InterfaceType = DomStorage;

  explicit DomStorageProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OpenLocalStorage(const ::scoped_refptr<const ::blink::SecurityOrigin>& origin, ::mojo::PendingReceiver<::blink::mojom::blink::StorageArea> area) final;
  
  void BindSessionStorageNamespace(const WTF::String& namespace_id, ::mojo::PendingReceiver<::blink::mojom::blink::SessionStorageNamespace> receiver) final;
  
  void BindSessionStorageArea(const ::scoped_refptr<const ::blink::SecurityOrigin>& origin, const WTF::String& namespace_id, ::mojo::PendingReceiver<::blink::mojom::blink::StorageArea> session_namespace) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class PLATFORM_EXPORT DomStorageClientProxy
    : public DomStorageClient {
 public:
  using InterfaceType = DomStorageClient;

  explicit DomStorageClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ResetStorageAreaAndNamespaceConnections() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT DomStorageProviderStubDispatch {
 public:
  static bool Accept(DomStorageProvider* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DomStorageProvider* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DomStorageProvider>>
class DomStorageProviderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DomStorageProviderStub() {}
  ~DomStorageProviderStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DomStorageProviderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DomStorageProviderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT DomStorageStubDispatch {
 public:
  static bool Accept(DomStorage* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DomStorage* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DomStorage>>
class DomStorageStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DomStorageStub() {}
  ~DomStorageStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DomStorageStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DomStorageStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT DomStorageClientStubDispatch {
 public:
  static bool Accept(DomStorageClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DomStorageClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DomStorageClient>>
class DomStorageClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DomStorageClientStub() {}
  ~DomStorageClientStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DomStorageClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DomStorageClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT DomStorageProviderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT DomStorageRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT DomStorageClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_DOM_STORAGE_DOM_STORAGE_MOJOM_BLINK_H_