// third_party/blink/public/mojom/file_system_access/native_file_system_directory_handle.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/file_system_access/native_file_system_directory_handle.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/file_system_access/native_file_system_directory_handle.mojom-params-data.h"
#include "third_party/blink/public/mojom/file_system_access/native_file_system_directory_handle.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/file_system_access/native_file_system_directory_handle.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_NATIVE_FILE_SYSTEM_DIRECTORY_HANDLE_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_NATIVE_FILE_SYSTEM_DIRECTORY_HANDLE_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
NativeFileSystemEntry::NativeFileSystemEntry()
    : entry_handle(),
      name() {}

NativeFileSystemEntry::NativeFileSystemEntry(
    NativeFileSystemHandlePtr entry_handle_in,
    const std::string& name_in)
    : entry_handle(std::move(entry_handle_in)),
      name(std::move(name_in)) {}

NativeFileSystemEntry::~NativeFileSystemEntry() = default;

void NativeFileSystemEntry::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("entry_handle", base::trace_event::ValueToString(this->entry_handle, "<value of type NativeFileSystemHandlePtr>"));
  value->SetString("name", this->name);
}

bool NativeFileSystemEntry::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
NativeFileSystemHandle::NativeFileSystemHandle() : tag_(Tag::FILE) {
  data_.file = new ::mojo::PendingRemote<::blink::mojom::NativeFileSystemFileHandle>;
}

NativeFileSystemHandle::~NativeFileSystemHandle() {
  DestroyActive();
}


void NativeFileSystemHandle::set_file(
    ::mojo::PendingRemote<::blink::mojom::NativeFileSystemFileHandle> file) {
  if (tag_ == Tag::FILE) {
    *(data_.file) = std::move(file);
  } else {
    DestroyActive();
    tag_ = Tag::FILE;
    data_.file = new ::mojo::PendingRemote<::blink::mojom::NativeFileSystemFileHandle>(
        std::move(file));
  }
}
void NativeFileSystemHandle::set_directory(
    ::mojo::PendingRemote<NativeFileSystemDirectoryHandle> directory) {
  if (tag_ == Tag::DIRECTORY) {
    *(data_.directory) = std::move(directory);
  } else {
    DestroyActive();
    tag_ = Tag::DIRECTORY;
    data_.directory = new ::mojo::PendingRemote<NativeFileSystemDirectoryHandle>(
        std::move(directory));
  }
}

void NativeFileSystemHandle::DestroyActive() {
  switch (tag_) {

    case Tag::FILE:

      delete data_.file;
      break;
    case Tag::DIRECTORY:

      delete data_.directory;
      break;
  }
}

bool NativeFileSystemHandle::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
const char NativeFileSystemDirectoryEntriesListener::Name_[] = "blink.mojom.NativeFileSystemDirectoryEntriesListener";

NativeFileSystemDirectoryEntriesListenerProxy::NativeFileSystemDirectoryEntriesListenerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NativeFileSystemDirectoryEntriesListenerProxy::DidReadDirectory(
    ::blink::mojom::NativeFileSystemErrorPtr in_result, std::vector<NativeFileSystemEntryPtr> in_entries, bool in_has_more_entries) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::NativeFileSystemDirectoryEntriesListener::DidReadDirectory", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_result.is_null()) {
        raw_value->SetString("result", "nullptr");
      } else {
        raw_value->BeginDictionary("result");
        in_result->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      raw_value->BeginArray("entries");
      for (const auto& item0 : in_entries) {
        if (item0.is_null()) {
          raw_value->AppendString("nullptr");
        } else {
          raw_value->BeginDictionary();
          item0->AsValueInto(raw_value);
          raw_value->EndDictionary();
        }
      }
      raw_value->EndArray();
      raw_value->SetBoolean("has_more_entries", in_has_more_entries);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeFileSystemDirectoryEntriesListener_DidReadDirectory_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeFileSystemDirectoryEntriesListener_DidReadDirectory_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->result)::BaseType::BufferWriter
      result_writer;
  mojo::internal::Serialize<::blink::mojom::NativeFileSystemErrorDataView>(
      in_result, buffer, &result_writer, &serialization_context);
  params->result.Set(
      result_writer.is_null() ? nullptr : result_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in NativeFileSystemDirectoryEntriesListener.DidReadDirectory request");
  typename decltype(params->entries)::BaseType::BufferWriter
      entries_writer;
  const mojo::internal::ContainerValidateParams entries_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::NativeFileSystemEntryDataView>>(
      in_entries, buffer, &entries_writer, &entries_validate_params,
      &serialization_context);
  params->entries.Set(
      entries_writer.is_null() ? nullptr : entries_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->entries.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null entries in NativeFileSystemDirectoryEntriesListener.DidReadDirectory request");
  params->has_more_entries = in_has_more_entries;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeFileSystemDirectoryEntriesListener::Name_);
  message.set_method_name("DidReadDirectory");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool NativeFileSystemDirectoryEntriesListenerStubDispatch::Accept(
    NativeFileSystemDirectoryEntriesListener* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kNativeFileSystemDirectoryEntriesListener_DidReadDirectory_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::NativeFileSystemDirectoryEntriesListener::DidReadDirectory",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::NativeFileSystemDirectoryEntriesListener::DidReadDirectory");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NativeFileSystemDirectoryEntriesListener_DidReadDirectory_Params_Data* params =
          reinterpret_cast<internal::NativeFileSystemDirectoryEntriesListener_DidReadDirectory_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::NativeFileSystemErrorPtr p_result{};
      std::vector<NativeFileSystemEntryPtr> p_entries{};
      bool p_has_more_entries{};
      NativeFileSystemDirectoryEntriesListener_DidReadDirectory_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadResult(&p_result))
        success = false;
      if (success && !input_data_view.ReadEntries(&p_entries))
        success = false;
      if (success)
        p_has_more_entries = input_data_view.has_more_entries();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeFileSystemDirectoryEntriesListener::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidReadDirectory(
std::move(p_result), 
std::move(p_entries), 
std::move(p_has_more_entries));
      return true;
    }
  }
  return false;
}

// static
bool NativeFileSystemDirectoryEntriesListenerStubDispatch::AcceptWithResponder(
    NativeFileSystemDirectoryEntriesListener* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kNativeFileSystemDirectoryEntriesListener_DidReadDirectory_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kNativeFileSystemDirectoryEntriesListenerValidationInfo[] = {
    {&internal::NativeFileSystemDirectoryEntriesListener_DidReadDirectory_Params_Data::Validate,
     nullptr /* no response */},
};

bool NativeFileSystemDirectoryEntriesListenerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::NativeFileSystemDirectoryEntriesListener::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kNativeFileSystemDirectoryEntriesListenerValidationInfo);
}

const char NativeFileSystemDirectoryHandle::Name_[] = "blink.mojom.NativeFileSystemDirectoryHandle";

class NativeFileSystemDirectoryHandle_GetPermissionStatus_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NativeFileSystemDirectoryHandle_GetPermissionStatus_ForwardToCallback(
      NativeFileSystemDirectoryHandle::GetPermissionStatusCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NativeFileSystemDirectoryHandle::GetPermissionStatusCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NativeFileSystemDirectoryHandle_GetPermissionStatus_ForwardToCallback);
};

class NativeFileSystemDirectoryHandle_RequestPermission_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NativeFileSystemDirectoryHandle_RequestPermission_ForwardToCallback(
      NativeFileSystemDirectoryHandle::RequestPermissionCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NativeFileSystemDirectoryHandle::RequestPermissionCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NativeFileSystemDirectoryHandle_RequestPermission_ForwardToCallback);
};

class NativeFileSystemDirectoryHandle_GetFile_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NativeFileSystemDirectoryHandle_GetFile_ForwardToCallback(
      NativeFileSystemDirectoryHandle::GetFileCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NativeFileSystemDirectoryHandle::GetFileCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NativeFileSystemDirectoryHandle_GetFile_ForwardToCallback);
};

class NativeFileSystemDirectoryHandle_GetDirectory_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NativeFileSystemDirectoryHandle_GetDirectory_ForwardToCallback(
      NativeFileSystemDirectoryHandle::GetDirectoryCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NativeFileSystemDirectoryHandle::GetDirectoryCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NativeFileSystemDirectoryHandle_GetDirectory_ForwardToCallback);
};

class NativeFileSystemDirectoryHandle_RemoveEntry_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NativeFileSystemDirectoryHandle_RemoveEntry_ForwardToCallback(
      NativeFileSystemDirectoryHandle::RemoveEntryCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NativeFileSystemDirectoryHandle::RemoveEntryCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NativeFileSystemDirectoryHandle_RemoveEntry_ForwardToCallback);
};

class NativeFileSystemDirectoryHandle_Resolve_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NativeFileSystemDirectoryHandle_Resolve_ForwardToCallback(
      NativeFileSystemDirectoryHandle::ResolveCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NativeFileSystemDirectoryHandle::ResolveCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NativeFileSystemDirectoryHandle_Resolve_ForwardToCallback);
};

NativeFileSystemDirectoryHandleProxy::NativeFileSystemDirectoryHandleProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NativeFileSystemDirectoryHandleProxy::GetPermissionStatus(
    bool in_writable, GetPermissionStatusCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::NativeFileSystemDirectoryHandle::GetPermissionStatus", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("writable", in_writable);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeFileSystemDirectoryHandle_GetPermissionStatus_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeFileSystemDirectoryHandle_GetPermissionStatus_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->writable = in_writable;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeFileSystemDirectoryHandle::Name_);
  message.set_method_name("GetPermissionStatus");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NativeFileSystemDirectoryHandle_GetPermissionStatus_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NativeFileSystemDirectoryHandleProxy::RequestPermission(
    bool in_writable, RequestPermissionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::NativeFileSystemDirectoryHandle::RequestPermission", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("writable", in_writable);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeFileSystemDirectoryHandle_RequestPermission_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeFileSystemDirectoryHandle_RequestPermission_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->writable = in_writable;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeFileSystemDirectoryHandle::Name_);
  message.set_method_name("RequestPermission");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NativeFileSystemDirectoryHandle_RequestPermission_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NativeFileSystemDirectoryHandleProxy::GetFile(
    const std::string& in_basename, bool in_create, GetFileCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::NativeFileSystemDirectoryHandle::GetFile", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("basename", in_basename);
      raw_value->SetBoolean("create", in_create);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeFileSystemDirectoryHandle_GetFile_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeFileSystemDirectoryHandle_GetFile_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->basename)::BaseType::BufferWriter
      basename_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_basename, buffer, &basename_writer, &serialization_context);
  params->basename.Set(
      basename_writer.is_null() ? nullptr : basename_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->basename.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null basename in NativeFileSystemDirectoryHandle.GetFile request");
  params->create = in_create;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeFileSystemDirectoryHandle::Name_);
  message.set_method_name("GetFile");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NativeFileSystemDirectoryHandle_GetFile_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NativeFileSystemDirectoryHandleProxy::GetDirectory(
    const std::string& in_basename, bool in_create, GetDirectoryCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::NativeFileSystemDirectoryHandle::GetDirectory", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("basename", in_basename);
      raw_value->SetBoolean("create", in_create);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeFileSystemDirectoryHandle_GetDirectory_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeFileSystemDirectoryHandle_GetDirectory_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->basename)::BaseType::BufferWriter
      basename_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_basename, buffer, &basename_writer, &serialization_context);
  params->basename.Set(
      basename_writer.is_null() ? nullptr : basename_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->basename.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null basename in NativeFileSystemDirectoryHandle.GetDirectory request");
  params->create = in_create;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeFileSystemDirectoryHandle::Name_);
  message.set_method_name("GetDirectory");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NativeFileSystemDirectoryHandle_GetDirectory_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NativeFileSystemDirectoryHandleProxy::GetEntries(
    ::mojo::PendingRemote<NativeFileSystemDirectoryEntriesListener> in_listener) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::NativeFileSystemDirectoryHandle::GetEntries", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("listener", in_listener.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeFileSystemDirectoryHandle_GetEntries_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeFileSystemDirectoryHandle_GetEntries_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::NativeFileSystemDirectoryEntriesListenerInterfaceBase>>(
      in_listener, &params->listener, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->listener),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid listener in NativeFileSystemDirectoryHandle.GetEntries request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeFileSystemDirectoryHandle::Name_);
  message.set_method_name("GetEntries");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NativeFileSystemDirectoryHandleProxy::RemoveEntry(
    const std::string& in_basename, bool in_recurse, RemoveEntryCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::NativeFileSystemDirectoryHandle::RemoveEntry", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("basename", in_basename);
      raw_value->SetBoolean("recurse", in_recurse);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeFileSystemDirectoryHandle_RemoveEntry_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeFileSystemDirectoryHandle_RemoveEntry_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->basename)::BaseType::BufferWriter
      basename_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_basename, buffer, &basename_writer, &serialization_context);
  params->basename.Set(
      basename_writer.is_null() ? nullptr : basename_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->basename.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null basename in NativeFileSystemDirectoryHandle.RemoveEntry request");
  params->recurse = in_recurse;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeFileSystemDirectoryHandle::Name_);
  message.set_method_name("RemoveEntry");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NativeFileSystemDirectoryHandle_RemoveEntry_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NativeFileSystemDirectoryHandleProxy::Resolve(
    ::mojo::PendingRemote<::blink::mojom::NativeFileSystemTransferToken> in_possible_child, ResolveCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::NativeFileSystemDirectoryHandle::Resolve", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("possible_child", in_possible_child.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeFileSystemDirectoryHandle_Resolve_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeFileSystemDirectoryHandle_Resolve_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::NativeFileSystemTransferTokenInterfaceBase>>(
      in_possible_child, &params->possible_child, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->possible_child),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid possible_child in NativeFileSystemDirectoryHandle.Resolve request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeFileSystemDirectoryHandle::Name_);
  message.set_method_name("Resolve");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NativeFileSystemDirectoryHandle_Resolve_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NativeFileSystemDirectoryHandleProxy::Transfer(
    ::mojo::PendingReceiver<::blink::mojom::NativeFileSystemTransferToken> in_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::NativeFileSystemDirectoryHandle::Transfer", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("token", in_token.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeFileSystemDirectoryHandle_Transfer_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeFileSystemDirectoryHandle_Transfer_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::NativeFileSystemTransferTokenInterfaceBase>>(
      in_token, &params->token, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->token),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid token in NativeFileSystemDirectoryHandle.Transfer request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeFileSystemDirectoryHandle::Name_);
  message.set_method_name("Transfer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class NativeFileSystemDirectoryHandle_GetPermissionStatus_ProxyToResponder {
 public:
  static NativeFileSystemDirectoryHandle::GetPermissionStatusCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NativeFileSystemDirectoryHandle_GetPermissionStatus_ProxyToResponder> proxy(
        new NativeFileSystemDirectoryHandle_GetPermissionStatus_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NativeFileSystemDirectoryHandle_GetPermissionStatus_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NativeFileSystemDirectoryHandle_GetPermissionStatus_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NativeFileSystemDirectoryHandle_GetPermissionStatus_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NativeFileSystemDirectoryHandle::GetPermissionStatusCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::PermissionStatus in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NativeFileSystemDirectoryHandle_GetPermissionStatus_ProxyToResponder);
};

bool NativeFileSystemDirectoryHandle_GetPermissionStatus_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::NativeFileSystemDirectoryHandle::GetPermissionStatusCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NativeFileSystemDirectoryHandle_GetPermissionStatus_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NativeFileSystemDirectoryHandle_GetPermissionStatus_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::blink::mojom::PermissionStatus p_status{};
  NativeFileSystemDirectoryHandle_GetPermissionStatus_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NativeFileSystemDirectoryHandle::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void NativeFileSystemDirectoryHandle_GetPermissionStatus_ProxyToResponder::Run(
    ::blink::mojom::PermissionStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::NativeFileSystemDirectoryHandle::GetPermissionStatusCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("status", base::trace_event::ValueToString(in_status));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeFileSystemDirectoryHandle_GetPermissionStatus_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeFileSystemDirectoryHandle_GetPermissionStatus_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::PermissionStatus>(
      in_status, &params->status);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::NativeFileSystemDirectoryHandle::GetPermissionStatusCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeFileSystemDirectoryHandle::Name_);
  message.set_method_name("GetPermissionStatus");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NativeFileSystemDirectoryHandle_RequestPermission_ProxyToResponder {
 public:
  static NativeFileSystemDirectoryHandle::RequestPermissionCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NativeFileSystemDirectoryHandle_RequestPermission_ProxyToResponder> proxy(
        new NativeFileSystemDirectoryHandle_RequestPermission_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NativeFileSystemDirectoryHandle_RequestPermission_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NativeFileSystemDirectoryHandle_RequestPermission_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NativeFileSystemDirectoryHandle_RequestPermission_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NativeFileSystemDirectoryHandle::RequestPermissionCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::NativeFileSystemErrorPtr in_result, ::blink::mojom::PermissionStatus in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NativeFileSystemDirectoryHandle_RequestPermission_ProxyToResponder);
};

bool NativeFileSystemDirectoryHandle_RequestPermission_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::NativeFileSystemDirectoryHandle::RequestPermissionCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NativeFileSystemDirectoryHandle_RequestPermission_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NativeFileSystemDirectoryHandle_RequestPermission_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::blink::mojom::NativeFileSystemErrorPtr p_result{};
  ::blink::mojom::PermissionStatus p_status{};
  NativeFileSystemDirectoryHandle_RequestPermission_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NativeFileSystemDirectoryHandle::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_status));
  return true;
}

void NativeFileSystemDirectoryHandle_RequestPermission_ProxyToResponder::Run(
    ::blink::mojom::NativeFileSystemErrorPtr in_result, ::blink::mojom::PermissionStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::NativeFileSystemDirectoryHandle::RequestPermissionCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_result.is_null()) {
        raw_value->SetString("result", "nullptr");
      } else {
        raw_value->BeginDictionary("result");
        in_result->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      raw_value->SetString("status", base::trace_event::ValueToString(in_status));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeFileSystemDirectoryHandle_RequestPermission_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeFileSystemDirectoryHandle_RequestPermission_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->result)::BaseType::BufferWriter
      result_writer;
  mojo::internal::Serialize<::blink::mojom::NativeFileSystemErrorDataView>(
      in_result, buffer, &result_writer, &serialization_context);
  params->result.Set(
      result_writer.is_null() ? nullptr : result_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");
  mojo::internal::Serialize<::blink::mojom::PermissionStatus>(
      in_status, &params->status);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::NativeFileSystemDirectoryHandle::RequestPermissionCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeFileSystemDirectoryHandle::Name_);
  message.set_method_name("RequestPermission");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NativeFileSystemDirectoryHandle_GetFile_ProxyToResponder {
 public:
  static NativeFileSystemDirectoryHandle::GetFileCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NativeFileSystemDirectoryHandle_GetFile_ProxyToResponder> proxy(
        new NativeFileSystemDirectoryHandle_GetFile_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NativeFileSystemDirectoryHandle_GetFile_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NativeFileSystemDirectoryHandle_GetFile_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NativeFileSystemDirectoryHandle_GetFile_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NativeFileSystemDirectoryHandle::GetFileCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::NativeFileSystemErrorPtr in_result, ::mojo::PendingRemote<::blink::mojom::NativeFileSystemFileHandle> in_file);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NativeFileSystemDirectoryHandle_GetFile_ProxyToResponder);
};

bool NativeFileSystemDirectoryHandle_GetFile_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::NativeFileSystemDirectoryHandle::GetFileCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NativeFileSystemDirectoryHandle_GetFile_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NativeFileSystemDirectoryHandle_GetFile_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::blink::mojom::NativeFileSystemErrorPtr p_result{};
  ::mojo::PendingRemote<::blink::mojom::NativeFileSystemFileHandle> p_file{};
  NativeFileSystemDirectoryHandle_GetFile_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success) {
    p_file =
        input_data_view.TakeFile<decltype(p_file)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NativeFileSystemDirectoryHandle::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_file));
  return true;
}

void NativeFileSystemDirectoryHandle_GetFile_ProxyToResponder::Run(
    ::blink::mojom::NativeFileSystemErrorPtr in_result, ::mojo::PendingRemote<::blink::mojom::NativeFileSystemFileHandle> in_file) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::NativeFileSystemDirectoryHandle::GetFileCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_result.is_null()) {
        raw_value->SetString("result", "nullptr");
      } else {
        raw_value->BeginDictionary("result");
        in_result->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      raw_value->SetBoolean("file", in_file.is_valid());
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeFileSystemDirectoryHandle_GetFile_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeFileSystemDirectoryHandle_GetFile_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->result)::BaseType::BufferWriter
      result_writer;
  mojo::internal::Serialize<::blink::mojom::NativeFileSystemErrorDataView>(
      in_result, buffer, &result_writer, &serialization_context);
  params->result.Set(
      result_writer.is_null() ? nullptr : result_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::NativeFileSystemFileHandleInterfaceBase>>(
      in_file, &params->file, &serialization_context);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::NativeFileSystemDirectoryHandle::GetFileCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeFileSystemDirectoryHandle::Name_);
  message.set_method_name("GetFile");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NativeFileSystemDirectoryHandle_GetDirectory_ProxyToResponder {
 public:
  static NativeFileSystemDirectoryHandle::GetDirectoryCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NativeFileSystemDirectoryHandle_GetDirectory_ProxyToResponder> proxy(
        new NativeFileSystemDirectoryHandle_GetDirectory_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NativeFileSystemDirectoryHandle_GetDirectory_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NativeFileSystemDirectoryHandle_GetDirectory_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NativeFileSystemDirectoryHandle_GetDirectory_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NativeFileSystemDirectoryHandle::GetDirectoryCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::NativeFileSystemErrorPtr in_result, ::mojo::PendingRemote<NativeFileSystemDirectoryHandle> in_directory);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NativeFileSystemDirectoryHandle_GetDirectory_ProxyToResponder);
};

bool NativeFileSystemDirectoryHandle_GetDirectory_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::NativeFileSystemDirectoryHandle::GetDirectoryCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NativeFileSystemDirectoryHandle_GetDirectory_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NativeFileSystemDirectoryHandle_GetDirectory_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::blink::mojom::NativeFileSystemErrorPtr p_result{};
  ::mojo::PendingRemote<NativeFileSystemDirectoryHandle> p_directory{};
  NativeFileSystemDirectoryHandle_GetDirectory_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success) {
    p_directory =
        input_data_view.TakeDirectory<decltype(p_directory)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NativeFileSystemDirectoryHandle::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_directory));
  return true;
}

void NativeFileSystemDirectoryHandle_GetDirectory_ProxyToResponder::Run(
    ::blink::mojom::NativeFileSystemErrorPtr in_result, ::mojo::PendingRemote<NativeFileSystemDirectoryHandle> in_directory) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::NativeFileSystemDirectoryHandle::GetDirectoryCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_result.is_null()) {
        raw_value->SetString("result", "nullptr");
      } else {
        raw_value->BeginDictionary("result");
        in_result->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      raw_value->SetBoolean("directory", in_directory.is_valid());
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeFileSystemDirectoryHandle_GetDirectory_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeFileSystemDirectoryHandle_GetDirectory_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->result)::BaseType::BufferWriter
      result_writer;
  mojo::internal::Serialize<::blink::mojom::NativeFileSystemErrorDataView>(
      in_result, buffer, &result_writer, &serialization_context);
  params->result.Set(
      result_writer.is_null() ? nullptr : result_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::NativeFileSystemDirectoryHandleInterfaceBase>>(
      in_directory, &params->directory, &serialization_context);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::NativeFileSystemDirectoryHandle::GetDirectoryCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeFileSystemDirectoryHandle::Name_);
  message.set_method_name("GetDirectory");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NativeFileSystemDirectoryHandle_RemoveEntry_ProxyToResponder {
 public:
  static NativeFileSystemDirectoryHandle::RemoveEntryCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NativeFileSystemDirectoryHandle_RemoveEntry_ProxyToResponder> proxy(
        new NativeFileSystemDirectoryHandle_RemoveEntry_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NativeFileSystemDirectoryHandle_RemoveEntry_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NativeFileSystemDirectoryHandle_RemoveEntry_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NativeFileSystemDirectoryHandle_RemoveEntry_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NativeFileSystemDirectoryHandle::RemoveEntryCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::NativeFileSystemErrorPtr in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NativeFileSystemDirectoryHandle_RemoveEntry_ProxyToResponder);
};

bool NativeFileSystemDirectoryHandle_RemoveEntry_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::NativeFileSystemDirectoryHandle::RemoveEntryCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NativeFileSystemDirectoryHandle_RemoveEntry_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NativeFileSystemDirectoryHandle_RemoveEntry_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::blink::mojom::NativeFileSystemErrorPtr p_result{};
  NativeFileSystemDirectoryHandle_RemoveEntry_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NativeFileSystemDirectoryHandle::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void NativeFileSystemDirectoryHandle_RemoveEntry_ProxyToResponder::Run(
    ::blink::mojom::NativeFileSystemErrorPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::NativeFileSystemDirectoryHandle::RemoveEntryCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_result.is_null()) {
        raw_value->SetString("result", "nullptr");
      } else {
        raw_value->BeginDictionary("result");
        in_result->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeFileSystemDirectoryHandle_RemoveEntry_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeFileSystemDirectoryHandle_RemoveEntry_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->result)::BaseType::BufferWriter
      result_writer;
  mojo::internal::Serialize<::blink::mojom::NativeFileSystemErrorDataView>(
      in_result, buffer, &result_writer, &serialization_context);
  params->result.Set(
      result_writer.is_null() ? nullptr : result_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::NativeFileSystemDirectoryHandle::RemoveEntryCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeFileSystemDirectoryHandle::Name_);
  message.set_method_name("RemoveEntry");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NativeFileSystemDirectoryHandle_Resolve_ProxyToResponder {
 public:
  static NativeFileSystemDirectoryHandle::ResolveCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NativeFileSystemDirectoryHandle_Resolve_ProxyToResponder> proxy(
        new NativeFileSystemDirectoryHandle_Resolve_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NativeFileSystemDirectoryHandle_Resolve_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NativeFileSystemDirectoryHandle_Resolve_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NativeFileSystemDirectoryHandle_Resolve_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NativeFileSystemDirectoryHandle::ResolveCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::NativeFileSystemErrorPtr in_result, const base::Optional<std::vector<std::string>>& in_path);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NativeFileSystemDirectoryHandle_Resolve_ProxyToResponder);
};

bool NativeFileSystemDirectoryHandle_Resolve_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::NativeFileSystemDirectoryHandle::ResolveCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NativeFileSystemDirectoryHandle_Resolve_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NativeFileSystemDirectoryHandle_Resolve_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::blink::mojom::NativeFileSystemErrorPtr p_result{};
  base::Optional<std::vector<std::string>> p_path{};
  NativeFileSystemDirectoryHandle_Resolve_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadPath(&p_path))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NativeFileSystemDirectoryHandle::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_path));
  return true;
}

void NativeFileSystemDirectoryHandle_Resolve_ProxyToResponder::Run(
    ::blink::mojom::NativeFileSystemErrorPtr in_result, const base::Optional<std::vector<std::string>>& in_path) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::NativeFileSystemDirectoryHandle::ResolveCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_result.is_null()) {
        raw_value->SetString("result", "nullptr");
      } else {
        raw_value->BeginDictionary("result");
        in_result->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      if (in_path.has_value()) {
        raw_value->BeginArray("path");
        for (const auto& item0 : in_path.value()) {
          raw_value->AppendString(item0);
        }
        raw_value->EndArray();
      } else {
        raw_value->SetString("path", "base::nullopt");
      }
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeFileSystemDirectoryHandle_Resolve_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeFileSystemDirectoryHandle_Resolve_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->result)::BaseType::BufferWriter
      result_writer;
  mojo::internal::Serialize<::blink::mojom::NativeFileSystemErrorDataView>(
      in_result, buffer, &result_writer, &serialization_context);
  params->result.Set(
      result_writer.is_null() ? nullptr : result_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");
  typename decltype(params->path)::BaseType::BufferWriter
      path_writer;
  const mojo::internal::ContainerValidateParams path_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_path, buffer, &path_writer, &path_validate_params,
      &serialization_context);
  params->path.Set(
      path_writer.is_null() ? nullptr : path_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::NativeFileSystemDirectoryHandle::ResolveCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeFileSystemDirectoryHandle::Name_);
  message.set_method_name("Resolve");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool NativeFileSystemDirectoryHandleStubDispatch::Accept(
    NativeFileSystemDirectoryHandle* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kNativeFileSystemDirectoryHandle_GetPermissionStatus_Name: {
      break;
    }
    case internal::kNativeFileSystemDirectoryHandle_RequestPermission_Name: {
      break;
    }
    case internal::kNativeFileSystemDirectoryHandle_GetFile_Name: {
      break;
    }
    case internal::kNativeFileSystemDirectoryHandle_GetDirectory_Name: {
      break;
    }
    case internal::kNativeFileSystemDirectoryHandle_GetEntries_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::NativeFileSystemDirectoryHandle::GetEntries",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::NativeFileSystemDirectoryHandle::GetEntries");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NativeFileSystemDirectoryHandle_GetEntries_Params_Data* params =
          reinterpret_cast<internal::NativeFileSystemDirectoryHandle_GetEntries_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<NativeFileSystemDirectoryEntriesListener> p_listener{};
      NativeFileSystemDirectoryHandle_GetEntries_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_listener =
            input_data_view.TakeListener<decltype(p_listener)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeFileSystemDirectoryHandle::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetEntries(
std::move(p_listener));
      return true;
    }
    case internal::kNativeFileSystemDirectoryHandle_RemoveEntry_Name: {
      break;
    }
    case internal::kNativeFileSystemDirectoryHandle_Resolve_Name: {
      break;
    }
    case internal::kNativeFileSystemDirectoryHandle_Transfer_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::NativeFileSystemDirectoryHandle::Transfer",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::NativeFileSystemDirectoryHandle::Transfer");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NativeFileSystemDirectoryHandle_Transfer_Params_Data* params =
          reinterpret_cast<internal::NativeFileSystemDirectoryHandle_Transfer_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::blink::mojom::NativeFileSystemTransferToken> p_token{};
      NativeFileSystemDirectoryHandle_Transfer_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_token =
            input_data_view.TakeToken<decltype(p_token)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeFileSystemDirectoryHandle::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Transfer(
std::move(p_token));
      return true;
    }
  }
  return false;
}

// static
bool NativeFileSystemDirectoryHandleStubDispatch::AcceptWithResponder(
    NativeFileSystemDirectoryHandle* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kNativeFileSystemDirectoryHandle_GetPermissionStatus_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::NativeFileSystemDirectoryHandle::GetPermissionStatus",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::NativeFileSystemDirectoryHandle::GetPermissionStatus");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NativeFileSystemDirectoryHandle_GetPermissionStatus_Params_Data* params =
          reinterpret_cast<
              internal::NativeFileSystemDirectoryHandle_GetPermissionStatus_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      bool p_writable{};
      NativeFileSystemDirectoryHandle_GetPermissionStatus_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_writable = input_data_view.writable();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeFileSystemDirectoryHandle::Name_, 0, false);
        return false;
      }
      NativeFileSystemDirectoryHandle::GetPermissionStatusCallback callback =
          NativeFileSystemDirectoryHandle_GetPermissionStatus_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetPermissionStatus(
std::move(p_writable), std::move(callback));
      return true;
    }
    case internal::kNativeFileSystemDirectoryHandle_RequestPermission_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::NativeFileSystemDirectoryHandle::RequestPermission",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::NativeFileSystemDirectoryHandle::RequestPermission");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NativeFileSystemDirectoryHandle_RequestPermission_Params_Data* params =
          reinterpret_cast<
              internal::NativeFileSystemDirectoryHandle_RequestPermission_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      bool p_writable{};
      NativeFileSystemDirectoryHandle_RequestPermission_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_writable = input_data_view.writable();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeFileSystemDirectoryHandle::Name_, 1, false);
        return false;
      }
      NativeFileSystemDirectoryHandle::RequestPermissionCallback callback =
          NativeFileSystemDirectoryHandle_RequestPermission_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestPermission(
std::move(p_writable), std::move(callback));
      return true;
    }
    case internal::kNativeFileSystemDirectoryHandle_GetFile_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::NativeFileSystemDirectoryHandle::GetFile",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::NativeFileSystemDirectoryHandle::GetFile");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NativeFileSystemDirectoryHandle_GetFile_Params_Data* params =
          reinterpret_cast<
              internal::NativeFileSystemDirectoryHandle_GetFile_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_basename{};
      bool p_create{};
      NativeFileSystemDirectoryHandle_GetFile_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadBasename(&p_basename))
        success = false;
      if (success)
        p_create = input_data_view.create();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeFileSystemDirectoryHandle::Name_, 2, false);
        return false;
      }
      NativeFileSystemDirectoryHandle::GetFileCallback callback =
          NativeFileSystemDirectoryHandle_GetFile_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetFile(
std::move(p_basename), 
std::move(p_create), std::move(callback));
      return true;
    }
    case internal::kNativeFileSystemDirectoryHandle_GetDirectory_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::NativeFileSystemDirectoryHandle::GetDirectory",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::NativeFileSystemDirectoryHandle::GetDirectory");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NativeFileSystemDirectoryHandle_GetDirectory_Params_Data* params =
          reinterpret_cast<
              internal::NativeFileSystemDirectoryHandle_GetDirectory_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_basename{};
      bool p_create{};
      NativeFileSystemDirectoryHandle_GetDirectory_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadBasename(&p_basename))
        success = false;
      if (success)
        p_create = input_data_view.create();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeFileSystemDirectoryHandle::Name_, 3, false);
        return false;
      }
      NativeFileSystemDirectoryHandle::GetDirectoryCallback callback =
          NativeFileSystemDirectoryHandle_GetDirectory_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDirectory(
std::move(p_basename), 
std::move(p_create), std::move(callback));
      return true;
    }
    case internal::kNativeFileSystemDirectoryHandle_GetEntries_Name: {
      break;
    }
    case internal::kNativeFileSystemDirectoryHandle_RemoveEntry_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::NativeFileSystemDirectoryHandle::RemoveEntry",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::NativeFileSystemDirectoryHandle::RemoveEntry");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NativeFileSystemDirectoryHandle_RemoveEntry_Params_Data* params =
          reinterpret_cast<
              internal::NativeFileSystemDirectoryHandle_RemoveEntry_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_basename{};
      bool p_recurse{};
      NativeFileSystemDirectoryHandle_RemoveEntry_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadBasename(&p_basename))
        success = false;
      if (success)
        p_recurse = input_data_view.recurse();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeFileSystemDirectoryHandle::Name_, 5, false);
        return false;
      }
      NativeFileSystemDirectoryHandle::RemoveEntryCallback callback =
          NativeFileSystemDirectoryHandle_RemoveEntry_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveEntry(
std::move(p_basename), 
std::move(p_recurse), std::move(callback));
      return true;
    }
    case internal::kNativeFileSystemDirectoryHandle_Resolve_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::NativeFileSystemDirectoryHandle::Resolve",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::NativeFileSystemDirectoryHandle::Resolve");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NativeFileSystemDirectoryHandle_Resolve_Params_Data* params =
          reinterpret_cast<
              internal::NativeFileSystemDirectoryHandle_Resolve_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<::blink::mojom::NativeFileSystemTransferToken> p_possible_child{};
      NativeFileSystemDirectoryHandle_Resolve_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_possible_child =
            input_data_view.TakePossibleChild<decltype(p_possible_child)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeFileSystemDirectoryHandle::Name_, 6, false);
        return false;
      }
      NativeFileSystemDirectoryHandle::ResolveCallback callback =
          NativeFileSystemDirectoryHandle_Resolve_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Resolve(
std::move(p_possible_child), std::move(callback));
      return true;
    }
    case internal::kNativeFileSystemDirectoryHandle_Transfer_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kNativeFileSystemDirectoryHandleValidationInfo[] = {
    {&internal::NativeFileSystemDirectoryHandle_GetPermissionStatus_Params_Data::Validate,
     &internal::NativeFileSystemDirectoryHandle_GetPermissionStatus_ResponseParams_Data::Validate},
    {&internal::NativeFileSystemDirectoryHandle_RequestPermission_Params_Data::Validate,
     &internal::NativeFileSystemDirectoryHandle_RequestPermission_ResponseParams_Data::Validate},
    {&internal::NativeFileSystemDirectoryHandle_GetFile_Params_Data::Validate,
     &internal::NativeFileSystemDirectoryHandle_GetFile_ResponseParams_Data::Validate},
    {&internal::NativeFileSystemDirectoryHandle_GetDirectory_Params_Data::Validate,
     &internal::NativeFileSystemDirectoryHandle_GetDirectory_ResponseParams_Data::Validate},
    {&internal::NativeFileSystemDirectoryHandle_GetEntries_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::NativeFileSystemDirectoryHandle_RemoveEntry_Params_Data::Validate,
     &internal::NativeFileSystemDirectoryHandle_RemoveEntry_ResponseParams_Data::Validate},
    {&internal::NativeFileSystemDirectoryHandle_Resolve_Params_Data::Validate,
     &internal::NativeFileSystemDirectoryHandle_Resolve_ResponseParams_Data::Validate},
    {&internal::NativeFileSystemDirectoryHandle_Transfer_Params_Data::Validate,
     nullptr /* no response */},
};

bool NativeFileSystemDirectoryHandleRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::NativeFileSystemDirectoryHandle::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kNativeFileSystemDirectoryHandleValidationInfo);
}

bool NativeFileSystemDirectoryHandleResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::NativeFileSystemDirectoryHandle::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kNativeFileSystemDirectoryHandleValidationInfo);
}
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::NativeFileSystemEntry::DataView, ::blink::mojom::NativeFileSystemEntryPtr>::Read(
    ::blink::mojom::NativeFileSystemEntry::DataView input,
    ::blink::mojom::NativeFileSystemEntryPtr* output) {
  bool success = true;
  ::blink::mojom::NativeFileSystemEntryPtr result(::blink::mojom::NativeFileSystemEntry::New());
  
      if (success && !input.ReadEntryHandle(&result->entry_handle))
        success = false;
      if (success && !input.ReadName(&result->name))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::blink::mojom::NativeFileSystemHandle::DataView, ::blink::mojom::NativeFileSystemHandlePtr>::Read(
    ::blink::mojom::NativeFileSystemHandle::DataView input,
    ::blink::mojom::NativeFileSystemHandlePtr* output) {
  using UnionType = ::blink::mojom::NativeFileSystemHandle;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::FILE: {
      *output = UnionType::NewFile(
          input.TakeFile<::mojo::PendingRemote<::blink::mojom::NativeFileSystemFileHandle>>());
      break;
    }
    case Tag::DIRECTORY: {
      *output = UnionType::NewDirectory(
          input.TakeDirectory<::mojo::PendingRemote<::blink::mojom::NativeFileSystemDirectoryHandle>>());
      break;
    }
    default:
      return false;
  }
  return true;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif