// third_party/blink/public/mojom/frame/frame_policy.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_POLICY_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_POLICY_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "third_party/blink/public/mojom/frame/frame_policy.mojom-shared-internal.h"
#include "services/network/public/mojom/web_sandbox_flags.mojom-shared.h"
#include "third_party/blink/public/mojom/feature_policy/feature_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/feature_policy/document_policy_feature.mojom-shared.h"
#include "third_party/blink/public/mojom/feature_policy/feature_policy_feature.mojom-shared.h"
#include "third_party/blink/public/mojom/feature_policy/policy_value.mojom-shared.h"



#include "base/component_export.h"




namespace blink {
namespace mojom {
class FramePolicyDataView;



}  // namespace mojom
}  // namespace blink

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::FramePolicyDataView> {
  using Data = ::blink::mojom::internal::FramePolicy_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink {
namespace mojom {


class FramePolicyDataView {
 public:
  FramePolicyDataView() {}

  FramePolicyDataView(
      internal::FramePolicy_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSandboxFlags(UserType* output) const {
    auto data_value = data_->sandbox_flags;
    return mojo::internal::Deserialize<::network::mojom::WebSandboxFlags>(
        data_value, output);
  }

  ::network::mojom::WebSandboxFlags sandbox_flags() const {
    return static_cast<::network::mojom::WebSandboxFlags>(data_->sandbox_flags);
  }
  inline void GetContainerPolicyDataView(
      mojo::ArrayDataView<::blink::mojom::ParsedFeaturePolicyDeclarationDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadContainerPolicy(UserType* output) {
    
    auto* pointer = data_->container_policy.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::ParsedFeaturePolicyDeclarationDataView>>(
        pointer, output, context_);
  }
  inline void GetRequiredDocumentPolicyDataView(
      mojo::MapDataView<::blink::mojom::DocumentPolicyFeature, ::blink::mojom::PolicyValueDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRequiredDocumentPolicy(UserType* output) {
    
    auto* pointer = data_->required_document_policy.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::blink::mojom::DocumentPolicyFeature, ::blink::mojom::PolicyValueDataView>>(
        pointer, output, context_);
  }
  bool allowed_to_download() const {
    return data_->allowed_to_download;
  }
  bool disallow_document_access() const {
    return data_->disallow_document_access;
  }
 private:
  internal::FramePolicy_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace blink

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::FramePolicyDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::FramePolicyDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::FramePolicy_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    mojo::internal::Serialize<::network::mojom::WebSandboxFlags>(
        Traits::sandbox_flags(input), &(*output)->sandbox_flags);
    decltype(Traits::container_policy(input)) in_container_policy = Traits::container_policy(input);
    typename decltype((*output)->container_policy)::BaseType::BufferWriter
        container_policy_writer;
    const mojo::internal::ContainerValidateParams container_policy_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ParsedFeaturePolicyDeclarationDataView>>(
        in_container_policy, buffer, &container_policy_writer, &container_policy_validate_params,
        context);
    (*output)->container_policy.Set(
        container_policy_writer.is_null() ? nullptr : container_policy_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->container_policy.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null container_policy in FramePolicy struct");
    decltype(Traits::required_document_policy(input)) in_required_document_policy = Traits::required_document_policy(input);
    typename decltype((*output)->required_document_policy)::BaseType::BufferWriter
        required_document_policy_writer;
    const mojo::internal::ContainerValidateParams required_document_policy_validate_params(
        new mojo::internal::ContainerValidateParams(0, ::blink::mojom::internal::DocumentPolicyFeature_Data::Validate), new mojo::internal::ContainerValidateParams(0, false, nullptr));
    mojo::internal::Serialize<mojo::MapDataView<::blink::mojom::DocumentPolicyFeature, ::blink::mojom::PolicyValueDataView>>(
        in_required_document_policy, buffer, &required_document_policy_writer, &required_document_policy_validate_params,
        context);
    (*output)->required_document_policy.Set(
        required_document_policy_writer.is_null() ? nullptr : required_document_policy_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->required_document_policy.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null required_document_policy in FramePolicy struct");
    (*output)->allowed_to_download = Traits::allowed_to_download(input);
    (*output)->disallow_document_access = Traits::disallow_document_access(input);
  }

  static bool Deserialize(::blink::mojom::internal::FramePolicy_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::FramePolicyDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink {
namespace mojom {

inline void FramePolicyDataView::GetContainerPolicyDataView(
    mojo::ArrayDataView<::blink::mojom::ParsedFeaturePolicyDeclarationDataView>* output) {
  auto pointer = data_->container_policy.Get();
  *output = mojo::ArrayDataView<::blink::mojom::ParsedFeaturePolicyDeclarationDataView>(pointer, context_);
}
inline void FramePolicyDataView::GetRequiredDocumentPolicyDataView(
    mojo::MapDataView<::blink::mojom::DocumentPolicyFeature, ::blink::mojom::PolicyValueDataView>* output) {
  auto pointer = data_->required_document_policy.Get();
  *output = mojo::MapDataView<::blink::mojom::DocumentPolicyFeature, ::blink::mojom::PolicyValueDataView>(pointer, context_);
}



}  // namespace mojom
}  // namespace blink

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_POLICY_MOJOM_SHARED_H_